
/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;
DROP TABLE IF EXISTS `attendance_approvals`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendance_approvals` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `attendance_id` bigint unsigned NOT NULL,
  `approved_by` bigint unsigned NOT NULL,
  `note` text COLLATE utf8mb4_unicode_ci,
  `status` enum('pending','approved','rejected') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'approved',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `attendance_approvals_attendance_id_foreign` (`attendance_id`),
  KEY `attendance_approvals_approved_by_foreign` (`approved_by`),
  CONSTRAINT `attendance_approvals_approved_by_foreign` FOREIGN KEY (`approved_by`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `attendance_approvals_attendance_id_foreign` FOREIGN KEY (`attendance_id`) REFERENCES `attendances` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `attendance_approvals` WRITE;
/*!40000 ALTER TABLE `attendance_approvals` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendance_approvals` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `attendance_overrides`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendance_overrides` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `employee_id` bigint unsigned NOT NULL,
  `date` date NOT NULL,
  `status` enum('clock-in','no-clock','not-available','holiday') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `extra_hours` decimal(5,2) NOT NULL DEFAULT '0.00',
  `notes` text COLLATE utf8mb4_unicode_ci,
  `registered_by` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `attendance_overrides_employee_id_date_unique` (`employee_id`,`date`),
  KEY `attendance_overrides_employee_id_date_index` (`employee_id`,`date`),
  KEY `attendance_overrides_registered_by_index` (`registered_by`),
  CONSTRAINT `attendance_overrides_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `attendance_overrides_registered_by_foreign` FOREIGN KEY (`registered_by`) REFERENCES `users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `attendance_overrides` WRITE;
/*!40000 ALTER TABLE `attendance_overrides` DISABLE KEYS */;
INSERT INTO `attendance_overrides` VALUES (1,2672,'2026-01-01','holiday',0.00,NULL,2694,'2025-12-03 18:45:36','2025-12-03 18:45:38',NULL),(2,3516,'2025-11-01','clock-in',0.00,NULL,3516,'2025-12-03 18:51:04','2025-12-03 18:51:04',NULL),(3,2672,'2025-12-03','no-clock',0.00,NULL,NULL,'2025-12-04 01:00:05','2025-12-04 01:00:05',NULL),(4,13,'2025-12-03','no-clock',0.00,NULL,NULL,'2025-12-04 01:00:05','2025-12-04 01:00:05',NULL),(5,679,'2025-12-03','no-clock',0.00,NULL,NULL,'2025-12-04 01:00:05','2025-12-04 01:00:05',NULL),(6,1571,'2025-12-03','no-clock',0.00,NULL,NULL,'2025-12-04 01:00:05','2025-12-04 01:00:05',NULL),(7,1584,'2025-12-03','no-clock',0.00,NULL,NULL,'2025-12-04 01:00:05','2025-12-04 01:00:05',NULL),(8,1711,'2025-12-03','no-clock',0.00,NULL,NULL,'2025-12-04 01:00:05','2025-12-04 01:00:05',NULL),(9,1801,'2025-12-03','no-clock',0.00,NULL,NULL,'2025-12-04 01:00:05','2025-12-04 01:00:05',NULL),(10,2462,'2025-12-03','no-clock',0.00,NULL,NULL,'2025-12-04 01:00:05','2025-12-04 01:00:05',NULL),(11,2464,'2025-12-03','no-clock',0.00,NULL,NULL,'2025-12-04 01:00:05','2025-12-04 01:00:05',NULL),(12,2694,'2025-12-03','no-clock',0.00,NULL,NULL,'2025-12-04 01:00:05','2025-12-04 01:00:05',NULL),(13,3304,'2025-12-03','no-clock',0.00,NULL,NULL,'2025-12-04 01:00:05','2025-12-04 01:00:05',NULL),(14,3306,'2025-12-03','no-clock',0.00,NULL,NULL,'2025-12-04 01:00:05','2025-12-04 01:00:05',NULL),(15,3516,'2025-12-03','no-clock',0.00,NULL,NULL,'2025-12-04 01:00:05','2025-12-04 01:00:05',NULL),(16,3822,'2025-12-03','no-clock',0.00,NULL,NULL,'2025-12-04 01:00:05','2025-12-04 01:00:05',NULL),(17,1556,'2025-12-03','no-clock',0.00,NULL,NULL,'2025-12-04 01:00:05','2025-12-04 01:00:05',NULL),(18,2226,'2025-12-03','no-clock',0.00,NULL,NULL,'2025-12-04 01:00:05','2025-12-04 01:00:05',NULL),(19,2259,'2025-12-03','no-clock',0.00,NULL,NULL,'2025-12-04 01:00:05','2025-12-04 01:00:05',NULL),(20,2944,'2025-12-03','no-clock',0.00,NULL,NULL,'2025-12-04 01:00:05','2025-12-04 01:00:05',NULL),(21,3214,'2025-12-03','no-clock',0.00,NULL,NULL,'2025-12-04 01:00:05','2025-12-04 01:00:05',NULL),(22,3226,'2025-12-03','no-clock',0.00,NULL,NULL,'2025-12-04 01:00:05','2025-12-04 01:00:05',NULL),(23,2065,'2025-12-03','no-clock',0.00,NULL,NULL,'2025-12-04 01:00:05','2025-12-04 01:00:05',NULL);
/*!40000 ALTER TABLE `attendance_overrides` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `attendances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendances` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `clock_in_time` datetime NOT NULL,
  `clock_out_time` datetime DEFAULT NULL,
  `clock_in_ip` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  `clock_out_ip` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `attendance_status` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `total_hours` int DEFAULT NULL,
  `total_minutes` int DEFAULT NULL,
  `clock_in_image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clock_out_image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `notes` text COLLATE utf8mb4_unicode_ci,
  `requirement_id` bigint unsigned DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `attendances_requirement_id_clock_in_time_index` (`requirement_id`,`clock_in_time`),
  KEY `attendances_attendance_status_index` (`attendance_status`),
  KEY `attendances_user_id_clock_in_time_index` (`clock_in_time`),
  CONSTRAINT `attendances_requirement_id_foreign` FOREIGN KEY (`requirement_id`) REFERENCES `requirements` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=25233 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `attendances` WRITE;
/*!40000 ALTER TABLE `attendances` DISABLE KEYS */;
INSERT INTO `attendances` VALUES (9,'2019-09-17 16:28:04',NULL,'181.58.156.230','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2019-09-17 23:28:04','2019-09-17 23:28:04'),(10,'2019-09-19 13:55:43',NULL,'181.136.227.2','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2019-09-19 20:55:43','2019-09-19 20:55:43'),(11,'2022-04-13 00:55:57',NULL,'190.251.214.128','','pending',NULL,NULL,'attendances/372/clock_in.png',NULL,NULL,NULL,NULL,'2022-04-12 21:27:28','2022-04-12 21:27:28'),(12,'2022-09-30 16:52:06','2022-09-30 16:54:39','174.194.198.101','174.194.198.101','closed',0,2,'attendances/1713/clock_in.png','attendances/1713/clock_out.png',NULL,NULL,NULL,'2022-09-30 20:52:22','2022-09-30 20:54:51'),(13,'2022-09-30 16:51:39',NULL,'181.59.2.42','','pending',NULL,NULL,'attendances/1713/clock_in.png',NULL,NULL,NULL,NULL,'2022-09-30 20:54:05','2022-09-30 20:54:05'),(14,'2022-09-30 16:51:39',NULL,'181.59.2.42','','pending',NULL,NULL,'attendances/1713/clock_in.png',NULL,NULL,NULL,NULL,'2022-09-30 20:54:38','2022-09-30 20:54:38'),(15,'2022-09-30 23:43:03',NULL,'181.59.2.42','','pending',NULL,NULL,'attendances/1713/clock_in.png',NULL,NULL,NULL,NULL,'2022-10-01 03:43:09','2022-10-01 03:43:09'),(16,'2022-10-10 16:13:34','2022-10-10 16:22:21','179.1.129.37','179.1.129.37','closed',0,8,'attendances/1719/clock_in.png','attendances/1719/clock_out.png',NULL,NULL,NULL,'2022-10-10 20:22:03','2022-10-10 20:24:03'),(17,'2022-10-10 16:24:11','2022-10-10 16:24:39','179.1.129.37','179.1.129.37','closed',0,0,'attendances/1719/clock_in.png','attendances/1719/clock_out.png',NULL,NULL,NULL,'2022-10-10 20:24:34','2022-10-10 20:24:58'),(18,'2022-10-11 14:49:14','2022-10-11 14:50:18','174.194.136.25','174.194.136.25','closed',0,1,'attendances/1719/clock_in.png','attendances/1719/clock_out.png',NULL,NULL,NULL,'2022-10-11 18:50:06','2022-10-11 18:50:45'),(19,'2022-11-07 14:10:32','2023-01-09 12:23:16','181.129.210.131','179.13.4.114','closed',46,2772,'attendances/1803/clock_in.png','attendances/1803/clock_out.png',NULL,NULL,NULL,'2022-11-07 19:10:58','2023-01-09 17:24:49'),(20,'2022-12-02 15:33:03',NULL,'174.194.194.80','','pending',NULL,NULL,'attendances/1703/clock_in.png',NULL,NULL,NULL,NULL,'2022-12-02 20:33:10','2022-12-02 20:33:10'),(23,'2022-12-02 15:33:03',NULL,'174.194.194.80','','pending',NULL,NULL,'attendances/1703/clock_in.png',NULL,NULL,NULL,NULL,'2022-12-02 20:33:18','2022-12-02 20:33:18'),(24,'2022-12-12 15:39:47','2023-06-17 06:42:48','179.1.87.67','186.102.83.9','closed',111,6663,'attendances/1584/clock_in.png','attendances/1584/clock_out.png',NULL,NULL,NULL,'2022-12-12 20:39:58','2023-06-17 10:44:08'),(25,'2023-01-09 12:25:38','2023-01-09 12:26:49','179.13.4.114','179.13.4.114','closed',0,1,'attendances/1803/clock_in.png','attendances/1803/clock_out.png',NULL,NULL,NULL,'2023-01-09 17:26:47','2023-01-09 17:27:06'),(44,'2023-01-19 13:26:02','2023-01-19 13:27:02','99.46.136.238','99.46.136.238','closed',0,1,'attendances/679/clock_in.png','attendances/679/clock_out.png',NULL,NULL,NULL,'2023-01-19 18:26:59','2023-01-19 18:29:54'),(45,'2023-01-19 13:36:40','2023-01-19 14:15:53','99.46.136.238','99.46.136.238','closed',0,39,'attendances/13/clock_in.png','attendances/13/clock_out.png',NULL,NULL,NULL,'2023-01-19 19:15:51','2023-01-19 19:16:12'),(46,'2023-01-19 13:36:40',NULL,'99.46.136.238','','pending',NULL,NULL,'attendances/13/clock_in.png',NULL,NULL,NULL,NULL,'2023-01-19 19:15:51','2023-01-19 19:15:51'),(47,'2023-01-19 14:16:15','2023-01-19 14:16:31','99.46.136.238','99.46.136.238','closed',0,0,'attendances/13/clock_in.png','attendances/13/clock_out.png',NULL,NULL,NULL,'2023-01-19 19:16:29','2023-01-19 19:16:39'),(48,'2023-01-19 14:16:41','2023-01-19 14:17:49','99.46.136.238','99.46.136.238','closed',0,1,'attendances/13/clock_in.png','attendances/13/clock_out.png',NULL,NULL,NULL,'2023-01-19 19:17:47','2023-01-19 19:18:02'),(52,'2023-05-23 14:07:04','2023-05-28 09:28:48','174.194.192.172','12.249.250.150','closed',115,6921,'attendances/974/clock_in.png','attendances/974/clock_out.png',NULL,NULL,NULL,'2023-05-23 18:09:07','2023-05-28 13:37:52'),(53,'2023-05-23 14:07:04',NULL,'174.194.192.172','','pending',NULL,NULL,'attendances/974/clock_in.png',NULL,NULL,NULL,NULL,'2023-05-23 18:09:08','2023-05-23 18:09:08'),(54,'2023-05-23 14:07:04',NULL,'174.194.192.172','','pending',NULL,NULL,'attendances/974/clock_in.png',NULL,NULL,NULL,NULL,'2023-05-23 18:09:08','2023-05-23 18:09:08'),(55,'2023-05-23 14:09:11','2023-05-23 14:11:54','174.194.192.172','174.194.192.172','closed',0,2,'attendances/1588/clock_in.png','attendances/1588/clock_out.png',NULL,NULL,NULL,'2023-05-23 18:11:51','2023-05-23 18:12:43'),(56,'2023-05-23 14:09:11',NULL,'174.194.192.172','','pending',NULL,NULL,'attendances/1588/clock_in.png',NULL,NULL,NULL,NULL,'2023-05-23 18:11:51','2023-05-23 18:11:51'),(61,'2023-06-03 10:21:33',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1588/clock_in.png',NULL,NULL,34285,NULL,'2023-06-03 14:22:16','2023-06-03 14:22:16'),(62,'2023-06-03 10:21:33','2023-06-09 05:52:20','12.249.250.150','12.249.250.150','closed',139,8370,'attendances/1588/clock_in.png','attendances/1588/clock_out.png',NULL,34285,NULL,'2023-06-03 14:22:16','2023-06-09 09:52:43'),(64,'2023-06-03 18:24:55','2023-06-10 14:45:37','12.249.250.150','12.249.250.150','closed',164,9860,'attendances/1637/clock_in.png','attendances/1637/clock_out.png',NULL,34286,NULL,'2023-06-03 22:30:23','2023-06-10 18:45:59'),(65,'2023-06-09 05:52:45','2023-06-10 14:45:16','12.249.250.150','12.249.250.150','closed',32,1972,'attendances/1568/clock_in.png','attendances/1568/clock_out.png',NULL,NULL,NULL,'2023-06-09 09:53:31','2023-06-10 18:45:27'),(66,'2023-06-09 05:52:45',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1568/clock_in.png',NULL,NULL,NULL,NULL,'2023-06-09 09:53:31','2023-06-09 09:53:31'),(67,'2023-06-10 14:46:02','2023-06-16 08:04:00','12.249.250.150','12.249.250.150','closed',137,8237,'attendances/1588/clock_in.png','attendances/1588/clock_out.png',NULL,NULL,NULL,'2023-06-10 18:46:10','2023-06-16 12:04:14'),(68,'2023-06-10 14:46:02',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1588/clock_in.png',NULL,NULL,NULL,NULL,'2023-06-10 18:46:10','2023-06-10 18:46:10'),(72,'2023-06-16 05:50:48','2023-06-16 15:41:25','12.249.250.150','12.249.250.150','closed',9,590,'attendances/1568/clock_in.png','attendances/1568/clock_out.png',NULL,NULL,NULL,'2023-06-16 09:57:31','2023-06-16 19:42:20'),(73,'2023-06-16 08:04:17','2023-06-16 15:30:22','12.249.250.150','12.249.250.150','closed',7,446,'attendances/1588/clock_in.png','attendances/1588/clock_out.png',NULL,NULL,NULL,'2023-06-16 12:06:14','2023-06-16 19:41:22'),(74,'2023-06-16 15:29:30','2023-06-19 05:57:41','12.249.250.150','12.249.250.150','closed',62,3748,'attendances/1724/clock_in.png','attendances/1724/clock_out.png',NULL,NULL,NULL,'2023-06-16 19:30:19','2023-06-19 10:56:47'),(75,'2023-06-16 15:42:23','2023-06-20 05:55:00','12.249.250.150','12.249.250.150','closed',86,5172,'attendances/1375/clock_in.png','attendances/1375/clock_out.png',NULL,NULL,NULL,'2023-06-16 20:34:37','2023-06-20 09:55:24'),(78,'2023-06-17 06:45:30','2023-06-17 06:48:57','186.102.83.9','186.102.83.9','closed',0,3,'attendances/1584/clock_in.png','attendances/1584/clock_out.png',NULL,NULL,NULL,'2023-06-17 10:48:55','2023-06-17 10:52:25'),(79,'2023-06-17 06:55:21','2023-06-17 07:11:26','186.102.83.9','186.102.83.9','closed',0,16,'attendances/1584/clock_in.png','attendances/1584/clock_out.png',NULL,NULL,NULL,'2023-06-17 10:56:12','2023-06-17 11:11:48'),(80,'2023-06-19 05:47:43','2023-06-20 05:54:34','12.249.250.150','12.249.250.150','closed',24,1446,'attendances/1568/clock_in.png','attendances/1568/clock_out.png',NULL,NULL,NULL,'2023-06-19 09:57:00','2023-06-20 09:54:58'),(81,'2023-06-19 05:57:02','2023-06-20 05:30:15','12.249.250.150','12.249.250.150','closed',23,1413,'attendances/1588/clock_in.png','attendances/1588/clock_out.png',NULL,NULL,NULL,'2023-06-19 09:57:14','2023-06-20 09:53:41'),(82,'2023-06-19 05:57:17','2023-06-23 04:54:14','12.249.250.150','12.249.250.150','closed',94,5696,'attendances/1637/clock_in.png','attendances/1637/1687521254 clock_out.png',NULL,35368,NULL,'2023-06-19 09:57:38','2023-06-23 08:54:14'),(83,'2023-06-19 06:56:50','2023-06-20 06:56:43','12.249.250.150','12.249.250.150','closed',23,1439,'attendances/1728/clock_in.png','attendances/1728/clock_out.png',NULL,NULL,NULL,'2023-06-19 10:58:13','2023-06-20 10:57:01'),(84,'2023-06-19 06:58:16','2023-06-20 06:09:36','12.249.250.150','12.249.250.150','closed',23,1391,'attendances/1454/clock_in.png','attendances/1454/clock_out.png',NULL,NULL,NULL,'2023-06-19 10:58:38','2023-06-20 10:53:49'),(85,'2023-06-19 06:58:41','2023-06-20 06:53:51','12.249.250.150','12.249.250.150','closed',23,1435,'attendances/1564/clock_in.png','attendances/1564/clock_out.png',NULL,NULL,NULL,'2023-06-19 11:00:53','2023-06-20 10:54:40'),(86,'2023-06-19 07:00:56','2023-06-20 06:57:04','12.249.250.150','12.249.250.150','closed',23,1436,'attendances/1958/clock_in.png','attendances/1958/clock_out.png',NULL,35385,NULL,'2023-06-19 11:02:11','2023-06-20 10:57:50'),(87,'2023-06-19 07:02:14','2023-06-20 06:57:52','12.249.250.150','12.249.250.150','closed',23,1435,'attendances/1858/clock_in.png','attendances/1858/clock_out.png',NULL,35393,NULL,'2023-06-19 11:07:31','2023-06-20 10:58:04'),(88,'2023-06-19 07:07:33','2023-06-19 12:34:07','12.249.250.150','12.249.250.150','closed',5,326,'attendances/1869/clock_in.png','attendances/1869/clock_out.png',NULL,NULL,NULL,'2023-06-19 12:01:28','2023-06-19 16:34:25'),(89,'2023-06-19 08:01:30','2023-06-19 12:34:28','12.249.250.150','12.249.250.150','closed',4,272,'attendances/1891/clock_in.png','attendances/1891/clock_out.png',NULL,35416,NULL,'2023-06-19 12:01:43','2023-06-19 16:34:39'),(90,'2023-06-19 08:01:46','2023-06-19 10:48:42','12.249.250.150','12.249.250.150','closed',2,166,'attendances/1492/clock_in.png','attendances/1492/clock_out.png',NULL,35418,NULL,'2023-06-19 12:12:20','2023-06-19 16:34:04'),(91,'2023-06-19 12:34:41','2023-06-20 08:01:41','12.249.250.150','12.249.250.150','closed',19,1167,'attendances/1492/clock_in.png','attendances/1492/clock_out.png',NULL,35418,NULL,'2023-06-19 17:03:18','2023-06-20 12:17:18'),(92,'2023-06-19 13:03:20','2023-06-19 16:35:20','12.249.250.150','12.249.250.150','closed',3,212,'attendances/1869/clock_in.png','attendances/1869/clock_out.png',NULL,35413,NULL,'2023-06-19 17:04:22','2023-06-19 20:35:33'),(93,'2023-06-19 13:03:20','2023-06-19 16:35:35','12.249.250.150','12.249.250.150','closed',3,212,'attendances/1891/clock_in.png','attendances/1891/clock_out.png',NULL,35416,NULL,'2023-06-19 17:04:38','2023-06-19 20:35:45'),(94,'2023-06-20 05:55:26','2023-06-20 16:30:22','12.249.250.150','12.249.250.150','closed',10,634,'attendances/1934/clock_in.png','attendances/1934/clock_out.png',NULL,NULL,NULL,'2023-06-20 09:56:09','2023-06-20 20:30:51'),(95,'2023-06-20 05:56:11',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1376/clock_in.png',NULL,NULL,NULL,NULL,'2023-06-20 09:56:28','2023-06-20 09:56:28'),(96,'2023-06-20 06:54:42','2023-06-20 16:29:28','12.249.250.150','12.249.250.150','closed',9,574,'attendances/1462/clock_in.png','attendances/1462/clock_out.png',NULL,NULL,NULL,'2023-06-20 10:55:56','2023-06-20 20:30:19'),(97,'2023-06-20 06:55:58','2023-06-20 15:54:55','12.249.250.150','12.249.250.150','closed',8,538,'attendances/1724/clock_in.png','attendances/1724/clock_out.png',NULL,NULL,NULL,'2023-06-20 10:56:41','2023-06-20 19:55:08'),(98,'2023-06-20 06:58:07','2023-06-21 06:57:38','12.249.250.150','12.249.250.150','closed',23,1439,'attendances/1898/clock_in.png','attendances/1898/clock_out.png',NULL,NULL,NULL,'2023-06-20 10:59:32','2023-06-21 10:58:01'),(99,'2023-06-20 06:59:34','2023-06-21 06:58:21','12.249.250.150','12.249.250.150','closed',23,1438,'attendances/1948/clock_in.png','attendances/1948/clock_out.png',NULL,NULL,NULL,'2023-06-20 11:02:33','2023-06-21 10:59:48'),(100,'2023-06-20 07:02:36','2023-06-20 16:07:52','12.249.250.150','12.249.250.150','closed',9,545,'attendances/1888/clock_in.png','attendances/1888/clock_out.png',NULL,35473,NULL,'2023-06-20 11:04:40','2023-06-20 20:11:05'),(101,'2023-06-20 07:04:42','2023-06-20 12:35:58','12.249.250.150','12.249.250.150','closed',5,331,'attendances/1970/clock_in.png','attendances/1970/clock_out.png',NULL,NULL,NULL,'2023-06-20 11:56:39','2023-06-20 16:36:10'),(102,'2023-06-20 07:56:41','2023-06-20 13:04:48','12.249.250.150','12.249.250.150','closed',5,308,'attendances/1869/clock_in.png','attendances/1869/clock_out.png',NULL,NULL,NULL,'2023-06-20 12:01:39','2023-06-20 17:05:42'),(103,'2023-06-20 10:30:26',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1375/clock_in.png',NULL,NULL,35463,NULL,'2023-06-20 14:30:39','2023-06-20 14:30:39'),(104,'2023-06-20 12:35:31','2023-06-20 13:05:44','12.249.250.150','12.249.250.150','closed',0,30,'attendances/1891/clock_in.png','attendances/1891/clock_out.png',NULL,35477,NULL,'2023-06-20 16:35:56','2023-06-20 17:05:55'),(105,'2023-06-20 12:36:12','2023-06-20 12:36:30','12.249.250.150','12.249.250.150','closed',0,0,'attendances/1492/clock_in.png','attendances/1492/clock_out.png',NULL,35479,NULL,'2023-06-20 16:36:27','2023-06-20 17:04:46'),(106,'2023-06-20 15:55:10','2023-06-22 17:23:36','12.249.250.150','12.249.250.150','closed',49,2968,'attendances/1728/clock_in.png','attendances/1728/1687479816 clock_out.png',NULL,NULL,NULL,'2023-06-20 19:55:22','2023-06-22 21:23:36'),(107,'2023-06-20 15:55:25','2023-06-21 05:56:21','12.249.250.150','12.249.250.150','closed',14,840,'attendances/1568/clock_in.png','attendances/1568/clock_out.png',NULL,NULL,NULL,'2023-06-20 20:05:29','2023-06-21 09:56:37'),(108,'2023-06-20 16:05:31','2023-06-21 05:56:04','12.249.250.150','12.249.250.150','closed',13,830,'attendances/1588/clock_in.png','attendances/1588/clock_out.png',NULL,NULL,NULL,'2023-06-20 20:07:50','2023-06-21 09:56:18'),(109,'2023-06-20 16:11:07','2023-06-21 08:01:50','12.249.250.150','12.249.250.150','closed',15,950,'attendances/1492/clock_in.png','attendances/1492/clock_out.png',NULL,35479,NULL,'2023-06-20 20:29:26','2023-06-21 12:07:31'),(110,'2023-06-20 16:30:54','2023-06-21 07:08:19','12.249.250.150','12.249.250.150','closed',14,877,'attendances/1970/clock_in.png','attendances/1970/clock_out.png',NULL,NULL,NULL,'2023-06-20 20:32:00','2023-06-21 11:56:53'),(111,'2023-06-20 16:32:02','2023-06-21 07:56:55','12.249.250.150','12.249.250.150','closed',15,924,'attendances/1869/clock_in.png','attendances/1869/clock_out.png',NULL,NULL,NULL,'2023-06-20 20:36:45','2023-06-21 12:01:48'),(112,'2023-06-20 16:36:48','2023-06-21 08:07:34','12.249.250.150','12.249.250.150','closed',15,930,'attendances/1891/clock_in.png','attendances/1891/clock_out.png',NULL,NULL,NULL,'2023-06-20 20:37:02','2023-06-21 12:08:55'),(113,'2023-06-20 16:37:04','2023-06-21 06:58:03','12.249.250.150','12.249.250.150','closed',14,860,'attendances/1564/clock_in.png','attendances/1564/clock_out.png',NULL,NULL,NULL,'2023-06-20 21:17:00','2023-06-21 10:58:18'),(114,'2023-06-20 17:17:03','2023-06-21 05:56:59','12.249.250.150','12.249.250.150','closed',12,759,'attendances/1454/clock_in.png','attendances/1454/clock_out.png',NULL,NULL,NULL,'2023-06-20 21:17:21','2023-06-21 10:56:36'),(115,'2023-06-21 05:56:40','2023-06-21 16:32:58','12.249.250.150','12.249.250.150','closed',10,636,'attendances/1934/1687352216 clock_in.png','attendances/1934/1687390378 clock_out.png',NULL,NULL,NULL,'2023-06-21 09:56:56','2023-06-21 20:32:58'),(116,'2023-06-21 06:56:38','2023-06-21 15:45:42','12.249.250.150','12.249.250.150','closed',8,529,'attendances/1888/1687355840 clock_in.png','attendances/1888/1687388163 clock_out.png',NULL,NULL,NULL,'2023-06-21 10:57:20','2023-06-21 19:56:03'),(117,'2023-06-21 06:57:23','2023-06-21 13:56:29','12.249.250.150','12.249.250.150','closed',6,419,'attendances/1958/1687355856 clock_in.png','attendances/1958/1687386782 clock_out.png',NULL,NULL,NULL,'2023-06-21 10:57:36','2023-06-21 19:33:02'),(118,'2023-06-21 06:59:50','2023-06-21 16:36:24','12.249.250.150','12.249.250.150','closed',9,576,'attendances/1462/1687356211 clock_in.png','attendances/1462/1687390584 clock_out.png',NULL,NULL,NULL,'2023-06-21 11:03:31','2023-06-21 20:36:24'),(119,'2023-06-21 07:03:34','2023-06-21 15:33:05','12.249.250.150','12.249.250.150','closed',8,509,'attendances/1858/1687356496 clock_in.png','attendances/1858/1687386827 clock_out.png',NULL,35515,NULL,'2023-06-21 11:08:16','2023-06-21 19:33:47'),(120,'2023-06-21 08:12:03','2023-06-22 16:56:51','12.249.250.150','12.249.250.150','closed',32,1964,'attendances/1636/1687361571 clock_in.png','attendances/1636/1687478211 clock_out.png',NULL,NULL,NULL,'2023-06-21 12:32:51','2023-06-22 20:56:51'),(121,'2023-06-21 13:54:54',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1494/1687380986 clock_in.png',NULL,NULL,35507,NULL,'2023-06-21 17:56:26','2023-06-21 17:56:26'),(123,'2023-06-21 13:59:55','2023-06-22 15:57:25','12.249.250.150','12.249.250.150','closed',25,1557,'attendances/1898/1687386798 clock_in.png','attendances/1898/1687474645 clock_out.png',NULL,35508,NULL,'2023-06-21 19:33:18','2023-06-22 19:57:25'),(124,'2023-06-21 15:33:21',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1948/1687387402 clock_in.png',NULL,NULL,NULL,NULL,'2023-06-21 19:43:22','2023-06-21 19:43:22'),(125,'2023-06-21 15:43:24','2023-06-23 04:53:46','12.249.250.150','12.249.250.150','closed',37,2230,'attendances/1588/1687387539 clock_in.png','attendances/1588/1687521226 clock_out.png',NULL,NULL,NULL,'2023-06-21 19:45:39','2023-06-23 08:53:46'),(126,'2023-06-21 15:33:50','2023-06-23 04:54:01','12.249.250.150','12.249.250.150','closed',37,2240,'attendances/1568/1687387546 clock_in.png','attendances/1568/1687521241 clock_out.png',NULL,NULL,NULL,'2023-06-21 19:45:46','2023-06-23 08:54:01'),(128,'2023-06-21 16:31:27','2023-06-22 08:13:05','12.249.250.150','12.249.250.150','closed',15,941,'attendances/1492/1687390287 clock_in.png','attendances/1492/1687446785 clock_out.png',NULL,NULL,NULL,'2023-06-21 20:31:27','2023-06-22 12:13:05'),(129,'2023-06-21 16:34:47',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1970/1687390487 clock_in.png',NULL,NULL,NULL,NULL,'2023-06-21 20:34:47','2023-06-21 20:34:47'),(130,'2023-06-21 16:39:43',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1869/1687390783 clock_in.png',NULL,NULL,NULL,NULL,'2023-06-21 20:39:43','2023-06-21 20:39:43'),(131,'2023-06-21 16:39:53',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1891/1687390793 clock_in.png',NULL,NULL,NULL,NULL,'2023-06-21 20:39:53','2023-06-21 20:39:53'),(132,'2023-06-21 17:19:42','2023-06-22 17:33:40','12.249.250.150','12.249.250.150','closed',24,1453,'attendances/1454/1687393182 clock_in.png','attendances/1454/1687480420 clock_out.png',NULL,NULL,NULL,'2023-06-21 21:19:42','2023-06-22 21:33:40'),(133,'2023-06-21 17:19:42','2023-06-22 17:33:19','12.249.250.150','12.249.250.150','closed',24,1453,'attendances/1564/1687393182 clock_in.png','attendances/1564/1687480399 clock_out.png',NULL,NULL,NULL,'2023-06-21 21:19:42','2023-06-22 21:33:19'),(134,'2023-06-22 12:34:35','2023-06-22 13:03:57','12.249.250.150','12.249.250.150','closed',0,29,'attendances/1492/1687462475 clock_in.png','attendances/1492/1687464237 clock_out.png',NULL,35609,NULL,'2023-06-22 16:34:35','2023-06-22 17:03:57'),(135,'2023-06-22 16:09:34',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1462/1687475374 clock_in.png',NULL,NULL,NULL,NULL,'2023-06-22 20:09:34','2023-06-22 20:09:34'),(136,'2023-06-22 16:29:32',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1492/1687476572 clock_in.png',NULL,NULL,35609,NULL,'2023-06-22 20:29:33','2023-06-22 20:29:33'),(137,'2023-06-22 17:23:20',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1724/1687479800 clock_in.png',NULL,NULL,NULL,NULL,'2023-06-22 21:23:20','2023-06-22 21:23:20'),(138,'2023-06-23 16:06:51',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1462/1687561611 clock_in.png',NULL,NULL,NULL,NULL,'2023-06-23 20:06:51','2023-06-23 20:06:51'),(139,'2023-06-23 16:19:37','2023-06-23 16:20:13','12.249.250.150','12.249.250.150','closed',0,0,'attendances/1637/1687562377 clock_in.png','attendances/1637/1687562413 clock_out.png',NULL,NULL,NULL,'2023-06-23 20:19:37','2023-06-23 20:20:13'),(140,'2023-06-23 16:32:40',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1970/1687563160 clock_in.png',NULL,NULL,NULL,NULL,'2023-06-23 20:32:40','2023-06-23 20:32:40'),(141,'2023-06-23 16:33:31',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1891/1687563211 clock_in.png',NULL,NULL,NULL,NULL,'2023-06-23 20:33:31','2023-06-23 20:33:31'),(144,'2023-06-24 12:04:43','2023-06-24 12:05:37','191.152.189.37','191.152.189.37','closed',0,0,'attendances/1556/1687633483 clock_in.png','attendances/1556/1687633537 clock_out.png',NULL,NULL,NULL,'2023-06-24 16:04:43','2023-06-24 16:05:37'),(145,'2023-06-24 14:36:30',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1724/1687642590 clock_in.png',NULL,NULL,NULL,NULL,'2023-06-24 18:36:30','2023-06-24 18:36:30'),(146,'2023-06-24 14:37:07',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1728/1687642627 clock_in.png',NULL,NULL,NULL,NULL,'2023-06-24 18:37:07','2023-06-24 18:37:07'),(147,'2023-06-24 14:37:37',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1454/1687642657 clock_in.png',NULL,NULL,NULL,NULL,'2023-06-24 18:37:37','2023-06-24 18:37:37'),(148,'2023-06-24 15:41:59',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1564/1687646519 clock_in.png',NULL,NULL,NULL,NULL,'2023-06-24 19:41:59','2023-06-24 19:41:59'),(149,'2023-06-26 05:58:31','2023-06-26 16:01:03','12.249.250.150','12.249.250.150','closed',10,602,'attendances/1568/1687784311 clock_in.png','attendances/1568/1687820463 clock_out.png',NULL,35749,NULL,'2023-06-26 09:58:31','2023-06-26 20:01:03'),(150,'2023-06-26 05:59:08','2023-06-26 16:36:05','12.249.250.150','12.249.250.150','closed',10,636,'attendances/1561/1687784348 clock_in.png','attendances/1561/1687822565 clock_out.png',NULL,NULL,NULL,'2023-06-26 09:59:08','2023-06-26 20:36:05'),(151,'2023-06-26 05:59:22',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1728/1687784362 clock_in.png',NULL,NULL,NULL,NULL,'2023-06-26 09:59:22','2023-06-26 09:59:22'),(152,'2023-06-26 05:59:35','2023-06-26 16:08:22','12.249.250.150','12.249.250.150','closed',10,608,'attendances/1724/1687784375 clock_in.png','attendances/1724/1687820902 clock_out.png',NULL,NULL,NULL,'2023-06-26 09:59:35','2023-06-26 20:08:22'),(153,'2023-06-26 06:14:43','2023-06-26 16:07:53','12.249.250.150','12.249.250.150','closed',9,593,'attendances/1454/1687785283 clock_in.png','attendances/1454/1687820873 clock_out.png',NULL,NULL,NULL,'2023-06-26 10:14:43','2023-06-26 20:07:53'),(154,'2023-06-26 06:58:57','2023-06-26 15:36:40','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1958/1687787937 clock_in.png','attendances/1958/1687819000 clock_out.png',NULL,NULL,NULL,'2023-06-26 10:58:57','2023-06-26 19:36:40'),(155,'2023-06-26 06:59:43','2023-06-26 15:45:47','12.249.250.150','12.249.250.150','closed',8,526,'attendances/1636/1687787983 clock_in.png','attendances/1636/1687819547 clock_out.png',NULL,NULL,NULL,'2023-06-26 10:59:43','2023-06-26 19:45:47'),(156,'2023-06-26 07:03:19','2023-06-26 15:33:55','12.249.250.150','12.249.250.150','closed',8,510,'attendances/1898/1687788199 clock_in.png','attendances/1898/1687818835 clock_out.png',NULL,35767,NULL,'2023-06-26 11:03:19','2023-06-26 19:33:55'),(157,'2023-06-26 07:04:37','2023-06-26 15:37:33','12.249.250.150','12.249.250.150','closed',8,512,'attendances/1888/1687788277 clock_in.png','attendances/1888/1687819053 clock_out.png',NULL,35796,NULL,'2023-06-26 11:04:37','2023-06-26 19:37:33'),(158,'2023-06-26 07:58:19','2023-06-26 16:32:30','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1492/1687791499 clock_in.png','attendances/1492/1687822350 clock_out.png',NULL,NULL,NULL,'2023-06-26 11:58:19','2023-06-26 20:32:30'),(159,'2023-06-26 08:00:45','2023-06-26 16:35:14','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1869/1687791645 clock_in.png','attendances/1869/1687822514 clock_out.png',NULL,35797,NULL,'2023-06-26 12:00:45','2023-06-26 20:35:14'),(160,'2023-06-26 15:37:12',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1462/1687819032 clock_in.png',NULL,NULL,NULL,NULL,'2023-06-26 19:37:12','2023-06-26 19:37:12'),(161,'2023-06-26 16:01:20','2023-06-26 16:02:45','12.249.250.150','12.249.250.150','closed',0,1,'attendances/1568/1687820480 clock_in.png','attendances/1568/1687820565 clock_out.png',NULL,NULL,NULL,'2023-06-26 20:01:20','2023-06-26 20:02:45'),(162,'2023-06-26 16:34:58',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1970/1687822498 clock_in.png',NULL,NULL,NULL,NULL,'2023-06-26 20:34:58','2023-06-26 20:34:58'),(163,'2023-06-26 16:36:34',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1375/1687822594 clock_in.png',NULL,NULL,NULL,NULL,'2023-06-26 20:36:34','2023-06-26 20:36:34'),(164,'2023-06-26 16:36:55',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1376/1687822615 clock_in.png',NULL,NULL,NULL,NULL,'2023-06-26 20:36:55','2023-06-26 20:36:55'),(166,'2023-06-27 05:53:51',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1588/1687870431 clock_in.png',NULL,NULL,NULL,NULL,'2023-06-27 09:53:51','2023-06-27 09:53:51'),(167,'2023-06-27 05:54:09',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1637/1687870449 clock_in.png',NULL,NULL,NULL,NULL,'2023-06-27 09:54:09','2023-06-27 09:54:09'),(168,'2023-06-27 05:58:49',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1568/1687870729 clock_in.png',NULL,NULL,NULL,NULL,'2023-06-27 09:58:49','2023-06-27 09:58:49'),(169,'2023-06-27 06:53:57',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1724/1687874037 clock_in.png',NULL,NULL,NULL,NULL,'2023-06-27 10:53:57','2023-06-27 10:53:57'),(170,'2023-06-27 06:55:02',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1728/1687874102 clock_in.png',NULL,NULL,NULL,NULL,'2023-06-27 10:55:02','2023-06-27 10:55:02'),(171,'2023-06-27 06:56:38',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1858/1687874198 clock_in.png',NULL,NULL,NULL,NULL,'2023-06-27 10:56:38','2023-06-27 10:56:38'),(172,'2023-06-27 06:58:12',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1454/1687874292 clock_in.png',NULL,NULL,NULL,NULL,'2023-06-27 10:58:12','2023-06-27 10:58:12'),(173,'2023-06-27 06:59:07',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1898/1687874347 clock_in.png',NULL,NULL,NULL,NULL,'2023-06-27 10:59:07','2023-06-27 10:59:07'),(174,'2023-06-27 07:00:19',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1462/1687874419 clock_in.png',NULL,NULL,35894,NULL,'2023-06-27 11:00:19','2023-06-27 11:00:19'),(175,'2023-06-27 07:01:49','2023-06-27 07:02:41','191.77.254.175','191.77.254.175','closed',0,0,'attendances/1556/1687874509 clock_in.png','attendances/1556/1687874561 clock_out.png',NULL,NULL,NULL,'2023-06-27 11:01:49','2023-06-27 11:02:41'),(176,'2023-06-27 07:02:33',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1888/1687874553 clock_in.png',NULL,NULL,35911,NULL,'2023-06-27 11:02:33','2023-06-27 11:02:33'),(179,'2023-06-27 08:00:52',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1869/1687878052 clock_in.png',NULL,NULL,35912,NULL,'2023-06-27 12:00:52','2023-06-27 12:00:52'),(180,'2023-06-27 08:13:52',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1891/1687878832 clock_in.png',NULL,NULL,35914,NULL,'2023-06-27 12:13:52','2023-06-27 12:13:52'),(182,'2023-06-28 06:59:32','2023-06-28 15:50:16','12.249.250.150','12.249.250.150','closed',8,530,'attendances/1462/1687960772 clock_in.png','attendances/1462/1687992616 clock_out.png',NULL,NULL,NULL,'2023-06-28 10:59:32','2023-06-28 19:50:16'),(183,'2023-06-28 06:59:51','2023-06-28 15:45:38','12.249.250.150','12.249.250.150','closed',8,525,'attendances/1636/1687960791 clock_in.png','attendances/1636/1687992338 clock_out.png',NULL,NULL,NULL,'2023-06-28 10:59:51','2023-06-28 19:45:38'),(184,'2023-06-28 07:01:58','2023-06-28 15:41:25','12.249.250.150','12.249.250.150','closed',8,519,'attendances/1888/1687960918 clock_in.png','attendances/1888/1687992085 clock_out.png',NULL,35995,NULL,'2023-06-28 11:01:58','2023-06-28 19:41:25'),(185,'2023-06-28 07:10:19','2023-06-28 15:38:32','12.249.250.150','12.249.250.150','closed',8,508,'attendances/1858/1687961419 clock_in.png','attendances/1858/1687991912 clock_out.png',NULL,35981,NULL,'2023-06-28 11:10:19','2023-06-28 19:38:32'),(186,'2023-06-28 07:17:40','2023-06-28 07:18:41','179.32.221.112','179.32.221.112','closed',0,1,'attendances/1556/1687961860 clock_in.png','attendances/1556/1687961921 clock_out.png',NULL,NULL,NULL,'2023-06-28 11:17:40','2023-06-28 11:18:41'),(187,'2023-06-28 08:19:13','2023-06-28 12:34:00','12.249.250.150','12.249.250.150','closed',4,254,'attendances/1492/1687965553 clock_in.png','attendances/1492/1687980840 clock_out.png',NULL,36001,NULL,'2023-06-28 12:19:13','2023-06-28 16:34:00'),(188,'2023-06-28 13:04:36','2023-06-28 16:31:42','12.249.250.150','12.249.250.150','closed',3,207,'attendances/1492/1687982676 clock_in.png','attendances/1492/1687995102 clock_out.png',NULL,36001,NULL,'2023-06-28 17:04:36','2023-06-28 20:31:42'),(189,'2023-06-28 15:31:51','2023-06-28 15:32:02','12.249.250.150','12.249.250.150','closed',0,0,'attendances/1588/1687991511 clock_in.png','attendances/1588/1687991522 clock_out.png',NULL,NULL,NULL,'2023-06-28 19:31:51','2023-06-28 19:32:02'),(190,'2023-06-28 15:33:15',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1958/1687991595 clock_in.png',NULL,NULL,35997,NULL,'2023-06-28 19:33:15','2023-06-28 19:33:15'),(191,'2023-06-28 15:41:55',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1898/1687992115 clock_in.png',NULL,NULL,NULL,NULL,'2023-06-28 19:41:55','2023-06-28 19:41:55'),(192,'2023-06-28 15:44:06',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1724/1687992246 clock_in.png',NULL,NULL,NULL,NULL,'2023-06-28 19:44:06','2023-06-28 19:44:06'),(193,'2023-06-28 16:02:47',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1454/1687993367 clock_in.png',NULL,NULL,NULL,NULL,'2023-06-28 20:02:47','2023-06-28 20:02:47'),(194,'2023-06-29 05:29:51','2023-06-29 15:54:09','12.249.250.150','12.249.250.150','closed',10,624,'attendances/1636/1688041791 clock_in.png','attendances/1636/1688079249 clock_out.png',NULL,NULL,NULL,'2023-06-29 09:29:51','2023-06-29 19:54:09'),(195,'2023-06-29 05:53:11',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1588/1688043191 clock_in.png',NULL,NULL,NULL,NULL,'2023-06-29 09:53:11','2023-06-29 09:53:11'),(196,'2023-06-29 05:53:41','2023-06-29 16:59:56','12.249.250.150','12.249.250.150','closed',11,666,'attendances/1637/1688043221 clock_in.png','attendances/1637/1688083196 clock_out.png',NULL,NULL,NULL,'2023-06-29 09:53:41','2023-06-29 20:59:56'),(197,'2023-06-29 05:55:55','2023-06-29 16:14:30','12.249.250.150','190.2.214.172','closed',10,618,'attendances/1568/1688043355 clock_in.png','attendances/1568/1688080470 clock_out.png',NULL,NULL,NULL,'2023-06-29 09:55:55','2023-06-29 20:14:30'),(198,'2023-06-29 06:54:17','2023-06-29 11:32:58','12.249.250.150','12.249.250.150','closed',4,278,'attendances/1492/1688046857 clock_in.png','attendances/1492/1688063578 clock_out.png',NULL,NULL,NULL,'2023-06-29 10:54:17','2023-06-29 15:32:58'),(199,'2023-06-29 06:54:30',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1728/1688046870 clock_in.png',NULL,NULL,NULL,NULL,'2023-06-29 10:54:30','2023-06-29 10:54:30'),(200,'2023-06-29 06:54:49',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1724/1688046889 clock_in.png',NULL,NULL,NULL,NULL,'2023-06-29 10:54:49','2023-06-29 10:54:49'),(201,'2023-06-29 06:55:13','2023-06-29 16:02:03','12.249.250.150','12.249.250.150','closed',9,546,'attendances/1462/1688046913 clock_in.png','attendances/1462/1688079723 clock_out.png',NULL,NULL,NULL,'2023-06-29 10:55:13','2023-06-29 20:02:03'),(202,'2023-06-29 06:56:12',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1454/1688046972 clock_in.png',NULL,NULL,NULL,NULL,'2023-06-29 10:56:12','2023-06-29 10:56:12'),(203,'2023-06-29 06:56:26','2023-06-29 15:35:36','12.249.250.150','12.249.250.150','closed',8,519,'attendances/1948/1688046986 clock_in.png','attendances/1948/1688078136 clock_out.png',NULL,NULL,NULL,'2023-06-29 10:56:26','2023-06-29 19:35:36'),(204,'2023-06-29 06:57:06','2023-06-29 15:54:48','12.249.250.150','12.249.250.150','closed',8,537,'attendances/1898/1688047026 clock_in.png','attendances/1898/1688079288 clock_out.png',NULL,NULL,NULL,'2023-06-29 10:57:06','2023-06-29 19:54:48'),(205,'2023-06-29 06:59:54','2023-06-29 15:30:26','12.249.250.150','12.249.250.150','closed',8,510,'attendances/1958/1688047194 clock_in.png','attendances/1958/1688077826 clock_out.png',NULL,NULL,NULL,'2023-06-29 10:59:54','2023-06-29 19:30:26'),(206,'2023-06-29 07:00:08','2023-06-29 15:43:26','12.249.250.150','12.249.250.150','closed',8,523,'attendances/1888/1688047208 clock_in.png','attendances/1888/1688078606 clock_out.png',NULL,36051,NULL,'2023-06-29 11:00:08','2023-06-29 19:43:26'),(207,'2023-06-29 07:58:40',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1970/1688050720 clock_in.png',NULL,NULL,NULL,NULL,'2023-06-29 11:58:40','2023-06-29 11:58:40'),(208,'2023-06-29 12:03:17','2023-06-29 15:32:35','12.249.250.150','12.249.250.150','closed',3,209,'attendances/1492/1688065397 clock_in.png','attendances/1492/1688077955 clock_out.png',NULL,36057,NULL,'2023-06-29 16:03:17','2023-06-29 19:32:35'),(209,'2023-06-29 15:49:03','2023-06-29 15:54:07','190.2.214.172','190.2.214.172','closed',0,5,'attendances/1711/1688078943 clock_in.png','attendances/1711/1688079247 clock_out.png',NULL,NULL,NULL,'2023-06-29 19:49:03','2023-06-29 19:54:07'),(210,'2023-06-30 05:54:09',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1588/1688129649 clock_in.png',NULL,NULL,NULL,NULL,'2023-06-30 09:54:09','2023-06-30 09:54:09'),(211,'2023-06-30 05:54:33',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1568/1688129673 clock_in.png',NULL,NULL,NULL,NULL,'2023-06-30 09:54:33','2023-06-30 09:54:33'),(212,'2023-06-30 05:54:50',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1724/1688129690 clock_in.png',NULL,NULL,NULL,NULL,'2023-06-30 09:54:50','2023-06-30 09:54:50'),(213,'2023-06-30 05:56:09',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1728/1688129769 clock_in.png',NULL,NULL,NULL,NULL,'2023-06-30 09:56:09','2023-06-30 09:56:09'),(214,'2023-06-30 05:59:20',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1454/1688129960 clock_in.png',NULL,NULL,NULL,NULL,'2023-06-30 09:59:20','2023-06-30 09:59:20'),(215,'2023-06-30 06:59:08',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1958/1688133548 clock_in.png',NULL,NULL,NULL,NULL,'2023-06-30 10:59:08','2023-06-30 10:59:08'),(216,'2023-06-30 07:00:57',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1888/1688133657 clock_in.png',NULL,NULL,36103,NULL,'2023-06-30 11:00:57','2023-06-30 11:00:57'),(217,'2023-06-30 07:01:31',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1948/1688133691 clock_in.png',NULL,NULL,36096,NULL,'2023-06-30 11:01:31','2023-06-30 11:01:31'),(218,'2023-06-30 07:01:45',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1898/1688133705 clock_in.png',NULL,NULL,36079,NULL,'2023-06-30 11:01:45','2023-06-30 11:01:45'),(219,'2023-06-30 07:07:38',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1858/1688134058 clock_in.png',NULL,NULL,36086,NULL,'2023-06-30 11:07:38','2023-06-30 11:07:38'),(220,'2023-06-30 07:55:45',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1395/1688136945 clock_in.png',NULL,NULL,NULL,NULL,'2023-06-30 11:55:45','2023-06-30 11:55:45'),(221,'2023-06-30 08:04:47',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1970/1688137487 clock_in.png',NULL,NULL,36108,NULL,'2023-06-30 12:04:47','2023-06-30 12:04:47'),(222,'2023-07-03 06:53:05','2023-07-03 15:08:52','12.249.250.150','12.249.250.150','closed',8,495,'attendances/1568/1688392385 clock_in.png','attendances/1568/1688422132 clock_out.png',NULL,NULL,NULL,'2023-07-03 10:53:05','2023-07-03 19:08:52'),(223,'2023-07-03 06:53:20','2023-07-03 14:04:22','12.249.250.150','12.249.250.150','closed',7,431,'attendances/1588/1688392400 clock_in.png','attendances/1588/1688418262 clock_out.png',NULL,NULL,NULL,'2023-07-03 10:53:20','2023-07-03 18:04:22'),(224,'2023-07-03 06:53:35','2023-07-03 15:31:50','12.249.250.150','12.249.250.150','closed',8,518,'attendances/1637/1688392415 clock_in.png','attendances/1637/1688423510 clock_out.png',NULL,NULL,NULL,'2023-07-03 10:53:35','2023-07-03 19:31:50'),(225,'2023-07-03 06:56:28','2023-07-03 15:47:23','12.249.250.150','12.249.250.150','closed',8,530,'attendances/1888/1688392588 clock_in.png','attendances/1888/1688424443 clock_out.png',NULL,NULL,NULL,'2023-07-03 10:56:28','2023-07-03 19:47:23'),(226,'2023-07-06 15:33:46','2023-07-06 15:33:57','12.249.250.150','12.249.250.150','closed',0,0,'attendances/1568/1688682826 clock_in.png','attendances/1568/1688682837 clock_out.png',NULL,NULL,NULL,'2023-07-06 19:33:46','2023-07-06 19:33:57'),(227,'2023-07-06 15:39:53',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1948/1688683193 clock_in.png',NULL,NULL,NULL,NULL,'2023-07-06 19:39:53','2023-07-06 19:39:53'),(228,'2023-07-06 15:51:22',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1462/1688683882 clock_in.png',NULL,NULL,NULL,NULL,'2023-07-06 19:51:22','2023-07-06 19:51:22'),(229,'2023-07-05 05:54:56','2023-07-05 14:31:35','12.249.250.150','12.249.250.150','closed',8,37,'attendances/726/1688743256 clock_in.png','attendances/726/1688743355 clock_out.png',NULL,36333,NULL,'2023-07-07 12:20:56','2023-07-07 12:22:35'),(230,'2023-07-08 13:09:05',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1568/1688846945 clock_in.png',NULL,NULL,36369,NULL,'2023-07-08 17:09:05','2023-07-08 17:09:05'),(231,'2023-07-10 06:54:52','2023-07-10 17:28:59','12.249.250.150','12.249.250.150','closed',10,634,'attendances/1588/1688997292 clock_in.png','attendances/1588/1689035339 clock_out.png',NULL,NULL,NULL,'2023-07-10 10:54:52','2023-07-10 21:28:59'),(232,'2023-07-10 06:55:09',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1934/1688997309 clock_in.png',NULL,NULL,NULL,NULL,'2023-07-10 10:55:09','2023-07-10 10:55:09'),(233,'2023-07-10 06:55:21','2023-07-10 11:01:23','12.249.250.150','12.249.250.150','closed',4,246,'attendances/1724/1688997321 clock_in.png','attendances/1724/1689012083 clock_out.png',NULL,NULL,NULL,'2023-07-10 10:55:21','2023-07-10 15:01:23'),(234,'2023-07-10 06:55:39','2023-07-10 11:01:11','12.249.250.150','12.249.250.150','closed',4,245,'attendances/1965/1688997339 clock_in.png','attendances/1965/1689012071 clock_out.png',NULL,NULL,NULL,'2023-07-10 10:55:39','2023-07-10 15:01:11'),(235,'2023-07-10 06:55:57',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1728/1688997357 clock_in.png',NULL,NULL,NULL,NULL,'2023-07-10 10:55:57','2023-07-10 10:55:57'),(236,'2023-07-10 06:56:27',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1948/1688997387 clock_in.png',NULL,NULL,NULL,NULL,'2023-07-10 10:56:27','2023-07-10 10:56:27'),(237,'2023-07-10 06:56:54',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1374/1688997414 clock_in.png',NULL,NULL,NULL,NULL,'2023-07-10 10:56:54','2023-07-10 10:56:54'),(238,'2023-07-10 06:57:29',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1455/1688997449 clock_in.png',NULL,NULL,NULL,NULL,'2023-07-10 10:57:29','2023-07-10 10:57:29'),(240,'2023-07-10 06:58:57',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/974/1688997537 clock_in.png',NULL,NULL,NULL,NULL,'2023-07-10 10:58:57','2023-07-10 10:58:57'),(241,'2023-07-10 06:59:11','2023-07-10 16:15:20','12.249.250.150','12.249.250.150','closed',9,556,'attendances/1898/1688997551 clock_in.png','attendances/1898/1689030920 clock_out.png',NULL,NULL,NULL,'2023-07-10 10:59:11','2023-07-10 20:15:20'),(242,'2023-07-10 06:59:35',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1958/1688997575 clock_in.png',NULL,NULL,NULL,NULL,'2023-07-10 10:59:35','2023-07-10 10:59:35'),(243,'2023-07-10 07:00:10',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/622/1688997610 clock_in.png',NULL,NULL,36376,NULL,'2023-07-10 11:00:10','2023-07-10 11:00:10'),(244,'2023-07-10 07:08:28',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1951/1688998108 clock_in.png',NULL,NULL,36392,NULL,'2023-07-10 11:08:28','2023-07-10 11:08:28'),(245,'2023-07-10 07:09:55',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1888/1688998195 clock_in.png',NULL,NULL,36406,NULL,'2023-07-10 11:09:55','2023-07-10 11:09:55'),(246,'2023-07-10 07:11:23',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1462/1688998283 clock_in.png',NULL,NULL,36397,NULL,'2023-07-10 11:11:23','2023-07-10 11:11:23'),(247,'2023-07-10 07:11:47',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1858/1688998307 clock_in.png',NULL,NULL,36401,NULL,'2023-07-10 11:11:47','2023-07-10 11:11:47'),(248,'2023-07-10 08:00:12',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1970/1689001212 clock_in.png',NULL,NULL,36410,NULL,'2023-07-10 12:00:15','2023-07-10 12:00:15'),(249,'2023-07-10 08:00:31','2023-07-10 16:32:22','12.249.250.150','12.249.250.150','closed',8,511,'attendances/1869/1689001231 clock_in.png','attendances/1869/1689031942 clock_out.png',NULL,36407,NULL,'2023-07-10 12:00:31','2023-07-10 20:32:22'),(250,'2023-07-10 08:06:26','2023-07-10 12:33:06','12.249.250.150','12.249.250.150','closed',4,266,'attendances/1492/1689001586 clock_in.png','attendances/1492/1689017586 clock_out.png',NULL,36411,NULL,'2023-07-10 12:06:26','2023-07-10 16:33:06'),(251,'2023-07-10 09:10:44','2023-07-10 09:17:36','12.249.250.150','12.249.250.150','closed',0,6,'attendances/1584/1689005444 clock_in.png','attendances/1584/1689005856 clock_out.png',NULL,NULL,NULL,'2023-07-10 13:10:44','2023-07-10 13:17:36'),(252,'2023-07-10 10:34:53',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1375/1689010493 clock_in.png',NULL,NULL,36402,NULL,'2023-07-10 14:34:53','2023-07-10 14:34:53'),(253,'2023-07-10 11:02:02',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1724/1689012122 clock_in.png',NULL,NULL,36403,NULL,'2023-07-10 15:02:02','2023-07-10 15:02:02'),(254,'2023-07-10 11:02:19',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1965/1689012139 clock_in.png',NULL,NULL,36405,NULL,'2023-07-10 15:02:19','2023-07-10 15:02:19'),(255,'2023-07-10 16:30:12',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1492/1689031812 clock_in.png',NULL,NULL,NULL,NULL,'2023-07-10 20:30:12','2023-07-10 20:30:12'),(256,'2023-07-11 06:51:12','2023-07-11 15:29:32','12.249.250.150','12.249.250.150','closed',8,518,'attendances/1588/1689083472 clock_in.png','attendances/1588/1689114572 clock_out.png',NULL,NULL,NULL,'2023-07-11 10:51:12','2023-07-11 19:29:32'),(257,'2023-07-11 06:52:05','2023-07-11 15:35:50','12.249.250.150','12.249.250.150','closed',8,523,'attendances/1395/1689083525 clock_in.png','attendances/1395/1689114950 clock_out.png',NULL,NULL,NULL,'2023-07-11 10:52:05','2023-07-11 19:35:50'),(258,'2023-07-11 06:52:17','2023-07-11 15:30:04','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1568/1689083537 clock_in.png','attendances/1568/1689114604 clock_out.png',NULL,NULL,NULL,'2023-07-11 10:52:17','2023-07-11 19:30:04'),(259,'2023-07-11 06:52:45','2023-07-11 15:34:11','12.249.250.150','12.249.250.150','closed',8,521,'attendances/2021/1689083565 clock_in.png','attendances/2021/1689114851 clock_out.png',NULL,NULL,NULL,'2023-07-11 10:52:45','2023-07-11 19:34:11'),(260,'2023-07-11 06:53:11','2023-07-11 15:33:50','12.249.250.150','12.249.250.150','closed',8,520,'attendances/1965/1689083591 clock_in.png','attendances/1965/1689114830 clock_out.png',NULL,NULL,NULL,'2023-07-11 10:53:11','2023-07-11 19:33:50'),(261,'2023-07-11 06:53:44','2023-07-11 15:29:48','12.249.250.150','12.249.250.150','closed',8,516,'attendances/2025/1689083624 clock_in.png','attendances/2025/1689114588 clock_out.png',NULL,NULL,NULL,'2023-07-11 10:53:44','2023-07-11 19:29:48'),(262,'2023-07-11 06:54:12','2023-07-11 11:30:22','12.249.250.150','12.249.250.150','closed',4,276,'attendances/1774/1689083652 clock_in.png','attendances/1774/1689100222 clock_out.png',NULL,NULL,NULL,'2023-07-11 10:54:12','2023-07-11 15:30:22'),(263,'2023-07-11 06:54:30','2023-07-11 15:35:10','12.249.250.150','12.249.250.150','closed',8,520,'attendances/1374/1689083670 clock_in.png','attendances/1374/1689114910 clock_out.png',NULL,NULL,NULL,'2023-07-11 10:54:30','2023-07-11 19:35:10'),(264,'2023-07-11 06:54:44','2023-07-11 15:33:38','12.249.250.150','12.249.250.150','closed',8,518,'attendances/1934/1689083684 clock_in.png','attendances/1934/1689114818 clock_out.png',NULL,NULL,NULL,'2023-07-11 10:54:44','2023-07-11 19:33:38'),(265,'2023-07-11 06:55:01','2023-07-11 15:36:23','12.249.250.150','12.249.250.150','closed',8,521,'attendances/2005/1689083701 clock_in.png','attendances/2005/1689114983 clock_out.png',NULL,NULL,NULL,'2023-07-11 10:55:01','2023-07-11 19:36:23'),(266,'2023-07-11 06:55:37','2023-07-11 15:30:45','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1455/1689083737 clock_in.png','attendances/1455/1689114645 clock_out.png',NULL,NULL,NULL,'2023-07-11 10:55:37','2023-07-11 19:30:45'),(267,'2023-07-11 06:55:57','2023-07-11 15:39:54','12.249.250.150','12.249.250.150','closed',8,523,'attendances/1636/1689083757 clock_in.png','attendances/1636/1689115194 clock_out.png',NULL,NULL,NULL,'2023-07-11 10:55:57','2023-07-11 19:39:54'),(268,'2023-07-11 06:56:12','2023-07-11 15:34:24','12.249.250.150','12.249.250.150','closed',8,518,'attendances/1724/1689083772 clock_in.png','attendances/1724/1689114864 clock_out.png',NULL,NULL,NULL,'2023-07-11 10:56:12','2023-07-11 19:34:24'),(269,'2023-07-11 06:56:41','2023-07-11 15:31:15','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1479/1689083801 clock_in.png','attendances/1479/1689114675 clock_out.png',NULL,NULL,NULL,'2023-07-11 10:56:41','2023-07-11 19:31:15'),(270,'2023-07-11 06:56:53','2023-07-11 15:36:07','12.249.250.150','12.249.250.150','closed',8,519,'attendances/1728/1689083813 clock_in.png','attendances/1728/1689114967 clock_out.png',NULL,NULL,NULL,'2023-07-11 10:56:53','2023-07-11 19:36:07'),(271,'2023-07-11 06:57:08','2023-07-11 15:30:32','12.249.250.150','12.249.250.150','closed',8,513,'attendances/1450/1689083828 clock_in.png','attendances/1450/1689114632 clock_out.png',NULL,NULL,NULL,'2023-07-11 10:57:08','2023-07-11 19:30:32'),(272,'2023-07-11 06:57:24','2023-07-11 15:39:04','12.249.250.150','12.249.250.150','closed',8,521,'attendances/1867/1689083844 clock_in.png','attendances/1867/1689115144 clock_out.png',NULL,NULL,NULL,'2023-07-11 10:57:24','2023-07-11 19:39:04'),(273,'2023-07-11 06:57:39',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1950/1689083859 clock_in.png',NULL,NULL,NULL,NULL,'2023-07-11 10:57:39','2023-07-11 10:57:39'),(274,'2023-07-11 06:57:53',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1898/1689083873 clock_in.png',NULL,NULL,NULL,NULL,'2023-07-11 10:57:53','2023-07-11 10:57:53'),(275,'2023-07-11 06:58:27','2023-07-11 15:32:19','12.249.250.150','12.249.250.150','closed',8,513,'attendances/1116/1689083907 clock_in.png','attendances/1116/1689114739 clock_out.png',NULL,NULL,NULL,'2023-07-11 10:58:27','2023-07-11 19:32:19'),(276,'2023-07-11 06:58:38','2023-07-11 15:30:19','12.249.250.150','12.249.250.150','closed',8,511,'attendances/974/1689083918 clock_in.png','attendances/974/1689114619 clock_out.png',NULL,NULL,NULL,'2023-07-11 10:58:38','2023-07-11 19:30:19'),(277,'2023-07-11 06:58:49','2023-07-11 15:36:56','12.249.250.150','12.249.250.150','closed',8,518,'attendances/1951/1689083929 clock_in.png','attendances/1951/1689115016 clock_out.png',NULL,NULL,NULL,'2023-07-11 10:58:49','2023-07-11 19:36:56'),(278,'2023-07-11 06:59:01','2023-07-11 15:43:51','12.249.250.150','12.249.250.150','closed',8,524,'attendances/1948/1689083941 clock_in.png','attendances/1948/1689115431 clock_out.png',NULL,NULL,NULL,'2023-07-11 10:59:01','2023-07-11 19:43:51'),(279,'2023-07-11 06:59:16','2023-07-11 15:31:52','12.249.250.150','12.249.250.150','closed',8,512,'attendances/1999/1689083956 clock_in.png','attendances/1999/1689114712 clock_out.png',NULL,NULL,NULL,'2023-07-11 10:59:16','2023-07-11 19:31:52'),(280,'2023-07-11 06:59:49','2023-07-11 15:34:52','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1958/1689083989 clock_in.png','attendances/1958/1689114892 clock_out.png',NULL,NULL,NULL,'2023-07-11 10:59:49','2023-07-11 19:34:52'),(281,'2023-07-11 07:00:20','2023-07-11 15:37:12','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1666/1689084020 clock_in.png','attendances/1666/1689115032 clock_out.png',NULL,36456,NULL,'2023-07-11 11:00:20','2023-07-11 19:37:12'),(282,'2023-07-11 07:02:41','2023-07-11 15:41:50','12.249.250.150','12.249.250.150','closed',8,519,'attendances/1888/1689084161 clock_in.png','attendances/1888/1689115310 clock_out.png',NULL,36478,NULL,'2023-07-11 11:02:41','2023-07-11 19:41:50'),(283,'2023-07-11 07:06:19','2023-07-11 12:09:24','12.249.250.150','12.249.250.150','closed',5,303,'attendances/1462/1689084379 clock_in.png','attendances/1462/1689102564 clock_out.png',NULL,36459,NULL,'2023-07-11 11:06:19','2023-07-11 16:09:24'),(284,'2023-07-11 07:08:55','2023-07-11 15:34:39','12.249.250.150','12.249.250.150','closed',8,505,'attendances/1858/1689084535 clock_in.png','attendances/1858/1689114879 clock_out.png',NULL,36463,NULL,'2023-07-11 11:08:55','2023-07-11 19:34:39'),(285,'2023-07-11 07:58:30',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1970/1689087510 clock_in.png',NULL,NULL,NULL,NULL,'2023-07-11 11:58:30','2023-07-11 11:58:30'),(286,'2023-07-11 08:00:13',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1869/1689087613 clock_in.png',NULL,NULL,36479,NULL,'2023-07-11 12:00:18','2023-07-11 12:00:18'),(287,'2023-07-11 08:10:09',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1492/1689088209 clock_in.png',NULL,NULL,36482,NULL,'2023-07-11 12:10:09','2023-07-11 12:10:09'),(288,'2023-07-11 11:00:03','2023-07-11 15:31:02','12.249.250.150','12.249.250.150','closed',4,270,'attendances/1953/1689098403 clock_in.png','attendances/1953/1689114662 clock_out.png',NULL,36476,NULL,'2023-07-11 15:00:03','2023-07-11 19:31:02'),(289,'2023-07-11 15:31:38',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1774/1689114698 clock_in.png',NULL,NULL,NULL,NULL,'2023-07-11 19:31:38','2023-07-11 19:31:38'),(290,'2023-07-11 15:32:35',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1116/1689114755 clock_in.png',NULL,NULL,NULL,NULL,'2023-07-11 19:32:35','2023-07-11 19:32:35'),(291,'2023-07-11 15:35:33',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1375/1689114933 clock_in.png',NULL,NULL,NULL,NULL,'2023-07-11 19:35:33','2023-07-11 19:35:33'),(292,'2023-07-11 15:38:14',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/622/1689115094 clock_in.png',NULL,NULL,NULL,NULL,'2023-07-11 19:38:14','2023-07-11 19:38:14'),(293,'2023-07-11 15:38:41',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1462/1689115121 clock_in.png',NULL,NULL,NULL,NULL,'2023-07-11 19:38:41','2023-07-11 19:38:41'),(294,'2023-07-12 06:53:31',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1585/1689170011 clock_in.png',NULL,NULL,NULL,NULL,'2023-07-12 10:53:31','2023-07-12 10:53:31'),(295,'2023-07-12 06:53:54','2023-07-12 15:31:56','12.249.250.150','12.249.250.150','closed',8,518,'attendances/622/1689170034 clock_in.png','attendances/622/1689201116 clock_out.png',NULL,NULL,NULL,'2023-07-12 10:53:54','2023-07-12 19:31:56'),(296,'2023-07-12 06:54:16','2023-07-12 15:32:17','12.249.250.150','12.249.250.150','closed',8,518,'attendances/2021/1689170056 clock_in.png','attendances/2021/1689201137 clock_out.png',NULL,NULL,NULL,'2023-07-12 10:54:16','2023-07-12 19:32:17'),(297,'2023-07-12 06:54:29','2023-07-12 15:35:47','12.249.250.150','12.249.250.150','closed',8,521,'attendances/1948/1689170069 clock_in.png','attendances/1948/1689201347 clock_out.png',NULL,NULL,NULL,'2023-07-12 10:54:29','2023-07-12 19:35:47'),(298,'2023-07-12 06:54:47','2023-07-12 15:34:13','12.249.250.150','12.249.250.150','closed',8,519,'attendances/1965/1689170087 clock_in.png','attendances/1965/1689201253 clock_out.png',NULL,NULL,NULL,'2023-07-12 10:54:47','2023-07-12 19:34:13'),(299,'2023-07-12 06:55:01','2023-07-12 15:32:41','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1116/1689170101 clock_in.png','attendances/1116/1689201161 clock_out.png',NULL,NULL,NULL,'2023-07-12 10:55:01','2023-07-12 19:32:41'),(300,'2023-07-12 06:55:13','2023-07-12 15:33:38','12.249.250.150','12.249.250.150','closed',8,518,'attendances/1375/1689170113 clock_in.png','attendances/1375/1689201218 clock_out.png',NULL,NULL,NULL,'2023-07-12 10:55:13','2023-07-12 19:33:38'),(301,'2023-07-12 06:55:25','2023-07-12 15:33:50','12.249.250.150','12.249.250.150','closed',8,518,'attendances/1724/1689170125 clock_in.png','attendances/1724/1689201230 clock_out.png',NULL,NULL,NULL,'2023-07-12 10:55:25','2023-07-12 19:33:50'),(302,'2023-07-12 06:55:39','2023-07-12 15:32:54','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1934/1689170139 clock_in.png','attendances/1934/1689201175 clock_out.png',NULL,NULL,NULL,'2023-07-12 10:55:39','2023-07-12 19:32:55'),(303,'2023-07-12 06:55:55','2023-07-12 15:34:01','12.249.250.150','12.249.250.150','closed',8,518,'attendances/1728/1689170155 clock_in.png','attendances/1728/1689201241 clock_out.png',NULL,NULL,NULL,'2023-07-12 10:55:55','2023-07-12 19:34:01'),(304,'2023-07-12 06:56:06','2023-07-12 15:34:31','12.249.250.150','12.249.250.150','closed',8,518,'attendances/1999/1689170166 clock_in.png','attendances/1999/1689201271 clock_out.png',NULL,NULL,NULL,'2023-07-12 10:56:06','2023-07-12 19:34:31'),(305,'2023-07-12 06:58:08','2023-07-12 15:33:07','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1958/1689170288 clock_in.png','attendances/1958/1689201187 clock_out.png',NULL,NULL,NULL,'2023-07-12 10:58:08','2023-07-12 19:33:07'),(306,'2023-07-12 06:59:06','2023-07-12 15:36:31','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1898/1689170346 clock_in.png','attendances/1898/1689201391 clock_out.png',NULL,NULL,NULL,'2023-07-12 10:59:06','2023-07-12 19:36:31'),(307,'2023-07-12 07:00:20','2023-07-12 15:34:43','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1636/1689170420 clock_in.png','attendances/1636/1689201283 clock_out.png',NULL,36492,NULL,'2023-07-12 11:00:20','2023-07-12 19:34:43'),(308,'2023-07-12 07:00:45','2023-07-12 15:46:01','12.249.250.150','12.249.250.150','closed',8,525,'attendances/1462/1689170445 clock_in.png','attendances/1462/1689201961 clock_out.png',NULL,36494,NULL,'2023-07-12 11:00:45','2023-07-12 19:46:01'),(309,'2023-07-12 07:04:59','2023-07-12 15:37:25','12.249.250.150','12.249.250.150','closed',8,512,'attendances/1888/1689170699 clock_in.png','attendances/1888/1689201445 clock_out.png',NULL,36505,NULL,'2023-07-12 11:04:59','2023-07-12 19:37:25'),(310,'2023-07-12 07:10:06','2023-07-12 15:33:23','12.249.250.150','12.249.250.150','closed',8,503,'attendances/1858/1689171006 clock_in.png','attendances/1858/1689201203 clock_out.png',NULL,36497,NULL,'2023-07-12 11:10:06','2023-07-12 19:33:23'),(311,'2023-07-12 07:57:40','2023-07-12 16:30:57','12.249.250.150','12.249.250.150','closed',8,513,'attendances/1970/1689173860 clock_in.png','attendances/1970/1689204657 clock_out.png',NULL,NULL,NULL,'2023-07-12 11:57:40','2023-07-12 20:30:57'),(312,'2023-07-12 08:01:55','2023-07-12 16:33:41','12.249.250.150','12.249.250.150','closed',8,511,'attendances/1869/1689174115 clock_in.png','attendances/1869/1689204821 clock_out.png',NULL,36506,NULL,'2023-07-12 12:01:55','2023-07-12 20:33:41'),(313,'2023-07-12 08:02:07','2023-07-12 16:33:58','12.249.250.150','12.249.250.150','closed',8,511,'attendances/1891/1689174127 clock_in.png','attendances/1891/1689204838 clock_out.png',NULL,36508,NULL,'2023-07-12 12:02:07','2023-07-12 20:33:58'),(314,'2023-07-12 12:33:05',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/775/1689190385 clock_in.png',NULL,NULL,36373,NULL,'2023-07-12 16:33:05','2023-07-12 16:33:05'),(315,'2023-07-12 18:01:17',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1116/1689210077 clock_in.png',NULL,NULL,NULL,NULL,'2023-07-12 22:01:17','2023-07-12 22:01:17'),(316,'2023-07-13 06:53:50','2023-07-13 15:35:14','12.249.250.150','12.249.250.150','closed',8,521,'attendances/726/1689256430 clock_in.png','attendances/726/1689287714 clock_out.png',NULL,NULL,NULL,'2023-07-13 10:53:50','2023-07-13 19:35:14'),(317,'2023-07-13 06:54:09','2023-07-13 15:33:34','12.249.250.150','12.249.250.150','closed',8,519,'attendances/2021/1689256449 clock_in.png','attendances/2021/1689287614 clock_out.png',NULL,NULL,NULL,'2023-07-13 10:54:09','2023-07-13 19:33:34'),(318,'2023-07-13 06:54:40','2023-07-13 15:30:54','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1585/1689256480 clock_in.png','attendances/1585/1689287454 clock_out.png',NULL,NULL,NULL,'2023-07-13 10:54:40','2023-07-13 19:30:54'),(319,'2023-07-13 06:54:56','2023-07-13 15:33:51','12.249.250.150','12.249.250.150','closed',8,518,'attendances/1965/1689256496 clock_in.png','attendances/1965/1689287631 clock_out.png',NULL,NULL,NULL,'2023-07-13 10:54:56','2023-07-13 19:33:51'),(320,'2023-07-13 06:55:19','2023-07-13 16:02:27','12.249.250.150','12.249.250.150','closed',9,547,'attendances/1395/1689256519 clock_in.png','attendances/1395/1689289347 clock_out.png',NULL,NULL,NULL,'2023-07-13 10:55:19','2023-07-13 20:02:27'),(321,'2023-07-13 06:55:37','2023-07-13 15:58:35','12.249.250.150','12.249.250.150','closed',9,542,'attendances/1999/1689256537 clock_in.png','attendances/1999/1689289115 clock_out.png',NULL,NULL,NULL,'2023-07-13 10:55:37','2023-07-13 19:58:35'),(322,'2023-07-13 06:55:49','2023-07-13 16:19:06','12.249.250.150','12.249.250.150','closed',9,563,'attendances/1724/1689256549 clock_in.png','attendances/1724/1689290346 clock_out.png',NULL,NULL,NULL,'2023-07-13 10:55:49','2023-07-13 20:19:06'),(323,'2023-07-13 06:56:01','2023-07-13 16:19:16','12.249.250.150','12.249.250.150','closed',9,563,'attendances/1728/1689256561 clock_in.png','attendances/1728/1689290356 clock_out.png',NULL,NULL,NULL,'2023-07-13 10:56:01','2023-07-13 20:19:16'),(324,'2023-07-13 06:56:15','2023-07-13 15:36:44','12.249.250.150','12.249.250.150','closed',8,520,'attendances/1948/1689256575 clock_in.png','attendances/1948/1689287804 clock_out.png',NULL,NULL,NULL,'2023-07-13 10:56:15','2023-07-13 19:36:44'),(325,'2023-07-13 06:56:26','2023-07-13 15:36:12','12.249.250.150','12.249.250.150','closed',8,519,'attendances/1898/1689256586 clock_in.png','attendances/1898/1689287772 clock_out.png',NULL,NULL,NULL,'2023-07-13 10:56:26','2023-07-13 19:36:12'),(326,'2023-07-13 06:56:39','2023-07-13 15:32:51','12.249.250.150','12.249.250.150','closed',8,516,'attendances/622/1689256599 clock_in.png','attendances/622/1689287571 clock_out.png',NULL,NULL,NULL,'2023-07-13 10:56:39','2023-07-13 19:32:51'),(327,'2023-07-13 06:58:02','2023-07-13 15:32:17','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1958/1689256682 clock_in.png','attendances/1958/1689287537 clock_out.png',NULL,NULL,NULL,'2023-07-13 10:58:02','2023-07-13 19:32:17'),(328,'2023-07-13 06:58:17','2023-07-13 15:36:28','12.249.250.150','12.249.250.150','closed',8,518,'attendances/1568/1689256697 clock_in.png','attendances/1568/1689287788 clock_out.png',NULL,NULL,NULL,'2023-07-13 10:58:17','2023-07-13 19:36:28'),(329,'2023-07-13 06:58:37',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1774/1689256717 clock_in.png',NULL,NULL,NULL,NULL,'2023-07-13 10:58:37','2023-07-13 10:58:37'),(330,'2023-07-13 06:58:51','2023-07-13 15:34:24','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1375/1689256731 clock_in.png','attendances/1375/1689287664 clock_out.png',NULL,NULL,NULL,'2023-07-13 10:58:51','2023-07-13 19:34:24'),(331,'2023-07-13 06:59:11','2023-07-13 15:34:07','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1374/1689256751 clock_in.png','attendances/1374/1689287647 clock_out.png',NULL,NULL,NULL,'2023-07-13 10:59:11','2023-07-13 19:34:07'),(332,'2023-07-13 07:00:20','2023-07-13 15:31:11','12.249.250.150','12.249.250.150','closed',8,510,'attendances/2025/1689256820 clock_in.png','attendances/2025/1689287471 clock_out.png',NULL,36554,NULL,'2023-07-13 11:00:20','2023-07-13 19:31:11'),(333,'2023-07-13 07:00:33','2023-07-13 15:34:51','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1588/1689256833 clock_in.png','attendances/1588/1689287691 clock_out.png',NULL,36536,NULL,'2023-07-13 11:00:33','2023-07-13 19:34:51'),(334,'2023-07-13 07:01:47','2023-07-13 15:38:43','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1953/1689256907 clock_in.png','attendances/1953/1689287923 clock_out.png',NULL,36552,NULL,'2023-07-13 11:01:47','2023-07-13 19:38:43'),(335,'2023-07-13 07:03:03','2023-07-13 15:32:30','12.249.250.150','12.249.250.150','closed',8,509,'attendances/1858/1689256983 clock_in.png','attendances/1858/1689287550 clock_out.png',NULL,36544,NULL,'2023-07-13 11:03:03','2023-07-13 19:32:30'),(336,'2023-07-13 07:03:21','2023-07-13 15:40:14','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1888/1689257001 clock_in.png','attendances/1888/1689288014 clock_out.png',NULL,36555,NULL,'2023-07-13 11:03:21','2023-07-13 19:40:14'),(337,'2023-07-13 07:03:52','2023-07-13 16:06:33','12.249.250.150','12.249.250.150','closed',9,542,'attendances/1450/1689257032 clock_in.png','attendances/1450/1689289593 clock_out.png',NULL,36550,NULL,'2023-07-13 11:03:52','2023-07-13 20:06:33'),(338,'2023-07-13 07:08:28','2023-07-13 15:39:16','12.249.250.150','12.249.250.150','closed',8,510,'attendances/1462/1689257308 clock_in.png','attendances/1462/1689287956 clock_out.png',NULL,36542,NULL,'2023-07-13 11:08:28','2023-07-13 19:39:16'),(339,'2023-07-13 08:01:36','2023-07-13 16:33:06','12.249.250.150','12.249.250.150','closed',8,511,'attendances/1891/1689260496 clock_in.png','attendances/1891/1689291186 clock_out.png',NULL,36558,NULL,'2023-07-13 12:01:36','2023-07-13 20:33:06'),(340,'2023-07-13 08:04:12','2023-07-13 12:34:04','12.249.250.150','12.249.250.150','closed',4,269,'attendances/1492/1689260652 clock_in.png','attendances/1492/1689276844 clock_out.png',NULL,36560,NULL,'2023-07-13 12:04:12','2023-07-13 16:34:04'),(341,'2023-07-13 08:51:19',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1479/1689263479 clock_in.png',NULL,NULL,NULL,NULL,'2023-07-13 12:51:19','2023-07-13 12:51:19'),(342,'2023-07-13 13:04:19','2023-07-13 16:30:39','12.249.250.150','12.249.250.150','closed',3,206,'attendances/1492/1689278659 clock_in.png','attendances/1492/1689291039 clock_out.png',NULL,36560,NULL,'2023-07-13 17:04:19','2023-07-13 20:30:39'),(343,'2023-07-14 06:57:38',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/974/1689343058 clock_in.png',NULL,NULL,NULL,NULL,'2023-07-14 10:57:38','2023-07-14 10:57:38'),(344,'2023-07-14 06:58:00',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1898/1689343080 clock_in.png',NULL,NULL,NULL,NULL,'2023-07-14 10:58:00','2023-07-14 10:58:00'),(345,'2023-07-14 07:00:10',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1958/1689343210 clock_in.png',NULL,NULL,36570,NULL,'2023-07-14 11:00:10','2023-07-14 11:00:10'),(346,'2023-07-14 07:01:02',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1450/1689343262 clock_in.png',NULL,NULL,36577,NULL,'2023-07-14 11:01:02','2023-07-14 11:01:02'),(347,'2023-07-14 07:02:16',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1858/1689343336 clock_in.png',NULL,NULL,36574,NULL,'2023-07-14 11:02:16','2023-07-14 11:02:16'),(348,'2023-07-14 07:04:27',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1953/1689343467 clock_in.png',NULL,NULL,36578,NULL,'2023-07-14 11:04:27','2023-07-14 11:04:27'),(349,'2023-07-14 08:02:00',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1891/1689346920 clock_in.png',NULL,NULL,36581,NULL,'2023-07-14 12:02:00','2023-07-14 12:02:00'),(350,'2023-07-14 08:02:10',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1869/1689346930 clock_in.png',NULL,NULL,36580,NULL,'2023-07-14 12:02:10','2023-07-14 12:02:10'),(351,'2023-07-14 08:09:30','2023-07-14 12:31:46','12.249.250.150','12.249.250.150','closed',4,262,'attendances/1492/1689347370 clock_in.png','attendances/1492/1689363106 clock_out.png',NULL,36582,NULL,'2023-07-14 12:09:30','2023-07-14 16:31:46'),(352,'2023-07-14 11:03:05',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1585/1689357785 clock_in.png',NULL,NULL,36566,NULL,'2023-07-14 15:03:05','2023-07-14 15:03:05'),(353,'2023-07-14 11:29:13',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/726/1689359353 clock_in.png',NULL,NULL,36564,NULL,'2023-07-14 15:29:13','2023-07-14 15:29:13'),(354,'2023-07-14 11:48:26',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1551/1689360506 clock_in.png',NULL,NULL,36565,NULL,'2023-07-14 15:48:26','2023-07-14 15:48:26'),(355,'2023-07-14 13:03:19',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1492/1689364999 clock_in.png',NULL,NULL,36582,NULL,'2023-07-14 17:03:19','2023-07-14 17:03:19'),(356,'2023-07-15 05:00:58',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1636/1689422458 clock_in.png',NULL,NULL,36619,NULL,'2023-07-15 09:00:58','2023-07-15 09:00:58'),(357,'2023-07-15 05:55:06','2023-07-15 12:19:12','12.249.250.150','12.249.250.150','closed',6,384,'attendances/1395/1689425706 clock_in.png','attendances/1395/1689448752 clock_out.png',NULL,NULL,NULL,'2023-07-15 09:55:06','2023-07-15 16:19:12'),(358,'2023-07-15 05:56:28','2023-07-15 12:18:53','12.249.250.150','12.249.250.150','closed',6,382,'attendances/1116/1689425788 clock_in.png','attendances/1116/1689448733 clock_out.png',NULL,NULL,NULL,'2023-07-15 09:56:28','2023-07-15 16:18:53'),(359,'2023-07-15 06:47:37','2023-07-15 14:03:48','12.249.250.150','12.249.250.150','closed',7,436,'attendances/1479/1689428857 clock_in.png','attendances/1479/1689455028 clock_out.png',NULL,36622,NULL,'2023-07-15 10:47:37','2023-07-15 18:03:48'),(360,'2023-07-15 14:08:07','2023-07-15 14:08:47','12.249.250.150','12.249.250.150','closed',0,0,'attendances/1479/1689455287 clock_in.png','attendances/1479/1689455327 clock_out.png',NULL,36622,NULL,'2023-07-15 18:08:07','2023-07-15 18:08:47'),(361,'2023-07-15 14:41:29','2023-07-15 18:43:45','12.249.250.150','12.249.250.150','closed',4,242,'attendances/1116/1689457289 clock_in.png','attendances/1116/1689471825 clock_out.png',NULL,NULL,NULL,'2023-07-15 18:41:29','2023-07-15 22:43:45'),(362,'2023-07-15 14:41:54','2023-07-15 18:43:26','12.249.250.150','12.249.250.150','closed',4,241,'attendances/1395/1689457314 clock_in.png','attendances/1395/1689471806 clock_out.png',NULL,NULL,NULL,'2023-07-15 18:41:54','2023-07-15 22:43:26'),(363,'2023-07-15 18:52:07',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1479/1689472327 clock_in.png',NULL,NULL,NULL,NULL,'2023-07-15 22:52:07','2023-07-15 22:52:07'),(364,'2023-07-17 06:55:07','2023-07-17 15:33:37','12.249.250.150','12.249.250.150','closed',8,518,'attendances/1588/1689602107 clock_in.png','attendances/1588/1689633217 clock_out.png',NULL,NULL,NULL,'2023-07-17 10:55:07','2023-07-17 19:33:37'),(365,'2023-07-17 06:55:20','2023-07-17 15:31:49','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1934/1689602120 clock_in.png','attendances/1934/1689633109 clock_out.png',NULL,NULL,NULL,'2023-07-17 10:55:20','2023-07-17 19:31:49'),(366,'2023-07-17 06:55:39','2023-07-17 15:37:18','12.249.250.150','12.249.250.150','closed',8,521,'attendances/1728/1689602139 clock_in.png','attendances/1728/1689633438 clock_out.png',NULL,NULL,NULL,'2023-07-17 10:55:39','2023-07-17 19:37:18'),(367,'2023-07-17 06:55:55','2023-07-17 15:36:57','12.249.250.150','12.249.250.150','closed',8,521,'attendances/1724/1689602155 clock_in.png','attendances/1724/1689633417 clock_out.png',NULL,NULL,NULL,'2023-07-17 10:55:55','2023-07-17 19:36:57'),(368,'2023-07-17 06:56:11','2023-07-17 15:32:41','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1858/1689602171 clock_in.png','attendances/1858/1689633161 clock_out.png',NULL,NULL,NULL,'2023-07-17 10:56:11','2023-07-17 19:32:41'),(369,'2023-07-17 06:57:55','2023-07-17 15:32:27','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1958/1689602275 clock_in.png','attendances/1958/1689633147 clock_out.png',NULL,NULL,NULL,'2023-07-17 10:57:55','2023-07-17 19:32:27'),(370,'2023-07-17 06:58:35','2023-07-17 15:29:22','12.249.250.150','12.249.250.150','closed',8,510,'attendances/1585/1689602315 clock_in.png','attendances/1585/1689632962 clock_out.png',NULL,NULL,NULL,'2023-07-17 10:58:35','2023-07-17 19:29:22'),(371,'2023-07-17 06:59:12','2023-07-17 15:32:11','12.249.250.150','12.249.250.150','closed',8,512,'attendances/1374/1689602352 clock_in.png','attendances/1374/1689633131 clock_out.png',NULL,NULL,NULL,'2023-07-17 10:59:12','2023-07-17 19:32:11'),(372,'2023-07-17 06:59:32','2023-07-17 15:36:16','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1948/1689602372 clock_in.png','attendances/1948/1689633376 clock_out.png',NULL,NULL,NULL,'2023-07-17 10:59:32','2023-07-17 19:36:16'),(373,'2023-07-17 07:08:43','2023-07-17 15:36:32','12.249.250.150','12.249.250.150','closed',8,507,'attendances/1999/1689602923 clock_in.png','attendances/1999/1689633392 clock_out.png',NULL,36630,NULL,'2023-07-17 11:08:43','2023-07-17 19:36:32'),(374,'2023-07-17 07:54:13','2023-07-17 16:35:02','12.249.250.150','12.249.250.150','closed',8,520,'attendances/1869/1689605653 clock_in.png','attendances/1869/1689636902 clock_out.png',NULL,NULL,NULL,'2023-07-17 11:54:13','2023-07-17 20:35:02'),(375,'2023-07-17 11:02:46','2023-07-17 15:31:10','12.249.250.150','12.249.250.150','closed',4,268,'attendances/622/1689616966 clock_in.png','attendances/622/1689633070 clock_out.png',NULL,36638,NULL,'2023-07-17 15:02:46','2023-07-17 19:31:10'),(376,'2023-07-17 12:49:04','2023-07-17 13:25:32','12.249.250.150','12.249.250.150','closed',0,36,'attendances/1988/1689623344 clock_in.png','attendances/1988/1689625532 clock_out.png',NULL,36642,NULL,'2023-07-17 16:49:04','2023-07-17 17:25:32'),(377,'2023-07-17 14:39:14','2023-07-17 14:40:54','12.249.250.150','12.249.250.150','closed',0,1,'attendances/1951/1689629954 clock_in.png','attendances/1951/1689630054 clock_out.png',NULL,NULL,NULL,'2023-07-17 18:39:14','2023-07-17 18:40:54'),(378,'2023-07-17 14:41:16','2023-07-17 14:41:39','12.249.250.150','12.249.250.150','closed',0,0,'attendances/1568/1689630076 clock_in.png','attendances/1568/1689630099 clock_out.png',NULL,36625,NULL,'2023-07-17 18:41:16','2023-07-17 18:41:39'),(380,'2023-07-17 15:37:56',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1462/1689633476 clock_in.png',NULL,NULL,NULL,NULL,'2023-07-17 19:37:56','2023-07-17 19:37:56'),(382,'2023-07-17 17:00:03',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1988/1689638403 clock_in.png',NULL,NULL,NULL,NULL,'2023-07-17 21:00:03','2023-07-17 21:00:03'),(383,'2023-07-18 05:05:08',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/2005/1689682759 clock_in.png',NULL,NULL,36681,NULL,'2023-07-18 09:19:19','2023-07-18 12:12:39'),(384,'2023-07-18 05:21:26','2023-07-18 18:50:44','12.249.250.150','190.2.214.172','closed',13,809,'attendances/1584/1689682886 clock_in.png','attendances/1584/1689731444 clock_out.png',NULL,NULL,NULL,'2023-07-18 09:21:26','2023-07-18 22:50:44'),(385,'2023-07-18 05:54:39','2023-07-18 14:33:37','12.249.250.150','12.249.250.150','closed',8,518,'attendances/1774/1689684879 clock_in.png','attendances/1774/1689716017 clock_out.png',NULL,NULL,NULL,'2023-07-18 09:54:39','2023-07-18 18:33:37'),(386,'2023-07-18 06:12:02','2023-07-18 14:36:21','12.249.250.150','12.249.250.150','closed',8,504,'attendances/1951/1689685922 clock_in.png','attendances/1951/1689716181 clock_out.png',NULL,36684,NULL,'2023-07-18 10:12:02','2023-07-18 18:36:21'),(387,'2023-07-18 06:52:37','2023-07-18 15:33:28','12.249.250.150','12.249.250.150','closed',8,520,'attendances/622/1689688357 clock_in.png','attendances/622/1689719608 clock_out.png',NULL,NULL,NULL,'2023-07-18 10:52:37','2023-07-18 19:33:28'),(388,'2023-07-18 06:54:04','2023-07-18 15:40:20','12.249.250.150','12.249.250.150','closed',8,526,'attendances/1898/1689688445 clock_in.png','attendances/1898/1689720020 clock_out.png',NULL,NULL,NULL,'2023-07-18 10:54:05','2023-07-18 19:40:20'),(389,'2023-07-18 06:54:17','2023-07-18 15:37:58','12.249.250.150','12.249.250.150','closed',8,523,'attendances/1724/1689688457 clock_in.png','attendances/1724/1689719878 clock_out.png',NULL,NULL,NULL,'2023-07-18 10:54:17','2023-07-18 19:37:58'),(390,'2023-07-18 06:54:29','2023-07-18 15:37:29','12.249.250.150','12.249.250.150','closed',8,523,'attendances/1999/1689688469 clock_in.png','attendances/1999/1689719849 clock_out.png',NULL,NULL,NULL,'2023-07-18 10:54:29','2023-07-18 19:37:29'),(391,'2023-07-18 06:54:46','2023-07-18 15:37:46','12.249.250.150','12.249.250.150','closed',8,523,'attendances/1728/1689688486 clock_in.png','attendances/1728/1689719866 clock_out.png',NULL,NULL,NULL,'2023-07-18 10:54:46','2023-07-18 19:37:46'),(392,'2023-07-18 06:55:11','2023-07-18 15:32:51','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1965/1689688511 clock_in.png','attendances/1965/1689719571 clock_out.png',NULL,NULL,NULL,'2023-07-18 10:55:11','2023-07-18 19:32:51'),(393,'2023-07-18 06:56:01','2023-07-18 15:31:56','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1958/1689688561 clock_in.png','attendances/1958/1689719516 clock_out.png',NULL,NULL,NULL,'2023-07-18 10:56:01','2023-07-18 19:31:56'),(394,'2023-07-18 06:56:20','2023-07-18 15:31:44','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1858/1689688580 clock_in.png','attendances/1858/1689719504 clock_out.png',NULL,NULL,NULL,'2023-07-18 10:56:20','2023-07-18 19:31:44'),(395,'2023-07-18 06:58:19','2023-07-18 15:35:13','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1948/1689688699 clock_in.png','attendances/1948/1689719713 clock_out.png',NULL,NULL,NULL,'2023-07-18 10:58:19','2023-07-18 19:35:13'),(396,'2023-07-18 07:01:01','2023-07-18 15:39:55','12.249.250.150','12.249.250.150','closed',8,518,'attendances/1462/1689688861 clock_in.png','attendances/1462/1689719995 clock_out.png',NULL,36691,NULL,'2023-07-18 11:01:01','2023-07-18 19:39:55'),(397,'2023-07-18 07:01:16','2023-07-18 15:33:14','12.249.250.150','12.249.250.150','closed',8,511,'attendances/1375/1689688876 clock_in.png','attendances/1375/1689719594 clock_out.png',NULL,36694,NULL,'2023-07-18 11:01:16','2023-07-18 19:33:14'),(398,'2023-07-18 07:01:28','2023-07-18 15:33:42','12.249.250.150','12.249.250.150','closed',8,512,'attendances/1374/1689688888 clock_in.png','attendances/1374/1689719622 clock_out.png',NULL,36689,NULL,'2023-07-18 11:01:28','2023-07-18 19:33:42'),(399,'2023-07-18 07:23:19','2023-07-18 11:29:44','12.249.250.150','12.249.250.150','closed',4,246,'attendances/726/1689690199 clock_in.png','attendances/726/1689704984 clock_out.png',NULL,NULL,NULL,'2023-07-18 11:23:19','2023-07-18 15:29:44'),(400,'2023-07-18 07:58:48','2023-07-18 07:59:59','12.249.250.150','12.249.250.150','closed',0,1,'attendances/775/1689692328 clock_in.png','attendances/775/1689692399 clock_out.png',NULL,NULL,NULL,'2023-07-18 11:58:48','2023-07-18 11:59:59'),(401,'2023-07-18 07:59:16','2023-07-18 16:33:50','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1869/1689692356 clock_in.png','attendances/1869/1689723230 clock_out.png',NULL,NULL,NULL,'2023-07-18 11:59:16','2023-07-18 20:33:50'),(402,'2023-07-18 08:17:40','2023-07-18 16:29:29','12.249.250.150','12.249.250.150','closed',8,491,'attendances/1492/1689693460 clock_in.png','attendances/1492/1689722969 clock_out.png',NULL,36703,NULL,'2023-07-18 12:17:40','2023-07-18 20:29:29'),(403,'2023-07-18 08:34:17',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1988/1689694457 clock_in.png',NULL,NULL,36704,NULL,'2023-07-18 12:34:17','2023-07-18 12:34:17'),(404,'2023-07-18 11:59:08','2023-07-18 15:57:32','12.249.250.150','12.249.250.150','closed',3,238,'attendances/726/1689706748 clock_in.png','attendances/726/1689721052 clock_out.png',NULL,36699,NULL,'2023-07-18 15:59:08','2023-07-18 19:57:32'),(405,'2023-07-18 12:33:18','2023-07-18 16:34:08','12.249.250.150','12.249.250.150','closed',4,240,'attendances/1891/1689708798 clock_in.png','attendances/1891/1689723248 clock_out.png',NULL,36702,NULL,'2023-07-18 16:33:18','2023-07-18 20:34:08'),(406,'2023-07-18 12:34:14','2023-07-18 13:04:56','12.249.250.150','12.249.250.150','closed',0,30,'attendances/775/1689708854 clock_in.png','attendances/775/1689710696 clock_out.png',NULL,36701,NULL,'2023-07-18 16:34:14','2023-07-18 17:04:56'),(407,'2023-07-18 14:32:36',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/2021/1689715956 clock_in.png',NULL,NULL,NULL,NULL,'2023-07-18 18:32:36','2023-07-18 18:32:36'),(408,'2023-07-18 16:29:07',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/775/1689722947 clock_in.png',NULL,NULL,36701,NULL,'2023-07-18 20:29:07','2023-07-18 20:29:07'),(409,'2023-07-19 05:04:05','2023-07-19 19:35:59','12.249.250.150','12.249.250.150','closed',14,871,'attendances/1867/1689768245 clock_in.png','attendances/1867/1689820559 clock_out.png',NULL,36713,NULL,'2023-07-19 09:04:05','2023-07-19 23:35:59'),(411,'2023-07-19 05:06:05','2023-07-19 19:45:17','12.249.250.150','12.249.250.150','closed',14,879,'attendances/2025/1689768365 clock_in.png','attendances/2025/1689821117 clock_out.png',NULL,36717,NULL,'2023-07-19 09:06:05','2023-07-19 23:45:17'),(412,'2023-07-19 05:06:26','2023-07-19 19:32:03','12.249.250.150','12.249.250.150','closed',14,865,'attendances/382/1689768386 clock_in.png','attendances/382/1689820323 clock_out.png',NULL,36714,NULL,'2023-07-19 09:06:26','2023-07-19 23:32:03'),(413,'2023-07-19 05:07:17',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/2005/1689768437 clock_in.png',NULL,NULL,36715,NULL,'2023-07-19 09:07:17','2023-07-19 09:07:17'),(414,'2023-07-19 05:07:43','2023-07-19 19:45:25','12.249.250.150','12.249.250.150','closed',14,877,'attendances/1953/1689768463 clock_in.png','attendances/1953/1689821125 clock_out.png',NULL,36716,NULL,'2023-07-19 09:07:43','2023-07-19 23:45:25'),(415,'2023-07-19 05:53:57','2023-07-19 14:50:21','12.249.250.150','12.249.250.150','closed',8,536,'attendances/1774/1689771237 clock_in.png','attendances/1774/1689803421 clock_out.png',NULL,NULL,NULL,'2023-07-19 09:53:57','2023-07-19 18:50:21'),(416,'2023-07-19 05:54:31','2023-07-19 14:53:18','12.249.250.150','12.249.250.150','closed',8,538,'attendances/1551/1689771271 clock_in.png','attendances/1551/1689803598 clock_out.png',NULL,NULL,NULL,'2023-07-19 09:54:31','2023-07-19 18:53:18'),(417,'2023-07-19 05:54:55','2023-07-19 14:37:12','12.249.250.150','12.249.250.150','closed',8,522,'attendances/1951/1689771295 clock_in.png','attendances/1951/1689802632 clock_out.png',NULL,NULL,NULL,'2023-07-19 09:54:55','2023-07-19 18:37:12'),(418,'2023-07-19 05:56:54','2023-07-19 14:50:45','12.249.250.150','12.249.250.150','closed',8,533,'attendances/2021/1689771414 clock_in.png','attendances/2021/1689803445 clock_out.png',NULL,NULL,NULL,'2023-07-19 09:56:54','2023-07-19 18:50:45'),(419,'2023-07-19 06:53:25','2023-07-19 15:33:16','12.249.250.150','12.249.250.150','closed',8,519,'attendances/622/1689774805 clock_in.png','attendances/622/1689805996 clock_out.png',NULL,NULL,NULL,'2023-07-19 10:53:25','2023-07-19 19:33:16'),(420,'2023-07-19 06:53:44','2023-07-19 15:34:50','12.249.250.150','12.249.250.150','closed',8,521,'attendances/1898/1689774824 clock_in.png','attendances/1898/1689806090 clock_out.png',NULL,NULL,NULL,'2023-07-19 10:53:44','2023-07-19 19:34:50'),(421,'2023-07-19 06:54:08','2023-07-19 16:06:42','12.249.250.150','12.249.250.150','closed',9,552,'attendances/726/1689774848 clock_in.png','attendances/726/1689808002 clock_out.png',NULL,NULL,NULL,'2023-07-19 10:54:08','2023-07-19 20:06:42'),(422,'2023-07-19 06:54:25','2023-07-19 17:24:02','12.249.250.150','12.249.250.150','closed',10,629,'attendances/1116/1689774865 clock_in.png','attendances/1116/1689812642 clock_out.png',NULL,NULL,NULL,'2023-07-19 10:54:25','2023-07-19 21:24:02'),(423,'2023-07-19 06:54:41','2023-07-19 15:31:04','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1965/1689774881 clock_in.png','attendances/1965/1689805864 clock_out.png',NULL,NULL,NULL,'2023-07-19 10:54:41','2023-07-19 19:31:04'),(424,'2023-07-19 06:54:58','2023-07-19 15:34:14','12.249.250.150','12.249.250.150','closed',8,519,'attendances/1395/1689774898 clock_in.png','attendances/1395/1689806054 clock_out.png',NULL,NULL,NULL,'2023-07-19 10:54:58','2023-07-19 19:34:14'),(425,'2023-07-19 06:55:13','2023-07-19 15:32:33','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1479/1689774913 clock_in.png','attendances/1479/1689805953 clock_out.png',NULL,NULL,NULL,'2023-07-19 10:55:13','2023-07-19 19:32:33'),(426,'2023-07-19 06:55:29','2023-07-19 15:35:08','12.249.250.150','12.249.250.150','closed',8,519,'attendances/1934/1689774929 clock_in.png','attendances/1934/1689806108 clock_out.png',NULL,NULL,NULL,'2023-07-19 10:55:29','2023-07-19 19:35:08'),(427,'2023-07-19 06:55:44','2023-07-19 15:32:04','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1958/1689774944 clock_in.png','attendances/1958/1689805924 clock_out.png',NULL,NULL,NULL,'2023-07-19 10:55:44','2023-07-19 19:32:04'),(428,'2023-07-19 06:56:00','2023-07-19 15:31:49','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1858/1689774960 clock_in.png','attendances/1858/1689805909 clock_out.png',NULL,NULL,NULL,'2023-07-19 10:56:00','2023-07-19 19:31:49'),(429,'2023-07-19 06:56:11','2023-07-19 17:23:25','12.249.250.150','12.249.250.150','closed',10,627,'attendances/1588/1689774971 clock_in.png','attendances/1588/1689812605 clock_out.png',NULL,NULL,NULL,'2023-07-19 10:56:11','2023-07-19 21:23:25'),(430,'2023-07-19 06:56:30','2023-07-19 15:31:24','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1948/1689774990 clock_in.png','attendances/1948/1689805884 clock_out.png',NULL,NULL,NULL,'2023-07-19 10:56:30','2023-07-19 19:31:24'),(431,'2023-07-19 06:56:49','2023-07-19 15:37:54','12.249.250.150','12.249.250.150','closed',8,521,'attendances/1999/1689775009 clock_in.png','attendances/1999/1689806274 clock_out.png',NULL,NULL,NULL,'2023-07-19 10:56:49','2023-07-19 19:37:54'),(432,'2023-07-19 06:57:19','2023-07-19 15:34:35','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1568/1689775039 clock_in.png','attendances/1568/1689806075 clock_out.png',NULL,NULL,NULL,'2023-07-19 10:57:19','2023-07-19 19:34:35'),(433,'2023-07-19 06:57:29','2023-07-19 17:12:30','12.249.250.150','12.249.250.150','closed',10,615,'attendances/974/1689775049 clock_in.png','attendances/974/1689811950 clock_out.png',NULL,NULL,NULL,'2023-07-19 10:57:29','2023-07-19 21:12:30'),(434,'2023-07-19 06:57:57','2023-07-19 17:23:43','12.249.250.150','12.249.250.150','closed',10,625,'attendances/1585/1689775077 clock_in.png','attendances/1585/1689812623 clock_out.png',NULL,NULL,NULL,'2023-07-19 10:57:57','2023-07-19 21:23:43'),(435,'2023-07-19 06:58:10','2023-07-19 11:50:16','12.249.250.150','12.249.250.150','closed',4,292,'attendances/1375/1689775090 clock_in.png','attendances/1375/1689792616 clock_out.png',NULL,NULL,NULL,'2023-07-19 10:58:10','2023-07-19 15:50:16'),(436,'2023-07-19 06:59:22','2023-07-19 15:30:15','12.249.250.150','12.249.250.150','closed',8,510,'attendances/1455/1689775162 clock_in.png','attendances/1455/1689805815 clock_out.png',NULL,NULL,NULL,'2023-07-19 10:59:22','2023-07-19 19:30:15'),(437,'2023-07-19 06:59:47','2023-07-19 16:03:49','12.249.250.150','12.249.250.150','closed',9,544,'attendances/1636/1689775187 clock_in.png','attendances/1636/1689807829 clock_out.png',NULL,NULL,NULL,'2023-07-19 10:59:47','2023-07-19 20:03:49'),(438,'2023-07-19 07:02:04','2023-07-19 15:30:44','12.249.250.150','12.249.250.150','closed',8,508,'attendances/1450/1689775324 clock_in.png','attendances/1450/1689805844 clock_out.png',NULL,36741,NULL,'2023-07-19 11:02:04','2023-07-19 19:30:44'),(439,'2023-07-19 07:02:32','2023-07-19 15:42:41','12.249.250.150','12.249.250.150','closed',8,520,'attendances/1462/1689775352 clock_in.png','attendances/1462/1689806561 clock_out.png',NULL,36732,NULL,'2023-07-19 11:02:32','2023-07-19 19:42:41'),(440,'2023-07-19 07:59:24','2023-07-19 16:29:25','12.249.250.150','12.249.250.150','closed',8,510,'attendances/775/1689778764 clock_in.png','attendances/775/1689809365 clock_out.png',NULL,NULL,NULL,'2023-07-19 11:59:24','2023-07-19 20:29:25'),(441,'2023-07-19 08:00:32','2023-07-19 16:31:57','12.249.250.150','12.249.250.150','closed',8,511,'attendances/1869/1689778832 clock_in.png','attendances/1869/1689809517 clock_out.png',NULL,36743,NULL,'2023-07-19 12:00:32','2023-07-19 20:31:57'),(442,'2023-07-19 08:00:51','2023-07-19 16:31:32','12.249.250.150','12.249.250.150','closed',8,510,'attendances/1891/1689778851 clock_in.png','attendances/1891/1689809492 clock_out.png',NULL,36745,NULL,'2023-07-19 12:00:51','2023-07-19 20:31:32'),(443,'2023-07-19 08:08:48','2023-07-19 16:29:41','12.249.250.150','12.249.250.150','closed',8,500,'attendances/1492/1689779328 clock_in.png','attendances/1492/1689809381 clock_out.png',NULL,36746,NULL,'2023-07-19 12:08:48','2023-07-19 20:29:41'),(444,'2023-07-20 04:50:45',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/2005/1689853845 clock_in.png',NULL,NULL,NULL,NULL,'2023-07-20 08:50:45','2023-07-20 08:50:45'),(445,'2023-07-20 04:55:55','2023-07-20 16:11:04','12.249.250.150','12.249.250.150','closed',11,675,'attendances/1588/1689854155 clock_in.png','attendances/1588/1689894664 clock_out.png',NULL,NULL,NULL,'2023-07-20 08:55:55','2023-07-20 20:11:04'),(446,'2023-07-20 05:01:10','2023-07-20 16:08:13','12.249.250.150','12.249.250.150','closed',11,667,'attendances/1636/1689854470 clock_in.png','attendances/1636/1689894493 clock_out.png',NULL,36767,NULL,'2023-07-20 09:01:10','2023-07-20 20:08:13'),(447,'2023-07-20 05:01:22','2023-07-20 14:06:10','12.249.250.150','12.249.250.150','closed',9,544,'attendances/382/1689854482 clock_in.png','attendances/382/1689887170 clock_out.png',NULL,36766,NULL,'2023-07-20 09:01:22','2023-07-20 18:06:10'),(448,'2023-07-20 05:53:58','2023-07-20 14:51:42','12.249.250.150','12.249.250.150','closed',8,537,'attendances/1774/1689857638 clock_in.png','attendances/1774/1689889902 clock_out.png',NULL,NULL,NULL,'2023-07-20 09:53:58','2023-07-20 18:51:42'),(449,'2023-07-20 05:54:14','2023-07-20 14:54:25','12.249.250.150','12.249.250.150','closed',9,540,'attendances/2021/1689857654 clock_in.png','attendances/2021/1689890065 clock_out.png',NULL,NULL,NULL,'2023-07-20 09:54:14','2023-07-20 18:54:25'),(450,'2023-07-20 05:54:30','2023-07-20 14:51:13','12.249.250.150','12.249.250.150','closed',8,536,'attendances/1551/1689857670 clock_in.png','attendances/1551/1689889873 clock_out.png',NULL,NULL,NULL,'2023-07-20 09:54:30','2023-07-20 18:51:13'),(451,'2023-07-20 05:57:04','2023-07-20 14:48:11','12.249.250.150','12.249.250.150','closed',8,531,'attendances/1951/1689857824 clock_in.png','attendances/1951/1689889691 clock_out.png',NULL,NULL,NULL,'2023-07-20 09:57:04','2023-07-20 18:48:11'),(452,'2023-07-20 05:57:55','2023-07-20 16:18:06','12.249.250.150','12.249.250.150','closed',10,620,'attendances/1867/1689857875 clock_in.png','attendances/1867/1689895086 clock_out.png',NULL,NULL,NULL,'2023-07-20 09:57:55','2023-07-20 20:18:06'),(453,'2023-07-20 06:01:24','2023-07-20 16:13:50','12.249.250.150','12.249.250.150','closed',10,612,'attendances/1455/1689858084 clock_in.png','attendances/1455/1689894830 clock_out.png',NULL,36773,NULL,'2023-07-20 10:01:24','2023-07-20 20:13:50'),(454,'2023-07-20 06:04:14','2023-07-20 16:21:59','12.249.250.150','12.249.250.150','closed',10,617,'attendances/1450/1689858254 clock_in.png','attendances/1450/1689895319 clock_out.png',NULL,36774,NULL,'2023-07-20 10:04:14','2023-07-20 20:21:59'),(455,'2023-07-20 06:27:28','2023-07-20 16:51:37','12.249.250.150','12.249.250.150','closed',10,624,'attendances/1953/1689859648 clock_in.png','attendances/1953/1689897097 clock_out.png',NULL,36776,NULL,'2023-07-20 10:27:28','2023-07-20 20:51:37'),(457,'2023-07-20 06:53:42','2023-07-20 15:33:39','12.249.250.150','12.249.250.150','closed',8,519,'attendances/622/1689861222 clock_in.png','attendances/622/1689892419 clock_out.png',NULL,NULL,NULL,'2023-07-20 10:53:42','2023-07-20 19:33:39'),(458,'2023-07-20 06:53:56','2023-07-20 15:36:17','12.249.250.150','12.249.250.150','closed',8,522,'attendances/1375/1689861236 clock_in.png','attendances/1375/1689892577 clock_out.png',NULL,NULL,NULL,'2023-07-20 10:53:56','2023-07-20 19:36:17'),(459,'2023-07-20 06:54:12','2023-07-20 17:34:31','12.249.250.150','12.249.250.150','closed',10,640,'attendances/726/1689861252 clock_in.png','attendances/726/1689899671 clock_out.png',NULL,NULL,NULL,'2023-07-20 10:54:12','2023-07-20 21:34:31'),(460,'2023-07-20 06:54:24','2023-07-20 15:35:46','12.249.250.150','12.249.250.150','closed',8,521,'attendances/1948/1689861264 clock_in.png','attendances/1948/1689892546 clock_out.png',NULL,NULL,NULL,'2023-07-20 10:54:24','2023-07-20 19:35:46'),(461,'2023-07-20 06:54:40','2023-07-20 16:19:09','12.249.250.150','12.249.250.150','closed',9,564,'attendances/1395/1689861280 clock_in.png','attendances/1395/1689895149 clock_out.png',NULL,NULL,NULL,'2023-07-20 10:54:40','2023-07-20 20:19:09'),(462,'2023-07-20 06:54:51','2023-07-20 15:36:48','12.249.250.150','12.249.250.150','closed',8,521,'attendances/1374/1689861291 clock_in.png','attendances/1374/1689892608 clock_out.png',NULL,NULL,NULL,'2023-07-20 10:54:51','2023-07-20 19:36:48'),(463,'2023-07-20 06:55:03','2023-07-20 16:50:56','12.249.250.150','12.249.250.150','closed',9,595,'attendances/1724/1689861303 clock_in.png','attendances/1724/1689897056 clock_out.png',NULL,NULL,NULL,'2023-07-20 10:55:03','2023-07-20 20:50:56'),(464,'2023-07-20 06:55:15',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1728/1689861315 clock_in.png',NULL,NULL,NULL,NULL,'2023-07-20 10:55:15','2023-07-20 10:55:15'),(465,'2023-07-20 06:55:25','2023-07-20 15:33:22','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1568/1689861325 clock_in.png','attendances/1568/1689892402 clock_out.png',NULL,NULL,NULL,'2023-07-20 10:55:25','2023-07-20 19:33:22'),(466,'2023-07-20 06:55:27','2023-07-20 15:33:52','12.249.250.150','12.249.250.150','closed',8,518,'attendances/1934/1689861327 clock_in.png','attendances/1934/1689892432 clock_out.png',NULL,NULL,NULL,'2023-07-20 10:55:27','2023-07-20 19:33:52'),(467,'2023-07-20 06:55:44','2023-07-20 15:31:18','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1965/1689861344 clock_in.png','attendances/1965/1689892278 clock_out.png',NULL,NULL,NULL,'2023-07-20 10:55:44','2023-07-20 19:31:18'),(468,'2023-07-20 06:55:59','2023-07-20 16:54:41','12.249.250.150','12.249.250.150','closed',9,598,'attendances/974/1689861359 clock_in.png','attendances/974/1689897281 clock_out.png',NULL,NULL,NULL,'2023-07-20 10:55:59','2023-07-20 20:54:41'),(469,'2023-07-20 06:56:16','2023-07-20 16:50:35','12.249.250.150','12.249.250.150','closed',9,594,'attendances/1479/1689861376 clock_in.png','attendances/1479/1689897035 clock_out.png',NULL,NULL,NULL,'2023-07-20 10:56:16','2023-07-20 20:50:35'),(470,'2023-07-20 06:56:35','2023-07-20 15:34:12','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1858/1689861395 clock_in.png','attendances/1858/1689892452 clock_out.png',NULL,NULL,NULL,'2023-07-20 10:56:35','2023-07-20 19:34:12'),(471,'2023-07-20 06:56:49','2023-07-20 15:35:09','12.249.250.150','12.249.250.150','closed',8,518,'attendances/1898/1689861409 clock_in.png','attendances/1898/1689892509 clock_out.png',NULL,NULL,NULL,'2023-07-20 10:56:49','2023-07-20 19:35:09'),(472,'2023-07-20 06:57:49','2023-07-20 15:34:35','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1958/1689861470 clock_in.png','attendances/1958/1689892475 clock_out.png',NULL,NULL,NULL,'2023-07-20 10:57:50','2023-07-20 19:34:35'),(473,'2023-07-20 07:02:50','2023-07-20 16:37:49','12.249.250.150','12.249.250.150','closed',9,574,'attendances/1988/1689861770 clock_in.png','attendances/1988/1689896269 clock_out.png',NULL,36795,NULL,'2023-07-20 11:02:50','2023-07-20 20:37:49'),(474,'2023-07-20 07:04:20','2023-07-20 15:37:16','12.249.250.150','12.249.250.150','closed',8,512,'attendances/1462/1689861860 clock_in.png','attendances/1462/1689892636 clock_out.png',NULL,36784,NULL,'2023-07-20 11:04:20','2023-07-20 19:37:16'),(475,'2023-07-20 07:58:03','2023-07-20 16:29:52','12.249.250.150','12.249.250.150','closed',8,511,'attendances/775/1689865083 clock_in.png','attendances/775/1689895792 clock_out.png',NULL,NULL,NULL,'2023-07-20 11:58:03','2023-07-20 20:29:52'),(476,'2023-07-20 08:01:34','2023-07-20 16:30:49','12.249.250.150','12.249.250.150','closed',8,509,'attendances/1492/1689865294 clock_in.png','attendances/1492/1689895849 clock_out.png',NULL,36798,NULL,'2023-07-20 12:01:34','2023-07-20 20:30:49'),(477,'2023-07-20 08:02:19','2023-07-20 16:32:46','12.249.250.150','12.249.250.150','closed',8,510,'attendances/1891/1689865339 clock_in.png','attendances/1891/1689895966 clock_out.png',NULL,36797,NULL,'2023-07-20 12:02:19','2023-07-20 20:32:46'),(480,'2023-07-20 17:27:37','2023-07-20 18:38:28','12.249.250.150','12.249.250.150','closed',1,70,'attendances/974/1689899257 clock_in.png','attendances/974/1689903508 clock_out.png',NULL,NULL,NULL,'2023-07-20 21:27:37','2023-07-20 22:38:28'),(481,'2023-07-21 04:01:29','2023-07-21 20:23:59','12.249.250.150','12.249.250.150','closed',16,982,'attendances/1953/1689937289 clock_in.png','attendances/1953/1689996239 clock_out.png',NULL,NULL,NULL,'2023-07-21 08:01:29','2023-07-22 00:23:59'),(482,'2023-07-21 04:55:12','2023-07-21 16:39:21','12.249.250.150','12.249.250.150','closed',11,704,'attendances/1479/1689940512 clock_in.png','attendances/1479/1689982761 clock_out.png',NULL,NULL,NULL,'2023-07-21 08:55:12','2023-07-21 20:39:21'),(483,'2023-07-21 06:52:51','2023-07-21 19:21:17','12.249.250.150','12.249.250.150','closed',12,748,'attendances/1588/1689947571 clock_in.png','attendances/1588/1689992477 clock_out.png',NULL,NULL,NULL,'2023-07-21 10:52:51','2023-07-21 23:21:17'),(484,'2023-07-21 06:53:09','2023-07-21 16:27:36','12.249.250.150','12.249.250.150','closed',9,574,'attendances/726/1689947589 clock_in.png','attendances/726/1689982056 clock_out.png',NULL,NULL,NULL,'2023-07-21 10:53:09','2023-07-21 20:27:36'),(485,'2023-07-21 06:53:24','2023-07-21 15:38:34','12.249.250.150','12.249.250.150','closed',8,525,'attendances/1898/1689947604 clock_in.png','attendances/1898/1689979114 clock_out.png',NULL,NULL,NULL,'2023-07-21 10:53:24','2023-07-21 19:38:34'),(486,'2023-07-21 06:53:46','2023-07-21 15:35:46','12.249.250.150','12.249.250.150','closed',8,522,'attendances/1116/1689947626 clock_in.png','attendances/1116/1689978946 clock_out.png',NULL,NULL,NULL,'2023-07-21 10:53:46','2023-07-21 19:35:46'),(487,'2023-07-21 06:54:06','2023-07-21 15:31:45','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1455/1689947646 clock_in.png','attendances/1455/1689978705 clock_out.png',NULL,NULL,NULL,'2023-07-21 10:54:06','2023-07-21 19:31:45'),(488,'2023-07-21 06:54:18','2023-07-21 16:11:52','12.249.250.150','12.249.250.150','closed',9,557,'attendances/1395/1689947658 clock_in.png','attendances/1395/1689981112 clock_out.png',NULL,NULL,NULL,'2023-07-21 10:54:18','2023-07-21 20:11:52'),(489,'2023-07-21 06:54:39','2023-07-21 20:04:23','12.249.250.150','12.249.250.150','closed',13,789,'attendances/1585/1689947679 clock_in.png','attendances/1585/1689995063 clock_out.png',NULL,NULL,NULL,'2023-07-21 10:54:39','2023-07-22 00:04:23'),(490,'2023-07-21 06:54:43','2023-07-21 15:32:13','12.249.250.150','12.249.250.150','closed',8,517,'attendances/2025/1689947683 clock_in.png','attendances/2025/1689978733 clock_out.png',NULL,NULL,NULL,'2023-07-21 10:54:43','2023-07-21 19:32:13'),(491,'2023-07-21 06:54:56','2023-07-21 15:33:01','12.249.250.150','12.249.250.150','closed',8,518,'attendances/1965/1689947696 clock_in.png','attendances/1965/1689978781 clock_out.png',NULL,NULL,NULL,'2023-07-21 10:54:56','2023-07-21 19:33:01'),(492,'2023-07-21 06:55:13','2023-07-21 19:22:05','12.249.250.150','12.249.250.150','closed',12,746,'attendances/1551/1689947713 clock_in.png','attendances/1551/1689992525 clock_out.png',NULL,NULL,NULL,'2023-07-21 10:55:13','2023-07-21 23:22:05'),(493,'2023-07-21 06:55:23',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1568/1689947723 clock_in.png',NULL,NULL,NULL,NULL,'2023-07-21 10:55:23','2023-07-21 10:55:23'),(494,'2023-07-21 06:55:24','2023-07-21 15:30:35','12.249.250.150','12.249.250.150','closed',8,515,'attendances/2021/1689947724 clock_in.png','attendances/2021/1689978635 clock_out.png',NULL,NULL,NULL,'2023-07-21 10:55:24','2023-07-21 19:30:35'),(495,'2023-07-21 06:56:38',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1374/1689947798 clock_in.png',NULL,NULL,NULL,NULL,'2023-07-21 10:56:38','2023-07-21 10:56:38'),(496,'2023-07-21 06:56:41','2023-07-21 15:33:16','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1375/1689947801 clock_in.png','attendances/1375/1689978796 clock_out.png',NULL,NULL,NULL,'2023-07-21 10:56:41','2023-07-21 19:33:16'),(497,'2023-07-21 06:56:59','2023-07-21 15:35:32','12.249.250.150','12.249.250.150','closed',8,518,'attendances/1948/1689947819 clock_in.png','attendances/1948/1689978932 clock_out.png',NULL,NULL,NULL,'2023-07-21 10:56:59','2023-07-21 19:35:32'),(498,'2023-07-21 06:56:59','2023-07-21 16:08:48','12.249.250.150','12.249.250.150','closed',9,551,'attendances/1724/1689947819 clock_in.png','attendances/1724/1689980928 clock_out.png',NULL,NULL,NULL,'2023-07-21 10:56:59','2023-07-21 20:08:48'),(499,'2023-07-21 06:57:12','2023-07-21 15:33:41','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1934/1689947832 clock_in.png','attendances/1934/1689978821 clock_out.png',NULL,NULL,NULL,'2023-07-21 10:57:12','2023-07-21 19:33:41'),(500,'2023-07-21 06:57:27','2023-07-21 16:09:10','12.249.250.150','12.249.250.150','closed',9,551,'attendances/1728/1689947847 clock_in.png','attendances/1728/1689980950 clock_out.png',NULL,NULL,NULL,'2023-07-21 10:57:27','2023-07-21 20:09:10'),(501,'2023-07-21 06:57:31','2023-07-21 15:34:03','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1958/1689947851 clock_in.png','attendances/1958/1689978843 clock_out.png',NULL,NULL,NULL,'2023-07-21 10:57:31','2023-07-21 19:34:03'),(502,'2023-07-21 06:58:10','2023-07-21 15:34:50','12.249.250.150','12.249.250.150','closed',8,516,'attendances/974/1689947890 clock_in.png','attendances/974/1689978891 clock_out.png',NULL,NULL,NULL,'2023-07-21 10:58:10','2023-07-21 19:34:51'),(503,'2023-07-21 06:59:56','2023-07-21 16:03:53','12.249.250.150','12.249.250.150','closed',9,543,'attendances/1867/1689947996 clock_in.png','attendances/1867/1689980633 clock_out.png',NULL,NULL,NULL,'2023-07-21 10:59:56','2023-07-21 20:03:53'),(504,'2023-07-21 07:00:37','2023-07-21 16:10:34','12.249.250.150','12.249.250.150','closed',9,549,'attendances/1636/1689948037 clock_in.png','attendances/1636/1689981034 clock_out.png',NULL,36821,NULL,'2023-07-21 11:00:37','2023-07-21 20:10:34'),(505,'2023-07-21 07:02:58','2023-07-21 15:41:14','12.249.250.150','12.249.250.150','closed',8,518,'attendances/1450/1689948178 clock_in.png','attendances/1450/1689979274 clock_out.png',NULL,36832,NULL,'2023-07-21 11:02:58','2023-07-21 19:41:14'),(506,'2023-07-21 07:04:45','2023-07-21 15:34:18','12.249.250.150','12.249.250.150','closed',8,509,'attendances/1858/1689948285 clock_in.png','attendances/1858/1689978858 clock_out.png',NULL,36825,NULL,'2023-07-21 11:04:45','2023-07-21 19:34:18'),(507,'2023-07-21 07:59:22','2023-07-21 16:31:58','12.249.250.150','12.249.250.150','closed',8,512,'attendances/1869/1689951562 clock_in.png','attendances/1869/1689982318 clock_out.png',NULL,NULL,NULL,'2023-07-21 11:59:22','2023-07-21 20:31:58'),(508,'2023-07-21 08:02:42','2023-07-21 16:31:22','12.249.250.150','12.249.250.150','closed',8,508,'attendances/1492/1689951762 clock_in.png','attendances/1492/1689982282 clock_out.png',NULL,36837,NULL,'2023-07-21 12:02:42','2023-07-21 20:31:22'),(509,'2023-07-21 08:31:10','2023-07-21 16:51:38','12.249.250.150','12.249.250.150','closed',8,500,'attendances/1988/1689953470 clock_in.png','attendances/1988/1689983498 clock_out.png',NULL,36835,NULL,'2023-07-21 12:31:10','2023-07-21 20:51:38'),(510,'2023-07-22 07:00:03','2023-07-22 11:03:11','12.249.250.150','12.249.250.150','closed',4,243,'attendances/974/1690034403 clock_in.png','attendances/974/1690048991 clock_out.png',NULL,36874,NULL,'2023-07-22 11:00:03','2023-07-22 15:03:11'),(511,'2023-07-22 07:00:20','2023-07-22 13:00:42','12.249.250.150','12.249.250.150','closed',6,360,'attendances/1585/1690034420 clock_in.png','attendances/1585/1690056042 clock_out.png',NULL,36875,NULL,'2023-07-22 11:00:20','2023-07-22 17:00:42'),(512,'2023-07-22 07:00:48','2023-07-22 13:59:00','12.249.250.150','12.249.250.150','closed',6,418,'attendances/1774/1690034448 clock_in.png','attendances/1774/1690059540 clock_out.png',NULL,36876,NULL,'2023-07-22 11:00:48','2023-07-22 17:59:00'),(513,'2023-07-22 11:32:52','2023-07-22 13:00:57','12.249.250.150','12.249.250.150','closed',1,88,'attendances/974/1690050772 clock_in.png','attendances/974/1690056057 clock_out.png',NULL,36874,NULL,'2023-07-22 15:32:52','2023-07-22 17:00:57'),(514,'2023-07-22 11:58:33','2023-07-22 18:06:34','12.249.250.150','12.249.250.150','closed',6,368,'attendances/1867/1690052313 clock_in.png','attendances/1867/1690074394 clock_out.png',NULL,NULL,NULL,'2023-07-22 15:58:33','2023-07-22 22:06:34'),(515,'2023-07-22 14:03:00','2023-07-22 19:19:12','12.249.250.150','12.249.250.150','closed',5,316,'attendances/1455/1690059780 clock_in.png','attendances/1455/1690078752 clock_out.png',NULL,36878,NULL,'2023-07-22 18:03:00','2023-07-22 23:19:12'),(516,'2023-07-22 22:04:19',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1867/1690088659 clock_in.png',NULL,NULL,NULL,NULL,'2023-07-23 02:04:19','2023-07-23 02:04:19'),(517,'2023-07-22 22:57:48','2023-07-23 00:00:00','12.249.250.150','190.2.214.172','closed',1,62,'attendances/1585/1690091868 clock_in.png','attendances/1585/1690095600 clock_out.png',NULL,NULL,NULL,'2023-07-23 02:57:48','2023-07-23 04:00:00'),(518,'2023-07-22 22:58:40','2023-07-22 23:59:47','12.249.250.150','190.2.214.172','closed',1,61,'attendances/974/1690091920 clock_in.png','attendances/974/1690095587 clock_out.png',NULL,NULL,NULL,'2023-07-23 02:58:40','2023-07-23 03:59:47'),(519,'2023-07-23 00:00:20','2023-07-23 02:18:51','190.2.214.172','12.249.250.150','closed',2,138,'attendances/974/1690095620 clock_in.png','attendances/974/1690103931 clock_out.png',NULL,NULL,NULL,'2023-07-23 04:00:20','2023-07-23 06:18:51'),(520,'2023-07-23 00:00:38','2023-07-23 02:18:33','190.2.214.172','12.249.250.150','closed',2,137,'attendances/1585/1690095638 clock_in.png','attendances/1585/1690103913 clock_out.png',NULL,NULL,NULL,'2023-07-23 04:00:38','2023-07-23 06:18:33'),(521,'2023-07-23 00:50:16',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1867/1690098616 clock_in.png',NULL,NULL,NULL,NULL,'2023-07-23 04:50:16','2023-07-23 04:50:16'),(522,'2023-07-23 05:51:30','2023-07-23 12:06:33','12.249.250.150','12.249.250.150','closed',6,375,'attendances/1116/1690116691 clock_in.png','attendances/1116/1690139193 clock_out.png',NULL,NULL,NULL,'2023-07-23 09:51:31','2023-07-23 16:06:33'),(523,'2023-07-23 06:16:48',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1636/1690118208 clock_in.png',NULL,NULL,36879,NULL,'2023-07-23 10:16:48','2023-07-23 10:16:48'),(524,'2023-07-23 12:58:18',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1395/1690142298 clock_in.png',NULL,NULL,NULL,NULL,'2023-07-23 16:58:18','2023-07-23 16:58:18'),(525,'2023-07-23 13:01:01',NULL,'12.249.250.150','','pending',NULL,NULL,'attendances/1450/1690142461 clock_in.png',NULL,NULL,36882,NULL,'2023-07-23 17:01:01','2023-07-23 17:01:01'),(526,'2023-07-24 05:56:36','2023-07-24 16:01:16','12.249.250.150','12.249.250.150','closed',10,604,'attendances/382/1690203396 clock_in.png','attendances/382/1690239676 clock_out.png',NULL,NULL,NULL,'2023-07-24 09:56:36','2023-07-24 20:01:16'),(527,'2023-07-24 05:56:59','2023-07-24 14:50:36','12.249.250.150','12.249.250.150','closed',8,533,'attendances/726/1690203419 clock_in.png','attendances/726/1690235436 clock_out.png',NULL,NULL,NULL,'2023-07-24 09:56:59','2023-07-24 18:50:36'),(529,'2023-07-24 06:54:40','2023-07-24 15:34:07','12.249.250.150','12.249.250.150','closed',8,519,'attendances/1858/1690206880 clock_in.png','attendances/1858/1690238048 clock_out.png',NULL,NULL,NULL,'2023-07-24 10:54:40','2023-07-24 19:34:08'),(531,'2023-07-24 06:54:55','2023-07-24 14:27:06','12.249.250.150','12.249.250.150','closed',7,452,'attendances/2025/1690206895 clock_in.png','attendances/2025/1690234026 clock_out.png',NULL,NULL,NULL,'2023-07-24 10:54:55','2023-07-24 18:27:06'),(532,'2023-07-24 06:54:59','2023-07-24 15:35:13','12.249.250.150','12.249.250.150','closed',8,520,'attendances/1116/1690206899 clock_in.png','attendances/1116/1690238113 clock_out.png',NULL,NULL,NULL,'2023-07-24 10:54:59','2023-07-24 19:35:13'),(537,'2023-07-24 06:55:53','2023-07-24 15:36:17','12.249.250.150','12.249.250.150','closed',8,520,'attendances/1965/1690206953 clock_in.png','attendances/1965/1690238177 clock_out.png',NULL,NULL,NULL,'2023-07-24 10:55:53','2023-07-24 19:36:17'),(538,'2023-07-24 06:56:27','2023-07-24 15:38:16','12.249.250.150','12.249.250.150','closed',8,521,'attendances/1948/1690206987 clock_in.png','attendances/1948/1690223716 clock_out.png',NULL,NULL,NULL,'2023-07-24 10:56:27','2023-07-31 12:38:38'),(542,'2023-07-24 06:56:49','2023-07-24 15:40:00','12.249.250.150','','closed',8,523,'attendances/1728/1690207009 clock_in.png',NULL,NULL,NULL,NULL,'2023-07-24 10:56:49','2023-07-29 00:12:39'),(543,'2023-07-24 06:57:05','2023-07-24 15:40:56','12.249.250.150','12.249.250.150','closed',8,523,'attendances/1898/1690207025 clock_in.png','attendances/1898/1690238456 clock_out.png',NULL,NULL,NULL,'2023-07-24 10:57:05','2023-07-24 19:40:56'),(544,'2023-07-24 06:57:12','2023-07-24 16:37:46','12.249.250.150','12.249.250.150','closed',9,580,'attendances/1953/1690207032 clock_in.png','attendances/1953/1690241866 clock_out.png',NULL,NULL,NULL,'2023-07-24 10:57:12','2023-07-24 20:37:46'),(545,'2023-07-24 06:57:25','2023-07-24 15:30:00','12.249.250.150','','closed',8,512,'attendances/1724/1690207045 clock_in.png',NULL,NULL,NULL,NULL,'2023-07-24 10:57:25','2023-07-28 21:08:40'),(546,'2023-07-24 06:57:33','2023-07-24 15:32:35','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1568/1690207053 clock_in.png','attendances/1568/1690237955 clock_out.png',NULL,NULL,NULL,'2023-07-24 10:57:33','2023-07-24 19:32:35'),(547,'2023-07-24 06:57:41','2023-07-24 15:33:21','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1958/1690207061 clock_in.png','attendances/1958/1690238001 clock_out.png',NULL,NULL,NULL,'2023-07-24 10:57:41','2023-07-24 19:33:21'),(548,'2023-07-24 06:57:58','2023-07-24 15:32:57','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1455/1690207078 clock_in.png','attendances/1455/1690237977 clock_out.png',NULL,NULL,NULL,'2023-07-24 10:57:58','2023-07-24 19:32:57'),(549,'2023-07-24 06:58:06','2023-07-24 15:34:50','12.249.250.150','12.249.250.150','closed',8,516,'attendances/622/1690207086 clock_in.png','attendances/622/1690238090 clock_out.png',NULL,NULL,NULL,'2023-07-24 10:58:06','2023-07-24 19:34:50'),(550,'2023-07-24 06:58:28','2023-07-24 15:32:15','12.249.250.150','12.249.250.150','closed',8,513,'attendances/1374/1690207108 clock_in.png','attendances/1374/1690237935 clock_out.png',NULL,NULL,NULL,'2023-07-24 10:58:28','2023-07-24 19:32:15'),(551,'2023-07-24 07:00:35','2023-07-24 15:34:37','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1999/1690207235 clock_in.png','attendances/1999/1690238077 clock_out.png',NULL,36892,NULL,'2023-07-24 11:00:35','2023-07-24 19:34:37'),(552,'2023-07-24 07:01:49','2023-07-24 15:30:51','12.249.250.150','12.249.250.150','closed',8,509,'attendances/1951/1690207309 clock_in.png','attendances/1951/1690237851 clock_out.png',NULL,36888,NULL,'2023-07-24 11:01:49','2023-07-24 19:30:51'),(553,'2023-07-24 07:07:45','2023-07-24 15:40:02','12.249.250.150','12.249.250.150','closed',8,512,'attendances/1462/1690207665 clock_in.png','attendances/1462/1690238402 clock_out.png',NULL,36893,NULL,'2023-07-24 11:07:45','2023-07-24 19:40:02'),(554,'2023-07-24 07:56:26','2023-07-24 15:33:46','12.249.250.150','12.249.250.150','closed',7,457,'attendances/1774/1690210586 clock_in.png','attendances/1774/1690238026 clock_out.png',NULL,36907,NULL,'2023-07-24 11:56:26','2023-07-24 19:33:46'),(555,'2023-07-24 07:57:35','2023-07-24 16:30:40','12.249.250.150','12.249.250.150','closed',8,513,'attendances/775/1690210655 clock_in.png','attendances/775/1690241440 clock_out.png',NULL,36908,NULL,'2023-07-24 11:57:35','2023-07-24 20:30:40'),(556,'2023-07-24 07:59:34','2023-07-24 16:30:25','12.249.250.150','12.249.250.150','closed',8,510,'attendances/1492/1690210774 clock_in.png','attendances/1492/1690241425 clock_out.png',NULL,36909,NULL,'2023-07-24 11:59:34','2023-07-24 20:30:25'),(557,'2023-07-24 08:03:07','2023-07-24 16:32:55','12.249.250.150','12.249.250.150','closed',8,509,'attendances/1869/1690210987 clock_in.png','attendances/1869/1690241575 clock_out.png',NULL,36906,NULL,'2023-07-24 12:03:07','2023-07-24 20:32:55'),(558,'2023-07-24 08:30:34','2023-07-24 17:07:16','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1988/1690212634 clock_in.png','attendances/1988/1690243636 clock_out.png',NULL,36910,NULL,'2023-07-24 12:30:34','2023-07-24 21:07:16'),(559,'2023-07-24 06:56:14','2023-07-24 15:34:24','12.249.250.150','12.249.250.150','closed',8,518,'attendances/1934/1690222328 clock_in.png','attendances/1934/1690238064 clock_out.png',NULL,36894,NULL,'2023-07-24 15:12:08','2023-07-24 19:34:24'),(560,'2023-07-24 06:00:15','2023-07-24 14:51:00','12.249.250.150','','closed',8,530,'attendances/1450/1690235482 clock_in.png',NULL,NULL,NULL,NULL,'2023-07-24 18:51:22','2023-07-28 21:04:05'),(561,'2023-07-24 06:00:32','2023-07-24 16:03:45','12.249.250.150','12.249.250.150','closed',10,603,'attendances/2005/1690239812 clock_in.png','attendances/2005/1690239825 clock_out.png',NULL,NULL,NULL,'2023-07-24 20:03:32','2023-07-28 21:11:21'),(562,'2023-07-25 05:55:38','2023-07-25 14:25:04','12.249.250.150','12.249.250.150','closed',8,509,'attendances/2005/1690289738 clock_in.png','attendances/2005/1690320304 clock_out.png',NULL,36931,NULL,'2023-07-25 09:55:38','2023-07-25 18:25:04'),(563,'2023-07-25 05:55:58','2023-07-25 14:32:48','12.249.250.150','12.249.250.150','closed',8,516,'attendances/382/1690289758 clock_in.png','attendances/382/1690320768 clock_out.png',NULL,36930,NULL,'2023-07-25 09:55:58','2023-07-25 18:32:48'),(564,'2023-07-25 05:56:10','2023-07-25 14:28:59','12.249.250.150','12.249.250.150','closed',8,512,'attendances/974/1690289770 clock_in.png','attendances/974/1690320539 clock_out.png',NULL,36928,NULL,'2023-07-25 09:56:10','2023-07-25 18:28:59'),(565,'2023-07-25 05:58:23','2023-07-25 14:32:09','12.249.250.150','12.249.250.150','closed',8,513,'attendances/1479/1690289903 clock_in.png','attendances/1479/1690320729 clock_out.png',NULL,36929,NULL,'2023-07-25 09:58:24','2023-07-25 18:32:09'),(566,'2023-07-25 05:55:13','2023-07-25 14:30:48','12.249.250.150','12.249.250.150','closed',8,497,'attendances/2021/1690290793 clock_in.png','attendances/2021/1690320648 clock_out.png',NULL,36932,NULL,'2023-07-25 10:13:13','2023-08-02 12:57:56'),(567,'2023-07-25 06:52:26','2023-07-25 15:30:08','12.249.250.150','12.249.250.150','closed',8,517,'attendances/622/1690293146 clock_in.png','attendances/622/1690324208 clock_out.png',NULL,36948,NULL,'2023-07-25 10:52:26','2023-07-25 19:30:08'),(568,'2023-07-25 06:53:56','2023-07-25 15:34:09','12.249.250.150','12.249.250.150','closed',8,520,'attendances/1965/1690293236 clock_in.png','attendances/1965/1690324449 clock_out.png',NULL,36947,NULL,'2023-07-25 10:53:56','2023-07-25 19:34:09'),(569,'2023-07-25 06:54:05','2023-07-25 15:32:10','12.249.250.150','12.249.250.150','closed',8,518,'attendances/1585/1690293245 clock_in.png','attendances/1585/1690324330 clock_out.png',NULL,36933,NULL,'2023-07-25 10:54:05','2023-07-25 19:32:10'),(570,'2023-07-25 06:54:21','2023-07-25 15:31:53','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1934/1690293261 clock_in.png','attendances/1934/1690324313 clock_out.png',NULL,36942,NULL,'2023-07-25 10:54:21','2023-07-25 19:31:53'),(571,'2023-07-25 06:54:44','2023-07-25 15:30:40','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1375/1690293284 clock_in.png','attendances/1375/1690324240 clock_out.png',NULL,36944,NULL,'2023-07-25 10:54:44','2023-07-25 19:30:40'),(572,'2023-07-25 06:54:47','2023-07-25 15:37:17','12.249.250.150','12.249.250.150','closed',8,522,'attendances/1948/1690293287 clock_in.png','attendances/1948/1690324637 clock_out.png',NULL,36946,NULL,'2023-07-25 10:54:47','2023-07-25 19:37:17'),(573,'2023-07-25 06:55:00','2023-07-25 15:31:52','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1568/1690293300 clock_in.png','attendances/1568/1690324312 clock_out.png',NULL,36934,NULL,'2023-07-25 10:55:00','2023-07-25 19:31:52'),(574,'2023-07-25 06:56:02','2023-07-25 15:36:37','12.249.250.150','12.249.250.150','closed',8,520,'attendances/1999/1690293362 clock_in.png','attendances/1999/1690324597 clock_out.png',NULL,36940,NULL,'2023-07-25 10:56:02','2023-07-25 19:36:37'),(575,'2023-07-25 06:56:58','2023-07-25 15:36:10','12.249.250.150','12.249.250.150','closed',8,519,'attendances/1898/1690293418 clock_in.png','attendances/1898/1690324570 clock_out.png',NULL,36936,NULL,'2023-07-25 10:56:58','2023-07-25 19:36:10'),(576,'2023-07-25 06:57:44','2023-07-25 15:34:49','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1395/1690293464 clock_in.png','attendances/1395/1690324489 clock_out.png',NULL,36945,NULL,'2023-07-25 10:57:44','2023-07-25 19:34:49'),(577,'2023-07-25 06:58:26','2023-07-25 15:30:42','12.249.250.150','12.249.250.150','closed',8,512,'attendances/1374/1690293506 clock_in.png','attendances/1374/1690324242 clock_out.png',NULL,36938,NULL,'2023-07-25 10:58:26','2023-07-25 19:30:42'),(578,'2023-07-25 06:58:47','2023-07-25 15:38:34','12.249.250.150','12.249.250.150','closed',8,519,'attendances/1888/1690293527 clock_in.png','attendances/1888/1690309834 clock_out.png',NULL,36949,NULL,'2023-07-25 10:58:47','2023-08-02 10:37:13'),(579,'2023-07-25 06:59:33','2023-07-25 18:43:50','12.249.250.150','12.249.250.150','closed',11,704,'attendances/1636/1690293573 clock_in.png','attendances/1636/1690335830 clock_out.png',NULL,36939,NULL,'2023-07-25 10:59:33','2023-07-25 22:43:50'),(580,'2023-07-25 07:00:39','2023-07-25 15:34:44','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1462/1690293639 clock_in.png','attendances/1462/1690324484 clock_out.png',NULL,36941,NULL,'2023-07-25 11:00:39','2023-07-25 19:34:44'),(581,'2023-07-25 07:00:52','2023-07-25 15:32:26','12.249.250.150','12.249.250.150','closed',8,511,'attendances/1958/1690293652 clock_in.png','attendances/1958/1690324346 clock_out.png',NULL,36937,NULL,'2023-07-25 11:00:52','2023-07-25 19:32:26'),(582,'2023-07-25 07:04:18','2023-07-25 15:31:20','12.249.250.150','12.249.250.150','closed',8,507,'attendances/1951/1690293858 clock_in.png','attendances/1951/1690324280 clock_out.png',NULL,36935,NULL,'2023-07-25 11:04:18','2023-07-25 19:31:20'),(583,'2023-07-25 07:07:05','2023-07-25 15:32:49','12.249.250.150','12.249.250.150','closed',8,505,'attendances/1858/1690294025 clock_in.png','attendances/1858/1690324369 clock_out.png',NULL,36943,NULL,'2023-07-25 11:07:05','2023-07-25 19:32:49'),(584,'2023-07-25 07:58:24','2023-07-25 16:30:00','12.249.250.150','','closed',8,511,'attendances/775/1690297104 clock_in.png',NULL,NULL,36951,NULL,'2023-07-25 11:58:24','2023-07-29 00:19:06'),(585,'2023-07-25 08:00:53','2023-07-25 16:33:02','12.249.250.150','12.249.250.150','closed',8,512,'attendances/1869/1690297254 clock_in.png','attendances/1869/1690327982 clock_out.png',NULL,36950,NULL,'2023-07-25 12:00:54','2023-07-25 20:33:02'),(586,'2023-07-25 08:01:40','2023-07-25 16:30:41','12.249.250.150','12.249.250.150','closed',8,509,'attendances/1492/1690297300 clock_in.png','attendances/1492/1690327841 clock_out.png',NULL,36952,NULL,'2023-07-25 12:01:40','2023-07-25 20:30:41'),(587,'2023-07-25 08:30:40','2023-07-25 16:47:58','12.249.250.150','12.249.250.150','closed',8,497,'attendances/1988/1690299040 clock_in.png','attendances/1988/1690328878 clock_out.png',NULL,36953,NULL,'2023-07-25 12:30:40','2023-07-25 20:47:58'),(588,'2023-07-25 09:07:55','2023-07-25 18:13:02','12.249.250.150','12.249.250.150','closed',9,545,'attendances/1867/1690301275 clock_in.png','attendances/1867/1690333982 clock_out.png',NULL,36954,NULL,'2023-07-25 13:07:55','2023-07-25 22:13:02'),(589,'2023-07-25 11:53:56','2023-07-25 19:49:56','12.249.250.150','12.249.250.150','closed',7,476,'attendances/1551/1690311236 clock_in.png','attendances/1551/1690339796 clock_out.png',NULL,NULL,NULL,'2023-07-25 15:53:56','2023-07-25 23:49:56'),(590,'2023-07-25 11:54:13','2023-07-25 19:50:10','12.249.250.150','12.249.250.150','closed',7,475,'attendances/1588/1690311253 clock_in.png','attendances/1588/1690339810 clock_out.png',NULL,NULL,NULL,'2023-07-25 15:54:13','2023-07-25 23:50:10'),(593,'2023-07-26 05:56:04','2023-07-26 14:55:12','12.249.250.150','12.249.250.150','closed',8,539,'attendances/1479/1690376164 clock_in.png','attendances/1479/1690408512 clock_out.png',NULL,36981,NULL,'2023-07-26 09:56:04','2023-07-26 18:55:12'),(594,'2023-07-26 05:50:35','2023-07-26 14:47:57','12.249.250.150','12.249.250.150','closed',8,497,'attendances/726/1690378235 clock_in.png','attendances/726/1690408077 clock_out.png',NULL,36980,NULL,'2023-07-26 10:30:35','2023-07-26 19:11:38'),(595,'2023-07-26 06:00:19','2023-07-26 14:55:00','12.249.250.150','','closed',8,534,'attendances/974/1690378279 clock_in.png',NULL,NULL,36979,NULL,'2023-07-26 10:31:19','2023-07-26 19:21:14'),(596,'2023-07-26 06:54:38','2023-07-26 15:34:22','12.249.250.150','12.249.250.150','closed',8,519,'attendances/1724/1690379678 clock_in.png','attendances/1724/1690410862 clock_out.png',NULL,36995,NULL,'2023-07-26 10:54:38','2023-07-26 19:34:22'),(597,'2023-07-26 06:54:52','2023-07-26 15:35:49','12.249.250.150','12.249.250.150','closed',8,520,'attendances/1728/1690379692 clock_in.png','attendances/1728/1690410949 clock_out.png',NULL,36990,NULL,'2023-07-26 10:54:52','2023-07-26 19:35:49'),(598,'2023-07-26 06:55:57','2023-07-26 15:34:01','12.249.250.150','12.249.250.150','closed',8,518,'attendances/1999/1690379757 clock_in.png','attendances/1999/1690410841 clock_out.png',NULL,36987,NULL,'2023-07-26 10:55:57','2023-07-26 19:34:01'),(599,'2023-07-26 06:56:13','2023-07-26 15:35:13','12.249.250.150','12.249.250.150','closed',8,519,'attendances/1395/1690379773 clock_in.png','attendances/1395/1690410913 clock_out.png',NULL,36994,NULL,'2023-07-26 10:56:13','2023-07-26 19:35:13'),(600,'2023-07-26 06:56:27','2023-07-26 15:34:34','12.249.250.150','12.249.250.150','closed',8,518,'attendances/1898/1690379787 clock_in.png','attendances/1898/1690410874 clock_out.png',NULL,36984,NULL,'2023-07-26 10:56:27','2023-07-26 19:34:34'),(601,'2023-07-26 06:56:48','2023-07-26 15:36:06','12.249.250.150','12.249.250.150','closed',8,519,'attendances/1116/1690379808 clock_in.png','attendances/1116/1690410966 clock_out.png',NULL,36993,NULL,'2023-07-26 10:56:48','2023-07-26 19:36:06'),(602,'2023-07-26 06:57:26','2023-07-26 15:34:55','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1948/1690379846 clock_in.png','attendances/1948/1690410895 clock_out.png',NULL,36996,NULL,'2023-07-26 10:57:26','2023-07-26 19:34:55'),(603,'2023-07-26 06:59:47','2023-07-26 15:29:22','12.249.250.150','12.249.250.150','closed',8,509,'attendances/1951/1690379987 clock_in.png','attendances/1951/1690410562 clock_out.png',NULL,36983,NULL,'2023-07-26 10:59:47','2023-07-26 19:29:22'),(604,'2023-07-26 07:00:10','2023-07-26 15:33:45','12.249.250.150','12.249.250.150','closed',8,513,'attendances/1774/1690380010 clock_in.png','attendances/1774/1690410825 clock_out.png',NULL,36985,NULL,'2023-07-26 11:00:10','2023-07-26 19:33:45'),(605,'2023-07-26 07:01:52','2023-07-26 15:35:32','12.249.250.150','12.249.250.150','closed',8,513,'attendances/1888/1690380112 clock_in.png','attendances/1888/1690410932 clock_out.png',NULL,36999,NULL,'2023-07-26 11:01:52','2023-07-26 19:35:32'),(606,'2023-07-26 07:02:30','2023-07-26 15:32:57','12.249.250.150','12.249.250.150','closed',8,510,'attendances/622/1690380150 clock_in.png','attendances/622/1690410777 clock_out.png',NULL,36998,NULL,'2023-07-26 11:02:30','2023-07-26 19:32:57'),(607,'2023-07-26 07:02:48','2023-07-26 15:32:20','12.249.250.150','12.249.250.150','closed',8,509,'attendances/1934/1690380168 clock_in.png','attendances/1934/1690410740 clock_out.png',NULL,36989,NULL,'2023-07-26 11:02:48','2023-07-26 19:32:20'),(608,'2023-07-26 07:03:00','2023-07-26 15:33:24','12.249.250.150','12.249.250.150','closed',8,510,'attendances/1375/1690380180 clock_in.png','attendances/1375/1690410804 clock_out.png',NULL,36992,NULL,'2023-07-26 11:03:00','2023-07-26 19:33:24'),(609,'2023-07-26 07:04:13','2023-07-26 15:33:36','12.249.250.150','12.249.250.150','closed',8,509,'attendances/1965/1690380253 clock_in.png','attendances/1965/1690410816 clock_out.png',NULL,36997,NULL,'2023-07-26 11:04:13','2023-07-26 19:33:36'),(610,'2023-07-26 07:04:43','2023-07-26 15:38:24','12.249.250.150','12.249.250.150','closed',8,513,'attendances/1462/1690380283 clock_in.png','attendances/1462/1690411104 clock_out.png',NULL,36988,NULL,'2023-07-26 11:04:43','2023-07-26 19:38:24'),(612,'2023-07-26 07:10:30','2023-07-26 15:34:05','12.249.250.150','12.249.250.150','closed',8,503,'attendances/1858/1690380630 clock_in.png','attendances/1858/1690410845 clock_out.png',NULL,36991,NULL,'2023-07-26 11:10:30','2023-07-26 19:34:05'),(615,'2023-07-26 08:00:15','2023-07-26 16:29:59','12.249.250.150','12.249.250.150','closed',8,509,'attendances/775/1690383615 clock_in.png','attendances/775/1690414199 clock_out.png',NULL,37001,NULL,'2023-07-26 12:00:21','2023-07-26 20:29:59'),(616,'2023-07-26 08:00:49','2023-07-26 16:30:14','12.249.250.150','12.249.250.150','closed',8,509,'attendances/1492/1690383649 clock_in.png','attendances/1492/1690414214 clock_out.png',NULL,37002,NULL,'2023-07-26 12:00:49','2023-07-26 20:30:14'),(617,'2023-07-26 08:13:24','2023-07-26 16:32:31','12.249.250.150','12.249.250.150','closed',8,499,'attendances/1869/1690384404 clock_in.png','attendances/1869/1690414351 clock_out.png',NULL,37000,NULL,'2023-07-26 12:13:24','2023-07-26 20:32:31'),(619,'2023-07-26 06:56:57','2023-07-26 15:35:17','12.249.250.150','12.249.250.150','closed',8,518,'attendances/1568/1690410417 clock_in.png','attendances/1568/1690410917 clock_out.png',NULL,36982,NULL,'2023-07-26 19:26:57','2023-07-26 19:35:17'),(620,'2023-07-26 06:58:01','2023-07-26 15:35:52','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1958/1690410726 clock_in.png','attendances/1958/1690410952 clock_out.png',NULL,NULL,NULL,'2023-07-26 19:32:06','2023-07-26 19:35:52'),(621,'2023-07-27 05:31:48','2023-07-27 14:14:10','12.249.250.150','12.249.250.150','closed',8,522,'attendances/1455/1690461108 clock_in.png','attendances/1455/1690492450 clock_out.png',NULL,37004,NULL,'2023-07-27 09:31:48','2023-07-27 18:14:10'),(622,'2023-07-27 05:33:14','2023-07-27 14:15:58','12.249.250.150','12.249.250.150','closed',8,522,'attendances/1450/1690461194 clock_in.png','attendances/1450/1690492558 clock_out.png',NULL,37005,NULL,'2023-07-27 09:33:14','2023-07-27 18:15:58'),(623,'2023-07-27 05:54:34','2023-07-27 14:36:54','12.249.250.150','12.249.250.150','closed',8,522,'attendances/2025/1690462474 clock_in.png','attendances/2025/1690493814 clock_out.png',NULL,37006,NULL,'2023-07-27 09:54:34','2023-07-27 18:36:54'),(624,'2023-07-27 06:54:33','2023-07-27 15:30:03','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1585/1690466073 clock_in.png','attendances/1585/1690497003 clock_out.png',NULL,NULL,NULL,'2023-07-27 10:54:33','2023-07-27 19:30:03'),(625,'2023-07-27 06:54:51','2023-07-27 15:32:48','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1551/1690466091 clock_in.png','attendances/1551/1690497168 clock_out.png',NULL,NULL,NULL,'2023-07-27 10:54:51','2023-07-27 19:32:48'),(626,'2023-07-27 06:54:53','2023-07-27 15:31:13','12.249.250.150','12.249.250.150','closed',8,516,'attendances/2021/1690466093 clock_in.png','attendances/2021/1690497073 clock_out.png',NULL,NULL,NULL,'2023-07-27 10:54:53','2023-07-27 19:31:13'),(627,'2023-07-27 06:55:16','2023-07-27 15:32:25','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1568/1690466116 clock_in.png','attendances/1568/1690497145 clock_out.png',NULL,NULL,NULL,'2023-07-27 10:55:16','2023-07-27 19:32:25'),(628,'2023-07-27 06:55:24','2023-07-27 15:28:34','12.249.250.150','12.249.250.150','closed',8,513,'attendances/2005/1690466124 clock_in.png','attendances/2005/1690496914 clock_out.png',NULL,NULL,NULL,'2023-07-27 10:55:24','2023-07-27 19:28:34'),(629,'2023-07-27 06:55:35','2023-07-27 15:34:13','12.249.250.150','12.249.250.150','closed',8,518,'attendances/1774/1690466135 clock_in.png','attendances/1774/1690497253 clock_out.png',NULL,NULL,NULL,'2023-07-27 10:55:35','2023-07-27 19:34:13'),(630,'2023-07-27 06:55:51','2023-07-27 15:52:10','12.249.250.150','12.249.250.150','closed',8,536,'attendances/1636/1690466151 clock_in.png','attendances/1636/1690498330 clock_out.png',NULL,NULL,NULL,'2023-07-27 10:55:51','2023-07-27 19:52:10'),(631,'2023-07-27 06:55:59','2023-07-27 15:33:46','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1965/1690466159 clock_in.png','attendances/1965/1690497226 clock_out.png',NULL,NULL,NULL,'2023-07-27 10:55:59','2023-07-27 19:33:46'),(632,'2023-07-27 06:56:05','2023-07-27 15:33:25','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1934/1690466165 clock_in.png','attendances/1934/1690497205 clock_out.png',NULL,NULL,NULL,'2023-07-27 10:56:05','2023-07-27 19:33:25'),(633,'2023-07-27 06:56:20','2023-07-27 15:34:35','12.249.250.150','12.249.250.150','closed',8,518,'attendances/622/1690466180 clock_in.png','attendances/622/1690497275 clock_out.png',NULL,NULL,NULL,'2023-07-27 10:56:20','2023-07-27 19:34:35'),(634,'2023-07-27 06:56:21','2023-07-27 15:35:57','12.249.250.150','12.249.250.150','closed',8,519,'attendances/1948/1690466181 clock_in.png','attendances/1948/1690497357 clock_out.png',NULL,NULL,NULL,'2023-07-27 10:56:21','2023-07-27 19:35:57'),(635,'2023-07-27 06:56:38','2023-07-27 15:35:12','12.249.250.150','12.249.250.150','closed',8,518,'attendances/1898/1690466198 clock_in.png','attendances/1898/1690497312 clock_out.png',NULL,NULL,NULL,'2023-07-27 10:56:38','2023-07-27 19:35:12'),(636,'2023-07-27 06:56:54','2023-07-27 16:50:07','12.249.250.150','12.249.250.150','closed',9,593,'attendances/1724/1690466214 clock_in.png','attendances/1724/1690501807 clock_out.png',NULL,NULL,NULL,'2023-07-27 10:56:54','2023-07-27 20:50:07'),(637,'2023-07-27 06:57:08','2023-07-27 16:25:07','12.249.250.150','12.249.250.150','closed',9,567,'attendances/1588/1690466228 clock_in.png','attendances/1588/1690500307 clock_out.png',NULL,NULL,NULL,'2023-07-27 10:57:08','2023-07-27 20:25:07'),(638,'2023-07-27 06:57:19','2023-07-27 15:54:11','12.249.250.150','12.249.250.150','closed',8,536,'attendances/1728/1690466239 clock_in.png','attendances/1728/1690498451 clock_out.png',NULL,NULL,NULL,'2023-07-27 10:57:19','2023-07-27 19:54:11'),(639,'2023-07-27 06:57:32','2023-07-27 15:34:52','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1375/1690466252 clock_in.png','attendances/1375/1690497292 clock_out.png',NULL,NULL,NULL,'2023-07-27 10:57:32','2023-07-27 19:34:52'),(640,'2023-07-27 06:59:49','2023-07-27 15:34:04','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1958/1690466389 clock_in.png','attendances/1958/1690497244 clock_out.png',NULL,NULL,NULL,'2023-07-27 10:59:49','2023-07-27 19:34:04'),(641,'2023-07-27 07:00:36','2023-07-27 16:25:28','12.249.250.150','12.249.250.150','closed',9,564,'attendances/1953/1690466436 clock_in.png','attendances/1953/1690500328 clock_out.png',NULL,NULL,NULL,'2023-07-27 11:00:36','2023-07-27 20:25:28'),(642,'2023-07-27 07:00:38','2023-07-27 15:31:51','12.249.250.150','12.249.250.150','closed',8,511,'attendances/1867/1690466438 clock_in.png','attendances/1867/1690497111 clock_out.png',NULL,NULL,NULL,'2023-07-27 11:00:38','2023-07-27 19:31:51'),(643,'2023-07-27 07:01:36','2023-07-27 15:35:08','12.249.250.150','12.249.250.150','closed',8,513,'attendances/1374/1690466496 clock_in.png','attendances/1374/1690497308 clock_out.png',NULL,NULL,NULL,'2023-07-27 11:01:36','2023-07-27 19:35:08'),(644,'2023-07-27 07:02:16','2023-07-27 15:32:33','12.249.250.150','12.249.250.150','closed',8,510,'attendances/1951/1690466536 clock_in.png','attendances/1951/1690497153 clock_out.png',NULL,NULL,NULL,'2023-07-27 11:02:16','2023-07-27 19:32:33'),(645,'2023-07-27 07:02:55','2023-07-27 03:34:26','12.249.250.150','12.249.250.150','closed',3,208,'attendances/1888/1690466575 clock_in.png','attendances/1888/1690482746 clock_out.png',NULL,NULL,NULL,'2023-07-27 11:02:55','2023-08-02 11:04:36'),(646,'2023-07-27 07:04:41','2023-07-27 15:39:45','12.249.250.150','12.249.250.150','closed',8,515,'attendances/382/1690466681 clock_in.png','attendances/382/1690497585 clock_out.png',NULL,NULL,NULL,'2023-07-27 11:04:41','2023-07-27 19:39:45'),(647,'2023-07-27 07:05:37','2023-07-27 15:36:10','12.249.250.150','12.249.250.150','closed',8,510,'attendances/1462/1690466737 clock_in.png','attendances/1462/1690497370 clock_out.png',NULL,NULL,NULL,'2023-07-27 11:05:37','2023-07-27 19:36:10'),(648,'2023-07-27 07:09:47','2023-07-27 15:33:12','12.249.250.150','12.249.250.150','closed',8,503,'attendances/1858/1690466987 clock_in.png','attendances/1858/1690497192 clock_out.png',NULL,NULL,NULL,'2023-07-27 11:09:47','2023-07-27 19:33:12'),(649,'2023-07-27 08:00:15','2023-07-27 16:29:56','12.249.250.150','12.249.250.150','closed',8,509,'attendances/775/1690470015 clock_in.png','attendances/775/1690500596 clock_out.png',NULL,NULL,NULL,'2023-07-27 12:00:15','2023-07-27 20:29:56'),(650,'2023-07-27 08:02:34','2023-07-27 16:30:04','12.249.250.150','12.249.250.150','closed',8,507,'attendances/1492/1690470154 clock_in.png','attendances/1492/1690500604 clock_out.png',NULL,NULL,NULL,'2023-07-27 12:02:34','2023-07-27 20:30:04'),(651,'2023-07-27 08:29:50','2023-07-27 17:02:10','12.249.250.150','12.249.250.150','closed',8,512,'attendances/1988/1690471790 clock_in.png','attendances/1988/1690502530 clock_out.png',NULL,37035,NULL,'2023-07-27 12:29:50','2023-07-27 21:02:10'),(653,'2023-07-28 05:26:22','2023-07-28 16:04:41','12.249.250.150','12.249.250.150','closed',10,638,'attendances/2021/1690547182 clock_in.png','attendances/2021/1690585481 clock_out.png',NULL,37036,NULL,'2023-07-28 09:26:22','2023-07-28 20:04:41'),(654,'2023-07-28 05:54:08','2023-07-28 14:46:52','12.249.250.150','12.249.250.150','closed',8,532,'attendances/1728/1690548848 clock_in.png','attendances/1728/1690580812 clock_out.png',NULL,37048,NULL,'2023-07-28 09:54:08','2023-07-28 18:46:52'),(655,'2023-07-28 05:55:06','2023-07-28 14:47:05','12.249.250.150','12.249.250.150','closed',8,531,'attendances/1724/1690548906 clock_in.png','attendances/1724/1690580825 clock_out.png',NULL,37052,NULL,'2023-07-28 09:55:06','2023-07-28 18:47:05'),(656,'2023-07-28 06:53:07','2023-07-28 15:31:36','12.249.250.150','12.249.250.150','closed',8,518,'attendances/1116/1690552387 clock_in.png','attendances/1116/1690583496 clock_out.png',NULL,37050,NULL,'2023-07-28 10:53:07','2023-07-28 19:31:36'),(657,'2023-07-28 06:53:54','2023-07-28 16:59:40','12.249.250.150','12.249.250.150','closed',10,605,'attendances/2025/1690552434 clock_in.png','attendances/2025/1690588780 clock_out.png',NULL,37057,NULL,'2023-07-28 10:53:54','2023-07-28 20:59:40'),(658,'2023-07-28 06:54:09','2023-07-28 15:38:40','12.249.250.150','12.249.250.150','closed',8,524,'attendances/1588/1690552449 clock_in.png','attendances/1588/1690583920 clock_out.png',NULL,37042,NULL,'2023-07-28 10:54:09','2023-07-28 19:38:40'),(659,'2023-07-28 06:54:21','2023-07-28 15:37:25','12.249.250.150','12.249.250.150','closed',8,523,'attendances/1898/1690552461 clock_in.png','attendances/1898/1690583845 clock_out.png',NULL,37044,NULL,'2023-07-28 10:54:21','2023-07-28 19:37:25'),(660,'2023-07-28 06:54:32','2023-07-28 16:52:17','12.249.250.150','12.249.250.150','closed',9,597,'attendances/1585/1690552472 clock_in.png','attendances/1585/1690588337 clock_out.png',NULL,37040,NULL,'2023-07-28 10:54:32','2023-07-28 20:52:17'),(661,'2023-07-28 06:54:39','2023-07-28 16:07:36','12.249.250.150','12.249.250.150','closed',9,552,'attendances/726/1690552479 clock_in.png','attendances/726/1690585656 clock_out.png',NULL,37038,NULL,'2023-07-28 10:54:39','2023-07-28 20:07:36'),(662,'2023-07-28 06:55:01','2023-07-28 15:34:06','12.249.250.150','12.249.250.150','closed',8,519,'attendances/1479/1690552501 clock_in.png','attendances/1479/1690583646 clock_out.png',NULL,37043,NULL,'2023-07-28 10:55:01','2023-07-28 19:34:06'),(663,'2023-07-28 06:55:22','2023-07-28 15:33:17','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1774/1690552522 clock_in.png','attendances/1774/1690583597 clock_out.png',NULL,37045,NULL,'2023-07-28 10:55:22','2023-07-28 19:33:17'),(664,'2023-07-28 06:55:23','2023-07-28 15:36:44','12.249.250.150','12.249.250.150','closed',8,521,'attendances/1948/1690552523 clock_in.png','attendances/1948/1690583804 clock_out.png',NULL,37053,NULL,'2023-07-28 10:55:23','2023-07-28 19:36:44'),(665,'2023-07-28 06:55:50','2023-07-28 17:14:46','12.249.250.150','12.249.250.150','closed',10,618,'attendances/1455/1690552550 clock_in.png','attendances/1455/1690589686 clock_out.png',NULL,37047,NULL,'2023-07-28 10:55:50','2023-07-28 21:14:46'),(666,'2023-07-28 06:55:53','2023-07-28 15:35:28','12.249.250.150','12.249.250.150','closed',8,519,'attendances/974/1690552553 clock_in.png','attendances/974/1690583728 clock_out.png',NULL,37037,NULL,'2023-07-28 10:55:53','2023-07-28 19:35:28'),(667,'2023-07-28 06:56:20','2023-07-28 15:37:21','12.249.250.150','12.249.250.150','closed',8,521,'attendances/1953/1690552580 clock_in.png','attendances/1953/1690583841 clock_out.png',NULL,37056,NULL,'2023-07-28 10:56:20','2023-07-28 19:37:21'),(668,'2023-07-28 06:57:35','2023-07-28 16:52:44','12.249.250.150','12.249.250.150','closed',9,595,'attendances/1395/1690552655 clock_in.png','attendances/1395/1690588364 clock_out.png',NULL,37051,NULL,'2023-07-28 10:57:35','2023-07-28 20:52:44'),(669,'2023-07-28 06:57:54','2023-07-28 15:32:19','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1965/1690552674 clock_in.png','attendances/1965/1690583539 clock_out.png',NULL,37054,NULL,'2023-07-28 10:57:54','2023-07-28 19:32:19'),(670,'2023-07-28 06:58:00','2023-07-28 15:32:40','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1375/1690552680 clock_in.png','attendances/1375/1690583560 clock_out.png',NULL,37049,NULL,'2023-07-28 10:58:00','2023-07-28 19:32:40'),(671,'2023-07-28 06:58:15','2023-07-28 15:32:52','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1374/1690552695 clock_in.png','attendances/1374/1690583572 clock_out.png',NULL,37046,NULL,'2023-07-28 10:58:15','2023-07-28 19:32:52'),(672,'2023-07-28 06:59:42','2023-07-28 15:33:35','12.249.250.150','12.249.250.150','closed',8,513,'attendances/1867/1690552782 clock_in.png','attendances/1867/1690583615 clock_out.png',NULL,37041,NULL,'2023-07-28 10:59:42','2023-07-28 19:33:35'),(673,'2023-07-28 07:00:51','2023-07-28 15:35:12','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1450/1690552851 clock_in.png','attendances/1450/1690583712 clock_out.png',NULL,37055,NULL,'2023-07-28 11:00:51','2023-07-28 19:35:12'),(674,'2023-07-28 07:03:00','2023-07-28 15:36:20','12.249.250.150','12.249.250.150','closed',8,513,'attendances/1888/1690552980 clock_in.png','attendances/1888/1690583780 clock_out.png',NULL,37058,NULL,'2023-07-28 11:03:00','2023-07-28 19:36:20'),(675,'2023-07-28 07:47:23','2023-07-28 16:33:19','12.249.250.150','12.249.250.150','closed',8,525,'attendances/1869/1690555643 clock_in.png','attendances/1869/1690587199 clock_out.png',NULL,37059,NULL,'2023-07-28 11:47:23','2023-07-28 20:33:19'),(676,'2023-07-28 08:28:49','2023-07-28 16:46:47','12.249.250.150','12.249.250.150','closed',8,497,'attendances/1988/1690558129 clock_in.png','attendances/1988/1690588007 clock_out.png',NULL,37060,NULL,'2023-07-28 12:28:49','2023-07-28 20:46:47'),(677,'2023-07-28 10:05:03','2023-07-28 17:03:19','12.249.250.150','12.249.250.150','closed',6,418,'attendances/1636/1690566147 clock_in.png','attendances/1636/1690588999 clock_out.png',NULL,37061,NULL,'2023-07-28 14:42:27','2023-07-28 21:03:19'),(679,'2023-07-28 06:54:23','2023-07-28 15:22:22','190.2.214.172','190.2.214.172','closed',8,507,'attendances/1551/1690584983 clock_in.png','attendances/1551/1690584993 clock_out.png',NULL,37039,NULL,'2023-07-28 19:56:23','2023-07-28 20:57:28'),(680,'2023-07-29 05:54:29','2023-07-29 10:03:56','12.249.250.150','12.249.250.150','closed',4,249,'attendances/2021/1690635269 clock_in.png','attendances/2021/1690650236 clock_out.png',NULL,37066,NULL,'2023-07-29 09:54:29','2023-07-29 14:03:56'),(681,'2023-07-29 05:55:23','2023-07-29 12:41:29','12.249.250.150','12.249.250.150','closed',6,406,'attendances/1116/1690635323 clock_in.png','attendances/1116/1690659689 clock_out.png',NULL,37064,NULL,'2023-07-29 09:55:23','2023-07-29 16:41:29'),(682,'2023-07-29 05:55:36','2023-07-29 10:02:55','12.249.250.150','12.249.250.150','closed',4,247,'attendances/1395/1690635336 clock_in.png','attendances/1395/1690650175 clock_out.png',NULL,37065,NULL,'2023-07-29 09:55:36','2023-07-29 14:02:55'),(683,'2023-07-29 05:55:58','2023-07-29 10:02:39','12.249.250.150','12.249.250.150','closed',4,246,'attendances/1585/1690635358 clock_in.png','attendances/1585/1690650159 clock_out.png',NULL,37062,NULL,'2023-07-29 09:55:58','2023-07-29 14:02:39'),(684,'2023-07-29 05:56:18','2023-07-29 10:03:19','12.249.250.150','12.249.250.150','closed',4,247,'attendances/1479/1690635378 clock_in.png','attendances/1479/1690650199 clock_out.png',NULL,37063,NULL,'2023-07-29 09:56:18','2023-07-29 14:03:20'),(685,'2023-07-31 05:58:18','2023-07-31 18:00:00','12.249.250.150','','closed',12,721,'attendances/2005/1690808298 clock_in.png',NULL,'Juan R',37102,NULL,'2023-07-31 09:58:18','2023-08-07 15:46:45'),(686,'2023-07-31 06:51:33','2023-07-31 15:36:03','12.249.250.150','12.249.250.150','closed',8,524,'attendances/1999/1690811493 clock_in.png','attendances/1999/1690842963 clock_out.png','Juan R',37114,NULL,'2023-07-31 10:51:33','2023-08-07 15:39:00'),(687,'2023-07-31 06:53:44','2023-07-31 14:19:20','12.249.250.150','12.249.250.150','closed',7,445,'attendances/1588/1690811624 clock_in.png','attendances/1588/1690838360 clock_out.png','Juan R',37108,NULL,'2023-07-31 10:53:44','2023-08-07 15:26:26'),(688,'2023-07-31 06:53:57','2023-07-31 16:10:42','12.249.250.150','12.249.250.150','closed',9,556,'attendances/1585/1690811637 clock_in.png','attendances/1585/1690845042 clock_out.png','Juan R',37106,NULL,'2023-07-31 10:53:57','2023-08-07 15:24:33'),(689,'2023-07-31 06:54:21','2023-07-31 15:33:34','12.249.250.150','12.249.250.150','closed',8,519,'attendances/1934/1690811661 clock_in.png','attendances/1934/1690842814 clock_out.png','Juan R',37116,NULL,'2023-07-31 10:54:21','2023-08-07 15:40:54'),(690,'2023-07-31 06:54:22','2023-07-31 15:50:46','12.249.250.150','12.249.250.150','closed',8,536,'attendances/1551/1690811662 clock_in.png','attendances/1551/1690843846 clock_out.png','Juan R',37105,NULL,'2023-07-31 10:54:22','2023-08-07 15:23:53'),(691,'2023-07-31 06:54:25','2023-07-31 15:48:09','12.249.250.150','12.249.250.150','closed',8,533,'attendances/726/1690811665 clock_in.png','attendances/726/1690843689 clock_out.png','Juan R',37104,NULL,'2023-07-31 10:54:25','2023-08-07 15:21:14'),(692,'2023-07-31 06:54:49','2023-07-31 15:46:38','12.249.250.150','12.249.250.150','closed',8,531,'attendances/974/1690811689 clock_in.png','attendances/974/1690843598 clock_out.png','Juan R',37103,NULL,'2023-07-31 10:54:49','2023-08-07 15:19:24'),(693,'2023-07-31 06:54:56','2023-07-31 15:34:06','12.249.250.150','12.249.250.150','closed',8,519,'attendances/1374/1690811696 clock_in.png','attendances/1374/1690842846 clock_out.png','Juan R',37113,NULL,'2023-07-31 10:54:56','2023-08-07 15:38:11'),(694,'2023-07-31 06:55:13','2023-07-31 15:40:33','12.249.250.150','12.249.250.150','closed',8,525,'attendances/1898/1690811713 clock_in.png','attendances/1898/1690843233 clock_out.png','Juan R',37111,NULL,'2023-07-31 10:55:13','2023-08-07 13:52:23'),(695,'2023-07-31 06:55:28','2023-07-31 15:36:51','12.249.250.150','12.249.250.150','closed',8,521,'attendances/1948/1690811728 clock_in.png','attendances/1948/1690843011 clock_out.png','Juan R',37122,NULL,'2023-07-31 10:55:28','2023-08-07 15:52:42'),(696,'2023-07-31 06:55:41','2023-07-31 15:36:35','12.249.250.150','12.249.250.150','closed',8,520,'attendances/1965/1690811741 clock_in.png','attendances/1965/1690842995 clock_out.png','Juan R',37123,NULL,'2023-07-31 10:55:41','2023-08-07 15:52:51'),(697,'2023-07-31 06:56:05','2023-07-31 15:51:08','12.249.250.150','12.249.250.150','closed',8,535,'attendances/1568/1690811765 clock_in.png','attendances/1568/1690843868 clock_out.png','Juan R',37107,NULL,'2023-07-31 10:56:05','2023-08-07 15:25:09'),(698,'2023-07-31 06:56:09','2023-07-31 15:35:46','12.249.250.150','12.249.250.150','closed',8,519,'attendances/1395/1690811769 clock_in.png','attendances/1395/1690842946 clock_out.png','Juan R',37139,NULL,'2023-07-31 10:56:09','2023-08-07 15:47:56'),(699,'2023-07-31 06:56:24','2023-07-31 15:33:20','12.249.250.150','12.249.250.150','closed',8,516,'attendances/622/1690811784 clock_in.png','attendances/622/1690842800 clock_out.png','Juan R',37126,NULL,'2023-07-31 10:56:24','2023-08-07 15:54:34'),(700,'2023-07-31 06:56:28','2023-07-31 16:34:59','12.249.250.150','12.249.250.150','closed',9,578,'attendances/2021/1690811788 clock_in.png','attendances/2021/1690846499 clock_out.png','Juan R',37125,NULL,'2023-07-31 10:56:28','2023-08-07 15:53:26'),(701,'2023-07-31 06:56:28','2023-07-31 15:35:18','12.249.250.150','12.249.250.150','closed',8,518,'attendances/1728/1690811788 clock_in.png','attendances/1728/1690842918 clock_out.png','Juan R',37118,NULL,'2023-07-31 10:56:28','2023-08-07 15:42:42'),(702,'2023-07-31 06:57:03','2023-07-31 15:34:47','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1375/1690811823 clock_in.png','attendances/1375/1690842887 clock_out.png','Juan R',37120,NULL,'2023-07-31 10:57:03','2023-08-07 15:45:46'),(703,'2023-07-31 06:58:37','2023-07-31 15:48:53','12.249.250.150','12.249.250.150','closed',8,530,'attendances/1450/1690811917 clock_in.png','attendances/1450/1690843733 clock_out.png','Juan R',37124,NULL,'2023-07-31 10:58:37','2023-08-07 15:53:13'),(704,'2023-07-31 06:59:28','2023-07-31 15:48:52','12.249.250.150','12.249.250.150','closed',8,529,'attendances/382/1690811968 clock_in.png','attendances/382/1690843732 clock_out.png','Juan R',37109,NULL,'2023-07-31 10:59:28','2023-08-07 15:36:52'),(705,'2023-07-31 07:01:01','2023-07-31 15:35:32','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1455/1690812061 clock_in.png','attendances/1455/1690842932 clock_out.png','Juan R',37117,NULL,'2023-07-31 11:01:01','2023-08-07 15:41:25'),(706,'2023-07-31 07:04:06','2023-07-31 15:43:39','12.249.250.150','12.249.250.150','closed',8,519,'attendances/1951/1690812246 clock_in.png','attendances/1951/1690843419 clock_out.png','Juan R',37110,NULL,'2023-07-31 11:04:06','2023-08-07 15:35:59'),(707,'2023-07-31 07:04:16','2023-07-31 15:35:59','12.249.250.150','12.249.250.150','closed',8,511,'attendances/1958/1690812256 clock_in.png','attendances/1958/1690842959 clock_out.png','Juan R',37112,NULL,'2023-07-31 11:04:16','2023-08-07 15:38:00'),(708,'2023-07-31 07:05:52','2023-07-31 15:34:42','12.249.250.150','12.249.250.150','closed',8,508,'attendances/1888/1690812352 clock_in.png','attendances/1888/1690842882 clock_out.png','Juan R',37127,NULL,'2023-07-31 11:05:52','2023-08-07 15:56:27'),(709,'2023-07-31 07:08:28','2023-07-31 15:36:34','12.249.250.150','12.249.250.150','closed',8,508,'attendances/1858/1690812508 clock_in.png','attendances/1858/1690842994 clock_out.png','Juan R',37119,NULL,'2023-07-31 11:08:28','2023-08-07 15:46:21'),(710,'2023-07-31 07:16:26','2023-07-31 15:40:00','12.249.250.150','','closed',8,503,'attendances/1462/1690812986 clock_in.png',NULL,'Juan R',37115,NULL,'2023-07-31 11:16:26','2023-08-07 15:39:22'),(711,'2023-07-31 07:58:18','2023-07-31 16:32:10','12.249.250.150','12.249.250.150','closed',8,513,'attendances/1869/1690815499 clock_in.png','attendances/1869/1690846330 clock_out.png','Juan R',37128,NULL,'2023-07-31 11:58:19','2023-08-07 15:25:47'),(712,'2023-07-31 07:58:50','2023-07-31 16:30:06','12.249.250.150','12.249.250.150','closed',8,511,'attendances/775/1690815530 clock_in.png','attendances/775/1690846206 clock_out.png','Juan R',37129,NULL,'2023-07-31 11:58:50','2023-08-07 15:48:18'),(713,'2023-07-31 07:59:54','2023-07-31 16:32:03','12.249.250.150','12.249.250.150','closed',8,512,'attendances/1891/1690815594 clock_in.png','attendances/1891/1690846323 clock_out.png','Juan R',37130,NULL,'2023-07-31 11:59:54','2023-08-07 15:52:21'),(714,'2023-07-31 08:03:45','2023-07-31 16:30:16','12.249.250.150','12.249.250.150','closed',8,506,'attendances/1492/1690815825 clock_in.png','attendances/1492/1690846216 clock_out.png','Juan R',37131,NULL,'2023-07-31 12:03:45','2023-08-07 15:55:25'),(715,'2023-07-31 08:28:55','2023-07-31 17:07:11','12.249.250.150','12.249.250.150','closed',8,518,'attendances/1988/1690817335 clock_in.png','attendances/1988/1690848431 clock_out.png','Juan R',37132,NULL,'2023-07-31 12:28:55','2023-08-07 15:54:55'),(716,'2023-07-31 09:50:09','2023-07-31 18:38:06','12.249.250.150','12.249.250.150','closed',8,527,'attendances/1116/1690822209 clock_in.png','attendances/1116/1690853886 clock_out.png','Juan R',37133,NULL,'2023-07-31 13:50:09','2023-08-07 15:47:28'),(718,'2023-08-01 05:55:10','2023-08-01 19:40:39','12.249.250.150','12.249.250.150','closed',13,825,'attendances/2025/1690894510 clock_in.png','attendances/2025/1690944039 clock_out.png','Juan R',37173,NULL,'2023-08-01 09:55:10','2023-08-07 15:56:08'),(719,'2023-08-01 05:55:33','2023-08-01 19:45:55','12.249.250.150','12.249.250.150','closed',13,830,'attendances/1953/1690894533 clock_in.png','attendances/1953/1690944355 clock_out.png','Juan R',37172,NULL,'2023-08-01 09:55:33','2023-08-07 15:53:43'),(720,'2023-08-01 05:55:59','2023-08-01 15:30:00','12.249.250.150','','closed',9,574,'attendances/1568/1690894559 clock_in.png',NULL,'Juan R',37174,NULL,'2023-08-01 09:55:59','2023-08-07 15:25:03'),(721,'2023-08-01 05:57:04','2023-08-01 19:34:32','12.249.250.150','12.249.250.150','closed',13,817,'attendances/2005/1690894624 clock_in.png','attendances/2005/1690943672 clock_out.png','Juan R',37171,NULL,'2023-08-01 09:57:04','2023-08-07 15:46:36'),(722,'2023-08-01 06:54:01','2023-08-01 15:35:56','12.249.250.150','12.249.250.150','closed',8,521,'attendances/1898/1690898041 clock_in.png','attendances/1898/1690929356 clock_out.png','Juan R',37176,NULL,'2023-08-01 10:54:01','2023-08-07 13:52:19'),(723,'2023-08-01 06:54:55','2023-08-01 15:33:12','12.249.250.150','12.249.250.150','closed',8,518,'attendances/1728/1690898095 clock_in.png','attendances/1728/1690929192 clock_out.png','Juan R',37183,NULL,'2023-08-01 10:54:55','2023-08-07 15:42:38'),(724,'2023-08-01 06:55:24','2023-08-01 15:32:58','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1999/1690898124 clock_in.png','attendances/1999/1690929178 clock_out.png','Juan R',37180,NULL,'2023-08-01 10:55:24','2023-08-07 15:38:56'),(725,'2023-08-01 06:55:48','2023-08-01 15:35:41','12.249.250.150','12.249.250.150','closed',8,519,'attendances/1948/1690898148 clock_in.png','attendances/1948/1690929341 clock_out.png','Juan R',37186,NULL,'2023-08-01 10:55:48','2023-08-07 15:52:38'),(726,'2023-08-01 06:55:49','2023-08-01 15:36:39','12.249.250.150','12.249.250.150','closed',8,520,'attendances/622/1690898149 clock_in.png','attendances/622/1690929399 clock_out.png','Juan R',37187,NULL,'2023-08-01 10:55:49','2023-08-07 15:54:30'),(727,'2023-08-01 06:56:09','2023-08-01 15:36:20','12.249.250.150','12.249.250.150','closed',8,520,'attendances/1774/1690898169 clock_in.png','attendances/1774/1690929380 clock_out.png','Juan R',37177,NULL,'2023-08-01 10:56:09','2023-08-07 13:51:31'),(728,'2023-08-01 06:56:09','2023-08-01 15:33:30','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1479/1690898169 clock_in.png','attendances/1479/1690929210 clock_out.png','Juan R',37175,NULL,'2023-08-01 10:56:09','2023-08-07 15:35:36'),(729,'2023-08-01 06:56:27','2023-08-01 15:36:29','12.249.250.150','12.249.250.150','closed',8,520,'attendances/1374/1690898187 clock_in.png','attendances/1374/1690929389 clock_out.png','Juan R',37179,NULL,'2023-08-01 10:56:27','2023-08-07 15:38:07'),(730,'2023-08-01 06:56:53','2023-08-01 15:40:00','12.249.250.150','','closed',8,523,'attendances/1462/1690898213 clock_in.png',NULL,'Juan R',37181,NULL,'2023-08-01 10:56:53','2023-08-07 15:39:17'),(731,'2023-08-01 06:57:06','2023-08-01 15:34:00','12.249.250.150','','closed',8,516,'attendances/1958/1690898226 clock_in.png',NULL,'Juan R',37178,NULL,'2023-08-01 10:57:06','2023-08-07 15:37:51'),(732,'2023-08-01 06:58:05','2023-08-01 15:36:54','12.249.250.150','12.249.250.150','closed',8,518,'attendances/1934/1690898285 clock_in.png','attendances/1934/1690929414 clock_out.png','Juan R',37182,NULL,'2023-08-01 10:58:05','2023-08-07 15:40:51'),(733,'2023-08-01 07:02:41','2023-08-01 15:35:02','12.249.250.150','12.249.250.150','closed',8,512,'attendances/1858/1690898561 clock_in.png','attendances/1858/1690929722 clock_out.png','Juan R',37184,NULL,'2023-08-01 11:02:41','2023-08-07 15:46:16'),(734,'2023-08-01 07:04:49','2023-08-01 15:39:35','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1888/1690898689 clock_in.png','attendances/1888/1690929575 clock_out.png','Juan R',37188,NULL,'2023-08-01 11:04:49','2023-08-07 15:56:23'),(735,'2023-08-01 07:57:57','2023-08-01 16:30:00','12.249.250.150','','closed',8,512,'attendances/775/1690901877 clock_in.png',NULL,'Juan R',37190,NULL,'2023-08-01 11:57:57','2023-08-07 15:48:12'),(736,'2023-08-01 08:00:56','2023-08-01 16:32:00','12.249.250.150','','closed',8,511,'attendances/1869/1690902056 clock_in.png',NULL,'Juan R',37189,NULL,'2023-08-01 12:00:56','2023-08-07 15:25:25'),(737,'2023-08-01 08:06:26','2023-08-01 16:30:00','12.249.250.150','','closed',8,503,'attendances/1492/1690902386 clock_in.png',NULL,'Juan R',37192,NULL,'2023-08-01 12:06:26','2023-08-07 15:55:16'),(738,'2023-08-01 08:02:16','2023-08-01 16:34:00','12.249.250.150','','closed',8,511,'attendances/1891/1690902976 clock_in.png',NULL,'Juan R',37191,NULL,'2023-08-01 12:16:16','2023-08-07 15:52:16'),(739,'2023-08-01 08:29:05','2023-08-01 16:50:48','12.249.250.150','12.249.250.150','closed',8,501,'attendances/1988/1690903745 clock_in.png','attendances/1988/1690933848 clock_out.png','Juan R',37193,NULL,'2023-08-01 12:29:05','2023-08-07 15:54:50'),(741,'2023-08-02 05:54:51','2023-08-02 19:33:28','12.249.250.150','12.249.250.150','closed',13,818,'attendances/1455/1690980891 clock_in.png','attendances/1455/1691030008 clock_out.png','Juan R',37219,NULL,'2023-08-02 09:54:51','2023-08-07 15:41:15'),(742,'2023-08-02 05:55:12','2023-08-02 19:32:51','12.249.250.150','12.249.250.150','closed',13,817,'attendances/1585/1690980912 clock_in.png','attendances/1585/1691029971 clock_out.png','Juan R',37216,NULL,'2023-08-02 09:55:12','2023-08-07 15:24:10'),(743,'2023-08-02 05:55:36','2023-08-02 19:37:44','12.249.250.150','12.249.250.150','closed',13,822,'attendances/2025/1690980936 clock_in.png','attendances/2025/1691030264 clock_out.png','Juan R',37223,NULL,'2023-08-02 09:55:36','2023-08-07 15:56:04'),(744,'2023-08-02 05:56:03','2023-08-02 19:37:57','12.249.250.150','12.249.250.150','closed',13,821,'attendances/2021/1690980963 clock_in.png','attendances/2021/1691030277 clock_out.png','Juan R',37221,NULL,'2023-08-02 09:56:03','2023-08-07 15:53:22'),(745,'2023-08-02 05:58:07','2023-08-02 19:35:00','12.249.250.150','','closed',13,816,'attendances/2005/1690981087 clock_in.png',NULL,'Juan R',37220,NULL,'2023-08-02 09:58:07','2023-08-07 15:46:31'),(746,'2023-08-02 05:59:31','2023-08-02 19:33:40','12.249.250.150','12.249.250.150','closed',13,814,'attendances/1551/1690981171 clock_in.png','attendances/1551/1691030020 clock_out.png','Juan R',37215,NULL,'2023-08-02 09:59:31','2023-08-07 15:23:46'),(747,'2023-08-02 06:00:12','2023-08-02 19:35:14','12.249.250.150','12.249.250.150','closed',13,815,'attendances/382/1690981212 clock_in.png','attendances/382/1691030114 clock_out.png','Juan R',37218,NULL,'2023-08-02 10:00:12','2023-08-07 15:36:48'),(748,'2023-08-02 06:07:47','2023-08-02 19:46:09','12.249.250.150','12.249.250.150','closed',13,818,'attendances/1953/1690981667 clock_in.png','attendances/1953/1691030769 clock_out.png','Juan R',37222,NULL,'2023-08-02 10:07:47','2023-08-07 15:53:39'),(749,'2023-08-02 06:52:28','2023-08-02 15:33:22','12.249.250.150','12.249.250.150','closed',8,520,'attendances/1999/1690984348 clock_in.png','attendances/1999/1691015602 clock_out.png','Juan R',37232,NULL,'2023-08-02 10:52:28','2023-08-07 15:38:51'),(750,'2023-08-02 06:52:56','2023-08-02 15:38:54','12.249.250.150','12.249.250.150','closed',8,525,'attendances/1588/1690984376 clock_in.png','attendances/1588/1691015934 clock_out.png','Juan R',37226,NULL,'2023-08-02 10:52:56','2023-08-07 15:26:22'),(751,'2023-08-02 06:54:29','2023-08-02 15:34:06','12.249.250.150','12.249.250.150','closed',8,519,'attendances/726/1690984469 clock_in.png','attendances/726/1691015646 clock_out.png','Juan R',37225,NULL,'2023-08-02 10:54:29','2023-08-07 15:21:08'),(752,'2023-08-02 06:54:50','2023-08-02 15:35:16','12.249.250.150','12.249.250.150','closed',8,520,'attendances/622/1690984490 clock_in.png','attendances/622/1691015716 clock_out.png','Juan R',37243,NULL,'2023-08-02 10:54:50','2023-08-07 15:54:26'),(753,'2023-08-02 06:54:54','2023-08-02 15:31:33','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1116/1690984494 clock_in.png','attendances/1116/1691015493 clock_out.png','Juan R',37238,NULL,'2023-08-02 10:54:54','2023-08-07 15:47:23'),(754,'2023-08-02 06:55:12','2023-08-02 15:33:08','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1395/1690984512 clock_in.png','attendances/1395/1691015588 clock_out.png','Juan R',37239,NULL,'2023-08-02 10:55:12','2023-08-07 15:47:51'),(755,'2023-08-02 06:55:16','2023-08-02 15:34:38','12.249.250.150','12.249.250.150','closed',8,519,'attendances/1774/1690984516 clock_in.png','attendances/1774/1691015678 clock_out.png','Juan R',37230,NULL,'2023-08-02 10:55:16','2023-08-07 15:37:16'),(756,'2023-08-02 06:55:32','2023-08-02 16:20:03','12.249.250.150','12.249.250.150','closed',9,564,'attendances/1898/1690984532 clock_in.png','attendances/1898/1691018403 clock_out.png','Juan R',37229,NULL,'2023-08-02 10:55:32','2023-08-07 13:52:14'),(757,'2023-08-02 06:55:46','2023-08-02 16:19:49','12.249.250.150','12.249.250.150','closed',9,564,'attendances/1948/1690984546 clock_in.png','attendances/1948/1691018389 clock_out.png','Juan R',37240,NULL,'2023-08-02 10:55:46','2023-08-07 15:52:34'),(758,'2023-08-02 06:55:52','2023-08-02 15:34:06','12.249.250.150','12.249.250.150','closed',8,518,'attendances/1934/1690984552 clock_in.png','attendances/1934/1691015646 clock_out.png','Juan R',37234,NULL,'2023-08-02 10:55:53','2023-08-07 15:40:47'),(759,'2023-08-02 06:56:11','2023-08-02 15:33:36','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1858/1690984571 clock_in.png','attendances/1858/1691015616 clock_out.png','Juan R',37236,NULL,'2023-08-02 10:56:11','2023-08-07 15:46:13'),(760,'2023-08-02 06:56:16','2023-08-02 15:36:53','12.249.250.150','12.249.250.150','closed',8,520,'attendances/974/1690984576 clock_in.png','attendances/974/1691015813 clock_out.png','Juan R',37224,NULL,'2023-08-02 10:56:16','2023-08-07 15:19:03'),(761,'2023-08-02 06:56:38','2023-08-02 15:32:52','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1479/1690984598 clock_in.png','attendances/1479/1691015572 clock_out.png','Juan R',37227,NULL,'2023-08-02 10:56:38','2023-08-07 15:35:15'),(762,'2023-08-02 06:56:58','2023-08-02 15:33:14','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1958/1690984618 clock_in.png','attendances/1958/1691015594 clock_out.png','Juan R',37231,NULL,'2023-08-02 10:56:58','2023-08-07 15:37:46'),(763,'2023-08-02 06:57:41','2023-08-02 15:38:01','12.249.250.150','12.249.250.150','closed',8,520,'attendances/1462/1690984661 clock_in.png','attendances/1462/1691015881 clock_out.png','Juan R',37233,NULL,'2023-08-02 10:57:41','2023-08-07 15:39:12'),(764,'2023-08-02 06:59:10','2023-08-02 15:29:57','12.249.250.150','12.249.250.150','closed',8,510,'attendances/1728/1690984750 clock_in.png','attendances/1728/1691015397 clock_out.png','Juan R',37235,NULL,'2023-08-02 10:59:10','2023-08-07 15:42:34'),(765,'2023-08-02 07:00:46','2023-08-02 15:34:09','12.249.250.150','12.249.250.150','closed',8,513,'attendances/1450/1690984846 clock_in.png','attendances/1450/1691015649 clock_out.png','Juan R',37242,NULL,'2023-08-02 11:00:46','2023-08-07 15:53:09'),(766,'2023-08-02 07:01:20','2023-08-02 15:34:57','12.249.250.150','12.249.250.150','closed',8,513,'attendances/1888/1690984880 clock_in.png','attendances/1888/1691015697 clock_out.png','Juan R',37244,NULL,'2023-08-02 11:01:20','2023-08-07 15:56:18'),(767,'2023-08-02 07:06:55','2023-08-02 15:54:05','12.249.250.150','12.249.250.150','closed',8,527,'attendances/1951/1690985215 clock_in.png','attendances/1951/1691016845 clock_out.png','Juan R',37228,NULL,'2023-08-02 11:06:55','2023-08-07 15:35:50'),(768,'2023-08-02 07:59:19','2023-08-02 16:30:03','12.249.250.150','12.249.250.150','closed',8,510,'attendances/775/1690988359 clock_in.png','attendances/775/1691019003 clock_out.png','Juan R',37246,NULL,'2023-08-02 11:59:19','2023-08-07 15:48:09'),(769,'2023-08-02 08:04:15','2023-08-02 16:29:27','12.249.250.150','12.249.250.150','closed',8,505,'attendances/1492/1690988655 clock_in.png','attendances/1492/1691018967 clock_out.png','Juan R',37248,NULL,'2023-08-02 12:04:15','2023-08-07 15:55:13'),(770,'2023-08-02 08:07:24','2023-08-02 16:31:56','12.249.250.150','12.249.250.150','closed',8,504,'attendances/1869/1690988844 clock_in.png','attendances/1869/1691019117 clock_out.png','Juan R',37245,NULL,'2023-08-02 12:07:24','2023-08-07 15:25:21'),(771,'2023-08-02 08:07:35','2023-08-02 16:32:17','12.249.250.150','12.249.250.150','closed',8,504,'attendances/1891/1690988855 clock_in.png','attendances/1891/1691019137 clock_out.png','Juan R',37247,NULL,'2023-08-02 12:07:35','2023-08-07 15:52:12'),(772,'2023-08-02 08:38:28','2023-08-02 17:00:00','12.249.250.150','12.249.250.150','closed',8,501,'attendances/1988/1690990708 clock_in.png','attendances/1988/1691020800 clock_out.png','Juan R',37249,NULL,'2023-08-02 12:38:28','2023-08-07 15:54:46'),(773,'2023-08-03 05:53:39','2023-08-03 19:19:41','12.249.250.150','12.249.250.150','closed',13,806,'attendances/1585/1691067219 clock_in.png','attendances/1585/1691115581 clock_out.png','Juan R',37256,NULL,'2023-08-03 09:53:39','2023-08-07 15:24:05'),(774,'2023-08-03 05:53:55','2023-08-03 19:26:54','12.249.250.150','12.249.250.150','closed',13,812,'attendances/2025/1691067235 clock_in.png','attendances/2025/1691116014 clock_out.png','Juan R',37260,NULL,'2023-08-03 09:53:55','2023-08-07 15:56:00'),(775,'2023-08-03 05:54:26','2023-08-03 19:20:38','12.249.250.150','12.249.250.150','closed',13,806,'attendances/382/1691067266 clock_in.png','attendances/382/1691115638 clock_out.png','Juan R',37257,NULL,'2023-08-03 09:54:26','2023-08-07 15:36:44'),(776,'2023-08-03 05:54:29','2023-08-03 19:22:47','12.249.250.150','12.249.250.150','closed',13,808,'attendances/2005/1691067269 clock_in.png','attendances/2005/1691115767 clock_out.png','Juan R',37258,NULL,'2023-08-03 09:54:29','2023-08-07 15:46:28'),(777,'2023-08-03 05:54:52','2023-08-03 19:23:19','12.249.250.150','12.249.250.150','closed',13,808,'attendances/2021/1691067292 clock_in.png','attendances/2021/1691115799 clock_out.png','Juan R',37259,NULL,'2023-08-03 09:54:52','2023-08-07 15:53:18'),(778,'2023-08-03 05:55:49','2023-08-03 19:22:01','12.249.250.150','12.249.250.150','closed',13,806,'attendances/1551/1691067349 clock_in.png','attendances/1551/1691115721 clock_out.png','Juan R',37255,NULL,'2023-08-03 09:55:49','2023-08-07 15:23:43'),(779,'2023-08-03 06:52:50','2023-08-03 16:37:52','12.249.250.150','12.249.250.150','closed',9,585,'attendances/1999/1691070770 clock_in.png','attendances/1999/1691105872 clock_out.png','Juan R',37270,NULL,'2023-08-03 10:52:50','2023-08-07 15:38:46'),(780,'2023-08-03 06:55:03','2023-08-03 15:38:23','12.249.250.150','12.249.250.150','closed',8,523,'attendances/1462/1691070903 clock_in.png','attendances/1462/1691102303 clock_out.png','Juan R',37271,NULL,'2023-08-03 10:55:03','2023-08-07 15:39:08'),(781,'2023-08-03 06:55:06','2023-08-03 15:31:35','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1588/1691070906 clock_in.png','attendances/1588/1691101895 clock_out.png','Juan R',37264,NULL,'2023-08-03 10:55:06','2023-08-07 15:26:17'),(782,'2023-08-03 06:55:19','2023-08-03 15:32:34','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1568/1691070919 clock_in.png','attendances/1568/1691101954 clock_out.png','Juan R',37263,NULL,'2023-08-03 10:55:19','2023-08-07 15:24:59'),(783,'2023-08-03 06:55:20','2023-08-03 15:32:09','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1774/1691070920 clock_in.png','attendances/1774/1691101929 clock_out.png','Juan R',37267,NULL,'2023-08-03 10:55:20','2023-08-07 15:37:08'),(784,'2023-08-03 06:55:27','2023-08-03 15:32:57','12.249.250.150','12.249.250.150','closed',8,517,'attendances/726/1691070927 clock_in.png','attendances/726/1691101977 clock_out.png','Juan R',37262,NULL,'2023-08-03 10:55:27','2023-08-07 15:21:04'),(785,'2023-08-03 06:55:54','2023-08-03 17:20:07','12.249.250.150','12.249.250.150','closed',10,624,'attendances/1951/1691070954 clock_in.png','attendances/1951/1691108407 clock_out.png','Juan R',37265,NULL,'2023-08-03 10:55:54','2023-08-07 15:35:46'),(786,'2023-08-03 06:55:55','2023-08-03 16:31:13','12.249.250.150','12.249.250.150','closed',9,575,'attendances/1395/1691070955 clock_in.png','attendances/1395/1691105473 clock_out.png','Juan R',37277,NULL,'2023-08-03 10:55:55','2023-08-07 15:47:46'),(787,'2023-08-03 06:56:24','2023-08-03 15:34:47','12.249.250.150','12.249.250.150','closed',8,518,'attendances/974/1691070984 clock_in.png','attendances/974/1691102087 clock_out.png','Juan R',37261,NULL,'2023-08-03 10:56:24','2023-08-07 15:18:57'),(788,'2023-08-03 06:56:40','2023-08-03 18:43:08','12.249.250.150','12.249.250.150','closed',11,706,'attendances/1728/1691071000 clock_in.png','attendances/1728/1691113388 clock_out.png','Juan R',37274,NULL,'2023-08-03 10:56:40','2023-08-07 15:42:31'),(789,'2023-08-03 06:56:53','2023-08-03 15:32:18','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1455/1691071013 clock_in.png','attendances/1455/1691101938 clock_out.png','Juan R',37273,NULL,'2023-08-03 10:56:53','2023-08-07 15:41:12'),(790,'2023-08-03 06:56:53','2023-08-03 18:42:22','12.249.250.150','12.249.250.150','closed',11,705,'attendances/1898/1691071013 clock_in.png','attendances/1898/1691113342 clock_out.png','Juan R',37266,NULL,'2023-08-03 10:56:53','2023-08-07 13:51:56'),(791,'2023-08-03 06:57:38','2023-08-03 15:31:17','12.249.250.150','12.249.250.150','closed',8,513,'attendances/622/1691071058 clock_in.png','attendances/622/1691101877 clock_out.png','Juan R',37279,NULL,'2023-08-03 10:57:38','2023-08-07 15:54:22'),(792,'2023-08-03 06:58:03','2023-08-03 15:32:28','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1934/1691071083 clock_in.png','attendances/1934/1691101948 clock_out.png','Juan R',37272,NULL,'2023-08-03 10:58:03','2023-08-07 15:40:44'),(793,'2023-08-03 06:58:44','2023-08-03 18:42:44','12.249.250.150','12.249.250.150','closed',11,704,'attendances/1948/1691071124 clock_in.png','attendances/1948/1691113364 clock_out.png','Juan R',37278,NULL,'2023-08-03 10:58:44','2023-08-07 15:52:29'),(794,'2023-08-03 07:01:46','2023-08-03 15:33:16','12.249.250.150','12.249.250.150','closed',8,511,'attendances/1888/1691071306 clock_in.png','attendances/1888/1691101996 clock_out.png','Juan R',37280,NULL,'2023-08-03 11:01:46','2023-08-07 15:56:14'),(795,'2023-08-03 07:06:07','2023-08-03 15:33:27','12.249.250.150','12.249.250.150','closed',8,507,'attendances/1858/1691071567 clock_in.png','attendances/1858/1691102007 clock_out.png','Juan R',37275,NULL,'2023-08-03 11:06:07','2023-08-07 15:46:10'),(796,'2023-08-03 07:08:41','2023-08-03 15:33:25','12.249.250.150','12.249.250.150','closed',8,504,'attendances/1958/1691071721 clock_in.png','attendances/1958/1691102005 clock_out.png','Juan R',37268,NULL,'2023-08-03 11:08:41','2023-08-07 15:37:42'),(797,'2023-08-03 08:00:13','2023-08-03 16:32:45','12.249.250.150','12.249.250.150','closed',8,512,'attendances/1869/1691074813 clock_in.png','attendances/1869/1691105565 clock_out.png','Juan R',37285,NULL,'2023-08-03 12:00:20','2023-08-07 15:25:17'),(798,'2023-08-03 08:00:32','2023-08-03 16:30:10','12.249.250.150','12.249.250.150','closed',8,509,'attendances/775/1691074832 clock_in.png','attendances/775/1691105410 clock_out.png','Juan R',37281,NULL,'2023-08-03 12:00:32','2023-08-07 15:48:05'),(799,'2023-08-03 08:01:53','2023-08-03 16:30:33','12.249.250.150','12.249.250.150','closed',8,508,'attendances/1492/1691074913 clock_in.png','attendances/1492/1691105433 clock_out.png','Juan R',37283,NULL,'2023-08-03 12:01:53','2023-08-07 15:55:08'),(800,'2023-08-03 08:05:13','2023-08-03 16:33:24','12.249.250.150','12.249.250.150','closed',8,508,'attendances/1891/1691075113 clock_in.png','attendances/1891/1691105605 clock_out.png','Juan R',37282,NULL,'2023-08-03 12:05:13','2023-08-07 15:52:08'),(801,'2023-08-04 05:01:08','2023-08-04 19:50:02','12.249.250.150','12.249.250.150','closed',14,888,'attendances/726/1691150468 clock_in.png','attendances/726/1691203802 clock_out.png','Juan R',37286,NULL,'2023-08-04 09:01:08','2023-08-07 15:20:59'),(802,'2023-08-04 05:55:31','2023-08-04 19:26:04','12.249.250.150','12.249.250.150','closed',13,810,'attendances/2025/1691153731 clock_in.png','attendances/2025/1691202364 clock_out.png','Juan R',37291,NULL,'2023-08-04 09:55:31','2023-08-07 15:55:57'),(803,'2023-08-04 05:55:51','2023-08-04 19:25:16','12.249.250.150','12.249.250.150','closed',13,809,'attendances/1585/1691153751 clock_in.png','attendances/1585/1691202316 clock_out.png','Juan R',37288,NULL,'2023-08-04 09:55:51','2023-08-07 15:24:00'),(804,'2023-08-04 05:56:15','2023-08-04 19:25:31','12.249.250.150','12.249.250.150','closed',13,809,'attendances/2005/1691153775 clock_in.png','attendances/2005/1691202331 clock_out.png','Juan R',37290,NULL,'2023-08-04 09:56:15','2023-08-07 15:46:24'),(805,'2023-08-04 05:58:12','2023-08-04 19:25:40','12.249.250.150','12.249.250.150','closed',13,807,'attendances/1551/1691153892 clock_in.png','attendances/1551/1691202340 clock_out.png','Juan R',37287,NULL,'2023-08-04 09:58:12','2023-08-07 15:23:39'),(806,'2023-08-04 06:00:44','2023-08-04 19:26:44','12.249.250.150','12.249.250.150','closed',13,806,'attendances/382/1691154044 clock_in.png','attendances/382/1691202404 clock_out.png','Juan R',37289,NULL,'2023-08-04 10:00:44','2023-08-07 15:36:40'),(807,'2023-08-04 06:01:02','2023-08-04 14:29:54','12.249.250.150','12.249.250.150','closed',8,508,'attendances/1951/1691154062 clock_in.png','attendances/1951/1691184594 clock_out.png','Juan R',37296,NULL,'2023-08-04 10:01:02','2023-08-07 15:35:42'),(808,'2023-08-04 06:26:23','2023-08-04 20:09:39','12.249.250.150','12.249.250.150','closed',13,823,'attendances/1588/1691155583 clock_in.png','attendances/1588/1691204979 clock_out.png','Juan R',37292,NULL,'2023-08-04 10:26:23','2023-08-07 15:26:13'),(809,'2023-08-04 06:52:42','2023-08-04 15:31:06','12.249.250.150','12.249.250.150','closed',8,518,'attendances/622/1691157162 clock_in.png','attendances/622/1691188266 clock_out.png','Juan R',37308,NULL,'2023-08-04 10:52:42','2023-08-07 15:54:18'),(810,'2023-08-04 06:53:10','2023-08-04 15:31:43','12.249.250.150','12.249.250.150','closed',8,518,'attendances/1774/1691157190 clock_in.png','attendances/1774/1691188303 clock_out.png','Juan R',37298,NULL,'2023-08-04 10:53:10','2023-08-07 15:37:02'),(811,'2023-08-04 06:55:28','2023-08-04 15:33:05','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1898/1691157328 clock_in.png','attendances/1898/1691188385 clock_out.png','Juan R',37297,NULL,'2023-08-04 10:55:28','2023-08-07 13:51:37'),(812,'2023-08-04 06:55:30','2023-08-04 16:42:33','12.249.250.150','12.249.250.150','closed',9,587,'attendances/1568/1691157330 clock_in.png','attendances/1568/1691192553 clock_out.png','Juan R',37294,NULL,'2023-08-04 10:55:30','2023-08-07 15:24:55'),(813,'2023-08-04 06:55:46','2023-08-04 16:34:51','12.249.250.150','12.249.250.150','closed',9,579,'attendances/1116/1691157346 clock_in.png','attendances/1116/1691192091 clock_out.png','Juan R',37303,NULL,'2023-08-04 10:55:46','2023-08-07 15:45:35'),(814,'2023-08-04 06:55:57','2023-08-04 16:05:53','12.249.250.150','12.249.250.150','closed',9,549,'attendances/1728/1691157357 clock_in.png','attendances/1728/1691190353 clock_out.png','Juan R',37301,NULL,'2023-08-04 10:55:57','2023-08-07 15:42:27'),(815,'2023-08-04 06:56:12','2023-08-04 15:37:06','12.249.250.150','12.249.250.150','closed',8,520,'attendances/1395/1691157372 clock_in.png','attendances/1395/1691188626 clock_out.png','Juan R',37304,NULL,'2023-08-04 10:56:12','2023-08-07 15:47:43'),(816,'2023-08-04 06:56:48','2023-08-04 15:32:49','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1479/1691157408 clock_in.png','attendances/1479/1691188369 clock_out.png','Juan R',37295,NULL,'2023-08-04 10:56:48','2023-08-07 15:35:09'),(817,'2023-08-04 06:56:50','2023-08-04 13:58:45','12.249.250.150','12.249.250.150','closed',7,421,'attendances/1958/1691157410 clock_in.png','attendances/1958/1691182725 clock_out.png','Juan R',37299,NULL,'2023-08-04 10:56:50','2023-08-07 15:37:38'),(818,'2023-08-04 06:57:05','2023-08-04 15:33:53','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1948/1691157425 clock_in.png','attendances/1948/1691188433 clock_out.png','Juan R',37305,NULL,'2023-08-04 10:57:05','2023-08-07 15:52:25'),(819,'2023-08-04 06:57:11','2023-08-04 15:31:57','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1934/1691157431 clock_in.png','attendances/1934/1691188317 clock_out.png','Juan R',37313,NULL,'2023-08-04 10:57:11','2023-08-07 15:40:40'),(820,'2023-08-04 06:57:41','2023-08-04 16:54:29','12.249.250.150','12.249.250.150','closed',9,596,'attendances/1455/1691157461 clock_in.png','attendances/1455/1691193269 clock_out.png','Juan R',37300,NULL,'2023-08-04 10:57:41','2023-08-07 15:41:07'),(821,'2023-08-04 06:59:20','2023-08-04 16:32:49','12.249.250.150','12.249.250.150','closed',9,573,'attendances/974/1691157560 clock_in.png','attendances/974/1691191969 clock_out.png','Juan R',37293,NULL,'2023-08-04 10:59:20','2023-08-07 15:18:51'),(822,'2023-08-04 07:02:02','2023-08-04 16:42:28','12.249.250.150','12.249.250.150','closed',9,580,'attendances/1953/1691157722 clock_in.png','attendances/1953/1691192548 clock_out.png','Juan R',37307,NULL,'2023-08-04 11:02:02','2023-08-07 15:53:35'),(823,'2023-08-04 07:02:54','2023-08-04 16:54:54','12.249.250.150','12.249.250.150','closed',9,592,'attendances/1450/1691157774 clock_in.png','attendances/1450/1691193294 clock_out.png','Juan R',37306,NULL,'2023-08-04 11:02:54','2023-08-07 15:53:05'),(825,'2023-08-04 08:09:18','2023-08-04 16:32:54','12.249.250.150','12.249.250.150','closed',8,503,'attendances/1869/1691161218 clock_in.png','attendances/1869/1691191974 clock_out.png','Juan R',37309,NULL,'2023-08-04 12:00:26','2023-08-07 15:25:13'),(826,'2023-08-04 07:59:26','2023-08-04 16:33:09','12.249.250.150','12.249.250.150','closed',9,567,'attendances/1891/1691161766 clock_in.png','attendances/1891/1691191989 clock_out.png','Juan R',37310,NULL,'2023-08-04 12:09:26','2023-08-07 15:52:04'),(827,'2023-08-04 08:11:37','2023-08-04 16:31:28','12.249.250.150','12.249.250.150','closed',8,499,'attendances/1492/1691161897 clock_in.png','attendances/1492/1691191888 clock_out.png','Juan R',37311,NULL,'2023-08-04 12:11:37','2023-08-07 15:55:02'),(828,'2023-08-04 08:31:40','2023-08-04 17:03:21','12.249.250.150','12.249.250.150','closed',8,511,'attendances/1988/1691163100 clock_in.png','attendances/1988/1691193801 clock_out.png','Juan R',37312,NULL,'2023-08-04 12:31:40','2023-08-07 15:54:41'),(829,'2023-08-04 07:09:15','2023-08-04 15:34:20','179.32.210.88','12.249.250.150','closed',8,505,'attendances/1858/1691163615 clock_in.png','attendances/1858/1691188460 clock_out.png','Juan R',37302,NULL,'2023-08-04 12:40:15','2023-08-07 15:46:06'),(830,'2023-08-05 03:57:13','2023-08-05 15:10:10','12.249.250.150','12.249.250.150','closed',11,672,'attendances/974/1691233033 clock_in.png','attendances/974/1691273410 clock_out.png','Juan R',37349,NULL,'2023-08-05 07:57:13','2023-08-07 15:18:45'),(831,'2023-08-05 03:57:34','2023-08-05 15:09:24','12.249.250.150','12.249.250.150','closed',11,671,'attendances/1568/1691233054 clock_in.png','attendances/1568/1691273364 clock_out.png','Juan R',37350,NULL,'2023-08-05 07:57:34','2023-08-07 15:24:51'),(832,'2023-08-05 05:51:12','2023-08-05 19:56:48','12.249.250.150','12.249.250.150','closed',14,845,'attendances/1116/1691239872 clock_in.png','attendances/1116/1691290608 clock_out.png','Juan R',37352,NULL,'2023-08-05 09:51:12','2023-08-07 15:45:32'),(833,'2023-08-05 05:51:26','2023-08-05 20:00:14','12.249.250.150','12.249.250.150','closed',14,848,'attendances/1588/1691239886 clock_in.png','attendances/1588/1691290814 clock_out.png','Juan R',37351,NULL,'2023-08-05 09:51:26','2023-08-07 15:26:08'),(834,'2023-08-05 05:53:00','2023-08-05 19:57:51','12.249.250.150','12.249.250.150','closed',14,844,'attendances/1395/1691239980 clock_in.png','attendances/1395/1691290671 clock_out.png','Juan R',37356,NULL,'2023-08-05 09:53:00','2023-08-07 15:47:38'),(835,'2023-08-05 06:02:22','2023-08-05 20:01:17','12.249.250.150','12.249.250.150','closed',13,838,'attendances/1953/1691240542 clock_in.png','attendances/1953/1691290877 clock_out.png','Juan R',37357,NULL,'2023-08-05 10:02:22','2023-08-07 15:53:31'),(836,'2023-08-05 06:55:02','2023-08-05 11:01:14','12.249.250.150','12.249.250.150','closed',4,246,'attendances/726/1691243702 clock_in.png','attendances/726/1691258474 clock_out.png','Juan R',37353,NULL,'2023-08-05 10:55:02','2023-08-07 15:20:55'),(837,'2023-08-05 06:58:30','2023-08-05 13:58:55','12.249.250.150','12.249.250.150','closed',7,420,'attendances/1455/1691243910 clock_in.png','attendances/1455/1691269135 clock_out.png','Juan R',37354,NULL,'2023-08-05 10:58:30','2023-08-07 15:41:03'),(838,'2023-08-05 07:01:44','2023-08-05 13:58:26','12.249.250.150','12.249.250.150','closed',6,416,'attendances/1450/1691244104 clock_in.png','attendances/1450/1691269106 clock_out.png','Juan R',37355,NULL,'2023-08-05 11:01:44','2023-08-07 15:53:01'),(839,'2023-08-05 09:55:04','2023-08-05 17:16:30','12.249.250.150','12.249.250.150','closed',7,441,'attendances/1774/1691254504 clock_in.png','attendances/1774/1691280990 clock_out.png','Juan R',37358,NULL,'2023-08-05 13:55:04','2023-08-07 15:36:57'),(840,'2023-08-05 10:27:13','2023-08-05 15:48:35','12.249.250.150','12.249.250.150','closed',5,321,'attendances/1479/1691256433 clock_in.png','attendances/1479/1691275715 clock_out.png','Juan R',37359,NULL,'2023-08-05 14:27:13','2023-08-07 15:35:05'),(841,'2023-08-05 15:34:49','2023-08-05 17:19:52','12.249.250.150','12.249.250.150','closed',1,105,'attendances/1455/1691274889 clock_in.png','attendances/1455/1691281192 clock_out.png','Juan R',37395,NULL,'2023-08-05 19:34:49','2023-08-07 15:41:00'),(842,'2023-08-05 15:37:40','2023-08-05 17:19:28','12.249.250.150','12.249.250.150','closed',1,101,'attendances/1450/1691275060 clock_in.png','attendances/1450/1691281168 clock_out.png','Juan R',37396,NULL,'2023-08-05 19:37:40','2023-08-07 15:52:56'),(843,'2023-08-05 19:58:09','2023-08-05 22:34:19','12.249.250.150','12.249.250.150','closed',2,156,'attendances/1479/1691290689 clock_in.png','attendances/1479/1691300059 clock_out.png','Juan R',37399,NULL,'2023-08-05 23:58:09','2023-08-07 15:34:59'),(849,'2023-08-07 05:54:07','2023-08-07 19:03:53','12.249.250.150','12.249.250.150','closed',13,789,'attendances/1585/1691412847 clock_in.png','attendances/1585/1691460233 clock_out.png','Juan R',37362,NULL,'2023-08-07 09:54:07','2023-08-14 07:02:26'),(850,'2023-08-07 05:54:24','2023-08-07 15:36:42','12.249.250.150','12.249.250.150','closed',9,582,'attendances/1568/1691412864 clock_in.png','attendances/1568/1691447802 clock_out.png','Juan R',37363,NULL,'2023-08-07 09:54:24','2023-08-14 07:02:53'),(851,'2023-08-07 05:54:52','2023-08-07 19:05:42','12.249.250.150','12.249.250.150','closed',13,790,'attendances/2025/1691412892 clock_in.png','attendances/2025/1691460342 clock_out.png','Juan R',37366,NULL,'2023-08-07 09:54:52','2023-08-14 07:13:47'),(852,'2023-08-07 05:56:40','2023-08-07 19:04:33','12.249.250.150','12.249.250.150','closed',13,787,'attendances/382/1691413000 clock_in.png','attendances/382/1691460273 clock_out.png','Juan R',37364,NULL,'2023-08-07 09:56:40','2023-08-14 07:05:10'),(853,'2023-08-07 05:56:56','2023-08-07 19:04:18','12.249.250.150','12.249.250.150','closed',13,787,'attendances/1551/1691413016 clock_in.png','attendances/1551/1691460258 clock_out.png','Juan R',37361,NULL,'2023-08-07 09:56:56','2023-08-14 06:59:23'),(854,'2023-08-07 05:59:37','2023-08-07 19:02:14','12.249.250.150','12.249.250.150','closed',13,782,'attendances/2005/1691413177 clock_in.png','attendances/2005/1691460134 clock_out.png','Juan R',37365,NULL,'2023-08-07 09:59:37','2023-08-14 07:09:00'),(855,'2023-08-07 06:54:19','2023-08-07 15:32:26','12.249.250.150','12.249.250.150','closed',8,518,'attendances/622/1691416459 clock_in.png','attendances/622/1691447546 clock_out.png','Juan R',37382,NULL,'2023-08-07 10:54:19','2023-08-14 07:12:35'),(856,'2023-08-07 06:54:35','2023-08-07 15:31:55','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1774/1691416475 clock_in.png','attendances/1774/1691433115 clock_out.png','Juan R',37371,NULL,'2023-08-07 10:54:35','2023-08-14 07:05:35'),(857,'2023-08-07 06:55:13','2023-08-07 15:35:33','12.249.250.150','12.249.250.150','closed',8,520,'attendances/1588/1691416513 clock_in.png','attendances/1588/1691447733 clock_out.png','Juan R',37368,NULL,'2023-08-07 10:55:13','2023-08-14 07:03:46'),(858,'2023-08-07 06:55:26','2023-08-07 15:31:20','12.249.250.150','12.249.250.150','closed',8,515,'attendances/726/1691416526 clock_in.png','attendances/726/1691447480 clock_out.png','Juan R',37367,NULL,'2023-08-07 10:55:26','2023-08-14 06:58:11'),(859,'2023-08-07 06:55:44','2023-08-07 15:34:56','12.249.250.150','12.249.250.150','closed',8,519,'attendances/1395/1691416544 clock_in.png','attendances/1395/1691447696 clock_out.png','Juan R',37379,NULL,'2023-08-07 10:55:44','2023-08-14 07:09:58'),(860,'2023-08-07 06:55:58','2023-08-07 15:34:04','12.249.250.150','12.249.250.150','closed',8,518,'attendances/1898/1691416558 clock_in.png','attendances/1898/1691447644 clock_out.png','Juan R',37370,NULL,'2023-08-07 10:55:58','2023-08-14 07:06:01'),(861,'2023-08-07 06:56:11','2023-08-07 15:40:45','12.249.250.150','12.249.250.150','closed',8,524,'attendances/1948/1691416571 clock_in.png','attendances/1948/1691448045 clock_out.png','Juan R',37380,NULL,'2023-08-07 10:56:11','2023-08-14 07:11:03'),(862,'2023-08-07 06:56:21','2023-08-07 15:32:08','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1934/1691416581 clock_in.png','attendances/1934/1691447528 clock_out.png','Juan R',37375,NULL,'2023-08-07 10:56:21','2023-08-14 07:07:30'),(863,'2023-08-07 06:56:24','2023-08-07 15:31:12','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1728/1691416584 clock_in.png','attendances/1728/1691447472 clock_out.png','Juan R',37377,NULL,'2023-08-07 10:56:24','2023-08-14 07:08:13'),(864,'2023-08-07 06:57:08','2023-08-07 15:36:31','12.249.250.150','12.249.250.150','closed',8,519,'attendances/1958/1691416628 clock_in.png','attendances/1958/1691447791 clock_out.png','Juan R',37372,NULL,'2023-08-07 10:57:08','2023-08-14 07:06:19'),(865,'2023-08-07 06:57:50','2023-08-07 16:19:40','12.249.250.150','12.249.250.150','closed',9,561,'attendances/1455/1691416670 clock_in.png','attendances/1455/1691450380 clock_out.png','Juan R',37376,NULL,'2023-08-07 10:57:50','2023-08-14 07:07:52'),(866,'2023-08-07 07:00:38','2023-08-07 16:21:49','12.249.250.150','12.249.250.150','closed',9,561,'attendances/1450/1691416838 clock_in.png','attendances/1450/1691450509 clock_out.png','Juan R',37381,NULL,'2023-08-07 11:00:38','2023-08-14 07:11:27'),(867,'2023-08-07 07:00:49','2023-08-07 15:35:09','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1951/1691416849 clock_in.png','attendances/1951/1691447709 clock_out.png','Juan R',37369,NULL,'2023-08-07 11:00:49','2023-08-14 07:04:33'),(868,'2023-08-07 07:03:48','2023-08-07 15:42:39','12.249.250.150','12.249.250.150','closed',8,518,'attendances/1888/1691417028 clock_in.png','attendances/1888/1691448159 clock_out.png','Juan R',37383,NULL,'2023-08-07 11:03:48','2023-08-14 07:14:05'),(869,'2023-08-07 07:09:08','2023-08-07 15:36:45','12.249.250.150','12.249.250.150','closed',8,507,'attendances/1858/1691417348 clock_in.png','attendances/1858/1691447805 clock_out.png','Juan R',37378,NULL,'2023-08-07 11:09:08','2023-08-14 07:08:32'),(870,'2023-08-07 06:53:11','2023-08-07 15:34:32','12.249.250.150','12.249.250.150','closed',8,521,'attendances/1999/1691417531 clock_in.png','attendances/1999/1691447672 clock_out.png','Juan R',37373,NULL,'2023-08-07 11:12:11','2023-08-14 07:06:34'),(871,'2023-08-07 07:23:57','2023-08-07 15:41:44','12.249.250.150','12.249.250.150','closed',8,497,'attendances/1462/1691418237 clock_in.png','attendances/1462/1691448104 clock_out.png','Juan R',37374,NULL,'2023-08-07 11:23:57','2023-08-14 07:06:54'),(872,'2023-08-07 07:58:51','2023-08-07 16:31:21','12.249.250.150','12.249.250.150','closed',8,512,'attendances/775/1691420331 clock_in.png','attendances/775/1691451081 clock_out.png','Juan R',37385,NULL,'2023-08-07 11:58:51','2023-08-14 07:10:24'),(873,'2023-08-07 08:01:07','2023-08-07 16:55:55','12.249.250.150','12.249.250.150','closed',8,534,'attendances/1869/1691420467 clock_in.png','attendances/1869/1691452555 clock_out.png','Juan R',37384,NULL,'2023-08-07 12:01:07','2023-08-14 07:03:17'),(874,'2023-08-07 08:01:37','2023-08-07 16:55:54','12.249.250.150','12.249.250.150','closed',8,534,'attendances/1891/1691420497 clock_in.png','attendances/1891/1691452554 clock_out.png','Juan R',37386,NULL,'2023-08-07 12:01:37','2023-08-14 07:10:44'),(875,'2023-08-07 08:09:16','2023-08-07 16:31:11','12.249.250.150','12.249.250.150','closed',8,501,'attendances/1492/1691420956 clock_in.png','attendances/1492/1691451071 clock_out.png','Juan R',37387,NULL,'2023-08-07 12:09:16','2023-08-14 07:13:23'),(876,'2023-08-07 08:30:27','2023-08-07 17:00:08','12.249.250.150','12.249.250.150','closed',8,509,'attendances/1988/1691422227 clock_in.png','attendances/1988/1691452808 clock_out.png','Juan R',37388,NULL,'2023-08-07 12:30:27','2023-08-14 07:12:52'),(878,'2023-08-05 21:03:00','2023-08-05 22:53:00','190.2.214.172','190.2.214.172','closed',1,110,NULL,NULL,NULL,37398,NULL,'2023-08-07 17:11:08','2023-08-07 17:11:08'),(881,'2023-08-08 05:54:32','2023-08-08 14:32:41','12.249.250.150','12.249.250.150','closed',8,518,'attendances/1585/1691499272 clock_in.png','attendances/1585/1691530361 clock_out.png','Juan R',37406,NULL,'2023-08-08 09:54:32','2023-08-14 07:02:19'),(882,'2023-08-08 05:54:47','2023-08-08 14:31:42','12.249.250.150','12.249.250.150','closed',8,516,'attendances/2025/1691499287 clock_in.png','attendances/2025/1691530302 clock_out.png','Juan R',37410,NULL,'2023-08-08 09:54:47','2023-08-14 07:13:42'),(883,'2023-08-08 05:55:16','2023-08-08 14:32:56','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1551/1691499316 clock_in.png','attendances/1551/1691530376 clock_out.png','Juan R',37405,NULL,'2023-08-08 09:55:16','2023-08-14 06:58:25'),(884,'2023-08-08 06:00:42','2023-08-08 14:30:51','12.249.250.150','12.249.250.150','closed',8,510,'attendances/1455/1691499643 clock_in.png','attendances/1455/1691530251 clock_out.png','Juan R',37408,NULL,'2023-08-08 10:00:43','2023-08-14 07:07:46'),(885,'2023-08-08 06:03:00','2023-08-08 14:31:57','12.249.250.150','12.249.250.150','closed',8,508,'attendances/2005/1691499780 clock_in.png','attendances/2005/1691530317 clock_out.png','Juan R',37409,NULL,'2023-08-08 10:03:00','2023-08-14 07:08:56'),(886,'2023-08-08 06:51:30','2023-08-08 15:34:24','12.249.250.150','12.249.250.150','closed',8,522,'attendances/1999/1691502690 clock_in.png','attendances/1999/1691534064 clock_out.png','Juan R',37419,NULL,'2023-08-08 10:51:30','2023-08-14 07:06:31'),(887,'2023-08-08 06:53:11','2023-08-08 15:35:04','12.249.250.150','12.249.250.150','closed',8,521,'attendances/1948/1691502791 clock_in.png','attendances/1948/1691534104 clock_out.png','Juan R',37426,NULL,'2023-08-08 10:53:11','2023-08-14 07:10:58'),(888,'2023-08-08 06:54:58','2023-08-08 15:31:09','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1568/1691502898 clock_in.png','attendances/1568/1691533869 clock_out.png','Juan R',37412,NULL,'2023-08-08 10:54:58','2023-08-14 07:02:46'),(889,'2023-08-08 06:55:13','2023-08-08 15:31:26','12.249.250.150','12.249.250.150','closed',8,516,'attendances/622/1691502913 clock_in.png','attendances/622/1691533886 clock_out.png','Juan R',37429,NULL,'2023-08-08 10:55:13','2023-08-14 07:12:31'),(890,'2023-08-08 06:55:29','2023-08-08 15:32:50','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1774/1691502929 clock_in.png','attendances/1774/1691533970 clock_out.png','Juan R',37417,NULL,'2023-08-08 10:55:29','2023-08-14 07:05:26'),(891,'2023-08-08 06:55:57','2023-08-08 15:33:01','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1116/1691502957 clock_in.png','attendances/1116/1691533981 clock_out.png','Juan R',37424,NULL,'2023-08-08 10:55:57','2023-08-14 07:09:38'),(892,'2023-08-08 06:56:15','2023-08-08 15:34:41','12.249.250.150','12.249.250.150','closed',8,518,'attendances/1395/1691502975 clock_in.png','attendances/1395/1691534081 clock_out.png','Juan R',37425,NULL,'2023-08-08 10:56:15','2023-08-14 07:09:54'),(893,'2023-08-08 06:56:27','2023-08-08 15:36:08','12.249.250.150','12.249.250.150','closed',8,519,'attendances/1898/1691502987 clock_in.png','attendances/1898/1691534168 clock_out.png','Juan R',37416,NULL,'2023-08-08 10:56:27','2023-08-14 07:05:57'),(894,'2023-08-08 06:56:43','2023-08-08 16:29:19','12.249.250.150','12.249.250.150','closed',9,572,'attendances/1479/1691503003 clock_in.png','attendances/1479/1691537359 clock_out.png','Juan R',37414,NULL,'2023-08-08 10:56:43','2023-08-14 07:04:18'),(895,'2023-08-08 06:56:44','2023-08-08 15:32:55','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1934/1691503004 clock_in.png','attendances/1934/1691533975 clock_out.png','Juan R',37421,NULL,'2023-08-08 10:56:44','2023-08-14 07:07:26'),(896,'2023-08-08 06:56:57','2023-08-08 15:33:32','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1958/1691503017 clock_in.png','attendances/1958/1691534012 clock_out.png','Juan R',37418,NULL,'2023-08-08 10:56:57','2023-08-14 07:06:15'),(897,'2023-08-08 06:57:04','2023-08-08 15:31:02','12.249.250.150','12.249.250.150','closed',8,513,'attendances/1588/1691503024 clock_in.png','attendances/1588/1691533862 clock_out.png','Juan R',37413,NULL,'2023-08-08 10:57:04','2023-08-14 07:03:35'),(898,'2023-08-08 06:57:07','2023-08-08 15:57:00','12.249.250.150','12.249.250.150','closed',8,539,'attendances/726/1691503027 clock_in.png','attendances/726/1691520947 clock_out.png','Juan R',37431,NULL,'2023-08-08 10:57:07','2023-08-14 06:58:06'),(899,'2023-08-08 06:57:09','2023-08-08 15:33:23','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1858/1691503029 clock_in.png','attendances/1858/1691534003 clock_out.png','Juan R',37423,NULL,'2023-08-08 10:57:09','2023-08-14 07:08:27'),(900,'2023-08-08 06:57:29','2023-08-08 15:41:08','12.249.250.150','12.249.250.150','closed',8,523,'attendances/1462/1691503049 clock_in.png','attendances/1462/1691534468 clock_out.png','Juan R',37420,NULL,'2023-08-08 10:57:29','2023-08-14 07:06:49'),(901,'2023-08-08 06:57:52','2023-08-08 15:32:11','12.249.250.150','12.249.250.150','closed',8,514,'attendances/974/1691503072 clock_in.png','attendances/974/1691533931 clock_out.png','Juan R',37411,NULL,'2023-08-08 10:57:52','2023-08-14 06:52:23'),(902,'2023-08-08 06:59:17','2023-08-08 15:31:29','12.249.250.150','12.249.250.150','closed',8,512,'attendances/1953/1691503157 clock_in.png','attendances/1953/1691533889 clock_out.png','Juan R',37428,NULL,'2023-08-08 10:59:17','2023-08-14 11:53:35'),(903,'2023-08-08 06:59:19','2023-08-08 15:33:10','12.249.250.150','12.249.250.150','closed',8,513,'attendances/1951/1691503159 clock_in.png','attendances/1951/1691533990 clock_out.png','Juan R',37415,NULL,'2023-08-08 10:59:19','2023-08-14 07:04:31'),(904,'2023-08-08 06:59:44','2023-08-08 15:35:43','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1728/1691503184 clock_in.png','attendances/1728/1691534143 clock_out.png','Juan R',37422,NULL,'2023-08-08 10:59:44','2023-08-14 07:08:08'),(905,'2023-08-08 07:00:51','2023-08-08 15:30:56','12.249.250.150','12.249.250.150','closed',8,510,'attendances/1450/1691503251 clock_in.png','attendances/1450/1691533856 clock_out.png','Juan R',37427,NULL,'2023-08-08 11:00:51','2023-08-14 07:11:23'),(906,'2023-08-08 07:03:28','2023-08-08 16:21:31','12.249.250.150','12.249.250.150','closed',9,558,'attendances/1888/1691503408 clock_in.png','attendances/1888/1691536891 clock_out.png','Juan R',37430,NULL,'2023-08-08 11:03:28','2023-08-14 07:14:01'),(907,'2023-08-08 07:59:29','2023-08-08 16:34:49','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1869/1691506769 clock_in.png','attendances/1869/1691537689 clock_out.png','Juan R',37432,NULL,'2023-08-08 11:59:29','2023-08-14 07:03:08'),(908,'2023-08-08 08:00:14','2023-08-08 16:30:10','12.249.250.150','12.249.250.150','closed',8,509,'attendances/775/1691506814 clock_in.png','attendances/775/1691537410 clock_out.png','Juan R',37433,NULL,'2023-08-08 12:00:21','2023-08-14 07:10:19'),(909,'2023-08-08 08:04:46','2023-08-08 16:35:02','12.249.250.150','12.249.250.150','closed',8,510,'attendances/1891/1691507086 clock_in.png','attendances/1891/1691537702 clock_out.png','Juan R',37434,NULL,'2023-08-08 12:04:46','2023-08-14 07:10:40'),(910,'2023-08-08 08:16:13','2023-08-08 16:30:18','12.249.250.150','12.249.250.150','closed',8,494,'attendances/1492/1691507773 clock_in.png','attendances/1492/1691537418 clock_out.png','Juan R',37435,NULL,'2023-08-08 12:16:13','2023-08-14 07:13:19'),(912,'2023-08-09 05:56:54','2023-08-09 21:00:00','12.249.250.150','','closed',15,903,'attendances/1585/1691585814 clock_in.png',NULL,'Juan R',37454,NULL,'2023-08-09 09:56:54','2023-08-14 07:02:15'),(913,'2023-08-09 06:07:55','2023-08-09 21:00:00','12.249.250.150','','closed',14,892,'attendances/1551/1691586475 clock_in.png',NULL,'Juan R',37453,NULL,'2023-08-09 10:07:55','2023-08-14 06:58:22'),(914,'2023-08-09 06:53:53','2023-08-09 15:32:45','12.249.250.150','12.249.250.150','closed',8,518,'attendances/1774/1691589233 clock_in.png','attendances/1774/1691620365 clock_out.png','Juan R',37464,NULL,'2023-08-09 10:53:53','2023-08-14 07:05:21'),(915,'2023-08-09 06:54:34','2023-08-09 15:32:37','12.249.250.150','12.249.250.150','closed',8,518,'attendances/622/1691589274 clock_in.png','attendances/622/1691620357 clock_out.png','Juan R',37475,NULL,'2023-08-09 10:54:34','2023-08-14 07:12:27'),(916,'2023-08-09 06:55:13','2023-08-09 15:32:54','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1934/1691589313 clock_in.png','attendances/1934/1691620374 clock_out.png','Juan R',37468,NULL,'2023-08-09 10:55:13','2023-08-14 07:07:08'),(917,'2023-08-09 06:55:40','2023-08-09 15:31:31','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1568/1691589340 clock_in.png','attendances/1568/1691620291 clock_out.png','Juan R',37458,NULL,'2023-08-09 10:55:40','2023-08-14 07:02:35'),(918,'2023-08-09 06:55:50','2023-08-09 11:00:26','12.249.250.150','12.249.250.150','closed',4,244,'attendances/1588/1691589350 clock_in.png','attendances/1588/1691604026 clock_out.png','Juan R',37459,NULL,'2023-08-09 10:55:50','2023-08-14 07:03:30'),(919,'2023-08-09 06:56:02','2023-08-09 15:38:05','12.249.250.150','12.249.250.150','closed',8,522,'attendances/1958/1691589362 clock_in.png','attendances/1958/1691620685 clock_out.png','Juan R',37465,NULL,'2023-08-09 10:56:02','2023-08-14 07:06:10'),(920,'2023-08-09 06:56:42','2023-08-09 15:31:44','12.249.250.150','12.249.250.150','closed',8,515,'attendances/974/1691589402 clock_in.png','attendances/974/1691620304 clock_out.png','Juan R',37456,NULL,'2023-08-09 10:56:42','2023-08-14 06:52:16'),(921,'2023-08-09 06:57:14','2023-08-09 15:31:34','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1728/1691589434 clock_in.png','attendances/1728/1691620294 clock_out.png','Juan R',37469,NULL,'2023-08-09 10:57:14','2023-08-14 07:08:03'),(922,'2023-08-09 06:57:16','2023-08-09 15:30:16','12.249.250.150','12.249.250.150','closed',8,513,'attendances/382/1691589436 clock_in.png','attendances/382/1691620216 clock_out.png','Juan R',37461,NULL,'2023-08-09 10:57:16','2023-08-14 07:05:09'),(923,'2023-08-09 06:57:30','2023-08-09 15:30:50','12.249.250.150','12.249.250.150','closed',8,513,'attendances/726/1691589450 clock_in.png','attendances/726/1691620250 clock_out.png','Juan R',37457,NULL,'2023-08-09 10:57:30','2023-08-14 06:58:03'),(924,'2023-08-09 06:58:05','2023-08-09 15:32:08','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1999/1691589485 clock_in.png','attendances/1999/1691620328 clock_out.png','Juan R',37466,NULL,'2023-08-09 10:58:05','2023-08-14 07:06:28'),(925,'2023-08-09 06:58:22','2023-08-09 15:35:49','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1116/1691589502 clock_in.png','attendances/1116/1691605855 clock_out.png','Juan R',37471,NULL,'2023-08-09 10:58:22','2023-08-14 07:09:31'),(926,'2023-08-09 06:58:34','2023-08-09 15:31:48','12.249.250.150','12.249.250.150','closed',8,513,'attendances/1395/1691589514 clock_in.png','attendances/1395/1691620308 clock_out.png','Juan R',37472,NULL,'2023-08-09 10:58:34','2023-08-14 07:09:50'),(927,'2023-08-09 06:58:46','2023-08-09 16:42:39','12.249.250.150','12.249.250.150','closed',9,583,'attendances/1898/1691589526 clock_in.png','attendances/1898/1691624559 clock_out.png','Juan R',37463,NULL,'2023-08-09 10:58:46','2023-08-14 07:05:53'),(928,'2023-08-09 06:59:00','2023-08-09 15:31:21','12.249.250.150','12.249.250.150','closed',8,512,'attendances/1479/1691589540 clock_in.png','attendances/1479/1691620281 clock_out.png','Juan R',37460,NULL,'2023-08-09 10:59:00','2023-08-14 07:04:13'),(929,'2023-08-09 06:59:14','2023-08-09 15:41:51','12.249.250.150','12.249.250.150','closed',8,522,'attendances/1948/1691589554 clock_in.png','attendances/1948/1691620911 clock_out.png','Juan R',37473,NULL,'2023-08-09 10:59:14','2023-08-14 07:10:53'),(930,'2023-08-09 06:59:23','2023-08-09 15:35:24','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1462/1691589563 clock_in.png','attendances/1462/1691620524 clock_out.png','Juan R',37467,NULL,'2023-08-09 10:59:23','2023-08-14 07:06:43'),(931,'2023-08-09 07:00:03','2023-08-09 15:45:17','12.249.250.150','12.249.250.150','closed',8,525,'attendances/1951/1691589603 clock_in.png','attendances/1951/1691621117 clock_out.png','Juan R',37462,NULL,'2023-08-09 11:00:03','2023-08-14 07:04:27'),(932,'2023-08-09 07:04:24','2023-08-09 15:33:46','12.249.250.150','12.249.250.150','closed',8,509,'attendances/1450/1691589864 clock_in.png','attendances/1450/1691620426 clock_out.png','Juan R',37474,NULL,'2023-08-09 11:04:24','2023-08-14 07:11:14'),(933,'2023-08-09 07:05:27','2023-08-09 15:32:38','12.249.250.150','12.249.250.150','closed',8,507,'attendances/1888/1691589927 clock_in.png','attendances/1888/1691620358 clock_out.png','Juan R',37476,NULL,'2023-08-09 11:05:27','2023-08-14 07:13:57'),(934,'2023-08-09 07:10:47','2023-08-09 15:38:49','12.249.250.150','12.249.250.150','closed',8,508,'attendances/1858/1691590247 clock_in.png','attendances/1858/1691620729 clock_out.png','Juan R',37470,NULL,'2023-08-09 11:10:47','2023-08-14 07:08:24'),(935,'2023-08-09 07:56:53','2023-08-09 16:26:57','12.249.250.150','12.249.250.150','closed',8,510,'attendances/2025/1691593013 clock_in.png','attendances/2025/1691623617 clock_out.png','Juan R',37483,NULL,'2023-08-09 11:56:53','2023-08-14 07:13:38'),(936,'2023-08-09 08:00:16','2023-08-09 16:33:07','12.249.250.150','12.249.250.150','closed',8,512,'attendances/1891/1691593216 clock_in.png','attendances/1891/1691623987 clock_out.png','Juan R',37480,NULL,'2023-08-09 12:00:18','2023-08-14 07:10:35'),(937,'2023-08-09 08:00:44','2023-08-09 16:25:17','12.249.250.150','12.249.250.150','closed',8,504,'attendances/1455/1691593244 clock_in.png','attendances/1455/1691623517 clock_out.png','Juan R',37478,NULL,'2023-08-09 12:00:44','2023-08-14 07:07:43'),(938,'2023-08-09 08:01:02','2023-08-09 16:30:07','12.249.250.150','12.249.250.150','closed',8,509,'attendances/775/1691593262 clock_in.png','attendances/775/1691623807 clock_out.png','Juan R',37479,NULL,'2023-08-09 12:01:02','2023-08-14 07:10:13'),(939,'2023-08-09 08:02:32','2023-08-09 16:32:29','12.249.250.150','12.249.250.150','closed',8,509,'attendances/1869/1691593352 clock_in.png','attendances/1869/1691623949 clock_out.png','Juan R',37477,NULL,'2023-08-09 12:02:32','2023-08-14 07:03:04'),(940,'2023-08-09 08:11:11','2023-08-09 16:27:34','12.249.250.150','12.249.250.150','closed',8,496,'attendances/1953/1691593871 clock_in.png','attendances/1953/1691623654 clock_out.png','Juan R',37481,NULL,'2023-08-09 12:11:11','2023-08-14 07:12:17'),(941,'2023-08-09 08:11:28','2023-08-09 16:30:32','12.249.250.150','12.249.250.150','closed',8,499,'attendances/1492/1691593888 clock_in.png','attendances/1492/1691623832 clock_out.png','Juan R',37482,NULL,'2023-08-09 12:11:28','2023-08-14 07:13:16'),(942,'2023-08-09 08:32:31','2023-08-09 17:02:34','12.249.250.150','12.249.250.150','closed',8,510,'attendances/1988/1691595151 clock_in.png','attendances/1988/1691625754 clock_out.png','Juan R',37484,NULL,'2023-08-09 12:32:31','2023-08-14 07:12:47'),(946,'2023-08-09 08:45:00','2023-08-09 21:00:00','179.32.221.138','179.32.221.138','closed',12,735,NULL,NULL,'Juan R',37455,NULL,'2023-08-10 09:11:57','2023-08-14 07:08:44'),(947,'2023-08-10 05:54:06','2023-08-10 15:49:52','12.249.250.150','12.249.250.150','closed',9,595,'attendances/2025/1691672046 clock_in.png','attendances/2025/1691707792 clock_out.png','Juan R',37506,NULL,'2023-08-10 09:54:06','2023-08-14 07:13:34'),(948,'2023-08-10 05:55:17','2023-08-10 15:43:01','12.249.250.150','12.249.250.150','closed',9,587,'attendances/1585/1691672117 clock_in.png','attendances/1585/1691707381 clock_out.png','Juan R',37486,NULL,'2023-08-10 09:55:17','2023-08-14 07:02:11'),(949,'2023-08-10 05:56:06','2023-08-10 15:22:38','12.249.250.150','12.249.250.150','closed',9,566,'attendances/2005/1691672166 clock_in.png','attendances/2005/1691706158 clock_out.png','Juan R',37487,NULL,'2023-08-10 09:56:06','2023-08-14 07:08:38'),(950,'2023-08-10 05:58:16','2023-08-10 15:34:56','12.249.250.150','12.249.250.150','closed',9,576,'attendances/1551/1691672296 clock_in.png','attendances/1551/1691706896 clock_out.png','Juan R',37485,NULL,'2023-08-10 09:58:16','2023-08-14 06:58:18'),(951,'2023-08-10 06:02:39','2023-08-10 16:41:24','12.249.250.150','12.249.250.150','closed',10,638,'attendances/1450/1691672559 clock_in.png','attendances/1450/1691710884 clock_out.png','Juan R',37504,NULL,'2023-08-10 10:02:39','2023-08-14 07:11:10'),(952,'2023-08-10 06:25:50','2023-08-10 15:00:12','12.249.250.150','12.249.250.150','closed',8,514,'attendances/622/1691673950 clock_in.png','attendances/622/1691704812 clock_out.png','Juan R',37505,NULL,'2023-08-10 10:25:50','2023-08-14 07:12:23'),(953,'2023-08-10 06:26:03','2023-08-10 14:59:25','12.249.250.150','12.249.250.150','closed',8,513,'attendances/1774/1691673963 clock_in.png','attendances/1774/1691704765 clock_out.png','Juan R',37494,NULL,'2023-08-10 10:26:03','2023-08-14 07:05:17'),(954,'2023-08-10 06:26:16','2023-08-10 15:00:40','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1934/1691673976 clock_in.png','attendances/1934/1691704840 clock_out.png','Juan R',37498,NULL,'2023-08-10 10:26:16','2023-08-14 07:07:05'),(955,'2023-08-10 06:53:58','2023-08-10 17:03:18','12.249.250.150','12.249.250.150','closed',10,609,'attendances/1999/1691675638 clock_in.png','attendances/1999/1691712198 clock_out.png','Juan R',37496,NULL,'2023-08-10 10:53:58','2023-08-14 07:06:25'),(956,'2023-08-10 06:54:02','2023-08-10 16:42:03','12.249.250.150','12.249.250.150','closed',9,588,'attendances/1588/1691675642 clock_in.png','attendances/1588/1691710923 clock_out.png','Juan Juan RR',37490,NULL,'2023-08-10 10:54:02','2023-08-14 07:03:26'),(957,'2023-08-10 06:54:32','2023-08-10 16:40:03','12.249.250.150','12.249.250.150','closed',9,585,'attendances/974/1691675672 clock_in.png','attendances/974/1691710803 clock_out.png','Juan R',37488,NULL,'2023-08-10 10:54:32','2023-08-14 06:52:11'),(958,'2023-08-10 06:54:49','2023-08-10 17:03:54','12.249.250.150','12.249.250.150','closed',10,609,'attendances/1395/1691675689 clock_in.png','attendances/1395/1691712234 clock_out.png','Juan R',37502,NULL,'2023-08-10 10:54:49','2023-08-14 07:09:47'),(959,'2023-08-10 06:55:10','2023-08-10 15:36:42','12.249.250.150','12.249.250.150','closed',8,521,'attendances/1948/1691675710 clock_in.png','attendances/1948/1691707002 clock_out.png','Juan R',37503,NULL,'2023-08-10 10:55:10','2023-08-14 07:10:50'),(960,'2023-08-10 06:55:26','2023-08-10 15:36:09','12.249.250.150','12.249.250.150','closed',8,520,'attendances/1898/1691675726 clock_in.png','attendances/1898/1691706969 clock_out.png','Juan R',37493,NULL,'2023-08-10 10:55:26','2023-08-14 07:05:49'),(961,'2023-08-10 06:55:52','2023-08-10 16:09:29','12.249.250.150','12.249.250.150','closed',9,553,'attendances/1728/1691675752 clock_in.png','attendances/1728/1691708969 clock_out.png','Juan R',37500,NULL,'2023-08-10 10:55:52','2023-08-14 07:07:59'),(962,'2023-08-10 06:56:12','2023-08-10 16:42:41','12.249.250.150','12.249.250.150','closed',9,586,'attendances/1568/1691675772 clock_in.png','attendances/1568/1691710961 clock_out.png','Juan R',37489,NULL,'2023-08-10 10:56:12','2023-08-14 07:02:31'),(963,'2023-08-10 06:56:38','2023-08-10 15:38:43','12.249.250.150','12.249.250.150','closed',8,522,'attendances/1951/1691675798 clock_in.png','attendances/1951/1691707123 clock_out.png','Juan R',37492,NULL,'2023-08-10 10:56:38','2023-08-14 07:04:24'),(964,'2023-08-10 06:59:14','2023-08-10 16:00:28','12.249.250.150','12.249.250.150','closed',9,541,'attendances/1462/1691675954 clock_in.png','attendances/1462/1691708428 clock_out.png','Juan R',37497,NULL,'2023-08-10 10:59:14','2023-08-14 07:06:40'),(965,'2023-08-10 07:00:07','2023-08-10 15:32:09','12.249.250.150','12.249.250.150','closed',8,512,'attendances/1958/1691676007 clock_in.png','attendances/1958/1691706729 clock_out.png','Juan R',37495,NULL,'2023-08-10 11:00:07','2023-08-14 07:06:07'),(966,'2023-08-10 07:00:13','2023-08-10 17:03:06','12.249.250.150','12.249.250.150','closed',10,602,'attendances/1479/1691676013 clock_in.png','attendances/1479/1691712186 clock_out.png','Juan R',37491,NULL,'2023-08-10 11:00:13','2023-08-14 07:04:07'),(967,'2023-08-10 07:00:25','2023-08-10 15:48:28','12.249.250.150','12.249.250.150','closed',8,528,'attendances/1455/1691676025 clock_in.png','attendances/1455/1691707708 clock_out.png','Juan R',37499,NULL,'2023-08-10 11:00:25','2023-08-14 07:07:39'),(968,'2023-08-10 07:02:08','2023-08-10 15:36:20','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1888/1691676128 clock_in.png','attendances/1888/1691706980 clock_out.png','Juan R',37507,NULL,'2023-08-10 11:02:08','2023-08-14 07:13:54'),(969,'2023-08-10 07:06:25','2023-08-10 15:32:26','12.249.250.150','12.249.250.150','closed',8,506,'attendances/1858/1691676385 clock_in.png','attendances/1858/1691706746 clock_out.png','Juan R',37501,NULL,'2023-08-10 11:06:25','2023-08-14 07:08:21'),(970,'2023-08-10 07:59:36','2023-08-10 16:30:14','12.249.250.150','12.249.250.150','closed',8,510,'attendances/775/1691679576 clock_in.png','attendances/775/1691710214 clock_out.png','Juan R',37509,NULL,'2023-08-10 11:59:36','2023-08-14 07:10:08'),(971,'2023-08-10 08:04:06','2023-08-10 16:31:39','12.249.250.150','12.249.250.150','closed',8,507,'attendances/1869/1691679846 clock_in.png','attendances/1869/1691710299 clock_out.png','Juan R',37508,NULL,'2023-08-10 12:04:06','2023-08-14 07:03:00'),(972,'2023-08-10 08:16:36','2023-08-10 16:30:13','12.249.250.150','12.249.250.150','closed',8,493,'attendances/1492/1691680596 clock_in.png','attendances/1492/1691710213 clock_out.png','Juan R',37511,NULL,'2023-08-10 12:16:36','2023-08-14 07:13:12'),(974,'2023-08-10 08:40:07','2023-08-10 17:09:16','12.249.250.150','12.249.250.150','closed',8,509,'attendances/1988/1691682007 clock_in.png','attendances/1988/1691712556 clock_out.png','Juan R',37512,NULL,'2023-08-10 12:40:07','2023-08-14 07:12:43'),(975,'2023-08-10 08:01:36','2023-08-10 16:31:52','12.249.250.150','12.249.250.150','closed',8,510,'attendances/1891/1691695935 clock_in.png','attendances/1891/1691710312 clock_out.png','Juan R',37510,NULL,'2023-08-10 16:32:15','2023-08-14 07:10:32'),(976,'2023-08-10 13:26:06','2023-08-10 19:29:28','12.249.250.150','12.249.250.150','closed',6,363,'attendances/1953/1691699166 clock_in.png','attendances/1953/1691720968 clock_out.png','Juan R',37514,NULL,'2023-08-10 17:26:06','2023-08-14 07:12:07'),(977,'2023-08-10 13:51:12','2023-08-10 19:22:47','12.249.250.150','12.249.250.150','closed',5,331,'attendances/1116/1691700672 clock_in.png','attendances/1116/1691720567 clock_out.png','Juan R',37513,NULL,'2023-08-10 17:51:12','2023-08-14 07:09:25'),(979,'2023-08-11 04:55:51','2023-08-11 16:27:02','12.249.250.150','12.249.250.150','closed',11,691,'attendances/2025/1691754951 clock_in.png','attendances/2025/1691796422 clock_out.png','Juan R',37552,NULL,'2023-08-11 08:55:51','2023-08-14 07:13:30'),(980,'2023-08-11 04:56:10','2023-08-11 16:31:51','12.249.250.150','12.249.250.150','closed',11,695,'attendances/1588/1691754970 clock_in.png','attendances/1588/1691796711 clock_out.png','Juan R',37550,NULL,'2023-08-11 08:56:11','2023-08-14 07:03:21'),(981,'2023-08-11 05:02:45','2023-08-11 16:33:07','12.249.250.150','12.249.250.150','closed',11,690,'attendances/1450/1691755365 clock_in.png','attendances/1450/1691796787 clock_out.png','Juan R',37551,NULL,'2023-08-11 09:02:45','2023-08-14 07:11:06'),(982,'2023-08-11 05:55:11','2023-08-11 15:25:37','12.249.250.150','12.249.250.150','closed',9,570,'attendances/1551/1691758511 clock_in.png','attendances/1551/1691792737 clock_out.png','Juan R',37553,NULL,'2023-08-11 09:55:11','2023-08-14 06:58:15'),(983,'2023-08-11 05:56:02','2023-08-11 15:56:15','12.249.250.150','12.249.250.150','closed',10,600,'attendances/1728/1691758562 clock_in.png','attendances/1728/1691794575 clock_out.png','Juan R',37570,NULL,'2023-08-11 09:56:02','2023-08-14 07:07:56'),(984,'2023-08-11 05:56:03','2023-08-11 15:26:07','12.249.250.150','12.249.250.150','closed',9,570,'attendances/1585/1691758563 clock_in.png','attendances/1585/1691792767 clock_out.png','Juan R',37554,NULL,'2023-08-11 09:56:03','2023-08-14 07:02:07'),(985,'2023-08-11 05:57:51','2023-08-11 14:26:29','12.249.250.150','12.249.250.150','closed',8,508,'attendances/2005/1691758671 clock_in.png','attendances/2005/1691789189 clock_out.png','Juan R',37556,NULL,'2023-08-11 09:57:51','2023-08-14 07:08:35'),(987,'2023-08-11 05:59:30','2023-08-11 15:57:16','12.249.250.150','12.249.250.150','closed',9,597,'attendances/1999/1691758770 clock_in.png','attendances/1999/1691794636 clock_out.png','Juan R',37567,NULL,'2023-08-11 09:59:30','2023-08-14 07:06:22'),(988,'2023-08-11 06:02:33','2023-08-11 17:04:43','12.249.250.150','12.249.250.150','closed',11,662,'attendances/1455/1691758953 clock_in.png','attendances/1455/1691798683 clock_out.png','Juan R',37555,NULL,'2023-08-11 10:02:33','2023-08-14 07:07:36'),(989,'2023-08-11 06:04:20','2023-08-11 17:18:40','12.249.250.150','12.249.250.150','closed',11,674,'attendances/1953/1691759060 clock_in.png','attendances/1953/1691799520 clock_out.png','Juan R',37557,NULL,'2023-08-11 10:04:20','2023-08-14 07:12:03'),(990,'2023-08-09 16:48:00','2023-08-09 18:38:00','179.32.221.138','179.32.221.138','closed',1,110,NULL,NULL,'Juan R',37583,NULL,'2023-08-11 10:36:44','2023-08-14 07:12:11'),(991,'2023-08-11 06:51:32','2023-08-11 15:32:13','12.249.250.150','12.249.250.150','closed',8,520,'attendances/1774/1691761892 clock_in.png','attendances/1774/1691793133 clock_out.png','Juan R',37565,NULL,'2023-08-11 10:51:32','2023-08-14 07:05:13'),(992,'2023-08-11 06:51:46','2023-08-11 17:21:09','12.249.250.150','12.249.250.150','closed',10,629,'attendances/382/1691761906 clock_in.png','attendances/382/1691799669 clock_out.png','Juan R',37562,NULL,'2023-08-11 10:51:46','2023-08-14 07:04:43'),(993,'2023-08-11 06:52:21','2023-08-11 16:42:46','12.249.250.150','12.249.250.150','closed',9,590,'attendances/1116/1691761941 clock_in.png','attendances/1116/1691797366 clock_out.png','Juan R',37572,NULL,'2023-08-11 10:52:21','2023-08-14 07:09:22'),(994,'2023-08-11 06:54:05','2023-08-11 15:37:29','12.249.250.150','12.249.250.150','closed',8,523,'attendances/1948/1691762045 clock_in.png','attendances/1948/1691793449 clock_out.png','Juan R',37574,NULL,'2023-08-11 10:54:05','2023-08-14 07:10:47'),(995,'2023-08-11 06:54:31','2023-08-11 16:26:24','12.249.250.150','12.249.250.150','closed',9,571,'attendances/726/1691762071 clock_in.png','attendances/726/1691796384 clock_out.png','Juan R',37559,NULL,'2023-08-11 10:54:31','2023-08-14 06:58:00'),(996,'2023-08-11 06:55:09','2023-08-11 15:46:51','12.249.250.150','12.249.250.150','closed',8,531,'attendances/1951/1691762109 clock_in.png','attendances/1951/1691794011 clock_out.png','Juan R',37563,NULL,'2023-08-11 10:55:09','2023-08-14 07:04:21'),(997,'2023-08-11 06:55:50','2023-08-11 15:32:42','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1934/1691762150 clock_in.png','attendances/1934/1691793162 clock_out.png','Juan R',37569,NULL,'2023-08-11 10:55:50','2023-08-14 07:07:02'),(998,'2023-08-11 06:56:04','2023-08-11 15:56:52','12.249.250.150','12.249.250.150','closed',9,540,'attendances/1479/1691762164 clock_in.png','attendances/1479/1691794612 clock_out.png','Juan R',37561,NULL,'2023-08-11 10:56:04','2023-08-14 07:04:04'),(999,'2023-08-11 06:56:07','2023-08-11 15:33:06','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1858/1691762167 clock_in.png','attendances/1858/1691793186 clock_out.png','Juan R',37571,NULL,'2023-08-11 10:56:07','2023-08-14 07:08:17'),(1000,'2023-08-11 06:56:16','2023-08-11 15:32:00','12.249.250.150','12.249.250.150','closed',8,515,'attendances/622/1691762176 clock_in.png','attendances/622/1691793120 clock_out.png','Juan R',37575,NULL,'2023-08-11 10:56:16','2023-08-14 07:12:19'),(1001,'2023-08-11 06:56:23','2023-08-11 17:41:22','12.249.250.150','12.249.250.150','closed',10,644,'attendances/1395/1691762183 clock_in.png','attendances/1395/1691800882 clock_out.png','Juan R',37573,NULL,'2023-08-11 10:56:23','2023-08-14 07:09:43'),(1002,'2023-08-11 06:56:32','2023-08-11 15:32:52','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1958/1691762192 clock_in.png','attendances/1958/1691793172 clock_out.png','Juan R',37566,NULL,'2023-08-11 10:56:32','2023-08-14 07:06:04'),(1003,'2023-08-11 06:56:56','2023-08-11 15:44:24','12.249.250.150','12.249.250.150','closed',8,527,'attendances/1898/1691762216 clock_in.png','attendances/1898/1691793864 clock_out.png','Juan R',37564,NULL,'2023-08-11 10:56:56','2023-08-14 07:05:45'),(1004,'2023-08-11 06:56:56','2023-08-11 15:39:54','12.249.250.150','12.249.250.150','closed',8,522,'attendances/1568/1691762216 clock_in.png','attendances/1568/1691793594 clock_out.png','Juan R',37560,NULL,'2023-08-11 10:56:56','2023-08-14 07:02:27'),(1005,'2023-08-11 06:57:40','2023-08-11 15:34:48','12.249.250.150','12.249.250.150','closed',8,517,'attendances/974/1691762260 clock_in.png','attendances/974/1691793288 clock_out.png','Juan R',37558,NULL,'2023-08-11 10:57:40','2023-08-14 06:52:04'),(1006,'2023-08-11 07:01:37','2023-08-11 15:34:00','12.249.250.150','12.249.250.150','closed',8,512,'attendances/1888/1691762497 clock_in.png','attendances/1888/1691793240 clock_out.png','Juan R',37576,NULL,'2023-08-11 11:01:37','2023-08-14 07:13:51'),(1007,'2023-08-11 07:04:09','2023-08-11 15:41:53','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1462/1691762649 clock_in.png','attendances/1462/1691793713 clock_out.png','Juan R',37568,NULL,'2023-08-11 11:04:09','2023-08-14 07:06:37'),(1008,'2023-08-11 07:58:28','2023-08-11 16:30:35','12.249.250.150','12.249.250.150','closed',8,512,'attendances/775/1691765908 clock_in.png','attendances/775/1691796635 clock_out.png','Juan R',37578,NULL,'2023-08-11 11:58:28','2023-08-14 07:10:01'),(1009,'2023-08-11 08:00:43','2023-08-11 16:47:03','12.249.250.150','12.249.250.150','closed',8,526,'attendances/1891/1691766043 clock_in.png','attendances/1891/1691797623 clock_out.png','Juan R',37579,NULL,'2023-08-11 12:00:43','2023-08-14 07:10:28'),(1010,'2023-08-11 08:03:20','2023-08-11 16:46:51','12.249.250.150','12.249.250.150','closed',8,523,'attendances/1869/1691766200 clock_in.png','attendances/1869/1691797611 clock_out.png','Juan R',37577,NULL,'2023-08-11 12:03:20','2023-08-14 07:02:56'),(1011,'2023-08-11 08:12:35','2023-08-11 16:31:09','12.249.250.150','12.249.250.150','closed',8,498,'attendances/1492/1691766755 clock_in.png','attendances/1492/1691796669 clock_out.png','Juan R',37580,NULL,'2023-08-11 12:12:35','2023-08-14 07:12:59'),(1012,'2023-08-11 08:28:48','2023-08-11 17:05:05','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1988/1691767728 clock_in.png','attendances/1988/1691798705 clock_out.png','Juan R',37582,NULL,'2023-08-11 12:28:48','2023-08-14 07:12:38'),(1014,'2023-08-12 05:56:12','2023-08-12 14:03:23','12.249.250.150','12.249.250.150','closed',8,487,'attendances/1116/1691844972 clock_in.png','attendances/1116/1691874203 clock_out.png','Juan R',37591,NULL,'2023-08-12 09:56:12','2023-08-14 07:09:17'),(1015,'2023-08-12 05:58:23','2023-08-12 14:33:45','12.249.250.150','12.249.250.150','closed',8,515,'attendances/382/1691845103 clock_in.png','attendances/382/1691876025 clock_out.png','Juan R',37590,NULL,'2023-08-12 09:58:23','2023-08-14 07:04:42'),(1016,'2023-08-12 06:06:12','2023-08-12 14:55:19','12.249.250.150','12.249.250.150','closed',8,529,'attendances/974/1691845572 clock_in.png','attendances/974/1691877319 clock_out.png','Juan R',37589,NULL,'2023-08-12 10:06:12','2023-08-14 06:51:57'),(1017,'2023-08-12 06:57:39','2023-08-12 14:00:53','12.249.250.150','12.249.250.150','closed',7,423,'attendances/1479/1691848659 clock_in.png','attendances/1479/1691874053 clock_out.png','Juan R',37593,NULL,'2023-08-12 10:57:39','2023-08-14 07:04:00'),(1018,'2023-08-12 06:59:50','2023-08-12 17:30:26','12.249.250.150','12.249.250.150','closed',10,630,'attendances/726/1691848790 clock_in.png','attendances/726/1691886626 clock_out.png','Juan R',37592,NULL,'2023-08-12 10:59:50','2023-08-14 06:57:55'),(1019,'2023-08-12 19:00:12','2023-08-12 20:50:49','12.249.250.150','12.249.250.150','closed',1,110,'attendances/1479/1691892012 clock_in.png','attendances/1479/1691898649 clock_out.png','Juan R',37635,NULL,'2023-08-12 23:00:12','2023-08-14 07:03:56'),(1020,'2023-08-12 19:51:52','2023-08-12 23:59:00','12.249.250.150','','closed',4,247,'attendances/1116/1691895112 clock_in.png',NULL,'Juan R',37637,NULL,'2023-08-12 23:51:52','2023-08-14 12:01:34'),(1021,'2023-08-12 20:24:00','2023-08-12 23:59:00','12.249.250.150','','closed',3,215,'attendances/726/1691897040 clock_in.png',NULL,'Juan R',37636,NULL,'2023-08-13 00:24:00','2023-08-14 11:40:10'),(1024,'2023-08-13 05:51:57','2023-08-13 14:18:12','12.249.250.150','12.249.250.150','closed',8,506,'attendances/1953/1691961535 clock_in.png','attendances/1953/1691961552 clock_out.png','Juan R',37594,NULL,'2023-08-13 18:18:55','2023-08-14 11:24:04'),(1025,'2023-08-14 05:54:26','2023-08-14 18:02:30','12.249.250.150','12.249.250.150','closed',12,728,'attendances/1551/1692017666 clock_in.png','attendances/1551/1692061350 clock_out.png','Juan R',37599,NULL,'2023-08-14 09:54:26','2023-08-22 12:51:03'),(1026,'2023-08-14 05:54:33','2023-08-14 18:06:56','12.249.250.150','12.249.250.150','closed',12,732,'attendances/1585/1692017673 clock_in.png','attendances/1585/1692061616 clock_out.png','Juan R',37600,NULL,'2023-08-14 09:54:33','2023-08-22 12:51:56'),(1027,'2023-08-14 05:55:19','2023-08-14 15:30:35','12.249.250.150','12.249.250.150','closed',9,575,'attendances/974/1692017719 clock_in.png','attendances/974/1692052235 clock_out.png','Juan R',37598,NULL,'2023-08-14 09:55:19','2023-08-22 12:49:47'),(1028,'2023-08-14 05:55:36','2023-08-14 15:22:40','12.249.250.150','12.249.250.150','closed',9,567,'attendances/2025/1692017736 clock_in.png','attendances/2025/1692051760 clock_out.png','Juan R',37605,NULL,'2023-08-14 09:55:36','2023-08-22 13:06:42'),(1029,'2023-08-14 05:55:52','2023-08-14 15:32:13','12.249.250.150','12.249.250.150','closed',9,576,'attendances/1568/1692017752 clock_in.png','attendances/1568/1692052333 clock_out.png','Juan R',37601,NULL,'2023-08-14 09:55:52','2023-08-22 12:52:19'),(1030,'2023-08-14 05:57:18','2023-08-14 18:05:27','12.249.250.150','12.249.250.150','closed',12,728,'attendances/2005/1692017838 clock_in.png','attendances/2005/1692061527 clock_out.png','Juan R',37603,NULL,'2023-08-14 09:57:18','2023-08-22 13:01:41'),(1031,'2023-08-14 06:02:48','2023-08-14 18:02:38','12.249.250.150','12.249.250.150','closed',11,719,'attendances/382/1692018168 clock_in.png','attendances/382/1692061358 clock_out.png','Juan R',37602,NULL,'2023-08-14 10:02:48','2023-08-22 12:55:56'),(1032,'2023-08-14 06:03:26','2023-08-14 15:40:05','12.249.250.150','12.249.250.150','closed',9,576,'attendances/1450/1692018206 clock_in.png','attendances/1450/1692052805 clock_out.png','Juan R',37604,NULL,'2023-08-14 10:03:26','2023-08-22 13:31:55'),(1033,'2023-08-14 06:12:22','2023-08-14 16:14:40','12.249.250.150','12.249.250.150','closed',10,602,'attendances/1479/1692018742 clock_in.png','attendances/1479/1692054880 clock_out.png','Juan R',37608,NULL,'2023-08-14 10:12:22','2023-08-22 12:54:51'),(1034,'2023-08-14 06:52:03','2023-08-14 16:32:28','12.249.250.150','12.249.250.150','closed',9,580,'attendances/1116/1692021123 clock_in.png','attendances/1116/1692055948 clock_out.png','Juan R',37618,NULL,'2023-08-14 10:52:03','2023-08-22 13:02:04'),(1035,'2023-08-14 06:52:28','2023-08-14 15:31:57','12.249.250.150','12.249.250.150','closed',8,519,'attendances/726/1692021148 clock_in.png','attendances/726/1692052317 clock_out.png','Juan R',37606,NULL,'2023-08-14 10:52:28','2023-08-22 12:50:23'),(1036,'2023-08-14 06:54:56','2023-08-14 16:22:52','12.249.250.150','12.249.250.150','closed',9,567,'attendances/1588/1692021296 clock_in.png','attendances/1588/1692055372 clock_out.png','Juan R',37607,NULL,'2023-08-14 10:54:56','2023-08-22 12:53:51'),(1037,'2023-08-14 06:55:09','2023-08-14 15:31:32','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1774/1692021309 clock_in.png','attendances/1774/1692052292 clock_out.png','Juan R',37611,NULL,'2023-08-14 10:55:09','2023-08-22 12:56:35'),(1038,'2023-08-14 06:56:02','2023-08-14 16:31:50','12.249.250.150','12.249.250.150','closed',9,575,'attendances/1999/1692021362 clock_in.png','attendances/1999/1692055910 clock_out.png','Juan R',37613,NULL,'2023-08-14 10:56:02','2023-08-22 12:58:12'),(1039,'2023-08-14 06:56:23','2023-08-14 15:32:34','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1858/1692021383 clock_in.png','attendances/1858/1692052354 clock_out.png','Juan R',37617,NULL,'2023-08-14 10:56:23','2023-08-22 13:01:06'),(1040,'2023-08-14 06:56:33','2023-08-14 15:31:16','12.249.250.150','12.249.250.150','closed',8,514,'attendances/622/1692021393 clock_in.png','attendances/622/1692052276 clock_out.png','Juan R',37622,NULL,'2023-08-14 10:56:33','2023-08-22 13:08:25'),(1041,'2023-08-14 06:56:56','2023-08-14 15:31:53','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1934/1692021416 clock_in.png','attendances/1934/1692052313 clock_out.png','Juan R',37615,NULL,'2023-08-14 10:56:56','2023-08-22 12:59:14'),(1042,'2023-08-14 06:58:04','2023-08-14 16:02:17','12.249.250.150','12.249.250.150','closed',9,544,'attendances/1728/1692021484 clock_in.png','attendances/1728/1692054137 clock_out.png','Juan R',37616,NULL,'2023-08-14 10:58:04','2023-08-22 13:00:35'),(1043,'2023-08-14 06:58:07','2023-08-14 15:33:00','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1958/1692021487 clock_in.png','attendances/1958/1692052380 clock_out.png','Juan R',37612,NULL,'2023-08-14 10:58:07','2023-08-22 12:57:20'),(1044,'2023-08-14 06:58:19','2023-08-14 16:46:34','12.249.250.150','12.249.250.150','closed',9,588,'attendances/1395/1692021499 clock_in.png','attendances/1395/1692056794 clock_out.png','Juan R',37619,NULL,'2023-08-14 10:58:19','2023-08-22 13:02:43'),(1045,'2023-08-14 06:58:36','2023-08-14 15:35:30','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1948/1692021516 clock_in.png','attendances/1948/1692052530 clock_out.png','Juan R',37620,NULL,'2023-08-14 10:58:36','2023-08-22 13:04:43'),(1046,'2023-08-14 06:59:53','2023-08-14 15:47:36','12.249.250.150','12.249.250.150','closed',8,527,'attendances/1888/1692021593 clock_in.png','attendances/1888/1692053256 clock_out.png','Juan R',37623,NULL,'2023-08-14 10:59:53','2023-08-22 13:06:03'),(1047,'2023-08-14 07:00:32','2023-08-14 15:33:43','12.249.250.150','12.249.250.150','closed',8,513,'attendances/1951/1692021632 clock_in.png','attendances/1951/1692052423 clock_out.png','Juan R',37609,NULL,'2023-08-14 11:00:32','2023-08-22 12:55:18'),(1048,'2023-08-14 07:08:58','2023-08-14 16:30:23','12.249.250.150','12.249.250.150','closed',9,561,'attendances/1953/1692022138 clock_in.png','attendances/1953/1692055823 clock_out.png','Juan R',37621,NULL,'2023-08-14 11:08:58','2023-08-22 13:32:19'),(1049,'2023-08-14 07:14:45','2023-08-14 15:47:08','12.249.250.150','12.249.250.150','closed',8,512,'attendances/1462/1692022485 clock_in.png','attendances/1462/1692053228 clock_out.png','Juan R',37614,NULL,'2023-08-14 11:14:45','2023-08-22 12:58:44'),(1050,'2023-08-13 00:00:00','2023-08-13 00:02:00','190.2.214.172','190.2.214.172','closed',0,2,NULL,NULL,NULL,37668,NULL,'2023-08-14 11:49:35','2023-08-14 11:50:16'),(1051,'2023-08-14 07:57:49','2023-08-14 16:55:12','12.249.250.150','12.249.250.150','closed',8,537,'attendances/1455/1692025069 clock_in.png','attendances/1455/1692057312 clock_out.png','Juan R',37625,NULL,'2023-08-14 11:57:49','2023-08-22 13:00:04'),(1052,'2023-08-14 07:58:51','2023-08-14 16:30:05','12.249.250.150','12.249.250.150','closed',8,511,'attendances/775/1692025131 clock_in.png','attendances/775/1692055805 clock_out.png','Juan R',37626,NULL,'2023-08-14 11:58:51','2023-08-22 13:03:28'),(1053,'2023-08-14 08:00:59','2023-08-14 16:34:52','12.249.250.150','12.249.250.150','closed',8,513,'attendances/1891/1692025259 clock_in.png','attendances/1891/1692056092 clock_out.png','Juan R',37627,NULL,'2023-08-14 12:00:59','2023-08-22 13:04:16'),(1054,'2023-08-14 08:02:19','2023-08-14 16:34:40','12.249.250.150','12.249.250.150','closed',8,512,'attendances/1869/1692025339 clock_in.png','attendances/1869/1692056080 clock_out.png','Juan R',37624,NULL,'2023-08-14 12:02:19','2023-08-22 12:53:20'),(1055,'2023-08-13 00:00:00','2023-08-13 00:02:00','190.2.214.172','190.2.214.172','closed',0,2,NULL,NULL,NULL,37669,NULL,'2023-08-14 12:04:45','2023-08-14 12:04:45'),(1056,'2023-08-14 08:13:33','2023-08-14 16:29:52','12.249.250.150','12.249.250.150','closed',8,496,'attendances/1492/1692026013 clock_in.png','attendances/1492/1692055792 clock_out.png','Juan R',37628,NULL,'2023-08-14 12:13:33','2023-08-22 13:07:13'),(1057,'2023-08-14 08:30:17','2023-08-14 17:20:06','12.249.250.150','12.249.250.150','closed',8,529,'attendances/1988/1692027017 clock_in.png','attendances/1988/1692058806 clock_out.png','Juan R',37629,NULL,'2023-08-14 12:30:17','2023-08-22 13:07:46'),(1058,'2023-08-15 04:55:11','2023-08-15 19:32:27','12.249.250.150','12.249.250.150','closed',14,877,'attendances/1588/1692100511 clock_in.png','attendances/1588/1692153147 clock_out.png','Juan R',37674,NULL,'2023-08-15 08:55:11','2023-08-22 12:53:42'),(1059,'2023-08-15 05:02:18','2023-08-15 19:34:35','12.249.250.150','12.249.250.150','closed',14,872,'attendances/1450/1692100938 clock_in.png','attendances/1450/1692153275 clock_out.png','Juan R',37677,NULL,'2023-08-15 09:02:18','2023-08-22 13:31:48'),(1060,'2023-08-15 05:02:42','2023-08-15 19:32:46','12.249.250.150','12.249.250.150','closed',14,870,'attendances/1953/1692100962 clock_in.png','attendances/1953/1692153166 clock_out.png','Juan R',37678,NULL,'2023-08-15 09:02:42','2023-08-22 13:32:08'),(1061,'2023-08-15 05:53:53','2023-08-15 18:41:22','12.249.250.150','12.249.250.150','closed',12,767,'attendances/1551/1692104033 clock_in.png','attendances/1551/1692150082 clock_out.png','Juan R',37671,NULL,'2023-08-15 09:53:53','2023-08-22 12:50:50'),(1062,'2023-08-15 05:54:20','2023-08-15 18:43:31','12.249.250.150','12.249.250.150','closed',12,769,'attendances/1585/1692104060 clock_in.png','attendances/1585/1692150211 clock_out.png','Juan R',37672,NULL,'2023-08-15 09:54:20','2023-08-22 12:51:49'),(1063,'2023-08-15 05:55:55','2023-08-15 15:33:36','12.249.250.150','12.249.250.150','closed',9,577,'attendances/1568/1692104155 clock_in.png','attendances/1568/1692138816 clock_out.png','Juan R',37673,NULL,'2023-08-15 09:55:55','2023-08-22 12:52:14'),(1064,'2023-08-15 05:56:18','2023-08-15 18:44:01','12.249.250.150','12.249.250.150','closed',12,767,'attendances/2025/1692104178 clock_in.png','attendances/2025/1692150241 clock_out.png','Juan R',37679,NULL,'2023-08-15 09:56:18','2023-08-22 13:06:31'),(1065,'2023-08-15 05:56:39','2023-08-15 16:38:52','12.249.250.150','12.249.250.150','closed',10,642,'attendances/1999/1692104199 clock_in.png','attendances/1999/1692142732 clock_out.png','Juan R',37685,NULL,'2023-08-15 09:56:39','2023-08-22 12:58:07'),(1066,'2023-08-15 05:57:07','2023-08-15 16:39:44','12.249.250.150','12.249.250.150','closed',10,642,'attendances/1395/1692104227 clock_in.png','attendances/1395/1692142784 clock_out.png','Juan R',37692,NULL,'2023-08-15 09:57:07','2023-08-22 13:02:16'),(1067,'2023-08-15 05:57:47','2023-08-15 18:09:54','12.249.250.150','12.249.250.150','closed',12,732,'attendances/1479/1692104267 clock_in.png','attendances/1479/1692148194 clock_out.png','Juan R',37681,NULL,'2023-08-15 09:57:47','2023-08-22 12:54:34'),(1068,'2023-08-15 05:58:02','2023-08-15 14:30:43','12.249.250.150','12.249.250.150','closed',8,512,'attendances/974/1692104282 clock_in.png','attendances/974/1692135043 clock_out.png','Juan R',37670,NULL,'2023-08-15 09:58:02','2023-08-22 12:49:29'),(1069,'2023-08-15 06:00:11','2023-08-15 17:46:34','12.249.250.150','12.249.250.150','closed',11,706,'attendances/1951/1692104411 clock_in.png','attendances/1951/1692146794 clock_out.png','Juan R',37682,NULL,'2023-08-15 10:00:11','2023-08-22 12:55:13'),(1070,'2023-08-15 06:01:04','2023-08-15 18:41:08','12.249.250.150','12.249.250.150','closed',12,760,'attendances/382/1692104464 clock_in.png','attendances/382/1692150068 clock_out.png','Juan R',37675,NULL,'2023-08-15 10:01:04','2023-08-22 12:55:39'),(1071,'2023-08-15 06:53:44','2023-08-15 15:35:53','12.249.250.150','12.249.250.150','closed',8,522,'attendances/1948/1692107624 clock_in.png','attendances/1948/1692138953 clock_out.png','Juan R',37693,NULL,'2023-08-15 10:53:44','2023-08-22 13:04:36'),(1072,'2023-08-15 06:54:43','2023-08-15 15:31:45','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1455/1692107683 clock_in.png','attendances/1455/1692138705 clock_out.png','Juan R',37688,NULL,'2023-08-15 10:54:43','2023-08-22 12:59:40'),(1073,'2023-08-15 06:54:57','2023-08-15 15:31:25','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1774/1692107697 clock_in.png','attendances/1774/1692138685 clock_out.png','Juan R',37683,NULL,'2023-08-15 10:54:57','2023-08-22 12:56:20'),(1075,'2023-08-15 06:55:09','2023-08-15 15:31:14','12.249.250.150','12.249.250.150','closed',8,516,'attendances/622/1692107709 clock_in.png','attendances/622/1692138674 clock_out.png','Juan R',37694,NULL,'2023-08-15 10:55:09','2023-08-22 13:08:09'),(1076,'2023-08-15 06:55:39','2023-08-15 15:33:06','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1958/1692107739 clock_in.png','attendances/1958/1692138786 clock_out.png','Juan R',37684,NULL,'2023-08-15 10:55:39','2023-08-22 12:57:16'),(1077,'2023-08-15 06:55:41','2023-08-15 18:08:52','12.249.250.150','12.249.250.150','closed',11,673,'attendances/1116/1692107741 clock_in.png','attendances/1116/1692148132 clock_out.png','Juan R',37691,NULL,'2023-08-15 10:55:41','2023-08-22 13:02:00'),(1078,'2023-08-15 06:55:43','2023-08-15 15:32:39','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1858/1692107743 clock_in.png','attendances/1858/1692138759 clock_out.png','Juan R',37690,NULL,'2023-08-15 10:55:43','2023-08-22 13:01:02'),(1079,'2023-08-15 06:56:45','2023-08-15 15:31:57','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1934/1692107805 clock_in.png','attendances/1934/1692138717 clock_out.png','Juan R',37687,NULL,'2023-08-15 10:56:45','2023-08-22 12:59:06'),(1080,'2023-08-15 06:57:56','2023-08-15 16:02:03','12.249.250.150','12.249.250.150','closed',9,544,'attendances/1728/1692107876 clock_in.png','attendances/1728/1692140523 clock_out.png','Juan R',37689,NULL,'2023-08-15 10:57:56','2023-08-22 13:00:30'),(1081,'2023-08-15 07:07:01','2023-08-15 15:37:08','12.249.250.150','12.249.250.150','closed',8,510,'attendances/1888/1692108421 clock_in.png','attendances/1888/1692139028 clock_out.png','Juan R',37695,NULL,'2023-08-15 11:07:01','2023-08-22 13:05:54'),(1082,'2023-08-15 06:55:51','2023-08-15 15:32:57','12.249.250.150','12.249.250.150','closed',8,517,'attendances/726/1692108951 clock_in.png','attendances/726/1692138777 clock_out.png','Juan R',37680,NULL,'2023-08-15 11:15:51','2023-08-22 12:50:12'),(1083,'2023-08-15 07:17:26','2023-08-15 16:23:07','12.249.250.150','12.249.250.150','closed',9,545,'attendances/1462/1692109046 clock_in.png','attendances/1462/1692141787 clock_out.png','Juan R',37686,NULL,'2023-08-15 11:17:26','2023-08-22 12:58:36'),(1084,'2023-08-15 06:00:00','2023-08-15 18:42:30','179.32.217.191','12.249.250.150','closed',12,762,NULL,'attendances/2005/1692150150 clock_out.png','Juan R',37676,NULL,'2023-08-15 11:31:04','2023-08-22 13:01:29'),(1085,'2023-08-15 07:59:13','2023-08-15 16:30:06','12.249.250.150','12.249.250.150','closed',8,510,'attendances/775/1692111553 clock_in.png','attendances/775/1692142206 clock_out.png','Juan R',37697,NULL,'2023-08-15 11:59:13','2023-08-22 13:03:27'),(1086,'2023-08-15 08:02:24','2023-08-15 16:34:26','12.249.250.150','12.249.250.150','closed',8,512,'attendances/1869/1692111744 clock_in.png','attendances/1869/1692142466 clock_out.png','Juan R',37696,NULL,'2023-08-15 12:02:24','2023-08-22 12:53:05'),(1087,'2023-08-15 08:03:29','2023-08-15 16:34:07','12.249.250.150','12.249.250.150','closed',8,510,'attendances/1891/1692111809 clock_in.png','attendances/1891/1692142447 clock_out.png','Juan R',37698,NULL,'2023-08-15 12:03:29','2023-08-22 13:04:05'),(1088,'2023-08-15 08:10:31','2023-08-15 16:30:39','12.249.250.150','12.249.250.150','closed',8,500,'attendances/1492/1692112231 clock_in.png','attendances/1492/1692142239 clock_out.png','Juan R',37699,NULL,'2023-08-15 12:10:31','2023-08-22 13:07:00'),(1089,'2023-08-15 08:31:47','2023-08-15 17:01:07','12.249.250.150','12.249.250.150','closed',8,509,'attendances/1988/1692113507 clock_in.png','attendances/1988/1692144067 clock_out.png','Juan R',37700,NULL,'2023-08-15 12:31:47','2023-08-22 13:07:36'),(1091,'2023-08-16 04:55:07','2023-08-16 19:25:27','12.249.250.150','12.249.250.150','closed',14,870,'attendances/1588/1692186907 clock_in.png','attendances/1588/1692239127 clock_out.png','Juan R',37716,NULL,'2023-08-16 08:55:07','2023-08-22 12:53:37'),(1092,'2023-08-16 05:02:14','2023-08-16 19:21:21','12.249.250.150','12.249.250.150','closed',14,859,'attendances/1450/1692187334 clock_in.png','attendances/1450/1692238881 clock_out.png','Juan R',37717,NULL,'2023-08-16 09:02:14','2023-08-22 13:31:48'),(1093,'2023-08-16 05:04:32','2023-08-16 19:17:52','12.249.250.150','12.249.250.150','closed',14,853,'attendances/1953/1692187472 clock_in.png','attendances/1953/1692238672 clock_out.png','Juan R',37718,NULL,'2023-08-16 09:04:32','2023-08-22 13:32:03'),(1094,'2023-08-16 05:54:02','2023-08-16 19:42:45','12.249.250.150','12.249.250.150','closed',13,828,'attendances/2025/1692190442 clock_in.png','attendances/2025/1692240165 clock_out.png','Juan R',37726,NULL,'2023-08-16 09:54:02','2023-08-22 13:06:26'),(1095,'2023-08-16 05:54:22','2023-08-16 19:41:56','12.249.250.150','12.249.250.150','closed',13,827,'attendances/1551/1692190462 clock_in.png','attendances/1551/1692240116 clock_out.png','Juan R',37720,NULL,'2023-08-16 09:54:22','2023-08-22 12:50:44'),(1096,'2023-08-16 05:54:36','2023-08-16 19:40:53','12.249.250.150','12.249.250.150','closed',13,826,'attendances/2005/1692190476 clock_in.png','attendances/2005/1692240053 clock_out.png','Juan R',37725,NULL,'2023-08-16 09:54:36','2023-08-22 13:01:22'),(1097,'2023-08-16 05:56:24','2023-08-16 19:41:41','12.249.250.150','12.249.250.150','closed',13,825,'attendances/1585/1692190584 clock_in.png','attendances/1585/1692240101 clock_out.png','Juan R',37721,NULL,'2023-08-16 09:56:24','2023-08-22 12:51:44'),(1098,'2023-08-16 05:56:59','2023-08-16 15:31:23','12.249.250.150','12.249.250.150','closed',9,574,'attendances/1568/1692190619 clock_in.png','attendances/1568/1692225083 clock_out.png','Juan R',37722,NULL,'2023-08-16 09:56:59','2023-08-22 12:52:10'),(1099,'2023-08-16 06:02:42','2023-08-16 15:31:39','12.249.250.150','12.249.250.150','closed',9,568,'attendances/974/1692190962 clock_in.png','attendances/974/1692225099 clock_out.png','Juan R',37719,NULL,'2023-08-16 10:02:42','2023-08-22 12:49:22'),(1100,'2023-08-16 06:03:12','2023-08-16 19:43:21','12.249.250.150','12.249.250.150','closed',13,820,'attendances/382/1692190992 clock_in.png','attendances/382/1692240201 clock_out.png','Juan R',37724,NULL,'2023-08-16 10:03:12','2023-08-22 12:55:32'),(1101,'2023-08-16 06:54:20','2023-08-16 15:32:13','12.249.250.150','12.249.250.150','closed',8,517,'attendances/622/1692194060 clock_in.png','attendances/622/1692225133 clock_out.png','Juan R',37738,NULL,'2023-08-16 10:54:20','2023-08-22 13:08:04'),(1102,'2023-08-16 06:55:07','2023-08-16 15:31:53','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1774/1692194107 clock_in.png','attendances/1774/1692225113 clock_out.png','Juan R',37728,NULL,'2023-08-16 10:55:07','2023-08-22 12:56:15'),(1103,'2023-08-16 06:55:13','2023-08-16 16:31:28','12.249.250.150','12.249.250.150','closed',9,576,'attendances/726/1692194113 clock_in.png','attendances/726/1692228688 clock_out.png','Juan R',37740,NULL,'2023-08-16 10:55:13','2023-08-22 12:50:04'),(1104,'2023-08-16 06:55:43','2023-08-16 17:07:55','12.249.250.150','12.249.250.150','closed',10,612,'attendances/1395/1692194143 clock_in.png','attendances/1395/1692230875 clock_out.png','Juan R',37736,NULL,'2023-08-16 10:55:43','2023-08-22 13:02:30'),(1105,'2023-08-16 06:55:57','2023-08-16 17:06:30','12.249.250.150','12.249.250.150','closed',10,610,'attendances/1999/1692194157 clock_in.png','attendances/1999/1692230790 clock_out.png','Juan R',37730,NULL,'2023-08-16 10:55:57','2023-08-22 12:58:01'),(1106,'2023-08-16 06:56:27','2023-08-16 16:35:57','12.249.250.150','12.249.250.150','closed',9,579,'attendances/1479/1692194187 clock_in.png','attendances/1479/1692228957 clock_out.png','Juan R',37723,NULL,'2023-08-16 10:56:27','2023-08-22 12:54:27'),(1107,'2023-08-16 06:56:41','2023-08-16 17:20:16','12.249.250.150','12.249.250.150','closed',10,623,'attendances/1116/1692194201 clock_in.png','attendances/1116/1692231616 clock_out.png','Juan R',37735,NULL,'2023-08-16 10:56:41','2023-08-22 13:01:55'),(1108,'2023-08-16 06:56:54','2023-08-16 16:13:23','12.249.250.150','12.249.250.150','closed',9,556,'attendances/1728/1692194214 clock_in.png','attendances/1728/1692227603 clock_out.png','Juan R',37733,NULL,'2023-08-16 10:56:54','2023-08-22 13:00:19'),(1109,'2023-08-16 06:56:56','2023-08-16 15:32:08','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1934/1692194216 clock_in.png','attendances/1934/1692225128 clock_out.png','Juan R',37732,NULL,'2023-08-16 10:56:56','2023-08-22 12:59:01'),(1110,'2023-08-16 06:57:19','2023-08-16 15:31:25','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1888/1692194239 clock_in.png','attendances/1888/1692225085 clock_out.png','Juan R',37739,NULL,'2023-08-16 10:57:19','2023-08-22 13:05:48'),(1111,'2023-08-16 06:58:01','2023-08-16 15:32:29','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1958/1692194281 clock_in.png','attendances/1958/1692225149 clock_out.png','Juan R',37729,NULL,'2023-08-16 10:58:01','2023-08-22 12:57:07'),(1112,'2023-08-16 06:58:29','2023-08-16 15:29:09','12.249.250.150','12.249.250.150','closed',8,510,'attendances/1951/1692194309 clock_in.png','attendances/1951/1692224949 clock_out.png','Juan R',37727,NULL,'2023-08-16 10:58:29','2023-08-22 12:55:09'),(1113,'2023-08-16 07:01:23','2023-08-16 15:34:35','12.249.250.150','12.249.250.150','closed',8,513,'attendances/1948/1692194483 clock_in.png','attendances/1948/1692225275 clock_out.png','Juan R',37737,NULL,'2023-08-16 11:01:23','2023-08-22 13:04:30'),(1114,'2023-08-16 07:04:18','2023-08-16 16:32:38','12.249.250.150','12.249.250.150','closed',9,568,'attendances/1462/1692194658 clock_in.png','attendances/1462/1692228758 clock_out.png','Juan R',37731,NULL,'2023-08-16 11:04:18','2023-08-22 12:58:31'),(1115,'2023-08-16 07:07:26','2023-08-16 14:29:33','12.249.250.150','12.249.250.150','closed',7,442,'attendances/1858/1692194846 clock_in.png','attendances/1858/1692221373 clock_out.png','Juan R',37734,NULL,'2023-08-16 11:07:26','2023-08-22 13:00:54'),(1116,'2023-08-16 08:00:28','2023-08-16 16:30:05','12.249.250.150','12.249.250.150','closed',8,509,'attendances/775/1692198028 clock_in.png','attendances/775/1692228605 clock_out.png','Juan R',37743,NULL,'2023-08-16 12:00:29','2023-08-22 13:02:53'),(1117,'2023-08-16 08:06:48','2023-08-16 16:34:03','12.249.250.150','12.249.250.150','closed',8,507,'attendances/1455/1692198408 clock_in.png','attendances/1455/1692228843 clock_out.png','Juan R',37742,NULL,'2023-08-16 12:06:48','2023-08-22 12:59:31'),(1118,'2023-08-16 08:13:31','2023-08-16 16:39:43','12.249.250.150','12.249.250.150','closed',8,506,'attendances/1891/1692198811 clock_in.png','attendances/1891/1692229183 clock_out.png','Juan R',37744,NULL,'2023-08-16 12:13:31','2023-08-22 13:04:00'),(1119,'2023-08-16 08:16:23','2023-08-16 16:39:56','12.249.250.150','12.249.250.150','closed',8,503,'attendances/1869/1692198983 clock_in.png','attendances/1869/1692229196 clock_out.png','Juan R',37741,NULL,'2023-08-16 12:16:23','2023-08-22 12:53:01'),(1120,'2023-08-16 08:24:51','2023-08-16 16:30:27','12.249.250.150','12.249.250.150','closed',8,485,'attendances/1492/1692199491 clock_in.png','attendances/1492/1692228627 clock_out.png','Juan R',37745,NULL,'2023-08-16 12:24:51','2023-08-22 13:06:56'),(1121,'2023-08-16 08:33:35','2023-08-16 17:05:36','12.249.250.150','12.249.250.150','closed',8,512,'attendances/1988/1692200015 clock_in.png','attendances/1988/1692230736 clock_out.png','Juan R',37746,NULL,'2023-08-16 12:33:35','2023-08-22 13:07:31'),(1122,'2023-08-17 04:00:40','2023-08-17 19:27:27','12.249.250.150','12.249.250.150','closed',15,926,'attendances/1953/1692270040 clock_in.png','attendances/1953/1692325647 clock_out.png','Juan R',37748,NULL,'2023-08-17 08:00:40','2023-08-22 13:32:03'),(1123,'2023-08-17 04:01:17','2023-08-17 19:31:31','12.249.250.150','12.249.250.150','closed',15,930,'attendances/1450/1692270077 clock_in.png','attendances/1450/1692325891 clock_out.png','Juan R',37747,NULL,'2023-08-17 08:01:17','2023-08-22 13:04:56'),(1124,'2023-08-17 04:23:26','2023-08-17 16:37:29','12.249.250.150','12.249.250.150','closed',12,734,'attendances/1116/1692271406 clock_in.png','attendances/1116/1692315449 clock_out.png','Juan R',37750,NULL,'2023-08-17 08:23:26','2023-08-22 13:01:54'),(1125,'2023-08-17 04:24:43','2023-08-17 13:55:19','12.249.250.150','12.249.250.150','closed',9,570,'attendances/2025/1692271484 clock_in.png','attendances/2025/1692305719 clock_out.png','Juan R',37751,NULL,'2023-08-17 08:24:44','2023-08-22 13:06:21'),(1126,'2023-08-17 04:25:52','2023-08-17 14:00:35','12.249.250.150','12.249.250.150','closed',9,574,'attendances/1588/1692271552 clock_in.png','attendances/1588/1692306035 clock_out.png','Juan R',37749,NULL,'2023-08-17 08:25:52','2023-08-22 12:53:32'),(1127,'2023-08-17 05:57:16','2023-08-17 15:33:10','12.249.250.150','12.249.250.150','closed',9,575,'attendances/1568/1692277036 clock_in.png','attendances/1568/1692311590 clock_out.png','Juan R',37753,NULL,'2023-08-17 09:57:16','2023-08-22 12:52:05'),(1128,'2023-08-17 05:59:21','2023-08-17 15:31:51','12.249.250.150','12.249.250.150','closed',9,572,'attendances/974/1692277161 clock_in.png','attendances/974/1692311511 clock_out.png','Juan R',37752,NULL,'2023-08-17 09:59:21','2023-08-22 12:49:15'),(1129,'2023-08-17 05:59:50','2023-08-17 18:01:06','12.249.250.150','12.249.250.150','closed',12,721,'attendances/2005/1692277190 clock_in.png','attendances/2005/1692320466 clock_out.png','Juan R',37754,NULL,'2023-08-17 09:59:50','2023-08-22 13:01:17'),(1130,'2023-08-17 06:27:46','2023-08-17 16:36:51','12.249.250.150','12.249.250.150','closed',10,609,'attendances/1479/1692278866 clock_in.png','attendances/1479/1692315411 clock_out.png','Juan R',37755,NULL,'2023-08-17 10:27:46','2023-08-22 12:54:15'),(1131,'2023-08-17 06:53:56','2023-08-17 15:31:20','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1774/1692280436 clock_in.png','attendances/1774/1692311480 clock_out.png','Juan R',37757,NULL,'2023-08-17 10:53:56','2023-08-22 12:56:08'),(1132,'2023-08-17 06:54:23','2023-08-17 16:59:58','12.249.250.150','12.249.250.150','closed',10,605,'attendances/1999/1692280463 clock_in.png','attendances/1999/1692316798 clock_out.png','Juan R',37759,NULL,'2023-08-17 10:54:23','2023-08-22 12:57:50'),(1133,'2023-08-17 06:54:59','2023-08-17 15:30:05','12.249.250.150','12.249.250.150','closed',8,515,'attendances/622/1692280499 clock_in.png','attendances/622/1692311405 clock_out.png','Juan R',37766,NULL,'2023-08-17 10:54:59','2023-08-22 13:07:57'),(1134,'2023-08-17 06:55:20','2023-08-17 15:31:39','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1934/1692280520 clock_in.png','attendances/1934/1692311499 clock_out.png','Juan R',37761,NULL,'2023-08-17 10:55:20','2023-08-22 12:58:56'),(1135,'2023-08-17 06:55:36','2023-08-17 17:52:40','12.249.250.150','12.249.250.150','closed',10,657,'attendances/1728/1692280536 clock_in.png','attendances/1728/1692319960 clock_out.png','Juan R',37762,NULL,'2023-08-17 10:55:36','2023-08-22 13:00:14'),(1136,'2023-08-17 06:56:33','2023-08-17 15:32:53','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1958/1692280593 clock_in.png','attendances/1958/1692311573 clock_out.png','Juan R',37758,NULL,'2023-08-17 10:56:33','2023-08-22 12:57:05'),(1137,'2023-08-17 06:59:22','2023-08-17 16:32:35','12.249.250.150','12.249.250.150','closed',9,573,'attendances/1462/1692280762 clock_in.png','attendances/1462/1692315155 clock_out.png','Juan R',37760,NULL,'2023-08-17 10:59:22','2023-08-22 12:58:27'),(1138,'2023-08-17 06:59:55','2023-08-17 15:38:56','12.249.250.150','12.249.250.150','closed',8,519,'attendances/1951/1692280795 clock_in.png','attendances/1951/1692311936 clock_out.png','Juan R',37756,NULL,'2023-08-17 10:59:55','2023-08-22 12:55:04'),(1139,'2023-08-17 07:00:15','2023-08-17 15:33:32','12.249.250.150','12.249.250.150','closed',8,513,'attendances/1948/1692280815 clock_in.png','attendances/1948/1692311612 clock_out.png','Juan R',37765,NULL,'2023-08-17 11:00:15','2023-08-22 13:04:26'),(1140,'2023-08-17 07:03:10','2023-08-17 15:34:49','12.249.250.150','12.249.250.150','closed',8,511,'attendances/1888/1692280990 clock_in.png','attendances/1888/1692311689 clock_out.png','Juan R',37767,NULL,'2023-08-17 11:03:10','2023-08-22 13:05:41'),(1141,'2023-08-17 07:07:57','2023-08-17 15:32:30','12.249.250.150','12.249.250.150','closed',8,504,'attendances/1858/1692281277 clock_in.png','attendances/1858/1692311550 clock_out.png','Juan R',37763,NULL,'2023-08-17 11:07:57','2023-08-22 13:00:52'),(1142,'2023-08-17 08:01:17','2023-08-17 16:34:09','12.249.250.150','12.249.250.150','closed',8,512,'attendances/1869/1692284477 clock_in.png','attendances/1869/1692315249 clock_out.png','Juan R',37768,NULL,'2023-08-17 12:01:17','2023-08-22 12:52:56'),(1143,'2023-08-17 08:01:25','2023-08-17 16:34:22','12.249.250.150','12.249.250.150','closed',8,512,'attendances/1891/1692284485 clock_in.png','attendances/1891/1692315262 clock_out.png','Juan R',37769,NULL,'2023-08-17 12:01:25','2023-08-22 13:03:49'),(1144,'2023-08-17 08:15:50','2023-08-17 16:31:04','12.249.250.150','12.249.250.150','closed',8,495,'attendances/1492/1692285350 clock_in.png','attendances/1492/1692315064 clock_out.png','Juan R',37770,NULL,'2023-08-17 12:15:50','2023-08-22 13:06:52'),(1145,'2023-08-17 08:30:25','2023-08-17 15:05:43','12.249.250.150','12.249.250.150','closed',6,395,'attendances/1988/1692286225 clock_in.png','attendances/1988/1692309943 clock_out.png','Juan R',37771,NULL,'2023-08-17 12:30:25','2023-08-22 13:07:26'),(1146,'2023-08-17 11:54:43','2023-08-17 20:53:18','12.249.250.150','12.249.250.150','closed',8,538,'attendances/726/1692298483 clock_in.png','attendances/726/1692330798 clock_out.png','Juan R',37772,NULL,'2023-08-17 15:54:43','2023-08-22 12:49:55'),(1147,'2023-08-17 11:58:30','2023-08-17 20:51:15','12.249.250.150','12.249.250.150','closed',8,532,'attendances/1455/1692298710 clock_in.png','attendances/1455/1692330675 clock_out.png','Juan R',37773,NULL,'2023-08-17 15:58:30','2023-08-22 12:59:26'),(1150,'2023-08-18 05:58:46','2023-08-18 15:30:00','12.249.250.150','','closed',9,571,'attendances/974/1692363526 clock_in.png',NULL,'Juan R',37809,NULL,'2023-08-18 09:58:46','2023-08-22 12:49:02'),(1151,'2023-08-18 06:01:19','2023-08-18 16:04:29','12.249.250.150','12.249.250.150','closed',10,603,'attendances/1728/1692363679 clock_in.png','attendances/1728/1692399869 clock_out.png','Juan R',37821,NULL,'2023-08-18 10:01:19','2023-08-22 13:00:09'),(1152,'2023-08-18 06:02:04','2023-08-18 14:54:46','12.249.250.150','12.249.250.150','closed',8,532,'attendances/1951/1692363724 clock_in.png','attendances/1951/1692395686 clock_out.png','Juan R',37810,NULL,'2023-08-18 10:02:04','2023-08-22 12:54:59'),(1153,'2023-08-18 06:05:34','2023-08-18 16:02:30','12.249.250.150','12.249.250.150','closed',9,596,'attendances/1999/1692363934 clock_in.png','attendances/1999/1692399750 clock_out.png','Juan R',37817,NULL,'2023-08-18 10:05:34','2023-08-22 12:57:38'),(1154,'2023-08-18 06:10:02','2023-08-18 15:47:34','12.249.250.150','12.249.250.150','closed',9,577,'attendances/1395/1692364202 clock_in.png','attendances/1395/1692398854 clock_out.png','Juan R',37824,NULL,'2023-08-18 10:10:02','2023-08-22 13:02:22'),(1155,'2023-08-18 06:54:15','2023-08-18 17:41:25','12.249.250.150','12.249.250.150','closed',10,647,'attendances/1116/1692366855 clock_in.png','attendances/1116/1692405685 clock_out.png','Juan R',37823,NULL,'2023-08-18 10:54:15','2023-08-22 13:01:46'),(1156,'2023-08-18 06:55:21','2023-08-18 14:44:50','12.249.250.150','12.249.250.150','closed',7,469,'attendances/726/1692366921 clock_in.png','attendances/726/1692395090 clock_out.png','Juan R',37811,NULL,'2023-08-18 10:55:21','2023-08-22 12:49:55'),(1157,'2023-08-18 06:55:39','2023-08-18 15:39:24','12.249.250.150','12.249.250.150','closed',8,523,'attendances/1948/1692366939 clock_in.png','attendances/1948/1692398365 clock_out.png','Juan R',37825,NULL,'2023-08-18 10:55:39','2023-08-22 13:04:22'),(1158,'2023-08-18 06:55:57','2023-08-18 15:31:04','12.249.250.150','12.249.250.150','closed',8,515,'attendances/622/1692366957 clock_in.png','attendances/622/1692397864 clock_out.png','Juan R',37826,NULL,'2023-08-18 10:55:57','2023-08-22 13:07:50'),(1159,'2023-08-18 06:56:17','2023-08-18 15:31:19','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1774/1692366977 clock_in.png','attendances/1774/1692397879 clock_out.png','Juan R',37815,NULL,'2023-08-18 10:56:17','2023-08-22 12:56:01'),(1160,'2023-08-18 06:56:57','2023-08-18 15:36:54','12.249.250.150','12.249.250.150','closed',8,519,'attendances/1958/1692367017 clock_in.png','attendances/1958/1692398214 clock_out.png','Juan R',37816,NULL,'2023-08-18 10:56:57','2023-08-22 12:56:55'),(1161,'2023-08-18 06:57:18','2023-08-18 15:32:15','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1934/1692367038 clock_in.png','attendances/1934/1692397935 clock_out.png','Juan R',37819,NULL,'2023-08-18 10:57:18','2023-08-22 12:58:50'),(1162,'2023-08-18 06:57:53','2023-08-18 15:34:14','12.249.250.150','12.249.250.150','closed',8,516,'attendances/775/1692367073 clock_in.png','attendances/775/1692398054 clock_out.png','Juan R',37829,NULL,'2023-08-18 10:57:53','2023-08-22 13:02:53'),(1163,'2023-08-18 06:59:54','2023-08-18 16:18:01','12.249.250.150','12.249.250.150','closed',9,558,'attendances/1455/1692367194 clock_in.png','attendances/1455/1692400681 clock_out.png','Juan R',37820,NULL,'2023-08-18 10:59:54','2023-08-22 12:59:20'),(1164,'2023-08-18 07:00:30','2023-08-18 16:05:13','12.249.250.150','12.249.250.150','closed',9,544,'attendances/1462/1692367230 clock_in.png','attendances/1462/1692367333 clock_out.png','Juan R',37818,NULL,'2023-08-18 11:00:30','2023-08-22 12:58:22'),(1165,'2023-08-18 07:02:01','2023-08-18 15:34:06','12.249.250.150','12.249.250.150','closed',8,512,'attendances/1888/1692367321 clock_in.png','attendances/1888/1692398046 clock_out.png','Juan R',37827,NULL,'2023-08-18 11:02:01','2023-08-22 13:05:40'),(1166,'2023-08-18 07:02:39','2023-08-18 18:37:26','12.249.250.150','12.249.250.150','closed',11,694,'attendances/382/1692367359 clock_in.png','attendances/382/1692409046 clock_out.png','Juan R',37814,NULL,'2023-08-18 11:02:39','2023-08-22 12:55:28'),(1167,'2023-08-18 07:06:11','2023-08-18 15:29:35','12.249.250.150','12.249.250.150','closed',8,503,'attendances/1585/1692367571 clock_in.png','attendances/1585/1692397775 clock_out.png','Juan R',37813,NULL,'2023-08-18 11:06:11','2023-08-22 12:51:39'),(1168,'2023-08-18 07:08:54','2023-08-18 15:37:42','12.249.250.150','12.249.250.150','closed',8,508,'attendances/1858/1692367734 clock_in.png','attendances/1858/1692398262 clock_out.png','Juan R',37822,NULL,'2023-08-18 11:08:54','2023-08-22 13:00:45'),(1169,'2023-08-18 07:24:06','2023-08-18 15:29:15','12.249.250.150','12.249.250.150','closed',8,485,'attendances/1551/1692368646 clock_in.png','attendances/1551/1692397755 clock_out.png','Juan R',37812,NULL,'2023-08-18 11:24:06','2023-08-22 12:50:38'),(1170,'2023-08-18 08:01:28','2023-08-18 16:34:45','12.249.250.150','12.249.250.150','closed',8,513,'attendances/1869/1692370888 clock_in.png','attendances/1869/1692401685 clock_out.png','Juan R',37828,NULL,'2023-08-18 12:01:28','2023-08-22 12:52:52'),(1171,'2023-08-18 08:02:28','2023-08-18 16:35:00','12.249.250.150','12.249.250.150','closed',8,512,'attendances/1891/1692370948 clock_in.png','attendances/1891/1692401700 clock_out.png','Juan R',37830,NULL,'2023-08-18 12:02:28','2023-08-22 13:03:44'),(1172,'2023-08-18 08:07:22','2023-08-18 16:31:20','12.249.250.150','12.249.250.150','closed',8,503,'attendances/1492/1692371242 clock_in.png','attendances/1492/1692401480 clock_out.png','Juan R',37831,NULL,'2023-08-18 12:07:22','2023-08-22 13:06:50'),(1173,'2023-08-18 08:31:07','2023-08-18 17:05:46','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1988/1692372667 clock_in.png','attendances/1988/1692403546 clock_out.png','Juan R',37832,NULL,'2023-08-18 12:31:07','2023-08-22 13:07:21'),(1175,'2023-08-18 12:00:13','2023-08-18 19:50:43','12.249.250.150','12.249.250.150','closed',7,470,'attendances/1479/1692385213 clock_in.png','attendances/1479/1692413443 clock_out.png','Juan R',37833,NULL,'2023-08-18 16:00:13','2023-08-22 12:54:09'),(1177,'2023-08-21 02:58:32','2023-08-21 14:09:50','12.249.250.150','12.249.250.150','closed',11,671,'attendances/2005/1692611912 clock_in.png','attendances/2005/1692652190 clock_out.png','Juan R',37847,NULL,'2023-08-21 06:58:32','2023-08-29 06:10:14'),(1178,'2023-08-21 02:58:54','2023-08-21 14:19:38','12.249.250.150','12.249.250.150','closed',11,680,'attendances/382/1692611934 clock_in.png','attendances/382/1692652778 clock_out.png','Juan R',37846,NULL,'2023-08-21 06:58:54','2023-08-29 06:04:05'),(1179,'2023-08-21 02:59:12','2023-08-21 14:13:05','12.249.250.150','12.249.250.150','closed',11,673,'attendances/1551/1692611952 clock_in.png','attendances/1551/1692652385 clock_out.png','Juan R',37844,NULL,'2023-08-21 06:59:12','2023-08-29 05:59:55'),(1180,'2023-08-21 03:00:03','2023-08-21 14:12:44','12.249.250.150','12.249.250.150','closed',11,672,'attendances/1585/1692612003 clock_in.png','attendances/1585/1692652364 clock_out.png','Juan R',37845,NULL,'2023-08-21 07:00:04','2023-08-29 06:00:20'),(1181,'2023-08-21 03:03:37','2023-08-21 14:13:47','12.249.250.150','12.249.250.150','closed',11,670,'attendances/1450/1692612217 clock_in.png','attendances/1450/1692652427 clock_out.png','Juan R',37848,NULL,'2023-08-21 07:03:37','2023-08-29 06:13:48'),(1182,'2023-08-21 05:59:39','2023-08-21 15:30:51','12.249.250.150','12.249.250.150','closed',9,571,'attendances/1568/1692622779 clock_in.png','attendances/1568/1692657051 clock_out.png','Juan R',37851,NULL,'2023-08-21 09:59:39','2023-08-29 06:00:48'),(1183,'2023-08-21 06:50:24','2023-08-21 16:28:22','12.249.250.150','12.249.250.150','closed',9,577,'attendances/1999/1692625824 clock_in.png','attendances/1999/1692660502 clock_out.png','Juan R',37857,NULL,'2023-08-21 10:50:24','2023-08-29 06:07:19'),(1184,'2023-08-21 06:52:10','2023-08-21 15:31:39','12.249.250.150','12.249.250.150','closed',8,519,'attendances/1774/1692625930 clock_in.png','attendances/1774/1692657099 clock_out.png','Juan R',37855,NULL,'2023-08-21 10:52:10','2023-08-29 06:04:49'),(1185,'2023-08-21 06:52:27','2023-08-21 16:42:25','12.249.250.150','12.249.250.150','closed',9,589,'attendances/1395/1692625947 clock_in.png','attendances/1395/1692661345 clock_out.png','Juan R',37863,NULL,'2023-08-21 10:52:27','2023-08-29 06:11:28'),(1186,'2023-08-21 06:53:07','2023-08-21 16:43:01','12.249.250.150','12.249.250.150','closed',9,589,'attendances/726/1692625987 clock_in.png','attendances/726/1692661381 clock_out.png','Juan R',37852,NULL,'2023-08-21 10:53:07','2023-08-29 05:59:27'),(1187,'2023-08-21 06:54:05','2023-08-21 15:57:19','12.249.250.150','12.249.250.150','closed',9,543,'attendances/1116/1692626045 clock_in.png','attendances/1116/1692658639 clock_out.png','Juan R',37862,NULL,'2023-08-21 10:54:05','2023-08-29 06:10:36'),(1188,'2023-08-21 06:54:35','2023-08-21 18:03:48','12.249.250.150','12.249.250.150','closed',11,669,'attendances/1479/1692626075 clock_in.png','attendances/1479/1692666228 clock_out.png','Juan R',37853,NULL,'2023-08-21 10:54:35','2023-08-29 06:03:07'),(1189,'2023-08-21 06:54:37','2023-08-21 15:31:26','12.249.250.150','12.249.250.150','closed',8,516,'attendances/622/1692626077 clock_in.png','attendances/622/1692657086 clock_out.png','Juan R',37865,NULL,'2023-08-21 10:54:37','2023-08-29 06:15:02'),(1190,'2023-08-21 06:54:53','2023-08-21 15:30:31','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1934/1692626093 clock_in.png','attendances/1934/1692657031 clock_out.png','Juan R',37859,NULL,'2023-08-21 10:54:53','2023-08-29 06:08:16'),(1191,'2023-08-21 06:56:23','2023-08-21 15:33:40','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1948/1692626183 clock_in.png','attendances/1948/1692657220 clock_out.png','Juan R',37864,NULL,'2023-08-21 10:56:23','2023-08-29 06:13:14'),(1192,'2023-08-21 06:56:51','2023-08-21 16:38:57','12.249.250.150','12.249.250.150','closed',9,582,'attendances/1728/1692626211 clock_in.png','attendances/1728/1692661137 clock_out.png','Juan R',37860,NULL,'2023-08-21 10:56:51','2023-08-29 06:09:20'),(1193,'2023-08-21 06:59:02','2023-08-21 15:35:24','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1951/1692626342 clock_in.png','attendances/1951/1692657324 clock_out.png','Juan R',37854,NULL,'2023-08-21 10:59:02','2023-08-29 06:03:40'),(1194,'2023-08-21 07:00:21','2023-08-21 15:30:50','12.249.250.150','12.249.250.150','closed',8,510,'attendances/1888/1692626421 clock_in.png','attendances/1888/1692657050 clock_out.png','Juan R',37866,NULL,'2023-08-21 11:00:21','2023-08-29 06:17:08'),(1195,'2023-08-21 07:07:36','2023-08-21 15:33:13','12.249.250.150','12.249.250.150','closed',8,505,'attendances/1958/1692626856 clock_in.png','attendances/1958/1692657193 clock_out.png','Juan R',37856,NULL,'2023-08-21 11:07:36','2023-08-29 06:05:29'),(1196,'2023-08-21 07:11:27','2023-08-21 14:16:08','12.249.250.150','12.249.250.150','closed',7,424,'attendances/1858/1692627087 clock_in.png','attendances/1858/1692652568 clock_out.png','Juan R',37861,NULL,'2023-08-21 11:11:27','2023-08-29 06:09:46'),(1197,'2023-08-21 07:58:29','2023-08-21 16:30:12','12.249.250.150','12.249.250.150','closed',8,511,'attendances/775/1692629909 clock_in.png','attendances/775/1692660612 clock_out.png','Juan R',37868,NULL,'2023-08-21 11:58:29','2023-08-29 06:12:15'),(1198,'2023-08-21 08:02:52','2023-08-21 16:34:29','12.249.250.150','12.249.250.150','closed',8,511,'attendances/1891/1692630172 clock_in.png','attendances/1891/1692660869 clock_out.png','Juan R',37869,NULL,'2023-08-21 12:02:52','2023-08-29 06:12:39'),(1199,'2023-08-21 08:07:05','2023-08-21 15:36:03','12.249.250.150','12.249.250.150','closed',7,448,'attendances/1462/1692630425 clock_in.png','attendances/1462/1692657363 clock_out.png','Juan R',37895,NULL,'2023-08-21 12:07:05','2023-08-29 06:07:49'),(1200,'2023-08-21 08:09:37','2023-08-21 16:30:47','12.249.250.150','12.249.250.150','closed',8,501,'attendances/1492/1692630577 clock_in.png','attendances/1492/1692660647 clock_out.png','Juan R',37870,NULL,'2023-08-21 12:09:37','2023-08-29 06:15:47'),(1201,'2023-08-21 08:15:01','2023-08-21 16:34:18','12.249.250.150','12.249.250.150','closed',8,499,'attendances/1869/1692630901 clock_in.png','attendances/1869/1692660858 clock_out.png','Juan R',37867,NULL,'2023-08-21 12:15:01','2023-08-29 06:01:13'),(1202,'2023-08-21 08:32:41','2023-08-21 17:00:00','12.249.250.150','','closed',8,507,'attendances/1988/1692631961 clock_in.png',NULL,'Juan R',37871,NULL,'2023-08-21 12:32:41','2023-08-29 06:15:07'),(1204,'2023-08-21 14:53:36','2023-08-21 22:12:21','12.249.250.150','12.249.250.150','closed',7,438,'attendances/1953/1692654816 clock_in.png','attendances/1953/1692681141 clock_out.png','Juan R',37873,NULL,'2023-08-21 18:53:36','2023-08-29 06:14:23'),(1205,'2023-08-21 14:54:55','2023-08-21 22:10:13','12.249.250.150','12.249.250.150','closed',7,435,'attendances/1588/1692654895 clock_in.png','attendances/1588/1692681013 clock_out.png','Juan R',37872,NULL,'2023-08-21 18:54:55','2023-08-29 06:01:53'),(1206,'2023-08-22 06:52:58','2023-08-22 16:24:37','12.249.250.150','12.249.250.150','closed',9,571,'attendances/1395/1692712378 clock_in.png','attendances/1395/1692746677 clock_out.png','Juan R',37908,NULL,'2023-08-22 10:52:58','2023-08-29 06:11:16'),(1207,'2023-08-22 06:53:57','2023-08-22 16:23:45','12.249.250.150','12.249.250.150','closed',9,569,'attendances/1999/1692712437 clock_in.png','attendances/1999/1692746625 clock_out.png','Juan R',37902,NULL,'2023-08-22 10:53:57','2023-08-29 06:07:14'),(1208,'2023-08-22 06:54:14','2023-08-22 16:25:43','12.249.250.150','12.249.250.150','closed',9,571,'attendances/1728/1692712454 clock_in.png','attendances/1728/1692746743 clock_out.png','Juan R',37906,NULL,'2023-08-22 10:54:14','2023-08-29 06:09:11'),(1209,'2023-08-22 06:55:01','2023-08-22 15:31:45','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1588/1692712501 clock_in.png','attendances/1588/1692743505 clock_out.png','Juan R',37898,NULL,'2023-08-22 10:55:01','2023-08-29 06:01:35'),(1210,'2023-08-22 06:55:15','2023-08-22 15:30:21','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1568/1692712515 clock_in.png','attendances/1568/1692743421 clock_out.png','Juan R',37897,NULL,'2023-08-22 10:55:15','2023-08-29 06:00:41'),(1211,'2023-08-22 06:55:30','2023-08-22 15:30:32','12.249.250.150','12.249.250.150','closed',8,515,'attendances/622/1692712530 clock_in.png','attendances/622/1692743432 clock_out.png','Juan R',37910,NULL,'2023-08-22 10:55:30','2023-08-29 06:14:51'),(1212,'2023-08-22 06:55:41','2023-08-22 15:30:44','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1774/1692712541 clock_in.png','attendances/1774/1692743444 clock_out.png','Juan R',37900,NULL,'2023-08-22 10:55:41','2023-08-29 06:04:39'),(1213,'2023-08-22 06:55:45','2023-08-22 15:32:23','12.249.250.150','12.249.250.150','closed',8,516,'attendances/726/1692712545 clock_in.png','attendances/726/1692729083 clock_out.png','Juan R',37896,NULL,'2023-08-22 10:55:45','2023-08-29 05:59:21'),(1214,'2023-08-22 06:55:53','2023-08-22 15:30:20','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1934/1692712553 clock_in.png','attendances/1934/1692743420 clock_out.png','Juan R',37904,NULL,'2023-08-22 10:55:53','2023-08-29 06:08:09'),(1215,'2023-08-22 06:57:10','2023-08-22 15:38:22','12.249.250.150','12.249.250.150','closed',8,521,'attendances/1951/1692712630 clock_in.png','attendances/1951/1692743902 clock_out.png','Juan R',37899,NULL,'2023-08-22 10:57:10','2023-08-29 06:03:31'),(1216,'2023-08-22 06:59:10','2023-08-22 16:31:32','12.249.250.150','12.249.250.150','closed',9,572,'attendances/1462/1692712750 clock_in.png','attendances/1462/1692747092 clock_out.png','Juan R',37903,NULL,'2023-08-22 10:59:10','2023-08-29 06:07:41'),(1217,'2023-08-22 06:59:48','2023-08-22 15:29:51','12.249.250.150','12.249.250.150','closed',8,510,'attendances/1958/1692712788 clock_in.png','attendances/1958/1692743391 clock_out.png','Juan R',37901,NULL,'2023-08-22 10:59:48','2023-08-29 06:05:17'),(1218,'2023-08-22 07:00:22','2023-08-22 15:29:37','12.249.250.150','12.249.250.150','closed',8,509,'attendances/1455/1692712822 clock_in.png','attendances/1455/1692743377 clock_out.png','Juan R',37905,NULL,'2023-08-22 11:00:22','2023-08-29 06:08:48'),(1219,'2023-08-22 07:01:52','2023-08-22 15:38:28','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1948/1692712912 clock_in.png','attendances/1948/1692743908 clock_out.png','Juan R',37909,NULL,'2023-08-22 11:01:52','2023-08-29 06:13:07'),(1220,'2023-08-22 07:02:12','2023-08-22 15:35:03','12.249.250.150','12.249.250.150','closed',8,512,'attendances/1888/1692712932 clock_in.png','attendances/1888/1692743703 clock_out.png','Juan R',37911,NULL,'2023-08-22 11:02:12','2023-08-29 06:17:03'),(1221,'2023-08-22 07:04:09','2023-08-22 15:33:08','12.249.250.150','12.249.250.150','closed',8,508,'attendances/1858/1692713049 clock_in.png','attendances/1858/1692743588 clock_out.png','Juan R',37907,NULL,'2023-08-22 11:04:09','2023-08-29 06:09:37'),(1222,'2023-08-22 07:59:52','2023-08-22 16:30:11','12.249.250.150','12.249.250.150','closed',8,510,'attendances/775/1692716392 clock_in.png','attendances/775/1692747011 clock_out.png','Juan R',37913,NULL,'2023-08-22 11:59:52','2023-08-29 06:11:50'),(1223,'2023-08-22 08:00:41','2023-08-22 16:34:00','12.249.250.150','','closed',8,513,'attendances/1869/1692716441 clock_in.png',NULL,'Juan R',37912,NULL,'2023-08-22 12:00:52','2023-08-29 06:01:08'),(1225,'2023-08-22 08:01:05','2023-08-22 16:35:00','12.249.250.150','','closed',8,513,'attendances/1891/1692716465 clock_in.png',NULL,'Juan R',37914,NULL,'2023-08-22 12:01:05','2023-08-29 06:12:34'),(1226,'2023-08-22 08:18:02','2023-08-22 16:30:08','12.249.250.150','12.249.250.150','closed',8,492,'attendances/1492/1692717482 clock_in.png','attendances/1492/1692747008 clock_out.png','Juan R',37915,NULL,'2023-08-22 12:18:02','2023-08-29 06:15:40'),(1228,'2023-08-23 05:58:17','2023-08-23 14:33:50','12.249.250.150','12.249.250.150','closed',8,515,'attendances/2005/1692795497 clock_in.png','attendances/2005/1692826430 clock_out.png','Juan R',37949,NULL,'2023-08-23 09:58:17','2023-08-29 06:10:07'),(1229,'2023-08-23 05:58:38','2023-08-23 14:37:16','12.249.250.150','12.249.250.150','closed',8,518,'attendances/1551/1692795518 clock_in.png','attendances/1551/1692826636 clock_out.png','Juan R',37946,NULL,'2023-08-23 09:58:38','2023-08-29 05:59:49'),(1230,'2023-08-23 05:59:37','2023-08-23 14:44:18','12.249.250.150','12.249.250.150','closed',8,524,'attendances/1951/1692795577 clock_in.png','attendances/1951/1692827058 clock_out.png','Juan R',37948,NULL,'2023-08-23 09:59:37','2023-08-29 06:03:26'),(1231,'2023-08-23 06:01:32','2023-08-23 14:41:08','12.249.250.150','12.249.250.150','closed',8,519,'attendances/382/1692795692 clock_in.png','attendances/382/1692826868 clock_out.png','Juan R',37947,NULL,'2023-08-23 10:01:32','2023-08-29 06:04:00'),(1232,'2023-08-23 06:50:54','2023-08-23 15:27:12','12.249.250.150','12.249.250.150','closed',8,516,'attendances/726/1692798654 clock_in.png','attendances/726/1692815442 clock_out.png','Juan R',37951,NULL,'2023-08-23 10:50:54','2023-08-29 05:59:14'),(1233,'2023-08-23 06:51:13','2023-08-23 16:28:08','12.249.250.150','12.249.250.150','closed',9,576,'attendances/1999/1692798673 clock_in.png','attendances/1999/1692833288 clock_out.png','Juan R',37956,NULL,'2023-08-23 10:51:13','2023-08-29 06:07:03'),(1234,'2023-08-23 06:51:30','2023-08-23 16:29:41','12.249.250.150','12.249.250.150','closed',9,578,'attendances/1395/1692798690 clock_in.png','attendances/1395/1692833381 clock_out.png','Juan R',37963,NULL,'2023-08-23 10:51:30','2023-08-29 06:11:11'),(1235,'2023-08-23 06:51:49','2023-08-23 15:30:18','12.249.250.150','12.249.250.150','closed',8,518,'attendances/974/1692798709 clock_in.png','attendances/974/1692829818 clock_out.png','Juan R',37950,NULL,'2023-08-23 10:51:49','2023-08-29 05:58:49'),(1236,'2023-08-23 06:53:14','2023-08-23 15:34:01','12.249.250.150','12.249.250.150','closed',8,520,'attendances/1948/1692798794 clock_in.png','attendances/1948/1692830041 clock_out.png','Juan R',37964,NULL,'2023-08-23 10:53:14','2023-08-29 06:12:59'),(1237,'2023-08-23 06:55:19','2023-08-23 16:39:45','12.249.250.150','12.249.250.150','closed',9,584,'attendances/1116/1692798919 clock_in.png','attendances/1116/1692833985 clock_out.png','Juan R',37962,NULL,'2023-08-23 10:55:19','2023-08-29 06:10:30'),(1238,'2023-08-23 06:55:32','2023-08-23 15:59:44','12.249.250.150','12.249.250.150','closed',9,544,'attendances/2025/1692798932 clock_in.png','attendances/2025/1692831584 clock_out.png','Juan R',37966,NULL,'2023-08-23 10:55:32','2023-08-29 06:16:40'),(1239,'2023-08-23 06:55:49','2023-08-23 15:31:35','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1774/1692798949 clock_in.png','attendances/1774/1692829895 clock_out.png','Juan R',37954,NULL,'2023-08-23 10:55:49','2023-08-29 06:04:35'),(1240,'2023-08-23 06:56:02','2023-08-23 15:29:23','12.249.250.150','12.249.250.150','closed',8,513,'attendances/1934/1692798962 clock_in.png','attendances/1934/1692829763 clock_out.png','Juan R',37958,NULL,'2023-08-23 10:56:02','2023-08-29 06:08:05'),(1241,'2023-08-23 06:56:10','2023-08-23 15:33:31','12.249.250.150','12.249.250.150','closed',8,517,'attendances/622/1692798970 clock_in.png','attendances/622/1692830011 clock_out.png','Juan R',37965,NULL,'2023-08-23 10:56:10','2023-08-29 06:14:44'),(1242,'2023-08-23 06:57:23','2023-08-23 15:29:08','12.249.250.150','12.249.250.150','closed',8,511,'attendances/1585/1692799043 clock_in.png','attendances/1585/1692829748 clock_out.png','Juan R',37952,NULL,'2023-08-23 10:57:23','2023-08-29 06:00:14'),(1243,'2023-08-23 06:57:47','2023-08-23 16:39:11','12.249.250.150','12.249.250.150','closed',9,581,'attendances/1728/1692799067 clock_in.png','attendances/1728/1692833952 clock_out.png','Juan R',37960,NULL,'2023-08-23 10:57:47','2023-08-29 06:09:06'),(1244,'2023-08-23 06:59:27','2023-08-23 15:32:13','12.249.250.150','12.249.250.150','closed',8,512,'attendances/1958/1692799167 clock_in.png','attendances/1958/1692829933 clock_out.png','Juan R',37955,NULL,'2023-08-23 10:59:27','2023-08-29 06:05:13'),(1245,'2023-08-23 06:59:31','2023-08-23 16:07:52','12.249.250.150','12.249.250.150','closed',9,548,'attendances/1462/1692799171 clock_in.png','attendances/1462/1692832072 clock_out.png','Juan R',37957,NULL,'2023-08-23 10:59:31','2023-08-29 06:07:37'),(1246,'2023-08-23 07:00:17','2023-08-23 15:33:19','12.249.250.150','12.249.250.150','closed',8,513,'attendances/1888/1692799217 clock_in.png','attendances/1888/1692829999 clock_out.png','Juan R',37967,NULL,'2023-08-23 11:00:17','2023-08-29 06:16:56'),(1247,'2023-08-23 07:01:40','2023-08-23 15:32:53','12.249.250.150','12.249.250.150','closed',8,511,'attendances/1858/1692799300 clock_in.png','attendances/1858/1692829973 clock_out.png','Juan R',37961,NULL,'2023-08-23 11:01:40','2023-08-29 06:09:33'),(1248,'2023-08-23 07:04:06','2023-08-23 15:30:12','12.249.250.150','12.249.250.150','closed',8,506,'attendances/1455/1692799447 clock_in.png','attendances/1455/1692829812 clock_out.png','Juan R',37959,NULL,'2023-08-23 11:04:07','2023-08-29 06:08:40'),(1249,'2023-08-23 07:58:41','2023-08-23 16:32:24','12.249.250.150','12.249.250.150','closed',8,513,'attendances/1869/1692802721 clock_in.png','attendances/1869/1692833545 clock_out.png','Juan R',37968,NULL,'2023-08-23 11:58:41','2023-08-29 06:01:04'),(1250,'2023-08-23 07:58:52','2023-08-23 16:32:39','12.249.250.150','12.249.250.150','closed',8,513,'attendances/1891/1692802732 clock_in.png','attendances/1891/1692833559 clock_out.png','Juan R',37970,NULL,'2023-08-23 11:58:52','2023-08-29 06:12:29'),(1251,'2023-08-23 08:00:05','2023-08-23 16:29:39','12.249.250.150','12.249.250.150','closed',8,509,'attendances/775/1692802805 clock_in.png','attendances/775/1692833379 clock_out.png','Juan R',37969,NULL,'2023-08-23 12:00:05','2023-08-29 06:11:45'),(1252,'2023-08-23 08:26:23','2023-08-23 16:30:47','12.249.250.150','12.249.250.150','closed',8,484,'attendances/1492/1692804383 clock_in.png','attendances/1492/1692833447 clock_out.png','Juan R',37971,NULL,'2023-08-23 12:26:23','2023-08-29 06:15:34'),(1253,'2023-08-23 08:36:30','2023-08-23 17:01:58','12.249.250.150','12.249.250.150','closed',8,505,'attendances/1479/1692804990 clock_in.png','attendances/1479/1692835318 clock_out.png','Juan R',37972,NULL,'2023-08-23 12:36:30','2023-08-29 06:02:54'),(1254,'2023-08-23 10:01:33','2023-08-23 15:43:49','12.249.250.150','12.249.250.150','closed',5,342,'attendances/1450/1692810093 clock_in.png','attendances/1450/1692830629 clock_out.png','Juan R',37973,NULL,'2023-08-23 14:01:33','2023-08-29 06:13:34'),(1255,'2023-08-23 10:44:03','2023-08-23 15:44:15','12.249.250.150','12.249.250.150','closed',5,300,'attendances/1953/1692812643 clock_in.png','attendances/1953/1692830655 clock_out.png','Juan R',37974,NULL,'2023-08-23 14:44:03','2023-08-29 06:14:08'),(1257,'2023-08-24 05:53:00','2023-08-24 17:53:20','12.249.250.150','12.249.250.150','closed',12,720,'attendances/1585/1692881580 clock_in.png','attendances/1585/1692924800 clock_out.png','Juan R',37976,NULL,'2023-08-24 09:53:00','2023-08-29 06:00:09'),(1258,'2023-08-24 05:53:41','2023-08-24 17:55:21','12.249.250.150','12.249.250.150','closed',12,721,'attendances/2025/1692881621 clock_in.png','attendances/2025/1692924921 clock_out.png','Juan R',37979,NULL,'2023-08-24 09:53:41','2023-08-29 06:16:33'),(1259,'2023-08-24 05:54:18','2023-08-24 17:53:42','12.249.250.150','12.249.250.150','closed',11,719,'attendances/2005/1692881658 clock_in.png','attendances/2005/1692924822 clock_out.png','Juan R',37978,NULL,'2023-08-24 09:54:18','2023-08-29 06:10:03'),(1260,'2023-08-24 05:56:16','2023-08-24 17:54:00','12.249.250.150','','closed',11,717,'attendances/1551/1692881776 clock_in.png',NULL,'Juan R',37975,NULL,'2023-08-24 09:56:16','2023-08-29 05:59:44'),(1261,'2023-08-24 05:56:38','2023-08-24 17:52:39','12.249.250.150','12.249.250.150','closed',11,716,'attendances/1395/1692881798 clock_in.png','attendances/1395/1692924759 clock_out.png','Juan R',37994,NULL,'2023-08-24 09:56:38','2023-08-29 06:11:04'),(1262,'2023-08-24 05:56:51','2023-08-24 17:51:50','12.249.250.150','12.249.250.150','closed',11,714,'attendances/1999/1692881811 clock_in.png','attendances/1999/1692924710 clock_out.png','Juan R',37987,NULL,'2023-08-24 09:56:51','2023-08-29 06:06:58'),(1263,'2023-08-24 06:00:13','2023-08-24 17:55:46','12.249.250.150','12.249.250.150','closed',11,715,'attendances/382/1692882013 clock_in.png','attendances/382/1692924946 clock_out.png','Juan R',37977,NULL,'2023-08-24 10:00:13','2023-08-29 06:03:53'),(1264,'2023-08-24 06:53:39','2023-08-24 15:32:22','12.249.250.150','12.249.250.150','closed',8,518,'attendances/726/1692885219 clock_in.png','attendances/726/1692916342 clock_out.png','Juan R',37981,NULL,'2023-08-24 10:53:39','2023-08-29 05:59:08'),(1265,'2023-08-24 06:54:08','2023-08-24 15:31:29','12.249.250.150','12.249.250.150','closed',8,517,'attendances/622/1692885248 clock_in.png','attendances/622/1692916289 clock_out.png','Juan R',37998,NULL,'2023-08-24 10:54:08','2023-08-29 06:14:29'),(1266,'2023-08-24 06:54:10','2023-08-24 15:36:04','12.249.250.150','12.249.250.150','closed',8,521,'attendances/1588/1692885250 clock_in.png','attendances/1588/1692916564 clock_out.png','Juan R',37983,NULL,'2023-08-24 10:54:10','2023-08-29 06:01:29'),(1267,'2023-08-24 06:54:20','2023-08-24 15:31:41','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1774/1692885260 clock_in.png','attendances/1774/1692916301 clock_out.png','Juan R',37985,NULL,'2023-08-24 10:54:20','2023-08-29 06:04:30'),(1268,'2023-08-24 06:55:14','2023-08-24 15:56:20','12.249.250.150','12.249.250.150','closed',9,541,'attendances/1948/1692885314 clock_in.png','attendances/1948/1692917780 clock_out.png','Juan R',37995,NULL,'2023-08-24 10:55:14','2023-08-29 06:12:49'),(1269,'2023-08-24 06:55:35','2023-08-24 15:37:33','12.249.250.150','12.249.250.150','closed',8,521,'attendances/974/1692885335 clock_in.png','attendances/974/1692916653 clock_out.png','Juan R',37980,NULL,'2023-08-24 10:55:35','2023-08-29 05:58:45'),(1270,'2023-08-24 06:55:55','2023-08-24 17:47:26','12.249.250.150','12.249.250.150','closed',10,651,'attendances/1728/1692885355 clock_in.png','attendances/1728/1692924446 clock_out.png','Juan R',37991,NULL,'2023-08-24 10:55:55','2023-08-29 06:08:56'),(1271,'2023-08-24 06:56:21','2023-08-24 15:32:17','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1934/1692885381 clock_in.png','attendances/1934/1692916337 clock_out.png','Juan R',37989,NULL,'2023-08-24 10:56:21','2023-08-29 06:08:01'),(1272,'2023-08-24 06:56:58','2023-08-24 15:31:54','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1568/1692885418 clock_in.png','attendances/1568/1692916314 clock_out.png','Juan R',37982,NULL,'2023-08-24 10:56:58','2023-08-29 06:00:36'),(1273,'2023-08-24 06:58:41','2023-08-24 15:35:03','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1958/1692885521 clock_in.png','attendances/1958/1692916503 clock_out.png','Juan R',37986,NULL,'2023-08-24 10:58:41','2023-08-29 06:05:07'),(1274,'2023-08-24 06:59:15','2023-08-24 17:28:30','12.249.250.150','12.249.250.150','closed',10,629,'attendances/1455/1692885555 clock_in.png','attendances/1455/1692923310 clock_out.png','Juan R',37990,NULL,'2023-08-24 10:59:15','2023-08-29 06:08:36'),(1275,'2023-08-24 06:59:27','2023-08-24 16:34:27','12.249.250.150','12.249.250.150','closed',9,575,'attendances/1462/1692885567 clock_in.png','attendances/1462/1692920067 clock_out.png','Juan R',37988,NULL,'2023-08-24 10:59:27','2023-08-29 06:07:33'),(1276,'2023-08-24 07:00:01','2023-08-24 15:48:37','12.249.250.150','12.249.250.150','closed',8,528,'attendances/1951/1692885601 clock_in.png','attendances/1951/1692917317 clock_out.png','Juan R',37984,NULL,'2023-08-24 11:00:01','2023-08-29 06:03:21'),(1277,'2023-08-24 07:03:06','2023-08-24 18:44:07','12.249.250.150','12.249.250.150','closed',11,701,'attendances/1450/1692885786 clock_in.png','attendances/1450/1692927847 clock_out.png','Juan R',37996,NULL,'2023-08-24 11:03:06','2023-08-29 06:13:30'),(1278,'2023-08-24 07:03:07','2023-08-24 15:31:16','12.249.250.150','12.249.250.150','closed',8,508,'attendances/1888/1692885787 clock_in.png','attendances/1888/1692916276 clock_out.png','Juan R',37999,NULL,'2023-08-24 11:03:07','2023-08-29 06:16:51'),(1279,'2023-08-24 07:05:44','2023-08-24 15:35:37','12.249.250.150','12.249.250.150','closed',8,509,'attendances/1858/1692885944 clock_in.png','attendances/1858/1692916537 clock_out.png','Juan R',37992,NULL,'2023-08-24 11:05:44','2023-08-29 06:09:30'),(1280,'2023-08-24 07:13:53','2023-08-24 18:44:56','12.249.250.150','12.249.250.150','closed',11,691,'attendances/1953/1692886433 clock_in.png','attendances/1953/1692927896 clock_out.png','Juan R',37997,NULL,'2023-08-24 11:13:53','2023-08-29 06:14:03'),(1281,'2023-08-24 07:00:57','2023-08-24 17:53:33','12.249.250.150','12.249.250.150','closed',10,652,'attendances/1116/1692886977 clock_in.png','attendances/1116/1692924813 clock_out.png','Juan R',37993,NULL,'2023-08-24 11:22:57','2023-08-29 06:10:26'),(1282,'2023-08-24 07:56:23','2023-08-24 16:33:09','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1869/1692888983 clock_in.png','attendances/1869/1692919989 clock_out.png','Juan R',38000,NULL,'2023-08-24 11:56:23','2023-08-29 06:00:59'),(1283,'2023-08-24 07:58:33','2023-08-24 16:30:16','12.249.250.150','12.249.250.150','closed',8,511,'attendances/775/1692889113 clock_in.png','attendances/775/1692919816 clock_out.png','Juan R',38001,NULL,'2023-08-24 11:58:33','2023-08-29 06:11:39'),(1284,'2023-08-24 08:14:39','2023-08-24 16:33:23','12.249.250.150','12.249.250.150','closed',8,498,'attendances/1891/1692890079 clock_in.png','attendances/1891/1692920003 clock_out.png','Juan R',38002,NULL,'2023-08-24 12:14:39','2023-08-29 06:12:24'),(1285,'2023-08-24 08:22:55','2023-08-24 17:51:30','12.249.250.150','12.249.250.150','closed',9,568,'attendances/1479/1692890575 clock_in.png','attendances/1479/1692924690 clock_out.png','Juan R',38004,NULL,'2023-08-24 12:22:55','2023-08-29 06:02:50'),(1286,'2023-08-24 08:26:00','2023-08-24 16:30:43','12.249.250.150','12.249.250.150','closed',8,484,'attendances/1492/1692890760 clock_in.png','attendances/1492/1692919843 clock_out.png','Juan R',38003,NULL,'2023-08-24 12:26:00','2023-08-29 06:15:27'),(1288,'2023-08-25 05:55:15','2023-08-25 18:29:36','12.249.250.150','12.249.250.150','closed',12,754,'attendances/1585/1692968115 clock_in.png','attendances/1585/1693013376 clock_out.png','Juan R',38007,NULL,'2023-08-25 09:55:15','2023-08-29 06:00:05'),(1289,'2023-08-25 05:55:56','2023-08-25 18:27:22','12.249.250.150','12.249.250.150','closed',12,751,'attendances/2005/1692968156 clock_in.png','attendances/2005/1693013242 clock_out.png','Juan R',38009,NULL,'2023-08-25 09:55:56','2023-08-29 06:09:54'),(1290,'2023-08-25 05:58:09','2023-08-25 18:30:18','12.249.250.150','12.249.250.150','closed',12,752,'attendances/382/1692968289 clock_in.png','attendances/382/1693013418 clock_out.png','Juan R',38008,NULL,'2023-08-25 09:58:09','2023-08-29 06:03:49'),(1291,'2023-08-25 05:58:18','2023-08-25 16:03:42','12.249.250.150','12.249.250.150','closed',10,605,'attendances/1395/1692968298 clock_in.png','attendances/1395/1693004622 clock_out.png','Juan R',38025,NULL,'2023-08-25 09:58:18','2023-08-29 06:11:03'),(1292,'2023-08-25 05:58:33','2023-08-25 16:04:05','12.249.250.150','12.249.250.150','closed',10,605,'attendances/1999/1692968313 clock_in.png','attendances/1999/1693004645 clock_out.png','Juan R',38018,NULL,'2023-08-25 09:58:33','2023-08-29 06:06:54'),(1293,'2023-08-25 05:58:35','2023-08-25 18:27:40','12.249.250.150','12.249.250.150','closed',12,749,'attendances/1551/1692968315 clock_in.png','attendances/1551/1693013260 clock_out.png','Juan R',38006,NULL,'2023-08-25 09:58:35','2023-08-29 05:59:39'),(1294,'2023-08-25 06:01:43','2023-08-25 18:31:21','12.249.250.150','12.249.250.150','closed',12,749,'attendances/1450/1692968503 clock_in.png','attendances/1450/1693013481 clock_out.png','Juan R',38010,NULL,'2023-08-25 10:01:43','2023-08-29 06:13:25'),(1295,'2023-08-25 06:02:08','2023-08-25 16:03:11','12.249.250.150','12.249.250.150','closed',10,601,'attendances/1728/1692968528 clock_in.png','attendances/1728/1693004591 clock_out.png','Juan R',38022,NULL,'2023-08-25 10:02:08','2023-08-29 06:08:51'),(1296,'2023-08-25 06:52:43','2023-08-25 15:35:07','12.249.250.150','12.249.250.150','closed',8,522,'attendances/622/1692971563 clock_in.png','attendances/622/1693002907 clock_out.png','Juan R',38027,NULL,'2023-08-25 10:52:43','2023-08-29 06:14:40'),(1297,'2023-08-25 06:54:02','2023-08-25 15:37:13','12.249.250.150','12.249.250.150','closed',8,523,'attendances/1588/1692971642 clock_in.png','attendances/1588/1693003033 clock_out.png','Juan R',38014,NULL,'2023-08-25 10:54:02','2023-08-29 06:01:25'),(1298,'2023-08-25 06:54:20','2023-08-25 13:50:52','12.249.250.150','12.249.250.150','closed',6,416,'attendances/2025/1692971660 clock_in.png','attendances/2025/1692996652 clock_out.png','Juan R',38028,NULL,'2023-08-25 10:54:20','2023-08-29 06:16:20'),(1299,'2023-08-25 06:54:32','2023-08-25 15:31:19','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1774/1692971672 clock_in.png','attendances/1774/1693002679 clock_out.png','Juan R',38016,NULL,'2023-08-25 10:54:32','2023-08-29 06:04:26'),(1300,'2023-08-25 06:54:51','2023-08-25 15:31:58','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1934/1692971691 clock_in.png','attendances/1934/1693002718 clock_out.png','Juan R',38020,NULL,'2023-08-25 10:54:51','2023-08-29 06:07:57'),(1301,'2023-08-25 06:54:52','2023-08-25 16:35:10','12.249.250.150','12.249.250.150','closed',9,580,'attendances/726/1692971692 clock_in.png','attendances/726/1693006510 clock_out.png','Juan R',38012,NULL,'2023-08-25 10:54:52','2023-08-29 05:58:59'),(1302,'2023-08-25 06:55:03','2023-08-25 15:36:15','12.249.250.150','12.249.250.150','closed',8,521,'attendances/1568/1692971703 clock_in.png','attendances/1568/1693002975 clock_out.png','Juan R',38013,NULL,'2023-08-25 10:55:03','2023-08-29 06:00:32'),(1303,'2023-08-25 06:55:20','2023-08-25 16:06:21','12.249.250.150','12.249.250.150','closed',9,551,'attendances/1116/1692971720 clock_in.png','attendances/1116/1693004781 clock_out.png','Juan R',38024,NULL,'2023-08-25 10:55:20','2023-08-29 06:10:23'),(1304,'2023-08-25 06:55:45','2023-08-25 15:34:09','12.249.250.150','12.249.250.150','closed',8,518,'attendances/1948/1692971745 clock_in.png','attendances/1948/1693002849 clock_out.png','Juan R',38026,NULL,'2023-08-25 10:55:45','2023-08-29 06:12:48'),(1305,'2023-08-25 06:58:18','2023-08-25 15:33:14','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1958/1692971898 clock_in.png','attendances/1958/1693002794 clock_out.png','Juan R',38017,NULL,'2023-08-25 10:58:18','2023-08-29 06:04:57'),(1306,'2023-08-25 06:59:12','2023-08-25 15:37:57','12.249.250.150','12.249.250.150','closed',8,518,'attendances/1951/1692971952 clock_in.png','attendances/1951/1693003077 clock_out.png','Juan R',38015,NULL,'2023-08-25 10:59:12','2023-08-29 06:03:12'),(1307,'2023-08-25 06:59:58','2023-08-25 17:06:48','12.249.250.150','12.249.250.150','closed',10,606,'attendances/1455/1692971998 clock_in.png','attendances/1455/1693008408 clock_out.png','Juan R',38021,NULL,'2023-08-25 10:59:58','2023-08-29 06:08:32'),(1308,'2023-08-25 07:00:10','2023-08-25 16:05:38','12.249.250.150','12.249.250.150','closed',9,545,'attendances/974/1692972010 clock_in.png','attendances/974/1693004738 clock_out.png','Juan R',38011,NULL,'2023-08-25 11:00:10','2023-08-29 05:55:37'),(1309,'2023-08-25 07:01:35','2023-08-25 15:32:56','12.249.250.150','12.249.250.150','closed',8,511,'attendances/1858/1692972095 clock_in.png','attendances/1858/1693002776 clock_out.png','Juan R',38023,NULL,'2023-08-25 11:01:35','2023-08-29 06:09:24'),(1310,'2023-08-25 07:02:59','2023-08-25 15:33:18','12.249.250.150','12.249.250.150','closed',8,510,'attendances/1888/1692972179 clock_in.png','attendances/1888/1693002798 clock_out.png','Juan R',38029,NULL,'2023-08-25 11:02:59','2023-08-29 06:16:46'),(1311,'2023-08-25 07:12:07','2023-08-25 16:01:21','12.249.250.150','12.249.250.150','closed',8,529,'attendances/1462/1692972727 clock_in.png','attendances/1462/1693004481 clock_out.png','Juan R',38019,NULL,'2023-08-25 11:12:07','2023-08-29 06:07:28'),(1312,'2023-08-25 07:59:23','2023-08-25 16:30:40','12.249.250.150','12.249.250.150','closed',8,511,'attendances/775/1692975563 clock_in.png','attendances/775/1693006240 clock_out.png','Juan R',38031,NULL,'2023-08-25 11:59:23','2023-08-29 06:11:33'),(1313,'2023-08-25 08:00:40','2023-08-25 16:39:15','12.249.250.150','12.249.250.150','closed',8,518,'attendances/1869/1692975640 clock_in.png','attendances/1869/1693006755 clock_out.png','Juan R',38030,NULL,'2023-08-25 12:00:40','2023-08-29 06:00:55'),(1314,'2023-08-25 08:01:14','2023-08-25 16:39:23','12.249.250.150','12.249.250.150','closed',8,518,'attendances/1891/1692975674 clock_in.png','attendances/1891/1693006763 clock_out.png','Juan R',38032,NULL,'2023-08-25 12:01:14','2023-08-29 06:12:20'),(1315,'2023-08-25 08:25:06','2023-08-25 16:31:09','12.249.250.150','12.249.250.150','closed',8,486,'attendances/1492/1692977106 clock_in.png','attendances/1492/1693006269 clock_out.png','Juan R',38033,NULL,'2023-08-25 12:25:06','2023-08-29 06:15:21'),(1316,'2023-08-25 08:26:08','2023-08-25 17:01:44','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1479/1692977168 clock_in.png','attendances/1479/1693008104 clock_out.png','Juan R',38034,NULL,'2023-08-25 12:26:08','2023-08-29 06:02:45'),(1317,'2023-08-26 04:55:55','2023-08-26 14:00:08','12.249.250.150','12.249.250.150','closed',9,544,'attendances/1588/1693050955 clock_in.png','attendances/1588/1693083608 clock_out.png','Juan R',38078,NULL,'2023-08-26 08:55:55','2023-08-29 06:01:18'),(1318,'2023-08-26 04:56:07','2023-08-26 13:56:02','12.249.250.150','12.249.250.150','closed',8,539,'attendances/1568/1693050967 clock_in.png','attendances/1568/1693083362 clock_out.png','Juan R',38077,NULL,'2023-08-26 08:56:07','2023-08-29 06:00:28'),(1319,'2023-08-26 05:57:58','2023-08-26 15:11:25','12.249.250.150','12.249.250.150','closed',9,553,'attendances/1551/1693054678 clock_in.png','attendances/1551/1693087885 clock_out.png','Juan R',38075,NULL,'2023-08-26 09:57:58','2023-08-29 05:59:32'),(1320,'2023-08-26 05:58:16','2023-08-26 16:12:58','12.249.250.150','12.249.250.150','closed',10,614,'attendances/1953/1693054696 clock_in.png','attendances/1953/1693091578 clock_out.png','Juan R',38083,NULL,'2023-08-26 09:58:16','2023-08-29 06:13:58'),(1321,'2023-08-26 05:58:32','2023-08-26 15:12:18','12.249.250.150','12.249.250.150','closed',9,553,'attendances/1585/1693054712 clock_in.png','attendances/1585/1693087938 clock_out.png','Juan R',38076,NULL,'2023-08-26 09:58:32','2023-08-29 06:00:00'),(1322,'2023-08-26 05:58:47','2023-08-26 15:11:53','12.249.250.150','12.249.250.150','closed',9,553,'attendances/2005/1693054727 clock_in.png','attendances/2005/1693087913 clock_out.png','Juan R',38080,NULL,'2023-08-26 09:58:47','2023-08-29 06:09:50'),(1323,'2023-08-26 06:01:16','2023-08-26 15:12:10','12.249.250.150','12.249.250.150','closed',9,550,'attendances/382/1693054876 clock_in.png','attendances/382/1693087930 clock_out.png','Juan R',38079,NULL,'2023-08-26 10:01:16','2023-08-29 06:03:44'),(1324,'2023-08-26 06:02:17','2023-08-26 15:11:39','12.249.250.150','12.249.250.150','closed',9,549,'attendances/1450/1693054937 clock_in.png','attendances/1450/1693087899 clock_out.png','Juan R',38082,NULL,'2023-08-26 10:02:17','2023-08-29 06:13:19'),(1325,'2023-08-26 06:28:40','2023-08-26 10:54:58','12.249.250.150','12.249.250.150','closed',4,266,'attendances/1455/1693056520 clock_in.png','attendances/1455/1693072498 clock_out.png','Juan R',38084,NULL,'2023-08-26 10:28:40','2023-08-29 06:08:28'),(1326,'2023-08-26 07:55:14','2023-08-26 14:58:27','12.249.250.150','12.249.250.150','closed',7,423,'attendances/1479/1693061714 clock_in.png','attendances/1479/1693087107 clock_out.png','Juan R',38085,NULL,'2023-08-26 11:55:14','2023-08-29 06:02:36'),(1327,'2023-08-26 05:55:00','2023-08-26 17:52:38','186.102.95.178','12.249.250.150','closed',11,717,NULL,'attendances/1116/1693097558 clock_out.png','Juan R',38081,NULL,'2023-08-26 14:23:44','2023-08-29 06:10:18'),(1328,'2023-08-26 22:50:01','2023-08-26 23:59:00','12.249.250.150','','closed',1,68,'attendances/1479/1693115401 clock_in.png',NULL,'Juan R',38128,NULL,'2023-08-27 02:50:01','2023-08-29 06:02:29'),(1329,'2023-08-27 00:00:00','2023-08-27 01:48:00','186.102.34.138','','closed',1,108,NULL,NULL,'Juan R',38138,NULL,'2023-08-27 14:12:27','2023-08-29 06:02:23'),(1330,'2023-08-27 18:11:19','2023-08-27 23:59:00','12.249.250.150','','closed',5,347,'attendances/1953/1693185079 clock_in.png',NULL,'Juan R',NULL,NULL,'2023-08-27 22:11:19','2023-08-29 06:13:55'),(1333,'2023-08-28 05:56:52','2023-08-28 14:29:12','12.249.250.150','12.249.250.150','closed',8,512,'attendances/2005/1693227412 clock_in.png','attendances/2005/1693258152 clock_out.png','Juan R',38126,NULL,'2023-08-28 09:56:52','2023-09-05 04:29:23'),(1334,'2023-08-28 05:57:09','2023-08-28 14:29:43','12.249.250.150','12.249.250.150','closed',8,512,'attendances/1551/1693227429 clock_in.png','attendances/1551/1693258183 clock_out.png','Juan R',38123,NULL,'2023-08-28 09:57:09','2023-09-05 04:13:56'),(1335,'2023-08-28 05:58:01','2023-08-28 14:29:59','12.249.250.150','12.249.250.150','closed',8,511,'attendances/1585/1693227481 clock_in.png','attendances/1585/1693258199 clock_out.png','Juan R',38124,NULL,'2023-08-28 09:58:01','2023-09-05 04:14:16'),(1336,'2023-08-28 05:59:48','2023-08-28 14:43:26','12.249.250.150','12.249.250.150','closed',8,523,'attendances/1450/1693227588 clock_in.png','attendances/1450/1693259006 clock_out.png','Juan R',38127,NULL,'2023-08-28 09:59:48','2023-09-05 04:32:39'),(1337,'2023-08-28 06:32:19','2023-08-28 15:31:41','12.249.250.150','12.249.250.150','closed',8,539,'attendances/1568/1693229539 clock_in.png','attendances/1568/1693261901 clock_out.png','Juan R',38100,NULL,'2023-08-28 10:32:19','2023-09-05 04:14:40'),(1338,'2023-08-28 06:51:41','2023-08-28 13:03:07','12.249.250.150','12.249.250.150','closed',6,371,'attendances/1999/1693230701 clock_in.png','attendances/1999/1693252987 clock_out.png','Juan R',38105,NULL,'2023-08-28 10:51:41','2023-09-05 04:21:10'),(1339,'2023-08-28 06:51:56','2023-08-28 16:24:11','12.249.250.150','12.249.250.150','closed',9,572,'attendances/1395/1693230716 clock_in.png','attendances/1395/1693265051 clock_out.png','Juan R',38111,NULL,'2023-08-28 10:51:56','2023-09-05 04:30:14'),(1340,'2023-08-28 06:53:51','2023-08-28 15:36:09','12.249.250.150','12.249.250.150','closed',8,522,'attendances/1953/1693230831 clock_in.png','attendances/1953/1693262169 clock_out.png','Juan R',38170,NULL,'2023-08-28 10:53:51','2023-09-01 17:58:34'),(1341,'2023-08-28 06:54:53','2023-08-28 15:28:14','12.249.250.150','12.249.250.150','closed',8,513,'attendances/726/1693230893 clock_in.png','attendances/726/1693261694 clock_out.png','Juan R',38099,NULL,'2023-08-28 10:54:53','2023-09-05 04:13:34'),(1342,'2023-08-28 06:55:14','2023-08-28 16:31:42','12.249.250.150','12.249.250.150','closed',9,576,'attendances/1958/1693230914 clock_in.png','attendances/1958/1693265502 clock_out.png','Juan R',38104,NULL,'2023-08-28 10:55:14','2023-09-05 04:20:29'),(1343,'2023-08-28 06:55:25','2023-08-28 15:35:10','12.249.250.150','12.249.250.150','closed',8,519,'attendances/1116/1693230925 clock_in.png','attendances/1116/1693262110 clock_out.png','Juan R',38110,NULL,'2023-08-28 10:55:25','2023-09-05 04:29:45'),(1344,'2023-08-28 06:55:33','2023-08-28 15:30:13','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1588/1693230933 clock_in.png','attendances/1588/1693261813 clock_out.png','Juan R',38101,NULL,'2023-08-28 10:55:33','2023-09-05 04:17:12'),(1345,'2023-08-28 06:55:43','2023-08-28 15:32:07','12.249.250.150','12.249.250.150','closed',8,516,'attendances/622/1693230943 clock_in.png','attendances/622/1693261927 clock_out.png','Juan R',38114,NULL,'2023-08-28 10:55:43','2023-09-05 04:33:09'),(1346,'2023-08-28 06:55:58','2023-08-28 15:38:05','12.249.250.150','12.249.250.150','closed',8,522,'attendances/1948/1693230958 clock_in.png','attendances/1948/1693262285 clock_out.png','Juan R',38112,NULL,'2023-08-28 10:55:58','2023-09-05 04:32:14'),(1347,'2023-08-28 06:56:00','2023-08-28 15:19:34','12.249.250.150','12.249.250.150','closed',8,503,'attendances/2025/1693230960 clock_in.png','attendances/2025/1693261174 clock_out.png','Juan R',38115,NULL,'2023-08-28 10:56:00','2023-09-05 04:34:24'),(1348,'2023-08-28 06:56:13','2023-08-28 15:32:02','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1934/1693230973 clock_in.png','attendances/1934/1693261922 clock_out.png','Juan R',38106,NULL,'2023-08-28 10:56:13','2023-09-05 04:24:42'),(1349,'2023-08-28 06:56:26','2023-08-28 15:31:25','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1774/1693230986 clock_in.png','attendances/1774/1693261885 clock_out.png','Juan R',38103,NULL,'2023-08-28 10:56:26','2023-09-05 04:18:53'),(1350,'2023-08-28 06:57:20','2023-08-28 15:17:00','12.249.250.150','','closed',8,499,'attendances/974/1693231040 clock_in.png',NULL,'Juan R',38098,NULL,'2023-08-28 10:57:20','2023-09-05 04:12:51'),(1351,'2023-08-28 06:57:57','2023-08-28 15:53:23','12.249.250.150','12.249.250.150','closed',8,535,'attendances/1455/1693231077 clock_in.png','attendances/1455/1693263203 clock_out.png','Juan R',38107,NULL,'2023-08-28 10:57:57','2023-09-05 04:27:29'),(1352,'2023-08-28 06:59:43','2023-08-28 15:39:32','12.249.250.150','12.249.250.150','closed',8,519,'attendances/1728/1693231183 clock_in.png','attendances/1728/1693262372 clock_out.png','Juan R',38108,NULL,'2023-08-28 10:59:43','2023-09-05 04:27:54'),(1353,'2023-08-28 06:59:52','2023-08-28 15:35:35','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1951/1693231192 clock_in.png','attendances/1951/1693262135 clock_out.png','Juan R',38102,NULL,'2023-08-28 10:59:52','2023-09-05 04:18:03'),(1354,'2023-08-28 07:01:49','2023-08-28 15:37:52','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1888/1693231309 clock_in.png','attendances/1888/1693262272 clock_out.png','Juan R',38116,NULL,'2023-08-28 11:01:49','2023-09-05 04:35:51'),(1355,'2023-08-28 07:04:33','2023-08-28 16:31:58','12.249.250.150','12.249.250.150','closed',9,567,'attendances/1858/1693231473 clock_in.png','attendances/1858/1693265518 clock_out.png','Juan R',38109,NULL,'2023-08-28 11:04:33','2023-09-05 04:28:23'),(1356,'2023-08-28 07:54:59','2023-08-28 16:32:49','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1869/1693234499 clock_in.png','attendances/1869/1693265569 clock_out.png','Juan R',38117,NULL,'2023-08-28 11:54:59','2023-09-05 04:15:49'),(1357,'2023-08-28 07:58:58','2023-08-28 16:30:03','12.249.250.150','12.249.250.150','closed',8,511,'attendances/775/1693234738 clock_in.png','attendances/775/1693265403 clock_out.png','Juan R',38119,NULL,'2023-08-28 11:58:58','2023-09-05 04:30:42'),(1358,'2023-08-28 07:59:21','2023-08-28 16:13:23','12.249.250.150','12.249.250.150','closed',8,494,'attendances/1462/1693234761 clock_in.png','attendances/1462/1693264403 clock_out.png','Juan R',38118,NULL,'2023-08-28 11:59:21','2023-09-05 04:23:53'),(1359,'2023-08-28 08:10:54','2023-08-28 16:33:01','12.249.250.150','12.249.250.150','closed',8,502,'attendances/1891/1693235454 clock_in.png','attendances/1891/1693265581 clock_out.png','Juan R',38120,NULL,'2023-08-28 12:10:54','2023-09-05 04:31:58'),(1360,'2023-08-28 08:25:35','2023-08-28 16:30:37','12.249.250.150','12.249.250.150','closed',8,485,'attendances/1492/1693236335 clock_in.png','attendances/1492/1693265437 clock_out.png','Juan R',38121,NULL,'2023-08-28 12:25:35','2023-09-05 04:33:43'),(1361,'2023-08-28 08:26:48','2023-08-28 17:06:20','12.249.250.150','12.249.250.150','closed',8,519,'attendances/1479/1693236408 clock_in.png','attendances/1479/1693267580 clock_out.png','Juan R',38122,NULL,'2023-08-28 12:26:48','2023-09-05 04:17:33'),(1362,'2023-08-28 00:00:00','2023-08-28 02:33:00','179.32.223.183','179.32.223.183','closed',2,153,NULL,NULL,'Juan R',38169,NULL,'2023-08-29 10:50:39','2023-09-01 18:04:49'),(1364,'2023-08-29 06:52:35','2023-08-29 15:31:28','12.249.250.150','12.249.250.150','closed',8,518,'attendances/622/1693317155 clock_in.png','attendances/622/1693348288 clock_out.png','Juan R',38185,NULL,'2023-08-29 10:52:35','2023-09-05 04:33:02'),(1365,'2023-08-29 06:53:20','2023-08-29 15:35:05','12.249.250.150','12.249.250.150','closed',8,521,'attendances/1999/1693317200 clock_in.png','attendances/1999/1693348505 clock_out.png','Juan R',38177,NULL,'2023-08-29 10:53:20','2023-09-05 04:21:08'),(1366,'2023-08-29 06:54:08','2023-08-29 15:35:36','12.249.250.150','12.249.250.150','closed',8,521,'attendances/726/1693317248 clock_in.png','attendances/726/1693333846 clock_out.png','Juan R',38171,NULL,'2023-08-29 10:54:08','2023-09-05 04:13:27'),(1367,'2023-08-29 06:54:53','2023-08-29 15:38:08','12.249.250.150','12.249.250.150','closed',8,523,'attendances/1395/1693317293 clock_in.png','attendances/1395/1693348688 clock_out.png','Juan R',38183,NULL,'2023-08-29 10:54:53','2023-09-05 04:30:05'),(1368,'2023-08-29 06:55:14','2023-08-29 15:31:40','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1588/1693317315 clock_in.png','attendances/1588/1693348300 clock_out.png','Juan R',38173,NULL,'2023-08-29 10:55:15','2023-09-05 04:17:07'),(1369,'2023-08-29 06:55:29','2023-08-29 15:31:44','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1774/1693317329 clock_in.png','attendances/1774/1693348304 clock_out.png','Juan R',38175,NULL,'2023-08-29 10:55:29','2023-09-05 04:18:47'),(1370,'2023-08-29 06:55:55','2023-08-29 15:30:29','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1934/1693317355 clock_in.png','attendances/1934/1693348229 clock_out.png','Juan R',38179,NULL,'2023-08-29 10:55:55','2023-09-05 04:24:36'),(1371,'2023-08-29 06:56:13','2023-08-29 15:33:46','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1958/1693317373 clock_in.png','attendances/1958/1693348426 clock_out.png','Juan R',38176,NULL,'2023-08-29 10:56:13','2023-09-05 04:19:39'),(1372,'2023-08-29 06:56:47','2023-08-29 15:40:44','12.249.250.150','12.249.250.150','closed',8,523,'attendances/1948/1693317407 clock_in.png','attendances/1948/1693348844 clock_out.png','Juan R',38184,NULL,'2023-08-29 10:56:47','2023-09-05 04:32:11'),(1373,'2023-08-29 06:57:02','2023-08-29 15:30:09','12.249.250.150','12.249.250.150','closed',8,513,'attendances/1568/1693317422 clock_in.png','attendances/1568/1693348209 clock_out.png','Juan R',38172,NULL,'2023-08-29 10:57:02','2023-09-05 04:14:31'),(1374,'2023-08-29 06:57:16','2023-08-29 15:29:19','12.249.250.150','12.249.250.150','closed',8,512,'attendances/1951/1693317436 clock_in.png','attendances/1951/1693348159 clock_out.png','Juan R',38174,NULL,'2023-08-29 10:57:16','2023-09-05 04:17:57'),(1375,'2023-08-29 06:57:30','2023-08-29 16:04:47','12.249.250.150','12.249.250.150','closed',9,547,'attendances/1462/1693317450 clock_in.png','attendances/1462/1693350287 clock_out.png','Juan R',38178,NULL,'2023-08-29 10:57:30','2023-09-05 04:23:37'),(1376,'2023-08-29 06:58:13','2023-08-29 15:37:54','12.249.250.150','12.249.250.150','closed',8,519,'attendances/1728/1693317493 clock_in.png','attendances/1728/1693348674 clock_out.png','Juan R',38181,NULL,'2023-08-29 10:58:13','2023-09-05 04:27:48'),(1377,'2023-08-29 07:01:45','2023-08-29 15:30:56','12.249.250.150','12.249.250.150','closed',8,509,'attendances/1455/1693317705 clock_in.png','attendances/1455/1693348256 clock_out.png','Juan R',38180,NULL,'2023-08-29 11:01:45','2023-09-05 04:27:25'),(1378,'2023-08-29 07:02:59','2023-08-29 15:42:52','12.249.250.150','12.249.250.150','closed',8,519,'attendances/1888/1693317779 clock_in.png','attendances/1888/1693348972 clock_out.png','Juan R',38186,NULL,'2023-08-29 11:02:59','2023-09-05 04:35:47'),(1379,'2023-08-29 07:06:31','2023-08-29 15:33:18','12.249.250.150','12.249.250.150','closed',8,506,'attendances/1858/1693317991 clock_in.png','attendances/1858/1693348398 clock_out.png','Juan R',38182,NULL,'2023-08-29 11:06:31','2023-09-05 04:28:17'),(1380,'2023-08-29 07:58:52','2023-08-29 16:29:55','12.249.250.150','12.249.250.150','closed',8,511,'attendances/775/1693321132 clock_in.png','attendances/775/1693351795 clock_out.png','Juan R',38188,NULL,'2023-08-29 11:58:52','2023-09-05 04:30:37'),(1381,'2023-08-29 08:04:01','2023-08-29 16:33:34','12.249.250.150','12.249.250.150','closed',8,509,'attendances/1891/1693321441 clock_in.png','attendances/1891/1693352014 clock_out.png','Juan R',38189,NULL,'2023-08-29 12:04:01','2023-09-05 04:31:56'),(1382,'2023-08-29 08:07:57','2023-08-29 16:33:22','12.249.250.150','12.249.250.150','closed',8,505,'attendances/1869/1693321677 clock_in.png','attendances/1869/1693352002 clock_out.png','Juan R',38187,NULL,'2023-08-29 12:07:57','2023-09-05 04:15:36'),(1383,'2023-08-29 08:20:33','2023-08-29 16:57:20','12.249.250.150','12.249.250.150','closed',8,516,'attendances/974/1693322433 clock_in.png','attendances/974/1693353440 clock_out.png','Juan R',38190,NULL,'2023-08-29 12:20:33','2023-09-05 04:12:37'),(1384,'2023-08-29 08:32:21','2023-08-29 16:31:14','12.249.250.150','12.249.250.150','closed',7,478,'attendances/1492/1693323141 clock_in.png','attendances/1492/1693351874 clock_out.png','Juan R',38191,NULL,'2023-08-29 12:32:21','2023-09-05 04:33:36'),(1385,'2023-08-30 05:55:17','2023-08-30 14:31:05','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1585/1693400117 clock_in.png','attendances/1585/1693431065 clock_out.png','Juan R',38214,NULL,'2023-08-30 09:55:17','2023-09-05 04:14:09'),(1386,'2023-08-30 05:58:57','2023-08-30 14:37:33','12.249.250.150','12.249.250.150','closed',8,518,'attendances/2025/1693400337 clock_in.png','attendances/2025/1693431453 clock_out.png','Juan R',38217,NULL,'2023-08-30 09:58:57','2023-09-05 04:34:17'),(1387,'2023-08-30 06:02:14','2023-08-30 14:40:20','12.249.250.150','12.249.250.150','closed',8,518,'attendances/1450/1693400534 clock_in.png','attendances/1450/1693431620 clock_out.png','Juan R',38215,NULL,'2023-08-30 10:02:14','2023-09-05 04:32:32'),(1388,'2023-08-30 06:06:57','2023-08-30 14:45:17','12.249.250.150','12.249.250.150','closed',8,518,'attendances/1953/1693400817 clock_in.png','attendances/1953/1693431917 clock_out.png','Juan R',38216,NULL,'2023-08-30 10:06:57','2023-09-01 17:58:26'),(1389,'2023-08-30 06:51:26','2023-08-30 15:32:14','12.249.250.150','12.249.250.150','closed',8,520,'attendances/622/1693403486 clock_in.png','attendances/622/1693434734 clock_out.png','Juan R',38236,NULL,'2023-08-30 10:51:26','2023-09-05 04:32:57'),(1390,'2023-08-30 06:52:35','2023-08-30 15:29:56','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1999/1693403555 clock_in.png','attendances/1999/1693434596 clock_out.png','Juan R',38227,NULL,'2023-08-30 10:52:35','2023-09-05 04:20:54'),(1391,'2023-08-30 06:54:13','2023-08-30 15:31:33','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1479/1693403653 clock_in.png','attendances/1479/1693434693 clock_out.png','Juan R',38222,NULL,'2023-08-30 10:54:13','2023-09-05 04:17:24'),(1392,'2023-08-30 06:54:54','2023-08-30 15:34:39','12.249.250.150','12.249.250.150','closed',8,519,'attendances/1728/1693403694 clock_in.png','attendances/1728/1693434879 clock_out.png','Juan R',38230,NULL,'2023-08-30 10:54:54','2023-09-05 04:27:44'),(1393,'2023-08-30 06:55:19','2023-08-30 15:29:04','12.249.250.150','12.249.250.150','closed',8,513,'attendances/2005/1693403719 clock_in.png','attendances/2005/1693434544 clock_out.png','Juan R',38232,NULL,'2023-08-30 10:55:19','2023-09-05 04:29:19'),(1394,'2023-08-30 06:55:32','2023-08-30 15:30:48','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1551/1693403732 clock_in.png','attendances/1551/1693434648 clock_out.png','Juan R',38221,NULL,'2023-08-30 10:55:32','2023-09-05 04:13:51'),(1395,'2023-08-30 06:55:51','2023-08-30 15:30:43','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1395/1693403751 clock_in.png','attendances/1395/1693434643 clock_out.png','Juan R',38234,NULL,'2023-08-30 10:55:51','2023-09-05 04:30:00'),(1396,'2023-08-30 06:55:54','2023-08-30 15:31:24','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1858/1693403754 clock_in.png','attendances/1858/1693403784 clock_out.png','Juan R',38231,NULL,'2023-08-30 10:55:54','2023-09-05 04:28:12'),(1397,'2023-08-30 06:56:37','2023-08-30 15:31:11','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1774/1693403797 clock_in.png','attendances/1774/1693434671 clock_out.png','Juan R',38225,NULL,'2023-08-30 10:56:37','2023-09-05 04:18:44'),(1398,'2023-08-30 06:56:44','2023-08-30 15:37:50','12.249.250.150','12.249.250.150','closed',8,521,'attendances/1116/1693403804 clock_in.png','attendances/1116/1693435070 clock_out.png','Juan R',38233,NULL,'2023-08-30 10:56:44','2023-09-05 04:29:41'),(1399,'2023-08-30 06:56:53','2023-08-30 15:32:25','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1934/1693403813 clock_in.png','attendances/1934/1693434745 clock_out.png','Juan R',38229,NULL,'2023-08-30 10:56:53','2023-09-05 04:24:30'),(1400,'2023-08-30 06:57:11','2023-08-30 15:31:23','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1958/1693403831 clock_in.png','attendances/1958/1693434683 clock_out.png','Juan R',38226,NULL,'2023-08-30 10:57:11','2023-09-05 04:19:31'),(1401,'2023-08-30 06:57:48','2023-08-30 15:30:47','12.249.250.150','12.249.250.150','closed',8,512,'attendances/1951/1693403868 clock_in.png','attendances/1951/1693434647 clock_out.png','Juan R',38224,NULL,'2023-08-30 10:57:48','2023-09-05 04:17:50'),(1402,'2023-08-30 06:58:08','2023-08-30 15:30:36','12.249.250.150','12.249.250.150','closed',8,512,'attendances/382/1693403888 clock_in.png','attendances/382/1693434636 clock_out.png','Juan R',38223,NULL,'2023-08-30 10:58:08','2023-09-05 04:18:33'),(1403,'2023-08-30 07:05:13','2023-08-30 15:37:32','12.249.250.150','12.249.250.150','closed',8,512,'attendances/1888/1693404313 clock_in.png','attendances/1888/1693435052 clock_out.png','Juan R',38237,NULL,'2023-08-30 11:05:13','2023-09-05 04:35:42'),(1404,'2023-08-30 07:05:27','2023-08-30 15:39:53','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1462/1693404327 clock_in.png','attendances/1462/1693435193 clock_out.png','Juan R',38228,NULL,'2023-08-30 11:05:27','2023-09-05 04:23:29'),(1405,'2023-08-30 07:07:28','2023-08-30 15:39:29','12.249.250.150','12.249.250.150','closed',8,512,'attendances/1948/1693404448 clock_in.png','attendances/1948/1693435169 clock_out.png','Juan R',38235,NULL,'2023-08-30 11:07:28','2023-09-05 04:32:01'),(1406,'2023-08-30 07:54:01','2023-08-30 16:30:21','12.249.250.150','12.249.250.150','closed',8,516,'attendances/974/1693407241 clock_in.png','attendances/974/1693438221 clock_out.png','Juan R',38238,NULL,'2023-08-30 11:54:01','2023-09-05 04:12:30'),(1407,'2023-08-30 07:59:40','2023-08-30 16:30:08','12.249.250.150','12.249.250.150','closed',8,510,'attendances/775/1693407580 clock_in.png','attendances/775/1693438208 clock_out.png','Juan R',38240,NULL,'2023-08-30 11:59:40','2023-09-05 04:30:27'),(1408,'2023-08-30 08:04:11','2023-08-30 16:33:01','12.249.250.150','12.249.250.150','closed',8,508,'attendances/1891/1693407851 clock_in.png','attendances/1891/1693438381 clock_out.png','Juan R',38241,NULL,'2023-08-30 12:04:11','2023-09-05 04:31:55'),(1409,'2023-08-30 08:09:32','2023-08-30 16:32:51','12.249.250.150','12.249.250.150','closed',8,503,'attendances/1869/1693408172 clock_in.png','attendances/1869/1693438371 clock_out.png','Juan R',38239,NULL,'2023-08-30 12:09:32','2023-09-05 04:15:31'),(1410,'2023-08-30 08:28:24','2023-08-30 16:30:24','12.249.250.150','12.249.250.150','closed',8,482,'attendances/1492/1693409304 clock_in.png','attendances/1492/1693438224 clock_out.png','Juan R',38242,NULL,'2023-08-30 12:28:24','2023-09-05 04:33:31'),(1411,'2023-08-31 05:54:08','2023-08-31 14:24:53','12.249.250.150','12.249.250.150','closed',8,510,'attendances/2005/1693486448 clock_in.png','attendances/2005/1693517093 clock_out.png','Juan R',38267,NULL,'2023-08-31 09:54:08','2023-09-05 04:29:11'),(1412,'2023-08-31 05:57:04','2023-08-31 14:29:26','12.249.250.150','12.249.250.150','closed',8,512,'attendances/1551/1693486624 clock_in.png','attendances/1551/1693517366 clock_out.png','Juan R',38252,NULL,'2023-08-31 09:57:04','2023-09-05 04:13:43'),(1413,'2023-08-31 05:57:47','2023-08-31 14:31:22','12.249.250.150','12.249.250.150','closed',8,513,'attendances/382/1693486667 clock_in.png','attendances/382/1693517482 clock_out.png','Juan R',38257,NULL,'2023-08-31 09:57:47','2023-09-05 04:18:13'),(1414,'2023-08-31 05:59:23','2023-08-31 14:23:47','12.249.250.150','12.249.250.150','closed',8,504,'attendances/1951/1693486763 clock_in.png','attendances/1951/1693517027 clock_out.png','Juan R',38258,NULL,'2023-08-31 09:59:23','2023-09-05 04:17:41'),(1415,'2023-08-31 06:49:05','2023-08-31 15:31:58','12.249.250.150','12.249.250.150','closed',8,522,'attendances/622/1693489745 clock_in.png','attendances/622/1693521118 clock_out.png','Juan R',38273,NULL,'2023-08-31 10:49:05','2023-09-05 04:32:53'),(1416,'2023-08-31 06:51:32','2023-08-31 15:33:39','12.249.250.150','12.249.250.150','closed',8,522,'attendances/1999/1693489892 clock_in.png','attendances/1999/1693521219 clock_out.png','Juan R',38261,NULL,'2023-08-31 10:51:32','2023-09-05 04:20:30'),(1417,'2023-08-31 06:55:21','2023-08-31 16:26:46','12.249.250.150','12.249.250.150','closed',9,571,'attendances/1395/1693490121 clock_in.png','attendances/1395/1693524406 clock_out.png','Juan R',38269,NULL,'2023-08-31 10:55:21','2023-09-05 04:29:55'),(1418,'2023-08-31 06:55:41','2023-08-31 15:29:32','12.249.250.150','12.249.250.150','closed',8,513,'attendances/2025/1693490141 clock_in.png','attendances/2025/1693520972 clock_out.png','Juan R',38274,NULL,'2023-08-31 10:55:41','2023-09-05 04:34:13'),(1419,'2023-08-31 06:55:45','2023-08-31 15:32:46','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1728/1693490145 clock_in.png','attendances/1728/1693521166 clock_out.png','Juan R',38265,NULL,'2023-08-31 10:55:45','2023-09-05 04:27:40'),(1420,'2023-08-31 06:56:04','2023-08-31 15:31:01','12.249.250.150','12.249.250.150','closed',8,514,'attendances/726/1693490164 clock_in.png','attendances/726/1693521061 clock_out.png','Juan R',38251,NULL,'2023-08-31 10:56:04','2023-09-05 04:13:20'),(1421,'2023-08-31 06:56:14','2023-08-31 15:38:02','12.249.250.150','12.249.250.150','closed',8,521,'attendances/1585/1693490174 clock_in.png','attendances/1585/1693521482 clock_out.png','Juan R',38253,NULL,'2023-08-31 10:56:14','2023-09-05 04:14:06'),(1422,'2023-08-31 06:56:22','2023-08-31 15:33:07','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1479/1693490182 clock_in.png','attendances/1479/1693521187 clock_out.png','Juan R',38256,NULL,'2023-08-31 10:56:22','2023-09-05 04:17:21'),(1423,'2023-08-31 06:56:29','2023-08-31 15:31:37','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1774/1693490189 clock_in.png','attendances/1774/1693521097 clock_out.png','Juan R',38259,NULL,'2023-08-31 10:56:29','2023-09-05 04:18:40'),(1424,'2023-08-31 06:56:34','2023-08-31 12:03:12','12.249.250.150','12.249.250.150','closed',5,306,'attendances/1568/1693490194 clock_in.png','attendances/1568/1693508592 clock_out.png','Juan R',38254,NULL,'2023-08-31 10:56:34','2023-09-05 04:14:26'),(1425,'2023-08-31 06:56:37','2023-08-31 15:39:00','12.249.250.150','12.249.250.150','closed',8,522,'attendances/1948/1693490197 clock_in.png','attendances/1948/1693521540 clock_out.png','Juan R',38270,NULL,'2023-08-31 10:56:37','2023-09-05 04:32:00'),(1426,'2023-08-31 06:56:46','2023-08-31 15:30:26','12.249.250.150','12.249.250.150','closed',8,513,'attendances/1934/1693490206 clock_in.png','attendances/1934/1693521026 clock_out.png','Juan R',38263,NULL,'2023-08-31 10:56:46','2023-09-05 04:24:24'),(1427,'2023-08-31 06:56:55','2023-08-31 15:32:11','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1588/1693490215 clock_in.png','attendances/1588/1693521131 clock_out.png','Juan R',38255,NULL,'2023-08-31 10:56:55','2023-09-05 04:17:00'),(1428,'2023-08-31 06:57:03','2023-08-31 15:33:25','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1958/1693490223 clock_in.png','attendances/1958/1693521205 clock_out.png','Juan R',38260,NULL,'2023-08-31 10:57:03','2023-09-05 04:19:06'),(1429,'2023-08-31 06:58:28','2023-08-31 15:39:35','12.249.250.150','12.249.250.150','closed',8,521,'attendances/1462/1693490308 clock_in.png','attendances/1462/1693521575 clock_out.png','Juan R',38262,NULL,'2023-08-31 10:58:28','2023-09-05 04:23:25'),(1430,'2023-08-31 07:00:23','2023-08-31 15:33:30','12.249.250.150','12.249.250.150','closed',8,513,'attendances/1450/1693490423 clock_in.png','attendances/1450/1693506570 clock_out.png','Juan R',38271,NULL,'2023-08-31 11:00:23','2023-09-05 04:32:27'),(1431,'2023-08-31 07:00:39','2023-08-31 15:32:27','12.249.250.150','12.249.250.150','closed',8,511,'attendances/1888/1693490439 clock_in.png','attendances/1888/1693521147 clock_out.png','Juan R',38275,NULL,'2023-08-31 11:00:39','2023-09-05 04:35:39'),(1432,'2023-08-31 07:03:09','2023-08-31 15:29:46','12.249.250.150','12.249.250.150','closed',8,506,'attendances/1455/1693490589 clock_in.png','attendances/1455/1693520986 clock_out.png','Juan R',38264,NULL,'2023-08-31 11:03:09','2023-09-05 04:27:22'),(1433,'2023-08-31 07:05:57','2023-08-31 15:33:02','12.249.250.150','12.249.250.150','closed',8,507,'attendances/1858/1693490757 clock_in.png','attendances/1858/1693521182 clock_out.png','Juan R',38266,NULL,'2023-08-31 11:05:57','2023-09-05 04:28:06'),(1434,'2023-08-31 07:06:01','2023-08-31 15:39:36','12.249.250.150','12.249.250.150','closed',8,513,'attendances/1953/1693490761 clock_in.png','attendances/1953/1693521576 clock_out.png','Juan R',38272,NULL,'2023-08-31 11:06:01','2023-09-01 17:58:11'),(1435,'2023-08-31 07:54:13','2023-08-31 20:20:00','12.249.250.150','','closed',12,745,'attendances/1116/1693493653 clock_in.png',NULL,'Juan R',38268,NULL,'2023-08-31 11:54:13','2023-09-05 04:29:32'),(1436,'2023-08-31 07:58:49','2023-08-31 16:30:25','12.249.250.150','12.249.250.150','closed',8,511,'attendances/775/1693493929 clock_in.png','attendances/775/1693524625 clock_out.png','Juan R',38278,NULL,'2023-08-31 11:58:49','2023-09-05 04:30:24'),(1437,'2023-08-31 08:04:22','2023-08-31 16:35:09','12.249.250.150','12.249.250.150','closed',8,510,'attendances/1869/1693494262 clock_in.png','attendances/1869/1693524909 clock_out.png','Juan R',38277,NULL,'2023-08-31 12:04:22','2023-09-05 04:15:25'),(1438,'2023-08-31 08:04:41','2023-08-31 16:35:22','12.249.250.150','12.249.250.150','closed',8,510,'attendances/1891/1693494281 clock_in.png','attendances/1891/1693524922 clock_out.png','Juan R',38279,NULL,'2023-08-31 12:04:41','2023-09-05 04:31:14'),(1439,'2023-08-31 08:25:28','2023-08-31 16:30:36','12.249.250.150','12.249.250.150','closed',8,485,'attendances/1492/1693495528 clock_in.png','attendances/1492/1693524636 clock_out.png','Juan R',38280,NULL,'2023-08-31 12:25:28','2023-09-05 04:33:27'),(1442,'2023-09-01 05:55:25','2023-09-01 14:31:05','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1551/1693572925 clock_in.png','attendances/1551/1693603865 clock_out.png','Juan R',38281,NULL,'2023-09-01 09:55:25','2023-09-05 04:13:39'),(1443,'2023-09-01 05:55:45','2023-09-01 14:31:33','12.249.250.150','12.249.250.150','closed',8,515,'attendances/2005/1693572945 clock_in.png','attendances/2005/1693603893 clock_out.png','Juan R',38284,NULL,'2023-09-01 09:55:45','2023-09-05 04:28:33'),(1444,'2023-09-01 05:56:05','2023-09-01 14:31:57','12.249.250.150','12.249.250.150','closed',8,515,'attendances/382/1693572965 clock_in.png','attendances/382/1693603917 clock_out.png','Juan R',38282,NULL,'2023-09-01 09:56:05','2023-09-05 04:18:07'),(1445,'2023-09-01 05:58:48','2023-09-01 14:31:20','12.249.250.150','12.249.250.150','closed',8,512,'attendances/1951/1693573128 clock_in.png','attendances/1951/1693603880 clock_out.png','Juan R',38283,NULL,'2023-09-01 09:58:48','2023-09-05 04:17:37'),(1446,'2023-09-01 06:51:30','2023-09-01 15:32:15','12.249.250.150','12.249.250.150','closed',8,520,'attendances/622/1693576290 clock_in.png','attendances/622/1693607535 clock_out.png','Juan R',38300,NULL,'2023-09-01 10:51:30','2023-09-05 04:32:47'),(1447,'2023-09-01 06:51:45','2023-09-01 15:32:05','12.249.250.150','12.249.250.150','closed',8,520,'attendances/1774/1693576305 clock_in.png','attendances/1774/1693607525 clock_out.png','Juan R',38289,NULL,'2023-09-01 10:51:45','2023-09-05 04:18:36'),(1448,'2023-09-01 06:52:22','2023-09-01 15:30:16','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1958/1693576342 clock_in.png','attendances/1958/1693607416 clock_out.png','Juan R',38290,NULL,'2023-09-01 10:52:22','2023-09-05 04:18:58'),(1449,'2023-09-01 06:52:32','2023-09-01 15:33:28','12.249.250.150','12.249.250.150','closed',8,520,'attendances/1999/1693576352 clock_in.png','attendances/1999/1693607608 clock_out.png','Juan R',38291,NULL,'2023-09-01 10:52:32','2023-09-05 04:20:30'),(1450,'2023-09-01 06:53:55','2023-09-01 15:36:23','12.249.250.150','12.249.250.150','closed',8,522,'attendances/1116/1693576435 clock_in.png','attendances/1116/1693607783 clock_out.png','Juan R',38297,NULL,'2023-09-01 10:53:55','2023-09-05 04:29:28'),(1452,'2023-09-01 06:54:21','2023-09-01 15:40:22','12.249.250.150','12.249.250.150','closed',8,526,'attendances/1585/1693576461 clock_in.png','attendances/1585/1693608022 clock_out.png','Juan R',38286,NULL,'2023-09-01 10:54:21','2023-09-05 04:14:00'),(1453,'2023-09-01 06:54:32','2023-09-01 15:39:06','12.249.250.150','12.249.250.150','closed',8,524,'attendances/1588/1693576472 clock_in.png','attendances/1588/1693607946 clock_out.png','Juan R',38288,NULL,'2023-09-01 10:54:32','2023-09-05 04:16:56'),(1454,'2023-09-01 06:54:44','2023-09-01 15:30:56','12.249.250.150','12.249.250.150','closed',8,516,'attendances/2025/1693576484 clock_in.png','attendances/2025/1693607456 clock_out.png','Juan R',38301,NULL,'2023-09-01 10:54:44','2023-09-05 04:33:58'),(1455,'2023-09-01 06:54:47','2023-09-01 15:35:26','12.249.250.150','12.249.250.150','closed',8,520,'attendances/1395/1693576487 clock_in.png','attendances/1395/1693607726 clock_out.png','Juan R',38298,NULL,'2023-09-01 10:54:47','2023-09-05 04:29:50'),(1456,'2023-09-01 06:55:03','2023-09-01 13:32:27','12.249.250.150','12.249.250.150','closed',6,397,'attendances/726/1693576503 clock_in.png','attendances/726/1693600347 clock_out.png','Juan R',38285,NULL,'2023-09-01 10:55:03','2023-09-05 04:13:16'),(1457,'2023-09-01 06:55:08','2023-09-01 15:37:40','12.249.250.150','12.249.250.150','closed',8,522,'attendances/1568/1693576508 clock_in.png','attendances/1568/1693607860 clock_out.png','Juan R',38287,NULL,'2023-09-01 10:55:08','2023-09-05 04:14:21'),(1458,'2023-09-01 06:55:22','2023-09-01 15:31:44','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1934/1693576522 clock_in.png','attendances/1934/1693607504 clock_out.png','Juan R',38293,NULL,'2023-09-01 10:55:22','2023-09-05 04:24:12'),(1459,'2023-09-01 06:55:34','2023-09-01 15:32:01','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1948/1693576534 clock_in.png','attendances/1948/1693607521 clock_out.png','Juan R',38299,NULL,'2023-09-01 10:55:34','2023-09-05 04:31:59'),(1460,'2023-09-01 06:59:28','2023-09-01 15:31:17','12.249.250.150','12.249.250.150','closed',8,511,'attendances/1858/1693576768 clock_in.png','attendances/1858/1693607477 clock_out.png','Juan R',38296,NULL,'2023-09-01 10:59:28','2023-09-05 04:28:02'),(1461,'2023-09-01 07:00:49','2023-09-01 15:43:28','12.249.250.150','12.249.250.150','closed',8,522,'attendances/1728/1693576849 clock_in.png','attendances/1728/1693608208 clock_out.png','Juan R',38295,NULL,'2023-09-01 11:00:49','2023-09-05 04:27:35'),(1462,'2023-09-01 07:01:58','2023-09-01 15:39:27','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1455/1693576918 clock_in.png','attendances/1455/1693607967 clock_out.png','Juan R',38294,NULL,'2023-09-01 11:01:58','2023-09-05 04:27:18'),(1463,'2023-09-01 07:04:50','2023-09-01 15:31:49','12.249.250.150','12.249.250.150','closed',8,506,'attendances/1888/1693577090 clock_in.png','attendances/1888/1693607509 clock_out.png','Juan R',38302,NULL,'2023-09-01 11:04:55','2023-09-05 04:35:35'),(1464,'2023-09-01 07:07:10','2023-09-01 15:32:45','12.249.250.150','12.249.250.150','closed',8,505,'attendances/1462/1693577230 clock_in.png','attendances/1462/1693607565 clock_out.png','Juan R',38292,NULL,'2023-09-01 11:07:11','2023-09-05 04:23:21'),(1465,'2023-09-01 07:56:08','2023-09-01 16:59:12','12.249.250.150','12.249.250.150','closed',9,543,'attendances/974/1693580168 clock_in.png','attendances/974/1693612752 clock_out.png','Juan R',38303,NULL,'2023-09-01 11:56:08','2023-09-05 04:12:18'),(1466,'2023-09-01 07:58:09','2023-09-01 16:30:08','12.249.250.150','12.249.250.150','closed',8,511,'attendances/775/1693580289 clock_in.png','attendances/775/1693611008 clock_out.png','Juan R',38305,NULL,'2023-09-01 11:58:09','2023-09-05 04:30:18'),(1467,'2023-09-01 08:02:11','2023-09-01 16:32:49','12.249.250.150','12.249.250.150','closed',8,510,'attendances/1891/1693580531 clock_in.png','attendances/1891/1693611169 clock_out.png','Juan R',38306,NULL,'2023-09-01 12:02:11','2023-09-05 04:30:56'),(1468,'2023-09-01 08:03:05','2023-09-01 16:33:00','12.249.250.150','12.249.250.150','closed',8,509,'attendances/1869/1693580585 clock_in.png','attendances/1869/1693611180 clock_out.png','Juan R',38304,NULL,'2023-09-01 12:03:05','2023-09-05 04:15:18'),(1469,'2023-09-01 08:26:12','2023-09-01 16:30:36','12.249.250.150','12.249.250.150','closed',8,484,'attendances/1492/1693581972 clock_in.png','attendances/1492/1693611036 clock_out.png','Juan R',38307,NULL,'2023-09-01 12:26:12','2023-09-05 04:33:22'),(1470,'2023-09-01 11:55:32','2023-09-01 16:59:33','12.249.250.150','12.249.250.150','closed',5,304,'attendances/1479/1693594532 clock_in.png','attendances/1479/1693612773 clock_out.png','Juan R',38308,NULL,'2023-09-01 15:55:32','2023-09-05 04:17:16'),(1471,'2023-09-01 11:57:36','2023-09-01 17:00:23','12.249.250.150','12.249.250.150','closed',5,302,'attendances/1450/1693594656 clock_in.png','attendances/1450/1693612823 clock_out.png','Juan R',38309,NULL,'2023-09-01 15:57:36','2023-09-05 04:32:22'),(1474,'2023-09-05 05:53:44','2023-09-05 16:30:34','12.249.250.150','12.249.250.150','closed',10,636,'attendances/726/1693918424 clock_in.png','attendances/726/1693956634 clock_out.png','Juan R',38320,NULL,'2023-09-05 09:53:44','2023-09-12 16:24:00'),(1475,'2023-09-05 05:54:13','2023-09-05 14:49:36','12.249.250.150','12.249.250.150','closed',8,535,'attendances/1585/1693918453 clock_in.png','attendances/1585/1693950576 clock_out.png','Juan R',38322,NULL,'2023-09-05 09:54:13','2023-09-12 16:24:04'),(1476,'2023-09-05 05:54:25','2023-09-05 18:54:03','12.249.250.150','12.249.250.150','closed',12,779,'attendances/2025/1693918465 clock_in.png','attendances/2025/1693965243 clock_out.png','Juan R',38326,NULL,'2023-09-05 09:54:25','2023-09-12 16:25:29'),(1477,'2023-09-05 05:54:38','2023-09-05 18:53:33','12.249.250.150','12.249.250.150','closed',12,778,'attendances/1551/1693918478 clock_in.png','attendances/1551/1693965213 clock_out.png','Juan R',38321,NULL,'2023-09-05 09:54:38','2023-09-12 16:24:00'),(1478,'2023-09-05 05:54:45','2023-09-05 18:38:27','12.249.250.150','12.249.250.150','closed',12,763,'attendances/2005/1693918485 clock_in.png','attendances/2005/1693964307 clock_out.png','Juan R',38324,NULL,'2023-09-05 09:54:45','2023-09-12 16:25:00'),(1479,'2023-09-05 05:59:08','2023-09-05 18:54:22','12.249.250.150','12.249.250.150','closed',12,775,'attendances/1450/1693918748 clock_in.png','attendances/1450/1693965262 clock_out.png','Juan R',38325,NULL,'2023-09-05 09:59:08','2023-09-12 16:25:20'),(1480,'2023-09-05 05:59:28','2023-09-05 18:55:06','12.249.250.150','12.249.250.150','closed',12,775,'attendances/382/1693918768 clock_in.png','attendances/382/1693965306 clock_out.png','Juan R',38323,NULL,'2023-09-05 09:59:28','2023-09-12 16:24:26'),(1481,'2023-09-05 06:19:01','2023-09-05 14:42:02','12.249.250.150','12.249.250.150','closed',8,503,'attendances/1116/1693919941 clock_in.png','attendances/1116/1693950122 clock_out.png','Juan R',38339,NULL,'2023-09-05 10:19:01','2023-09-12 16:25:03'),(1482,'2023-09-05 06:53:00','2023-09-05 15:34:13','12.249.250.150','12.249.250.150','closed',8,521,'attendances/1999/1693921980 clock_in.png','attendances/1999/1693953253 clock_out.png','Juan R',38333,NULL,'2023-09-05 10:53:00','2023-09-12 16:24:35'),(1483,'2023-09-05 06:53:43','2023-09-05 15:37:16','12.249.250.150','12.249.250.150','closed',8,523,'attendances/622/1693922023 clock_in.png','attendances/622/1693953436 clock_out.png','Juan R',38342,NULL,'2023-09-05 10:53:43','2023-09-12 16:25:23'),(1484,'2023-09-05 06:53:47','2023-09-05 15:33:17','12.249.250.150','12.249.250.150','closed',8,519,'attendances/1395/1693922027 clock_in.png','attendances/1395/1693953197 clock_out.png','Juan R',38340,NULL,'2023-09-05 10:53:47','2023-09-12 16:25:07'),(1485,'2023-09-05 06:53:59','2023-09-05 15:30:33','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1774/1693922039 clock_in.png','attendances/1774/1693953033 clock_out.png','Juan R',38331,NULL,'2023-09-05 10:53:59','2023-09-12 16:24:29'),(1486,'2023-09-05 06:55:16','2023-09-05 15:32:00','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1858/1693922116 clock_in.png','attendances/1858/1693953120 clock_out.png','Juan R',38338,NULL,'2023-09-05 10:55:16','2023-09-12 16:24:56'),(1487,'2023-09-05 06:55:29','2023-09-05 15:32:52','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1728/1693922129 clock_in.png','attendances/1728/1693953172 clock_out.png','Juan R',38337,NULL,'2023-09-05 10:55:29','2023-09-12 16:24:53'),(1488,'2023-09-05 06:55:51','2023-09-05 15:32:08','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1479/1693922151 clock_in.png','attendances/1479/1693953128 clock_out.png','Juan R',38329,NULL,'2023-09-05 10:55:51','2023-09-12 16:24:19'),(1489,'2023-09-05 06:55:57','2023-09-05 15:31:16','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1934/1693922157 clock_in.png','attendances/1934/1693953076 clock_out.png','Juan R',38335,NULL,'2023-09-05 10:55:57','2023-09-12 16:24:44'),(1490,'2023-09-05 06:56:05','2023-09-05 15:32:27','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1588/1693922165 clock_in.png','attendances/1588/1693953147 clock_out.png','Juan R',38328,NULL,'2023-09-05 10:56:05','2023-09-12 16:24:16'),(1491,'2023-09-05 06:56:20','2023-09-05 15:32:37','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1568/1693922180 clock_in.png','attendances/1568/1693953157 clock_out.png','Juan R',38327,NULL,'2023-09-05 10:56:20','2023-09-12 16:24:08'),(1492,'2023-09-05 06:57:23','2023-09-05 15:33:31','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1948/1693922243 clock_in.png','attendances/1948/1693953211 clock_out.png','Juan R',38341,NULL,'2023-09-05 10:57:23','2023-09-12 16:25:16'),(1493,'2023-09-05 06:58:38','2023-09-05 15:33:58','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1462/1693922318 clock_in.png','attendances/1462/1693953238 clock_out.png','Juan R',38334,NULL,'2023-09-05 10:58:38','2023-09-12 16:24:39'),(1494,'2023-09-05 07:01:21','2023-09-05 15:31:30','12.249.250.150','12.249.250.150','closed',8,510,'attendances/1958/1693922481 clock_in.png','attendances/1958/1693953090 clock_out.png','Juan R',38332,NULL,'2023-09-05 11:01:21','2023-09-12 16:24:32'),(1495,'2023-09-05 07:02:29','2023-09-05 15:32:36','12.249.250.150','12.249.250.150','closed',8,510,'attendances/1455/1693922549 clock_in.png','attendances/1455/1693953156 clock_out.png','Juan R',38336,NULL,'2023-09-05 11:02:29','2023-09-12 16:24:49'),(1496,'2023-09-05 07:02:32','2023-09-05 15:43:03','12.249.250.150','12.249.250.150','closed',8,520,'attendances/1951/1693922552 clock_in.png','attendances/1951/1693953783 clock_out.png','Juan R',38330,NULL,'2023-09-05 11:02:32','2023-09-12 16:24:23'),(1497,'2023-09-05 07:05:35','2023-09-05 15:33:04','12.249.250.150','12.249.250.150','closed',8,507,'attendances/1888/1693922735 clock_in.png','attendances/1888/1693953184 clock_out.png','Juan R',38343,NULL,'2023-09-05 11:05:35','2023-09-12 16:25:32'),(1498,'2023-09-05 07:56:08','2023-09-05 17:00:57','12.249.250.150','12.249.250.150','closed',9,544,'attendances/974/1693925768 clock_in.png','attendances/974/1693958457 clock_out.png','Juan R',38344,NULL,'2023-09-05 11:56:08','2023-09-12 16:24:00'),(1499,'2023-09-05 07:59:05','2023-09-05 16:30:22','12.249.250.150','12.249.250.150','closed',8,511,'attendances/775/1693925945 clock_in.png','attendances/775/1693956622 clock_out.png','Juan R',38346,NULL,'2023-09-05 11:59:05','2023-09-12 16:25:10'),(1500,'2023-09-05 08:11:54','2023-09-05 16:32:01','12.249.250.150','12.249.250.150','closed',8,500,'attendances/1869/1693926714 clock_in.png','attendances/1869/1693956721 clock_out.png','Juan R',38345,NULL,'2023-09-05 12:11:54','2023-09-12 16:24:12'),(1501,'2023-09-05 08:25:34','2023-09-05 16:30:34','12.249.250.150','12.249.250.150','closed',8,485,'attendances/1492/1693927534 clock_in.png','attendances/1492/1693956634 clock_out.png','Juan R',38348,NULL,'2023-09-05 12:25:34','2023-09-12 16:25:25'),(1502,'2023-09-05 08:15:04','2023-09-05 16:32:14','12.249.250.150','12.249.250.150','closed',8,497,'attendances/1891/1693942391 clock_in.png','attendances/1891/1693956734 clock_out.png','Juan R',38347,NULL,'2023-09-05 16:33:11','2023-09-12 16:25:13'),(1503,'2023-09-06 05:56:46','2023-09-06 17:50:31','12.249.250.150','12.249.250.150','closed',11,713,'attendances/2025/1694005006 clock_in.png','attendances/2025/1694047831 clock_out.png','Juan R',38453,NULL,'2023-09-06 09:56:46','2023-09-12 17:43:01'),(1504,'2023-09-06 06:06:11','2023-09-06 17:53:24','12.249.250.150','12.249.250.150','closed',11,707,'attendances/1450/1694005571 clock_in.png','attendances/1450/1694048004 clock_out.png','Juan R',38452,NULL,'2023-09-06 10:06:11','2023-09-12 17:43:04'),(1505,'2023-09-06 06:42:10','2023-09-06 15:32:11','12.249.250.150','12.249.250.150','closed',8,530,'attendances/1774/1694007730 clock_in.png','attendances/1774/1694039531 clock_out.png','Juan R',38459,NULL,'2023-09-06 10:42:10','2023-09-12 17:36:36'),(1506,'2023-09-06 06:45:52','2023-09-06 15:31:58','12.249.250.150','12.249.250.150','closed',8,526,'attendances/622/1694007952 clock_in.png','attendances/622/1694039518 clock_out.png','Juan R',38469,NULL,'2023-09-06 10:45:52','2023-09-12 17:43:03'),(1507,'2023-09-06 06:55:09','2023-09-06 15:34:10','12.249.250.150','12.249.250.150','closed',8,519,'attendances/1479/1694008509 clock_in.png','attendances/1479/1694039650 clock_out.png','Juan R',38457,NULL,'2023-09-06 10:55:09','2023-09-12 16:56:43'),(1508,'2023-09-06 06:55:21','2023-09-06 16:00:57','12.249.250.150','12.249.250.150','closed',9,545,'attendances/1999/1694008521 clock_in.png','attendances/1999/1694041257 clock_out.png','Juan R',38461,NULL,'2023-09-06 10:55:21','2023-09-12 17:37:02'),(1509,'2023-09-06 06:55:24','2023-09-06 16:52:15','12.249.250.150','12.249.250.150','closed',9,596,'attendances/1588/1694008524 clock_in.png','attendances/1588/1694044335 clock_out.png','Juan R',38456,NULL,'2023-09-06 10:55:24','2023-09-12 16:49:21'),(1510,'2023-09-06 06:55:59','2023-09-06 15:30:50','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1934/1694008559 clock_in.png','attendances/1934/1694039450 clock_out.png','Juan R',38463,NULL,'2023-09-06 10:55:59','2023-09-12 17:37:23'),(1511,'2023-09-06 06:56:30','2023-09-06 15:32:26','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1858/1694008590 clock_in.png','attendances/1858/1694039546 clock_out.png','Juan R',38465,NULL,'2023-09-06 10:56:30','2023-09-12 17:37:50'),(1512,'2023-09-06 06:56:32','2023-09-06 15:40:00','12.249.250.150','12.249.250.150','closed',8,523,'attendances/1948/1694008592 clock_in.png','attendances/1948/1694040000 clock_out.png','Juan R',38468,NULL,'2023-09-06 10:56:32','2023-09-12 17:43:12'),(1513,'2023-09-06 06:56:42','2023-09-06 15:33:35','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1958/1694008602 clock_in.png','attendances/1958/1694023235 clock_out.png','Juan R',38460,NULL,'2023-09-06 10:56:42','2023-09-12 17:36:46'),(1514,'2023-09-06 06:57:03','2023-09-06 16:09:58','12.249.250.150','12.249.250.150','closed',9,552,'attendances/1395/1694008623 clock_in.png','attendances/1395/1694041798 clock_out.png','Juan R',38467,NULL,'2023-09-06 10:57:03','2023-09-12 17:38:39'),(1515,'2023-09-06 06:58:17','2023-09-06 15:31:32','12.249.250.150','12.249.250.150','closed',8,513,'attendances/1951/1694008697 clock_in.png','attendances/1951/1694039492 clock_out.png','Juan R',38458,NULL,'2023-09-06 10:58:17','2023-09-12 17:36:12'),(1516,'2023-09-06 06:59:03','2023-09-06 16:51:07','12.249.250.150','12.249.250.150','closed',9,592,'attendances/1568/1694008743 clock_in.png','attendances/1568/1694044267 clock_out.png','Juan R',38455,NULL,'2023-09-06 10:59:03','2023-09-12 16:37:53'),(1517,'2023-09-06 06:59:40','2023-09-06 15:35:13','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1462/1694008780 clock_in.png','attendances/1462/1694039713 clock_out.png','Juan R',38462,NULL,'2023-09-06 10:59:40','2023-09-12 17:37:12'),(1518,'2023-09-06 06:59:56','2023-09-06 16:25:38','12.249.250.150','12.249.250.150','closed',9,565,'attendances/1728/1694008796 clock_in.png','attendances/1728/1694042738 clock_out.png','Juan R',38464,NULL,'2023-09-06 10:59:56','2023-09-12 17:37:42'),(1519,'2023-09-06 07:04:25','2023-09-06 15:43:15','12.249.250.150','12.249.250.150','closed',8,518,'attendances/1888/1694009065 clock_in.png','attendances/1888/1694040195 clock_out.png','Juan R',38470,NULL,'2023-09-06 11:04:25','2023-09-12 17:43:00'),(1520,'2023-09-06 06:55:45','2023-09-06 16:01:45','12.249.250.150','12.249.250.150','closed',9,546,'attendances/1116/1694009745 clock_in.png','attendances/1116/1694041305 clock_out.png','Juan R',38466,NULL,'2023-09-06 11:15:45','2023-09-12 17:38:26'),(1521,'2023-09-06 06:55:00','2023-09-06 18:39:02','186.154.240.36','12.249.250.150','closed',11,704,NULL,'attendances/726/1694050742 clock_out.png','Juan R',38454,NULL,'2023-09-06 11:20:25','2023-09-12 16:35:33'),(1523,'2023-09-06 07:55:28','2023-09-06 16:57:10','12.249.250.150','12.249.250.150','closed',9,541,'attendances/974/1694012128 clock_in.png','attendances/974/1694044630 clock_out.png','Juan R',38471,NULL,'2023-09-06 11:55:28','2023-09-12 16:35:17'),(1524,'2023-09-06 07:58:23','2023-09-06 16:33:09','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1891/1694012303 clock_in.png','attendances/1891/1694043189 clock_out.png','Juan R',38474,NULL,'2023-09-06 11:58:23','2023-09-12 17:43:25'),(1525,'2023-09-06 07:59:26','2023-09-06 16:30:44','12.249.250.150','12.249.250.150','closed',8,511,'attendances/775/1694012366 clock_in.png','attendances/775/1694043044 clock_out.png','Juan R',38473,NULL,'2023-09-06 11:59:26','2023-09-12 17:43:35'),(1526,'2023-09-06 08:00:02','2023-09-06 16:31:45','12.249.250.150','12.249.250.150','closed',8,511,'attendances/1869/1694012402 clock_in.png','attendances/1869/1694043105 clock_out.png','Juan R',38472,NULL,'2023-09-06 12:00:02','2023-09-12 16:44:50'),(1527,'2023-09-06 08:25:11','2023-09-06 16:32:43','12.249.250.150','12.249.250.150','closed',8,487,'attendances/1492/1694013911 clock_in.png','attendances/1492/1694043163 clock_out.png','Juan R',38475,NULL,'2023-09-06 12:25:11','2023-09-12 17:43:02'),(1528,'2023-09-06 10:53:52','2023-09-06 18:51:55','12.249.250.150','12.249.250.150','closed',7,478,'attendances/1585/1694022832 clock_in.png','attendances/1585/1694051515 clock_out.png','Juan R',38477,NULL,'2023-09-06 14:53:52','2023-09-12 16:35:58'),(1529,'2023-09-06 10:54:11','2023-09-06 18:45:59','12.249.250.150','12.249.250.150','closed',7,471,'attendances/2005/1694022851 clock_in.png','attendances/2005/1694051159 clock_out.png','Juan R',38479,NULL,'2023-09-06 14:54:11','2023-09-12 17:37:58'),(1530,'2023-09-06 10:57:37','2023-09-06 18:47:03','12.249.250.150','12.249.250.150','closed',7,469,'attendances/1551/1694023057 clock_in.png','attendances/1551/1694051223 clock_out.png','Juan R',38476,NULL,'2023-09-06 14:57:37','2023-09-12 16:35:46'),(1531,'2023-09-06 11:01:11','2023-09-06 18:48:09','12.249.250.150','12.249.250.150','closed',7,466,'attendances/382/1694023271 clock_in.png','attendances/382/1694051289 clock_out.png','Juan R',38478,NULL,'2023-09-06 15:01:11','2023-09-12 17:36:24'),(1532,'2023-09-07 05:54:06','2023-09-07 16:27:13','12.249.250.150','12.249.250.150','closed',10,633,'attendances/2005/1694091246 clock_in.png','attendances/2005/1694129233 clock_out.png','Juan R',38488,NULL,'2023-09-07 09:54:06','2023-09-12 17:37:54'),(1533,'2023-09-07 05:54:22','2023-09-07 19:40:09','12.249.250.150','12.249.250.150','closed',13,825,'attendances/2025/1694091262 clock_in.png','attendances/2025/1694140810 clock_out.png','Juan R',38490,NULL,'2023-09-07 09:54:22','2023-09-12 17:43:01'),(1534,'2023-09-07 05:54:38','2023-09-07 16:28:47','12.249.250.150','12.249.250.150','closed',10,634,'attendances/1585/1694091278 clock_in.png','attendances/1585/1694129327 clock_out.png','Juan R',38484,NULL,'2023-09-07 09:54:38','2023-09-12 16:35:54'),(1535,'2023-09-07 05:55:06','2023-09-07 15:30:37','12.249.250.150','12.249.250.150','closed',9,575,'attendances/1588/1694091306 clock_in.png','attendances/1588/1694125837 clock_out.png','Juan R',38486,NULL,'2023-09-07 09:55:06','2023-09-12 16:49:16'),(1536,'2023-09-07 05:55:08','2023-09-07 16:20:05','12.249.250.150','12.249.250.150','closed',10,624,'attendances/382/1694091308 clock_in.png','attendances/382/1694128805 clock_out.png','Juan R',38487,NULL,'2023-09-07 09:55:08','2023-09-12 17:36:19'),(1537,'2023-09-07 05:55:27','2023-09-07 16:38:04','12.249.250.150','12.249.250.150','closed',10,642,'attendances/1551/1694091327 clock_in.png','attendances/1551/1694129884 clock_out.png','Juan R',38483,NULL,'2023-09-07 09:55:27','2023-09-12 16:35:41'),(1538,'2023-09-07 05:56:23','2023-09-07 15:31:02','12.249.250.150','12.249.250.150','closed',9,574,'attendances/1568/1694091383 clock_in.png','attendances/1568/1694125862 clock_out.png','Juan R',38485,NULL,'2023-09-07 09:56:23','2023-09-12 16:37:48'),(1539,'2023-09-07 05:58:30','2023-09-07 19:40:43','12.249.250.150','12.249.250.150','closed',13,822,'attendances/1450/1694091510 clock_in.png','attendances/1450/1694140843 clock_out.png','Juan R',38489,NULL,'2023-09-07 09:58:30','2023-09-12 17:43:03'),(1540,'2023-09-07 06:33:19','2023-09-07 15:31:06','12.249.250.150','12.249.250.150','closed',8,537,'attendances/622/1694093599 clock_in.png','attendances/622/1694125866 clock_out.png','Juan R',38505,NULL,'2023-09-07 10:33:19','2023-09-12 17:43:03'),(1541,'2023-09-07 06:53:29','2023-09-07 20:17:59','12.249.250.150','12.249.250.150','closed',13,804,'attendances/1999/1694094809 clock_in.png','attendances/1999/1694143079 clock_out.png','Juan R',38496,NULL,'2023-09-07 10:53:29','2023-09-12 17:36:58'),(1543,'2023-09-07 06:53:55','2023-09-07 20:17:47','12.249.250.150','12.249.250.150','closed',13,803,'attendances/1395/1694094835 clock_in.png','attendances/1395/1694143067 clock_out.png','Juan R',38503,NULL,'2023-09-07 10:53:55','2023-09-12 17:38:33'),(1544,'2023-09-07 06:54:10','2023-09-07 15:39:41','12.249.250.150','12.249.250.150','closed',8,525,'attendances/1948/1694094850 clock_in.png','attendances/1948/1694126381 clock_out.png','Juan R',38504,NULL,'2023-09-07 10:54:10','2023-09-12 17:43:17'),(1545,'2023-09-07 06:54:24','2023-09-07 20:12:21','12.249.250.150','12.249.250.150','closed',13,797,'attendances/1116/1694094864 clock_in.png','attendances/1116/1694142741 clock_out.png','Juan R',38502,NULL,'2023-09-07 10:54:24','2023-09-12 17:38:19'),(1546,'2023-09-07 06:54:39','2023-09-07 15:32:47','12.249.250.150','12.249.250.150','closed',8,518,'attendances/1858/1694094879 clock_in.png','attendances/1858/1694125967 clock_out.png','Juan R',38501,NULL,'2023-09-07 10:54:39','2023-09-12 17:37:45'),(1547,'2023-09-07 06:54:48','2023-09-07 16:33:13','12.249.250.150','12.249.250.150','closed',9,578,'attendances/1479/1694094888 clock_in.png','attendances/1479/1694129593 clock_out.png','Juan R',38492,NULL,'2023-09-07 10:54:48','2023-09-12 16:56:38'),(1548,'2023-09-07 06:55:12','2023-09-07 15:31:42','12.249.250.150','12.249.250.150','closed',8,516,'attendances/726/1694094912 clock_in.png','attendances/726/1694125902 clock_out.png','Juan R',38491,NULL,'2023-09-07 10:55:12','2023-09-12 16:35:29'),(1549,'2023-09-07 06:55:13','2023-09-07 15:31:25','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1934/1694094913 clock_in.png','attendances/1934/1694125885 clock_out.png','Juan R',38498,NULL,'2023-09-07 10:55:13','2023-09-12 17:37:18'),(1550,'2023-09-07 06:55:26','2023-09-07 15:30:50','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1774/1694094926 clock_in.png','attendances/1774/1694125850 clock_out.png','Juan R',38494,NULL,'2023-09-07 10:55:26','2023-09-12 17:36:31'),(1551,'2023-09-07 06:58:37','2023-09-07 15:33:06','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1958/1694095117 clock_in.png','attendances/1958/1694125986 clock_out.png','Juan R',38495,NULL,'2023-09-07 10:58:37','2023-09-12 17:36:41'),(1552,'2023-09-07 07:00:24','2023-09-07 16:51:44','12.249.250.150','12.249.250.150','closed',9,591,'attendances/1951/1694095224 clock_in.png','attendances/1951/1694130704 clock_out.png','Juan R',38493,NULL,'2023-09-07 11:00:24','2023-09-12 17:36:08'),(1553,'2023-09-07 07:00:36','2023-09-07 15:45:25','12.249.250.150','12.249.250.150','closed',8,524,'attendances/1462/1694095236 clock_in.png','attendances/1462/1694126725 clock_out.png','Juan R',38497,NULL,'2023-09-07 11:00:36','2023-09-12 17:37:07'),(1554,'2023-09-07 07:00:45','2023-09-07 18:35:13','12.249.250.150','12.249.250.150','closed',11,694,'attendances/1455/1694095245 clock_in.png','attendances/1455/1694136913 clock_out.png','Juan R',38499,NULL,'2023-09-07 11:00:45','2023-09-12 17:37:31'),(1555,'2023-09-07 07:02:54','2023-09-07 15:38:24','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1888/1694095374 clock_in.png','attendances/1888/1694126304 clock_out.png','Juan R',38506,NULL,'2023-09-07 11:02:54','2023-09-12 17:42:56'),(1556,'2023-09-07 07:57:45','2023-09-07 17:01:44','12.249.250.150','12.249.250.150','closed',9,543,'attendances/974/1694098665 clock_in.png','attendances/974/1694131304 clock_out.png','Juan R',38507,NULL,'2023-09-07 11:57:45','2023-09-12 16:35:12'),(1557,'2023-09-07 07:59:26','2023-09-07 16:30:24','12.249.250.150','12.249.250.150','closed',8,510,'attendances/775/1694098766 clock_in.png','attendances/775/1694129424 clock_out.png','Juan R',38509,NULL,'2023-09-07 11:59:26','2023-09-12 17:43:39'),(1558,'2023-09-07 08:01:43','2023-09-07 16:33:30','12.249.250.150','12.249.250.150','closed',8,511,'attendances/1891/1694098903 clock_in.png','attendances/1891/1694129610 clock_out.png','Juan R',38510,NULL,'2023-09-07 12:01:43','2023-09-12 17:43:31'),(1559,'2023-09-07 08:03:49','2023-09-07 16:33:20','12.249.250.150','12.249.250.150','closed',8,509,'attendances/1869/1694099029 clock_in.png','attendances/1869/1694129600 clock_out.png','Juan R',38508,NULL,'2023-09-07 12:03:49','2023-09-12 16:44:45'),(1560,'2023-09-07 08:25:10','2023-09-07 16:31:08','12.249.250.150','12.249.250.150','closed',8,485,'attendances/1492/1694100310 clock_in.png','attendances/1492/1694129468 clock_out.png','Juan R',38511,NULL,'2023-09-07 12:25:10','2023-09-12 17:43:03'),(1561,'2023-09-08 05:52:43','2023-09-08 17:22:16','12.249.250.150','12.249.250.150','closed',11,689,'attendances/1999/1694177563 clock_in.png','attendances/1999/1694218936 clock_out.png','Juan R',38585,NULL,'2023-09-08 09:52:43','2023-09-12 17:36:53'),(1562,'2023-09-08 05:54:57','2023-09-08 17:07:49','12.249.250.150','12.249.250.150','closed',11,672,'attendances/1395/1694177697 clock_in.png','attendances/1395/1694218069 clock_out.png','Juan R',38592,NULL,'2023-09-08 09:54:57','2023-09-12 17:38:29'),(1563,'2023-09-08 05:56:17','2023-09-08 20:01:39','12.249.250.150','12.249.250.150','closed',14,845,'attendances/1116/1694177777 clock_in.png','attendances/1116/1694228499 clock_out.png','Juan R',38576,NULL,'2023-09-08 09:56:17','2023-09-12 17:38:16'),(1564,'2023-09-08 05:58:30','2023-09-08 17:40:04','12.249.250.150','12.249.250.150','closed',11,701,'attendances/1588/1694177910 clock_in.png','attendances/1588/1694220004 clock_out.png','Juan R',38575,NULL,'2023-09-08 09:58:30','2023-09-12 16:44:55'),(1565,'2023-09-08 05:59:18','2023-09-08 16:00:24','12.249.250.150','12.249.250.150','closed',10,601,'attendances/1568/1694177958 clock_in.png','attendances/1568/1694214025 clock_out.png','Juan R',38574,NULL,'2023-09-08 09:59:18','2023-09-12 16:37:43'),(1566,'2023-09-08 06:00:40','2023-09-08 17:23:00','12.249.250.150','12.249.250.150','closed',11,682,'attendances/1728/1694178040 clock_in.png','attendances/1728/1694218980 clock_out.png','Juan R',38589,NULL,'2023-09-08 10:00:40','2023-09-12 17:37:34'),(1567,'2023-09-08 06:39:38','2023-09-08 15:48:33','12.249.250.150','12.249.250.150','closed',9,548,'attendances/622/1694180378 clock_in.png','attendances/622/1694213313 clock_out.png','Juan R',38595,NULL,'2023-09-08 10:39:38','2023-09-12 17:43:04'),(1568,'2023-09-08 06:53:03','2023-09-08 15:38:06','12.249.250.150','12.249.250.150','closed',8,525,'attendances/726/1694181183 clock_in.png','attendances/726/1694212686 clock_out.png','Juan R',38577,NULL,'2023-09-08 10:53:03','2023-09-12 16:35:22'),(1569,'2023-09-08 06:54:23','2023-09-08 19:50:38','12.249.250.150','12.249.250.150','closed',12,776,'attendances/1585/1694181263 clock_in.png','attendances/1585/1694227838 clock_out.png','Juan R',38579,NULL,'2023-09-08 10:54:23','2023-09-12 16:35:50'),(1570,'2023-09-08 06:54:34','2023-09-08 20:25:21','12.249.250.150','12.249.250.150','closed',13,810,'attendances/1479/1694181274 clock_in.png','attendances/1479/1694229921 clock_out.png','Juan R',38580,NULL,'2023-09-08 10:54:34','2023-09-12 16:56:34'),(1571,'2023-09-08 06:55:06','2023-09-08 19:50:24','12.249.250.150','12.249.250.150','closed',12,775,'attendances/382/1694181306 clock_in.png','attendances/382/1694227824 clock_out.png','Juan R',38581,NULL,'2023-09-08 10:55:06','2023-09-12 17:36:15'),(1572,'2023-09-08 06:55:24','2023-09-08 17:48:05','12.249.250.150','12.249.250.150','closed',10,652,'attendances/2005/1694181324 clock_in.png','attendances/2005/1694220485 clock_out.png','Juan R',38591,NULL,'2023-09-08 10:55:24','2023-09-12 16:15:25'),(1573,'2023-09-08 06:55:35','2023-09-08 15:48:21','12.249.250.150','12.249.250.150','closed',8,532,'attendances/1774/1694181335 clock_in.png','attendances/1774/1694213301 clock_out.png','Juan R',38583,NULL,'2023-09-08 10:55:35','2023-09-12 16:14:09'),(1574,'2023-09-08 06:55:46','2023-09-08 19:49:59','12.249.250.150','12.249.250.150','closed',12,774,'attendances/1551/1694181346 clock_in.png','attendances/1551/1694227799 clock_out.png','Juan R',38578,NULL,'2023-09-08 10:55:46','2023-09-12 16:35:37'),(1575,'2023-09-08 06:55:51','2023-09-08 17:52:07','12.249.250.150','12.249.250.150','closed',10,656,'attendances/2025/1694181351 clock_in.png','attendances/2025/1694220727 clock_out.png','Juan R',38596,NULL,'2023-09-08 10:55:51','2023-09-12 16:17:30'),(1576,'2023-09-08 06:56:06','2023-09-08 17:03:00','12.249.250.150','','closed',10,606,'attendances/1934/1694181366 clock_in.png',NULL,'Juan R',38587,NULL,'2023-09-08 10:56:06','2023-09-12 17:37:15'),(1577,'2023-09-08 06:56:23','2023-09-08 15:47:00','12.249.250.150','','closed',8,530,'attendances/1951/1694181383 clock_in.png',NULL,'Juan R',38582,NULL,'2023-09-08 10:56:23','2023-09-12 17:36:04'),(1578,'2023-09-08 06:56:53','2023-09-08 15:46:43','12.249.250.150','12.249.250.150','closed',8,529,'attendances/1948/1694181413 clock_in.png','attendances/1948/1694213203 clock_out.png','Juan R',38593,NULL,'2023-09-08 10:56:53','2023-09-12 17:43:21'),(1579,'2023-09-08 06:58:29','2023-09-08 15:38:54','12.249.250.150','12.249.250.150','closed',8,520,'attendances/1958/1694181509 clock_in.png','attendances/1958/1694212734 clock_out.png','Juan R',38584,NULL,'2023-09-08 10:58:29','2023-09-12 16:14:15'),(1580,'2023-09-08 06:59:45','2023-09-08 19:48:45','12.249.250.150','12.249.250.150','closed',12,769,'attendances/1455/1694181585 clock_in.png','attendances/1455/1694227725 clock_out.png','Juan R',38588,NULL,'2023-09-08 10:59:45','2023-09-12 17:37:26'),(1581,'2023-09-08 07:01:52','2023-09-08 17:55:15','12.249.250.150','12.249.250.150','closed',10,653,'attendances/1450/1694181712 clock_in.png','attendances/1450/1694220915 clock_out.png','Juan R',38594,NULL,'2023-09-08 11:01:52','2023-09-12 17:43:04'),(1582,'2023-09-08 07:04:07','2023-09-08 15:38:00','12.249.250.150','','closed',8,513,'attendances/1462/1694181847 clock_in.png',NULL,'Juan R',38586,NULL,'2023-09-08 11:04:07','2023-09-12 16:14:26'),(1583,'2023-09-08 07:04:20','2023-09-08 15:42:48','12.249.250.150','12.249.250.150','closed',8,518,'attendances/1888/1694181860 clock_in.png','attendances/1888/1694212968 clock_out.png','Juan R',38597,NULL,'2023-09-08 11:04:20','2023-09-12 16:17:34'),(1584,'2023-09-08 07:04:40','2023-09-08 15:39:07','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1858/1694181880 clock_in.png','attendances/1858/1694212747 clock_out.png','Juan R',38590,NULL,'2023-09-08 11:04:40','2023-09-12 16:15:19'),(1585,'2023-09-08 07:56:21','2023-09-08 16:33:48','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1891/1694184981 clock_in.png','attendances/1891/1694216028 clock_out.png','Juan R',38601,NULL,'2023-09-08 11:56:21','2023-09-12 16:17:06'),(1586,'2023-09-08 07:57:31','2023-09-08 17:04:30','12.249.250.150','12.249.250.150','closed',9,546,'attendances/974/1694185051 clock_in.png','attendances/974/1694217870 clock_out.png','Juan R',38598,NULL,'2023-09-08 11:57:31','2023-09-12 16:35:12'),(1587,'2023-09-08 07:58:29','2023-09-08 16:33:40','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1869/1694185109 clock_in.png','attendances/1869/1694216020 clock_out.png','Juan R',38599,NULL,'2023-09-08 11:58:29','2023-09-12 16:13:08'),(1588,'2023-09-08 07:59:03','2023-09-08 16:30:06','12.249.250.150','12.249.250.150','closed',8,511,'attendances/775/1694185143 clock_in.png','attendances/775/1694215806 clock_out.png','Juan R',38600,NULL,'2023-09-08 11:59:03','2023-09-12 16:16:58'),(1589,'2023-09-08 08:25:07','2023-09-08 16:31:14','12.249.250.150','12.249.250.150','closed',8,486,'attendances/1492/1694186707 clock_in.png','attendances/1492/1694215874 clock_out.png','Juan R',38602,NULL,'2023-09-08 12:25:07','2023-09-12 16:17:25'),(1591,'2023-09-09 05:26:29','2023-09-09 21:50:54','12.249.250.150','12.249.250.150','closed',16,984,'attendances/1479/1694262389 clock_in.png','attendances/1479/1694321454 clock_out.png','Juan R',38614,NULL,'2023-09-09 09:26:29','2023-09-12 16:13:24'),(1592,'2023-09-09 05:26:57','2023-09-09 14:12:51','12.249.250.150','12.249.250.150','closed',8,525,'attendances/622/1694262417 clock_in.png','attendances/622/1694293971 clock_out.png','Juan R',38622,NULL,'2023-09-09 09:26:57','2023-09-12 16:17:21'),(1593,'2023-09-09 05:27:11','2023-09-09 14:55:24','12.249.250.150','12.249.250.150','closed',9,568,'attendances/1774/1694262431 clock_in.png','attendances/1774/1694296524 clock_out.png','Juan R',38618,NULL,'2023-09-09 09:27:11','2023-09-12 16:13:44'),(1594,'2023-09-09 05:27:27','2023-09-09 14:55:04','12.249.250.150','12.249.250.150','closed',9,567,'attendances/1951/1694262447 clock_in.png','attendances/1951/1694296504 clock_out.png','Juan R',38643,NULL,'2023-09-09 09:27:27','2023-09-12 16:13:30'),(1595,'2023-09-09 05:52:20','2023-09-09 14:26:36','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1395/1694263940 clock_in.png','attendances/1395/1694294796 clock_out.png','Juan R',38621,NULL,'2023-09-09 09:52:20','2023-09-12 16:16:44'),(1596,'2023-09-09 05:52:42','2023-09-09 14:24:24','12.249.250.150','12.249.250.150','closed',8,511,'attendances/974/1694263962 clock_in.png','attendances/974/1694294664 clock_out.png','Juan R',38615,NULL,'2023-09-09 09:52:42','2023-09-12 16:11:36'),(1598,'2023-09-09 05:53:30','2023-09-09 14:23:50','12.249.250.150','12.249.250.150','closed',8,510,'attendances/1999/1694264010 clock_in.png','attendances/1999/1694294630 clock_out.png','Juan R',38644,NULL,'2023-09-09 09:53:30','2023-09-12 16:14:21'),(1599,'2023-09-09 05:55:37','2023-09-09 15:26:55','12.249.250.150','12.249.250.150','closed',9,571,'attendances/1116/1694264137 clock_in.png','attendances/1116/1694264155 clock_out.png','Juan R',38623,NULL,'2023-09-09 09:55:37','2023-09-12 17:38:12'),(1600,'2023-09-09 05:56:43','2023-09-09 12:31:02','12.249.250.150','12.249.250.150','closed',6,394,'attendances/1934/1694264203 clock_in.png','attendances/1934/1694287862 clock_out.png','Juan R',38619,NULL,'2023-09-09 09:56:43','2023-09-12 16:14:32'),(1601,'2023-09-09 05:56:55','2023-09-09 14:23:14','12.249.250.150','12.249.250.150','closed',8,506,'attendances/1728/1694264215 clock_in.png','attendances/1728/1694294594 clock_out.png','Juan R',38620,NULL,'2023-09-09 09:56:55','2023-09-12 16:15:13'),(1602,'2023-09-09 05:58:00','2023-09-09 14:33:43','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1948/1694264280 clock_in.png','attendances/1948/1694295223 clock_out.png','Juan R',38657,NULL,'2023-09-09 09:58:03','2023-09-12 16:17:10'),(1603,'2023-09-09 06:00:45','2023-09-09 15:02:45','12.249.250.150','12.249.250.150','closed',9,542,'attendances/1568/1694264445 clock_in.png','attendances/1568/1694296965 clock_out.png','Juan R',38616,NULL,'2023-09-09 10:00:45','2023-09-12 16:12:54'),(1604,'2023-09-09 06:01:00','2023-09-09 15:00:11','12.249.250.150','12.249.250.150','closed',8,539,'attendances/1588/1694264460 clock_in.png','attendances/1588/1694296811 clock_out.png','Juan R',38617,NULL,'2023-09-09 10:01:00','2023-09-12 16:13:15'),(1605,'2023-09-09 07:04:43','2023-09-09 17:04:22','12.249.250.150','12.249.250.150','closed',9,599,'attendances/1455/1694268283 clock_in.png','attendances/1455/1694304262 clock_out.png','Juan R',38625,NULL,'2023-09-09 11:04:43','2023-09-12 16:15:08'),(1606,'2023-09-09 07:25:13','2023-09-09 16:51:31','12.249.250.150','12.249.250.150','closed',9,566,'attendances/726/1694269513 clock_in.png','attendances/726/1694303491 clock_out.png','Juan R',38624,NULL,'2023-09-09 11:25:13','2023-09-12 16:12:02'),(1607,'2023-09-09 09:53:25','2023-09-09 21:59:24','12.249.250.150','12.249.250.150','closed',12,725,'attendances/1450/1694278405 clock_in.png','attendances/1450/1694321964 clock_out.png','Juan R',38626,NULL,'2023-09-09 13:53:25','2023-09-12 16:17:16'),(1609,'2023-09-09 21:50:22','2023-09-09 23:59:00','12.249.250.150','','closed',2,128,'attendances/1116/1694321422 clock_in.png',NULL,'Juan R',38686,NULL,'2023-09-10 01:50:22','2023-09-12 17:38:02'),(1611,'2023-09-10 05:52:10','2023-09-10 17:30:00','12.249.250.150','','closed',11,697,'attendances/1585/1694350330 clock_in.png',NULL,'Juan R',38629,NULL,'2023-09-10 09:52:10','2023-09-12 16:12:49'),(1612,'2023-09-10 05:53:56','2023-09-10 17:30:00','12.249.250.150','','closed',11,696,'attendances/382/1694350436 clock_in.png',NULL,'Juan R',38630,NULL,'2023-09-10 09:53:56','2023-09-12 16:13:37'),(1613,'2023-09-10 05:54:11','2023-09-10 17:30:00','12.249.250.150','','closed',11,695,'attendances/1551/1694350451 clock_in.png',NULL,'Juan R',38628,NULL,'2023-09-10 09:54:11','2023-09-12 16:12:26'),(1614,'2023-09-11 04:55:05','2023-09-11 16:24:32','12.249.250.150','12.249.250.150','closed',11,689,'attendances/1116/1694433305 clock_in.png','attendances/1116/1694474672 clock_out.png','Juan R',38663,NULL,'2023-09-11 08:55:05','2023-09-18 14:27:35'),(1615,'2023-09-11 04:55:24','2023-09-11 15:42:35','12.249.250.150','12.249.250.150','closed',10,647,'attendances/1588/1694433324 clock_in.png','attendances/1588/1694472155 clock_out.png','Juan R',38662,NULL,'2023-09-11 08:55:24','2023-09-18 14:19:06'),(1616,'2023-09-11 04:55:38','2023-09-11 15:32:18','12.249.250.150','12.249.250.150','closed',10,636,'attendances/1568/1694433338 clock_in.png','attendances/1568/1694471538 clock_out.png','Juan R',38661,NULL,'2023-09-11 08:55:38','2023-09-18 14:06:53'),(1617,'2023-09-11 04:56:38','2023-09-11 15:33:37','12.249.250.150','12.249.250.150','closed',10,636,'attendances/2025/1694433398 clock_in.png','attendances/2025/1694471617 clock_out.png','Juan R',38665,NULL,'2023-09-11 08:56:38','2023-09-18 14:29:44'),(1618,'2023-09-11 05:00:00','2023-09-11 15:59:06','12.249.250.150','12.249.250.150','closed',10,659,'attendances/1450/1694433600 clock_in.png','attendances/1450/1694473146 clock_out.png','Juan R',38664,NULL,'2023-09-11 09:00:00','2023-09-18 14:29:01'),(1619,'2023-09-11 05:52:49','2023-09-11 15:31:39','12.249.250.150','12.249.250.150','closed',9,578,'attendances/726/1694436769 clock_in.png','attendances/726/1694471499 clock_out.png','Juan R',38684,NULL,'2023-09-11 09:52:49','2023-09-18 13:46:19'),(1620,'2023-09-11 05:58:28','2023-09-11 19:27:00','12.249.250.150','','closed',13,808,'attendances/2005/1694437108 clock_in.png',NULL,'Juan R',38667,NULL,'2023-09-11 09:58:28','2023-09-18 14:27:32'),(1621,'2023-09-11 06:00:45','2023-09-11 16:08:05','12.249.250.150','12.249.250.150','closed',10,607,'attendances/1951/1694437245 clock_in.png','attendances/1951/1694473685 clock_out.png','Juan R',38666,NULL,'2023-09-11 10:00:45','2023-09-18 14:19:20'),(1622,'2023-09-11 06:42:27','2023-09-11 15:32:05','12.249.250.150','12.249.250.150','closed',8,529,'attendances/622/1694439747 clock_in.png','attendances/622/1694471525 clock_out.png','Juan R',38677,NULL,'2023-09-11 10:42:27','2023-09-18 14:29:11'),(1623,'2023-09-11 06:50:30','2023-09-11 16:22:06','12.249.250.150','12.249.250.150','closed',9,571,'attendances/1999/1694440230 clock_in.png','attendances/1999/1694474526 clock_out.png','Juan R',38670,NULL,'2023-09-11 10:50:30','2023-09-18 14:19:58'),(1624,'2023-09-10 00:00:00','2023-09-10 00:35:00','181.234.37.96','181.234.37.96','closed',0,35,NULL,NULL,'Juan R',38718,NULL,'2023-09-11 10:53:28','2023-09-12 16:16:37'),(1625,'2023-09-11 06:53:34','2023-09-11 16:25:21','12.249.250.150','12.249.250.150','closed',9,571,'attendances/1395/1694440414 clock_in.png','attendances/1395/1694474721 clock_out.png','Juan R',38675,NULL,'2023-09-11 10:53:34','2023-09-18 14:28:01'),(1626,'2023-09-11 06:54:00','2023-09-11 16:01:19','12.249.250.150','12.249.250.150','closed',9,547,'attendances/1479/1694440440 clock_in.png','attendances/1479/1694473279 clock_out.png','Juan R',38668,NULL,'2023-09-11 10:54:00','2023-09-18 14:19:16'),(1627,'2023-09-11 06:55:56','2023-09-11 15:30:40','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1774/1694440556 clock_in.png','attendances/1774/1694455240 clock_out.png','Juan R',38669,NULL,'2023-09-11 10:55:56','2023-09-18 14:19:30'),(1628,'2023-09-11 06:56:08','2023-09-11 15:31:49','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1934/1694440568 clock_in.png','attendances/1934/1694471509 clock_out.png','Juan R',38671,NULL,'2023-09-11 10:56:08','2023-09-18 14:25:57'),(1629,'2023-09-11 06:56:32','2023-09-11 15:30:43','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1858/1694440592 clock_in.png','attendances/1858/1694471443 clock_out.png','Juan R',38674,NULL,'2023-09-11 10:56:32','2023-09-18 14:27:00'),(1630,'2023-09-11 06:57:46','2023-09-11 15:39:25','12.249.250.150','12.249.250.150','closed',8,521,'attendances/1948/1694440666 clock_in.png','attendances/1948/1694471966 clock_out.png','Juan R',38676,NULL,'2023-09-11 10:57:46','2023-09-18 14:28:38'),(1631,'2023-09-11 06:58:58','2023-09-11 16:26:48','12.249.250.150','12.249.250.150','closed',9,567,'attendances/1728/1694440738 clock_in.png','attendances/1728/1694474808 clock_out.png','Juan R',38673,NULL,'2023-09-11 10:58:58','2023-09-18 14:26:53'),(1632,'2023-09-11 07:02:36','2023-09-11 20:19:56','12.249.250.150','12.249.250.150','closed',13,797,'attendances/1455/1694440956 clock_in.png','attendances/1455/1694488796 clock_out.png','Juan R',38672,NULL,'2023-09-11 11:02:36','2023-09-18 14:26:50'),(1633,'2023-09-11 07:02:58','2023-09-11 15:39:13','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1888/1694440978 clock_in.png','attendances/1888/1694471953 clock_out.png','Juan R',38678,NULL,'2023-09-11 11:02:58','2023-09-18 14:30:24'),(1634,'2023-09-11 07:35:29','2023-09-11 16:22:19','12.249.250.150','12.249.250.150','closed',8,526,'attendances/974/1694442929 clock_in.png','attendances/974/1694474539 clock_out.png','Juan R',38679,NULL,'2023-09-11 11:35:29','2023-09-18 13:46:12'),(1635,'2023-09-11 07:57:57','2023-09-11 16:31:02','12.249.250.150','12.249.250.150','closed',8,513,'attendances/775/1694444277 clock_in.png','attendances/775/1694475062 clock_out.png','Juan R',38682,NULL,'2023-09-11 11:57:57','2023-09-18 14:28:11'),(1636,'2023-09-11 07:59:31','2023-09-11 16:33:09','12.249.250.150','12.249.250.150','closed',8,513,'attendances/1891/1694444371 clock_in.png','attendances/1891/1694475189 clock_out.png','Juan R',38683,NULL,'2023-09-11 11:59:31','2023-09-18 14:28:34'),(1637,'2023-09-11 08:02:36','2023-09-11 15:43:37','12.249.250.150','12.249.250.150','closed',7,461,'attendances/1462/1694444556 clock_in.png','attendances/1462/1694472217 clock_out.png','Juan R',38681,NULL,'2023-09-11 12:02:36','2023-09-18 14:20:19'),(1638,'2023-09-11 06:00:00','2023-09-11 16:30:00','181.234.37.96','','closed',10,630,NULL,NULL,'Juan R',38645,NULL,'2023-09-11 15:18:33','2023-09-18 13:47:26'),(1639,'2023-09-11 06:00:00','2023-09-11 16:30:00','181.234.37.96','','closed',10,630,NULL,NULL,'Juan R',38646,NULL,'2023-09-11 15:18:57','2023-09-18 13:47:50'),(1640,'2023-09-11 06:00:00','2023-09-11 16:30:00','181.234.37.96','','closed',10,630,NULL,NULL,'Juan R',38647,NULL,'2023-09-11 15:19:13','2023-09-18 14:19:25'),(1641,'2023-09-07 06:53:00','2023-09-07 20:18:00','186.154.240.36','','closed',13,805,NULL,NULL,'Juan R',38500,NULL,'2023-09-11 21:34:30','2023-09-12 17:37:37'),(1642,'2023-09-12 05:55:07','2023-09-12 19:38:16','12.249.250.150','12.249.250.150','closed',13,823,'attendances/2025/1694523307 clock_in.png','attendances/2025/1694572696 clock_out.png','Juan R',38728,NULL,'2023-09-12 09:55:07','2023-09-18 14:29:44'),(1643,'2023-09-12 05:55:24','2023-09-12 19:11:45','12.249.250.150','12.249.250.150','closed',13,796,'attendances/1116/1694523324 clock_in.png','attendances/1116/1694571105 clock_out.png','Juan R',38727,NULL,'2023-09-12 09:55:24','2023-09-18 14:27:35'),(1644,'2023-09-12 05:56:16','2023-09-12 16:30:13','12.249.250.150','12.249.250.150','closed',10,633,'attendances/1588/1694523376 clock_in.png','attendances/1588/1694561413 clock_out.png','Juan R',38724,NULL,'2023-09-12 09:56:16','2023-09-18 14:19:06'),(1645,'2023-09-12 05:56:18','2023-09-12 16:00:46','12.249.250.150','12.249.250.150','closed',10,604,'attendances/1568/1694523378 clock_in.png','attendances/1568/1694559646 clock_out.png','Juan R',38723,NULL,'2023-09-12 09:56:18','2023-09-18 14:06:53'),(1646,'2023-09-12 05:58:37','2023-09-12 19:40:00','12.249.250.150','','closed',13,821,'attendances/2005/1694523517 clock_in.png',NULL,'Juan R',38726,NULL,'2023-09-12 09:58:37','2023-09-18 14:27:32'),(1647,'2023-09-12 06:01:00','2023-09-12 15:36:20','12.249.250.150','12.249.250.150','closed',9,575,'attendances/1951/1694523660 clock_in.png','attendances/1951/1694558180 clock_out.png','Juan R',38731,NULL,'2023-09-12 10:01:00','2023-09-18 14:19:20'),(1648,'2023-09-12 06:01:24','2023-09-12 19:53:12','12.249.250.150','12.249.250.150','closed',13,831,'attendances/1455/1694523684 clock_in.png','attendances/1455/1694573592 clock_out.png','Juan R',38725,NULL,'2023-09-12 10:01:24','2023-09-18 14:26:50'),(1649,'2023-09-12 06:39:14','2023-09-12 15:32:40','12.249.250.150','12.249.250.150','closed',8,533,'attendances/622/1694525954 clock_in.png','attendances/622/1694557960 clock_out.png','Juan R',38742,NULL,'2023-09-12 10:39:14','2023-09-18 14:29:11'),(1650,'2023-09-12 06:52:50','2023-09-12 15:32:52','12.249.250.150','12.249.250.150','closed',8,520,'attendances/1774/1694526770 clock_in.png','attendances/1774/1694557972 clock_out.png','Juan R',38732,NULL,'2023-09-12 10:52:50','2023-09-18 14:19:30'),(1651,'2023-09-12 06:53:38','2023-09-12 15:56:23','12.249.250.150','12.249.250.150','closed',9,542,'attendances/726/1694526818 clock_in.png','attendances/726/1694559383 clock_out.png','Juan R',38729,NULL,'2023-09-12 10:53:38','2023-09-18 13:46:19'),(1652,'2023-09-12 06:53:56','2023-09-12 16:32:16','12.249.250.150','12.249.250.150','closed',9,578,'attendances/1395/1694526836 clock_in.png','attendances/1395/1694561536 clock_out.png','Juan R',38739,NULL,'2023-09-12 10:53:56','2023-09-18 14:28:01'),(1653,'2023-09-12 06:54:23','2023-09-12 16:29:47','12.249.250.150','12.249.250.150','closed',9,575,'attendances/1479/1694526863 clock_in.png','attendances/1479/1694561387 clock_out.png','Juan R',38730,NULL,'2023-09-12 10:54:23','2023-09-18 14:19:16'),(1654,'2023-09-12 06:54:41','2023-09-12 16:41:09','12.249.250.150','12.249.250.150','closed',9,586,'attendances/1999/1694526881 clock_in.png','attendances/1999/1694562069 clock_out.png','Juan R',38734,NULL,'2023-09-12 10:54:41','2023-09-18 14:19:58'),(1655,'2023-09-12 06:55:06','2023-09-12 15:46:46','12.249.250.150','12.249.250.150','closed',8,531,'attendances/1948/1694526906 clock_in.png','attendances/1948/1694558806 clock_out.png','Juan R',38740,NULL,'2023-09-12 10:55:06','2023-09-18 14:28:38'),(1656,'2023-09-12 06:56:41','2023-09-12 15:33:07','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1934/1694527001 clock_in.png','attendances/1934/1694557987 clock_out.png','Juan R',38736,NULL,'2023-09-12 10:56:41','2023-09-18 14:25:57'),(1657,'2023-09-12 06:56:57','2023-09-12 15:32:11','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1958/1694527017 clock_in.png','attendances/1958/1694557931 clock_out.png','Juan R',38733,NULL,'2023-09-12 10:56:57','2023-09-18 14:19:50'),(1658,'2023-09-12 06:58:40','2023-09-12 15:46:33','12.249.250.150','12.249.250.150','closed',8,527,'attendances/1462/1694527121 clock_in.png','attendances/1462/1694558793 clock_out.png','Juan R',38735,NULL,'2023-09-12 10:58:41','2023-09-18 14:20:19'),(1659,'2023-09-12 06:59:27','2023-09-12 16:29:01','12.249.250.150','12.249.250.150','closed',9,569,'attendances/1888/1694527167 clock_in.png','attendances/1888/1694561341 clock_out.png','Juan R',38743,NULL,'2023-09-12 10:59:27','2023-09-18 14:30:24'),(1660,'2023-09-12 06:59:39','2023-09-12 16:40:19','12.249.250.150','12.249.250.150','closed',9,580,'attendances/974/1694527179 clock_in.png','attendances/974/1694562019 clock_out.png','Juan R',38744,NULL,'2023-09-12 10:59:39','2023-09-18 13:46:12'),(1661,'2023-09-12 07:00:32','2023-09-12 16:20:00','12.249.250.150','','closed',9,559,'attendances/1728/1694527232 clock_in.png',NULL,'Juan R',38737,NULL,'2023-09-12 11:00:32','2023-09-18 14:26:53'),(1662,'2023-09-12 07:01:12','2023-09-12 15:55:58','12.249.250.150','12.249.250.150','closed',8,534,'attendances/1450/1694527272 clock_in.png','attendances/1450/1694559358 clock_out.png','Juan R',38741,NULL,'2023-09-12 11:01:12','2023-09-18 14:29:01'),(1663,'2023-09-12 07:10:02','2023-09-12 15:35:30','12.249.250.150','12.249.250.150','closed',8,505,'attendances/1858/1694527802 clock_in.png','attendances/1858/1694558130 clock_out.png','Juan R',38738,NULL,'2023-09-12 11:10:02','2023-09-18 14:27:00'),(1665,'2023-09-12 06:00:00','2023-09-12 16:30:00','181.234.13.6','','closed',10,630,NULL,NULL,'Juan R',38648,NULL,'2023-09-12 11:43:07','2023-09-18 13:47:26'),(1666,'2023-09-12 06:00:00','2023-09-12 16:30:00','181.234.13.6','','closed',10,630,NULL,NULL,'Juan R',38649,NULL,'2023-09-12 11:43:37','2023-09-18 13:47:50'),(1667,'2023-09-12 06:00:00','2023-09-12 16:30:00','181.234.13.6','','closed',10,630,NULL,NULL,'Juan R',38650,NULL,'2023-09-12 11:44:02','2023-09-18 14:19:25'),(1668,'2023-09-12 08:00:51','2023-09-12 16:30:38','12.249.250.150','12.249.250.150','closed',8,509,'attendances/775/1694530851 clock_in.png','attendances/775/1694561438 clock_out.png','Juan R',38746,NULL,'2023-09-12 12:00:51','2023-09-18 14:28:11'),(1669,'2023-09-12 08:03:31','2023-09-12 16:34:00','12.249.250.150','','closed',8,510,'attendances/1869/1694531011 clock_in.png',NULL,'Juan R',38745,NULL,'2023-09-12 12:03:31','2023-09-18 14:18:29'),(1670,'2023-09-12 08:03:40','2023-09-12 16:34:51','12.249.250.150','12.249.250.150','closed',8,511,'attendances/1891/1694531020 clock_in.png','attendances/1891/1694561691 clock_out.png','Juan R',38747,NULL,'2023-09-12 12:03:40','2023-09-18 14:28:34'),(1673,'2023-09-13 05:00:57','2023-09-13 18:39:28','12.249.250.150','12.249.250.150','closed',13,818,'attendances/1455/1694606697 clock_in.png','attendances/1455/1694655568 clock_out.png','Juan R',38768,NULL,'2023-09-13 09:04:57','2023-09-18 14:26:50'),(1674,'2023-09-13 04:30:00','2023-09-13 17:00:00','186.154.240.36','','closed',12,750,NULL,NULL,'Juan R',38651,NULL,'2023-09-13 09:30:26','2023-09-18 13:47:26'),(1675,'2023-09-13 04:30:00','2023-09-13 17:00:00','186.154.240.36','','closed',12,750,NULL,NULL,'Juan R',38652,NULL,'2023-09-13 09:32:08','2023-09-18 13:47:50'),(1676,'2023-09-13 04:30:00','2023-09-13 17:00:00','186.154.240.36','','closed',12,750,NULL,NULL,'Juan R',38653,NULL,'2023-09-13 09:32:33','2023-09-18 14:19:25'),(1677,'2023-09-13 05:56:26','2023-09-13 15:44:02','12.249.250.150','12.249.250.150','closed',9,587,'attendances/1588/1694609786 clock_in.png','attendances/1588/1694645042 clock_out.png','Juan R',38770,NULL,'2023-09-13 09:56:26','2023-09-18 14:19:06'),(1678,'2023-09-13 05:58:17','2023-09-13 14:28:18','12.249.250.150','12.249.250.150','closed',8,510,'attendances/2005/1694609897 clock_in.png','attendances/2005/1694640498 clock_out.png','Juan R',38771,NULL,'2023-09-13 09:58:17','2023-09-18 14:27:32'),(1679,'2023-09-13 05:59:14','2023-09-13 15:42:53','12.249.250.150','12.249.250.150','closed',9,583,'attendances/1568/1694609954 clock_in.png','attendances/1568/1694644973 clock_out.png','Juan R',38769,NULL,'2023-09-13 09:59:14','2023-09-18 14:06:53'),(1680,'2023-09-13 06:00:24','2023-09-13 15:27:04','12.249.250.150','12.249.250.150','closed',9,566,'attendances/1951/1694610024 clock_in.png','attendances/1951/1694644024 clock_out.png','Juan R',38773,NULL,'2023-09-13 10:00:24','2023-09-18 14:19:20'),(1681,'2023-09-12 19:00:00','2023-09-12 21:50:00','181.234.13.6','181.234.13.6','closed',2,170,NULL,NULL,'Juan R',38793,NULL,'2023-09-13 10:10:48','2023-09-18 14:19:16'),(1682,'2023-09-13 06:45:57','2023-09-13 15:34:48','12.249.250.150','12.249.250.150','closed',8,528,'attendances/622/1694612757 clock_in.png','attendances/622/1694644488 clock_out.png','Juan R',38785,NULL,'2023-09-13 10:45:57','2023-09-18 14:29:11'),(1683,'2023-09-13 06:54:04','2023-09-13 15:32:10','12.249.250.150','12.249.250.150','closed',8,518,'attendances/1774/1694613244 clock_in.png','attendances/1774/1694644330 clock_out.png','Juan R',38774,NULL,'2023-09-13 10:54:04','2023-09-18 14:19:30'),(1684,'2023-09-13 06:54:34','2023-09-13 15:47:57','12.249.250.150','12.249.250.150','closed',8,533,'attendances/1948/1694613274 clock_in.png','attendances/1948/1694645277 clock_out.png','Juan R',38783,NULL,'2023-09-13 10:54:34','2023-09-18 14:28:38'),(1685,'2023-09-13 06:55:01','2023-09-13 17:42:33','12.249.250.150','12.249.250.150','closed',10,647,'attendances/1479/1694613301 clock_in.png','attendances/1479/1694652153 clock_out.png','Juan R',38772,NULL,'2023-09-13 10:55:01','2023-09-18 14:19:16'),(1686,'2023-09-13 06:55:46','2023-09-13 19:03:00','12.249.250.150','12.249.250.150','closed',12,727,'attendances/2025/1694613346 clock_in.png','attendances/2025/1694656980 clock_out.png','Juan R',38786,NULL,'2023-09-13 10:55:46','2023-09-18 14:29:44'),(1687,'2023-09-13 06:56:08','2023-09-13 15:30:35','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1934/1694613368 clock_in.png','attendances/1934/1694644235 clock_out.png','Juan R',38778,NULL,'2023-09-13 10:56:08','2023-09-18 14:25:57'),(1688,'2023-09-13 06:57:10','2023-09-13 16:11:11','12.249.250.150','12.249.250.150','closed',9,554,'attendances/1999/1694613430 clock_in.png','attendances/1999/1694646671 clock_out.png','Juan R',38776,NULL,'2023-09-13 10:57:10','2023-09-18 14:19:58'),(1689,'2023-09-13 06:57:25','2023-09-13 15:30:56','12.249.250.150','12.249.250.150','closed',8,513,'attendances/1958/1694613445 clock_in.png','attendances/1958/1694644256 clock_out.png','Juan R',38775,NULL,'2023-09-13 10:57:25','2023-09-18 14:19:50'),(1690,'2023-09-13 06:57:45','2023-09-13 15:34:02','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1395/1694613465 clock_in.png','attendances/1395/1694644442 clock_out.png','Juan R',38782,NULL,'2023-09-13 10:57:45','2023-09-18 14:28:01'),(1691,'2023-09-13 06:59:02','2023-09-13 15:58:40','12.249.250.150','12.249.250.150','closed',8,539,'attendances/1728/1694613542 clock_in.png','attendances/1728/1694645920 clock_out.png','Juan R',38779,NULL,'2023-09-13 10:59:02','2023-09-18 14:26:53'),(1692,'2023-09-13 06:59:31','2023-09-13 15:41:00','12.249.250.150','12.249.250.150','closed',8,521,'attendances/1462/1694613571 clock_in.png','attendances/1462/1694644860 clock_out.png','Juan R',38777,NULL,'2023-09-13 10:59:31','2023-09-18 14:20:19'),(1693,'2023-09-13 07:01:58','2023-09-13 15:40:01','12.249.250.150','12.249.250.150','closed',8,518,'attendances/1888/1694613718 clock_in.png','attendances/1888/1694644801 clock_out.png','Juan R',38787,NULL,'2023-09-13 11:01:58','2023-09-18 14:30:24'),(1694,'2023-09-13 07:02:16','2023-09-13 15:32:29','12.249.250.150','12.249.250.150','closed',8,510,'attendances/1858/1694613737 clock_in.png','attendances/1858/1694644349 clock_out.png','Juan R',38780,NULL,'2023-09-13 11:02:17','2023-09-18 14:27:00'),(1695,'2023-09-13 07:03:37','2023-09-13 19:04:18','12.249.250.150','12.249.250.150','closed',12,720,'attendances/1450/1694613817 clock_in.png','attendances/1450/1694657058 clock_out.png','Juan R',38784,NULL,'2023-09-13 11:03:37','2023-09-18 14:29:01'),(1696,'2023-09-13 07:09:06','2023-09-13 15:41:44','12.249.250.150','12.249.250.150','closed',8,512,'attendances/974/1694614146 clock_in.png','attendances/974/1694644904 clock_out.png','Juan R',38788,NULL,'2023-09-13 11:09:06','2023-09-18 13:46:12'),(1697,'2023-09-13 07:24:05','2023-09-13 17:00:35','12.249.250.150','12.249.250.150','closed',9,576,'attendances/1116/1694615045 clock_in.png','attendances/1116/1694649635 clock_out.png','Juan R',38781,NULL,'2023-09-13 11:24:05','2023-09-18 14:27:35'),(1698,'2023-09-13 07:53:12','2023-09-13 17:19:16','12.249.250.150','12.249.250.150','closed',9,566,'attendances/726/1694616792 clock_in.png','attendances/726/1694650756 clock_out.png','Juan R',38789,NULL,'2023-09-13 11:53:12','2023-09-18 13:46:19'),(1699,'2023-09-13 08:00:40','2023-09-13 16:30:16','12.249.250.150','12.249.250.150','closed',8,509,'attendances/775/1694617240 clock_in.png','attendances/775/1694647816 clock_out.png','Juan R',38791,NULL,'2023-09-13 12:00:40','2023-09-18 14:28:11'),(1700,'2023-09-13 08:02:51','2023-09-13 16:31:45','12.249.250.150','12.249.250.150','closed',8,508,'attendances/1869/1694617371 clock_in.png','attendances/1869/1694647905 clock_out.png','Juan R',38790,NULL,'2023-09-13 12:02:51','2023-09-18 14:18:29'),(1701,'2023-09-13 08:03:07','2023-09-13 16:32:00','12.249.250.150','12.249.250.150','closed',8,508,'attendances/1891/1694617387 clock_in.png','attendances/1891/1694647920 clock_out.png','Juan R',38792,NULL,'2023-09-13 12:03:07','2023-09-18 14:28:34'),(1704,'2023-09-13 20:57:39','2023-09-13 23:37:32','12.249.250.150','12.249.250.150','closed',2,159,'attendances/1479/1694663859 clock_in.png','attendances/1479/1694673452 clock_out.png','Juan R',38818,NULL,'2023-09-14 00:57:39','2023-09-18 14:19:16'),(1705,'2023-09-14 05:57:03','2023-09-14 18:46:49','12.249.250.150','12.249.250.150','closed',12,769,'attendances/2005/1694696223 clock_in.png','attendances/2005/1694742409 clock_out.png','Juan R',38796,NULL,'2023-09-14 09:57:03','2023-09-18 14:27:32'),(1706,'2023-09-14 05:59:22','2023-09-14 15:31:06','12.249.250.150','12.249.250.150','closed',9,571,'attendances/1568/1694696362 clock_in.png','attendances/1568/1694730666 clock_out.png','Juan R',38794,NULL,'2023-09-14 09:59:22','2023-09-18 14:06:53'),(1707,'2023-09-14 05:59:42','2023-09-14 15:02:40','12.249.250.150','12.249.250.150','closed',9,542,'attendances/1450/1694696382 clock_in.png','attendances/1450/1694728960 clock_out.png','Juan R',38797,NULL,'2023-09-14 09:59:42','2023-09-18 14:29:01'),(1708,'2023-09-14 06:00:25','2023-09-14 19:11:08','12.249.250.150','12.249.250.150','closed',13,790,'attendances/1455/1694696425 clock_in.png','attendances/1455/1694743868 clock_out.png','Juan R',38795,NULL,'2023-09-14 10:00:25','2023-09-18 14:26:50'),(1709,'2023-09-14 06:02:46','2023-09-14 15:32:49','12.249.250.150','12.249.250.150','closed',9,570,'attendances/1951/1694696566 clock_in.png','attendances/1951/1694730769 clock_out.png','Juan R',38801,NULL,'2023-09-14 10:02:46','2023-09-18 14:19:20'),(1710,'2023-09-14 06:00:00','2023-09-14 17:19:26','181.234.24.110','12.249.250.150','closed',11,679,NULL,'attendances/1551/1694737166 clock_out.png','Juan R',38654,NULL,'2023-09-14 10:16:32','2023-09-18 13:47:26'),(1711,'2023-09-14 06:00:00','2023-09-14 17:19:52','181.234.24.110','12.249.250.150','closed',11,679,NULL,'attendances/1585/1694737192 clock_out.png','Juan R',38655,NULL,'2023-09-14 10:16:50','2023-09-18 13:47:50'),(1712,'2023-09-14 06:00:00','2023-09-14 17:20:14','181.234.24.110','12.249.250.150','closed',11,680,NULL,'attendances/382/1694737214 clock_out.png','Juan R',38656,NULL,'2023-09-14 10:17:10','2023-09-18 14:19:25'),(1713,'2023-09-14 06:40:10','2023-09-14 15:34:53','12.249.250.150','12.249.250.150','closed',8,534,'attendances/622/1694698810 clock_in.png','attendances/622/1694730893 clock_out.png','Juan R',38812,NULL,'2023-09-14 10:40:10','2023-09-18 14:29:11'),(1714,'2023-09-14 06:50:05','2023-09-14 17:02:42','12.249.250.150','12.249.250.150','closed',10,612,'attendances/1999/1694699405 clock_in.png','attendances/1999/1694736162 clock_out.png','Juan R',38804,NULL,'2023-09-14 10:50:05','2023-09-18 14:19:58'),(1715,'2023-09-14 06:50:50','2023-09-14 16:09:25','12.249.250.150','12.249.250.150','closed',9,558,'attendances/1116/1694699450 clock_in.png','attendances/1116/1694732965 clock_out.png','Juan R',38809,NULL,'2023-09-14 10:50:50','2023-09-18 14:27:35'),(1716,'2023-09-14 06:52:55','2023-09-14 16:52:55','12.249.250.150','12.249.250.150','closed',10,600,'attendances/1395/1694699575 clock_in.png','attendances/1395/1694735575 clock_out.png','Juan R',38810,NULL,'2023-09-14 10:52:55','2023-09-18 14:28:01'),(1717,'2023-09-14 06:53:29','2023-09-14 16:04:32','12.249.250.150','12.249.250.150','closed',9,551,'attendances/1479/1694699609 clock_in.png','attendances/1479/1694732672 clock_out.png','Juan R',38800,NULL,'2023-09-14 10:53:29','2023-09-18 14:19:16'),(1718,'2023-09-14 06:54:10','2023-09-14 15:30:20','12.249.250.150','12.249.250.150','closed',8,516,'attendances/726/1694699650 clock_in.png','attendances/726/1694730620 clock_out.png','Juan R',38798,NULL,'2023-09-14 10:54:10','2023-09-18 13:46:19'),(1719,'2023-09-14 06:54:37','2023-09-14 15:32:19','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1774/1694699677 clock_in.png','attendances/1774/1694730739 clock_out.png','Juan R',38802,NULL,'2023-09-14 10:54:37','2023-09-18 14:19:30'),(1720,'2023-09-14 06:55:10','2023-09-14 15:31:38','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1858/1694699710 clock_in.png','attendances/1858/1694730698 clock_out.png','Juan R',38808,NULL,'2023-09-14 10:55:10','2023-09-18 14:27:00'),(1721,'2023-09-14 06:56:06','2023-09-14 15:31:08','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1934/1694699766 clock_in.png','attendances/1934/1694730668 clock_out.png','Juan R',38806,NULL,'2023-09-14 10:56:06','2023-09-18 14:25:57'),(1722,'2023-09-14 06:57:25','2023-09-14 15:32:03','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1958/1694699845 clock_in.png','attendances/1958/1694730723 clock_out.png','Juan R',38803,NULL,'2023-09-14 10:57:25','2023-09-18 14:19:50'),(1723,'2023-09-14 06:59:38','2023-09-14 17:27:14','12.249.250.150','12.249.250.150','closed',10,627,'attendances/974/1694699978 clock_in.png','attendances/974/1694737634 clock_out.png','Juan R',38814,NULL,'2023-09-14 10:59:38','2023-09-18 13:46:12'),(1724,'2023-09-14 06:59:53','2023-09-14 16:08:59','12.249.250.150','12.249.250.150','closed',9,549,'attendances/1728/1694699993 clock_in.png','attendances/1728/1694732939 clock_out.png','Juan R',38807,NULL,'2023-09-14 10:59:53','2023-09-18 14:26:53'),(1725,'2023-09-14 07:00:34','2023-09-14 15:34:16','12.249.250.150','12.249.250.150','closed',8,513,'attendances/1948/1694700034 clock_in.png','attendances/1948/1694730856 clock_out.png','Juan R',38811,NULL,'2023-09-14 11:00:34','2023-09-18 14:28:38'),(1726,'2023-09-14 07:02:05','2023-09-14 17:26:48','12.249.250.150','12.249.250.150','closed',10,624,'attendances/1888/1694700125 clock_in.png','attendances/1888/1694737608 clock_out.png','Juan R',38813,NULL,'2023-09-14 11:02:05','2023-09-18 14:30:24'),(1727,'2023-09-14 07:03:01','2023-09-14 15:50:28','12.249.250.150','12.249.250.150','closed',8,527,'attendances/1462/1694700181 clock_in.png','attendances/1462/1694731828 clock_out.png','Juan R',38805,NULL,'2023-09-14 11:03:01','2023-09-18 14:20:19'),(1728,'2023-09-14 07:07:57','2023-09-14 15:30:55','12.249.250.150','12.249.250.150','closed',8,502,'attendances/1588/1694700477 clock_in.png','attendances/1588/1694730655 clock_out.png','Juan R',38799,NULL,'2023-09-14 11:07:57','2023-09-18 14:19:06'),(1729,'2023-09-14 07:58:46','2023-09-14 16:30:04','12.249.250.150','12.249.250.150','closed',8,511,'attendances/775/1694703526 clock_in.png','attendances/775/1694734204 clock_out.png','Juan R',38816,NULL,'2023-09-14 11:58:46','2023-09-18 14:28:11'),(1730,'2023-09-14 08:03:17','2023-09-14 16:32:41','12.249.250.150','12.249.250.150','closed',8,509,'attendances/1891/1694703797 clock_in.png','attendances/1891/1694734361 clock_out.png','Juan R',38817,NULL,'2023-09-14 12:03:17','2023-09-18 14:28:34'),(1731,'2023-09-15 05:52:44','2023-09-15 17:30:57','12.249.250.150','12.249.250.150','closed',11,698,'attendances/1999/1694782364 clock_in.png','attendances/1999/1694824257 clock_out.png','Juan R',38842,NULL,'2023-09-15 09:52:44','2023-09-18 14:19:58'),(1732,'2023-09-15 05:57:25','2023-09-15 16:56:50','12.249.250.150','12.249.250.150','closed',10,659,'attendances/1450/1694782645 clock_in.png','attendances/1450/1694822210 clock_out.png','Juan R',38835,NULL,'2023-09-15 09:57:25','2023-09-18 14:29:01'),(1733,'2023-09-15 05:57:43','2023-09-15 23:48:29','12.249.250.150','12.249.250.150','closed',17,1070,'attendances/2005/1694782663 clock_in.png','attendances/2005/1694846909 clock_out.png','Juan R',38834,NULL,'2023-09-15 09:57:43','2023-09-18 14:27:32'),(1734,'2023-09-15 05:57:57','2023-09-15 23:47:58','12.249.250.150','12.249.250.150','closed',17,1070,'attendances/1568/1694782677 clock_in.png','attendances/1568/1694846878 clock_out.png','Juan R',38832,NULL,'2023-09-15 09:57:57','2023-09-18 14:06:53'),(1735,'2023-09-15 05:58:14','2023-09-15 15:41:46','12.249.250.150','12.249.250.150','closed',9,583,'attendances/1951/1694782694 clock_in.png','attendances/1951/1694817706 clock_out.png','Juan R',38839,NULL,'2023-09-15 09:58:14','2023-09-18 14:19:20'),(1736,'2023-09-15 06:02:09','2023-09-15 17:31:25','12.249.250.150','12.249.250.150','closed',11,689,'attendances/1395/1694782929 clock_in.png','attendances/1395/1694824285 clock_out.png','Juan R',38847,NULL,'2023-09-15 10:02:09','2023-09-18 14:28:01'),(1737,'2023-09-15 06:39:41','2023-09-15 15:35:01','12.249.250.150','12.249.250.150','closed',8,535,'attendances/622/1694785181 clock_in.png','attendances/622/1694817301 clock_out.png','Juan R',38849,NULL,'2023-09-15 10:39:41','2023-09-18 14:29:11'),(1738,'2023-09-15 06:51:37','2023-09-15 17:29:18','12.249.250.150','12.249.250.150','closed',10,637,'attendances/1728/1694785897 clock_in.png','attendances/1728/1694824158 clock_out.png','Juan R',38845,NULL,'2023-09-15 10:51:37','2023-09-18 14:26:53'),(1739,'2023-09-15 06:52:44','2023-09-15 16:31:30','12.249.250.150','12.249.250.150','closed',9,578,'attendances/726/1694785964 clock_in.png','attendances/726/1694820690 clock_out.png','Juan R',38836,NULL,'2023-09-15 10:52:44','2023-09-18 13:46:19'),(1740,'2023-09-15 06:53:46','2023-09-15 16:06:11','12.249.250.150','12.249.250.150','closed',9,552,'attendances/2025/1694786026 clock_in.png','attendances/2025/1694819171 clock_out.png','Juan R',38850,NULL,'2023-09-15 10:53:46','2023-09-18 14:29:44'),(1741,'2023-09-15 06:53:59','2023-09-15 15:32:06','12.249.250.150','12.249.250.150','closed',8,518,'attendances/1774/1694786039 clock_in.png','attendances/1774/1694817126 clock_out.png','Juan R',38840,NULL,'2023-09-15 10:53:59','2023-09-18 14:19:30'),(1742,'2023-09-15 06:55:44','2023-09-15 17:02:50','12.249.250.150','12.249.250.150','closed',10,607,'attendances/1588/1694786144 clock_in.png','attendances/1588/1694822570 clock_out.png','Juan R',38837,NULL,'2023-09-15 10:55:44','2023-09-18 14:19:06'),(1743,'2023-09-15 06:56:12','2023-09-15 15:31:54','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1934/1694786172 clock_in.png','attendances/1934/1694817114 clock_out.png','Juan R',38844,NULL,'2023-09-15 10:56:12','2023-09-18 14:25:57'),(1744,'2023-09-15 06:56:32','2023-09-15 15:36:33','12.249.250.150','12.249.250.150','closed',8,520,'attendances/1479/1694786192 clock_in.png','attendances/1479/1694817393 clock_out.png','Juan R',38838,NULL,'2023-09-15 10:56:32','2023-09-18 14:19:16'),(1745,'2023-09-15 06:57:51','2023-09-15 15:32:33','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1858/1694786271 clock_in.png','attendances/1858/1694817153 clock_out.png','Juan R',38846,NULL,'2023-09-15 10:57:51','2023-09-18 14:27:00'),(1746,'2023-09-15 06:58:15','2023-09-15 17:29:39','12.249.250.150','12.249.250.150','closed',10,631,'attendances/974/1694786295 clock_in.png','attendances/974/1694824179 clock_out.png','Juan R',38852,NULL,'2023-09-15 10:58:15','2023-09-18 13:46:12'),(1747,'2023-09-15 06:59:21','2023-09-15 15:32:20','12.249.250.150','12.249.250.150','closed',8,512,'attendances/1958/1694786361 clock_in.png','attendances/1958/1694817140 clock_out.png','Juan R',38841,NULL,'2023-09-15 10:59:21','2023-09-18 14:19:50'),(1748,'2023-09-15 07:00:08','2023-09-15 15:37:27','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1948/1694786408 clock_in.png','attendances/1948/1694817448 clock_out.png','Juan R',38848,NULL,'2023-09-15 11:00:08','2023-09-18 14:28:38'),(1749,'2023-09-15 07:03:04','2023-09-15 15:37:17','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1888/1694786584 clock_in.png','attendances/1888/1694817437 clock_out.png','Juan R',38851,NULL,'2023-09-15 11:03:04','2023-09-18 14:30:24'),(1750,'2023-09-15 07:04:01','2023-09-15 15:39:44','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1462/1694786641 clock_in.png','attendances/1462/1694817584 clock_out.png','Juan R',38843,NULL,'2023-09-15 11:04:01','2023-09-18 14:20:19'),(1751,'2023-09-15 07:57:18','2023-09-15 16:31:41','12.249.250.150','12.249.250.150','closed',8,514,'attendances/775/1694789838 clock_in.png','attendances/775/1694820701 clock_out.png','Juan R',38854,NULL,'2023-09-15 11:57:18','2023-09-18 14:28:11'),(1752,'2023-09-15 08:00:47','2023-09-15 16:32:42','12.249.250.150','12.249.250.150','closed',8,511,'attendances/1869/1694790047 clock_in.png','attendances/1869/1694820762 clock_out.png','Juan R',38853,NULL,'2023-09-15 12:00:47','2023-09-18 14:18:29'),(1753,'2023-09-15 08:00:55','2023-09-15 16:32:56','12.249.250.150','12.249.250.150','closed',8,512,'attendances/1891/1694790055 clock_in.png','attendances/1891/1694820776 clock_out.png','Juan R',38855,NULL,'2023-09-15 12:00:55','2023-09-18 14:28:34'),(1754,'2023-09-15 10:56:54','2023-09-15 22:01:05','12.249.250.150','12.249.250.150','closed',11,664,'attendances/1116/1694800614 clock_in.png','attendances/1116/1694840465 clock_out.png','Juan R',38856,NULL,'2023-09-15 14:56:54','2023-09-18 14:27:35'),(1755,'2023-09-18 05:00:07','2023-09-18 15:31:09','12.249.250.150','12.249.250.150','closed',10,631,'attendances/1568/1695038407 clock_in.png','attendances/1568/1695076269 clock_out.png','Juan R',38863,NULL,'2023-09-18 09:00:07','2023-09-25 14:42:27'),(1756,'2023-09-18 05:00:26','2023-09-18 15:35:25','12.249.250.150','12.249.250.150','closed',10,634,'attendances/1588/1695038426 clock_in.png','attendances/1588/1695076525 clock_out.png','Juan R',38864,NULL,'2023-09-18 09:00:26','2023-09-25 14:42:36'),(1757,'2023-09-18 05:55:05','2023-09-18 18:58:00','12.249.250.150','12.249.250.150','closed',13,782,'attendances/1551/1695041705 clock_in.png','attendances/1551/1695088680 clock_out.png','Juan R',38865,NULL,'2023-09-18 09:55:05','2023-09-25 14:42:05'),(1758,'2023-09-18 05:55:21','2023-09-18 19:00:55','12.249.250.150','12.249.250.150','closed',13,785,'attendances/2005/1695041721 clock_in.png','attendances/2005/1695088855 clock_out.png','Juan R',38870,NULL,'2023-09-18 09:55:21','2023-09-25 14:45:13'),(1759,'2023-09-18 05:56:07','2023-09-18 15:55:15','12.249.250.150','12.249.250.150','closed',9,599,'attendances/1116/1695041767 clock_in.png','attendances/1116/1695077715 clock_out.png','Juan R',38871,NULL,'2023-09-18 09:56:07','2023-09-25 14:45:18'),(1760,'2023-09-18 05:56:19','2023-09-18 16:03:50','12.249.250.150','12.249.250.150','closed',10,607,'attendances/1951/1695041779 clock_in.png','attendances/1951/1695078230 clock_out.png','Juan R',38874,NULL,'2023-09-18 09:56:19','2023-09-25 14:43:14'),(1761,'2023-09-18 05:57:28','2023-09-18 17:38:26','12.249.250.150','12.249.250.150','closed',11,700,'attendances/1479/1695041848 clock_in.png','attendances/1479/1695083906 clock_out.png','Juan R',38867,NULL,'2023-09-18 09:57:28','2023-09-25 14:42:47'),(1762,'2023-09-18 06:01:45','2023-09-18 17:20:42','12.249.250.150','12.249.250.150','closed',11,678,'attendances/1450/1695042105 clock_in.png','attendances/1450/1695082842 clock_out.png','Juan R',38872,NULL,'2023-09-18 10:01:45','2023-09-25 14:49:14'),(1763,'2023-09-18 06:01:58','2023-09-18 17:12:02','12.249.250.150','12.249.250.150','closed',11,670,'attendances/1455/1695042118 clock_in.png','attendances/1455/1695082322 clock_out.png','Juan R',38869,NULL,'2023-09-18 10:01:58','2023-09-25 14:44:24'),(1764,'2023-09-18 06:03:05','2023-09-18 15:34:33','12.249.250.150','12.249.250.150','closed',9,571,'attendances/622/1695042185 clock_in.png','attendances/622/1695076473 clock_out.png','Juan R',38883,NULL,'2023-09-18 10:03:05','2023-09-25 14:49:19'),(1765,'2023-09-18 06:50:06','2023-09-18 16:17:19','12.249.250.150','12.249.250.150','closed',9,567,'attendances/1999/1695045006 clock_in.png','attendances/1999/1695079039 clock_out.png','Juan R',38877,NULL,'2023-09-18 10:50:06','2023-09-25 14:43:56'),(1766,'2023-09-18 06:51:37','2023-09-18 16:17:42','12.249.250.150','12.249.250.150','closed',9,566,'attendances/1395/1695045097 clock_in.png','attendances/1395/1695079062 clock_out.png','Juan R',38881,NULL,'2023-09-18 10:51:37','2023-09-25 14:45:44'),(1767,'2023-09-18 06:53:27','2023-09-18 15:38:07','12.249.250.150','12.249.250.150','closed',8,524,'attendances/974/1695045207 clock_in.png','attendances/974/1695076687 clock_out.png','Juan R',38886,NULL,'2023-09-18 10:53:27','2023-09-25 14:41:42'),(1768,'2023-09-18 06:53:48','2023-09-18 19:00:19','12.249.250.150','12.249.250.150','closed',12,726,'attendances/726/1695045228 clock_in.png','attendances/726/1695088819 clock_out.png','Juan R',38873,NULL,'2023-09-18 10:53:48','2023-09-25 14:41:46'),(1769,'2023-09-18 06:55:07','2023-09-18 16:17:31','12.249.250.150','12.249.250.150','closed',9,562,'attendances/1728/1695045307 clock_in.png','attendances/1728/1695079051 clock_out.png','Juan R',38879,NULL,'2023-09-18 10:55:07','2023-09-25 14:44:38'),(1770,'2023-09-18 06:56:12','2023-09-18 15:30:37','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1934/1695045372 clock_in.png','attendances/1934/1695076237 clock_out.png','Juan R',38878,NULL,'2023-09-18 10:56:12','2023-09-25 14:44:16'),(1771,'2023-09-18 06:56:25','2023-09-18 15:34:52','12.249.250.150','12.249.250.150','closed',8,518,'attendances/1774/1695045385 clock_in.png','attendances/1774/1695076492 clock_out.png','Juan R',38875,NULL,'2023-09-18 10:56:25','2023-09-25 14:43:32'),(1772,'2023-09-18 06:56:47','2023-09-18 15:33:22','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1858/1695045407 clock_in.png','attendances/1858/1695061882 clock_out.png','Juan R',38880,NULL,'2023-09-18 10:56:47','2023-09-25 14:44:42'),(1773,'2023-09-18 06:57:18','2023-09-18 15:35:13','12.249.250.150','12.249.250.150','closed',8,517,'attendances/2025/1695045438 clock_in.png','attendances/2025/1695076513 clock_out.png','Juan R',38884,NULL,'2023-09-18 10:57:18','2023-09-25 14:49:28'),(1774,'2023-09-18 06:59:09','2023-09-18 15:35:44','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1948/1695045549 clock_in.png','attendances/1948/1695076544 clock_out.png','Juan R',38882,NULL,'2023-09-18 10:59:09','2023-09-25 14:47:43'),(1775,'2023-09-18 06:59:19','2023-09-18 15:32:08','12.249.250.150','12.249.250.150','closed',8,512,'attendances/1958/1695045559 clock_in.png','attendances/1958/1695076328 clock_out.png','Juan R',38876,NULL,'2023-09-18 10:59:19','2023-09-25 14:43:52'),(1776,'2023-09-18 07:06:50','2023-09-18 15:18:28','12.249.250.150','12.249.250.150','closed',8,491,'attendances/1888/1695046010 clock_in.png','attendances/1888/1695075508 clock_out.png','Juan R',38885,NULL,'2023-09-18 11:06:50','2023-09-25 14:49:53'),(1777,'2023-09-18 05:55:00','2023-09-18 17:11:11','190.2.214.172','12.249.250.150','closed',11,676,NULL,'attendances/1585/1695082271 clock_out.png','Juan R',38866,NULL,'2023-09-18 11:14:00','2023-09-25 14:42:09'),(1779,'2023-09-18 07:59:09','2023-09-18 16:31:19','12.249.250.150','12.249.250.150','closed',8,512,'attendances/775/1695049149 clock_in.png','attendances/775/1695079879 clock_out.png','Juan R',38889,NULL,'2023-09-18 11:59:09','2023-09-25 14:45:47'),(1780,'2023-09-18 08:00:57','2023-09-18 16:34:06','12.249.250.150','12.249.250.150','closed',8,513,'attendances/1869/1695049257 clock_in.png','attendances/1869/1695080046 clock_out.png','Juan R',38887,NULL,'2023-09-18 12:00:57','2023-09-25 14:42:33'),(1781,'2023-09-18 08:01:04','2023-09-18 16:34:20','12.249.250.150','12.249.250.150','closed',8,513,'attendances/1891/1695049264 clock_in.png','attendances/1891/1695080060 clock_out.png','Juan R',38890,NULL,'2023-09-18 12:01:04','2023-09-25 14:47:35'),(1782,'2023-09-18 08:18:31','2023-09-18 15:45:36','12.249.250.150','12.249.250.150','closed',7,447,'attendances/1462/1695050311 clock_in.png','attendances/1462/1695077136 clock_out.png','Juan R',38888,NULL,'2023-09-18 12:18:31','2023-09-25 14:43:58'),(1783,'2023-09-19 05:14:47','2023-09-19 14:03:41','12.249.250.150','12.249.250.150','closed',8,528,'attendances/1450/1695125687 clock_in.png','attendances/1450/1695157421 clock_out.png','Juan R',39007,NULL,'2023-09-19 09:14:47','2023-09-25 14:49:14'),(1784,'2023-09-19 05:26:20','2023-09-19 14:02:13','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1551/1695126380 clock_in.png','attendances/1551/1695157333 clock_out.png','Juan R',39008,NULL,'2023-09-19 09:26:20','2023-09-25 14:42:05'),(1785,'2023-09-19 05:27:26','2023-09-19 14:02:29','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1455/1695126446 clock_in.png','attendances/1455/1695157349 clock_out.png','Juan R',39009,NULL,'2023-09-19 09:27:26','2023-09-25 14:44:24'),(1786,'2023-09-19 05:51:36','2023-09-19 20:08:32','12.249.250.150','12.249.250.150','closed',14,856,'attendances/2025/1695127896 clock_in.png','attendances/2025/1695179312 clock_out.png','Juan R',39016,NULL,'2023-09-19 09:51:36','2023-09-25 14:49:28'),(1787,'2023-09-19 05:54:31','2023-09-19 15:36:52','12.249.250.150','12.249.250.150','closed',9,582,'attendances/622/1695128071 clock_in.png','attendances/622/1695163012 clock_out.png','Juan R',39028,NULL,'2023-09-19 09:54:31','2023-09-25 14:49:19'),(1788,'2023-09-19 05:54:46','2023-09-19 15:29:45','12.249.250.150','12.249.250.150','closed',9,574,'attendances/1116/1695128086 clock_in.png','attendances/1116/1695162585 clock_out.png','Juan R',39015,NULL,'2023-09-19 09:54:46','2023-09-25 14:45:18'),(1789,'2023-09-19 05:55:28','2023-09-19 16:15:06','12.249.250.150','12.249.250.150','closed',10,619,'attendances/2005/1695128128 clock_in.png','attendances/2005/1695165306 clock_out.png','Juan R',39014,NULL,'2023-09-19 09:55:28','2023-09-25 14:45:13'),(1790,'2023-09-19 05:55:50','2023-09-19 15:30:51','12.249.250.150','12.249.250.150','closed',9,575,'attendances/726/1695128150 clock_in.png','attendances/726/1695162651 clock_out.png','Juan R',39010,NULL,'2023-09-19 09:55:50','2023-09-25 14:41:46'),(1791,'2023-09-19 05:55:51','2023-09-19 15:31:21','12.249.250.150','12.249.250.150','closed',9,575,'attendances/1588/1695128151 clock_in.png','attendances/1588/1695162681 clock_out.png','Juan R',39013,NULL,'2023-09-19 09:55:51','2023-09-25 14:42:36'),(1792,'2023-09-19 05:58:13','2023-09-19 15:30:35','12.249.250.150','12.249.250.150','closed',9,572,'attendances/1568/1695128293 clock_in.png','attendances/1568/1695162635 clock_out.png','Juan R',39012,NULL,'2023-09-19 09:58:13','2023-09-25 14:42:27'),(1793,'2023-09-19 05:58:51','2023-09-19 15:05:49','12.249.250.150','12.249.250.150','closed',9,546,'attendances/1585/1695128331 clock_in.png','attendances/1585/1695161149 clock_out.png','Juan R',39011,NULL,'2023-09-19 09:58:51','2023-09-25 14:42:09'),(1794,'2023-09-19 05:59:18','2023-09-19 14:59:38','12.249.250.150','12.249.250.150','closed',9,540,'attendances/1951/1695128359 clock_in.png','attendances/1951/1695160778 clock_out.png','Juan R',39018,NULL,'2023-09-19 09:59:19','2023-09-25 14:43:14'),(1795,'2023-09-19 06:51:46','2023-09-19 15:35:36','12.249.250.150','12.249.250.150','closed',8,523,'attendances/1999/1695131506 clock_in.png','attendances/1999/1695162936 clock_out.png','Juan R',39021,NULL,'2023-09-19 10:51:46','2023-09-25 14:43:56'),(1796,'2023-09-19 06:52:53','2023-09-19 15:51:46','12.249.250.150','12.249.250.150','closed',8,538,'attendances/1728/1695131573 clock_in.png','attendances/1728/1695163906 clock_out.png','Juan R',39024,NULL,'2023-09-19 10:52:53','2023-09-25 14:44:38'),(1797,'2023-09-19 06:53:05','2023-09-19 15:31:32','12.249.250.150','12.249.250.150','closed',8,518,'attendances/1774/1695131585 clock_in.png','attendances/1774/1695162692 clock_out.png','Juan R',39019,NULL,'2023-09-19 10:53:05','2023-09-25 14:43:32'),(1798,'2023-09-19 06:53:09','2023-09-19 15:34:31','12.249.250.150','12.249.250.150','closed',8,521,'attendances/1395/1695131589 clock_in.png','attendances/1395/1695162871 clock_out.png','Juan R',39026,NULL,'2023-09-19 10:53:09','2023-09-25 14:45:44'),(1799,'2023-09-19 06:54:14','2023-09-19 15:31:49','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1479/1695131654 clock_in.png','attendances/1479/1695162709 clock_out.png','Juan R',39017,NULL,'2023-09-19 10:54:14','2023-09-25 14:42:47'),(1800,'2023-09-19 06:54:50','2023-09-19 15:31:44','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1934/1695131690 clock_in.png','attendances/1934/1695162704 clock_out.png','Juan R',39023,NULL,'2023-09-19 10:54:50','2023-09-25 14:44:16'),(1801,'2023-09-19 06:56:44','2023-09-19 15:32:02','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1858/1695131804 clock_in.png','attendances/1858/1695162722 clock_out.png','Juan R',39025,NULL,'2023-09-19 10:56:44','2023-09-25 14:44:42'),(1802,'2023-09-19 06:57:05','2023-09-19 15:32:15','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1958/1695131825 clock_in.png','attendances/1958/1695162735 clock_out.png','Juan R',39020,NULL,'2023-09-19 10:57:05','2023-09-25 14:43:52'),(1803,'2023-09-19 06:57:29','2023-09-19 15:33:35','12.249.250.150','12.249.250.150','closed',8,516,'attendances/974/1695131849 clock_in.png','attendances/974/1695162815 clock_out.png','Juan R',39030,NULL,'2023-09-19 10:57:29','2023-09-25 14:41:42'),(1804,'2023-09-19 07:02:37','2023-09-19 15:30:32','12.249.250.150','12.249.250.150','closed',8,507,'attendances/1948/1695132157 clock_in.png','attendances/1948/1695162632 clock_out.png','Juan R',39027,NULL,'2023-09-19 11:02:38','2023-09-25 14:47:43'),(1805,'2023-09-19 07:04:48','2023-09-19 15:34:05','12.249.250.150','12.249.250.150','closed',8,509,'attendances/1888/1695132288 clock_in.png','attendances/1888/1695162845 clock_out.png','Juan R',39029,NULL,'2023-09-19 11:04:48','2023-09-25 14:49:53'),(1806,'2023-09-19 07:05:30','2023-09-19 15:39:14','12.249.250.150','12.249.250.150','closed',8,513,'attendances/1462/1695132330 clock_in.png','attendances/1462/1695163154 clock_out.png','Juan R',39022,NULL,'2023-09-19 11:05:30','2023-09-25 14:43:58'),(1807,'2023-09-19 07:59:38','2023-09-19 16:30:42','12.249.250.150','12.249.250.150','closed',8,511,'attendances/775/1695135578 clock_in.png','attendances/775/1695166242 clock_out.png','Juan R',39032,NULL,'2023-09-19 11:59:38','2023-09-25 14:45:47'),(1808,'2023-09-19 08:04:48','2023-09-19 16:32:00','12.249.250.150','12.249.250.150','closed',8,507,'attendances/1869/1695135888 clock_in.png','attendances/1869/1695166320 clock_out.png','Juan R',39031,NULL,'2023-09-19 12:04:48','2023-09-25 14:42:33'),(1809,'2023-09-19 08:04:56','2023-09-19 16:31:00','12.249.250.150','','closed',8,506,'attendances/1891/1695135896 clock_in.png',NULL,'Juan R',39033,NULL,'2023-09-19 12:04:56','2023-09-25 14:47:35'),(1810,'2023-09-20 05:54:44','2023-09-20 16:48:16','12.249.250.150','12.249.250.150','closed',10,653,'attendances/1585/1695214484 clock_in.png','attendances/1585/1695253696 clock_out.png','Juan R',39039,NULL,'2023-09-20 09:54:44','2023-09-25 14:42:09'),(1811,'2023-09-20 05:55:24','2023-09-20 17:01:37','12.249.250.150','12.249.250.150','closed',11,666,'attendances/1116/1695214524 clock_in.png','attendances/1116/1695254497 clock_out.png','Juan R',39043,NULL,'2023-09-20 09:55:24','2023-09-25 14:45:18'),(1812,'2023-09-20 05:55:46','2023-09-20 15:38:38','12.249.250.150','12.249.250.150','closed',9,582,'attendances/1588/1695214546 clock_in.png','attendances/1588/1695249518 clock_out.png','Juan R',39041,NULL,'2023-09-20 09:55:46','2023-09-25 14:42:36'),(1813,'2023-09-20 05:55:59','2023-09-20 17:03:18','12.249.250.150','12.249.250.150','closed',11,667,'attendances/1479/1695214559 clock_in.png','attendances/1479/1695254598 clock_out.png','Juan R',39042,NULL,'2023-09-20 09:55:59','2023-09-25 14:42:47'),(1814,'2023-09-20 05:56:01','2023-09-20 16:44:53','12.249.250.150','12.249.250.150','closed',10,648,'attendances/2025/1695214561 clock_in.png','attendances/2025/1695253493 clock_out.png','Juan R',39045,NULL,'2023-09-20 09:56:01','2023-09-25 14:49:28'),(1815,'2023-09-20 05:56:51','2023-09-20 16:45:17','12.249.250.150','12.249.250.150','closed',10,648,'attendances/1450/1695214611 clock_in.png','attendances/1450/1695253517 clock_out.png','Juan R',39044,NULL,'2023-09-20 09:56:51','2023-09-25 14:49:14'),(1816,'2023-09-20 05:58:09','2023-09-20 15:38:09','12.249.250.150','12.249.250.150','closed',9,580,'attendances/1568/1695214689 clock_in.png','attendances/1568/1695249489 clock_out.png','Juan R',39040,NULL,'2023-09-20 09:58:09','2023-09-25 14:42:27'),(1817,'2023-09-20 06:01:06','2023-09-20 18:11:40','12.249.250.150','12.249.250.150','closed',12,730,'attendances/622/1695214866 clock_in.png','attendances/622/1695258700 clock_out.png','Juan R',39060,NULL,'2023-09-20 10:01:06','2023-09-25 14:49:19'),(1818,'2023-09-20 06:53:47','2023-09-20 15:31:17','12.249.250.150','12.249.250.150','closed',8,517,'attendances/726/1695218027 clock_in.png','attendances/726/1695249077 clock_out.png','Juan R',39046,NULL,'2023-09-20 10:53:47','2023-09-25 14:41:46'),(1819,'2023-09-20 06:54:43','2023-09-20 15:30:00','12.249.250.150','','closed',8,515,'attendances/1551/1695218083 clock_in.png',NULL,'Juan R',39047,NULL,'2023-09-20 10:54:43','2023-09-25 14:42:05'),(1820,'2023-09-20 06:54:54','2023-09-20 15:29:21','12.249.250.150','12.249.250.150','closed',8,514,'attendances/2005/1695218094 clock_in.png','attendances/2005/1695248961 clock_out.png','Juan R',39057,NULL,'2023-09-20 10:54:54','2023-09-25 14:45:13'),(1821,'2023-09-20 06:55:08','2023-09-20 18:11:51','12.249.250.150','12.249.250.150','closed',11,676,'attendances/1774/1695218108 clock_in.png','attendances/1774/1695258711 clock_out.png','Juan R',39049,NULL,'2023-09-20 10:55:08','2023-09-25 14:43:32'),(1822,'2023-09-20 06:55:22','2023-09-20 15:32:03','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1934/1695218122 clock_in.png','attendances/1934/1695249123 clock_out.png','Juan R',39053,NULL,'2023-09-20 10:55:22','2023-09-25 14:44:16'),(1823,'2023-09-20 06:56:26','2023-09-20 17:03:45','12.249.250.150','12.249.250.150','closed',10,607,'attendances/1999/1695218186 clock_in.png','attendances/1999/1695254625 clock_out.png','Juan R',39051,NULL,'2023-09-20 10:56:26','2023-09-25 14:43:56'),(1824,'2023-09-20 06:56:51','2023-09-20 17:03:03','12.249.250.150','12.249.250.150','closed',10,606,'attendances/974/1695218211 clock_in.png','attendances/974/1695254583 clock_out.png','Juan R',39062,NULL,'2023-09-20 10:56:51','2023-09-25 14:41:42'),(1825,'2023-09-20 06:57:04','2023-09-20 15:32:52','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1858/1695218224 clock_in.png','attendances/1858/1695249172 clock_out.png','Juan R',39056,NULL,'2023-09-20 10:57:04','2023-09-25 14:44:42'),(1826,'2023-09-20 06:57:08','2023-09-20 17:01:24','12.249.250.150','12.249.250.150','closed',10,604,'attendances/1395/1695218228 clock_in.png','attendances/1395/1695254484 clock_out.png','Juan R',39058,NULL,'2023-09-20 10:57:08','2023-09-25 14:45:44'),(1827,'2023-09-20 06:57:17','2023-09-20 15:32:39','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1958/1695218237 clock_in.png','attendances/1958/1695249159 clock_out.png','Juan R',39050,NULL,'2023-09-20 10:57:17','2023-09-25 14:43:52'),(1828,'2023-09-20 06:57:24','2023-09-20 16:59:57','12.249.250.150','12.249.250.150','closed',10,602,'attendances/1728/1695218244 clock_in.png','attendances/1728/1695254397 clock_out.png','Juan R',39055,NULL,'2023-09-20 10:57:24','2023-09-25 14:44:38'),(1829,'2023-09-20 06:57:49','2023-09-20 15:35:31','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1951/1695218269 clock_in.png','attendances/1951/1695249331 clock_out.png','Juan R',39048,NULL,'2023-09-20 10:57:49','2023-09-25 14:43:14'),(1830,'2023-09-20 07:00:20','2023-09-20 15:32:18','12.249.250.150','12.249.250.150','closed',8,511,'attendances/1888/1695218420 clock_in.png','attendances/1888/1695249138 clock_out.png','Juan R',39061,NULL,'2023-09-20 11:00:20','2023-09-25 14:49:53'),(1831,'2023-09-20 07:00:38','2023-09-20 15:39:42','12.249.250.150','12.249.250.150','closed',8,519,'attendances/1462/1695218438 clock_in.png','attendances/1462/1695249582 clock_out.png','Juan R',39052,NULL,'2023-09-20 11:00:38','2023-09-25 14:43:58'),(1832,'2023-09-20 07:00:54','2023-09-20 15:31:47','12.249.250.150','12.249.250.150','closed',8,510,'attendances/1455/1695218454 clock_in.png','attendances/1455/1695249107 clock_out.png','Juan R',39054,NULL,'2023-09-20 11:00:54','2023-09-25 14:44:24'),(1833,'2023-09-20 07:03:39','2023-09-20 14:15:18','12.249.250.150','12.249.250.150','closed',7,431,'attendances/1948/1695218619 clock_in.png','attendances/1948/1695244518 clock_out.png','Juan R',39059,NULL,'2023-09-20 11:03:39','2023-09-25 14:47:43'),(1834,'2023-09-20 08:00:15','2023-09-20 16:30:44','12.249.250.150','12.249.250.150','closed',8,510,'attendances/775/1695222015 clock_in.png','attendances/775/1695252644 clock_out.png','Juan R',39064,NULL,'2023-09-20 12:00:15','2023-09-25 14:45:47'),(1835,'2023-09-20 08:02:08','2023-09-20 16:38:59','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1869/1695222128 clock_in.png','attendances/1869/1695238499 clock_out.png','Juan R',39063,NULL,'2023-09-20 12:02:08','2023-09-25 14:42:33'),(1836,'2023-09-20 08:02:17','2023-09-20 16:39:34','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1891/1695222137 clock_in.png','attendances/1891/1695253174 clock_out.png','Juan R',39065,NULL,'2023-09-20 12:02:17','2023-09-25 14:47:35'),(1838,'2023-09-21 05:54:48','2023-09-21 18:21:24','12.249.250.150','12.249.250.150','closed',12,746,'attendances/1585/1695300888 clock_in.png','attendances/1585/1695345684 clock_out.png','Juan R',39090,NULL,'2023-09-21 09:54:48','2023-09-25 14:42:09'),(1839,'2023-09-21 05:56:04','2023-09-21 18:21:51','12.249.250.150','12.249.250.150','closed',12,745,'attendances/1551/1695300964 clock_in.png','attendances/1551/1695345711 clock_out.png','Juan R',39089,NULL,'2023-09-21 09:56:04','2023-09-25 14:42:05'),(1840,'2023-09-21 05:57:17','2023-09-21 17:42:50','12.249.250.150','12.249.250.150','closed',11,705,'attendances/1116/1695301037 clock_in.png','attendances/1116/1695343370 clock_out.png','Juan R',39094,NULL,'2023-09-21 09:57:17','2023-09-25 14:45:18'),(1841,'2023-09-21 05:57:24','2023-09-21 16:30:09','12.249.250.150','12.249.250.150','closed',10,632,'attendances/1588/1695301044 clock_in.png','attendances/1588/1695339010 clock_out.png','Juan R',39092,NULL,'2023-09-21 09:57:24','2023-09-25 14:42:36'),(1842,'2023-09-21 05:57:39','2023-09-21 16:18:43','12.249.250.150','12.249.250.150','closed',10,621,'attendances/1568/1695301059 clock_in.png','attendances/1568/1695338323 clock_out.png','Juan R',39091,NULL,'2023-09-21 09:57:39','2023-09-25 14:42:27'),(1843,'2023-09-21 05:58:23','2023-09-21 18:22:57','12.249.250.150','12.249.250.150','closed',12,744,'attendances/2025/1695301103 clock_in.png','attendances/2025/1695345777 clock_out.png','Juan R',39096,NULL,'2023-09-21 09:58:23','2023-09-25 14:49:28'),(1844,'2023-09-21 06:00:21','2023-09-21 18:22:20','12.249.250.150','12.249.250.150','closed',12,741,'attendances/2005/1695301221 clock_in.png','attendances/2005/1695345740 clock_out.png','Juan R',39093,NULL,'2023-09-21 10:00:21','2023-09-25 14:45:13'),(1845,'2023-09-21 06:00:35','2023-09-21 18:22:07','12.249.250.150','12.249.250.150','closed',12,741,'attendances/1450/1695301235 clock_in.png','attendances/1450/1695345727 clock_out.png','Juan R',39095,NULL,'2023-09-21 10:00:35','2023-09-25 14:49:14'),(1846,'2023-09-21 06:24:04','2023-09-21 16:30:23','12.249.250.150','12.249.250.150','closed',10,606,'attendances/622/1695302644 clock_in.png','attendances/622/1695339023 clock_out.png','Juan R',39110,NULL,'2023-09-21 10:24:04','2023-09-25 14:49:19'),(1847,'2023-09-21 06:51:32','2023-09-21 19:22:23','12.249.250.150','12.249.250.150','closed',12,750,'attendances/1395/1695304292 clock_in.png','attendances/1395/1695349343 clock_out.png','Juan R',39108,NULL,'2023-09-21 10:51:32','2023-09-25 14:45:44'),(1848,'2023-09-21 06:52:35','2023-09-21 20:28:41','12.249.250.150','12.249.250.150','closed',13,816,'attendances/1999/1695304355 clock_in.png','attendances/1999/1695353321 clock_out.png','Juan R',39102,NULL,'2023-09-21 10:52:35','2023-09-25 14:43:56'),(1849,'2023-09-21 06:53:20','2023-09-21 15:44:34','12.249.250.150','12.249.250.150','closed',8,531,'attendances/726/1695304400 clock_in.png','attendances/726/1695336274 clock_out.png','Juan R',39097,NULL,'2023-09-21 10:53:20','2023-09-25 14:41:46'),(1850,'2023-09-21 06:53:36','2023-09-21 16:30:35','12.249.250.150','12.249.250.150','closed',9,576,'attendances/1774/1695304416 clock_in.png','attendances/1774/1695339035 clock_out.png','Juan R',39100,NULL,'2023-09-21 10:53:36','2023-09-25 14:43:32'),(1851,'2023-09-21 06:54:07','2023-09-21 15:35:24','12.249.250.150','12.249.250.150','closed',8,521,'attendances/1934/1695304447 clock_in.png','attendances/1934/1695335724 clock_out.png','Juan R',39104,NULL,'2023-09-21 10:54:07','2023-09-25 14:44:16'),(1852,'2023-09-21 06:54:21','2023-09-21 15:35:06','12.249.250.150','12.249.250.150','closed',8,520,'attendances/1951/1695304461 clock_in.png','attendances/1951/1695335707 clock_out.png','Juan R',39099,NULL,'2023-09-21 10:54:21','2023-09-25 14:43:14'),(1853,'2023-09-21 06:55:55','2023-09-21 18:48:43','12.249.250.150','12.249.250.150','closed',11,712,'attendances/1479/1695304555 clock_in.png','attendances/1479/1695347323 clock_out.png','Juan R',39098,NULL,'2023-09-21 10:55:55','2023-09-25 14:42:47'),(1854,'2023-09-21 06:56:15','2023-09-21 19:33:22','12.249.250.150','12.249.250.150','closed',12,757,'attendances/1728/1695304575 clock_in.png','attendances/1728/1695350002 clock_out.png','Juan R',39106,NULL,'2023-09-21 10:56:15','2023-09-25 14:44:38'),(1855,'2023-09-21 06:56:35','2023-09-21 15:32:46','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1858/1695304595 clock_in.png','attendances/1858/1695335566 clock_out.png','Juan R',39107,NULL,'2023-09-21 10:56:35','2023-09-25 14:44:42'),(1856,'2023-09-21 06:56:54','2023-09-21 15:32:31','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1958/1695304614 clock_in.png','attendances/1958/1695335551 clock_out.png','Juan R',39101,NULL,'2023-09-21 10:56:54','2023-09-25 14:43:52'),(1857,'2023-09-21 06:56:55','2023-09-21 15:34:10','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1948/1695304615 clock_in.png','attendances/1948/1695335650 clock_out.png','Juan R',39109,NULL,'2023-09-21 10:56:55','2023-09-25 14:47:43'),(1858,'2023-09-21 06:57:31','2023-09-21 18:49:01','12.249.250.150','12.249.250.150','closed',11,711,'attendances/974/1695304651 clock_in.png','attendances/974/1695347341 clock_out.png','Juan R',39111,NULL,'2023-09-21 10:57:31','2023-09-25 14:41:42'),(1859,'2023-09-21 06:57:45','2023-09-21 17:11:47','12.249.250.150','12.249.250.150','closed',10,614,'attendances/1455/1695304665 clock_in.png','attendances/1455/1695341507 clock_out.png','Juan R',39105,NULL,'2023-09-21 10:57:45','2023-09-25 14:44:24'),(1860,'2023-09-21 07:01:19','2023-09-21 15:43:34','12.249.250.150','12.249.250.150','closed',8,522,'attendances/1462/1695304879 clock_in.png','attendances/1462/1695336214 clock_out.png','Juan R',39103,NULL,'2023-09-21 11:01:19','2023-09-25 14:43:58'),(1861,'2023-09-21 08:01:03','2023-09-21 16:30:45','12.249.250.150','12.249.250.150','closed',8,509,'attendances/775/1695308463 clock_in.png','attendances/775/1695339045 clock_out.png','Juan R',39113,NULL,'2023-09-21 12:01:03','2023-09-25 14:45:47'),(1862,'2023-09-21 08:04:14','2023-09-21 16:36:10','12.249.250.150','12.249.250.150','closed',8,511,'attendances/1869/1695308654 clock_in.png','attendances/1869/1695339370 clock_out.png','Juan R',39112,NULL,'2023-09-21 12:04:14','2023-09-25 14:42:33'),(1863,'2023-09-21 08:04:21','2023-09-21 16:35:52','12.249.250.150','12.249.250.150','closed',8,511,'attendances/1891/1695308661 clock_in.png','attendances/1891/1695339352 clock_out.png','Juan R',39114,NULL,'2023-09-21 12:04:21','2023-09-25 14:47:35'),(1864,'2023-09-22 04:54:32','2023-09-22 19:14:32','12.249.250.150','12.249.250.150','closed',14,860,'attendances/2005/1695383672 clock_in.png','attendances/2005/1695435272 clock_out.png','Juan R',39174,NULL,'2023-09-22 08:54:32','2023-09-25 14:45:13'),(1865,'2023-09-22 05:52:32','2023-09-22 18:02:39','12.249.250.150','12.249.250.150','closed',12,730,'attendances/1395/1695387152 clock_in.png','attendances/1395/1695430959 clock_out.png','Juan R',39171,NULL,'2023-09-22 09:52:32','2023-09-25 14:45:44'),(1866,'2023-09-22 05:54:31','2023-09-22 17:52:32','12.249.250.150','12.249.250.150','closed',11,718,'attendances/1585/1695387271 clock_in.png','attendances/1585/1695430352 clock_out.png','Juan R',39151,NULL,'2023-09-22 09:54:31','2023-09-25 14:42:09'),(1867,'2023-09-22 05:54:52','2023-09-22 17:51:11','12.249.250.150','12.249.250.150','closed',11,716,'attendances/2025/1695387292 clock_in.png','attendances/2025/1695430271 clock_out.png','Juan R',39156,NULL,'2023-09-22 09:54:52','2023-09-25 14:49:28'),(1868,'2023-09-22 05:55:47','2023-09-22 19:15:09','12.249.250.150','12.249.250.150','closed',13,799,'attendances/1588/1695387347 clock_in.png','attendances/1588/1695435309 clock_out.png','Juan R',39153,NULL,'2023-09-22 09:55:47','2023-09-25 14:42:36'),(1869,'2023-09-22 05:56:49','2023-09-22 16:21:00','12.249.250.150','12.249.250.150','closed',10,624,'attendances/1568/1695387409 clock_in.png','attendances/1568/1695402120 clock_out.png','Juan R',39152,NULL,'2023-09-22 09:56:49','2023-09-25 14:42:27'),(1870,'2023-09-22 05:56:58','2023-09-22 16:41:47','12.249.250.150','12.249.250.150','closed',10,644,'attendances/1728/1695387418 clock_in.png','attendances/1728/1695426107 clock_out.png','Juan R',39168,NULL,'2023-09-22 09:56:58','2023-09-25 14:44:38'),(1871,'2023-09-22 05:58:23','2023-09-22 18:09:48','12.249.250.150','12.249.250.150','closed',12,731,'attendances/1999/1695387503 clock_in.png','attendances/1999/1695431388 clock_out.png','Juan R',39164,NULL,'2023-09-22 09:58:23','2023-09-25 14:43:56'),(1872,'2023-09-22 05:58:54','2023-09-22 17:51:17','12.249.250.150','12.249.250.150','closed',11,712,'attendances/1479/1695387534 clock_in.png','attendances/1479/1695430277 clock_out.png','Juan R',39154,NULL,'2023-09-22 09:58:54','2023-09-25 14:42:47'),(1873,'2023-09-22 06:11:16','2023-09-22 16:32:20','12.249.250.150','12.249.250.150','closed',10,621,'attendances/1450/1695388276 clock_in.png','attendances/1450/1695425540 clock_out.png','Juan R',39155,NULL,'2023-09-22 10:11:16','2023-09-25 14:49:14'),(1874,'2023-09-22 06:25:06','2023-09-22 16:30:50','12.249.250.150','12.249.250.150','closed',10,605,'attendances/622/1695389106 clock_in.png','attendances/622/1695425450 clock_out.png','Juan R',39173,NULL,'2023-09-22 10:25:06','2023-09-25 14:49:19'),(1875,'2023-09-22 06:52:38','2023-09-22 16:30:35','12.249.250.150','12.249.250.150','closed',9,577,'attendances/1774/1695390758 clock_in.png','attendances/1774/1695425435 clock_out.png','Juan R',39162,NULL,'2023-09-22 10:52:38','2023-09-25 14:43:32'),(1876,'2023-09-22 06:53:40','2023-09-22 15:49:00','12.249.250.150','12.249.250.150','closed',8,535,'attendances/726/1695390820 clock_in.png','attendances/726/1695422940 clock_out.png','Juan R',39158,NULL,'2023-09-22 10:53:40','2023-09-25 14:41:46'),(1877,'2023-09-22 06:54:22','2023-09-22 19:41:53','12.249.250.150','12.249.250.150','closed',12,767,'attendances/1116/1695390862 clock_in.png','attendances/1116/1695436913 clock_out.png','Juan R',39170,NULL,'2023-09-22 10:54:22','2023-09-25 14:45:18'),(1878,'2023-09-22 06:55:20','2023-09-22 16:14:19','12.249.250.150','12.249.250.150','closed',9,558,'attendances/1551/1695390920 clock_in.png','attendances/1551/1695424459 clock_out.png','Juan R',39159,NULL,'2023-09-22 10:55:20','2023-09-25 14:42:05'),(1879,'2023-09-22 06:55:47','2023-09-22 15:31:21','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1934/1695390947 clock_in.png','attendances/1934/1695421881 clock_out.png','Juan R',39166,NULL,'2023-09-22 10:55:47','2023-09-25 14:44:16'),(1880,'2023-09-22 06:57:09','2023-09-22 18:38:09','12.249.250.150','12.249.250.150','closed',11,701,'attendances/382/1695391029 clock_in.png','attendances/382/1695433089 clock_out.png','Juan R',39160,NULL,'2023-09-22 10:57:09','2023-09-25 14:43:25'),(1881,'2023-09-22 06:59:08','2023-09-22 19:13:02','12.249.250.150','12.249.250.150','closed',12,733,'attendances/1951/1695391148 clock_in.png','attendances/1951/1695435182 clock_out.png','Juan R',39161,NULL,'2023-09-22 10:59:08','2023-09-25 14:43:14'),(1882,'2023-09-22 06:59:42','2023-09-22 18:02:15','12.249.250.150','12.249.250.150','closed',11,662,'attendances/974/1695391182 clock_in.png','attendances/974/1695430935 clock_out.png','Juan R',39157,NULL,'2023-09-22 10:59:42','2023-09-25 14:41:42'),(1883,'2023-09-22 07:01:06','2023-09-22 17:58:21','12.249.250.150','12.249.250.150','closed',10,657,'attendances/1455/1695391266 clock_in.png','attendances/1455/1695430701 clock_out.png','Juan R',39167,NULL,'2023-09-22 11:01:06','2023-09-25 14:44:24'),(1884,'2023-09-22 07:04:20','2023-09-22 15:39:55','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1948/1695391460 clock_in.png','attendances/1948/1695422395 clock_out.png','Juan R',39172,NULL,'2023-09-22 11:04:20','2023-09-25 14:47:43'),(1885,'2023-09-22 07:06:59','2023-09-22 15:43:21','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1462/1695391619 clock_in.png','attendances/1462/1695422601 clock_out.png','Juan R',39165,NULL,'2023-09-22 11:06:59','2023-09-25 14:43:58'),(1886,'2023-09-22 07:09:09','2023-09-22 15:36:00','12.249.250.150','12.249.250.150','closed',8,506,'attendances/1858/1695391749 clock_in.png','attendances/1858/1695422160 clock_out.png','Juan R',39169,NULL,'2023-09-22 11:09:09','2023-09-25 14:44:42'),(1887,'2023-09-22 07:10:17','2023-09-22 15:33:23','12.249.250.150','12.249.250.150','closed',8,503,'attendances/1958/1695391817 clock_in.png','attendances/1958/1695422003 clock_out.png','Juan R',39163,NULL,'2023-09-22 11:10:17','2023-09-25 14:43:52'),(1888,'2023-09-22 08:03:23','2023-09-22 16:35:27','12.249.250.150','12.249.250.150','closed',8,512,'attendances/1869/1695395003 clock_in.png','attendances/1869/1695425727 clock_out.png','Juan R',39175,NULL,'2023-09-22 12:03:23','2023-09-25 14:42:33'),(1889,'2023-09-22 08:03:37','2023-09-22 13:15:00','12.249.250.150','','closed',5,311,'attendances/1891/1695395017 clock_in.png',NULL,'Juan R',39176,NULL,'2023-09-22 12:03:37','2023-09-25 14:47:35'),(1892,'2023-09-23 05:52:27','2023-09-23 14:32:05','12.249.250.150','12.249.250.150','closed',8,519,'attendances/1774/1695473547 clock_in.png','attendances/1774/1695504725 clock_out.png','Juan R',39283,NULL,'2023-09-23 09:52:27','2023-09-25 14:43:32'),(1893,'2023-09-23 05:53:18','2023-09-23 18:31:18','12.249.250.150','12.249.250.150','closed',12,758,'attendances/382/1695473598 clock_in.png','attendances/382/1695519078 clock_out.png','Juan R',39282,NULL,'2023-09-23 09:53:18','2023-09-25 14:43:25'),(1894,'2023-09-23 05:54:21','2023-09-23 14:31:52','12.249.250.150','12.249.250.150','closed',8,517,'attendances/622/1695473661 clock_in.png','attendances/622/1695504712 clock_out.png','Juan R',39285,NULL,'2023-09-23 09:54:21','2023-09-25 14:49:19'),(1895,'2023-09-23 05:56:12','2023-09-23 14:33:01','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1934/1695473772 clock_in.png','attendances/1934/1695504781 clock_out.png','Juan R',39284,NULL,'2023-09-23 09:56:12','2023-09-25 14:44:16'),(1898,'2023-09-23 06:35:00','2023-09-23 10:32:00','179.32.223.91','179.32.223.91','closed',3,237,NULL,NULL,'Juan R',39327,NULL,'2023-09-23 20:08:06','2023-09-25 14:42:33'),(1899,'2023-09-23 06:35:00','2023-09-23 10:32:00','179.32.223.91','179.32.223.91','closed',3,237,NULL,NULL,'Juan R',39328,NULL,'2023-09-23 20:37:17','2023-09-25 14:47:35'),(1903,'2023-09-24 04:58:00','2023-09-24 14:00:00','181.234.23.27','181.234.23.27','closed',9,542,NULL,NULL,'Juan R',39333,NULL,'2023-09-24 18:57:45','2023-09-25 14:45:13'),(1904,'2023-09-25 04:54:36','2023-09-25 19:33:37','12.249.250.150','12.249.250.150','closed',14,879,'attendances/1585/1695642876 clock_in.png','attendances/1585/1695695617 clock_out.png','Juan R',39300,NULL,'2023-09-25 08:54:36','2023-10-02 13:51:43'),(1905,'2023-09-25 04:55:23','2023-09-25 18:50:11','12.249.250.150','12.249.250.150','closed',13,834,'attendances/1588/1695642923 clock_in.png','attendances/1588/1695693011 clock_out.png','Juan R',39302,NULL,'2023-09-25 08:55:23','2023-10-02 13:51:57'),(1906,'2023-09-25 04:56:10','2023-09-25 19:50:00','12.249.250.150','191.93.224.204','closed',14,893,'attendances/1551/1695642970 clock_in.png',NULL,'Juan R',39299,NULL,'2023-09-25 08:56:10','2023-10-02 13:50:35'),(1907,'2023-09-25 04:56:59','2023-09-25 16:40:49','12.249.250.150','12.249.250.150','closed',11,703,'attendances/1568/1695643019 clock_in.png','attendances/1568/1695685249 clock_out.png','Juan R',39301,NULL,'2023-09-25 08:56:59','2023-10-02 13:51:48'),(1908,'2023-09-25 04:57:29','2023-09-25 19:32:21','12.249.250.150','12.249.250.150','closed',14,874,'attendances/2005/1695643049 clock_in.png','attendances/2005/1695695541 clock_out.png','Juan R',39303,NULL,'2023-09-25 08:57:29','2023-10-02 13:52:54'),(1909,'2023-09-25 05:56:11','2023-09-25 18:28:19','12.249.250.150','12.249.250.150','closed',12,752,'attendances/1450/1695646571 clock_in.png','attendances/1450/1695691699 clock_out.png','Juan R',39308,NULL,'2023-09-25 09:56:11','2023-10-02 13:53:51'),(1910,'2023-09-25 05:58:12','2023-09-25 15:14:46','12.249.250.150','12.249.250.150','closed',9,556,'attendances/2025/1695646692 clock_in.png','attendances/2025/1695680086 clock_out.png','Juan R',39309,NULL,'2023-09-25 09:58:12','2023-10-02 13:54:13'),(1911,'2023-09-25 06:03:49','2023-09-25 17:16:12','12.249.250.150','12.249.250.150','closed',11,672,'attendances/382/1695647029 clock_in.png','attendances/382/1695687372 clock_out.png','Juan R',39305,NULL,'2023-09-25 10:03:49','2023-10-02 13:52:11'),(1912,'2023-09-25 06:22:39','2023-09-25 16:31:22','12.249.250.150','12.249.250.150','closed',10,608,'attendances/622/1695648159 clock_in.png','attendances/622/1695684682 clock_out.png','Juan R',39320,NULL,'2023-09-25 10:22:39','2023-10-02 13:54:11'),(1913,'2023-09-25 06:23:20','2023-09-25 17:12:10','12.249.250.150','12.249.250.150','closed',10,648,'attendances/726/1695648200 clock_in.png','attendances/726/1695687130 clock_out.png','Juan R',39304,NULL,'2023-09-25 10:23:20','2023-10-02 13:50:28'),(1914,'2023-09-25 06:05:11','2023-09-25 18:29:14','190.2.214.172','12.249.250.150','closed',12,744,'attendances/1455/1695648252 clock_in.png','attendances/1455/1695691754 clock_out.png','Juan R',39307,NULL,'2023-09-25 10:24:12','2023-10-02 13:52:41'),(1915,'2023-09-25 06:24:48','2023-09-25 18:49:51','12.249.250.150','12.249.250.150','closed',12,745,'attendances/1116/1695648288 clock_in.png','attendances/1116/1695692991 clock_out.png','Juan R',39310,NULL,'2023-09-25 10:24:48','2023-10-02 13:53:15'),(1916,'2023-09-25 06:52:55','2023-09-25 15:42:43','12.249.250.150','12.249.250.150','closed',8,529,'attendances/1479/1695649975 clock_in.png','attendances/1479/1695681763 clock_out.png','Juan R',39311,NULL,'2023-09-25 10:52:55','2023-10-02 13:52:02'),(1917,'2023-09-25 06:53:06','2023-09-25 16:31:36','12.249.250.150','12.249.250.150','closed',9,578,'attendances/1774/1695649986 clock_in.png','attendances/1774/1695684696 clock_out.png','Juan R',39312,NULL,'2023-09-25 10:53:06','2023-10-02 13:52:26'),(1918,'2023-09-25 06:53:12','2023-09-25 21:20:45','12.249.250.150','12.249.250.150','closed',14,867,'attendances/1395/1695649992 clock_in.png','attendances/1395/1695702045 clock_out.png','Juan R',39318,NULL,'2023-09-25 10:53:12','2023-10-02 13:53:27'),(1919,'2023-09-25 06:55:25','2023-09-25 15:43:34','12.249.250.150','12.249.250.150','closed',8,528,'attendances/1728/1695650125 clock_in.png','attendances/1728/1695681814 clock_out.png','Juan R',39316,NULL,'2023-09-25 10:55:25','2023-10-02 13:52:48'),(1920,'2023-09-25 06:55:38','2023-09-25 13:08:09','12.249.250.150','12.249.250.150','closed',6,372,'attendances/1999/1695650138 clock_in.png','attendances/1999/1695672489 clock_out.png','Juan R',39314,NULL,'2023-09-25 10:55:38','2023-10-02 13:52:33'),(1921,'2023-09-25 06:55:52','2023-09-25 15:31:53','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1858/1695650152 clock_in.png','attendances/1858/1695681113 clock_out.png','Juan R',39317,NULL,'2023-09-25 10:55:52','2023-10-02 13:52:51'),(1922,'2023-09-25 06:56:18','2023-09-25 15:31:07','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1934/1695650178 clock_in.png','attendances/1934/1695681067 clock_out.png','Juan R',39315,NULL,'2023-09-25 10:56:18','2023-10-02 13:52:39'),(1923,'2023-09-25 06:57:16','2023-09-25 13:02:57','12.249.250.150','12.249.250.150','closed',6,365,'attendances/1958/1695650236 clock_in.png','attendances/1958/1695672177 clock_out.png','Juan R',39313,NULL,'2023-09-25 10:57:16','2023-10-02 13:52:29'),(1924,'2023-09-25 06:58:22','2023-09-25 15:35:00','12.249.250.150','179.32.215.235','closed',8,516,'attendances/974/1695650302 clock_in.png',NULL,'Juan R',39321,NULL,'2023-09-25 10:58:22','2023-10-02 13:50:05'),(1925,'2023-09-25 06:59:07','2023-09-25 15:33:28','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1951/1695650347 clock_in.png','attendances/1951/1695681208 clock_out.png','Juan R',39306,NULL,'2023-09-25 10:59:07','2023-10-02 13:52:05'),(1926,'2023-09-25 07:07:27','2023-09-25 16:02:27','12.249.250.150','12.249.250.150','closed',8,535,'attendances/1948/1695650847 clock_in.png','attendances/1948/1695682947 clock_out.png','Juan R',39319,NULL,'2023-09-25 11:07:27','2023-10-02 13:53:48'),(1927,'2023-09-25 08:00:18','2023-09-25 16:32:38','12.249.250.150','12.249.250.150','closed',8,512,'attendances/775/1695654018 clock_in.png','attendances/775/1695684758 clock_out.png','Juan R',39323,NULL,'2023-09-25 12:00:18','2023-10-02 13:53:31'),(1928,'2023-09-25 08:02:58','2023-09-25 16:40:37','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1869/1695654178 clock_in.png','attendances/1869/1695685237 clock_out.png','Juan R',39322,NULL,'2023-09-25 12:02:58','2023-10-02 13:51:54'),(1929,'2023-09-25 08:03:06','2023-09-25 16:39:47','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1891/1695654186 clock_in.png','attendances/1891/1695685187 clock_out.png','Juan R',39324,NULL,'2023-09-25 12:03:06','2023-10-02 13:53:34'),(1930,'2023-09-25 08:08:02','2023-09-25 16:04:59','12.249.250.150','12.249.250.150','closed',7,476,'attendances/1462/1695654482 clock_in.png','attendances/1462/1695683099 clock_out.png','Juan R',39326,NULL,'2023-09-25 12:08:02','2023-10-02 13:52:36'),(1933,'2023-09-26 05:01:09','2023-09-26 23:04:47','12.249.250.150','12.249.250.150','closed',18,1083,'attendances/1455/1695729669 clock_in.png','attendances/1455/1695794687 clock_out.png','Juan R',39376,NULL,'2023-09-26 09:01:09','2023-10-02 13:52:41'),(1934,'2023-09-26 05:23:38','2023-09-26 20:00:03','12.249.250.150','12.249.250.150','closed',14,876,'attendances/2025/1695731018 clock_in.png','attendances/2025/1695783603 clock_out.png','Juan R',39379,NULL,'2023-09-26 09:23:38','2023-10-02 13:54:13'),(1935,'2023-09-26 05:23:57','2023-09-26 20:04:44','12.249.250.150','12.249.250.150','closed',14,880,'attendances/1585/1695731037 clock_in.png','attendances/1585/1695783884 clock_out.png','Juan R',39375,NULL,'2023-09-26 09:23:57','2023-10-02 13:51:43'),(1936,'2023-09-26 05:26:01','2023-09-26 19:59:35','12.249.250.150','12.249.250.150','closed',14,873,'attendances/1551/1695731161 clock_in.png','attendances/1551/1695783575 clock_out.png','Juan R',39374,NULL,'2023-09-26 09:26:01','2023-10-02 13:50:35'),(1937,'2023-09-26 05:26:45','2023-09-26 19:59:08','12.249.250.150','12.249.250.150','closed',14,872,'attendances/2005/1695731205 clock_in.png','attendances/2005/1695783548 clock_out.png','Juan R',39377,NULL,'2023-09-26 09:26:45','2023-10-02 13:52:54'),(1938,'2023-09-26 05:27:24','2023-09-26 20:01:22','12.249.250.150','12.249.250.150','closed',14,873,'attendances/1450/1695731244 clock_in.png','attendances/1450/1695783682 clock_out.png','Juan R',39378,NULL,'2023-09-26 09:27:24','2023-10-02 13:53:51'),(1939,'2023-09-26 05:54:06','2023-09-26 15:42:35','12.249.250.150','12.249.250.150','closed',9,588,'attendances/1588/1695732846 clock_in.png','attendances/1588/1695768155 clock_out.png','Juan R',39382,NULL,'2023-09-26 09:54:06','2023-10-02 13:51:57'),(1940,'2023-09-26 05:55:06','2023-09-26 15:38:18','12.249.250.150','12.249.250.150','closed',9,583,'attendances/726/1695732906 clock_in.png','attendances/726/1695767898 clock_out.png','Juan R',39380,NULL,'2023-09-26 09:55:06','2023-10-02 13:50:28'),(1941,'2023-09-26 05:58:25','2023-09-26 15:42:22','12.249.250.150','12.249.250.150','closed',9,583,'attendances/1568/1695733105 clock_in.png','attendances/1568/1695768142 clock_out.png','Juan R',39381,NULL,'2023-09-26 09:58:25','2023-10-02 13:51:48'),(1942,'2023-09-26 06:45:30','2023-09-26 16:33:26','12.249.250.150','12.249.250.150','closed',9,587,'attendances/622/1695735930 clock_in.png','attendances/622/1695771206 clock_out.png','Juan R',39396,NULL,'2023-09-26 10:45:30','2023-10-02 13:54:11'),(1943,'2023-09-26 06:47:49','2023-09-26 15:50:17','12.249.250.150','12.249.250.150','closed',9,542,'attendances/382/1695736069 clock_in.png','attendances/382/1695768617 clock_out.png','Juan R',39384,NULL,'2023-09-26 10:47:49','2023-10-02 13:52:11'),(1944,'2023-09-26 06:52:28','2023-09-26 16:31:09','12.249.250.150','12.249.250.150','closed',9,578,'attendances/1774/1695736348 clock_in.png','attendances/1774/1695771069 clock_out.png','Juan R',39386,NULL,'2023-09-26 10:52:28','2023-10-02 13:52:26'),(1945,'2023-09-26 06:53:46','2023-09-26 20:34:53','12.249.250.150','12.249.250.150','closed',13,821,'attendances/1116/1695736427 clock_in.png','attendances/1116/1695785693 clock_out.png','Juan R',39393,NULL,'2023-09-26 10:53:47','2023-10-02 13:53:15'),(1946,'2023-09-26 06:54:19','2023-09-26 17:37:04','12.249.250.150','12.249.250.150','closed',10,642,'attendances/1395/1695736459 clock_in.png','attendances/1395/1695775024 clock_out.png','Juan R',39394,NULL,'2023-09-26 10:54:19','2023-10-02 13:53:27'),(1947,'2023-09-26 06:55:31','2023-09-26 16:07:25','12.249.250.150','12.249.250.150','closed',9,551,'attendances/1951/1695736531 clock_in.png','attendances/1951/1695769645 clock_out.png','Juan R',39385,NULL,'2023-09-26 10:55:31','2023-10-02 13:52:05'),(1948,'2023-09-26 06:55:47','2023-09-26 17:27:11','12.249.250.150','12.249.250.150','closed',10,631,'attendances/1728/1695736547 clock_in.png','attendances/1728/1695774431 clock_out.png','Juan R',39391,NULL,'2023-09-26 10:55:47','2023-10-02 13:52:48'),(1949,'2023-09-26 06:55:51','2023-09-26 15:33:53','12.249.250.150','12.249.250.150','closed',8,518,'attendances/1934/1695736551 clock_in.png','attendances/1934/1695767633 clock_out.png','Juan R',39390,NULL,'2023-09-26 10:55:51','2023-10-02 13:52:39'),(1950,'2023-09-26 06:56:31','2023-09-26 17:23:24','12.249.250.150','12.249.250.150','closed',10,626,'attendances/1479/1695736591 clock_in.png','attendances/1479/1695774204 clock_out.png','Juan R',39383,NULL,'2023-09-26 10:56:31','2023-10-02 13:52:02'),(1951,'2023-09-26 06:56:34','2023-09-26 15:33:36','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1858/1695736594 clock_in.png','attendances/1858/1695767616 clock_out.png','Juan R',39392,NULL,'2023-09-26 10:56:34','2023-10-02 13:52:51'),(1952,'2023-09-26 06:56:43','2023-09-26 17:36:50','12.249.250.150','12.249.250.150','closed',10,640,'attendances/1999/1695736603 clock_in.png','attendances/1999/1695775010 clock_out.png','Juan R',39388,NULL,'2023-09-26 10:56:43','2023-10-02 13:52:33'),(1953,'2023-09-26 06:56:56','2023-09-26 15:36:46','12.249.250.150','12.249.250.150','closed',8,519,'attendances/1948/1695736616 clock_in.png','attendances/1948/1695767806 clock_out.png','Juan R',39395,NULL,'2023-09-26 10:56:56','2023-10-02 13:53:48'),(1954,'2023-09-26 06:58:34','2023-09-26 17:29:04','12.249.250.150','12.249.250.150','closed',10,630,'attendances/974/1695736714 clock_in.png','attendances/974/1695774544 clock_out.png','Juan R',39397,NULL,'2023-09-26 10:58:34','2023-10-02 13:50:05'),(1955,'2023-09-26 07:01:19','2023-09-26 15:33:18','12.249.250.150','12.249.250.150','closed',8,511,'attendances/1958/1695736879 clock_in.png','attendances/1958/1695767598 clock_out.png','Juan R',39387,NULL,'2023-09-26 11:01:19','2023-10-02 13:52:29'),(1956,'2023-09-26 07:04:40','2023-09-26 15:58:56','12.249.250.150','12.249.250.150','closed',8,534,'attendances/1462/1695737080 clock_in.png','attendances/1462/1695769136 clock_out.png','Juan R',39389,NULL,'2023-09-26 11:04:40','2023-10-02 13:52:36'),(1957,'2023-09-26 07:59:41','2023-09-26 16:31:20','12.249.250.150','12.249.250.150','closed',8,511,'attendances/775/1695740381 clock_in.png','attendances/775/1695771080 clock_out.png','Juan R',39399,NULL,'2023-09-26 11:59:41','2023-10-02 13:53:31'),(1958,'2023-09-26 08:05:11','2023-09-26 16:34:16','12.249.250.150','12.249.250.150','closed',8,509,'attendances/1869/1695740711 clock_in.png','attendances/1869/1695771256 clock_out.png','Juan R',39398,NULL,'2023-09-26 12:05:11','2023-10-02 13:51:54'),(1959,'2023-09-26 08:05:24','2023-09-26 16:34:43','12.249.250.150','12.249.250.150','closed',8,509,'attendances/1891/1695740724 clock_in.png','attendances/1891/1695771283 clock_out.png','Juan R',39400,NULL,'2023-09-26 12:05:24','2023-10-02 13:53:34'),(1960,'2023-09-27 05:55:15','2023-09-27 14:35:42','12.249.250.150','12.249.250.150','closed',8,520,'attendances/726/1695819315 clock_in.png','attendances/726/1695850542 clock_out.png','Juan R',39515,NULL,'2023-09-27 09:55:15','2023-10-02 13:50:28'),(1961,'2023-09-27 05:55:30','2023-09-27 19:45:38','12.249.250.150','12.249.250.150','closed',13,830,'attendances/1585/1695819330 clock_in.png','attendances/1585/1695869138 clock_out.png','Juan R',39517,NULL,'2023-09-27 09:55:30','2023-10-02 13:51:43'),(1962,'2023-09-27 05:55:44','2023-09-27 19:47:35','12.249.250.150','12.249.250.150','closed',13,831,'attendances/1551/1695819344 clock_in.png','attendances/1551/1695869255 clock_out.png','Juan R',39516,NULL,'2023-09-27 09:55:44','2023-10-02 13:50:35'),(1963,'2023-09-27 05:56:06','2023-09-27 19:45:52','12.249.250.150','12.249.250.150','closed',13,829,'attendances/2025/1695819366 clock_in.png','attendances/2025/1695869152 clock_out.png','Juan R',39525,NULL,'2023-09-27 09:56:06','2023-10-02 13:54:13'),(1964,'2023-09-27 05:56:19','2023-09-27 19:47:16','12.249.250.150','12.249.250.150','closed',13,830,'attendances/2005/1695819379 clock_in.png','attendances/2005/1695869236 clock_out.png','Juan R',39523,NULL,'2023-09-27 09:56:19','2023-10-02 13:52:54'),(1965,'2023-09-27 06:00:31','2023-09-27 15:50:42','12.249.250.150','12.249.250.150','closed',9,590,'attendances/1588/1695819631 clock_in.png','attendances/1588/1695855042 clock_out.png','Juan R',39519,NULL,'2023-09-27 10:00:31','2023-10-02 13:51:57'),(1966,'2023-09-27 06:00:59','2023-09-27 15:48:10','12.249.250.150','12.249.250.150','closed',9,587,'attendances/1568/1695819659 clock_in.png','attendances/1568/1695854890 clock_out.png','Juan R',39518,NULL,'2023-09-27 10:00:59','2023-10-02 13:51:48'),(1967,'2023-09-27 06:02:21','2023-09-27 15:31:46','12.249.250.150','12.249.250.150','closed',9,569,'attendances/1951/1695819741 clock_in.png','attendances/1951/1695853906 clock_out.png','Juan R',39521,NULL,'2023-09-27 10:02:21','2023-10-02 13:52:05'),(1968,'2023-09-27 06:03:27','2023-09-27 15:04:49','12.249.250.150','12.249.250.150','closed',9,541,'attendances/1450/1695819807 clock_in.png','attendances/1450/1695852289 clock_out.png','Juan R',39524,NULL,'2023-09-27 10:03:27','2023-10-02 13:53:51'),(1969,'2023-09-27 06:04:13','2023-09-27 19:47:31','12.249.250.150','12.249.250.150','closed',13,823,'attendances/382/1695819853 clock_in.png','attendances/382/1695869251 clock_out.png','Juan R',39520,NULL,'2023-09-27 10:04:13','2023-10-02 13:52:11'),(1970,'2023-09-27 06:08:57','2023-09-27 14:35:10','12.249.250.150','12.249.250.150','closed',8,506,'attendances/1455/1695820137 clock_in.png','attendances/1455/1695850510 clock_out.png','Juan R',39522,NULL,'2023-09-27 10:08:57','2023-10-02 13:52:41'),(1971,'2023-09-27 06:14:31','2023-09-27 16:31:09','12.249.250.150','12.249.250.150','closed',10,616,'attendances/622/1695820471 clock_in.png','attendances/622/1695857469 clock_out.png','Juan R',39513,NULL,'2023-09-27 10:14:31','2023-10-02 13:54:11'),(1972,'2023-09-27 06:50:55','2023-09-27 17:50:33','12.249.250.150','181.234.10.174','closed',10,659,'attendances/1395/1695822655 clock_in.png','attendances/1395/1695839673 clock_out.png','Juan R',39511,NULL,'2023-09-27 10:50:55','2023-10-02 13:53:27'),(1973,'2023-09-27 06:52:56','2023-09-27 17:44:10','12.249.250.150','12.249.250.150','closed',10,651,'attendances/1999/1695822776 clock_in.png','attendances/1999/1695861850 clock_out.png','Juan R',39505,NULL,'2023-09-27 10:52:56','2023-10-02 13:52:33'),(1974,'2023-09-27 06:53:31','2023-09-27 17:12:47','12.249.250.150','12.249.250.150','closed',10,619,'attendances/1116/1695822811 clock_in.png','attendances/1116/1695859967 clock_out.png','Juan R',39510,NULL,'2023-09-27 10:53:31','2023-10-02 13:53:15'),(1975,'2023-09-27 06:55:10','2023-09-27 18:47:56','12.249.250.150','12.249.250.150','closed',11,712,'attendances/1479/1695822910 clock_in.png','attendances/1479/1695865676 clock_out.png','Juan R',39502,NULL,'2023-09-27 10:55:10','2023-10-02 13:52:02'),(1976,'2023-09-27 06:55:20','2023-09-27 15:31:31','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1934/1695822920 clock_in.png','attendances/1934/1695853891 clock_out.png','Juan R',39507,NULL,'2023-09-27 10:55:20','2023-10-02 13:52:39'),(1977,'2023-09-27 06:55:34','2023-09-27 16:31:21','12.249.250.150','12.249.250.150','closed',9,575,'attendances/1774/1695822934 clock_in.png','attendances/1774/1695857481 clock_out.png','Juan R',39503,NULL,'2023-09-27 10:55:34','2023-10-02 13:52:26'),(1978,'2023-09-27 06:55:55','2023-09-27 15:31:15','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1958/1695822955 clock_in.png','attendances/1958/1695853875 clock_out.png','Juan R',39504,NULL,'2023-09-27 10:55:55','2023-10-02 13:52:29'),(1979,'2023-09-27 06:55:58','2023-09-27 17:44:32','12.249.250.150','12.249.250.150','closed',10,648,'attendances/1728/1695822958 clock_in.png','attendances/1728/1695861872 clock_out.png','Juan R',39508,NULL,'2023-09-27 10:55:58','2023-10-02 13:52:48'),(1980,'2023-09-27 06:56:10','2023-09-27 15:31:04','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1858/1695822970 clock_in.png','attendances/1858/1695853864 clock_out.png','Juan R',39509,NULL,'2023-09-27 10:56:10','2023-10-02 13:52:51'),(1981,'2023-09-27 06:56:19','2023-09-27 16:48:26','12.249.250.150','12.249.250.150','closed',9,592,'attendances/974/1695822979 clock_in.png','attendances/974/1695858506 clock_out.png','Juan R',39498,NULL,'2023-09-27 10:56:19','2023-10-02 13:50:05'),(1982,'2023-09-27 06:57:09','2023-09-27 15:33:02','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1948/1695823030 clock_in.png','attendances/1948/1695853982 clock_out.png','Juan R',39512,NULL,'2023-09-27 10:57:10','2023-10-02 13:53:48'),(1983,'2023-09-27 07:00:49','2023-09-27 15:31:50','12.249.250.150','12.249.250.150','closed',8,511,'attendances/1888/1695823249 clock_in.png','attendances/1888/1695853910 clock_out.png','Juan R',39514,NULL,'2023-09-27 11:00:49','2023-10-02 13:54:23'),(1984,'2023-09-27 07:03:17','2023-09-27 15:32:47','12.249.250.150','12.249.250.150','closed',8,509,'attendances/1462/1695823397 clock_in.png','attendances/1462/1695853967 clock_out.png','Juan R',39506,NULL,'2023-09-27 11:03:17','2023-10-02 13:52:36'),(1985,'2023-09-27 07:58:43','2023-09-27 16:30:38','12.249.250.150','12.249.250.150','closed',8,511,'attendances/775/1695826723 clock_in.png','attendances/775/1695857438 clock_out.png','Juan R',39500,NULL,'2023-09-27 11:58:43','2023-10-02 13:53:31'),(1986,'2023-09-27 08:03:00','2023-09-27 16:33:42','12.249.250.150','12.249.250.150','closed',8,510,'attendances/1869/1695826980 clock_in.png','attendances/1869/1695857622 clock_out.png','Juan R',39499,NULL,'2023-09-27 12:03:00','2023-10-02 13:51:54'),(1987,'2023-09-27 08:03:07','2023-09-27 16:33:33','12.249.250.150','12.249.250.150','closed',8,510,'attendances/1891/1695826987 clock_in.png','attendances/1891/1695857613 clock_out.png','Juan R',39501,NULL,'2023-09-27 12:03:07','2023-10-02 13:53:34'),(1988,'2023-09-28 05:54:37','2023-09-28 18:22:26','12.249.250.150','12.249.250.150','closed',12,747,'attendances/1585/1695905677 clock_in.png','attendances/1585/1695950546 clock_out.png','Juan R',39552,NULL,'2023-09-28 09:54:37','2023-10-02 13:51:43'),(1989,'2023-09-28 05:54:58','2023-09-28 18:20:33','12.249.250.150','12.249.250.150','closed',12,745,'attendances/2005/1695905698 clock_in.png','attendances/2005/1695950433 clock_out.png','Juan R',39556,NULL,'2023-09-28 09:54:58','2023-10-02 13:52:54'),(1990,'2023-09-28 05:55:30','2023-09-28 14:32:24','12.249.250.150','12.249.250.150','closed',8,516,'attendances/726/1695905730 clock_in.png','attendances/726/1695936744 clock_out.png','Juan R',39551,NULL,'2023-09-28 09:55:30','2023-10-02 13:50:28'),(1991,'2023-09-28 05:56:01','2023-09-28 15:44:39','12.249.250.150','12.249.250.150','closed',9,588,'attendances/1588/1695905761 clock_in.png','attendances/1588/1695941079 clock_out.png','Juan R',39554,NULL,'2023-09-28 09:56:01','2023-10-02 13:51:57'),(1992,'2023-09-28 05:56:44','2023-09-28 18:19:58','12.249.250.150','12.249.250.150','closed',12,743,'attendances/2025/1695905804 clock_in.png','attendances/2025/1695950398 clock_out.png','Juan R',39557,NULL,'2023-09-28 09:56:44','2023-10-02 13:54:13'),(1993,'2023-09-28 05:58:33','2023-09-28 15:40:58','12.249.250.150','12.249.250.150','closed',9,582,'attendances/1568/1695905913 clock_in.png','attendances/1568/1695940858 clock_out.png','Juan R',39553,NULL,'2023-09-28 09:58:33','2023-10-02 13:51:48'),(1994,'2023-09-28 05:59:10','2023-09-28 15:30:21','12.249.250.150','12.249.250.150','closed',9,571,'attendances/1951/1695905950 clock_in.png','attendances/1951/1695940221 clock_out.png','Juan R',39555,NULL,'2023-09-28 09:59:10','2023-10-02 13:52:05'),(1995,'2023-09-28 06:08:51','2023-09-28 16:31:42','12.249.250.150','191.93.224.204','closed',10,622,'attendances/622/1695906531 clock_in.png','attendances/622/1695922122 clock_out.png','Juan R',39569,NULL,'2023-09-28 10:08:51','2023-10-02 13:54:11'),(1996,'2023-09-28 06:30:11','2023-09-28 16:43:59','12.249.250.150','12.249.250.150','closed',10,613,'attendances/1450/1695907811 clock_in.png','attendances/1450/1695944639 clock_out.png','Juan R',39550,NULL,'2023-09-28 10:30:11','2023-10-02 13:53:51'),(1997,'2023-09-28 06:30:57','2023-09-28 16:34:53','12.249.250.150','12.249.250.150','closed',10,603,'attendances/1551/1695907857 clock_in.png','attendances/1551/1695944093 clock_out.png','Juan R',39548,NULL,'2023-09-28 10:30:57','2023-10-02 13:50:35'),(1998,'2023-09-28 06:33:40','2023-09-28 16:34:39','12.249.250.150','12.249.250.150','closed',10,600,'attendances/1455/1695908020 clock_in.png','attendances/1455/1695944079 clock_out.png','Juan R',39549,NULL,'2023-09-28 10:33:40','2023-10-02 13:52:41'),(1999,'2023-09-28 06:50:52','2023-09-28 16:31:11','12.249.250.150','12.249.250.150','closed',9,580,'attendances/1774/1695909052 clock_in.png','attendances/1774/1695943871 clock_out.png','Juan R',39559,NULL,'2023-09-28 10:50:52','2023-10-02 13:52:26'),(2000,'2023-09-28 06:53:42','2023-09-28 19:08:07','12.249.250.150','12.249.250.150','closed',12,734,'attendances/1395/1695909222 clock_in.png','attendances/1395/1695953287 clock_out.png','Juan R',39567,NULL,'2023-09-28 10:53:42','2023-10-02 13:53:27'),(2001,'2023-09-28 06:54:05','2023-09-28 18:34:06','12.249.250.150','12.249.250.150','closed',11,700,'attendances/1116/1695909245 clock_in.png','attendances/1116/1695951246 clock_out.png','Juan R',39566,NULL,'2023-09-28 10:54:05','2023-10-02 13:53:15'),(2002,'2023-09-28 06:54:19','2023-09-28 18:33:26','12.249.250.150','12.249.250.150','closed',11,699,'attendances/1999/1695909259 clock_in.png','attendances/1999/1695951206 clock_out.png','Juan R',39561,NULL,'2023-09-28 10:54:19','2023-10-02 13:52:33'),(2003,'2023-09-28 06:55:34','2023-09-28 15:44:31','12.249.250.150','12.249.250.150','closed',8,528,'attendances/1948/1695909334 clock_in.png','attendances/1948/1695941071 clock_out.png','Juan R',39568,NULL,'2023-09-28 10:55:34','2023-10-02 13:53:48'),(2004,'2023-09-28 06:55:42','2023-09-28 15:30:50','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1934/1695909342 clock_in.png','attendances/1934/1695940250 clock_out.png','Juan R',39563,NULL,'2023-09-28 10:55:42','2023-10-02 13:52:39'),(2005,'2023-09-28 06:56:17','2023-09-28 18:33:42','12.249.250.150','12.249.250.150','closed',11,697,'attendances/974/1695909377 clock_in.png','attendances/974/1695951222 clock_out.png','Juan R',39571,NULL,'2023-09-28 10:56:17','2023-10-02 13:50:05'),(2006,'2023-09-28 06:57:01','2023-09-28 19:11:22','12.249.250.150','12.249.250.150','closed',12,734,'attendances/1728/1695909421 clock_in.png','attendances/1728/1695953482 clock_out.png','Juan R',39564,NULL,'2023-09-28 10:57:01','2023-10-02 13:52:48'),(2007,'2023-09-28 06:57:24','2023-09-28 15:32:02','12.249.250.150','12.249.250.150','closed',8,514,'attendances/775/1695909444 clock_in.png','attendances/775/1695940322 clock_out.png','Juan R',39574,NULL,'2023-09-28 10:57:24','2023-10-02 13:53:31'),(2008,'2023-09-28 06:58:01','2023-09-28 15:32:37','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1958/1695909481 clock_in.png','attendances/1958/1695940357 clock_out.png','Juan R',39560,NULL,'2023-09-28 10:58:01','2023-10-02 13:52:29'),(2009,'2023-09-28 07:01:34','2023-09-28 15:50:40','12.249.250.150','12.249.250.150','closed',8,529,'attendances/1888/1695909694 clock_in.png','attendances/1888/1695941440 clock_out.png','Juan R',39570,NULL,'2023-09-28 11:01:34','2023-10-02 13:54:23'),(2010,'2023-09-28 07:05:39','2023-09-28 15:40:18','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1462/1695909939 clock_in.png','attendances/1462/1695940818 clock_out.png','Juan R',39562,NULL,'2023-09-28 11:05:39','2023-10-02 13:52:36'),(2011,'2023-09-28 07:11:59','2023-09-28 15:32:54','12.249.250.150','12.249.250.150','closed',8,500,'attendances/1858/1695910319 clock_in.png','attendances/1858/1695940374 clock_out.png','Juan R',39565,NULL,'2023-09-28 11:11:59','2023-10-02 13:52:51'),(2012,'2023-09-28 07:30:43','2023-09-28 20:01:06','12.249.250.150','12.249.250.150','closed',12,750,'attendances/382/1695911443 clock_in.png','attendances/382/1695956466 clock_out.png','Juan R',39558,NULL,'2023-09-28 11:30:43','2023-10-02 13:52:11'),(2013,'2023-09-28 08:02:58','2023-09-28 16:32:54','12.249.250.150','12.249.250.150','closed',8,509,'attendances/1869/1695913378 clock_in.png','attendances/1869/1695943974 clock_out.png','Juan R',39572,NULL,'2023-09-28 12:02:58','2023-10-02 13:51:54'),(2014,'2023-09-28 08:03:13','2023-09-28 16:31:54','12.249.250.150','12.249.250.150','closed',8,508,'attendances/1891/1695913393 clock_in.png','attendances/1891/1695943914 clock_out.png','Juan R',39575,NULL,'2023-09-28 12:03:13','2023-10-02 13:53:34'),(2015,'2023-09-28 08:24:12','2023-09-28 17:05:04','12.249.250.150','12.249.250.150','closed',8,520,'attendances/1479/1695914652 clock_in.png','attendances/1479/1695945904 clock_out.png','Juan R',39573,NULL,'2023-09-28 12:24:12','2023-10-02 13:52:02'),(2017,'2023-09-29 04:57:35','2023-09-29 12:55:46','12.249.250.150','12.249.250.150','closed',7,478,'attendances/2005/1695988655 clock_in.png','attendances/2005/1696017346 clock_out.png','Juan R',39633,NULL,'2023-09-29 08:57:35','2023-10-02 13:52:54'),(2018,'2023-09-29 05:56:21','2023-09-29 16:04:40','12.249.250.150','12.249.250.150','closed',10,608,'attendances/1588/1695992181 clock_in.png','attendances/1588/1696028680 clock_out.png','Juan R',39632,NULL,'2023-09-29 09:56:21','2023-10-02 13:51:57'),(2019,'2023-09-29 05:57:36','2023-09-29 15:38:06','12.249.250.150','12.249.250.150','closed',9,580,'attendances/1568/1695992256 clock_in.png','attendances/1568/1696027086 clock_out.png','Juan R',39631,NULL,'2023-09-29 09:57:36','2023-10-02 13:51:48'),(2020,'2023-09-29 06:00:31','2023-09-29 14:28:17','12.249.250.150','12.249.250.150','closed',8,507,'attendances/1951/1695992431 clock_in.png','attendances/1951/1696022897 clock_out.png','Juan R',39636,NULL,'2023-09-29 10:00:31','2023-10-02 13:52:05'),(2021,'2023-09-29 06:29:12','2023-09-29 16:02:36','12.249.250.150','12.249.250.150','closed',9,573,'attendances/622/1695994152 clock_in.png','attendances/622/1696028556 clock_out.png','Juan R',39646,NULL,'2023-09-29 10:29:12','2023-10-02 13:54:11'),(2022,'2023-09-29 06:52:26','2023-09-29 16:02:53','12.249.250.150','12.249.250.150','closed',9,550,'attendances/1774/1695995546 clock_in.png','attendances/1774/1696028573 clock_out.png','Juan R',39637,NULL,'2023-09-29 10:52:26','2023-10-02 13:52:26'),(2023,'2023-09-29 06:54:08','2023-09-29 15:35:41','12.249.250.150','12.249.250.150','closed',8,521,'attendances/1395/1695995648 clock_in.png','attendances/1395/1696026941 clock_out.png','Juan R',39644,NULL,'2023-09-29 10:54:08','2023-10-02 13:53:27'),(2024,'2023-09-29 06:54:51','2023-09-29 14:50:57','12.249.250.150','12.249.250.150','closed',7,476,'attendances/726/1695995691 clock_in.png','attendances/726/1696024257 clock_out.png','Juan R',39634,NULL,'2023-09-29 10:54:51','2023-10-02 13:50:28'),(2025,'2023-09-29 06:55:59','2023-09-29 15:33:17','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1999/1695995759 clock_in.png','attendances/1999/1696026797 clock_out.png','Juan R',39639,NULL,'2023-09-29 10:55:59','2023-10-02 13:52:33'),(2026,'2023-09-29 06:57:05','2023-09-29 15:35:54','12.249.250.150','12.249.250.150','closed',8,518,'attendances/1728/1695995825 clock_in.png','attendances/1728/1696026954 clock_out.png','Juan R',39642,NULL,'2023-09-29 10:57:05','2023-10-02 13:52:48'),(2027,'2023-09-29 06:57:34','2023-09-29 16:38:03','12.249.250.150','12.249.250.150','closed',9,580,'attendances/1479/1695995854 clock_in.png','attendances/1479/1696030683 clock_out.png','Juan R',39635,NULL,'2023-09-29 10:57:34','2023-10-02 13:52:02'),(2028,'2023-09-29 06:58:02','2023-09-29 15:36:48','12.249.250.150','12.249.250.150','closed',8,518,'attendances/1958/1695995882 clock_in.png','attendances/1958/1696027008 clock_out.png','Juan R',39638,NULL,'2023-09-29 10:58:02','2023-10-02 13:52:29'),(2029,'2023-09-29 06:58:35','2023-09-29 15:30:00','12.249.250.150','179.32.200.184','closed',8,511,'attendances/974/1695995915 clock_in.png',NULL,'Juan R',39648,NULL,'2023-09-29 10:58:35','2023-10-02 13:50:05'),(2030,'2023-09-29 06:59:26','2023-09-29 15:32:00','12.249.250.150','179.19.157.5','closed',8,512,'attendances/1934/1695995966 clock_in.png',NULL,'Juan R',39641,NULL,'2023-09-29 10:59:26','2023-10-02 13:52:39'),(2031,'2023-09-29 07:02:11','2023-09-29 15:36:20','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1888/1695996131 clock_in.png','attendances/1888/1696026980 clock_out.png','Juan R',39647,NULL,'2023-09-29 11:02:11','2023-10-02 13:54:23'),(2032,'2023-09-29 07:04:12','2023-09-29 15:36:07','12.249.250.150','12.249.250.150','closed',8,511,'attendances/1948/1695996252 clock_in.png','attendances/1948/1696026967 clock_out.png','Juan R',39645,NULL,'2023-09-29 11:04:12','2023-10-02 13:53:48'),(2033,'2023-09-29 07:05:11','2023-09-29 15:36:39','12.249.250.150','12.249.250.150','closed',8,511,'attendances/1462/1695996311 clock_in.png','attendances/1462/1696026999 clock_out.png','Juan R',39640,NULL,'2023-09-29 11:05:11','2023-10-02 13:52:36'),(2034,'2023-09-29 07:08:44','2023-09-29 15:37:05','12.249.250.150','12.249.250.150','closed',8,508,'attendances/1858/1695996524 clock_in.png','attendances/1858/1696027025 clock_out.png','Juan R',39643,NULL,'2023-09-29 11:08:44','2023-10-02 13:52:51'),(2035,'2023-09-29 07:48:28','2023-09-29 17:46:39','12.249.250.150','12.249.250.150','closed',9,598,'attendances/1116/1695998908 clock_in.png','attendances/1116/1696034799 clock_out.png','Juan R',39650,NULL,'2023-09-29 11:48:28','2023-10-02 13:53:15'),(2036,'2023-09-29 08:05:25','2023-09-29 16:31:34','12.249.250.150','12.249.250.150','closed',8,506,'attendances/775/1695999925 clock_in.png','attendances/775/1696030294 clock_out.png','Juan R',39651,NULL,'2023-09-29 12:05:25','2023-10-02 13:53:31'),(2037,'2023-09-29 08:21:52','2023-09-29 16:36:00','12.249.250.150','12.249.250.150','closed',8,494,'attendances/1869/1696000912 clock_in.png','attendances/1869/1696030560 clock_out.png','Juan R',39649,NULL,'2023-09-29 12:21:52','2023-10-02 13:51:54'),(2038,'2023-09-29 08:22:04','2023-09-29 16:36:12','12.249.250.150','12.249.250.150','closed',8,494,'attendances/1891/1696000924 clock_in.png','attendances/1891/1696030572 clock_out.png','Juan R',39652,NULL,'2023-09-29 12:22:04','2023-10-02 13:53:34'),(2040,'2023-09-30 05:53:09','2023-09-30 13:31:44','12.249.250.150','12.249.250.150','closed',7,458,'attendances/622/1696078389 clock_in.png','attendances/622/1696105904 clock_out.png','Juan R',39728,NULL,'2023-09-30 09:53:09','2023-10-02 13:54:11'),(2041,'2023-09-30 05:57:02','2023-09-30 14:32:41','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1774/1696078622 clock_in.png','attendances/1774/1696109561 clock_out.png','Juan R',39727,NULL,'2023-09-30 09:57:02','2023-10-02 13:52:26'),(2042,'2023-10-01 05:23:17','2023-10-01 18:38:00','12.249.250.150','12.249.250.150','closed',13,794,'attendances/1585/1696162997 clock_in.png','attendances/1585/1696210680 clock_out.png','Juan R',39730,NULL,'2023-10-01 09:23:17','2023-10-02 13:51:43'),(2043,'2023-10-01 05:23:42','2023-10-01 18:33:30','12.249.250.150','12.249.250.150','closed',13,789,'attendances/382/1696163022 clock_in.png','attendances/382/1696210410 clock_out.png','Juan R',39731,NULL,'2023-10-01 09:23:42','2023-10-02 13:52:11'),(2044,'2023-10-01 05:25:49','2023-10-01 18:17:52','12.249.250.150','12.249.250.150','closed',12,772,'attendances/2025/1696163149 clock_in.png','attendances/2025/1696209472 clock_out.png','Juan R',39734,NULL,'2023-10-01 09:25:49','2023-10-02 13:54:13'),(2045,'2023-10-01 05:28:19','2023-10-01 18:32:22','12.249.250.150','12.249.250.150','closed',13,784,'attendances/1551/1696163299 clock_in.png','attendances/1551/1696210342 clock_out.png','Juan R',39729,NULL,'2023-10-01 09:28:19','2023-10-02 13:50:35'),(2046,'2023-10-01 05:28:34','2023-10-01 18:28:17','12.249.250.150','12.249.250.150','closed',12,779,'attendances/1455/1696163314 clock_in.png','attendances/1455/1696210097 clock_out.png','Juan R',39732,NULL,'2023-10-01 09:28:34','2023-10-02 13:52:41'),(2047,'2023-10-01 05:28:47','2023-10-01 18:31:03','12.249.250.150','12.249.250.150','closed',13,782,'attendances/1450/1696163327 clock_in.png','attendances/1450/1696210263 clock_out.png','Juan R',39733,NULL,'2023-10-01 09:28:47','2023-10-02 13:53:51'),(2048,'2023-10-02 04:58:32','2023-10-02 15:30:12','12.249.250.150','12.249.250.150','closed',10,631,'attendances/1568/1696247912 clock_in.png','attendances/1568/1696285812 clock_out.png','Juan R',39744,NULL,'2023-10-02 08:58:32','2023-10-10 08:08:01'),(2049,'2023-10-02 04:58:45','2023-10-02 14:00:11','12.249.250.150','12.249.250.150','closed',9,541,'attendances/1588/1696247925 clock_in.png','attendances/1588/1696280411 clock_out.png','Juan R',39745,NULL,'2023-10-02 08:58:45','2023-10-10 08:08:52'),(2050,'2023-10-02 05:01:48','2023-10-02 13:47:10','12.249.250.150','12.249.250.150','closed',8,525,'attendances/1455/1696248108 clock_in.png','attendances/1455/1696279630 clock_out.png','Juan R',39746,NULL,'2023-10-02 09:01:48','2023-10-10 08:10:07'),(2051,'2023-10-02 05:54:33','2023-10-02 18:35:49','12.249.250.150','12.249.250.150','closed',12,761,'attendances/1585/1696251273 clock_in.png','attendances/1585/1696296949 clock_out.png','Juan R',39748,NULL,'2023-10-02 09:54:33','2023-10-10 08:07:57'),(2052,'2023-10-02 05:54:59','2023-10-02 18:50:51','12.249.250.150','12.249.250.150','closed',12,775,'attendances/1551/1696251299 clock_in.png','attendances/1551/1696297851 clock_out.png','Juan R',39747,NULL,'2023-10-02 09:54:59','2023-10-10 08:07:45'),(2053,'2023-10-02 05:55:03','2023-10-02 17:17:27','12.249.250.150','12.249.250.150','closed',11,682,'attendances/2025/1696251303 clock_in.png','attendances/2025/1696292247 clock_out.png','Juan R',39753,NULL,'2023-10-02 09:55:03','2023-10-10 08:11:42'),(2054,'2023-10-02 05:55:12','2023-10-02 18:50:37','12.249.250.150','12.249.250.150','closed',12,775,'attendances/2005/1696251312 clock_in.png','attendances/2005/1696297837 clock_out.png','Juan R',39751,NULL,'2023-10-02 09:55:12','2023-10-10 08:10:26'),(2055,'2023-10-02 06:00:53','2023-10-02 17:20:52','12.249.250.150','12.249.250.150','closed',11,679,'attendances/1450/1696251653 clock_in.png','attendances/1450/1696292452 clock_out.png','Juan R',39752,NULL,'2023-10-02 10:00:53','2023-10-10 08:11:27'),(2056,'2023-10-02 06:01:10','2023-10-02 18:51:51','12.249.250.150','12.249.250.150','closed',12,770,'attendances/382/1696251670 clock_in.png','attendances/382/1696297911 clock_out.png','Juan R',39749,NULL,'2023-10-02 10:01:10','2023-10-10 08:09:05'),(2057,'2023-10-02 05:58:00','2023-10-02 18:50:18','179.32.200.184','12.249.250.150','closed',12,772,NULL,'attendances/1951/1696297818 clock_out.png','Juan R',39750,NULL,'2023-10-02 10:16:58','2023-10-10 08:09:01'),(2058,'2023-10-02 06:26:56','2023-10-02 15:35:44','12.249.250.150','12.249.250.150','closed',9,548,'attendances/622/1696253216 clock_in.png','attendances/622/1696286144 clock_out.png','Juan R',39765,NULL,'2023-10-02 10:26:56','2023-10-10 08:11:34'),(2059,'2023-10-02 06:52:05','2023-10-02 15:33:28','12.249.250.150','12.249.250.150','closed',8,521,'attendances/1395/1696254725 clock_in.png','attendances/1395/1696286008 clock_out.png','Juan R',39763,NULL,'2023-10-02 10:52:05','2023-10-10 08:10:52'),(2060,'2023-10-02 06:52:21','2023-10-02 16:17:49','12.249.250.150','12.249.250.150','closed',9,565,'attendances/1116/1696254741 clock_in.png','attendances/1116/1696288669 clock_out.png','Juan R',39762,NULL,'2023-10-02 10:52:21','2023-10-10 08:10:33'),(2061,'2023-10-02 06:52:35','2023-10-02 15:31:36','12.249.250.150','12.249.250.150','closed',8,519,'attendances/1479/1696254755 clock_in.png','attendances/1479/1696285896 clock_out.png','Juan R',39755,NULL,'2023-10-02 10:52:35','2023-10-10 08:08:56'),(2062,'2023-10-02 06:52:46','2023-10-02 15:32:47','12.249.250.150','12.249.250.150','closed',8,520,'attendances/1774/1696254766 clock_in.png','attendances/1774/1696285967 clock_out.png','Juan R',39756,NULL,'2023-10-02 10:52:46','2023-10-10 08:09:41'),(2063,'2023-10-02 06:52:47','2023-10-02 17:51:18','12.249.250.150','12.249.250.150','closed',10,658,'attendances/726/1696254767 clock_in.png','attendances/726/1696294278 clock_out.png','Juan R',39754,NULL,'2023-10-02 10:52:47','2023-10-10 08:07:41'),(2064,'2023-10-02 06:55:09','2023-10-02 16:17:35','12.249.250.150','12.249.250.150','closed',9,562,'attendances/1728/1696254909 clock_in.png','attendances/1728/1696288655 clock_out.png','Juan R',39760,NULL,'2023-10-02 10:55:09','2023-10-10 08:10:15'),(2065,'2023-10-02 06:56:50','2023-10-02 15:30:29','12.249.250.150','12.249.250.150','closed',8,513,'attendances/1934/1696255010 clock_in.png','attendances/1934/1696285829 clock_out.png','Juan R',39759,NULL,'2023-10-02 10:56:50','2023-10-10 08:10:05'),(2066,'2023-10-02 06:57:24','2023-10-02 15:31:18','12.249.250.150','12.249.250.150','closed',8,513,'attendances/974/1696255044 clock_in.png','attendances/974/1696285878 clock_out.png','Juan R',39767,NULL,'2023-10-02 10:57:24','2023-10-10 08:06:19'),(2067,'2023-10-02 06:58:30','2023-10-02 15:32:34','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1958/1696255110 clock_in.png','attendances/1958/1696285955 clock_out.png','Juan R',39757,NULL,'2023-10-02 10:58:30','2023-10-10 08:09:54'),(2068,'2023-10-02 07:03:07','2023-10-02 15:35:02','12.249.250.150','12.249.250.150','closed',8,511,'attendances/1888/1696255387 clock_in.png','attendances/1888/1696286102 clock_out.png','Juan R',39766,NULL,'2023-10-02 11:03:07','2023-10-10 08:12:07'),(2069,'2023-10-02 07:03:17','2023-10-02 15:34:48','12.249.250.150','12.249.250.150','closed',8,511,'attendances/1948/1696255397 clock_in.png','attendances/1948/1696286088 clock_out.png','Juan R',39764,NULL,'2023-10-02 11:03:17','2023-10-10 08:11:25'),(2070,'2023-10-02 07:13:24','2023-10-02 15:35:12','12.249.250.150','12.249.250.150','closed',8,501,'attendances/1858/1696256004 clock_in.png','attendances/1858/1696286112 clock_out.png','Juan R',39761,NULL,'2023-10-02 11:13:24','2023-10-10 08:10:22'),(2071,'2023-10-02 06:50:41','2023-10-02 15:30:45','179.32.200.184','12.249.250.150','closed',8,520,'attendances/1999/1696256621 clock_in.png','attendances/1999/1696285845 clock_out.png','Juan R',39758,NULL,'2023-10-02 11:23:41','2023-10-10 08:09:58'),(2072,'2023-10-02 08:00:08','2023-10-02 16:30:22','12.249.250.150','12.249.250.150','closed',8,510,'attendances/775/1696258808 clock_in.png','attendances/775/1696289422 clock_out.png','Juan R',39770,NULL,'2023-10-02 12:00:08','2023-10-10 08:11:03'),(2073,'2023-10-02 08:02:19','2023-10-02 17:50:53','12.249.250.150','12.249.250.150','closed',9,588,'attendances/1869/1696258939 clock_in.png','attendances/1869/1696294253 clock_out.png','Juan R',39768,NULL,'2023-10-02 12:02:19','2023-10-10 08:08:15'),(2074,'2023-10-02 08:02:27','2023-10-02 16:42:49','12.249.250.150','12.249.250.150','closed',8,520,'attendances/1891/1696258947 clock_in.png','attendances/1891/1696290169 clock_out.png','Juan R',39771,NULL,'2023-10-02 12:02:27','2023-10-10 08:11:21'),(2075,'2023-10-02 08:04:07','2023-10-02 15:43:15','12.249.250.150','12.249.250.150','closed',7,459,'attendances/1462/1696259047 clock_in.png','attendances/1462/1696286595 clock_out.png','Juan R',39769,NULL,'2023-10-02 12:04:07','2023-10-10 08:10:00'),(2076,'2023-10-03 05:53:23','2023-10-03 18:28:38','12.249.250.150','12.249.250.150','closed',12,755,'attendances/2005/1696337603 clock_in.png','attendances/2005/1696382918 clock_out.png','Juan R',39867,NULL,'2023-10-03 09:53:23','2023-10-10 08:10:26'),(2077,'2023-10-03 05:53:40','2023-10-03 18:26:33','12.249.250.150','12.249.250.150','closed',12,752,'attendances/1585/1696337620 clock_in.png','attendances/1585/1696382793 clock_out.png','Juan R',39862,NULL,'2023-10-03 09:53:40','2023-10-10 08:07:57'),(2078,'2023-10-03 05:53:50','2023-10-03 15:36:02','12.249.250.150','12.249.250.150','closed',9,582,'attendances/1588/1696337630 clock_in.png','attendances/1588/1696372562 clock_out.png','Juan R',39864,NULL,'2023-10-03 09:53:50','2023-10-10 08:08:52'),(2079,'2023-10-03 05:55:37','2023-10-03 18:28:24','12.249.250.150','12.249.250.150','closed',12,752,'attendances/1551/1696337737 clock_in.png','attendances/1551/1696382904 clock_out.png','Juan R',39861,NULL,'2023-10-03 09:55:37','2023-10-10 08:07:45'),(2080,'2023-10-03 05:58:57','2023-10-03 15:31:04','12.249.250.150','12.249.250.150','closed',9,572,'attendances/1951/1696337937 clock_in.png','attendances/1951/1696372264 clock_out.png','Juan R',39866,NULL,'2023-10-03 09:58:57','2023-10-10 08:09:01'),(2081,'2023-10-03 05:59:13','2023-10-03 15:36:05','12.249.250.150','179.32.196.216','closed',9,576,'attendances/1568/1696337953 clock_in.png','attendances/1568/1696352465 clock_out.png','Juan R',39863,NULL,'2023-10-03 09:59:13','2023-10-10 08:08:01'),(2082,'2023-10-03 06:02:28','2023-10-03 18:31:24','12.249.250.150','12.249.250.150','closed',12,748,'attendances/382/1696338149 clock_in.png','attendances/382/1696383084 clock_out.png','Juan R',39865,NULL,'2023-10-03 10:02:29','2023-10-10 08:09:05'),(2083,'2023-10-03 06:04:04','2023-10-03 14:56:43','12.249.250.150','12.249.250.150','closed',8,532,'attendances/1450/1696338244 clock_in.png','attendances/1450/1696370203 clock_out.png','Juan R',39868,NULL,'2023-10-03 10:04:04','2023-10-10 08:11:27'),(2084,'2023-10-03 06:26:27','2023-10-03 17:24:51','12.249.250.150','12.249.250.150','closed',10,658,'attendances/2025/1696339587 clock_in.png','attendances/2025/1696379091 clock_out.png','Juan R',39871,NULL,'2023-10-03 10:26:27','2023-10-10 08:11:42'),(2085,'2023-10-03 06:29:08','2023-10-03 16:30:32','12.249.250.150','12.249.250.150','closed',10,601,'attendances/622/1696339748 clock_in.png','attendances/622/1696375832 clock_out.png','Juan R',39884,NULL,'2023-10-03 10:29:08','2023-10-10 08:11:34'),(2086,'2023-10-03 06:29:47','2023-10-03 17:24:24','12.249.250.150','12.249.250.150','closed',10,654,'attendances/1455/1696339787 clock_in.png','attendances/1455/1696379064 clock_out.png','Juan R',39870,NULL,'2023-10-03 10:29:47','2023-10-10 08:10:07'),(2087,'2023-10-03 06:51:12','2023-10-03 15:33:46','12.249.250.150','12.249.250.150','closed',8,522,'attendances/1999/1696341072 clock_in.png','attendances/1999/1696372426 clock_out.png','Juan R',39876,NULL,'2023-10-03 10:51:12','2023-10-10 08:09:58'),(2088,'2023-10-03 06:51:44','2023-10-03 16:30:42','12.249.250.150','12.249.250.150','closed',9,578,'attendances/1774/1696341104 clock_in.png','attendances/1774/1696375842 clock_out.png','Juan R',39874,NULL,'2023-10-03 10:51:44','2023-10-10 08:09:41'),(2089,'2023-10-03 06:53:35','2023-10-03 15:50:52','12.249.250.150','12.249.250.150','closed',8,537,'attendances/726/1696341215 clock_in.png','attendances/726/1696373452 clock_out.png','Juan R',39872,NULL,'2023-10-03 10:53:43','2023-10-10 08:07:41'),(2090,'2023-10-03 06:54:12','2023-10-03 15:32:08','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1479/1696341252 clock_in.png','attendances/1479/1696372328 clock_out.png','Juan R',39873,NULL,'2023-10-03 10:54:12','2023-10-10 08:08:56'),(2091,'2023-10-03 06:54:25','2023-10-03 15:33:29','12.249.250.150','12.249.250.150','closed',8,519,'attendances/1395/1696341265 clock_in.png','attendances/1395/1696372409 clock_out.png','Juan R',39882,NULL,'2023-10-03 10:54:25','2023-10-10 08:10:52'),(2092,'2023-10-03 06:54:45','2023-10-03 17:11:51','12.249.250.150','12.249.250.150','closed',10,617,'attendances/1116/1696341285 clock_in.png','attendances/1116/1696378311 clock_out.png','Juan R',39881,NULL,'2023-10-03 10:54:45','2023-10-10 08:10:33'),(2093,'2023-10-03 06:55:29','2023-10-03 15:31:48','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1934/1696341329 clock_in.png','attendances/1934/1696372308 clock_out.png','Juan R',39878,NULL,'2023-10-03 10:55:29','2023-10-10 08:10:05'),(2094,'2023-10-03 06:56:06','2023-10-03 15:35:00','12.249.250.150','179.19.191.39','closed',8,518,'attendances/974/1696341366 clock_in.png',NULL,'Juan R',39886,NULL,'2023-10-03 10:56:06','2023-10-10 08:06:19'),(2095,'2023-10-03 06:57:13','2023-10-03 15:33:57','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1728/1696341433 clock_in.png','attendances/1728/1696372437 clock_out.png','Juan R',39879,NULL,'2023-10-03 10:57:13','2023-10-10 08:10:15'),(2096,'2023-10-03 06:57:46','2023-10-03 15:38:38','12.249.250.150','12.249.250.150','closed',8,520,'attendances/1948/1696341466 clock_in.png','attendances/1948/1696372718 clock_out.png','Juan R',39883,NULL,'2023-10-03 10:57:46','2023-10-10 08:11:25'),(2097,'2023-10-03 06:58:58','2023-10-03 15:33:36','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1958/1696341538 clock_in.png','attendances/1958/1696372416 clock_out.png','Juan R',39875,NULL,'2023-10-03 10:58:58','2023-10-10 08:09:54'),(2098,'2023-10-03 07:02:17','2023-10-03 15:32:21','12.249.250.150','12.249.250.150','closed',8,510,'attendances/1888/1696341737 clock_in.png','attendances/1888/1696372341 clock_out.png','Juan R',39885,NULL,'2023-10-03 11:02:17','2023-10-10 08:12:07'),(2099,'2023-10-03 07:05:45','2023-10-03 15:33:56','12.249.250.150','12.249.250.150','closed',8,508,'attendances/1858/1696341945 clock_in.png','attendances/1858/1696372436 clock_out.png','Juan R',39880,NULL,'2023-10-03 11:05:45','2023-10-10 08:10:22'),(2100,'2023-10-03 07:07:13','2023-10-03 16:01:00','12.249.250.150','12.249.250.150','closed',8,533,'attendances/1462/1696342033 clock_in.png','attendances/1462/1696374060 clock_out.png','Juan R',39877,NULL,'2023-10-03 11:07:13','2023-10-10 08:10:00'),(2101,'2023-10-03 08:01:17','2023-10-03 16:31:04','12.249.250.150','12.249.250.150','closed',8,509,'attendances/775/1696345277 clock_in.png','attendances/775/1696375864 clock_out.png','Juan R',39888,NULL,'2023-10-03 12:01:17','2023-10-10 08:11:03'),(2102,'2023-10-03 08:03:55','2023-10-03 16:33:21','12.249.250.150','12.249.250.150','closed',8,509,'attendances/1869/1696345435 clock_in.png','attendances/1869/1696376001 clock_out.png','Juan R',39887,NULL,'2023-10-03 12:03:55','2023-10-10 08:08:15'),(2103,'2023-10-03 08:04:17','2023-10-03 16:33:32','12.249.250.150','12.249.250.150','closed',8,509,'attendances/1891/1696345457 clock_in.png','attendances/1891/1696376012 clock_out.png','Juan R',39889,NULL,'2023-10-03 12:04:17','2023-10-10 08:11:21'),(2105,'2023-10-03 20:24:41','2023-10-03 23:41:51','12.249.250.150','12.249.250.150','closed',3,197,'attendances/726/1696389881 clock_in.png','attendances/726/1696401711 clock_out.png','Juan R',39959,NULL,'2023-10-04 00:24:41','2023-10-10 08:07:41'),(2106,'2023-10-04 05:54:37','2023-10-04 16:49:12','12.249.250.150','12.249.250.150','closed',10,654,'attendances/2025/1696424077 clock_in.png','attendances/2025/1696463352 clock_out.png','Juan R',39940,NULL,'2023-10-04 09:54:37','2023-10-10 08:11:42'),(2107,'2023-10-04 05:57:47','2023-10-04 17:37:11','12.249.250.150','12.249.250.150','closed',11,699,'attendances/1116/1696424267 clock_in.png','attendances/1116/1696466231 clock_out.png','Juan R',39939,NULL,'2023-10-04 09:57:47','2023-10-10 08:10:33'),(2108,'2023-10-04 05:58:26','2023-10-04 15:32:52','12.249.250.150','12.249.250.150','closed',9,574,'attendances/1568/1696424306 clock_in.png','attendances/1568/1696458772 clock_out.png','Juan R',39935,NULL,'2023-10-04 09:58:26','2023-10-10 08:08:01'),(2109,'2023-10-04 05:58:46','2023-10-04 15:37:14','12.249.250.150','12.249.250.150','closed',9,578,'attendances/1951/1696424326 clock_in.png','attendances/1951/1696459034 clock_out.png','Juan R',39937,NULL,'2023-10-04 09:58:46','2023-10-10 08:09:01'),(2110,'2023-10-04 05:59:06','2023-10-04 15:33:03','12.249.250.150','12.249.250.150','closed',9,573,'attendances/1588/1696424346 clock_in.png','attendances/1588/1696458783 clock_out.png','Juan R',39936,NULL,'2023-10-04 09:59:06','2023-10-10 08:08:52'),(2111,'2023-10-04 06:06:08','2023-10-04 17:03:50','12.249.250.150','12.249.250.150','closed',10,657,'attendances/1455/1696424768 clock_in.png','attendances/1455/1696464230 clock_out.png','Juan R',39938,NULL,'2023-10-04 10:06:08','2023-10-10 08:10:07'),(2112,'2023-10-04 06:06:24','2023-10-04 17:20:37','12.249.250.150','12.249.250.150','closed',11,674,'attendances/726/1696424784 clock_in.png','attendances/726/1696465237 clock_out.png','Juan R',39934,NULL,'2023-10-04 10:06:24','2023-10-10 08:07:41'),(2113,'2023-10-04 06:29:16','2023-10-04 16:47:55','12.249.250.150','12.249.250.150','closed',10,618,'attendances/622/1696426156 clock_in.png','attendances/622/1696463275 clock_out.png','Juan R',39951,NULL,'2023-10-04 10:29:16','2023-10-10 08:11:34'),(2114,'2023-10-04 06:52:44','2023-10-04 16:48:19','12.249.250.150','12.249.250.150','closed',9,595,'attendances/1774/1696427564 clock_in.png','attendances/1774/1696463299 clock_out.png','Juan R',39942,NULL,'2023-10-04 10:52:44','2023-10-10 08:09:41'),(2115,'2023-10-04 06:55:24','2023-10-04 15:59:41','12.249.250.150','12.249.250.150','closed',9,544,'attendances/1462/1696427724 clock_in.png','attendances/1462/1696460381 clock_out.png','Juan R',39945,NULL,'2023-10-04 10:55:24','2023-10-10 08:10:00'),(2116,'2023-10-04 06:55:37','2023-10-04 17:31:54','12.249.250.150','12.249.250.150','closed',10,636,'attendances/1395/1696427737 clock_in.png','attendances/1395/1696465914 clock_out.png','Juan R',39949,NULL,'2023-10-04 10:55:37','2023-10-10 08:10:52'),(2117,'2023-10-04 06:55:56','2023-10-04 17:28:51','12.249.250.150','12.249.250.150','closed',10,632,'attendances/1479/1696427756 clock_in.png','attendances/1479/1696465731 clock_out.png','Juan R',39941,NULL,'2023-10-04 10:55:56','2023-10-10 08:08:56'),(2118,'2023-10-04 06:56:06','2023-10-04 15:32:01','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1958/1696427766 clock_in.png','attendances/1958/1696458721 clock_out.png','Juan R',39943,NULL,'2023-10-04 10:56:06','2023-10-10 08:09:54'),(2119,'2023-10-04 06:56:16','2023-10-04 15:32:37','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1934/1696427776 clock_in.png','attendances/1934/1696458757 clock_out.png','Juan R',39946,NULL,'2023-10-04 10:56:16','2023-10-10 08:10:05'),(2120,'2023-10-04 06:56:35','2023-10-04 15:30:00','12.249.250.150','179.19.239.79','closed',8,513,'attendances/1858/1696427795 clock_in.png',NULL,'Juan R',39948,NULL,'2023-10-04 10:56:35','2023-10-10 08:10:22'),(2121,'2023-10-04 06:58:13','2023-10-04 15:45:06','12.249.250.150','12.249.250.150','closed',8,526,'attendances/1948/1696427893 clock_in.png','attendances/1948/1696459506 clock_out.png','Juan R',39950,NULL,'2023-10-04 10:58:13','2023-10-10 08:11:25'),(2122,'2023-10-04 06:58:32','2023-10-04 17:41:16','12.249.250.150','12.249.250.150','closed',10,642,'attendances/974/1696427912 clock_in.png','attendances/974/1696466476 clock_out.png','Juan R',39953,NULL,'2023-10-04 10:58:32','2023-10-10 08:06:19'),(2123,'2023-10-04 06:58:48','2023-10-04 15:35:58','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1888/1696427928 clock_in.png','attendances/1888/1696458958 clock_out.png','Juan R',39952,NULL,'2023-10-04 10:58:48','2023-10-10 08:12:07'),(2124,'2023-10-04 06:59:05','2023-10-04 17:36:56','12.249.250.150','12.249.250.150','closed',10,637,'attendances/1999/1696427945 clock_in.png','attendances/1999/1696466216 clock_out.png','Juan R',39944,NULL,'2023-10-04 10:59:05','2023-10-10 08:09:58'),(2125,'2023-10-04 07:58:08','2023-10-04 16:30:33','12.249.250.150','12.249.250.150','closed',8,512,'attendances/775/1696431488 clock_in.png','attendances/775/1696462233 clock_out.png','Juan R',39955,NULL,'2023-10-04 11:58:08','2023-10-10 08:11:03'),(2126,'2023-10-04 07:58:23','2023-10-04 16:33:58','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1869/1696431503 clock_in.png','attendances/1869/1696462438 clock_out.png','Juan R',39954,NULL,'2023-10-04 11:58:23','2023-10-10 08:08:15'),(2128,'2023-10-04 11:31:00','2023-10-04 16:36:00','179.19.239.79','179.19.239.79','closed',5,305,NULL,NULL,'Juan R',40041,NULL,'2023-10-04 21:22:37','2023-10-10 08:11:21'),(2129,'2023-10-05 04:57:30','2023-10-05 18:34:22','12.249.250.150','12.249.250.150','closed',13,816,'attendances/1551/1696507050 clock_in.png','attendances/1551/1696556062 clock_out.png','Juan R',40013,NULL,'2023-10-05 08:57:30','2023-10-10 08:07:45'),(2130,'2023-10-05 04:57:42','2023-10-05 18:33:48','12.249.250.150','12.249.250.150','closed',13,816,'attendances/1585/1696507062 clock_in.png','attendances/1585/1696556028 clock_out.png','Juan R',40014,NULL,'2023-10-05 08:57:42','2023-10-10 08:07:57'),(2131,'2023-10-05 05:30:38','2023-10-05 15:31:38','12.249.250.150','12.249.250.150','closed',10,601,'attendances/1450/1696509038 clock_in.png','attendances/1450/1696545098 clock_out.png','Juan R',40015,NULL,'2023-10-05 09:30:38','2023-10-10 08:11:27'),(2132,'2023-10-05 05:30:59','2023-10-05 15:34:49','12.249.250.150','12.249.250.150','closed',10,603,'attendances/2025/1696509059 clock_in.png','attendances/2025/1696545290 clock_out.png','Juan R',40016,NULL,'2023-10-05 09:30:59','2023-10-10 08:11:42'),(2133,'2023-10-05 05:54:11','2023-10-05 19:27:00','12.249.250.150','179.19.223.74','closed',13,812,'attendances/1116/1696510451 clock_in.png',NULL,'Juan R',40021,NULL,'2023-10-05 09:54:11','2023-10-10 08:10:33'),(2134,'2023-10-05 05:58:49','2023-10-05 15:43:07','12.249.250.150','12.249.250.150','closed',9,584,'attendances/1568/1696510729 clock_in.png','attendances/1568/1696545787 clock_out.png','Juan R',40017,NULL,'2023-10-05 09:58:49','2023-10-10 08:08:01'),(2135,'2023-10-05 05:59:00','2023-10-05 15:38:40','12.249.250.150','12.249.250.150','closed',9,579,'attendances/1588/1696510740 clock_in.png','attendances/1588/1696545520 clock_out.png','Juan R',40018,NULL,'2023-10-05 09:59:00','2023-10-10 08:08:52'),(2136,'2023-10-05 06:02:36','2023-10-05 15:32:08','12.249.250.150','12.249.250.150','closed',9,569,'attendances/1951/1696510956 clock_in.png','attendances/1951/1696545128 clock_out.png','Juan R',40019,NULL,'2023-10-05 10:02:36','2023-10-10 08:09:01'),(2137,'2023-10-05 06:03:59','2023-10-05 15:28:47','12.249.250.150','12.249.250.150','closed',9,564,'attendances/1455/1696511039 clock_in.png','attendances/1455/1696544927 clock_out.png','Juan R',40020,NULL,'2023-10-05 10:03:59','2023-10-10 08:10:07'),(2138,'2023-10-05 06:30:07','2023-10-05 15:34:37','12.249.250.150','12.249.250.150','closed',9,544,'attendances/622/1696512607 clock_in.png','attendances/622/1696545277 clock_out.png','Juan R',40035,NULL,'2023-10-05 10:30:07','2023-10-10 08:11:34'),(2139,'2023-10-05 06:53:00','2023-10-05 16:18:35','12.249.250.150','12.249.250.150','closed',9,565,'attendances/726/1696513980 clock_in.png','attendances/726/1696547915 clock_out.png','Juan R',40022,NULL,'2023-10-05 10:53:00','2023-10-10 08:07:41'),(2140,'2023-10-05 06:54:22','2023-10-05 15:31:32','12.249.250.150','179.19.223.74','closed',8,517,'attendances/1774/1696514062 clock_in.png','attendances/1774/1696514312 clock_out.png','Juan R',40025,NULL,'2023-10-05 10:54:37','2023-10-10 08:09:41'),(2141,'2023-10-05 06:54:25','2023-10-05 16:06:10','12.249.250.150','12.249.250.150','closed',9,551,'attendances/382/1696514065 clock_in.png','attendances/382/1696547170 clock_out.png','Juan R',40024,NULL,'2023-10-05 10:54:37','2023-10-10 08:09:05'),(2142,'2023-10-05 06:56:16','2023-10-05 15:30:03','12.249.250.150','179.19.223.74','closed',8,513,'attendances/1958/1696514176 clock_in.png','attendances/1958/1696514223 clock_out.png','Juan R',40026,NULL,'2023-10-05 10:56:31','2023-10-10 08:09:54'),(2143,'2023-10-05 06:56:31','2023-10-05 16:01:21','12.249.250.150','12.249.250.150','closed',9,544,'attendances/1728/1696514191 clock_in.png','attendances/1728/1696546881 clock_out.png','Juan R',40030,NULL,'2023-10-05 10:56:31','2023-10-10 08:10:15'),(2144,'2023-10-05 06:56:52','2023-10-05 19:27:15','12.249.250.150','12.249.250.150','closed',12,750,'attendances/1395/1696514212 clock_in.png','attendances/1395/1696559235 clock_out.png','Juan R',40033,NULL,'2023-10-05 10:56:56','2023-10-10 08:10:52'),(2145,'2023-10-05 06:57:14','2023-10-05 16:39:39','12.249.250.150','12.249.250.150','closed',9,582,'attendances/1479/1696514234 clock_in.png','attendances/1479/1696549179 clock_out.png','Juan R',40023,NULL,'2023-10-05 10:57:15','2023-10-10 08:08:56'),(2146,'2023-10-05 06:57:39','2023-10-05 15:30:37','12.249.250.150','12.249.250.150','closed',8,512,'attendances/1934/1696514259 clock_in.png','attendances/1934/1696545037 clock_out.png','Juan R',40029,NULL,'2023-10-05 10:57:39','2023-10-10 08:10:05'),(2148,'2023-10-05 06:58:04','2023-10-05 15:31:02','12.249.250.150','12.249.250.150','closed',8,512,'attendances/1858/1696514284 clock_in.png','attendances/1858/1696545062 clock_out.png','Juan R',40031,NULL,'2023-10-05 10:58:04','2023-10-10 08:10:22'),(2149,'2023-10-05 06:59:04','2023-10-05 15:41:51','12.249.250.150','12.249.250.150','closed',8,522,'attendances/1948/1696514344 clock_in.png','attendances/1948/1696545711 clock_out.png','Juan R',40034,NULL,'2023-10-05 10:59:04','2023-10-10 08:11:25'),(2150,'2023-10-05 07:00:44','2023-10-05 16:03:30','12.249.250.150','12.249.250.150','closed',9,542,'attendances/1462/1696514444 clock_in.png','attendances/1462/1696547010 clock_out.png','Juan R',40028,NULL,'2023-10-05 11:00:44','2023-10-10 08:10:00'),(2151,'2023-10-05 07:00:55','2023-10-05 20:36:29','12.249.250.150','12.249.250.150','closed',13,815,'attendances/1999/1696514455 clock_in.png','attendances/1999/1696563389 clock_out.png','Juan R',40027,NULL,'2023-10-05 11:00:55','2023-10-10 08:09:58'),(2152,'2023-10-05 07:01:59','2023-10-05 20:37:16','12.249.250.150','12.249.250.150','closed',13,815,'attendances/974/1696514519 clock_in.png','attendances/974/1696563436 clock_out.png','Juan R',40037,NULL,'2023-10-05 11:01:59','2023-10-10 08:06:19'),(2153,'2023-10-05 07:05:38','2023-10-05 15:33:13','12.249.250.150','12.249.250.150','closed',8,507,'attendances/1888/1696514738 clock_in.png','attendances/1888/1696545193 clock_out.png','Juan R',40036,NULL,'2023-10-05 11:05:38','2023-10-10 08:12:07'),(2154,'2023-10-05 07:17:36','2023-10-05 15:19:18','12.249.250.150','12.249.250.150','closed',8,481,'attendances/2005/1696515456 clock_in.png','attendances/2005/1696544358 clock_out.png','Juan R',40032,NULL,'2023-10-05 11:17:36','2023-10-10 08:10:26'),(2155,'2023-10-05 07:54:21','2023-10-05 16:37:00','12.249.250.150','179.19.223.74','closed',8,522,'attendances/1869/1696517661 clock_in.png',NULL,'Juan R',40038,NULL,'2023-10-05 11:54:21','2023-10-10 08:08:15'),(2156,'2023-10-05 07:59:09','2023-10-05 16:30:25','12.249.250.150','12.249.250.150','closed',8,511,'attendances/775/1696517949 clock_in.png','attendances/775/1696548625 clock_out.png','Juan R',40039,NULL,'2023-10-05 11:59:09','2023-10-10 08:11:03'),(2157,'2023-10-05 08:04:11','2023-10-05 16:36:00','12.249.250.150','12.249.250.150','closed',8,511,'attendances/1891/1696518251 clock_in.png','attendances/1891/1696548960 clock_out.png','Juan R',40040,NULL,'2023-10-05 12:04:11','2023-10-10 08:11:21'),(2158,'2023-10-06 05:27:04','2023-10-06 22:12:52','12.249.250.150','12.249.250.150','closed',16,1005,'attendances/726/1696595224 clock_in.png','attendances/726/1696655572 clock_out.png','Juan R',40157,NULL,'2023-10-06 09:27:04','2023-10-10 08:07:41'),(2159,'2023-10-06 05:58:00','2023-10-06 18:37:45','12.249.250.150','12.249.250.150','closed',12,759,'attendances/1588/1696597080 clock_in.png','attendances/1588/1696642665 clock_out.png','Juan R',40160,NULL,'2023-10-06 09:58:00','2023-10-10 08:08:52'),(2160,'2023-10-06 05:59:14','2023-10-06 15:42:45','12.249.250.150','12.249.250.150','closed',9,583,'attendances/1568/1696597154 clock_in.png','attendances/1568/1696632165 clock_out.png','Juan R',40159,NULL,'2023-10-06 09:59:14','2023-10-10 08:08:01'),(2161,'2023-10-06 06:26:58','2023-10-06 15:32:40','12.249.250.150','12.249.250.150','closed',9,545,'attendances/622/1696598818 clock_in.png','attendances/622/1696631560 clock_out.png','Juan R',40171,NULL,'2023-10-06 10:26:58','2023-10-10 08:11:34'),(2162,'2023-10-06 06:52:37','2023-10-06 16:45:58','12.249.250.150','12.249.250.150','closed',9,593,'attendances/1395/1696600357 clock_in.png','attendances/1395/1696635958 clock_out.png','Juan R',40169,NULL,'2023-10-06 10:52:37','2023-10-10 08:10:52'),(2163,'2023-10-06 06:53:19','2023-10-06 15:33:00','12.249.250.150','12.249.250.150','closed',8,519,'attendances/1934/1696600399 clock_in.png','attendances/1934/1696631580 clock_out.png','Juan R',40166,NULL,'2023-10-06 10:53:19','2023-10-10 08:10:05'),(2164,'2023-10-06 06:53:36','2023-10-06 15:33:17','12.249.250.150','12.249.250.150','closed',8,519,'attendances/1958/1696600416 clock_in.png','attendances/1958/1696631597 clock_out.png','Juan R',40163,NULL,'2023-10-06 10:53:36','2023-10-10 08:09:54'),(2165,'2023-10-06 06:54:03','2023-10-06 15:33:31','12.249.250.150','12.249.250.150','closed',8,519,'attendances/1774/1696600443 clock_in.png','attendances/1774/1696631611 clock_out.png','Juan R',40162,NULL,'2023-10-06 10:54:03','2023-10-10 08:09:41'),(2166,'2023-10-06 06:55:08','2023-10-06 16:50:23','12.249.250.150','12.249.250.150','closed',9,595,'attendances/1479/1696600508 clock_in.png','attendances/1479/1696636223 clock_out.png','Juan R',40161,NULL,'2023-10-06 10:55:08','2023-10-10 08:08:56'),(2167,'2023-10-06 06:55:30','2023-10-06 15:30:58','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1858/1696600530 clock_in.png','attendances/1858/1696631458 clock_out.png','Juan R',40168,NULL,'2023-10-06 10:55:30','2023-10-10 08:10:22'),(2168,'2023-10-06 06:57:12','2023-10-06 16:05:48','12.249.250.150','12.249.250.150','closed',9,548,'attendances/1728/1696600632 clock_in.png','attendances/1728/1696633548 clock_out.png','Juan R',40167,NULL,'2023-10-06 10:57:12','2023-10-10 08:10:15'),(2169,'2023-10-06 07:01:36','2023-10-06 16:30:30','12.249.250.150','12.249.250.150','closed',9,568,'attendances/1999/1696600896 clock_in.png','attendances/1999/1696635030 clock_out.png','Juan R',40164,NULL,'2023-10-06 11:01:36','2023-10-10 08:09:58'),(2170,'2023-10-06 07:03:17','2023-10-06 15:33:10','12.249.250.150','12.249.250.150','closed',8,509,'attendances/1948/1696600997 clock_in.png','attendances/1948/1696631590 clock_out.png','Juan R',40170,NULL,'2023-10-06 11:03:17','2023-10-10 08:11:25'),(2171,'2023-10-06 07:03:33','2023-10-06 16:31:19','12.249.250.150','12.249.250.150','closed',9,567,'attendances/974/1696601013 clock_in.png','attendances/974/1696635079 clock_out.png','Juan R',40173,NULL,'2023-10-06 11:03:33','2023-10-10 08:06:19'),(2172,'2023-10-06 07:06:57','2023-10-06 15:35:28','12.249.250.150','12.249.250.150','closed',8,508,'attendances/1888/1696601217 clock_in.png','attendances/1888/1696631728 clock_out.png','Juan R',40172,NULL,'2023-10-06 11:06:57','2023-10-10 08:12:07'),(2173,'2023-10-06 07:07:35','2023-10-06 16:00:35','12.249.250.150','12.249.250.150','closed',8,533,'attendances/1462/1696601255 clock_in.png','attendances/1462/1696633235 clock_out.png','Juan R',40165,NULL,'2023-10-06 11:07:35','2023-10-10 08:10:00'),(2174,'2023-10-06 07:58:20','2023-10-06 16:30:09','12.249.250.150','12.249.250.150','closed',8,511,'attendances/775/1696604300 clock_in.png','attendances/775/1696635009 clock_out.png','Juan R',40175,NULL,'2023-10-06 11:58:20','2023-10-10 08:11:03'),(2175,'2023-10-06 08:02:23','2023-10-06 16:51:48','12.249.250.150','12.249.250.150','closed',8,529,'attendances/1869/1696604543 clock_in.png','attendances/1869/1696636308 clock_out.png','Juan R',40174,NULL,'2023-10-06 12:02:23','2023-10-10 08:08:15'),(2176,'2023-10-06 08:02:30','2023-10-06 16:51:37','12.249.250.150','12.249.250.150','closed',8,529,'attendances/1891/1696604550 clock_in.png','attendances/1891/1696636297 clock_out.png','Juan R',40176,NULL,'2023-10-06 12:02:30','2023-10-10 08:11:21'),(2177,'2023-10-06 09:51:22','2023-10-06 18:21:00','12.249.250.150','12.249.250.150','closed',8,509,'attendances/1450/1696611082 clock_in.png','attendances/1450/1696641660 clock_out.png','Juan R',40177,NULL,'2023-10-06 13:51:22','2023-10-10 08:11:27'),(2178,'2023-10-06 05:30:00','2023-10-06 18:36:40','181.234.24.128','12.249.250.150','closed',13,786,NULL,'attendances/1455/1696642600 clock_out.png','Juan R',40158,NULL,'2023-10-06 13:51:33','2023-10-10 08:10:07'),(2180,'2023-10-06 19:59:00','2023-10-06 23:59:00','179.19.144.139','181.234.24.128','closed',4,240,NULL,NULL,'Juan R',40274,NULL,'2023-10-07 00:21:45','2023-10-10 08:08:56'),(2181,'2023-10-07 00:14:15','2023-10-07 08:37:37','12.249.250.150','12.249.250.150','closed',8,503,'attendances/1585/1696662855 clock_in.png','attendances/1585/1696693057 clock_out.png','Juan R',40233,NULL,'2023-10-07 04:14:15','2023-10-10 08:07:57'),(2182,'2023-10-07 00:16:43','2023-10-07 08:35:18','12.249.250.150','12.249.250.150','closed',8,498,'attendances/1551/1696663003 clock_in.png','attendances/1551/1696692918 clock_out.png','Juan R',40232,NULL,'2023-10-07 04:16:43','2023-10-10 08:07:45'),(2183,'2023-10-07 00:20:37','2023-10-07 08:45:38','12.249.250.150','12.249.250.150','closed',8,505,'attendances/382/1696663237 clock_in.png','attendances/382/1696693538 clock_out.png','Juan R',40234,NULL,'2023-10-07 04:20:37','2023-10-10 08:09:05'),(2185,'2023-10-07 00:00:00','2023-10-07 02:14:00','181.234.24.128','181.234.24.128','closed',2,134,NULL,NULL,'Juan R',40275,NULL,'2023-10-07 10:52:54','2023-10-10 08:08:56'),(2186,'2023-10-07 03:40:00','2023-10-07 12:52:00','181.234.24.128','179.19.144.139','closed',9,552,NULL,NULL,'Juan R',40265,NULL,'2023-10-07 11:36:06','2023-10-10 08:08:15'),(2187,'2023-10-07 03:40:00','2023-10-07 12:52:00','181.234.24.128','179.19.144.139','closed',9,552,NULL,NULL,'Juan R',40266,NULL,'2023-10-07 11:36:23','2023-10-10 08:11:21'),(2188,'2023-10-07 05:54:00','2023-10-07 15:39:07','181.234.24.128','12.249.250.150','closed',9,585,NULL,'attendances/1116/1696718347 clock_out.png','Juan R',40235,NULL,'2023-10-07 12:58:53','2023-10-10 08:10:33'),(2189,'2023-10-08 05:52:10','2023-10-08 19:49:46','12.249.250.150','12.249.250.150','closed',13,837,'attendances/2025/1696769530 clock_in.png','attendances/2025/1696819786 clock_out.png','Juan R',40291,NULL,'2023-10-08 09:52:10','2023-10-10 08:11:42'),(2190,'2023-10-08 10:02:34','2023-10-08 20:25:09','12.249.250.150','12.249.250.150','closed',10,622,'attendances/1951/1696784554 clock_in.png','attendances/1951/1696821909 clock_out.png','Juan R',40287,NULL,'2023-10-08 14:02:34','2023-10-10 08:09:01'),(2191,'2023-10-08 18:42:55','2023-10-08 23:59:00','12.249.250.150','186.113.214.9','closed',5,316,'attendances/1585/1696815775 clock_in.png',NULL,'Juan R',40289,NULL,'2023-10-08 22:42:55','2023-10-10 08:07:57'),(2192,'2023-10-08 18:44:12','2023-10-08 23:59:00','12.249.250.150','186.113.214.9','closed',5,314,'attendances/1551/1696815852 clock_in.png',NULL,'Juan R',40288,NULL,'2023-10-08 22:44:12','2023-10-10 08:07:45'),(2193,'2023-10-08 18:57:09','2023-10-08 23:59:00','12.249.250.150','186.113.214.9','closed',5,301,'attendances/382/1696816629 clock_in.png',NULL,'Juan R',40290,NULL,'2023-10-08 22:57:09','2023-10-10 08:09:05'),(2197,'2023-10-09 00:00:00','2023-10-09 00:45:00','186.113.214.9','186.113.214.9','closed',0,45,NULL,NULL,'Juan R',40326,NULL,'2023-10-09 08:24:00','2023-10-16 15:27:26'),(2198,'2023-10-09 00:00:00','2023-10-09 00:46:00','186.113.214.9','186.113.214.9','closed',0,46,NULL,NULL,'Juan R',40327,NULL,'2023-10-09 08:24:25','2023-10-16 15:27:33'),(2199,'2023-10-09 00:00:00','2023-10-09 00:46:00','186.113.214.9','186.113.214.9','closed',0,46,NULL,NULL,'Juan R',40328,NULL,'2023-10-09 08:24:43','2023-10-16 15:28:48'),(2200,'2023-10-09 04:57:36','2023-10-09 16:49:23','12.249.250.150','12.249.250.150','closed',11,711,'attendances/1568/1696852656 clock_in.png','attendances/1568/1696895363 clock_out.png','Juan R',40300,NULL,'2023-10-09 08:57:36','2023-10-16 15:27:39'),(2201,'2023-10-09 04:58:45','2023-10-09 15:37:49','12.249.250.150','12.249.250.150','closed',10,639,'attendances/1588/1696852725 clock_in.png','attendances/1588/1696891069 clock_out.png','Juan R',40301,NULL,'2023-10-09 08:58:45','2023-10-16 15:28:37'),(2202,'2023-10-09 05:55:26','2023-10-09 15:43:31','12.249.250.150','12.249.250.150','closed',9,588,'attendances/1116/1696856126 clock_in.png','attendances/1116/1696891411 clock_out.png','Juan R',40303,NULL,'2023-10-09 09:55:26','2023-10-16 15:31:12'),(2203,'2023-10-09 05:56:55','2023-10-09 17:48:44','12.249.250.150','12.249.250.150','closed',11,711,'attendances/2005/1696856215 clock_in.png','attendances/2005/1696898924 clock_out.png','Juan R',40302,NULL,'2023-10-09 09:56:55','2023-10-16 15:31:08'),(2204,'2023-10-09 06:02:14','2023-10-09 15:35:25','12.249.250.150','12.249.250.150','closed',9,573,'attendances/622/1696856534 clock_in.png','attendances/622/1696890925 clock_out.png','Juan R',40318,NULL,'2023-10-09 10:02:14','2023-10-16 15:33:22'),(2205,'2023-10-09 06:32:57','2023-10-09 16:44:00','12.249.250.150','181.250.216.42','closed',10,611,'attendances/2094/1696858377 clock_in.png',NULL,'Juan R',40369,NULL,'2023-10-09 10:32:57','2023-10-16 15:33:00'),(2206,'2023-10-09 06:46:47','2023-10-09 15:48:12','12.249.250.150','12.249.250.150','closed',9,541,'attendances/1395/1696859207 clock_in.png','attendances/1395/1696891692 clock_out.png','Juan R',40316,NULL,'2023-10-09 10:46:47','2023-10-16 15:31:25'),(2207,'2023-10-09 06:50:05','2023-10-09 15:20:10','12.249.250.150','186.113.214.9','closed',8,510,'attendances/1999/1696859405 clock_in.png','attendances/1999/1696884750 clock_out.png','Juan R',40310,NULL,'2023-10-09 10:50:05','2023-10-16 15:29:30'),(2208,'2023-10-09 06:54:04','2023-10-09 15:35:40','12.249.250.150','12.249.250.150','closed',8,521,'attendances/1774/1696859644 clock_in.png','attendances/1774/1696890940 clock_out.png','Juan R',40308,NULL,'2023-10-09 10:54:04','2023-10-16 15:29:08'),(2209,'2023-10-09 06:55:19','2023-10-09 15:32:03','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1934/1696859719 clock_in.png','attendances/1934/1696890723 clock_out.png','Juan R',40312,NULL,'2023-10-09 10:55:19','2023-10-16 15:30:01'),(2210,'2023-10-09 06:55:38','2023-10-09 17:03:08','12.249.250.150','12.249.250.150','closed',10,607,'attendances/1479/1696859738 clock_in.png','attendances/1479/1696896188 clock_out.png','Juan R',40306,NULL,'2023-10-09 10:55:38','2023-10-16 15:28:41'),(2211,'2023-10-09 06:56:30','2023-10-09 08:30:04','12.249.250.150','181.250.229.199','closed',1,93,'attendances/1948/1696859790 clock_in.png','attendances/1948/1696865164 clock_out.png','Juan R',40317,NULL,'2023-10-09 10:56:30','2023-10-16 15:32:26'),(2212,'2023-10-09 06:56:53','2023-10-09 15:36:48','12.249.250.150','12.249.250.150','closed',8,519,'attendances/974/1696859813 clock_in.png','attendances/974/1696891008 clock_out.png','Juan R',40321,NULL,'2023-10-09 10:56:53','2023-10-16 15:26:49'),(2213,'2023-10-09 06:57:11','2023-10-09 17:04:19','12.249.250.150','12.249.250.150','closed',10,607,'attendances/1728/1696859832 clock_in.png','attendances/1728/1696896260 clock_out.png','Juan R',40314,NULL,'2023-10-09 10:57:12','2023-10-16 15:30:36'),(2214,'2023-10-09 06:57:23','2023-10-09 16:41:17','12.249.250.150','12.249.250.150','closed',9,583,'attendances/2025/1696859843 clock_in.png','attendances/2025/1696894877 clock_out.png','Juan R',40319,NULL,'2023-10-09 10:57:23','2023-10-16 15:33:28'),(2215,'2023-10-09 06:57:44','2023-10-09 15:30:46','12.249.250.150','12.249.250.150','closed',8,513,'attendances/1858/1696859864 clock_in.png','attendances/1858/1696890646 clock_out.png','Juan R',40315,NULL,'2023-10-09 10:57:44','2023-10-16 15:30:42'),(2216,'2023-10-09 07:02:30','2023-10-09 15:36:39','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1888/1696860150 clock_in.png','attendances/1888/1696890999 clock_out.png','Juan R',40320,NULL,'2023-10-09 11:02:30','2023-10-16 15:33:56'),(2217,'2023-10-09 07:02:32','2023-10-09 19:00:02','12.249.250.150','12.249.250.150','closed',11,717,'attendances/1951/1696860152 clock_in.png','attendances/1951/1696903202 clock_out.png','Juan R',40307,NULL,'2023-10-09 11:02:32','2023-10-16 15:28:45'),(2218,'2023-10-09 07:16:23','2023-10-09 16:50:00','12.249.250.150','181.204.85.170','closed',9,573,'attendances/2138/1696860983 clock_in.png',NULL,'Juan R',40304,NULL,'2023-10-09 11:16:23','2023-10-16 15:26:56'),(2219,'2023-10-09 07:26:32','2023-10-09 16:40:00','12.249.250.150','181.204.85.170','closed',9,553,'attendances/2133/1696861592 clock_in.png',NULL,'Juan R',40305,NULL,'2023-10-09 11:26:32','2023-10-16 15:31:03'),(2220,'2023-10-09 07:56:54','2023-10-09 15:44:52','12.249.250.150','186.113.214.9','closed',7,467,'attendances/1462/1696863414 clock_in.png','attendances/1462/1696876732 clock_out.png','Juan R',40311,NULL,'2023-10-09 11:56:54','2023-10-16 15:29:58'),(2221,'2023-10-09 07:59:58','2023-10-09 16:32:59','12.249.250.150','12.249.250.150','closed',8,513,'attendances/1869/1696863598 clock_in.png','attendances/1869/1696894379 clock_out.png','Juan R',40322,NULL,'2023-10-09 11:59:58','2023-10-16 15:27:46'),(2222,'2023-10-09 08:00:15','2023-10-09 16:33:13','12.249.250.150','12.249.250.150','closed',8,512,'attendances/1891/1696863615 clock_in.png','attendances/1891/1696894393 clock_out.png','Juan R',40324,NULL,'2023-10-09 12:00:15','2023-10-16 15:31:57'),(2223,'2023-10-09 08:25:44','2023-10-09 17:00:14','12.249.250.150','12.249.250.150','closed',8,514,'attendances/775/1696865144 clock_in.png','attendances/775/1696896014 clock_out.png','Juan R',40323,NULL,'2023-10-09 12:25:44','2023-10-16 15:31:50'),(2227,'2023-10-10 05:54:07','2023-10-10 15:44:41','12.249.250.150','12.249.250.150','closed',9,590,'attendances/1116/1696942447 clock_in.png','attendances/1116/1696977881 clock_out.png','Juan R',40425,NULL,'2023-10-10 09:54:07','2023-10-16 15:31:12'),(2228,'2023-10-10 05:54:12','2023-10-10 14:36:06','12.249.250.150','12.249.250.150','closed',8,521,'attendances/1551/1696942452 clock_in.png','attendances/1551/1696973766 clock_out.png','Juan R',40419,NULL,'2023-10-10 09:54:12','2023-10-16 15:27:26'),(2229,'2023-10-10 05:54:27','2023-10-10 18:46:34','12.249.250.150','12.249.250.150','closed',12,772,'attendances/2025/1696942467 clock_in.png','attendances/2025/1696988794 clock_out.png','Juan R',40427,NULL,'2023-10-10 09:54:27','2023-10-16 15:33:28'),(2230,'2023-10-10 05:54:59','2023-10-10 14:31:22','12.249.250.150','12.249.250.150','closed',8,516,'attendances/726/1696942499 clock_in.png','attendances/726/1696973482 clock_out.png','Juan R',40418,NULL,'2023-10-10 09:54:59','2023-10-16 15:27:16'),(2231,'2023-10-10 05:55:16','2023-10-10 14:37:05','12.249.250.150','12.249.250.150','closed',8,521,'attendances/382/1696942516 clock_in.png','attendances/382/1696973825 clock_out.png','Juan R',40422,NULL,'2023-10-10 09:55:16','2023-10-16 15:28:48'),(2232,'2023-10-10 05:58:44','2023-10-10 18:45:07','12.249.250.150','12.249.250.150','closed',12,766,'attendances/1450/1696942724 clock_in.png','attendances/1450/1696988707 clock_out.png','Juan R',40426,NULL,'2023-10-10 09:58:44','2023-10-16 15:33:18'),(2233,'2023-10-10 05:59:01','2023-10-10 15:45:00','12.249.250.150','181.204.85.170','closed',9,585,'attendances/1568/1696942741 clock_in.png',NULL,'Juan R',40420,NULL,'2023-10-10 09:59:01','2023-10-16 15:27:39'),(2234,'2023-10-10 05:59:27','2023-10-10 14:36:33','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1588/1696942768 clock_in.png','attendances/1588/1696973793 clock_out.png','Juan R',40421,NULL,'2023-10-10 09:59:28','2023-10-16 15:28:37'),(2235,'2023-10-10 05:59:58','2023-10-10 16:32:04','12.249.250.150','12.249.250.150','closed',10,632,'attendances/1951/1696942798 clock_in.png','attendances/1951/1696980724 clock_out.png','Juan R',40423,NULL,'2023-10-10 09:59:58','2023-10-16 15:28:45'),(2236,'2023-10-10 06:00:26','2023-10-10 18:44:24','12.249.250.150','12.249.250.150','closed',12,763,'attendances/1455/1696942826 clock_in.png','attendances/1455/1696988664 clock_out.png','Juan R',40424,NULL,'2023-10-10 10:00:26','2023-10-16 15:30:06'),(2237,'2023-10-10 06:24:10','2023-10-10 15:31:04','12.249.250.150','12.249.250.150','closed',9,546,'attendances/622/1696944250 clock_in.png','attendances/622/1696977064 clock_out.png','Juan R',40439,NULL,'2023-10-10 10:24:10','2023-10-16 15:33:22'),(2238,'2023-10-10 06:52:02','2023-10-10 15:31:17','12.249.250.150','12.249.250.150','closed',8,519,'attendances/1774/1696945922 clock_in.png','attendances/1774/1696977077 clock_out.png','Juan R',40430,NULL,'2023-10-10 10:52:02','2023-10-16 15:29:08'),(2239,'2023-10-10 06:54:52','2023-10-10 18:55:58','12.249.250.150','12.249.250.150','closed',12,721,'attendances/1585/1696946092 clock_in.png','attendances/1585/1696989358 clock_out.png','Juan R',40428,NULL,'2023-10-10 10:54:52','2023-10-16 15:27:33'),(2240,'2023-10-10 06:55:39','2023-10-10 15:32:00','12.249.250.150','181.204.85.170','closed',8,516,'attendances/1934/1696946139 clock_in.png',NULL,'Juan R',40433,NULL,'2023-10-10 10:55:39','2023-10-16 15:30:01'),(2241,'2023-10-10 06:55:52','2023-10-10 15:37:11','12.249.250.150','12.249.250.150','closed',8,521,'attendances/1479/1696946152 clock_in.png','attendances/1479/1696977431 clock_out.png','Juan R',40429,NULL,'2023-10-10 10:55:52','2023-10-16 15:28:41'),(2242,'2023-10-10 06:55:53','2023-10-10 18:00:00','12.249.250.150','181.204.85.170','closed',11,664,'attendances/2005/1696946153 clock_in.png',NULL,'Juan R',40436,NULL,'2023-10-10 10:55:53','2023-10-16 15:31:08'),(2243,'2023-10-10 06:56:07','2023-10-10 15:47:03','12.249.250.150','12.249.250.150','closed',8,530,'attendances/1395/1696946167 clock_in.png','attendances/1395/1696978023 clock_out.png','Juan R',40437,NULL,'2023-10-10 10:56:07','2023-10-16 15:31:25'),(2244,'2023-10-10 06:56:11','2023-10-10 15:31:40','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1958/1696946171 clock_in.png','attendances/1958/1696977101 clock_out.png','Juan R',40431,NULL,'2023-10-10 10:56:11','2023-10-16 15:29:24'),(2245,'2023-10-10 06:56:57','2023-10-10 15:44:29','12.249.250.150','12.249.250.150','closed',8,527,'attendances/1728/1696946217 clock_in.png','attendances/1728/1696977869 clock_out.png','Juan R',40434,NULL,'2023-10-10 10:56:57','2023-10-16 15:30:36'),(2246,'2023-10-10 06:59:26','2023-10-10 15:44:12','12.249.250.150','181.204.85.170','closed',8,524,'attendances/1462/1696946366 clock_in.png','attendances/1462/1696963992 clock_out.png','Juan R',40432,NULL,'2023-10-10 10:59:26','2023-10-16 15:29:58'),(2247,'2023-10-10 06:59:46','2023-10-10 15:31:56','12.249.250.150','12.249.250.150','closed',8,512,'attendances/1858/1696946386 clock_in.png','attendances/1858/1696977116 clock_out.png','Juan R',40435,NULL,'2023-10-10 10:59:46','2023-10-16 15:30:42'),(2248,'2023-10-10 07:00:22','2023-10-10 15:36:13','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1948/1696946422 clock_in.png','attendances/1948/1696977373 clock_out.png','Juan R',40438,NULL,'2023-10-10 11:00:22','2023-10-16 15:32:26'),(2249,'2023-10-10 07:02:14','2023-10-10 11:55:00','12.249.250.150','190.120.253.128','closed',4,292,'attendances/974/1696946534 clock_in.png',NULL,'Juan R',40441,NULL,'2023-10-10 11:02:14','2023-10-16 15:26:49'),(2250,'2023-10-10 07:02:38','2023-10-10 15:35:49','12.249.250.150','12.249.250.150','closed',8,513,'attendances/1888/1696946558 clock_in.png','attendances/1888/1696977349 clock_out.png','Juan R',40440,NULL,'2023-10-10 11:02:56','2023-10-16 15:33:56'),(2251,'2023-10-10 08:02:36','2023-10-10 16:33:30','12.249.250.150','12.249.250.150','closed',8,510,'attendances/1869/1696950156 clock_in.png','attendances/1869/1696980810 clock_out.png','Juan R',40442,NULL,'2023-10-10 12:02:36','2023-10-16 15:27:46'),(2252,'2023-10-10 08:02:46','2023-10-10 16:33:38','12.249.250.150','12.249.250.150','closed',8,510,'attendances/1891/1696950166 clock_in.png','attendances/1891/1696980818 clock_out.png','Juan R',40444,NULL,'2023-10-10 12:02:46','2023-10-16 15:31:57'),(2253,'2023-10-10 08:25:52','2023-10-10 17:00:25','12.249.250.150','12.249.250.150','closed',8,514,'attendances/775/1696951552 clock_in.png','attendances/775/1696982425 clock_out.png','Juan R',40443,NULL,'2023-10-10 12:25:52','2023-10-16 15:31:50'),(2256,'2023-10-09 14:00:00','2023-10-09 15:57:00','181.250.229.199','186.86.52.144','closed',1,117,NULL,NULL,'Juan R',40446,NULL,'2023-10-10 19:59:35','2023-10-16 15:32:26'),(2258,'2023-10-11 05:55:08','2023-10-11 15:38:50','12.249.250.150','12.249.250.150','closed',9,583,'attendances/1116/1697028908 clock_in.png','attendances/1116/1697063930 clock_out.png','Juan R',40473,NULL,'2023-10-11 09:55:08','2023-10-16 15:31:12'),(2259,'2023-10-11 05:56:17','2023-10-11 19:00:21','12.249.250.150','12.249.250.150','closed',13,784,'attendances/1551/1697028977 clock_in.png','attendances/1551/1697076021 clock_out.png','Juan R',40469,NULL,'2023-10-11 09:56:17','2023-10-16 15:27:26'),(2260,'2023-10-11 05:57:03','2023-10-11 19:00:36','12.249.250.150','12.249.250.150','closed',13,783,'attendances/2005/1697029023 clock_in.png','attendances/2005/1697076036 clock_out.png','Juan R',40472,NULL,'2023-10-11 09:57:03','2023-10-16 15:31:08'),(2261,'2023-10-11 05:57:37','2023-10-11 19:01:47','12.249.250.150','12.249.250.150','closed',13,784,'attendances/382/1697029057 clock_in.png','attendances/382/1697076107 clock_out.png','Juan R',40471,NULL,'2023-10-11 09:57:37','2023-10-16 15:28:48'),(2262,'2023-10-11 06:32:04','2023-10-11 15:31:12','12.249.250.150','12.249.250.150','closed',8,539,'attendances/622/1697031124 clock_in.png','attendances/622/1697063472 clock_out.png','Juan R',40466,NULL,'2023-10-11 10:32:04','2023-10-16 15:33:22'),(2263,'2023-10-11 06:51:45','2023-10-11 15:41:20','12.249.250.150','12.249.250.150','closed',8,529,'attendances/1395/1697032305 clock_in.png','attendances/1395/1697064080 clock_out.png','Juan R',40463,NULL,'2023-10-11 10:51:45','2023-10-16 15:31:25'),(2264,'2023-10-11 06:53:40','2023-10-11 15:32:45','12.249.250.150','12.249.250.150','closed',8,519,'attendances/1774/1697032420 clock_in.png','attendances/1774/1697063565 clock_out.png','Juan R',40455,NULL,'2023-10-11 10:53:40','2023-10-16 15:29:08'),(2265,'2023-10-11 06:53:46','2023-10-11 15:36:57','12.249.250.150','12.249.250.150','closed',8,523,'attendances/726/1697032426 clock_in.png','attendances/726/1697063817 clock_out.png','Juan R',40451,NULL,'2023-10-11 10:53:46','2023-10-16 15:27:16'),(2266,'2023-10-11 06:54:29','2023-10-11 18:19:47','12.249.250.150','12.249.250.150','closed',11,685,'attendances/1455/1697032469 clock_in.png','attendances/1455/1697073587 clock_out.png','Juan R',40460,NULL,'2023-10-11 10:54:29','2023-10-16 15:30:06'),(2267,'2023-10-11 06:54:41','2023-10-11 18:35:29','12.249.250.150','12.249.250.150','closed',11,700,'attendances/2025/1697032481 clock_in.png','attendances/2025/1697074529 clock_out.png','Juan R',40467,NULL,'2023-10-11 10:54:41','2023-10-16 15:33:28'),(2268,'2023-10-11 06:54:57','2023-10-11 15:32:55','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1568/1697032497 clock_in.png','attendances/1568/1697063575 clock_out.png','Juan R',40452,NULL,'2023-10-11 10:54:57','2023-10-16 15:27:39'),(2269,'2023-10-11 06:56:12','2023-10-11 15:32:11','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1934/1697032572 clock_in.png','attendances/1934/1697063531 clock_out.png','Juan R',40459,NULL,'2023-10-11 10:56:12','2023-10-16 15:30:01'),(2270,'2023-10-11 06:56:24','2023-10-11 18:35:02','12.249.250.150','12.249.250.150','closed',11,698,'attendances/1450/1697032584 clock_in.png','attendances/1450/1697074503 clock_out.png','Juan R',40465,NULL,'2023-10-11 10:56:24','2023-10-16 15:33:18'),(2271,'2023-10-11 06:57:07','2023-10-11 15:31:56','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1958/1697032627 clock_in.png','attendances/1958/1697063516 clock_out.png','Juan R',40456,NULL,'2023-10-11 10:57:07','2023-10-16 15:29:24'),(2272,'2023-10-11 06:57:20','2023-10-11 15:31:28','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1858/1697032640 clock_in.png','attendances/1858/1697063488 clock_out.png','Juan R',40462,NULL,'2023-10-11 10:57:20','2023-10-16 15:30:42'),(2273,'2023-10-11 06:57:54','2023-10-11 15:31:22','12.249.250.150','12.249.250.150','closed',8,513,'attendances/1728/1697032674 clock_in.png','attendances/1728/1697063482 clock_out.png','Juan R',40461,NULL,'2023-10-11 10:57:54','2023-10-16 15:30:36'),(2274,'2023-10-11 06:58:08','2023-10-11 15:31:06','12.249.250.150','12.249.250.150','closed',8,512,'attendances/1999/1697032688 clock_in.png','attendances/1999/1697063466 clock_out.png','Juan R',40457,NULL,'2023-10-11 10:58:08','2023-10-16 15:29:30'),(2275,'2023-10-11 06:59:22','2023-10-11 15:38:01','12.249.250.150','12.249.250.150','closed',8,518,'attendances/1462/1697032762 clock_in.png','attendances/1462/1697063881 clock_out.png','Juan R',40458,NULL,'2023-10-11 10:59:22','2023-10-16 15:29:58'),(2276,'2023-10-11 06:59:48','2023-10-11 15:34:04','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1948/1697032788 clock_in.png','attendances/1948/1697063644 clock_out.png','Juan R',40464,NULL,'2023-10-11 10:59:48','2023-10-16 15:32:26'),(2277,'2023-10-11 07:01:02','2023-10-11 15:30:53','12.249.250.150','12.249.250.150','closed',8,509,'attendances/974/1697032862 clock_in.png','attendances/974/1697063453 clock_out.png','Juan R',40447,NULL,'2023-10-11 11:01:02','2023-10-16 15:26:49'),(2278,'2023-10-11 07:04:43','2023-10-11 15:41:30','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1888/1697033083 clock_in.png','attendances/1888/1697064090 clock_out.png','Juan R',40468,NULL,'2023-10-11 11:04:43','2023-10-16 15:33:56'),(2279,'2023-10-11 07:04:50','2023-10-11 15:33:28','12.249.250.150','12.249.250.150','closed',8,508,'attendances/1951/1697033090 clock_in.png','attendances/1951/1697063608 clock_out.png','Juan R',40454,NULL,'2023-10-11 11:04:50','2023-10-16 15:28:45'),(2280,'2023-10-11 08:06:11','2023-10-11 16:36:51','12.249.250.150','12.249.250.150','closed',8,510,'attendances/1869/1697036771 clock_in.png','attendances/1869/1697067411 clock_out.png','Juan R',40448,NULL,'2023-10-11 12:06:11','2023-10-16 15:27:46'),(2281,'2023-10-11 08:06:24','2023-10-11 16:38:42','12.249.250.150','12.249.250.150','closed',8,512,'attendances/1891/1697036784 clock_in.png','attendances/1891/1697067522 clock_out.png','Juan R',40450,NULL,'2023-10-11 12:06:24','2023-10-16 15:31:57'),(2282,'2023-10-11 08:26:33','2023-10-11 17:00:09','12.249.250.150','12.249.250.150','closed',8,513,'attendances/775/1697037993 clock_in.png','attendances/775/1697068809 clock_out.png','Juan R',40449,NULL,'2023-10-11 12:26:33','2023-10-16 15:31:50'),(2283,'2023-10-11 08:55:17','2023-10-11 15:31:40','12.249.250.150','12.249.250.150','closed',6,396,'attendances/1479/1697039717 clock_in.png','attendances/1479/1697063500 clock_out.png','Juan R',40474,NULL,'2023-10-11 12:55:17','2023-10-16 15:28:41'),(2284,'2023-10-11 05:54:00','2023-10-11 19:00:53','181.250.229.199','12.249.250.150','closed',13,786,NULL,'attendances/1585/1697076053 clock_out.png','Juan R',40470,NULL,'2023-10-11 19:21:09','2023-10-16 15:27:33'),(2285,'2023-10-12 05:54:12','2023-10-12 17:27:41','12.249.250.150','12.249.250.150','closed',11,693,'attendances/2025/1697115252 clock_in.png','attendances/2025/1697156861 clock_out.png','Juan R',40496,NULL,'2023-10-12 09:54:12','2023-10-16 15:33:28'),(2286,'2023-10-12 05:57:05','2023-10-12 17:57:21','12.249.250.150','12.249.250.150','closed',12,720,'attendances/2005/1697115425 clock_in.png','attendances/2005/1697158641 clock_out.png','Juan R',40494,NULL,'2023-10-12 09:57:05','2023-10-16 15:31:08'),(2287,'2023-10-12 05:57:17','2023-10-12 17:54:32','12.249.250.150','12.249.250.150','closed',11,717,'attendances/1585/1697115437 clock_in.png','attendances/1585/1697158472 clock_out.png','Juan R',40491,NULL,'2023-10-12 09:57:17','2023-10-16 15:27:33'),(2288,'2023-10-12 05:57:38','2023-10-12 18:17:42','12.249.250.150','12.249.250.150','closed',12,740,'attendances/1551/1697115458 clock_in.png','attendances/1551/1697159862 clock_out.png','Juan R',40490,NULL,'2023-10-12 09:57:38','2023-10-16 15:27:26'),(2289,'2023-10-12 05:58:24','2023-10-12 17:37:50','12.249.250.150','12.249.250.150','closed',11,699,'attendances/1455/1697115504 clock_in.png','attendances/1455/1697157470 clock_out.png','Juan R',40493,NULL,'2023-10-12 09:58:24','2023-10-16 15:30:06'),(2290,'2023-10-12 06:01:04','2023-10-12 17:38:11','12.249.250.150','12.249.250.150','closed',11,697,'attendances/1450/1697115664 clock_in.png','attendances/1450/1697157491 clock_out.png','Juan R',40495,NULL,'2023-10-12 10:01:04','2023-10-16 15:33:18'),(2291,'2023-10-12 06:04:36','2023-10-12 18:30:05','12.249.250.150','12.249.250.150','closed',12,745,'attendances/382/1697115876 clock_in.png','attendances/382/1697160605 clock_out.png','Juan R',40492,NULL,'2023-10-12 10:04:36','2023-10-16 15:28:48'),(2292,'2023-10-12 06:35:25','2023-10-12 15:32:08','12.249.250.150','12.249.250.150','closed',8,536,'attendances/622/1697117725 clock_in.png','attendances/622/1697149928 clock_out.png','Juan R',40511,NULL,'2023-10-12 10:35:25','2023-10-16 15:33:22'),(2293,'2023-10-12 06:50:10','2023-10-12 17:44:48','12.249.250.150','12.249.250.150','closed',10,654,'attendances/1395/1697118610 clock_in.png','attendances/1395/1697157888 clock_out.png','Juan R',40509,NULL,'2023-10-12 10:50:10','2023-10-16 15:31:25'),(2294,'2023-10-12 06:53:06','2023-10-12 15:33:07','12.249.250.150','12.249.250.150','closed',8,520,'attendances/1774/1697118786 clock_in.png','attendances/1774/1697149987 clock_out.png','Juan R',40502,NULL,'2023-10-12 10:53:06','2023-10-16 15:29:08'),(2295,'2023-10-12 06:54:09','2023-10-12 15:47:10','12.249.250.150','12.249.250.150','closed',8,533,'attendances/726/1697118849 clock_in.png','attendances/726/1697150830 clock_out.png','Juan R',40497,NULL,'2023-10-12 10:54:09','2023-10-16 15:27:16'),(2296,'2023-10-12 06:54:29','2023-10-12 18:57:15','12.249.250.150','12.249.250.150','closed',12,722,'attendances/1479/1697118869 clock_in.png','attendances/1479/1697162235 clock_out.png','Juan R',40500,NULL,'2023-10-12 10:54:29','2023-10-16 15:28:41'),(2297,'2023-10-12 06:54:33','2023-10-12 18:57:51','12.249.250.150','12.249.250.150','closed',12,723,'attendances/1951/1697118873 clock_in.png','attendances/1951/1697162271 clock_out.png','Juan R',40501,NULL,'2023-10-12 10:54:33','2023-10-16 15:28:45'),(2298,'2023-10-12 06:56:05','2023-10-12 17:03:58','12.249.250.150','12.249.250.150','closed',10,607,'attendances/1568/1697118965 clock_in.png','attendances/1568/1697155438 clock_out.png','Juan R',40498,NULL,'2023-10-12 10:56:05','2023-10-16 15:27:39'),(2299,'2023-10-12 06:56:12','2023-10-12 16:45:16','12.249.250.150','12.249.250.150','closed',9,589,'attendances/1728/1697118972 clock_in.png','attendances/1728/1697154316 clock_out.png','Juan R',40507,NULL,'2023-10-12 10:56:12','2023-10-16 15:30:36'),(2300,'2023-10-12 06:56:24','2023-10-12 15:32:40','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1934/1697118984 clock_in.png','attendances/1934/1697149960 clock_out.png','Juan R',40506,NULL,'2023-10-12 10:56:24','2023-10-16 15:30:01'),(2301,'2023-10-12 06:57:44','2023-10-12 15:31:09','12.249.250.150','12.249.250.150','closed',8,513,'attendances/1588/1697119064 clock_in.png','attendances/1588/1697149869 clock_out.png','Juan R',40499,NULL,'2023-10-12 10:57:44','2023-10-16 15:28:37'),(2302,'2023-10-12 06:58:34','2023-10-12 15:30:48','12.249.250.150','12.249.250.150','closed',8,512,'attendances/1958/1697119114 clock_in.png','attendances/1958/1697149848 clock_out.png','Juan R',40503,NULL,'2023-10-12 10:58:34','2023-10-16 15:29:24'),(2303,'2023-10-12 06:58:56','2023-10-12 17:03:57','12.249.250.150','12.249.250.150','closed',10,605,'attendances/1999/1697119136 clock_in.png','attendances/1999/1697155437 clock_out.png','Juan R',40504,NULL,'2023-10-12 10:58:56','2023-10-16 15:29:30'),(2304,'2023-10-12 07:00:25','2023-10-12 16:52:40','12.249.250.150','12.249.250.150','closed',9,592,'attendances/974/1697119225 clock_in.png','attendances/974/1697154760 clock_out.png','Juan R',40513,NULL,'2023-10-12 11:00:25','2023-10-16 15:26:49'),(2305,'2023-10-12 07:02:11','2023-10-12 12:44:54','12.249.250.150','12.249.250.150','closed',5,342,'attendances/1948/1697119331 clock_in.png','attendances/1948/1697139894 clock_out.png','Juan R',40510,NULL,'2023-10-12 11:02:11','2023-10-16 15:32:26'),(2306,'2023-10-12 07:02:25','2023-10-12 17:03:05','12.249.250.150','12.249.250.150','closed',10,600,'attendances/1869/1697119345 clock_in.png','attendances/1869/1697155385 clock_out.png','Juan R',40514,NULL,'2023-10-12 11:02:25','2023-10-16 15:27:46'),(2307,'2023-10-12 07:02:37','2023-10-12 17:03:15','12.249.250.150','12.249.250.150','closed',10,600,'attendances/1891/1697119357 clock_in.png','attendances/1891/1697155395 clock_out.png','Juan R',40515,NULL,'2023-10-12 11:02:37','2023-10-16 15:31:57'),(2308,'2023-10-12 07:03:34','2023-10-12 15:50:38','12.249.250.150','12.249.250.150','closed',8,527,'attendances/1888/1697119414 clock_in.png','attendances/1888/1697151038 clock_out.png','Juan R',40512,NULL,'2023-10-12 11:03:34','2023-10-16 15:33:56'),(2309,'2023-10-12 07:04:46','2023-10-12 15:37:00','12.249.250.150','186.154.240.36','closed',8,512,'attendances/1462/1697119486 clock_in.png',NULL,'Juan R',40505,NULL,'2023-10-12 11:04:46','2023-10-16 15:29:58'),(2310,'2023-10-12 07:09:12','2023-10-12 15:34:26','12.249.250.150','12.249.250.150','closed',8,505,'attendances/1858/1697119752 clock_in.png','attendances/1858/1697150066 clock_out.png','Juan R',40508,NULL,'2023-10-12 11:09:12','2023-10-16 15:30:42'),(2311,'2023-10-12 08:19:33','2023-10-12 17:45:40','12.249.250.150','12.249.250.150','closed',9,566,'attendances/1116/1697123973 clock_in.png','attendances/1116/1697157940 clock_out.png','Juan R',40516,NULL,'2023-10-12 12:19:33','2023-10-16 15:31:12'),(2312,'2023-10-12 08:27:00','2023-10-12 16:59:57','12.249.250.150','12.249.250.150','closed',8,512,'attendances/775/1697124420 clock_in.png','attendances/775/1697155197 clock_out.png','Juan R',40517,NULL,'2023-10-12 12:27:00','2023-10-16 15:31:50'),(2313,'2023-10-13 05:56:10','2023-10-13 16:35:14','12.249.250.150','12.249.250.150','closed',10,639,'attendances/2025/1697201770 clock_in.png','attendances/2025/1697240114 clock_out.png','Juan R',40566,NULL,'2023-10-13 09:56:10','2023-10-16 15:33:28'),(2314,'2023-10-13 05:57:36','2023-10-13 18:04:38','12.249.250.150','12.249.250.150','closed',12,727,'attendances/382/1697201856 clock_in.png','attendances/382/1697245478 clock_out.png','Juan R',40563,NULL,'2023-10-13 09:57:36','2023-10-16 15:28:48'),(2315,'2023-10-13 05:58:12','2023-10-13 17:52:22','12.249.250.150','12.249.250.150','closed',11,714,'attendances/1585/1697201892 clock_in.png','attendances/1585/1697244742 clock_out.png','Juan R',40562,NULL,'2023-10-13 09:58:19','2023-10-16 15:27:33'),(2316,'2023-10-13 05:59:20','2023-10-13 18:04:22','12.249.250.150','12.249.250.150','closed',12,725,'attendances/1551/1697201960 clock_in.png','attendances/1551/1697245463 clock_out.png','Juan R',40561,NULL,'2023-10-13 09:59:20','2023-10-16 15:27:26'),(2317,'2023-10-13 05:59:46','2023-10-13 16:33:17','12.249.250.150','12.249.250.150','closed',10,633,'attendances/1450/1697201986 clock_in.png','attendances/1450/1697239997 clock_out.png','Juan R',40565,NULL,'2023-10-13 09:59:46','2023-10-16 15:33:18'),(2318,'2023-10-13 06:35:02','2023-10-13 15:32:46','12.249.250.150','12.249.250.150','closed',8,537,'attendances/622/1697204102 clock_in.png','attendances/622/1697236366 clock_out.png','Juan R',40559,NULL,'2023-10-13 10:35:02','2023-10-16 15:33:22'),(2319,'2023-10-13 06:53:06','2023-10-13 15:32:20','12.249.250.150','12.249.250.150','closed',8,519,'attendances/1774/1697205186 clock_in.png','attendances/1774/1697236340 clock_out.png','Juan R',40549,NULL,'2023-10-13 10:53:06','2023-10-16 15:29:08'),(2320,'2023-10-13 06:53:26','2023-10-13 17:30:51','12.249.250.150','12.249.250.150','closed',10,637,'attendances/726/1697205206 clock_in.png','attendances/726/1697243451 clock_out.png','Juan R',40544,NULL,'2023-10-13 10:53:26','2023-10-16 15:27:16'),(2321,'2023-10-13 06:53:49','2023-10-13 16:06:36','12.249.250.150','12.249.250.150','closed',9,552,'attendances/1395/1697205229 clock_in.png','attendances/1395/1697238396 clock_out.png','Juan R',40557,NULL,'2023-10-13 10:53:49','2023-10-16 15:31:25'),(2322,'2023-10-13 06:54:11','2023-10-13 15:51:51','12.249.250.150','12.249.250.150','closed',8,537,'attendances/1116/1697205251 clock_in.png','attendances/1116/1697237511 clock_out.png','Juan R',40556,NULL,'2023-10-13 10:54:11','2023-10-16 15:31:12'),(2323,'2023-10-13 06:54:55','2023-10-13 16:13:04','12.249.250.150','12.249.250.150','closed',9,558,'attendances/1479/1697205295 clock_in.png','attendances/1479/1697238784 clock_out.png','Juan R',40547,NULL,'2023-10-13 10:54:55','2023-10-16 15:28:41'),(2324,'2023-10-13 06:55:07','2023-10-13 16:48:09','12.249.250.150','12.249.250.150','closed',9,593,'attendances/1999/1697205307 clock_in.png','attendances/1999/1697240889 clock_out.png','Juan R',40551,NULL,'2023-10-13 10:55:07','2023-10-16 15:29:30'),(2325,'2023-10-13 06:56:42','2023-10-13 15:36:49','12.249.250.150','12.249.250.150','closed',8,520,'attendances/1958/1697205402 clock_in.png','attendances/1958/1697236609 clock_out.png','Juan R',40550,NULL,'2023-10-13 10:56:42','2023-10-16 15:29:24'),(2326,'2023-10-13 06:56:47','2023-10-13 15:43:00','12.249.250.150','12.249.250.150','closed',8,526,'attendances/1948/1697205407 clock_in.png','attendances/1948/1697236980 clock_out.png','Juan R',40558,NULL,'2023-10-13 10:56:47','2023-10-16 15:32:26'),(2327,'2023-10-13 06:58:07','2023-10-13 15:31:35','12.249.250.150','12.249.250.150','closed',8,513,'attendances/1934/1697205487 clock_in.png','attendances/1934/1697236295 clock_out.png','Juan R',40553,NULL,'2023-10-13 10:58:07','2023-10-16 15:30:01'),(2328,'2023-10-13 06:58:10','2023-10-13 16:55:44','12.249.250.150','12.249.250.150','closed',9,597,'attendances/1728/1697205490 clock_in.png','attendances/1728/1697241344 clock_out.png','Juan R',40554,NULL,'2023-10-13 10:58:10','2023-10-16 15:30:36'),(2329,'2023-10-13 06:59:28','2023-10-13 15:34:02','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1568/1697205568 clock_in.png','attendances/1568/1697236442 clock_out.png','Juan R',40545,NULL,'2023-10-13 10:59:28','2023-10-16 15:27:39'),(2330,'2023-10-13 06:59:39','2023-10-13 15:34:49','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1951/1697205579 clock_in.png','attendances/1951/1697236489 clock_out.png','Juan R',40548,NULL,'2023-10-13 10:59:39','2023-10-16 15:28:45'),(2331,'2023-10-13 06:59:51','2023-10-13 15:34:00','12.249.250.150','179.19.171.94','closed',8,514,'attendances/1588/1697205591 clock_in.png',NULL,'Juan R',40546,NULL,'2023-10-13 10:59:51','2023-10-16 15:28:37'),(2332,'2023-10-13 07:01:06','2023-10-13 16:52:36','12.249.250.150','12.249.250.150','closed',9,591,'attendances/974/1697205666 clock_in.png','attendances/974/1697241156 clock_out.png','Juan R',40539,NULL,'2023-10-13 11:01:06','2023-10-16 15:26:49'),(2333,'2023-10-13 07:01:06','2023-10-13 17:06:30','12.249.250.150','12.249.250.150','closed',10,605,'attendances/1869/1697205666 clock_in.png','attendances/1869/1697241990 clock_out.png','Juan R',40540,NULL,'2023-10-13 11:01:06','2023-10-16 15:27:46'),(2334,'2023-10-13 07:01:14','2023-10-13 17:06:15','12.249.250.150','12.249.250.150','closed',10,605,'attendances/1891/1697205674 clock_in.png','attendances/1891/1697241975 clock_out.png','Juan R',40542,NULL,'2023-10-13 11:01:14','2023-10-16 15:31:57'),(2335,'2023-10-13 07:05:45','2023-10-13 15:41:55','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1888/1697205945 clock_in.png','attendances/1888/1697236915 clock_out.png','Juan R',40560,NULL,'2023-10-13 11:05:45','2023-10-16 15:33:56'),(2336,'2023-10-13 07:06:21','2023-10-13 15:36:24','12.249.250.150','12.249.250.150','closed',8,510,'attendances/1858/1697205981 clock_in.png','attendances/1858/1697236584 clock_out.png','Juan R',40555,NULL,'2023-10-13 11:06:21','2023-10-16 15:30:42'),(2337,'2023-10-13 07:10:32','2023-10-13 15:39:27','12.249.250.150','12.249.250.150','closed',8,508,'attendances/1462/1697206232 clock_in.png','attendances/1462/1697236767 clock_out.png','Juan R',40552,NULL,'2023-10-13 11:10:32','2023-10-16 15:29:58'),(2338,'2023-10-13 08:00:48','2023-10-13 16:16:45','12.249.250.150','12.249.250.150','closed',8,495,'attendances/1455/1697209248 clock_in.png','attendances/1455/1697239005 clock_out.png','Juan R',40541,NULL,'2023-10-13 12:00:48','2023-10-16 15:30:06'),(2339,'2023-10-13 08:26:20','2023-10-13 17:00:04','12.249.250.150','12.249.250.150','closed',8,513,'attendances/775/1697210780 clock_in.png','attendances/775/1697241604 clock_out.png','Juan R',40543,NULL,'2023-10-13 12:26:20','2023-10-16 15:31:50'),(2341,'2023-10-14 05:52:29','2023-10-14 14:31:10','12.249.250.150','12.249.250.150','closed',8,518,'attendances/622/1697287949 clock_in.png','attendances/622/1697319070 clock_out.png','Juan R',40632,NULL,'2023-10-14 09:52:29','2023-10-16 15:33:22'),(2342,'2023-10-14 05:57:56','2023-10-14 14:35:00','12.249.250.150','191.106.139.228','closed',8,517,'attendances/1774/1697288276 clock_in.png',NULL,'Juan R',40633,NULL,'2023-10-14 09:57:56','2023-10-16 15:29:08'),(2343,'2023-10-14 06:03:22','2023-10-14 17:33:31','12.249.250.150','12.249.250.150','closed',11,690,'attendances/1450/1697288602 clock_in.png','attendances/1450/1697330011 clock_out.png','Juan R',40625,NULL,'2023-10-14 10:03:22','2023-10-16 15:33:18'),(2344,'2023-10-14 06:03:33','2023-10-14 14:36:43','12.249.250.150','12.249.250.150','closed',8,513,'attendances/1869/1697288613 clock_in.png','attendances/1869/1697319403 clock_out.png','Juan R',40623,NULL,'2023-10-14 10:03:33','2023-10-16 15:27:46'),(2345,'2023-10-14 06:03:43','2023-10-14 14:37:07','12.249.250.150','12.249.250.150','closed',8,513,'attendances/1891/1697288623 clock_in.png','attendances/1891/1697319427 clock_out.png','Juan R',40624,NULL,'2023-10-14 10:03:43','2023-10-16 15:31:57'),(2346,'2023-10-14 06:20:40','2023-10-14 14:39:28','12.249.250.150','12.249.250.150','closed',8,498,'attendances/1858/1697289640 clock_in.png','attendances/1858/1697319568 clock_out.png','Juan R',40631,NULL,'2023-10-14 10:20:40','2023-10-16 15:30:42'),(2347,'2023-10-14 06:20:55','2023-10-14 14:39:15','12.249.250.150','12.249.250.150','closed',8,498,'attendances/1958/1697289655 clock_in.png','attendances/1958/1697319555 clock_out.png','Juan R',40630,NULL,'2023-10-14 10:20:55','2023-10-16 15:29:24'),(2348,'2023-10-14 06:54:32','2023-10-14 18:45:55','12.249.250.150','12.249.250.150','closed',11,711,'attendances/1585/1697291672 clock_in.png','attendances/1585/1697334355 clock_out.png','Juan R',40627,NULL,'2023-10-14 10:54:32','2023-10-16 15:27:33'),(2349,'2023-10-14 06:56:46','2023-10-14 18:42:25','12.249.250.150','12.249.250.150','closed',11,705,'attendances/382/1697291806 clock_in.png','attendances/382/1697334145 clock_out.png','Juan R',40628,NULL,'2023-10-14 10:56:46','2023-10-16 15:28:48'),(2350,'2023-10-14 06:57:02','2023-10-14 18:42:51','12.249.250.150','12.249.250.150','closed',11,705,'attendances/1551/1697291822 clock_in.png','attendances/1551/1697334171 clock_out.png','Juan R',40626,NULL,'2023-10-14 10:57:02','2023-10-16 15:27:26'),(2351,'2023-10-14 07:03:08','2023-10-14 18:42:11','12.249.250.150','12.249.250.150','closed',11,699,'attendances/1455/1697292188 clock_in.png','attendances/1455/1697334131 clock_out.png','Juan R',40629,NULL,'2023-10-14 11:03:08','2023-10-16 15:30:06'),(2352,'2023-10-16 05:53:37','2023-10-16 16:08:39','12.249.250.150','12.249.250.150','closed',10,615,'attendances/726/1697460817 clock_in.png','attendances/726/1697497719 clock_out.png','Juan R',40672,NULL,'2023-10-16 09:53:37','2023-10-23 13:48:00'),(2353,'2023-10-16 05:53:51','2023-10-16 17:00:52','12.249.250.150','12.249.250.150','closed',11,667,'attendances/1585/1697460831 clock_in.png','attendances/1585/1697500852 clock_out.png','Juan R',40675,NULL,'2023-10-16 09:53:51','2023-10-23 13:48:07'),(2354,'2023-10-16 05:54:09','2023-10-16 18:46:43','12.249.250.150','12.249.250.150','closed',12,772,'attendances/1551/1697460849 clock_in.png','attendances/1551/1697507203 clock_out.png','Juan R',40674,NULL,'2023-10-16 09:54:09','2023-10-23 13:48:04'),(2355,'2023-10-16 05:54:32','2023-10-16 18:50:00','12.249.250.150','181.204.85.170','closed',12,775,'attendances/2005/1697460872 clock_in.png',NULL,'Juan R',40679,NULL,'2023-10-16 09:54:32','2023-10-23 13:49:14'),(2356,'2023-10-16 05:55:27','2023-10-16 15:37:45','12.249.250.150','12.249.250.150','closed',9,582,'attendances/1958/1697460927 clock_in.png','attendances/1958/1697495865 clock_out.png','Juan R',40671,NULL,'2023-10-16 09:55:27','2023-10-23 13:48:45'),(2357,'2023-10-16 05:58:30','2023-10-16 15:30:33','12.249.250.150','186.154.240.36','closed',9,572,'attendances/1588/1697461110 clock_in.png','attendances/1588/1697477427 clock_out.png','Juan R',40676,NULL,'2023-10-16 09:58:30','2023-10-23 13:48:20'),(2358,'2023-10-16 05:59:47','2023-10-16 15:32:20','12.249.250.150','12.249.250.150','closed',9,572,'attendances/1568/1697461187 clock_in.png','attendances/1568/1697495540 clock_out.png','Juan R',40673,NULL,'2023-10-16 09:59:47','2023-10-23 13:48:11'),(2359,'2023-10-16 06:01:01','2023-10-16 18:28:53','12.249.250.150','12.249.250.150','closed',12,747,'attendances/1888/1697461261 clock_in.png','attendances/1888/1697506133 clock_out.png',NULL,40669,NULL,'2023-10-16 10:01:01','2023-10-16 22:28:53'),(2360,'2023-10-16 06:01:25','2023-10-16 15:29:34','12.249.250.150','12.249.250.150','closed',9,568,'attendances/1951/1697461285 clock_in.png','attendances/1951/1697495374 clock_out.png','Juan R',40678,NULL,'2023-10-16 10:01:25','2023-10-23 13:48:33'),(2361,'2023-10-16 06:11:57','2023-10-16 15:37:17','12.249.250.150','12.249.250.150','closed',9,565,'attendances/1858/1697461917 clock_in.png','attendances/1858/1697495837 clock_out.png','Juan R',40670,NULL,'2023-10-16 10:11:57','2023-10-23 13:49:01'),(2362,'2023-10-16 06:25:47','2023-10-16 15:31:34','12.249.250.150','12.249.250.150','closed',9,545,'attendances/622/1697462747 clock_in.png','attendances/622/1697495494 clock_out.png','Juan R',40667,NULL,'2023-10-16 10:25:47','2023-10-23 13:58:59'),(2363,'2023-10-16 06:51:30','2023-10-16 16:21:55','12.249.250.150','179.19.133.251','closed',9,570,'attendances/1999/1697464290 clock_in.png','attendances/1999/1697481276 clock_out.png','Juan R',40660,NULL,'2023-10-16 10:51:30','2023-10-23 13:48:48'),(2364,'2023-10-16 06:53:31','2023-10-16 15:31:22','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1774/1697464411 clock_in.png','attendances/1774/1697495482 clock_out.png','Juan R',40659,NULL,'2023-10-16 10:53:31','2023-10-23 13:48:43'),(2365,'2023-10-16 06:53:59','2023-10-16 15:31:47','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1934/1697464439 clock_in.png','attendances/1934/1697495507 clock_out.png','Juan R',40661,NULL,'2023-10-16 10:53:59','2023-10-23 13:48:53'),(2366,'2023-10-16 06:54:13','2023-10-16 16:30:46','12.249.250.150','12.249.250.150','closed',9,576,'attendances/1116/1697464453 clock_in.png','attendances/1116/1697499046 clock_out.png','Juan R',40663,NULL,'2023-10-16 10:54:13','2023-10-23 13:49:56'),(2367,'2023-10-16 06:55:49','2023-10-16 15:36:41','12.249.250.150','12.249.250.150','closed',8,520,'attendances/1395/1697464549 clock_in.png','attendances/1395/1697495801 clock_out.png','Juan R',40664,NULL,'2023-10-16 10:55:49','2023-10-23 13:55:39'),(2368,'2023-10-16 06:57:22','2023-10-16 15:36:09','12.249.250.150','12.249.250.150','closed',8,518,'attendances/1728/1697464642 clock_in.png','attendances/1728/1697495769 clock_out.png','Juan R',40662,NULL,'2023-10-16 10:57:22','2023-10-23 13:48:59'),(2369,'2023-10-16 06:57:47','2023-10-16 16:33:04','12.249.250.150','12.249.250.150','closed',9,575,'attendances/1869/1697464667 clock_in.png','attendances/1869/1697499184 clock_out.png','Juan R',40642,NULL,'2023-10-16 10:57:47','2023-10-23 13:48:14'),(2370,'2023-10-16 06:57:58','2023-10-16 16:33:16','12.249.250.150','12.249.250.150','closed',9,575,'attendances/1891/1697464678 clock_in.png','attendances/1891/1697499196 clock_out.png','Juan R',40645,NULL,'2023-10-16 10:57:58','2023-10-23 13:55:47'),(2371,'2023-10-16 06:58:52','2023-10-16 17:58:05','12.249.250.150','12.249.250.150','closed',10,659,'attendances/2025/1697464732 clock_in.png','attendances/2025/1697504285 clock_out.png',NULL,40668,NULL,'2023-10-16 10:58:52','2023-10-16 21:58:05'),(2372,'2023-10-16 06:58:57','2023-10-16 15:35:56','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1479/1697464737 clock_in.png','attendances/1479/1697495756 clock_out.png','Juan R',40658,NULL,'2023-10-16 10:58:57','2023-10-23 13:48:29'),(2373,'2023-10-16 06:59:12','2023-10-16 16:27:32','12.249.250.150','12.249.250.150','closed',9,568,'attendances/974/1697464752 clock_in.png','attendances/974/1697498852 clock_out.png','Juan R',40641,NULL,'2023-10-16 10:59:12','2023-10-23 13:47:54'),(2374,'2023-10-16 07:00:25','2023-10-16 15:47:46','12.249.250.150','12.249.250.150','closed',8,527,'attendances/1948/1697464825 clock_in.png','attendances/1948/1697496466 clock_out.png','Juan R',40665,NULL,'2023-10-16 11:00:25','2023-10-23 13:55:51'),(2375,'2023-10-16 07:01:04','2023-10-16 15:31:10','12.249.250.150','12.249.250.150','closed',8,510,'attendances/2116/1697464864 clock_in.png','attendances/2116/1697495470 clock_out.png','Juan R',40687,NULL,'2023-10-16 11:01:04','2023-10-23 13:48:24'),(2376,'2023-10-16 07:59:38','2023-10-16 16:30:03','12.249.250.150','12.249.250.150','closed',8,510,'attendances/775/1697468378 clock_in.png','attendances/775/1697499004 clock_out.png','Juan R',40644,NULL,'2023-10-16 11:59:38','2023-10-23 13:55:45'),(2377,'2023-10-16 08:08:19','2023-10-16 15:37:28','12.249.250.150','12.249.250.150','closed',7,449,'attendances/1462/1697468899 clock_in.png','attendances/1462/1697495848 clock_out.png','Juan R',40643,NULL,'2023-10-16 12:08:19','2023-10-23 13:48:50'),(2381,'2023-10-17 05:56:33','2023-10-17 21:16:27','12.249.250.150','12.249.250.150','closed',15,919,'attendances/1728/1697547393 clock_in.png','attendances/1728/1697602587 clock_out.png','Juan R',40702,NULL,'2023-10-17 09:56:33','2023-10-23 13:48:59'),(2382,'2023-10-17 05:57:39','2023-10-17 15:31:48','12.249.250.150','12.249.250.150','closed',9,574,'attendances/1958/1697547459 clock_in.png','attendances/1958/1697581908 clock_out.png','Juan R',40697,NULL,'2023-10-17 09:57:39','2023-10-23 13:48:45'),(2383,'2023-10-17 06:07:15','2023-10-17 15:34:14','12.249.250.150','12.249.250.150','closed',9,566,'attendances/1858/1697548035 clock_in.png','attendances/1858/1697582054 clock_out.png','Juan R',40703,NULL,'2023-10-17 10:07:15','2023-10-23 13:49:01'),(2384,'2023-10-17 06:41:21','2023-10-17 15:30:18','12.249.250.150','12.249.250.150','closed',8,528,'attendances/622/1697550081 clock_in.png','attendances/622/1697581818 clock_out.png','Juan R',40709,NULL,'2023-10-17 10:41:21','2023-10-23 13:58:59'),(2385,'2023-10-17 06:53:48','2023-10-17 15:32:01','12.249.250.150','12.249.250.150','closed',8,518,'attendances/726/1697550828 clock_in.png','attendances/726/1697581921 clock_out.png','Juan R',40688,NULL,'2023-10-17 10:53:48','2023-10-23 13:48:00'),(2386,'2023-10-17 06:54:11','2023-10-17 21:16:40','12.249.250.150','12.249.250.150','closed',14,862,'attendances/1116/1697550851 clock_in.png','attendances/1116/1697602600 clock_out.png','Juan R',40705,NULL,'2023-10-17 10:54:11','2023-10-23 13:49:56'),(2387,'2023-10-17 06:54:12','2023-10-17 15:31:37','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1585/1697550852 clock_in.png','attendances/1585/1697581897 clock_out.png','Juan R',40690,NULL,'2023-10-17 10:54:12','2023-10-23 13:48:07'),(2388,'2023-10-17 06:54:26','2023-10-17 17:00:00','12.249.250.150','179.19.12.252','closed',10,605,'attendances/2005/1697550866 clock_in.png',NULL,'Juan R',40704,NULL,'2023-10-17 10:54:26','2023-10-23 13:49:14'),(2389,'2023-10-17 06:55:12','2023-10-17 15:30:31','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1934/1697550912 clock_in.png','attendances/1934/1697581831 clock_out.png','Juan R',40700,NULL,'2023-10-17 10:55:12','2023-10-23 13:48:53'),(2390,'2023-10-17 06:56:13','2023-10-17 15:31:19','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1588/1697550973 clock_in.png','attendances/1588/1697581879 clock_out.png','Juan R',40692,NULL,'2023-10-17 10:56:13','2023-10-23 13:48:20'),(2391,'2023-10-17 06:56:26','2023-10-17 18:22:24','12.249.250.150','12.249.250.150','closed',11,685,'attendances/1551/1697550986 clock_in.png','attendances/1551/1697592144 clock_out.png','Juan R',40689,NULL,'2023-10-17 10:56:26','2023-10-23 13:48:04'),(2392,'2023-10-17 06:56:53','2023-10-17 17:38:12','12.249.250.150','12.249.250.150','closed',10,641,'attendances/1450/1697551013 clock_in.png','attendances/1450/1697589492 clock_out.png','Juan R',40708,NULL,'2023-10-17 10:56:53','2023-10-23 13:55:53'),(2393,'2023-10-17 06:57:02','2023-10-17 15:47:53','12.249.250.150','12.249.250.150','closed',8,530,'attendances/1479/1697551022 clock_in.png','attendances/1479/1697582873 clock_out.png','Juan R',40694,NULL,'2023-10-17 10:57:02','2023-10-23 13:48:29'),(2394,'2023-10-17 06:57:08','2023-10-17 15:34:34','12.249.250.150','12.249.250.150','closed',8,517,'attendances/2116/1697551028 clock_in.png','attendances/2116/1697582074 clock_out.png','Juan R',40693,NULL,'2023-10-17 10:57:08','2023-10-23 13:48:24'),(2395,'2023-10-17 06:57:19','2023-10-17 15:31:03','12.249.250.150','12.249.250.150','closed',8,513,'attendances/1774/1697551039 clock_in.png','attendances/1774/1697581863 clock_out.png','Juan R',40696,NULL,'2023-10-17 10:57:19','2023-10-23 13:48:43'),(2396,'2023-10-17 06:57:24','2023-10-17 21:17:22','12.249.250.150','12.249.250.150','closed',14,859,'attendances/1999/1697551044 clock_in.png','attendances/1999/1697602642 clock_out.png','Juan R',40698,NULL,'2023-10-17 10:57:24','2023-10-23 13:48:48'),(2397,'2023-10-17 06:57:32','2023-10-17 15:30:49','12.249.250.150','12.249.250.150','closed',8,513,'attendances/1568/1697551052 clock_in.png','attendances/1568/1697581849 clock_out.png','Juan R',40691,NULL,'2023-10-17 10:57:32','2023-10-23 13:48:11'),(2398,'2023-10-17 06:59:03','2023-10-17 21:20:24','12.249.250.150','12.249.250.150','closed',14,861,'attendances/1395/1697551143 clock_in.png','attendances/1395/1697602824 clock_out.png','Juan R',40706,NULL,'2023-10-17 10:59:03','2023-10-23 13:55:39'),(2399,'2023-10-17 07:00:01','2023-10-17 19:43:07','12.249.250.150','12.249.250.150','closed',12,763,'attendances/1888/1697551201 clock_in.png','attendances/1888/1697596987 clock_out.png',NULL,40710,NULL,'2023-10-17 11:00:01','2023-10-17 23:43:07'),(2400,'2023-10-17 07:00:28','2023-10-17 21:17:40','12.249.250.150','12.249.250.150','closed',14,857,'attendances/974/1697551228 clock_in.png','attendances/974/1697602660 clock_out.png','Juan R',40711,NULL,'2023-10-17 11:00:28','2023-10-23 13:47:54'),(2401,'2023-10-17 07:00:43','2023-10-17 15:33:57','12.249.250.150','12.249.250.150','closed',8,513,'attendances/1951/1697551243 clock_in.png','attendances/1951/1697582037 clock_out.png','Juan R',40695,NULL,'2023-10-17 11:00:43','2023-10-23 13:48:33'),(2402,'2023-10-17 07:04:19','2023-10-17 16:02:57','12.249.250.150','12.249.250.150','closed',8,538,'attendances/1948/1697551459 clock_in.png','attendances/1948/1697583777 clock_out.png','Juan R',40707,NULL,'2023-10-17 11:04:19','2023-10-23 13:55:51'),(2403,'2023-10-17 07:09:58','2023-10-17 15:41:53','12.249.250.150','12.249.250.150','closed',8,511,'attendances/1462/1697551798 clock_in.png','attendances/1462/1697582513 clock_out.png','Juan R',40699,NULL,'2023-10-17 11:09:58','2023-10-23 13:48:50'),(2404,'2023-10-17 08:00:39','2023-10-17 16:30:07','12.249.250.150','12.249.250.150','closed',8,509,'attendances/775/1697554839 clock_in.png','attendances/775/1697585407 clock_out.png','Juan R',40713,NULL,'2023-10-17 12:00:39','2023-10-23 13:55:45'),(2405,'2023-10-17 08:01:33','2023-10-17 16:32:35','12.249.250.150','12.249.250.150','closed',8,511,'attendances/1869/1697554893 clock_in.png','attendances/1869/1697585555 clock_out.png','Juan R',40712,NULL,'2023-10-17 12:01:33','2023-10-23 13:48:14'),(2406,'2023-10-17 08:01:44','2023-10-17 16:32:44','12.249.250.150','12.249.250.150','closed',8,511,'attendances/1891/1697554904 clock_in.png','attendances/1891/1697585564 clock_out.png','Juan R',40714,NULL,'2023-10-17 12:01:44','2023-10-23 13:55:47'),(2407,'2023-10-17 19:27:46','2023-10-17 23:32:02','12.249.250.150','12.249.250.150','closed',4,244,'attendances/1479/1697596066 clock_in.png','attendances/1479/1697610722 clock_out.png','Juan R',40882,NULL,'2023-10-17 23:27:46','2023-10-23 13:48:29'),(2408,'2023-10-18 04:55:14','2023-10-18 18:35:56','12.249.250.150','12.249.250.150','closed',13,820,'attendances/1116/1697630114 clock_in.png','attendances/1116/1697679356 clock_out.png','Juan R',40866,NULL,'2023-10-18 08:55:14','2023-10-23 13:49:56'),(2409,'2023-10-18 04:56:15','2023-10-18 14:49:39','12.249.250.150','12.249.250.150','closed',9,593,'attendances/1551/1697630175 clock_in.png','attendances/1551/1697665779 clock_out.png','Juan R',40883,NULL,'2023-10-18 08:56:15','2023-10-23 13:48:04'),(2410,'2023-10-18 04:58:45','2023-10-18 18:45:00','12.249.250.150','12.249.250.150','closed',13,826,'attendances/1585/1697630325 clock_in.png','attendances/1585/1697679900 clock_out.png','Juan R',40864,NULL,'2023-10-18 08:58:45','2023-10-23 13:48:07'),(2411,'2023-10-18 04:58:56','2023-10-18 18:55:53','12.249.250.150','12.249.250.150','closed',13,836,'attendances/1450/1697630336 clock_in.png','attendances/1450/1697680553 clock_out.png','Juan R',40867,NULL,'2023-10-18 08:58:56','2023-10-23 13:55:53'),(2412,'2023-10-18 04:59:13','2023-10-18 18:00:00','12.249.250.150','181.204.85.170','closed',13,780,'attendances/2005/1697630353 clock_in.png',NULL,'Juan R',40865,NULL,'2023-10-18 08:59:13','2023-10-23 13:49:14'),(2413,'2023-10-18 05:53:19','2023-10-18 18:33:13','12.249.250.150','12.249.250.150','closed',12,759,'attendances/726/1697633599 clock_in.png','attendances/726/1697679193 clock_out.png','Juan R',40860,NULL,'2023-10-18 09:53:19','2023-10-23 13:48:00'),(2414,'2023-10-18 05:55:17','2023-10-18 16:33:37','12.249.250.150','12.249.250.150','closed',10,638,'attendances/1588/1697633717 clock_in.png','attendances/1588/1697672017 clock_out.png','Juan R',40861,NULL,'2023-10-18 09:55:17','2023-10-23 13:48:20'),(2415,'2023-10-18 05:56:26','2023-10-18 22:07:17','12.249.250.150','12.249.250.150','closed',16,970,'attendances/1728/1697633786 clock_in.png','attendances/1728/1697692037 clock_out.png','Juan R',40853,NULL,'2023-10-18 09:56:26','2023-10-23 13:48:59'),(2416,'2023-10-18 05:58:26','2023-10-18 18:42:25','12.249.250.150','12.249.250.150','closed',12,763,'attendances/1951/1697633906 clock_in.png','attendances/1951/1697679745 clock_out.png','Juan R',40863,NULL,'2023-10-18 09:58:26','2023-10-23 13:48:33'),(2417,'2023-10-18 05:58:42','2023-10-18 20:37:58','12.249.250.150','12.249.250.150','closed',14,879,'attendances/1479/1697633922 clock_in.png','attendances/1479/1697686678 clock_out.png','Juan R',40862,NULL,'2023-10-18 09:58:42','2023-10-23 13:48:29'),(2418,'2023-10-18 06:02:36','2023-10-18 16:28:56','12.249.250.150','12.249.250.150','closed',10,626,'attendances/1888/1697634156 clock_in.png','attendances/1888/1697671736 clock_out.png',NULL,40857,NULL,'2023-10-18 10:02:36','2023-10-18 20:28:56'),(2419,'2023-10-18 06:30:51','2023-10-18 15:33:19','12.249.250.150','12.249.250.150','closed',9,542,'attendances/622/1697635851 clock_in.png','attendances/622/1697668399 clock_out.png','Juan R',40856,NULL,'2023-10-18 10:30:51','2023-10-23 13:58:59'),(2420,'2023-10-18 06:54:09','2023-10-18 15:31:45','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1774/1697637249 clock_in.png','attendances/1774/1697668305 clock_out.png','Juan R',40849,NULL,'2023-10-18 10:54:09','2023-10-23 13:48:43'),(2421,'2023-10-18 06:55:44','2023-10-18 15:31:30','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1934/1697637344 clock_in.png','attendances/1934/1697668290 clock_out.png','Juan R',40852,NULL,'2023-10-18 10:55:44','2023-10-23 13:48:53'),(2422,'2023-10-18 06:55:48','2023-10-18 22:07:26','12.249.250.150','12.249.250.150','closed',15,911,'attendances/1999/1697637348 clock_in.png','attendances/1999/1697692046 clock_out.png','Juan R',40850,NULL,'2023-10-18 10:55:48','2023-10-23 13:48:48'),(2423,'2023-10-18 06:56:07','2023-10-18 22:11:23','12.249.250.150','12.249.250.150','closed',15,915,'attendances/974/1697637367 clock_in.png','attendances/974/1697692283 clock_out.png','Juan R',40842,NULL,'2023-10-18 10:56:07','2023-10-23 13:47:54'),(2424,'2023-10-18 06:56:27','2023-10-18 14:30:34','12.249.250.150','12.249.250.150','closed',7,454,'attendances/1858/1697637387 clock_in.png','attendances/1858/1697664634 clock_out.png','Juan R',40858,NULL,'2023-10-18 10:56:27','2023-10-23 13:49:01'),(2425,'2023-10-18 06:57:33','2023-10-18 15:32:01','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1958/1697637453 clock_in.png','attendances/1958/1697668321 clock_out.png','Juan R',40859,NULL,'2023-10-18 10:57:33','2023-10-23 13:48:45'),(2426,'2023-10-18 06:57:34','2023-10-18 22:11:49','12.249.250.150','12.249.250.150','closed',15,914,'attendances/1395/1697637454 clock_in.png','attendances/1395/1697692309 clock_out.png','Juan R',40854,NULL,'2023-10-18 10:57:34','2023-10-23 13:55:39'),(2427,'2023-10-18 06:57:47','2023-10-18 15:30:53','12.249.250.150','12.249.250.150','closed',8,513,'attendances/1568/1697637467 clock_in.png','attendances/1568/1697668253 clock_out.png','Juan R',40848,NULL,'2023-10-18 10:57:47','2023-10-23 13:48:11'),(2428,'2023-10-18 07:08:06','2023-10-18 15:43:10','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1462/1697638086 clock_in.png','attendances/1462/1697668990 clock_out.png','Juan R',40851,NULL,'2023-10-18 11:08:06','2023-10-23 13:48:50'),(2429,'2023-10-18 07:14:25','2023-10-18 15:43:23','12.249.250.150','12.249.250.150','closed',8,508,'attendances/1948/1697638465 clock_in.png','attendances/1948/1697669003 clock_out.png','Juan R',40855,NULL,'2023-10-18 11:14:25','2023-10-23 13:55:51'),(2430,'2023-10-18 07:52:45','2023-10-18 17:40:37','12.249.250.150','12.249.250.150','closed',9,587,'attendances/2116/1697640765 clock_in.png','attendances/2116/1697676037 clock_out.png','Juan R',40843,NULL,'2023-10-18 11:52:45','2023-10-23 13:48:24'),(2431,'2023-10-18 07:59:27','2023-10-18 17:43:54','12.249.250.150','12.249.250.150','closed',9,584,'attendances/1455/1697641167 clock_in.png','attendances/1455/1697676234 clock_out.png','Juan R',40844,NULL,'2023-10-18 11:59:27','2023-10-23 13:48:56'),(2432,'2023-10-18 08:04:04','2023-10-18 16:36:17','12.249.250.150','12.249.250.150','closed',8,512,'attendances/1869/1697641444 clock_in.png','attendances/1869/1697672177 clock_out.png','Juan R',40847,NULL,'2023-10-18 12:04:04','2023-10-23 13:48:14'),(2433,'2023-10-18 08:04:17','2023-10-18 16:36:04','12.249.250.150','12.249.250.150','closed',8,511,'attendances/1891/1697641457 clock_in.png','attendances/1891/1697672164 clock_out.png','Juan R',40846,NULL,'2023-10-18 12:04:17','2023-10-23 13:55:47'),(2434,'2023-10-18 08:25:53','2023-10-18 17:00:08','12.249.250.150','12.249.250.150','closed',8,514,'attendances/775/1697642753 clock_in.png','attendances/775/1697673608 clock_out.png','Juan R',40845,NULL,'2023-10-18 12:25:53','2023-10-23 13:55:45'),(2435,'2023-10-19 05:53:36','2023-10-19 19:30:16','12.249.250.150','12.249.250.150','closed',13,816,'attendances/726/1697720016 clock_in.png','attendances/726/1697769016 clock_out.png','Juan R',40930,NULL,'2023-10-19 09:53:36','2023-10-23 13:48:00'),(2436,'2023-10-19 05:54:12','2023-10-19 20:28:51','12.249.250.150','12.249.250.150','closed',14,874,'attendances/1116/1697720052 clock_in.png','attendances/1116/1697772531 clock_out.png','Juan R',40958,NULL,'2023-10-19 09:54:12','2023-10-23 13:49:56'),(2437,'2023-10-19 05:54:35','2023-10-19 15:30:51','12.249.250.150','12.249.250.150','closed',9,576,'attendances/1588/1697720075 clock_in.png','attendances/1588/1697754651 clock_out.png','Juan R',40934,NULL,'2023-10-19 09:54:35','2023-10-23 13:48:20'),(2438,'2023-10-19 05:55:39','2023-10-19 15:31:56','12.249.250.150','12.249.250.150','closed',9,576,'attendances/1568/1697720139 clock_in.png','attendances/1568/1697754716 clock_out.png','Juan R',40933,NULL,'2023-10-19 09:55:39','2023-10-23 13:48:11'),(2439,'2023-10-19 05:56:47','2023-10-19 19:17:25','12.249.250.150','12.249.250.150','closed',13,800,'attendances/1479/1697720207 clock_in.png','attendances/1479/1697768245 clock_out.png','Juan R',40936,NULL,'2023-10-19 09:56:47','2023-10-23 13:48:29'),(2440,'2023-10-19 05:57:33','2023-10-19 19:51:50','12.249.250.150','12.249.250.150','closed',13,834,'attendances/2005/1697720253 clock_in.png','attendances/2005/1697770310 clock_out.png','Juan R',40938,NULL,'2023-10-19 09:57:33','2023-10-23 13:49:14'),(2441,'2023-10-19 05:58:36','2023-10-19 19:52:06','12.249.250.150','12.249.250.150','closed',13,833,'attendances/1585/1697720316 clock_in.png','attendances/1585/1697770326 clock_out.png','Juan R',40932,NULL,'2023-10-19 09:58:36','2023-10-23 13:48:07'),(2442,'2023-10-19 05:59:18','2023-10-19 19:30:05','12.249.250.150','12.249.250.150','closed',13,810,'attendances/1551/1697720358 clock_in.png','attendances/1551/1697769005 clock_out.png','Juan R',40931,NULL,'2023-10-19 09:59:18','2023-10-23 13:48:04'),(2443,'2023-10-19 06:02:07','2023-10-19 15:06:15','12.249.250.150','12.249.250.150','closed',9,544,'attendances/2116/1697720527 clock_in.png','attendances/2116/1697753175 clock_out.png','Juan R',40935,NULL,'2023-10-19 10:02:07','2023-10-23 13:48:24'),(2444,'2023-10-19 06:02:36','2023-10-19 19:57:22','12.249.250.150','12.249.250.150','closed',13,834,'attendances/1450/1697720556 clock_in.png','attendances/1450/1697770642 clock_out.png','Juan R',40939,NULL,'2023-10-19 10:02:36','2023-10-23 13:55:53'),(2445,'2023-10-19 06:02:56','2023-10-19 15:31:46','12.249.250.150','12.249.250.150','closed',9,568,'attendances/1455/1697720576 clock_in.png','attendances/1455/1697754706 clock_out.png','Juan R',40937,NULL,'2023-10-19 10:02:56','2023-10-23 13:48:56'),(2446,'2023-10-19 06:32:46','2023-10-19 15:33:11','12.249.250.150','12.249.250.150','closed',9,540,'attendances/622/1697722366 clock_in.png','attendances/622/1697754791 clock_out.png','Juan R',40953,NULL,'2023-10-19 10:32:46','2023-10-23 13:58:59'),(2447,'2023-10-19 06:43:08','2023-10-19 21:27:08','12.249.250.150','12.249.250.150','closed',14,884,'attendances/1999/1697722988 clock_in.png','attendances/1999/1697776028 clock_out.png','Juan R',40946,NULL,'2023-10-19 10:43:08','2023-10-23 13:48:48'),(2448,'2023-10-19 06:54:25','2023-10-19 15:32:37','12.249.250.150','12.249.250.150','closed',8,518,'attendances/1774/1697723665 clock_in.png','attendances/1774/1697754757 clock_out.png','Juan R',40944,NULL,'2023-10-19 10:54:25','2023-10-23 13:48:43'),(2449,'2023-10-19 06:55:41','2023-10-19 15:34:27','12.249.250.150','12.249.250.150','closed',8,518,'attendances/1934/1697723741 clock_in.png','attendances/1934/1697754867 clock_out.png','Juan R',40948,NULL,'2023-10-19 10:55:41','2023-10-23 13:48:53'),(2450,'2023-10-19 06:55:58','2023-10-19 15:33:31','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1858/1697723758 clock_in.png','attendances/1858/1697754811 clock_out.png','Juan R',40950,NULL,'2023-10-19 10:55:58','2023-10-23 13:49:01'),(2451,'2023-10-19 06:56:18','2023-10-19 15:30:28','12.249.250.150','12.249.250.150','closed',8,514,'attendances/775/1697723778 clock_in.png','attendances/775/1697754628 clock_out.png','Juan R',40956,NULL,'2023-10-19 10:56:18','2023-10-23 13:55:45'),(2452,'2023-10-19 06:57:01','2023-10-19 15:33:20','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1958/1697723821 clock_in.png','attendances/1958/1697754800 clock_out.png','Juan R',40945,NULL,'2023-10-19 10:57:01','2023-10-23 13:48:45'),(2453,'2023-10-19 06:57:55','2023-10-19 21:28:08','12.249.250.150','12.249.250.150','closed',14,870,'attendances/974/1697723875 clock_in.png','attendances/974/1697776088 clock_out.png','Juan R',40942,NULL,'2023-10-19 10:57:55','2023-10-23 13:47:54'),(2454,'2023-10-19 06:59:17','2023-10-19 16:32:10','12.249.250.150','12.249.250.150','closed',9,572,'attendances/1951/1697723957 clock_in.png','attendances/1951/1697758330 clock_out.png','Juan R',40943,NULL,'2023-10-19 10:59:17','2023-10-23 13:48:33'),(2455,'2023-10-19 07:00:19','2023-10-19 21:27:22','12.249.250.150','12.249.250.150','closed',14,867,'attendances/1395/1697724019 clock_in.png','attendances/1395/1697776042 clock_out.png','Juan R',40951,NULL,'2023-10-19 11:00:19','2023-10-23 13:55:39'),(2456,'2023-10-19 07:04:48','2023-10-19 13:30:36','12.249.250.150','12.249.250.150','closed',6,385,'attendances/1462/1697724288 clock_in.png','attendances/1462/1697747436 clock_out.png','Juan R',40947,NULL,'2023-10-19 11:04:48','2023-10-23 13:48:50'),(2457,'2023-10-19 07:05:01','2023-10-19 21:26:58','12.249.250.150','12.249.250.150','closed',14,861,'attendances/1728/1697724301 clock_in.png','attendances/1728/1697776018 clock_out.png','Juan R',40949,NULL,'2023-10-19 11:05:01','2023-10-23 13:48:59'),(2458,'2023-10-19 07:05:12','2023-10-19 15:41:25','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1948/1697724312 clock_in.png','attendances/1948/1697755285 clock_out.png','Juan R',40952,NULL,'2023-10-19 11:05:12','2023-10-23 13:55:51'),(2459,'2023-10-19 07:11:08','2023-10-19 15:51:31','12.249.250.150','12.249.250.150','closed',8,520,'attendances/1888/1697724668 clock_in.png','attendances/1888/1697755891 clock_out.png',NULL,40954,NULL,'2023-10-19 11:11:08','2023-10-19 19:51:31'),(2460,'2023-10-19 07:58:02','2023-10-19 16:33:44','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1869/1697727482 clock_in.png','attendances/1869/1697758424 clock_out.png','Juan R',40955,NULL,'2023-10-19 11:58:02','2023-10-23 13:48:14'),(2461,'2023-10-19 07:58:12','2023-10-19 16:35:03','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1891/1697727492 clock_in.png','attendances/1891/1697758503 clock_out.png','Juan R',40957,NULL,'2023-10-19 11:58:12','2023-10-23 13:55:47'),(2464,'2023-10-19 22:23:00','2023-10-19 23:59:00','38.51.234.67','38.51.234.67','closed',1,96,NULL,NULL,'Juan R',41033,NULL,'2023-10-20 09:16:42','2023-10-23 13:49:56'),(2465,'2023-10-20 00:00:00','2023-10-20 02:05:00','38.51.234.67','38.51.234.67','closed',2,125,NULL,NULL,'Juan R',41034,NULL,'2023-10-20 09:17:43','2023-10-23 13:49:56'),(2466,'2023-10-20 05:55:06','2023-10-20 19:35:34','12.249.250.150','12.249.250.150','closed',13,820,'attendances/1116/1697806506 clock_in.png','attendances/1116/1697855734 clock_out.png','Juan R',41011,NULL,'2023-10-20 09:55:06','2023-10-23 13:49:56'),(2467,'2023-10-20 05:56:16','2023-10-20 15:32:48','12.249.250.150','12.249.250.150','closed',9,576,'attendances/622/1697806576 clock_in.png','attendances/622/1697841168 clock_out.png','Juan R',41009,NULL,'2023-10-20 09:56:16','2023-10-23 13:58:59'),(2468,'2023-10-20 05:56:27','2023-10-20 15:33:05','12.249.250.150','12.249.250.150','closed',9,576,'attendances/1774/1697806587 clock_in.png','attendances/1774/1697841185 clock_out.png','Juan R',41000,NULL,'2023-10-20 09:56:27','2023-10-23 13:48:43'),(2469,'2023-10-20 05:57:44','2023-10-20 19:52:07','12.249.250.150','12.249.250.150','closed',13,834,'attendances/1958/1697806664 clock_in.png','attendances/1958/1697856727 clock_out.png','Juan R',41001,NULL,'2023-10-20 09:57:44','2023-10-23 13:48:45'),(2470,'2023-10-20 05:57:55','2023-10-20 19:34:34','12.249.250.150','12.249.250.150','closed',13,816,'attendances/2116/1697806675 clock_in.png','attendances/2116/1697855674 clock_out.png','Juan R',41016,NULL,'2023-10-20 09:57:55','2023-10-23 13:48:24'),(2471,'2023-10-20 05:59:56','2023-10-20 18:52:02','12.249.250.150','12.249.250.150','closed',12,772,'attendances/1728/1697806796 clock_in.png','attendances/1728/1697853122 clock_out.png','Juan R',41005,NULL,'2023-10-20 09:59:56','2023-10-23 13:48:59'),(2472,'2023-10-20 06:00:19','2023-10-20 18:56:25','12.249.250.150','12.249.250.150','closed',12,776,'attendances/1395/1697806819 clock_in.png','attendances/1395/1697853385 clock_out.png','Juan R',41007,NULL,'2023-10-20 10:00:19','2023-10-23 13:55:39'),(2473,'2023-10-20 06:04:57','2023-10-20 16:17:21','12.249.250.150','12.249.250.150','closed',10,612,'attendances/1455/1697807097 clock_in.png','attendances/1455/1697843842 clock_out.png','Juan R',41017,NULL,'2023-10-20 10:04:57','2023-10-23 13:48:56'),(2474,'2023-10-20 06:06:20','2023-10-20 19:05:58','12.249.250.150','12.249.250.150','closed',12,779,'attendances/1999/1697807180 clock_in.png','attendances/1999/1697853958 clock_out.png','Juan R',41002,NULL,'2023-10-20 10:06:20','2023-10-23 13:48:48'),(2475,'2023-10-20 06:07:46','2023-10-20 18:52:32','12.249.250.150','12.249.250.150','closed',12,764,'attendances/974/1697807266 clock_in.png','attendances/974/1697853152 clock_out.png','Juan R',40995,NULL,'2023-10-20 10:07:46','2023-10-23 13:47:54'),(2476,'2023-10-20 06:08:31','2023-10-20 19:51:52','12.249.250.150','12.249.250.150','closed',13,823,'attendances/1858/1697807311 clock_in.png','attendances/1858/1697856712 clock_out.png','Juan R',41006,NULL,'2023-10-20 10:08:31','2023-10-23 13:49:01'),(2477,'2023-10-20 06:53:43','2023-10-20 20:43:13','12.249.250.150','12.249.250.150','closed',13,829,'attendances/726/1697810023 clock_in.png','attendances/726/1697859794 clock_out.png','Juan R',40996,NULL,'2023-10-20 10:53:43','2023-10-23 13:48:00'),(2478,'2023-10-20 06:55:43','2023-10-20 17:30:03','12.249.250.150','12.249.250.150','closed',10,634,'attendances/1934/1697810143 clock_in.png','attendances/1934/1697848203 clock_out.png','Juan R',41004,NULL,'2023-10-20 10:55:43','2023-10-23 13:48:53'),(2479,'2023-10-20 06:57:02','2023-10-20 19:30:51','12.249.250.150','12.249.250.150','closed',12,753,'attendances/1479/1697810222 clock_in.png','attendances/1479/1697855451 clock_out.png','Juan R',40999,NULL,'2023-10-20 10:57:02','2023-10-23 13:48:29'),(2480,'2023-10-20 07:00:12','2023-10-20 15:34:43','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1568/1697810412 clock_in.png','attendances/1568/1697841283 clock_out.png','Juan R',40997,NULL,'2023-10-20 11:00:12','2023-10-23 13:48:11'),(2481,'2023-10-20 07:00:26','2023-10-20 15:46:37','12.249.250.150','12.249.250.150','closed',8,526,'attendances/1948/1697810426 clock_in.png','attendances/1948/1697841997 clock_out.png','Juan R',41008,NULL,'2023-10-20 11:00:26','2023-10-23 13:55:51'),(2482,'2023-10-20 07:00:33','2023-10-20 14:44:18','12.249.250.150','12.249.250.150','closed',7,463,'attendances/1588/1697810433 clock_in.png','attendances/1588/1697838258 clock_out.png','Juan R',40998,NULL,'2023-10-20 11:00:33','2023-10-23 13:48:20'),(2483,'2023-10-20 07:01:03','2023-10-20 15:46:29','12.249.250.150','12.249.250.150','closed',8,525,'attendances/1951/1697810463 clock_in.png','attendances/1951/1697841989 clock_out.png','Juan R',41018,NULL,'2023-10-20 11:01:03','2023-10-23 13:48:33'),(2484,'2023-10-20 07:06:49','2023-10-20 15:38:36','12.249.250.150','12.249.250.150','closed',8,511,'attendances/1462/1697810809 clock_in.png','attendances/1462/1697841516 clock_out.png','Juan R',41003,NULL,'2023-10-20 11:06:49','2023-10-23 13:48:50'),(2485,'2023-10-20 07:08:14','2023-10-20 15:38:10','12.249.250.150','12.249.250.150','closed',8,509,'attendances/1888/1697810894 clock_in.png','attendances/1888/1697841490 clock_out.png',NULL,41010,NULL,'2023-10-20 11:08:14','2023-10-20 19:38:10'),(2486,'2023-10-20 07:56:42','2023-10-20 16:32:06','12.249.250.150','12.249.250.150','closed',8,515,'attendances/775/1697813802 clock_in.png','attendances/775/1697844726 clock_out.png','Juan R',41020,NULL,'2023-10-20 11:56:42','2023-10-23 13:55:45'),(2487,'2023-10-20 08:00:36','2023-10-20 16:32:55','12.249.250.150','12.249.250.150','closed',8,512,'attendances/1869/1697814036 clock_in.png','attendances/1869/1697844775 clock_out.png','Juan R',41019,NULL,'2023-10-20 12:00:36','2023-10-23 13:48:14'),(2488,'2023-10-20 08:00:46','2023-10-20 16:33:07','12.249.250.150','12.249.250.150','closed',8,512,'attendances/1891/1697814046 clock_in.png','attendances/1891/1697844787 clock_out.png','Juan R',41021,NULL,'2023-10-20 12:00:46','2023-10-23 13:55:47'),(2489,'2023-10-20 09:53:57','2023-10-20 20:42:03','12.249.250.150','12.249.250.150','closed',10,648,'attendances/1585/1697820837 clock_in.png','attendances/1585/1697859723 clock_out.png','Juan R',41014,NULL,'2023-10-20 13:53:57','2023-10-23 13:48:07'),(2490,'2023-10-20 09:56:31','2023-10-20 20:41:36','12.249.250.150','12.249.250.150','closed',10,645,'attendances/1551/1697820991 clock_in.png','attendances/1551/1697859696 clock_out.png','Juan R',41013,NULL,'2023-10-20 13:56:31','2023-10-23 13:48:04'),(2491,'2023-10-20 10:06:01','2023-10-20 19:55:59','12.249.250.150','12.249.250.150','closed',9,589,'attendances/1450/1697821561 clock_in.png','attendances/1450/1697856959 clock_out.png','Juan R',41015,NULL,'2023-10-20 14:06:01','2023-10-23 13:55:53'),(2493,'2023-10-20 17:08:00','2023-10-20 23:59:00','179.19.80.155','38.51.234.67','closed',6,411,NULL,NULL,'Juan R',41146,NULL,'2023-10-21 00:39:02','2023-10-23 13:58:59'),(2494,'2023-10-21 05:54:33','2023-10-21 14:32:04','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1934/1697892874 clock_in.png','attendances/1934/1697923924 clock_out.png','Juan R',41093,NULL,'2023-10-21 09:54:34','2023-10-23 13:48:53'),(2495,'2023-10-21 05:56:47','2023-10-21 16:43:47','12.249.250.150','12.249.250.150','closed',10,647,'attendances/2116/1697893007 clock_in.png','attendances/2116/1697931827 clock_out.png','Juan R',41094,NULL,'2023-10-21 09:56:47','2023-10-23 13:48:24'),(2496,'2023-10-21 06:04:07','2023-10-21 16:55:29','12.249.250.150','12.249.250.150','closed',10,651,'attendances/1999/1697893447 clock_in.png','attendances/1999/1697932529 clock_out.png','Juan R',41092,NULL,'2023-10-21 10:04:07','2023-10-23 13:48:48'),(2498,'2023-10-21 08:37:00','2023-10-21 16:56:00','38.51.234.67','181.204.85.170','closed',8,499,NULL,NULL,'Juan R',41152,NULL,'2023-10-21 13:01:58','2023-10-23 13:49:56'),(2503,'2023-10-23 04:50:13','2023-10-23 16:53:31','12.249.250.150','12.249.250.150','closed',12,723,'attendances/1568/1698061813 clock_in.png','attendances/1568/1698105211 clock_out.png','Juan R',41163,NULL,'2023-10-23 08:50:13','2023-10-31 17:17:51'),(2504,'2023-10-23 04:59:18','2023-10-23 20:29:53','12.249.250.150','12.249.250.150','closed',15,930,'attendances/2200/1698062358 clock_in.png','attendances/2200/1698118193 clock_out.png','Juan R',41188,NULL,'2023-10-23 08:59:18','2023-10-31 17:18:40'),(2505,'2023-10-23 05:53:13','2023-10-23 17:42:07','12.249.250.150','12.249.250.150','closed',11,708,'attendances/1585/1698065593 clock_in.png','attendances/1585/1698108127 clock_out.png','Juan R',41166,NULL,'2023-10-23 09:53:13','2023-10-31 17:17:48'),(2506,'2023-10-23 05:54:02','2023-10-23 17:43:08','12.249.250.150','12.249.250.150','closed',11,709,'attendances/1551/1698065642 clock_in.png','attendances/1551/1698108188 clock_out.png','Juan R',41165,NULL,'2023-10-23 09:54:02','2023-10-31 17:17:46'),(2507,'2023-10-23 05:54:12','2023-10-23 17:00:21','12.249.250.150','12.249.250.150','closed',11,666,'attendances/726/1698065652 clock_in.png','attendances/726/1698105621 clock_out.png','Juan R',41164,NULL,'2023-10-23 09:54:12','2023-10-31 17:17:43'),(2508,'2023-10-23 05:55:05','2023-10-23 14:37:32','12.249.250.150','12.249.250.150','closed',8,522,'attendances/2116/1698065705 clock_in.png','attendances/2116/1698097052 clock_out.png','Juan R',41167,NULL,'2023-10-23 09:55:05','2023-10-31 17:18:00'),(2509,'2023-10-23 05:55:40','2023-10-23 16:05:30','12.249.250.150','12.249.250.150','closed',10,609,'attendances/1479/1698065740 clock_in.png','attendances/1479/1698102330 clock_out.png','Juan R',41168,NULL,'2023-10-23 09:55:40','2023-10-31 17:18:02'),(2510,'2023-10-23 05:56:46','2023-10-23 17:42:29','12.249.250.150','12.249.250.150','closed',11,705,'attendances/2005/1698065806 clock_in.png','attendances/2005/1698108149 clock_out.png','Juan R',41169,NULL,'2023-10-23 09:56:46','2023-10-31 17:19:18'),(2511,'2023-10-23 05:58:01','2023-10-23 15:33:20','12.249.250.150','12.249.250.150','closed',9,575,'attendances/1948/1698065881 clock_in.png','attendances/1948/1698100400 clock_out.png','Juan R',41181,NULL,'2023-10-23 09:58:01','2023-10-31 17:20:04'),(2512,'2023-10-23 05:59:02','2023-10-23 18:44:37','12.249.250.150','12.249.250.150','closed',12,765,'attendances/1450/1698065942 clock_in.png','attendances/1450/1698111877 clock_out.png','Juan R',41170,NULL,'2023-10-23 09:59:02','2023-10-31 17:20:07'),(2513,'2023-10-23 06:04:55','2023-10-23 16:39:20','12.249.250.150','12.249.250.150','closed',10,634,'attendances/1888/1698066295 clock_in.png','attendances/1888/1698104360 clock_out.png','Juan R',41171,NULL,'2023-10-23 10:04:55','2023-10-31 17:20:27'),(2514,'2023-10-23 06:19:02','2023-10-23 15:30:48','12.249.250.150','12.249.250.150','closed',9,551,'attendances/622/1698067142 clock_in.png','attendances/622/1698100248 clock_out.png','Juan R',41182,NULL,'2023-10-23 10:19:02','2023-10-31 17:20:18'),(2515,'2023-10-22 05:57:00','2023-10-22 16:27:00','38.51.234.67','38.51.234.67','closed',10,630,NULL,NULL,'Juan R',41194,NULL,'2023-10-23 10:48:08','2023-10-23 13:48:59'),(2516,'2023-10-22 05:55:00','2023-10-22 16:30:00','38.51.234.67','38.51.234.67','closed',10,635,NULL,NULL,'Juan R',41195,NULL,'2023-10-23 10:48:40','2023-10-23 13:55:39'),(2517,'2023-10-23 06:49:21','2023-10-23 16:15:34','12.249.250.150','12.249.250.150','closed',9,566,'attendances/1999/1698068961 clock_in.png','attendances/1999/1698102934 clock_out.png','Juan R',41175,NULL,'2023-10-23 10:49:21','2023-10-31 17:19:02'),(2518,'2023-10-23 06:50:36','2023-10-23 16:33:15','12.249.250.150','12.249.250.150','closed',9,582,'attendances/1951/1698069036 clock_in.png','attendances/1951/1698103995 clock_out.png','Juan R',41172,NULL,'2023-10-23 10:50:36','2023-10-31 17:18:28'),(2519,'2023-10-23 06:50:50','2023-10-23 15:31:10','12.249.250.150','12.249.250.150','closed',8,520,'attendances/1774/1698069050 clock_in.png','attendances/1774/1698100270 clock_out.png','Juan R',41173,NULL,'2023-10-23 10:50:50','2023-10-31 17:18:51'),(2520,'2023-10-23 06:55:15','2023-10-23 15:35:51','12.249.250.150','12.249.250.150','closed',8,520,'attendances/1728/1698069315 clock_in.png','attendances/1728/1698100551 clock_out.png','Juan R',41177,NULL,'2023-10-23 10:55:15','2023-10-31 17:19:12'),(2521,'2023-10-23 06:55:41','2023-10-23 15:31:25','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1958/1698069341 clock_in.png','attendances/1958/1698100285 clock_out.png','Juan R',41174,NULL,'2023-10-23 10:55:41','2023-10-31 17:18:57'),(2522,'2023-10-23 06:55:56','2023-10-23 15:31:37','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1858/1698069356 clock_in.png','attendances/1858/1698100297 clock_out.png','Juan R',41178,NULL,'2023-10-23 10:55:56','2023-10-31 17:19:15'),(2523,'2023-10-23 06:56:11','2023-10-23 16:20:48','12.249.250.150','12.249.250.150','closed',9,564,'attendances/1116/1698069371 clock_in.png','attendances/1116/1698103248 clock_out.png','Juan R',41179,NULL,'2023-10-23 10:56:11','2023-10-31 17:19:22'),(2524,'2023-10-23 06:56:26','2023-10-23 23:36:21','12.249.250.150','12.249.250.150','closed',16,999,'attendances/974/1698069386 clock_in.png','attendances/974/1698129381 clock_out.png','Juan R',41183,NULL,'2023-10-23 10:56:26','2023-10-31 17:17:36'),(2525,'2023-10-23 06:56:41','2023-10-23 16:21:41','12.249.250.150','12.249.250.150','closed',9,565,'attendances/1395/1698069401 clock_in.png','attendances/1395/1698103301 clock_out.png','Juan R',41180,NULL,'2023-10-23 10:56:41','2023-10-31 17:19:29'),(2526,'2023-10-23 06:57:29','2023-10-23 15:30:58','12.249.250.150','12.249.250.150','closed',8,513,'attendances/1934/1698069449 clock_in.png','attendances/1934/1698100258 clock_out.png',NULL,41176,NULL,'2023-10-23 10:57:29','2023-10-23 19:30:58'),(2527,'2023-10-21 00:00:00','2023-10-21 02:03:00','38.51.234.67','38.51.234.67','closed',2,123,NULL,NULL,'Juan R',41247,NULL,'2023-10-23 11:00:54','2023-10-23 13:58:59'),(2528,'2023-10-22 00:00:00','2023-10-22 01:43:00','38.51.234.67','38.51.234.67','closed',1,103,NULL,NULL,'Juan R',41248,NULL,'2023-10-23 11:06:45','2023-10-23 13:58:59'),(2529,'2023-10-21 17:30:00','2023-10-21 23:59:00','38.51.234.67','38.51.234.67','closed',6,389,NULL,NULL,'Juan R',41095,NULL,'2023-10-23 11:08:41','2023-10-23 13:58:59'),(2530,'2023-10-23 07:48:20','2023-10-23 18:05:18','12.249.250.150','12.249.250.150','closed',10,616,'attendances/1869/1698072500 clock_in.png','attendances/1869/1698109518 clock_out.png','Juan R',41184,NULL,'2023-10-23 11:48:20','2023-10-31 17:17:56'),(2531,'2023-10-23 07:59:09','2023-10-23 16:30:35','12.249.250.150','12.249.250.150','closed',8,511,'attendances/775/1698073149 clock_in.png','attendances/775/1698103835 clock_out.png','Juan R',41186,NULL,'2023-10-23 11:59:09','2023-10-31 17:19:45'),(2532,'2023-10-23 08:07:56','2023-10-23 15:40:32','12.249.250.150','12.249.250.150','closed',7,452,'attendances/1462/1698073676 clock_in.png','attendances/1462/1698100832 clock_out.png','Juan R',41185,NULL,'2023-10-23 12:07:56','2023-10-31 17:19:06'),(2533,'2023-10-23 10:25:34','2023-10-23 18:05:02','12.249.250.150','12.249.250.150','closed',7,459,'attendances/1891/1698081934 clock_in.png','attendances/1891/1698109502 clock_out.png','Juan R',41187,NULL,'2023-10-23 14:25:34','2023-10-31 17:19:49'),(2534,'2023-10-24 04:27:22','2023-10-24 18:31:04','12.249.250.150','12.249.250.150','closed',14,843,'attendances/1450/1698146842 clock_in.png','attendances/1450/1698197464 clock_out.png','Juan R',41383,NULL,'2023-10-24 08:27:22','2023-10-31 17:20:07'),(2535,'2023-10-24 05:51:32','2023-10-24 15:30:31','12.249.250.150','12.249.250.150','closed',9,578,'attendances/1568/1698151892 clock_in.png','attendances/1568/1698186631 clock_out.png','Juan R',41379,NULL,'2023-10-24 09:51:32','2023-10-31 17:17:51'),(2536,'2023-10-24 05:54:41','2023-10-24 16:10:50','12.249.250.150','12.249.250.150','closed',10,616,'attendances/1585/1698152081 clock_in.png','attendances/1585/1698189050 clock_out.png','Juan R',41378,NULL,'2023-10-24 09:54:41','2023-10-31 17:17:48'),(2537,'2023-10-24 05:55:23','2023-10-24 16:11:32','12.249.250.150','12.249.250.150','closed',10,616,'attendances/726/1698152123 clock_in.png','attendances/726/1698189092 clock_out.png','Juan R',41362,NULL,'2023-10-24 09:55:23','2023-10-31 17:17:43'),(2538,'2023-10-24 05:56:18','2023-10-24 17:42:03','12.249.250.150','12.249.250.150','closed',11,705,'attendances/2116/1698152178 clock_in.png','attendances/2116/1698194523 clock_out.png','Juan R',41380,NULL,'2023-10-24 09:56:18','2023-10-31 17:18:00'),(2539,'2023-10-24 05:59:05','2023-10-24 16:08:37','12.249.250.150','12.249.250.150','closed',10,609,'attendances/1551/1698152345 clock_in.png','attendances/1551/1698188917 clock_out.png','Juan R',41377,NULL,'2023-10-24 09:59:05','2023-10-31 17:17:46'),(2540,'2023-10-24 05:59:43','2023-10-24 17:00:30','12.249.250.150','12.249.250.150','closed',11,660,'attendances/2005/1698152383 clock_in.png','attendances/2005/1698192030 clock_out.png','Juan R',41382,NULL,'2023-10-24 09:59:43','2023-10-31 17:19:18'),(2541,'2023-10-24 06:00:09','2023-10-24 15:41:39','12.249.250.150','12.249.250.150','closed',9,581,'attendances/1951/1698152409 clock_in.png','attendances/1951/1698187299 clock_out.png','Juan R',41381,NULL,'2023-10-24 10:00:09','2023-10-31 17:18:28'),(2542,'2023-10-24 06:25:20','2023-10-24 15:30:59','12.249.250.150','12.249.250.150','closed',9,545,'attendances/622/1698153920 clock_in.png','attendances/622/1698186659 clock_out.png','Juan R',41375,NULL,'2023-10-24 10:25:20','2023-10-31 17:20:18'),(2543,'2023-10-24 06:51:17','2023-10-24 15:31:10','12.249.250.150','12.249.250.150','closed',8,519,'attendances/1774/1698155477 clock_in.png','attendances/1774/1698186670 clock_out.png','Juan R',41365,NULL,'2023-10-24 10:51:17','2023-10-31 17:18:51'),(2544,'2023-10-24 06:51:41','2023-10-24 19:00:37','12.249.250.150','12.249.250.150','closed',12,728,'attendances/1999/1698155501 clock_in.png','attendances/1999/1698199237 clock_out.png','Juan R',41367,NULL,'2023-10-24 10:51:41','2023-10-31 17:19:02'),(2545,'2023-10-24 06:55:34','2023-10-24 19:04:08','12.249.250.150','12.249.250.150','closed',12,728,'attendances/1116/1698155734 clock_in.png','attendances/1116/1698199448 clock_out.png','Juan R',41372,NULL,'2023-10-24 10:55:34','2023-10-31 17:19:22'),(2546,'2023-10-24 06:55:55','2023-10-24 15:31:43','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1858/1698155755 clock_in.png','attendances/1858/1698186703 clock_out.png','Juan R',41371,NULL,'2023-10-24 10:55:55','2023-10-31 17:19:15'),(2547,'2023-10-24 06:56:06','2023-10-24 18:58:45','12.249.250.150','12.249.250.150','closed',12,722,'attendances/1395/1698155766 clock_in.png','attendances/1395/1698199125 clock_out.png','Juan R',41373,NULL,'2023-10-24 10:56:06','2023-10-31 17:19:29'),(2548,'2023-10-24 06:57:07','2023-10-24 15:32:49','12.249.250.150','12.249.250.150','closed',8,515,'attendances/2200/1698155827 clock_in.png','attendances/2200/1698186769 clock_out.png','Juan R',41364,NULL,'2023-10-24 10:57:07','2023-10-31 17:18:40'),(2549,'2023-10-24 06:57:16','2023-10-24 15:31:58','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1958/1698155836 clock_in.png','attendances/1958/1698186718 clock_out.png','Juan R',41366,NULL,'2023-10-24 10:57:16','2023-10-31 17:18:57'),(2550,'2023-10-24 06:57:29','2023-10-24 15:30:44','12.249.250.150','12.249.250.150','closed',8,513,'attendances/1934/1698155849 clock_in.png','attendances/1934/1698186644 clock_out.png',NULL,41369,NULL,'2023-10-24 10:57:29','2023-10-24 19:30:44'),(2551,'2023-10-24 06:58:42','2023-10-24 17:44:28','12.249.250.150','12.249.250.150','closed',10,645,'attendances/1479/1698155922 clock_in.png','attendances/1479/1698194668 clock_out.png','Juan R',41363,NULL,'2023-10-24 10:58:42','2023-10-31 17:18:02'),(2552,'2023-10-24 06:59:04','2023-10-24 19:00:57','12.249.250.150','12.249.250.150','closed',12,721,'attendances/974/1698155944 clock_in.png','attendances/974/1698199257 clock_out.png','Juan R',41361,NULL,'2023-10-24 10:59:04','2023-10-31 17:17:36'),(2553,'2023-10-24 07:00:43','2023-10-24 18:58:25','12.249.250.150','12.249.250.150','closed',11,717,'attendances/1728/1698156043 clock_in.png','attendances/1728/1698199105 clock_out.png','Juan R',41370,NULL,'2023-10-24 11:00:43','2023-10-31 17:19:12'),(2554,'2023-10-24 07:01:38','2023-10-24 15:56:07','12.249.250.150','12.249.250.150','closed',8,534,'attendances/1948/1698156098 clock_in.png','attendances/1948/1698188167 clock_out.png','Juan R',41374,NULL,'2023-10-24 11:01:38','2023-10-31 17:20:04'),(2555,'2023-10-24 07:05:55','2023-10-24 15:47:31','12.249.250.150','12.249.250.150','closed',8,521,'attendances/1462/1698156355 clock_in.png','attendances/1462/1698187651 clock_out.png','Juan R',41368,NULL,'2023-10-24 11:05:55','2023-10-31 17:19:06'),(2556,'2023-10-24 07:08:02','2023-10-24 15:45:04','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1888/1698156482 clock_in.png','attendances/1888/1698187504 clock_out.png','Juan R',41376,NULL,'2023-10-24 11:08:02','2023-10-31 17:20:27'),(2557,'2023-10-24 07:28:51','2023-10-24 16:31:50','12.249.250.150','12.249.250.150','closed',9,542,'attendances/1891/1698157731 clock_in.png','attendances/1891/1698190310 clock_out.png','Juan R',41386,NULL,'2023-10-24 11:28:51','2023-10-31 17:19:49'),(2558,'2023-10-24 07:57:32','2023-10-24 16:30:27','12.249.250.150','12.249.250.150','closed',8,512,'attendances/775/1698159452 clock_in.png','attendances/775/1698190227 clock_out.png','Juan R',41385,NULL,'2023-10-24 11:57:32','2023-10-31 17:19:45'),(2559,'2023-10-25 05:31:52','2023-10-25 17:18:23','12.249.250.150','12.249.250.150','closed',11,706,'attendances/974/1698237112 clock_in.png','attendances/974/1698279503 clock_out.png','Juan R',41441,NULL,'2023-10-25 09:31:52','2023-10-31 17:17:36'),(2560,'2023-10-25 05:54:54','2023-10-25 17:00:21','12.249.250.150','12.249.250.150','closed',11,665,'attendances/1116/1698238494 clock_in.png','attendances/1116/1698278421 clock_out.png','Juan R',41412,NULL,'2023-10-25 09:54:54','2023-10-31 17:19:22'),(2561,'2023-10-25 06:33:33','2023-10-25 15:31:35','12.249.250.150','12.249.250.150','closed',8,538,'attendances/622/1698240813 clock_in.png','attendances/622/1698273095 clock_out.png','Juan R',41440,NULL,'2023-10-25 10:33:33','2023-10-31 17:20:18'),(2562,'2023-10-25 06:48:45','2023-10-25 17:01:02','12.249.250.150','12.249.250.150','closed',10,612,'attendances/1999/1698241725 clock_in.png','attendances/1999/1698278462 clock_out.png','Juan R',41431,NULL,'2023-10-25 10:48:45','2023-10-31 17:19:02'),(2563,'2023-10-25 06:49:02','2023-10-25 17:01:36','12.249.250.150','12.249.250.150','closed',10,612,'attendances/1395/1698241742 clock_in.png','attendances/1395/1698278496 clock_out.png','Juan R',41437,NULL,'2023-10-25 10:49:02','2023-10-31 17:19:29'),(2564,'2023-10-25 06:53:13','2023-10-25 16:01:29','12.249.250.150','12.249.250.150','closed',9,548,'attendances/1585/1698241993 clock_in.png','attendances/1585/1698274890 clock_out.png','Juan R',41423,NULL,'2023-10-25 10:53:13','2023-10-31 17:17:48'),(2565,'2023-10-25 06:53:26','2023-10-25 15:31:26','12.249.250.150','12.249.250.150','closed',8,518,'attendances/1774/1698242006 clock_in.png','attendances/1774/1698273086 clock_out.png','Juan R',41429,NULL,'2023-10-25 10:53:26','2023-10-31 17:18:51'),(2566,'2023-10-25 06:54:15','2023-10-25 15:31:13','12.249.250.150','12.249.250.150','closed',8,516,'attendances/726/1698242055 clock_in.png','attendances/726/1698273073 clock_out.png','Juan R',41421,NULL,'2023-10-25 10:54:15','2023-10-31 17:17:43'),(2567,'2023-10-25 06:55:09','2023-10-25 15:32:48','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1934/1698242109 clock_in.png','attendances/1934/1698273168 clock_out.png',NULL,41433,NULL,'2023-10-25 10:55:09','2023-10-25 19:32:48'),(2568,'2023-10-25 06:55:35','2023-10-25 15:32:26','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1958/1698242135 clock_in.png','attendances/1958/1698273146 clock_out.png','Juan R',41430,NULL,'2023-10-25 10:55:35','2023-10-31 17:18:57'),(2569,'2023-10-25 06:55:41','2023-10-25 15:54:24','12.249.250.150','12.249.250.150','closed',8,538,'attendances/1479/1698242141 clock_in.png','attendances/1479/1698274464 clock_out.png','Juan R',41426,NULL,'2023-10-25 10:55:41','2023-10-31 17:18:02'),(2570,'2023-10-25 06:57:00','2023-10-25 16:06:41','12.249.250.150','12.249.250.150','closed',9,549,'attendances/1728/1698242220 clock_in.png','attendances/1728/1698275201 clock_out.png','Juan R',41434,NULL,'2023-10-25 10:57:00','2023-10-31 17:19:12'),(2571,'2023-10-25 06:58:11','2023-10-25 19:01:22','12.249.250.150','12.249.250.150','closed',12,723,'attendances/1551/1698242291 clock_in.png','attendances/1551/1698285682 clock_out.png','Juan R',41422,NULL,'2023-10-25 10:58:11','2023-10-31 17:17:46'),(2572,'2023-10-25 06:58:27','2023-10-25 15:30:31','12.249.250.150','12.249.250.150','closed',8,512,'attendances/2200/1698242307 clock_in.png','attendances/2200/1698273031 clock_out.png','Juan R',41428,NULL,'2023-10-25 10:58:27','2023-10-31 17:18:40'),(2573,'2023-10-25 06:58:37','2023-10-25 15:30:47','12.249.250.150','12.249.250.150','closed',8,512,'attendances/2116/1698242317 clock_in.png','attendances/2116/1698273047 clock_out.png','Juan R',41425,NULL,'2023-10-25 10:58:37','2023-10-31 17:18:00'),(2574,'2023-10-25 06:58:50','2023-10-25 15:50:02','12.249.250.150','12.249.250.150','closed',8,531,'attendances/1568/1698242330 clock_in.png','attendances/1568/1698274202 clock_out.png','Juan R',41424,NULL,'2023-10-25 10:58:50','2023-10-31 17:17:51'),(2575,'2023-10-25 06:58:58','2023-10-25 15:27:34','12.249.250.150','12.249.250.150','closed',8,508,'attendances/2005/1698242338 clock_in.png','attendances/2005/1698272854 clock_out.png','Juan R',41436,NULL,'2023-10-25 10:58:58','2023-10-31 17:19:18'),(2576,'2023-10-25 07:00:15','2023-10-25 16:06:26','12.249.250.150','12.249.250.150','closed',9,546,'attendances/1450/1698242415 clock_in.png','attendances/1450/1698275186 clock_out.png','Juan R',41439,NULL,'2023-10-25 11:00:15','2023-10-31 17:20:07'),(2577,'2023-10-25 07:01:21','2023-10-25 15:30:09','12.249.250.150','12.249.250.150','closed',8,508,'attendances/1951/1698242481 clock_in.png','attendances/1951/1698273009 clock_out.png','Juan R',41427,NULL,'2023-10-25 11:01:21','2023-10-31 17:18:28'),(2578,'2023-10-25 07:02:43','2023-10-25 15:32:13','12.249.250.150','12.249.250.150','closed',8,509,'attendances/1858/1698242563 clock_in.png','attendances/1858/1698273133 clock_out.png','Juan R',41435,NULL,'2023-10-25 11:02:43','2023-10-31 17:19:15'),(2579,'2023-10-25 07:03:59','2023-10-25 15:41:48','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1948/1698242639 clock_in.png','attendances/1948/1698273708 clock_out.png','Juan R',41438,NULL,'2023-10-25 11:03:59','2023-10-31 17:20:04'),(2580,'2023-10-25 07:06:01','2023-10-25 15:39:14','12.249.250.150','12.249.250.150','closed',8,513,'attendances/1462/1698242761 clock_in.png','attendances/1462/1698273554 clock_out.png','Juan R',41432,NULL,'2023-10-25 11:06:01','2023-10-31 17:19:06'),(2581,'2023-10-25 07:59:54','2023-10-25 16:30:04','12.249.250.150','12.249.250.150','closed',8,510,'attendances/775/1698245994 clock_in.png','attendances/775/1698276604 clock_out.png','Juan R',41446,NULL,'2023-10-25 11:59:54','2023-10-31 17:19:45'),(2582,'2023-10-25 08:01:12','2023-10-25 16:33:23','12.249.250.150','12.249.250.150','closed',8,512,'attendances/2214/1698246072 clock_in.png','attendances/2214/1698276803 clock_out.png','Juan R',41445,NULL,'2023-10-25 12:01:12','2023-10-31 17:18:08'),(2583,'2023-10-25 10:58:15','2023-10-25 16:00:34','12.249.250.150','12.249.250.150','closed',5,302,'attendances/1888/1698256695 clock_in.png','attendances/1888/1698274834 clock_out.png','Juan R',41448,NULL,'2023-10-25 14:58:15','2023-10-31 17:20:27'),(2584,'2023-10-25 07:06:21','2023-10-25 16:33:23','38.51.234.67','12.249.250.150','closed',5,301,'attendances/1891/1698258741 clock_in.png','attendances/1891/1698276803 clock_out.png','Juan R',41447,NULL,'2023-10-25 15:32:21','2023-10-31 17:19:49'),(2586,'2023-10-25 19:14:00','2023-10-25 23:59:00','179.19.21.92','38.51.234.67','closed',4,285,NULL,NULL,'Juan R',41507,NULL,'2023-10-25 23:43:39','2023-10-31 17:17:36'),(2587,'2023-10-26 04:29:57','2023-10-26 13:02:59','12.249.250.150','12.249.250.150','closed',8,513,'attendances/1551/1698319797 clock_in.png','attendances/1551/1698350579 clock_out.png','Juan R',41480,NULL,'2023-10-26 08:29:57','2023-10-31 17:17:46'),(2588,'2023-10-26 04:31:59','2023-10-26 13:05:00','12.249.250.150','179.19.30.174','closed',8,513,'attendances/2005/1698319920 clock_in.png',NULL,'Juan R',41481,NULL,'2023-10-26 08:32:00','2023-10-31 17:19:18'),(2589,'2023-10-26 06:01:13','2023-10-26 14:51:28','12.249.250.150','12.249.250.150','closed',8,530,'attendances/1585/1698325273 clock_in.png','attendances/1585/1698357088 clock_out.png','Juan R',41482,NULL,'2023-10-26 10:01:13','2023-10-31 17:17:48'),(2590,'2023-10-26 06:05:54','2023-10-26 17:11:22','12.249.250.150','12.249.250.150','closed',11,665,'attendances/1999/1698325554 clock_in.png','attendances/1999/1698365482 clock_out.png','Juan R',41493,NULL,'2023-10-26 10:05:54','2023-10-31 17:19:02'),(2591,'2023-10-26 06:35:15','2023-10-26 15:32:54','12.249.250.150','12.249.250.150','closed',8,537,'attendances/622/1698327315 clock_in.png','attendances/622/1698359574 clock_out.png','Juan R',41501,NULL,'2023-10-26 10:35:15','2023-10-31 17:20:18'),(2592,'2023-10-26 06:53:44','2023-10-26 16:47:27','12.249.250.150','12.249.250.150','closed',9,593,'attendances/1116/1698328424 clock_in.png','attendances/1116/1698364047 clock_out.png','Juan R',41498,NULL,'2023-10-26 10:53:44','2023-10-31 17:19:22'),(2593,'2023-10-26 06:54:15','2023-10-26 15:34:54','12.249.250.150','12.249.250.150','closed',8,520,'attendances/726/1698328455 clock_in.png','attendances/726/1698359694 clock_out.png','Juan R',41485,NULL,'2023-10-26 10:54:15','2023-10-31 17:17:43'),(2595,'2023-10-26 06:56:19','2023-10-26 15:32:27','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1774/1698328579 clock_in.png','attendances/1774/1698359547 clock_out.png','Juan R',41491,NULL,'2023-10-26 10:56:19','2023-10-31 17:18:51'),(2596,'2023-10-26 06:56:46','2023-10-26 16:09:21','12.249.250.150','12.249.250.150','closed',9,552,'attendances/1728/1698328606 clock_in.png','attendances/1728/1698361761 clock_out.png','Juan R',41496,NULL,'2023-10-26 10:56:46','2023-10-31 17:19:12'),(2597,'2023-10-26 06:56:49','2023-10-26 15:32:48','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1958/1698328609 clock_in.png','attendances/1958/1698359568 clock_out.png','Juan R',41492,NULL,'2023-10-26 10:56:49','2023-10-31 17:18:57'),(2598,'2023-10-26 06:57:06','2023-10-26 16:48:16','12.249.250.150','12.249.250.150','closed',9,591,'attendances/1395/1698328626 clock_in.png','attendances/1395/1698364096 clock_out.png','Juan R',41499,NULL,'2023-10-26 10:57:06','2023-10-31 17:19:29'),(2599,'2023-10-26 06:57:12','2023-10-26 15:33:23','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1858/1698328632 clock_in.png','attendances/1858/1698359604 clock_out.png','Juan R',41497,NULL,'2023-10-26 10:57:12','2023-10-31 17:19:15'),(2600,'2023-10-26 06:57:28','2023-10-26 16:01:08','12.249.250.150','12.249.250.150','closed',9,543,'attendances/1568/1698328648 clock_in.png','attendances/1568/1698361268 clock_out.png','Juan R',41486,NULL,'2023-10-26 10:57:28','2023-10-31 17:17:51'),(2601,'2023-10-26 06:57:50','2023-10-26 16:36:34','12.249.250.150','12.249.250.150','closed',9,578,'attendances/1891/1698328670 clock_in.png','attendances/1891/1698363394 clock_out.png','Juan R',41506,NULL,'2023-10-26 10:57:50','2023-10-31 17:19:49'),(2602,'2023-10-26 06:58:07','2023-10-26 16:32:37','12.249.250.150','12.249.250.150','closed',9,574,'attendances/1869/1698328687 clock_in.png','attendances/1869/1698363157 clock_out.png','Juan R',41504,NULL,'2023-10-26 10:58:07','2023-10-31 17:17:56'),(2603,'2023-10-26 06:58:23','2023-10-26 16:26:12','12.249.250.150','12.249.250.150','closed',9,567,'attendances/1934/1698328703 clock_in.png','attendances/1934/1698362772 clock_out.png',NULL,41495,NULL,'2023-10-26 10:58:23','2023-10-26 20:26:12'),(2604,'2023-10-26 06:58:36','2023-10-26 17:24:33','12.249.250.150','12.249.250.150','closed',10,625,'attendances/1479/1698328716 clock_in.png','attendances/1479/1698366273 clock_out.png','Juan R',41488,NULL,'2023-10-26 10:58:36','2023-10-31 17:18:02'),(2605,'2023-10-26 06:58:43','2023-10-26 16:00:41','12.249.250.150','12.249.250.150','closed',9,541,'attendances/2200/1698328723 clock_in.png','attendances/2200/1698361241 clock_out.png','Juan R',41490,NULL,'2023-10-26 10:58:43','2023-10-31 17:18:40'),(2606,'2023-10-26 06:59:00','2023-10-26 16:00:52','12.249.250.150','12.249.250.150','closed',9,541,'attendances/2116/1698328740 clock_in.png','attendances/2116/1698361252 clock_out.png','Juan R',41487,NULL,'2023-10-26 10:59:00','2023-10-31 17:18:00'),(2607,'2023-10-26 06:59:21','2023-10-26 17:11:39','12.249.250.150','12.249.250.150','closed',10,612,'attendances/974/1698328761 clock_in.png','attendances/974/1698365499 clock_out.png','Juan R',41503,NULL,'2023-10-26 10:59:21','2023-10-31 17:17:36'),(2608,'2023-10-26 07:00:13','2023-10-26 15:47:51','12.249.250.150','12.249.250.150','closed',8,527,'attendances/1948/1698328813 clock_in.png','attendances/1948/1698360471 clock_out.png','Juan R',41500,NULL,'2023-10-26 11:00:13','2023-10-31 17:20:04'),(2609,'2023-10-26 07:01:14','2023-10-26 15:59:41','12.249.250.150','12.249.250.150','closed',8,538,'attendances/1951/1698328874 clock_in.png','attendances/1951/1698361181 clock_out.png','Juan R',41489,NULL,'2023-10-26 11:01:14','2023-10-31 17:18:28'),(2610,'2023-10-26 00:00:00','2023-10-26 01:14:00','38.51.234.67','38.51.234.67','closed',1,74,NULL,NULL,'Juan R',41508,NULL,'2023-10-26 11:03:30','2023-10-31 17:17:36'),(2611,'2023-10-26 07:07:27','2023-10-26 15:42:36','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1462/1698329247 clock_in.png','attendances/1462/1698360156 clock_out.png','Juan R',41494,NULL,'2023-10-26 11:07:27','2023-10-31 17:19:06'),(2612,'2023-10-26 07:07:48','2023-10-26 15:39:10','12.249.250.150','12.249.250.150','closed',8,511,'attendances/1888/1698329268 clock_in.png','attendances/1888/1698359950 clock_out.png','Juan R',41502,NULL,'2023-10-26 11:07:48','2023-10-31 17:20:27'),(2613,'2023-10-26 07:58:47','2023-10-26 16:30:08','12.249.250.150','12.249.250.150','closed',8,511,'attendances/775/1698332327 clock_in.png','attendances/775/1698363008 clock_out.png','Juan R',41505,NULL,'2023-10-26 11:58:47','2023-10-31 17:19:45'),(2614,'2023-10-27 05:55:33','2023-10-27 17:03:18','12.249.250.150','12.249.250.150','closed',11,667,'attendances/2116/1698411333 clock_in.png','attendances/2116/1698451398 clock_out.png','Juan R',41521,NULL,'2023-10-27 09:55:33','2023-10-31 17:18:00'),(2615,'2023-10-27 06:27:53','2023-10-27 15:30:47','12.249.250.150','12.249.250.150','closed',9,542,'attendances/622/1698413273 clock_in.png','attendances/622/1698445847 clock_out.png','Juan R',41536,NULL,'2023-10-27 10:27:53','2023-10-31 17:20:18'),(2616,'2023-10-27 06:54:25','2023-10-27 15:31:29','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1774/1698414865 clock_in.png','attendances/1774/1698445889 clock_out.png','Juan R',41525,NULL,'2023-10-27 10:54:25','2023-10-31 17:18:51'),(2617,'2023-10-27 06:54:30','2023-10-27 15:47:06','12.249.250.150','12.249.250.150','closed',8,532,'attendances/726/1698414870 clock_in.png','attendances/726/1698446826 clock_out.png','Juan R',41517,NULL,'2023-10-27 10:54:30','2023-10-31 17:17:43'),(2618,'2023-10-27 06:54:35','2023-10-27 17:23:50','12.249.250.150','12.249.250.150','closed',10,629,'attendances/1585/1698414875 clock_in.png','attendances/1585/1698452630 clock_out.png','Juan R',41519,NULL,'2023-10-27 10:54:35','2023-10-31 17:17:48'),(2619,'2023-10-27 06:55:31','2023-10-27 15:34:27','12.249.250.150','12.249.250.150','closed',8,518,'attendances/1958/1698414931 clock_in.png','attendances/1958/1698446067 clock_out.png','Juan R',41526,NULL,'2023-10-27 10:55:31','2023-10-31 17:18:57'),(2620,'2023-10-27 06:56:12','2023-10-27 15:55:47','12.249.250.150','12.249.250.150','closed',8,539,'attendances/1116/1698414972 clock_in.png','attendances/1116/1698447347 clock_out.png','Juan R',41532,NULL,'2023-10-27 10:56:12','2023-10-31 17:19:22'),(2621,'2023-10-27 06:56:24','2023-10-27 15:31:10','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1934/1698414984 clock_in.png','attendances/1934/1698445870 clock_out.png',NULL,41529,NULL,'2023-10-27 10:56:24','2023-10-27 19:31:10'),(2622,'2023-10-27 06:56:44','2023-10-27 15:29:25','12.249.250.150','12.249.250.150','closed',8,512,'attendances/1951/1698415004 clock_in.png','attendances/1951/1698445765 clock_out.png','Juan R',41523,NULL,'2023-10-27 10:56:44','2023-10-31 17:18:28'),(2623,'2023-10-27 06:56:56','2023-10-27 15:49:33','12.249.250.150','12.249.250.150','closed',8,532,'attendances/1948/1698415016 clock_in.png','attendances/1948/1698446973 clock_out.png','Juan R',41534,NULL,'2023-10-27 10:56:56','2023-10-31 17:20:04'),(2624,'2023-10-27 06:56:58','2023-10-27 17:27:10','12.249.250.150','12.249.250.150','closed',10,630,'attendances/1551/1698415018 clock_in.png','attendances/1551/1698452830 clock_out.png','Juan R',41518,NULL,'2023-10-27 10:56:58','2023-10-31 17:17:46'),(2625,'2023-10-27 06:57:10','2023-10-27 16:05:27','12.249.250.150','12.249.250.150','closed',9,548,'attendances/1728/1698415030 clock_in.png','attendances/1728/1698447927 clock_out.png','Juan R',41530,NULL,'2023-10-27 10:57:10','2023-10-31 17:19:12'),(2626,'2023-10-27 06:57:15','2023-10-27 20:00:53','12.249.250.150','12.249.250.150','closed',13,783,'attendances/1568/1698415035 clock_in.png','attendances/1568/1698462053 clock_out.png','Juan R',41520,NULL,'2023-10-27 10:57:15','2023-10-31 17:17:51'),(2627,'2023-10-27 06:57:25','2023-10-27 19:18:53','12.249.250.150','12.249.250.150','closed',12,741,'attendances/1479/1698415045 clock_in.png','attendances/1479/1698459533 clock_out.png','Juan R',41522,NULL,'2023-10-27 10:57:25','2023-10-31 17:18:02'),(2628,'2023-10-27 06:57:37','2023-10-27 15:49:47','12.249.250.150','12.249.250.150','closed',8,532,'attendances/1395/1698415057 clock_in.png','attendances/1395/1698446987 clock_out.png','Juan R',41533,NULL,'2023-10-27 10:57:37','2023-10-31 17:19:29'),(2629,'2023-10-27 06:58:00','2023-10-27 15:46:33','12.249.250.150','12.249.250.150','closed',8,528,'attendances/1450/1698415080 clock_in.png','attendances/1450/1698446793 clock_out.png','Juan R',41535,NULL,'2023-10-27 10:58:00','2023-10-31 17:20:07'),(2630,'2023-10-27 06:58:37','2023-10-27 17:03:43','12.249.250.150','12.249.250.150','closed',10,605,'attendances/2200/1698415117 clock_in.png','attendances/2200/1698451423 clock_out.png','Juan R',41524,NULL,'2023-10-27 10:58:37','2023-10-31 17:18:40'),(2631,'2023-10-27 06:59:17','2023-10-27 19:50:48','12.249.250.150','12.249.250.150','closed',12,771,'attendances/974/1698415157 clock_in.png','attendances/974/1698461448 clock_out.png','Juan R',41538,NULL,'2023-10-27 10:59:17','2023-10-31 17:17:36'),(2632,'2023-10-27 06:59:00','2023-10-27 15:59:00','38.51.234.67','179.19.8.128','closed',8,539,'attendances/1999/1698415168 clock_in.png',NULL,'Juan R',41527,NULL,'2023-10-27 10:59:28','2023-10-31 17:19:02'),(2633,'2023-10-27 07:02:49','2023-10-27 15:43:34','12.249.250.150','12.249.250.150','closed',8,520,'attendances/1888/1698415369 clock_in.png','attendances/1888/1698446614 clock_out.png','Juan R',41537,NULL,'2023-10-27 11:02:49','2023-10-31 17:20:27'),(2634,'2023-10-27 07:05:51','2023-10-27 15:39:29','12.249.250.150','12.249.250.150','closed',8,513,'attendances/1462/1698415551 clock_in.png','attendances/1462/1698446369 clock_out.png','Juan R',41528,NULL,'2023-10-27 11:05:51','2023-10-31 17:19:06'),(2635,'2023-10-27 07:09:30','2023-10-27 15:33:55','12.249.250.150','12.249.250.150','closed',8,504,'attendances/1858/1698415770 clock_in.png','attendances/1858/1698446035 clock_out.png','Juan R',41531,NULL,'2023-10-27 11:09:30','2023-10-31 17:19:15'),(2636,'2023-10-27 08:03:03','2023-10-27 16:35:35','12.249.250.150','12.249.250.150','closed',8,512,'attendances/1869/1698418983 clock_in.png','attendances/1869/1698449735 clock_out.png','Juan R',41539,NULL,'2023-10-27 12:03:03','2023-10-31 17:17:56'),(2637,'2023-10-27 08:03:41','2023-10-27 16:35:46','12.249.250.150','12.249.250.150','closed',8,512,'attendances/1891/1698419021 clock_in.png','attendances/1891/1698449746 clock_out.png','Juan R',41541,NULL,'2023-10-27 12:03:41','2023-10-31 17:19:49'),(2639,'2023-10-30 05:55:31','2023-10-30 14:36:11','12.249.250.150','12.249.250.150','closed',8,520,'attendances/1585/1698670531 clock_in.png','attendances/1585/1698701771 clock_out.png','Juan R',41638,NULL,'2023-10-30 09:55:31','2023-11-07 12:41:31'),(2640,'2023-10-30 05:58:29','2023-10-30 14:31:26','12.249.250.150','12.249.250.150','closed',8,512,'attendances/1551/1698670709 clock_in.png','attendances/1551/1698701486 clock_out.png','Juan R',41637,NULL,'2023-10-30 09:58:29','2023-11-07 12:41:19'),(2641,'2023-10-30 06:47:23','2023-10-30 15:38:05','12.249.250.150','12.249.250.150','closed',8,530,'attendances/622/1698673643 clock_in.png','attendances/622/1698705485 clock_out.png','Juan R',41656,NULL,'2023-10-30 10:47:23','2023-11-07 12:44:21'),(2642,'2023-10-30 06:52:51','2023-10-30 15:29:20','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1728/1698673971 clock_in.png','attendances/1728/1698704960 clock_out.png','Juan R',41647,NULL,'2023-10-30 10:52:51','2023-11-07 12:42:59'),(2643,'2023-10-30 06:54:19','2023-10-30 15:38:19','12.249.250.150','12.249.250.150','closed',8,524,'attendances/1999/1698674059 clock_in.png','attendances/1999/1698705499 clock_out.png','Juan R',41645,NULL,'2023-10-30 10:54:19','2023-11-07 12:42:31'),(2644,'2023-10-30 06:55:31','2023-10-30 15:30:45','12.249.250.150','12.249.250.150','closed',8,515,'attendances/726/1698674131 clock_in.png','attendances/726/1698705045 clock_out.png','Juan R',41639,NULL,'2023-10-30 10:55:31','2023-11-07 12:41:15'),(2645,'2023-10-30 06:55:46','2023-10-30 15:48:18','12.249.250.150','12.249.250.150','closed',8,532,'attendances/2047/1698674146 clock_in.png','attendances/2047/1698706098 clock_out.png','Juan R',41671,NULL,'2023-10-30 10:55:46','2023-11-07 12:42:28'),(2646,'2023-10-30 06:56:07','2023-10-30 15:32:23','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1934/1698674167 clock_in.png','attendances/1934/1698705143 clock_out.png','Juan R',41646,NULL,'2023-10-30 10:56:07','2023-11-07 12:42:41'),(2647,'2023-10-30 06:56:07','2023-10-30 15:35:20','12.249.250.150','12.249.250.150','closed',8,519,'attendances/1948/1698674167 clock_in.png','attendances/1948/1698705320 clock_out.png','Juan R',41653,NULL,'2023-10-30 10:56:07','2023-11-07 12:44:02'),(2648,'2023-10-30 06:56:20','2023-10-30 15:39:05','12.249.250.150','12.249.250.150','closed',8,522,'attendances/1568/1698674180 clock_in.png','attendances/1568/1698705545 clock_out.png','Juan R',41640,NULL,'2023-10-30 10:56:20','2023-11-07 12:41:35'),(2649,'2023-10-30 06:56:29','2023-10-30 15:33:43','12.249.250.150','38.51.234.67','closed',8,517,'attendances/2133/1698674189 clock_in.png','attendances/2133/1698691003 clock_out.png','Juan R',41664,NULL,'2023-10-30 10:56:29','2023-11-07 12:43:07'),(2650,'2023-10-30 06:57:00','2023-10-30 15:36:12','12.249.250.150','12.249.250.150','closed',8,519,'attendances/2169/1698674220 clock_in.png','attendances/2169/1698705372 clock_out.png','Juan R',41676,NULL,'2023-10-30 10:57:00','2023-11-07 12:42:09'),(2651,'2023-10-30 06:57:11','2023-10-30 15:42:23','12.249.250.150','12.249.250.150','closed',8,525,'attendances/2168/1698674231 clock_in.png','attendances/2168/1698705743 clock_out.png','Juan R',41667,NULL,'2023-10-30 10:57:11','2023-11-07 12:42:20'),(2652,'2023-10-30 06:57:16','2023-10-30 15:36:52','12.249.250.150','12.249.250.150','closed',8,519,'attendances/1958/1698674236 clock_in.png','attendances/1958/1698705412 clock_out.png','Juan R',41650,NULL,'2023-10-30 10:57:16','2023-11-07 12:42:25'),(2653,'2023-10-30 06:57:27','2023-10-30 15:34:58','12.249.250.150','12.249.250.150','closed',8,517,'attendances/2080/1698674247 clock_in.png','attendances/2080/1698705298 clock_out.png','Juan R',41655,NULL,'2023-10-30 10:57:27','2023-11-07 12:44:17'),(2654,'2023-10-30 06:57:44','2023-10-30 15:32:59','12.249.250.150','12.249.250.150','closed',8,515,'attendances/2190/1698674264 clock_in.png','attendances/2190/1698705179 clock_out.png','Juan R',41678,NULL,'2023-10-30 10:57:44','2023-11-07 12:42:46'),(2655,'2023-10-30 06:57:53','2023-10-30 15:32:11','12.249.250.150','12.249.250.150','closed',8,514,'attendances/2005/1698674273 clock_in.png','attendances/2005/1698705131 clock_out.png','Juan R',41648,NULL,'2023-10-30 10:57:53','2023-11-07 12:43:10'),(2656,'2023-10-30 06:57:55','2023-10-30 15:36:38','12.249.250.150','12.249.250.150','closed',8,518,'attendances/2116/1698674275 clock_in.png','attendances/2116/1698705398 clock_out.png','Juan R',41641,NULL,'2023-10-30 10:57:55','2023-11-07 12:41:44'),(2657,'2023-10-30 06:58:03','2023-10-30 15:29:50','12.249.250.150','12.249.250.150','closed',8,511,'attendances/1395/1698674283 clock_in.png','attendances/1395/1698704990 clock_out.png','Juan R',41652,NULL,'2023-10-30 10:58:03','2023-11-07 12:43:24'),(2658,'2023-10-30 06:58:12','2023-10-30 15:34:41','12.249.250.150','12.249.250.150','closed',8,516,'attendances/2150/1698674292 clock_in.png','attendances/2150/1698705281 clock_out.png','Juan R',41666,NULL,'2023-10-30 10:58:12','2023-11-07 12:41:22'),(2659,'2023-10-30 06:58:15','2023-10-30 15:38:45','12.249.250.150','12.249.250.150','closed',8,520,'attendances/2218/1698674295 clock_in.png','attendances/2218/1698705525 clock_out.png','Juan R',41679,NULL,'2023-10-30 10:58:15','2023-11-07 12:42:38'),(2660,'2023-10-30 06:58:23','2023-10-30 15:32:27','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1116/1698674303 clock_in.png','attendances/1116/1698705147 clock_out.png','Juan R',41649,NULL,'2023-10-30 10:58:23','2023-11-07 12:43:13'),(2661,'2023-10-30 06:58:53','2023-10-30 15:39:41','12.249.250.150','12.249.250.150','closed',8,520,'attendances/2152/1698674333 clock_in.png','attendances/2152/1698705581 clock_out.png','Juan R',41663,NULL,'2023-10-30 10:58:53','2023-11-07 12:44:27'),(2662,'2023-10-30 06:59:02','2023-10-30 15:41:19','12.249.250.150','12.249.250.150','closed',8,522,'attendances/2205/1698674342 clock_in.png','attendances/2205/1698705679 clock_out.png','Juan R',41669,NULL,'2023-10-30 10:59:02','2023-10-31 17:22:50'),(2663,'2023-10-30 06:59:27','2023-10-30 15:32:41','12.249.250.150','12.249.250.150','closed',8,513,'attendances/2194/1698674367 clock_in.png','attendances/2194/1698705161 clock_out.png','Juan R',41672,NULL,'2023-10-30 10:59:27','2023-10-31 17:21:58'),(2664,'2023-10-30 06:59:57','2023-10-30 15:34:12','12.249.250.150','12.249.250.150','closed',8,514,'attendances/2076/1698674397 clock_in.png','attendances/2076/1698705252 clock_out.png','Juan R',41670,NULL,'2023-10-30 10:59:57','2023-11-07 12:44:14'),(2665,'2023-10-30 07:00:19','2023-10-30 15:36:59','12.249.250.150','12.249.250.150','closed',8,516,'attendances/2200/1698674419 clock_in.png','attendances/2200/1698705419 clock_out.png','Juan R',41643,NULL,'2023-10-30 11:00:19','2023-11-07 12:42:12'),(2666,'2023-10-30 07:01:11','2023-10-30 15:36:14','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1450/1698674471 clock_in.png','attendances/1450/1698705374 clock_out.png','Juan R',41654,NULL,'2023-10-30 11:01:11','2023-11-07 12:44:07'),(2667,'2023-10-30 07:01:34','2023-10-30 15:39:19','12.249.250.150','12.249.250.150','closed',8,517,'attendances/2151/1698674494 clock_in.png','attendances/2151/1698705559 clock_out.png','Juan R',41665,NULL,'2023-10-30 11:01:34','2023-11-07 12:43:19'),(2668,'2023-10-30 07:01:40','2023-10-30 15:33:38','12.249.250.150','12.249.250.150','closed',8,511,'attendances/974/1698674500 clock_in.png','attendances/974/1698705218 clock_out.png','Juan R',41658,NULL,'2023-10-30 11:01:40','2023-11-07 12:40:48'),(2669,'2023-10-30 07:02:20','2023-10-30 15:32:52','12.249.250.150','12.249.250.150','closed',8,510,'attendances/1744/1698674540 clock_in.png','attendances/1744/1698705172 clock_out.png','Juan R',41677,NULL,'2023-10-30 11:02:20','2023-11-07 12:43:16'),(2670,'2023-10-30 07:02:38','2023-10-30 15:34:12','12.249.250.150','12.249.250.150','closed',8,511,'attendances/2179/1698674558 clock_in.png','attendances/2179/1698705252 clock_out.png','Juan R',41674,NULL,'2023-10-30 11:02:38','2023-11-07 12:44:31'),(2671,'2023-10-30 07:02:52','2023-10-30 15:36:23','12.249.250.150','12.249.250.150','closed',8,513,'attendances/1951/1698674572 clock_in.png','attendances/1951/1698705384 clock_out.png','Juan R',41642,NULL,'2023-10-30 11:02:52','2023-11-07 12:41:57'),(2672,'2023-10-30 07:03:18','2023-10-30 15:34:24','12.249.250.150','12.249.250.150','closed',8,511,'attendances/2178/1698674598 clock_in.png','attendances/2178/1698705264 clock_out.png','Juan R',41673,NULL,'2023-10-30 11:03:18','2023-11-07 12:41:27'),(2673,'2023-10-30 07:04:11','2023-10-30 15:34:35','12.249.250.150','12.249.250.150','closed',8,510,'attendances/2102/1698674651 clock_in.png','attendances/2102/1698705275 clock_out.png','Juan R',41668,NULL,'2023-10-30 11:04:11','2023-10-31 17:22:12'),(2674,'2023-10-30 07:05:06','2023-10-30 15:42:00','12.249.250.150','12.249.250.150','closed',8,516,'attendances/2192/1698674706 clock_in.png','attendances/2192/1698705720 clock_out.png','Juan R',41675,NULL,'2023-10-30 11:05:06','2023-11-07 12:44:10'),(2675,'2023-10-30 07:07:41','2023-10-30 15:42:25','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1888/1698674861 clock_in.png','attendances/1888/1698705745 clock_out.png','Juan R',41657,NULL,'2023-10-30 11:07:41','2023-11-07 12:44:35'),(2676,'2023-10-30 07:10:50','2023-10-30 15:36:40','12.249.250.150','12.249.250.150','closed',8,505,'attendances/1858/1698675050 clock_in.png','attendances/1858/1698705400 clock_out.png','Juan R',41651,NULL,'2023-10-30 11:10:50','2023-11-07 12:43:04'),(2677,'2023-10-30 08:03:48','2023-10-30 16:32:17','12.249.250.150','12.249.250.150','closed',8,508,'attendances/1869/1698678228 clock_in.png','attendances/1869/1698708737 clock_out.png','Juan R',41659,NULL,'2023-10-30 12:03:48','2023-11-07 12:41:39'),(2678,'2023-10-30 08:03:57','2023-10-30 16:32:02','12.249.250.150','12.249.250.150','closed',8,508,'attendances/1891/1698678237 clock_in.png','attendances/1891/1698708723 clock_out.png','Juan R',41662,NULL,'2023-10-30 12:03:57','2023-11-07 12:43:47'),(2679,'2023-10-30 08:06:50','2023-10-30 15:39:16','12.249.250.150','12.249.250.150','closed',7,452,'attendances/1462/1698678410 clock_in.png','attendances/1462/1698705556 clock_out.png','Juan R',41660,NULL,'2023-10-30 12:06:50','2023-11-07 12:42:34'),(2680,'2023-10-30 08:25:44','2023-10-30 17:00:15','12.249.250.150','12.249.250.150','closed',8,514,'attendances/775/1698679544 clock_in.png','attendances/775/1698710415 clock_out.png','Juan R',41661,NULL,'2023-10-30 12:25:44','2023-11-07 12:43:38'),(2683,'2023-10-31 05:55:49','2023-10-31 17:46:08','12.249.250.150','12.249.250.150','closed',11,710,'attendances/726/1698756949 clock_in.png','attendances/726/1698799568 clock_out.png','Juan R',41684,NULL,'2023-10-31 09:55:49','2023-11-07 12:41:15'),(2684,'2023-10-31 05:58:06','2023-10-31 15:56:23','12.249.250.150','12.249.250.150','closed',9,598,'attendances/2005/1698757086 clock_in.png','attendances/2005/1698792983 clock_out.png','Juan R',41685,NULL,'2023-10-31 09:58:06','2023-11-07 12:43:10'),(2685,'2023-10-31 05:58:47','2023-10-31 15:57:10','12.249.250.150','12.249.250.150','closed',9,598,'attendances/2076/1698757127 clock_in.png','attendances/2076/1698793030 clock_out.png','Juan R',41687,NULL,'2023-10-31 09:58:47','2023-11-07 12:44:14'),(2686,'2023-10-31 06:01:44','2023-10-31 17:46:55','12.249.250.150','12.249.250.150','closed',11,705,'attendances/1450/1698757304 clock_in.png','attendances/1450/1698799615 clock_out.png','Juan R',41686,NULL,'2023-10-31 10:01:44','2023-11-07 12:44:07'),(2687,'2023-10-31 06:16:04','2023-10-31 17:47:41','12.249.250.150','12.249.250.150','closed',11,691,'attendances/974/1698758164 clock_in.png','attendances/974/1698799661 clock_out.png','Juan R',41688,NULL,'2023-10-31 10:16:04','2023-11-07 12:40:48'),(2688,'2023-10-31 06:29:15','2023-10-31 15:33:31','12.249.250.150','12.249.250.150','closed',9,544,'attendances/622/1698758955 clock_in.png','attendances/622/1698791611 clock_out.png','Juan R',41710,NULL,'2023-10-31 10:29:15','2023-11-07 12:44:21'),(2689,'2023-10-31 06:50:31','2023-10-31 15:52:21','12.249.250.150','12.249.250.150','closed',9,541,'attendances/1999/1698760231 clock_in.png','attendances/1999/1698792741 clock_out.png','Juan R',41699,NULL,'2023-10-31 10:50:31','2023-11-07 12:42:31'),(2690,'2023-10-31 06:53:52','2023-10-31 15:32:12','12.249.250.150','12.249.250.150','closed',8,518,'attendances/1585/1698760432 clock_in.png','attendances/1585/1698791532 clock_out.png','Juan R',41690,NULL,'2023-10-31 10:53:52','2023-11-07 12:41:31'),(2691,'2023-10-31 06:54:32','2023-10-31 15:31:23','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1774/1698760472 clock_in.png','attendances/1774/1698791483 clock_out.png','Juan R',41696,NULL,'2023-10-31 10:54:32','2023-11-07 12:42:17'),(2692,'2023-10-31 06:55:08','2023-10-31 16:27:15','12.249.250.150','190.103.31.247','closed',9,572,'attendances/2218/1698760508 clock_in.png','attendances/2218/1698777315 clock_out.png','Juan R',41701,NULL,'2023-10-31 10:55:08','2023-11-07 12:42:38'),(2693,'2023-10-31 06:55:20','2023-10-31 15:30:52','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1934/1698760520 clock_in.png','attendances/1934/1698791452 clock_out.png','Juan R',41702,NULL,'2023-10-31 10:55:20','2023-11-07 12:42:41'),(2694,'2023-10-31 06:55:31','2023-10-31 15:32:28','12.249.250.150','12.249.250.150','closed',8,516,'attendances/2116/1698760531 clock_in.png','attendances/2116/1698791548 clock_out.png','Juan R',41692,NULL,'2023-10-31 10:55:31','2023-11-07 12:41:44'),(2695,'2023-10-31 06:55:50','2023-10-31 15:33:14','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1958/1698760550 clock_in.png','attendances/1958/1698791594 clock_out.png','Juan R',41698,NULL,'2023-10-31 10:55:50','2023-11-07 12:42:25'),(2696,'2023-10-31 06:56:03','2023-10-31 16:35:26','12.249.250.150','12.249.250.150','closed',9,579,'attendances/1479/1698760563 clock_in.png','attendances/1479/1698795326 clock_out.png','Juan R',41693,NULL,'2023-10-31 10:56:03','2023-11-07 12:41:47'),(2697,'2023-10-31 06:56:06','2023-10-31 15:33:12','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1858/1698760566 clock_in.png','attendances/1858/1698791592 clock_out.png','Juan R',41704,NULL,'2023-10-31 10:56:06','2023-11-07 12:43:04'),(2698,'2023-10-31 06:56:20','2023-10-31 15:32:14','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1116/1698760580 clock_in.png','attendances/1116/1698791534 clock_out.png','Juan R',41705,NULL,'2023-10-31 10:56:20','2023-11-07 12:43:13'),(2699,'2023-10-31 06:56:34','2023-10-31 17:42:40','12.249.250.150','12.249.250.150','closed',10,646,'attendances/1568/1698760594 clock_in.png','attendances/1568/1698799360 clock_out.png','Juan R',41691,NULL,'2023-10-31 10:56:34','2023-11-07 12:41:35'),(2700,'2023-10-31 06:56:36','2023-10-31 15:31:37','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1395/1698760596 clock_in.png','attendances/1395/1698791497 clock_out.png','Juan R',41707,NULL,'2023-10-31 10:56:36','2023-11-07 12:43:24'),(2701,'2023-10-31 06:56:50','2023-10-31 15:32:03','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1728/1698760610 clock_in.png','attendances/1728/1698791523 clock_out.png','Juan R',41703,NULL,'2023-10-31 10:56:50','2023-11-07 12:42:59'),(2702,'2023-10-31 06:58:11','2023-10-31 16:59:25','12.249.250.150','12.249.250.150','closed',10,601,'attendances/1951/1698760691 clock_in.png','attendances/1951/1698796765 clock_out.png','Juan R',41694,NULL,'2023-10-31 10:58:11','2023-11-07 12:41:57'),(2703,'2023-10-31 07:01:49','2023-10-31 15:31:53','12.249.250.150','12.249.250.150','closed',8,510,'attendances/1744/1698760909 clock_in.png','attendances/1744/1698791513 clock_out.png','Juan R',41706,NULL,'2023-10-31 11:01:49','2023-11-07 12:43:16'),(2704,'2023-10-31 07:02:00','2023-10-31 15:36:53','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1888/1698760920 clock_in.png','attendances/1888/1698791813 clock_out.png','Juan R',41711,NULL,'2023-10-31 11:02:00','2023-11-07 12:44:35'),(2705,'2023-10-31 07:03:45','2023-10-31 15:32:57','12.249.250.150','12.249.250.150','closed',8,509,'attendances/2168/1698761025 clock_in.png','attendances/2168/1698791577 clock_out.png','Juan R',41697,NULL,'2023-10-31 11:03:45','2023-11-07 12:42:20'),(2706,'2023-10-31 07:06:42','2023-10-31 16:16:59','12.249.250.150','12.249.250.150','closed',9,550,'attendances/1948/1698761202 clock_in.png','attendances/1948/1698794219 clock_out.png','Juan R',41708,NULL,'2023-10-31 11:06:42','2023-11-07 12:44:02'),(2707,'2023-10-31 07:10:11','2023-10-31 15:38:24','12.249.250.150','12.249.250.150','closed',8,508,'attendances/1462/1698761411 clock_in.png','attendances/1462/1698791904 clock_out.png','Juan R',41700,NULL,'2023-10-31 11:10:11','2023-11-07 12:42:34'),(2708,'2023-10-31 07:11:36','2023-10-31 15:43:06','12.249.250.150','12.249.250.150','closed',8,511,'attendances/2200/1698761496 clock_in.png','attendances/2200/1698792186 clock_out.png','Juan R',41695,NULL,'2023-10-31 11:11:36','2023-11-07 12:42:12'),(2709,'2023-10-31 07:12:02','2023-10-31 16:27:06','12.249.250.150','12.249.250.150','closed',9,555,'attendances/2080/1698761522 clock_in.png','attendances/2080/1698794826 clock_out.png','Juan R',41709,NULL,'2023-10-31 11:12:02','2023-11-07 12:44:17'),(2710,'2023-10-31 08:05:05','2023-10-31 16:31:55','12.249.250.150','12.249.250.150','closed',8,506,'attendances/1869/1698764705 clock_in.png','attendances/1869/1698795115 clock_out.png','Juan R',41681,NULL,'2023-10-31 12:05:05','2023-11-07 12:41:39'),(2711,'2023-10-31 08:26:23','2023-10-31 17:00:14','12.249.250.150','12.249.250.150','closed',8,513,'attendances/775/1698765983 clock_in.png','attendances/775/1698796814 clock_out.png','Juan R',41682,NULL,'2023-10-31 12:26:23','2023-11-07 12:43:38'),(2712,'2023-10-31 12:59:23','2023-10-31 16:31:49','12.249.250.150','12.249.250.150','closed',3,212,'attendances/1891/1698782363 clock_in.png','attendances/1891/1698795109 clock_out.png','Juan R',41683,NULL,'2023-10-31 16:59:23','2023-11-07 12:43:47'),(2714,'2023-11-01 05:51:51','2023-11-01 15:19:04','12.249.250.150','12.249.250.150','closed',9,567,'attendances/2076/1698843111 clock_in.png','attendances/2076/1698877144 clock_out.png','Juan R',41746,NULL,'2023-11-01 09:51:51','2023-11-07 12:44:14'),(2715,'2023-11-01 05:53:17','2023-11-01 16:50:30','12.249.250.150','12.249.250.150','closed',10,657,'attendances/726/1698843197 clock_in.png','attendances/726/1698882630 clock_out.png','Juan R',41743,NULL,'2023-11-01 09:53:17','2023-11-07 12:41:15'),(2716,'2023-11-01 05:57:12','2023-11-01 15:01:20','12.249.250.150','12.249.250.150','closed',9,544,'attendances/1551/1698843432 clock_in.png','attendances/1551/1698876080 clock_out.png','Juan R',41744,NULL,'2023-11-01 09:57:12','2023-11-07 12:41:19'),(2717,'2023-11-01 06:00:37','2023-11-01 16:48:38','12.249.250.150','12.249.250.150','closed',10,648,'attendances/1450/1698843637 clock_in.png','attendances/1450/1698882518 clock_out.png','Juan R',41745,NULL,'2023-11-01 10:00:37','2023-11-07 12:44:07'),(2718,'2023-11-01 06:45:27','2023-11-01 15:36:03','12.249.250.150','12.249.250.150','closed',8,530,'attendances/622/1698846327 clock_in.png','attendances/622/1698878163 clock_out.png','Juan R',41749,NULL,'2023-11-01 10:45:27','2023-11-07 12:44:21'),(2719,'2023-11-01 06:50:14','2023-11-01 15:44:17','12.249.250.150','12.249.250.150','closed',8,534,'attendances/1999/1698846614 clock_in.png','attendances/1999/1698878657 clock_out.png','Juan R',41759,NULL,'2023-11-01 10:50:14','2023-11-07 12:42:31'),(2720,'2023-11-01 06:54:06','2023-11-01 15:30:23','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1585/1698846846 clock_in.png','attendances/1585/1698877823 clock_out.png','Juan R',41752,NULL,'2023-11-01 10:54:06','2023-11-07 12:41:31'),(2721,'2023-11-01 06:54:28','2023-11-01 15:33:31','12.249.250.150','12.249.250.150','closed',8,519,'attendances/1774/1698846868 clock_in.png','attendances/1774/1698878011 clock_out.png','Juan R',41757,NULL,'2023-11-01 10:54:28','2023-11-07 12:42:17'),(2722,'2023-11-01 06:54:39','2023-11-01 15:31:06','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1934/1698846879 clock_in.png','attendances/1934/1698877866 clock_out.png','Juan R',41761,NULL,'2023-11-01 10:54:39','2023-11-07 12:42:41'),(2723,'2023-11-01 06:54:41','2023-11-01 15:32:15','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1958/1698846881 clock_in.png','attendances/1958/1698877935 clock_out.png','Juan R',41758,NULL,'2023-11-01 10:54:41','2023-11-07 12:42:25'),(2724,'2023-11-01 06:55:06','2023-11-01 15:33:14','12.249.250.150','38.51.234.67','closed',8,518,'attendances/2080/1698846906 clock_in.png','attendances/2080/1698861614 clock_out.png','Juan R',41772,NULL,'2023-11-01 10:55:06','2023-11-07 12:44:17'),(2725,'2023-11-01 06:55:45','2023-11-01 15:33:25','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1744/1698846945 clock_in.png','attendances/1744/1698878005 clock_out.png','Juan R',41770,NULL,'2023-11-01 10:55:45','2023-11-07 12:43:16'),(2726,'2023-11-01 06:57:04','2023-11-01 15:32:36','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1858/1698847024 clock_in.png','attendances/1858/1698877956 clock_out.png','Juan R',41748,NULL,'2023-11-01 10:57:04','2023-11-07 12:43:04'),(2727,'2023-11-01 06:57:04','2023-11-01 15:30:53','12.249.250.150','12.249.250.150','closed',8,513,'attendances/2116/1698847024 clock_in.png','attendances/2116/1698877853 clock_out.png','Juan R',41766,NULL,'2023-11-01 10:57:04','2023-11-07 12:41:44'),(2728,'2023-11-01 06:57:17','2023-11-01 16:03:55','12.249.250.150','12.249.250.150','closed',9,546,'attendances/2005/1698847037 clock_in.png','attendances/2005/1698879835 clock_out.png','Juan R',41763,NULL,'2023-11-01 10:57:17','2023-11-07 12:43:10'),(2729,'2023-11-01 06:57:19','2023-11-01 15:34:11','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1728/1698847039 clock_in.png','attendances/1728/1698878051 clock_out.png','Juan R',41762,NULL,'2023-11-01 10:57:19','2023-11-07 12:42:59'),(2730,'2023-11-01 06:57:29','2023-11-01 15:33:06','12.249.250.150','12.249.250.150','closed',8,515,'attendances/2168/1698847049 clock_in.png','attendances/2168/1698877986 clock_out.png','Juan R',41767,NULL,'2023-11-01 10:57:29','2023-11-07 12:42:20'),(2731,'2023-11-01 06:57:43','2023-11-01 15:33:02','12.249.250.150','12.249.250.150','closed',8,515,'attendances/2169/1698847063 clock_in.png','attendances/2169/1698877982 clock_out.png','Juan R',41753,NULL,'2023-11-01 10:57:43','2023-11-07 12:42:09'),(2732,'2023-11-01 06:57:44','2023-11-01 15:35:19','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1116/1698847064 clock_in.png','attendances/1116/1698878119 clock_out.png','Juan R',41764,NULL,'2023-11-01 10:57:44','2023-11-07 12:43:13'),(2733,'2023-11-01 06:57:57','2023-11-01 15:36:54','12.249.250.150','12.249.250.150','closed',8,518,'attendances/2200/1698847077 clock_in.png','attendances/2200/1698878214 clock_out.png','Juan R',41756,NULL,'2023-11-01 10:57:57','2023-11-07 12:42:12'),(2734,'2023-11-01 06:58:11','2023-11-01 15:31:43','12.249.250.150','12.249.250.150','closed',8,513,'attendances/2218/1698847091 clock_in.png','attendances/2218/1698877903 clock_out.png','Juan R',41768,NULL,'2023-11-01 10:58:11','2023-11-07 12:42:38'),(2735,'2023-11-01 06:58:24','2023-11-01 15:32:14','12.249.250.150','12.249.250.150','closed',8,513,'attendances/1479/1698847104 clock_in.png','attendances/1479/1698877934 clock_out.png','Juan R',41754,NULL,'2023-11-01 10:58:24','2023-11-07 12:41:47'),(2736,'2023-11-01 06:59:35','2023-11-01 15:32:29','12.249.250.150','12.249.250.150','closed',8,512,'attendances/1395/1698847175 clock_in.png','attendances/1395/1698877949 clock_out.png','Juan R',41765,NULL,'2023-11-01 10:59:35','2023-11-07 12:43:24'),(2737,'2023-11-01 06:59:54','2023-11-01 15:31:28','12.249.250.150','12.249.250.150','closed',8,511,'attendances/1951/1698847194 clock_in.png','attendances/1951/1698877888 clock_out.png','Juan R',41755,NULL,'2023-11-01 10:59:54','2023-11-07 12:41:57'),(2738,'2023-11-01 07:00:38','2023-11-01 15:36:34','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1948/1698847238 clock_in.png','attendances/1948/1698878194 clock_out.png','Juan R',41750,NULL,'2023-11-01 11:00:38','2023-11-07 12:44:02'),(2739,'2023-11-01 07:00:57','2023-11-01 15:45:06','12.249.250.150','12.249.250.150','closed',8,524,'attendances/974/1698847257 clock_in.png','attendances/974/1698878706 clock_out.png','Juan R',41751,NULL,'2023-11-01 11:00:57','2023-11-07 12:40:48'),(2740,'2023-11-01 07:02:52','2023-11-01 15:31:09','12.249.250.150','12.249.250.150','closed',8,508,'attendances/2133/1698847372 clock_in.png','attendances/2133/1698877869 clock_out.png','Juan R',41769,NULL,'2023-11-01 11:02:52','2023-11-07 12:43:07'),(2741,'2023-11-01 07:03:12','2023-11-01 15:46:07','12.249.250.150','12.249.250.150','closed',8,522,'attendances/1888/1698847392 clock_in.png','attendances/1888/1698878767 clock_out.png','Juan R',41747,NULL,'2023-11-01 11:03:12','2023-11-07 12:44:35'),(2742,'2023-11-01 07:03:27','2023-11-01 15:34:01','12.249.250.150','12.249.250.150','closed',8,510,'attendances/2047/1698847407 clock_in.png','attendances/2047/1698878041 clock_out.png','Juan R',41773,NULL,'2023-11-01 11:03:27','2023-11-07 12:42:28'),(2743,'2023-11-01 07:05:28','2023-11-01 15:34:28','12.249.250.150','12.249.250.150','closed',8,509,'attendances/2192/1698847528 clock_in.png','attendances/2192/1698878068 clock_out.png','Juan R',41771,NULL,'2023-11-01 11:05:28','2023-11-07 12:44:10'),(2744,'2023-11-01 07:07:39','2023-11-01 15:36:19','12.249.250.150','12.249.250.150','closed',8,508,'attendances/1462/1698847659 clock_in.png','attendances/1462/1698878179 clock_out.png','Juan R',41760,NULL,'2023-11-01 11:07:39','2023-11-07 12:42:34'),(2745,'2023-11-01 07:51:51','2023-11-01 16:32:16','12.249.250.150','12.249.250.150','closed',8,520,'attendances/1869/1698850311 clock_in.png','attendances/1869/1698881536 clock_out.png','Juan R',41740,NULL,'2023-11-01 11:51:51','2023-11-07 12:41:39'),(2746,'2023-11-01 08:00:24','2023-11-01 16:39:29','12.249.250.150','12.249.250.150','closed',8,519,'attendances/1891/1698850824 clock_in.png','attendances/1891/1698881969 clock_out.png','Juan R',41742,NULL,'2023-11-01 12:00:24','2023-11-07 12:43:47'),(2747,'2023-11-01 08:26:16','2023-11-01 17:00:34','12.249.250.150','12.249.250.150','closed',8,514,'attendances/775/1698852376 clock_in.png','attendances/775/1698883234 clock_out.png','Juan R',41741,NULL,'2023-11-01 12:26:16','2023-11-07 12:43:38'),(2750,'2023-11-02 05:53:44','2023-11-02 16:11:43','12.249.250.150','12.249.250.150','closed',10,617,'attendances/2116/1698929624 clock_in.png','attendances/2116/1698966703 clock_out.png','Juan R',41777,NULL,'2023-11-02 09:53:44','2023-11-07 12:41:44'),(2751,'2023-11-02 05:53:46','2023-11-02 16:24:15','12.249.250.150','12.249.250.150','closed',10,630,'attendances/1585/1698929626 clock_in.png','attendances/1585/1698967455 clock_out.png','Juan R',41776,NULL,'2023-11-02 09:53:46','2023-11-07 12:41:31'),(2752,'2023-11-02 05:54:41','2023-11-02 16:39:15','12.249.250.150','12.249.250.150','closed',10,644,'attendances/726/1698929681 clock_in.png','attendances/726/1698968355 clock_out.png','Juan R',41774,NULL,'2023-11-02 09:54:41','2023-11-07 12:41:15'),(2753,'2023-11-02 05:56:12','2023-11-02 16:24:49','12.249.250.150','12.249.250.150','closed',10,628,'attendances/1551/1698929772 clock_in.png','attendances/1551/1698967489 clock_out.png','Juan R',41775,NULL,'2023-11-02 09:56:12','2023-11-07 12:41:19'),(2754,'2023-11-02 05:56:13','2023-11-02 16:25:47','12.249.250.150','12.249.250.150','closed',10,629,'attendances/2076/1698929773 clock_in.png','attendances/2076/1698967547 clock_out.png','Juan R',41780,NULL,'2023-11-02 09:56:13','2023-11-07 12:44:14'),(2755,'2023-11-02 05:56:31','2023-11-02 14:35:47','12.249.250.150','12.249.250.150','closed',8,519,'attendances/2005/1698929791 clock_in.png','attendances/2005/1698960947 clock_out.png','Juan R',41779,NULL,'2023-11-02 09:56:31','2023-11-07 12:43:10'),(2756,'2023-11-02 06:30:16','2023-11-02 15:31:33','12.249.250.150','12.249.250.150','closed',9,541,'attendances/622/1698931816 clock_in.png','attendances/622/1698964293 clock_out.png','Juan R',41798,NULL,'2023-11-02 10:30:16','2023-11-07 12:44:21'),(2757,'2023-11-02 06:54:39','2023-11-02 15:39:03','12.249.250.150','12.249.250.150','closed',8,524,'attendances/1116/1698933279 clock_in.png','attendances/1116/1698964743 clock_out.png','Juan R',41793,NULL,'2023-11-02 10:54:39','2023-11-07 12:43:13'),(2758,'2023-11-02 06:55:02','2023-11-02 15:30:56','12.249.250.150','12.249.250.150','closed',8,515,'attendances/2218/1698933302 clock_in.png','attendances/2218/1698964256 clock_out.png','Juan R',41789,NULL,'2023-11-02 10:55:03','2023-11-07 12:42:38'),(2759,'2023-11-02 06:55:51','2023-11-02 15:38:45','12.249.250.150','12.249.250.150','closed',8,522,'attendances/1999/1698933351 clock_in.png','attendances/1999/1698964725 clock_out.png','Juan R',41787,NULL,'2023-11-02 10:55:51','2023-11-07 12:42:31'),(2760,'2023-11-02 06:55:56','2023-11-02 15:31:44','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1774/1698933356 clock_in.png','attendances/1774/1698964304 clock_out.png','Juan R',41784,NULL,'2023-11-02 10:55:56','2023-11-07 12:42:17'),(2761,'2023-11-02 06:56:16','2023-11-02 15:31:55','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1934/1698933376 clock_in.png','attendances/1934/1698964315 clock_out.png','Juan R',41790,NULL,'2023-11-02 10:56:16','2023-11-07 12:42:41'),(2762,'2023-11-02 06:56:56','2023-11-02 15:45:25','12.249.250.150','12.249.250.150','closed',8,528,'attendances/1395/1698933417 clock_in.png','attendances/1395/1698965125 clock_out.png','Juan R',41795,NULL,'2023-11-02 10:56:57','2023-11-07 12:43:24'),(2763,'2023-11-02 06:57:05','2023-11-02 15:32:51','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1744/1698933425 clock_in.png','attendances/1744/1698964371 clock_out.png','Juan R',41794,NULL,'2023-11-02 10:57:05','2023-11-07 12:43:16'),(2764,'2023-11-02 06:57:15','2023-11-02 15:37:57','12.249.250.150','12.249.250.150','closed',8,520,'attendances/1728/1698933436 clock_in.png','attendances/1728/1698964677 clock_out.png','Juan R',41791,NULL,'2023-11-02 10:57:16','2023-11-07 12:42:59'),(2765,'2023-11-02 06:57:16','2023-11-02 15:32:06','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1958/1698933436 clock_in.png','attendances/1958/1698964326 clock_out.png','Juan R',41786,NULL,'2023-11-02 10:57:16','2023-11-07 12:42:25'),(2766,'2023-11-02 06:57:36','2023-11-02 15:31:13','12.249.250.150','12.249.250.150','closed',8,513,'attendances/2080/1698933456 clock_in.png','attendances/2080/1698964273 clock_out.png','Juan R',41797,NULL,'2023-11-02 10:57:36','2023-11-07 12:44:17'),(2767,'2023-11-02 06:57:50','2023-11-02 15:31:57','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1479/1698933470 clock_in.png','attendances/1479/1698964317 clock_out.png','Juan R',41782,NULL,'2023-11-02 10:57:50','2023-11-07 12:41:47'),(2768,'2023-11-02 06:58:53','2023-11-02 16:01:12','12.249.250.150','12.249.250.150','closed',9,542,'attendances/974/1698933533 clock_in.png','attendances/974/1698966072 clock_out.png','Juan R',41800,NULL,'2023-11-02 10:58:53','2023-11-07 12:40:48'),(2769,'2023-11-02 06:59:11','2023-11-02 15:42:13','12.249.250.150','12.249.250.150','closed',8,523,'attendances/1568/1698933551 clock_in.png','attendances/1568/1698964933 clock_out.png','Juan R',41781,NULL,'2023-11-02 10:59:11','2023-11-07 12:41:35'),(2770,'2023-11-02 07:00:20','2023-11-02 15:44:33','12.249.250.150','12.249.250.150','closed',8,524,'attendances/1951/1698933620 clock_in.png','attendances/1951/1698965073 clock_out.png','Juan R',41783,NULL,'2023-11-02 11:00:20','2023-11-07 12:41:57'),(2771,'2023-11-02 07:01:21','2023-11-02 15:32:34','12.249.250.150','12.249.250.150','closed',8,511,'attendances/2168/1698933681 clock_in.png','attendances/2168/1698964354 clock_out.png','Juan R',41785,NULL,'2023-11-02 11:01:21','2023-11-07 12:42:20'),(2772,'2023-11-02 07:06:47','2023-11-02 16:05:21','12.249.250.150','12.249.250.150','closed',8,538,'attendances/1888/1698934007 clock_in.png','attendances/1888/1698966321 clock_out.png','Juan R',41799,NULL,'2023-11-02 11:06:47','2023-11-07 12:44:35'),(2773,'2023-11-02 07:07:38','2023-11-02 15:32:20','12.249.250.150','12.249.250.150','closed',8,504,'attendances/1858/1698934058 clock_in.png','attendances/1858/1698964340 clock_out.png','Juan R',41792,NULL,'2023-11-02 11:07:38','2023-11-07 12:43:04'),(2774,'2023-11-02 07:08:27','2023-11-02 15:42:38','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1948/1698934107 clock_in.png','attendances/1948/1698964958 clock_out.png','Juan R',41796,NULL,'2023-11-02 11:08:27','2023-11-07 12:44:02'),(2775,'2023-11-02 07:52:15','2023-11-02 15:36:40','12.249.250.150','12.249.250.150','closed',7,464,'attendances/1462/1698936735 clock_in.png','attendances/1462/1698964600 clock_out.png','Juan R',41788,NULL,'2023-11-02 11:52:15','2023-11-07 12:42:34'),(2776,'2023-11-02 07:55:12','2023-11-02 16:32:58','12.249.250.150','38.51.234.67','closed',8,517,'attendances/1869/1698936913 clock_in.png','attendances/1869/1698955438 clock_out.png','Juan R',41801,NULL,'2023-11-02 11:55:13','2023-11-07 12:41:39'),(2777,'2023-11-02 08:00:36','2023-11-02 16:33:23','12.249.250.150','12.249.250.150','closed',8,512,'attendances/1891/1698937236 clock_in.png','attendances/1891/1698968003 clock_out.png','Juan R',41803,NULL,'2023-11-02 12:00:36','2023-11-07 12:43:47'),(2778,'2023-11-02 08:27:08','2023-11-02 17:00:24','12.249.250.150','12.249.250.150','closed',8,513,'attendances/775/1698938828 clock_in.png','attendances/775/1698969624 clock_out.png','Juan R',41802,NULL,'2023-11-02 12:27:08','2023-11-07 12:43:38'),(2779,'2023-11-02 09:49:05','2023-11-02 18:00:19','12.249.250.150','12.249.250.150','closed',8,491,'attendances/2200/1698943745 clock_in.png','attendances/2200/1698973219 clock_out.png','Juan R',41805,NULL,'2023-11-02 13:49:05','2023-11-07 12:42:12'),(2780,'2023-11-02 09:52:18','2023-11-02 20:40:45','12.249.250.150','12.249.250.150','closed',10,648,'attendances/2047/1698943938 clock_in.png','attendances/2047/1698982845 clock_out.png','Juan R',41806,NULL,'2023-11-02 13:52:18','2023-11-07 12:42:28'),(2781,'2023-11-02 09:52:38','2023-11-02 20:41:11','12.249.250.150','12.249.250.150','closed',10,648,'attendances/2169/1698943958 clock_in.png','attendances/2169/1698982871 clock_out.png','Juan R',41804,NULL,'2023-11-02 13:52:38','2023-11-07 12:42:09'),(2782,'2023-11-02 10:02:03','2023-11-02 17:59:17','12.249.250.150','12.249.250.150','closed',7,477,'attendances/2192/1698944523 clock_in.png','attendances/2192/1698973157 clock_out.png','Juan R',41807,NULL,'2023-11-02 14:02:03','2023-11-07 12:44:10'),(2783,'2023-11-02 06:00:00','2023-11-02 15:44:17','190.103.31.245','12.249.250.150','closed',9,584,NULL,'attendances/2133/1698965057 clock_out.png','Juan R',41778,NULL,'2023-11-02 14:55:09','2023-11-07 12:43:07'),(2785,'2023-11-03 05:53:41','2023-11-03 15:51:00','12.249.250.150','12.249.250.150','closed',9,597,'attendances/1585/1699016021 clock_in.png','attendances/1585/1699051860 clock_out.png','Juan R',41853,NULL,'2023-11-03 09:53:41','2023-11-07 12:41:31'),(2786,'2023-11-03 05:55:10','2023-11-03 16:51:57','12.249.250.150','12.249.250.150','closed',10,656,'attendances/1551/1699016110 clock_in.png','attendances/1551/1699055517 clock_out.png','Juan R',41851,NULL,'2023-11-03 09:55:10','2023-11-07 12:41:19'),(2787,'2023-11-03 05:56:16','2023-11-03 15:53:15','12.249.250.150','12.249.250.150','closed',9,596,'attendances/2076/1699016176 clock_in.png','attendances/2076/1699051995 clock_out.png','Juan R',41857,NULL,'2023-11-03 09:56:16','2023-11-07 12:44:14'),(2788,'2023-11-03 05:56:40','2023-11-03 15:05:46','12.249.250.150','12.249.250.150','closed',9,549,'attendances/2218/1699016200 clock_in.png','attendances/2218/1699049146 clock_out.png','Juan R',41855,NULL,'2023-11-03 09:56:40','2023-11-07 12:42:38'),(2789,'2023-11-03 05:56:51','2023-11-03 14:57:56','12.249.250.150','12.249.250.150','closed',9,541,'attendances/2179/1699016211 clock_in.png','attendances/2179/1699048676 clock_out.png','Juan R',41859,NULL,'2023-11-03 09:56:51','2023-11-07 12:44:31'),(2790,'2023-11-03 05:57:12','2023-11-03 14:58:11','12.249.250.150','12.249.250.150','closed',9,540,'attendances/2178/1699016232 clock_in.png','attendances/2178/1699048691 clock_out.png','Juan R',41852,NULL,'2023-11-03 09:57:12','2023-11-07 12:41:27'),(2791,'2023-11-03 05:57:22','2023-11-03 16:30:39','12.249.250.150','12.249.250.150','closed',10,633,'attendances/1479/1699016242 clock_in.png','attendances/1479/1699054239 clock_out.png','Juan R',41854,NULL,'2023-11-03 09:57:22','2023-11-07 12:41:47'),(2792,'2023-11-03 05:57:47','2023-11-03 15:05:29','12.249.250.150','12.249.250.150','closed',9,547,'attendances/2080/1699016267 clock_in.png','attendances/2080/1699049129 clock_out.png','Juan R',41858,NULL,'2023-11-03 09:57:47','2023-11-07 12:44:17'),(2793,'2023-11-03 05:59:50','2023-11-03 16:52:03','12.249.250.150','12.249.250.150','closed',10,652,'attendances/1450/1699016390 clock_in.png','attendances/1450/1699055523 clock_out.png','Juan R',41856,NULL,'2023-11-03 09:59:50','2023-11-07 12:44:07'),(2794,'2023-11-03 06:05:19','2023-11-03 15:39:55','12.249.250.150','12.249.250.150','closed',9,574,'attendances/2150/1699016719 clock_in.png','attendances/2150/1699051195 clock_out.png','Juan R',41850,NULL,'2023-11-03 10:05:19','2023-11-07 12:41:22'),(2795,'2023-11-03 06:24:01','2023-11-03 15:35:50','12.249.250.150','12.249.250.150','closed',9,551,'attendances/1116/1699017841 clock_in.png','attendances/1116/1699050950 clock_out.png','Juan R',41860,NULL,'2023-11-03 10:24:01','2023-11-07 12:43:13'),(2796,'2023-11-03 06:25:17','2023-11-03 15:39:23','12.249.250.150','12.249.250.150','closed',9,554,'attendances/2151/1699017917 clock_in.png','attendances/2151/1699051163 clock_out.png','Juan R',41861,NULL,'2023-11-03 10:25:17','2023-11-07 12:43:19'),(2797,'2023-11-03 06:28:10','2023-11-03 16:05:15','12.249.250.150','12.249.250.150','closed',9,577,'attendances/1568/1699018090 clock_in.png','attendances/1568/1699052715 clock_out.png','Juan R',41863,NULL,'2023-11-03 10:28:10','2023-11-07 12:41:35'),(2798,'2023-11-03 06:32:15','2023-11-03 15:33:03','12.249.250.150','12.249.250.150','closed',9,540,'attendances/622/1699018335 clock_in.png','attendances/622/1699050783 clock_out.png','Juan R',41885,NULL,'2023-11-03 10:32:15','2023-11-07 12:44:21'),(2799,'2023-11-03 06:51:38','2023-11-03 16:06:27','12.249.250.150','12.249.250.150','closed',9,554,'attendances/2133/1699019498 clock_in.png','attendances/2133/1699052787 clock_out.png','Juan R',41878,NULL,'2023-11-03 10:51:38','2023-11-07 12:43:07'),(2800,'2023-11-03 06:52:02','2023-11-03 15:32:25','12.249.250.150','12.249.250.150','closed',8,520,'attendances/1774/1699019522 clock_in.png','attendances/1774/1699050745 clock_out.png','Juan R',41868,NULL,'2023-11-03 10:52:02','2023-11-07 12:42:17'),(2801,'2023-11-03 06:52:12','2023-11-03 15:39:04','12.249.250.150','12.249.250.150','closed',8,526,'attendances/2170/1699019532 clock_in.png','attendances/2170/1699051144 clock_out.png','Juan R',41881,NULL,'2023-11-03 10:52:12','2023-11-07 12:43:42'),(2802,'2023-11-03 06:52:27','2023-11-03 15:38:21','12.249.250.150','12.249.250.150','closed',8,525,'attendances/2190/1699019547 clock_in.png','attendances/2190/1699051101 clock_out.png','Juan R',41875,NULL,'2023-11-03 10:52:27','2023-11-07 12:42:46'),(2803,'2023-11-03 06:52:32','2023-11-03 15:39:06','12.249.250.150','12.249.250.150','closed',8,526,'attendances/2169/1699019552 clock_in.png','attendances/2169/1699051146 clock_out.png','Juan R',41865,NULL,'2023-11-03 10:52:32','2023-11-07 12:42:09'),(2804,'2023-11-03 06:52:59','2023-11-03 15:31:38','12.249.250.150','12.249.250.150','closed',8,518,'attendances/2168/1699019579 clock_in.png','attendances/2168/1699050698 clock_out.png','Juan R',41869,NULL,'2023-11-03 10:52:59','2023-11-07 12:42:20'),(2805,'2023-11-03 06:53:38','2023-11-03 16:07:01','12.249.250.150','12.249.250.150','closed',9,553,'attendances/2047/1699019618 clock_in.png','attendances/2047/1699052821 clock_out.png','Juan R',41871,NULL,'2023-11-03 10:53:38','2023-11-07 12:42:28'),(2806,'2023-11-03 06:55:10','2023-11-03 16:00:29','12.249.250.150','12.249.250.150','closed',9,545,'attendances/726/1699019710 clock_in.png','attendances/726/1699052429 clock_out.png','Juan R',41862,NULL,'2023-11-03 10:55:10','2023-11-07 12:41:15'),(2807,'2023-11-03 06:55:15','2023-11-03 15:32:47','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1934/1699019715 clock_in.png','attendances/1934/1699050767 clock_out.png','Juan R',41874,NULL,'2023-11-03 10:55:15','2023-11-07 12:42:41'),(2808,'2023-11-03 06:55:25','2023-11-03 16:06:07','12.249.250.150','12.249.250.150','closed',9,550,'attendances/2116/1699019725 clock_in.png','attendances/2116/1699052767 clock_out.png','Juan R',41864,NULL,'2023-11-03 10:55:25','2023-11-07 12:41:44'),(2809,'2023-11-03 06:56:53','2023-11-03 15:35:21','12.249.250.150','12.249.250.150','closed',8,518,'attendances/1958/1699019813 clock_in.png','attendances/1958/1699050921 clock_out.png','Juan R',41870,NULL,'2023-11-03 10:56:53','2023-11-07 12:42:25'),(2810,'2023-11-03 06:57:06','2023-11-03 17:10:59','12.249.250.150','12.249.250.150','closed',10,613,'attendances/2200/1699019826 clock_in.png','attendances/2200/1699056659 clock_out.png','Juan R',41867,NULL,'2023-11-03 10:57:06','2023-11-07 12:42:12'),(2811,'2023-11-03 06:57:30','2023-11-03 16:30:52','12.249.250.150','12.249.250.150','closed',9,573,'attendances/1395/1699019850 clock_in.png','attendances/1395/1699054252 clock_out.png','Juan R',41882,NULL,'2023-11-03 10:57:30','2023-11-07 12:43:24'),(2812,'2023-11-03 06:58:07','2023-11-03 15:43:23','12.249.250.150','12.249.250.150','closed',8,525,'attendances/1728/1699019887 clock_in.png','attendances/1728/1699051403 clock_out.png','Juan R',41876,NULL,'2023-11-03 10:58:07','2023-11-07 12:42:59'),(2813,'2023-11-03 06:58:35','2023-11-03 15:37:36','12.249.250.150','12.249.250.150','closed',8,519,'attendances/974/1699019915 clock_in.png','attendances/974/1699051056 clock_out.png','Juan R',41887,NULL,'2023-11-03 10:58:35','2023-11-07 12:40:48'),(2814,'2023-11-03 06:58:44','2023-11-03 15:32:03','12.249.250.150','12.249.250.150','closed',8,513,'attendances/1744/1699019924 clock_in.png','attendances/1744/1699050723 clock_out.png','Juan R',41880,NULL,'2023-11-03 10:58:44','2023-11-07 12:43:16'),(2816,'2023-11-03 07:01:09','2023-11-03 16:05:51','12.249.250.150','12.249.250.150','closed',9,544,'attendances/1951/1699020069 clock_in.png','attendances/1951/1699052751 clock_out.png','Juan R',41866,NULL,'2023-11-03 11:01:09','2023-11-07 12:41:57'),(2817,'2023-11-03 07:01:11','2023-11-03 15:42:49','12.249.250.150','12.249.250.150','closed',8,521,'attendances/1888/1699020071 clock_in.png','attendances/1888/1699051369 clock_out.png','Juan R',41886,NULL,'2023-11-03 11:01:11','2023-11-07 12:44:35'),(2818,'2023-11-03 07:03:52','2023-11-03 15:35:43','12.249.250.150','12.249.250.150','closed',8,511,'attendances/1858/1699020232 clock_in.png','attendances/1858/1699050943 clock_out.png','Juan R',41877,NULL,'2023-11-03 11:03:52','2023-11-07 12:43:04'),(2819,'2023-11-03 07:05:49','2023-11-03 15:40:07','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1948/1699020349 clock_in.png','attendances/1948/1699051207 clock_out.png','Juan R',41883,NULL,'2023-11-03 11:05:49','2023-11-07 12:44:02'),(2820,'2023-11-03 07:06:29','2023-11-03 15:38:03','12.249.250.150','12.249.250.150','closed',8,511,'attendances/1462/1699020389 clock_in.png','attendances/1462/1699051083 clock_out.png','Juan R',41873,NULL,'2023-11-03 11:06:29','2023-11-07 12:42:34'),(2822,'2023-11-03 07:57:44','2023-11-03 16:31:50','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1869/1699023464 clock_in.png','attendances/1869/1699054310 clock_out.png','Juan R',41888,NULL,'2023-11-03 11:57:44','2023-11-07 12:41:39'),(2823,'2023-11-03 07:59:30','2023-11-03 16:40:10','12.249.250.150','12.249.250.150','closed',8,520,'attendances/2152/1699023570 clock_in.png','attendances/2152/1699054810 clock_out.png','Juan R',41879,NULL,'2023-11-03 11:59:30','2023-11-07 12:44:27'),(2824,'2023-11-03 08:00:58','2023-11-03 16:38:00','12.249.250.150','186.154.240.36','closed',8,517,'attendances/1891/1699023658 clock_in.png',NULL,'Juan R',41890,NULL,'2023-11-03 12:00:58','2023-11-07 12:43:47'),(2825,'2023-11-03 08:27:12','2023-11-03 17:00:39','12.249.250.150','12.249.250.150','closed',8,513,'attendances/775/1699025232 clock_in.png','attendances/775/1699056039 clock_out.png','Juan R',41889,NULL,'2023-11-03 12:27:12','2023-11-07 12:43:38'),(2829,'2023-11-04 05:56:30','2023-11-04 14:42:44','12.249.250.150','12.249.250.150','closed',8,526,'attendances/1551/1699102590 clock_in.png','attendances/1551/1699134164 clock_out.png','Juan R',41936,NULL,'2023-11-04 09:56:30','2023-11-07 12:41:19'),(2830,'2023-11-04 05:56:41','2023-11-04 14:43:55','12.249.250.150','12.249.250.150','closed',8,527,'attendances/1568/1699102601 clock_in.png','attendances/1568/1699134235 clock_out.png','Juan R',41937,NULL,'2023-11-04 09:56:41','2023-11-07 12:41:35'),(2831,'2023-11-04 05:57:07','2023-11-04 15:01:54','12.249.250.150','12.249.250.150','closed',9,544,'attendances/2133/1699102627 clock_in.png','attendances/2133/1699135314 clock_out.png','Juan R',41939,NULL,'2023-11-04 09:57:07','2023-11-07 12:43:07'),(2832,'2023-11-04 05:57:20','2023-11-04 15:01:19','12.249.250.150','12.249.250.150','closed',9,543,'attendances/2047/1699102640 clock_in.png','attendances/2047/1699135279 clock_out.png','Juan R',41938,NULL,'2023-11-04 09:57:20','2023-11-07 12:42:28'),(2833,'2023-11-04 05:57:52','2023-11-04 15:01:40','12.249.250.150','12.249.250.150','closed',9,543,'attendances/2170/1699102672 clock_in.png','attendances/2170/1699135300 clock_out.png','Juan R',41941,NULL,'2023-11-04 09:57:52','2023-11-07 12:43:42'),(2835,'2023-11-04 05:58:45','2023-11-04 14:30:46','12.249.250.150','12.249.250.150','closed',8,512,'attendances/2151/1699102725 clock_in.png','attendances/2151/1699133446 clock_out.png','Juan R',41940,NULL,'2023-11-04 09:58:45','2023-11-07 12:43:19'),(2836,'2023-11-04 05:59:01','2023-11-04 14:39:35','12.249.250.150','12.249.250.150','closed',8,520,'attendances/1450/1699102741 clock_in.png','attendances/1450/1699133975 clock_out.png','Juan R',41942,NULL,'2023-11-04 09:59:01','2023-11-07 12:44:07'),(2837,'2023-11-04 06:55:43','2023-11-04 13:31:59','12.249.250.150','12.249.250.150','closed',6,396,'attendances/2178/1699106143 clock_in.png','attendances/2178/1699129919 clock_out.png','Juan R',41944,NULL,'2023-11-04 10:55:43','2023-11-07 12:41:27'),(2838,'2023-11-04 06:55:59','2023-11-04 13:32:15','12.249.250.150','12.249.250.150','closed',6,396,'attendances/2179/1699106159 clock_in.png','attendances/2179/1699129935 clock_out.png','Juan R',41945,NULL,'2023-11-04 10:55:59','2023-11-07 12:44:31'),(2839,'2023-11-04 07:56:34','2023-11-04 13:11:58','12.249.250.150','12.249.250.150','closed',5,315,'attendances/2152/1699109794 clock_in.png','attendances/2152/1699128718 clock_out.png','Juan R',41946,NULL,'2023-11-04 11:56:34','2023-11-07 12:44:27'),(2840,'2023-11-04 05:58:00','2023-11-04 13:32:56','179.19.206.180','12.249.250.150','closed',7,454,NULL,'attendances/2220/1699129976 clock_out.png','Juan R',41943,NULL,'2023-11-04 14:26:52','2023-11-07 12:44:24'),(2841,'2023-11-03 07:55:00','2023-11-03 16:42:00','38.51.234.67','179.19.206.180','closed',8,532,NULL,NULL,'Juan R',41884,NULL,'2023-11-04 14:40:41','2023-11-07 12:44:24'),(2842,'2023-11-04 10:01:00','2023-11-04 17:58:33','38.51.234.67','12.249.250.150','closed',7,477,NULL,'attendances/2169/1699145913 clock_out.png','Juan R',41947,NULL,'2023-11-04 16:31:08','2023-11-07 12:42:09'),(2843,'2023-11-05 07:00:41','2023-11-05 14:41:00','190.103.31.245','190.103.31.245','closed',7,460,'attendances/2179/1699197461 clock_in.png',NULL,'Juan R',42007,NULL,'2023-11-05 12:17:41','2023-11-07 12:44:31'),(2844,'2023-11-05 07:00:10','2023-11-05 14:41:00','190.103.31.245','190.103.31.245','closed',7,460,'attendances/2178/1699197490 clock_in.png',NULL,'Juan R',42005,NULL,'2023-11-05 12:18:10','2023-11-07 12:41:27'),(2845,'2023-11-05 07:00:54','2023-11-05 14:40:00','190.103.31.245','190.103.31.245','closed',7,459,'attendances/2152/1699197534 clock_in.png',NULL,'Juan R',42008,NULL,'2023-11-05 12:18:54','2023-11-07 12:44:27'),(2846,'2023-11-05 07:00:28','2023-11-05 14:40:00','190.103.31.245','190.103.31.245','closed',7,459,'attendances/2170/1699197568 clock_in.png',NULL,'Juan R',42006,NULL,'2023-11-05 12:19:28','2023-11-07 12:43:42'),(2847,'2023-11-06 05:25:10','2023-11-06 16:38:58','12.249.250.150','12.249.250.150','closed',11,673,'attendances/1585/1699277110 clock_in.png','attendances/1585/1699317538 clock_out.png','Juan R',42013,NULL,'2023-11-06 10:25:10','2023-11-14 17:10:18'),(2848,'2023-11-06 05:25:32','2023-11-06 16:39:30','12.249.250.150','12.249.250.150','closed',11,673,'attendances/1450/1699277132 clock_in.png','attendances/1450/1699317570 clock_out.png','Juan R',42015,NULL,'2023-11-06 10:25:32','2023-11-14 17:14:43'),(2849,'2023-11-06 05:25:57','2023-11-06 16:37:02','12.249.250.150','12.249.250.150','closed',11,671,'attendances/2116/1699277157 clock_in.png','attendances/2116/1699317422 clock_out.png','Juan R',42014,NULL,'2023-11-06 10:25:57','2023-11-14 17:10:44'),(2851,'2023-11-06 05:55:31','2023-11-06 14:32:16','12.249.250.150','12.249.250.150','closed',8,516,'attendances/726/1699278931 clock_in.png','attendances/726/1699309936 clock_out.png','Juan R',42016,NULL,'2023-11-06 10:55:31','2023-11-14 16:54:17'),(2852,'2023-11-06 05:55:48','2023-11-06 15:31:43','12.249.250.150','12.249.250.150','closed',9,575,'attendances/1568/1699278948 clock_in.png','attendances/1568/1699313503 clock_out.png','Juan R',42018,NULL,'2023-11-06 10:55:48','2023-11-14 17:10:29'),(2853,'2023-11-06 05:55:54','2023-11-06 18:10:01','12.249.250.150','12.249.250.150','closed',12,734,'attendances/1116/1699278954 clock_in.png','attendances/1116/1699323001 clock_out.png','Juan R',42020,NULL,'2023-11-06 10:55:54','2023-11-14 17:12:38'),(2854,'2023-11-06 05:55:59','2023-11-06 14:29:59','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1551/1699278959 clock_in.png','attendances/1551/1699309799 clock_out.png','Juan R',42017,NULL,'2023-11-06 10:55:59','2023-11-14 16:54:44'),(2855,'2023-11-06 05:56:22','2023-11-06 15:39:04','12.249.250.150','12.249.250.150','closed',9,582,'attendances/2151/1699278982 clock_in.png','attendances/2151/1699313944 clock_out.png','Juan R',42021,NULL,'2023-11-06 10:56:22','2023-11-14 17:13:19'),(2856,'2023-11-06 05:56:42','2023-11-06 15:32:30','12.249.250.150','12.249.250.150','closed',9,575,'attendances/2152/1699279002 clock_in.png','attendances/2152/1699313550 clock_out.png','Juan R',42024,NULL,'2023-11-06 10:56:42','2023-11-14 17:17:21'),(2857,'2023-11-06 05:57:15','2023-11-06 14:32:06','12.249.250.150','12.249.250.150','closed',8,514,'attendances/2076/1699279035 clock_in.png','attendances/2076/1699309926 clock_out.png','Juan R',42022,NULL,'2023-11-06 10:57:15','2023-11-14 17:14:50'),(2858,'2023-11-06 05:59:04','2023-11-06 14:31:32','12.249.250.150','12.249.250.150','closed',8,512,'attendances/1951/1699279144 clock_in.png','attendances/1951/1699309892 clock_out.png','Juan R',42019,NULL,'2023-11-06 10:59:04','2023-11-14 17:11:04'),(2859,'2023-11-06 06:30:46','2023-11-06 15:36:01','12.249.250.150','12.249.250.150','closed',9,545,'attendances/622/1699281046 clock_in.png','attendances/622/1699313761 clock_out.png','Juan R',42035,NULL,'2023-11-06 11:30:46','2023-11-14 17:17:19'),(2860,'2023-11-06 06:51:19','2023-11-06 15:30:42','12.249.250.150','12.249.250.150','closed',8,519,'attendances/1999/1699282279 clock_in.png','attendances/1999/1699313442 clock_out.png','Juan R',42028,NULL,'2023-11-06 11:51:19','2023-11-14 17:11:36'),(2861,'2023-11-06 06:53:26','2023-11-06 18:04:32','12.249.250.150','12.249.250.150','closed',11,671,'attendances/2133/1699282406 clock_in.png','attendances/2133/1699322672 clock_out.png','Juan R',42047,NULL,'2023-11-06 11:53:26','2023-11-14 17:12:26'),(2862,'2023-11-06 06:53:38','2023-11-06 15:36:12','12.249.250.150','12.249.250.150','closed',8,522,'attendances/1774/1699282418 clock_in.png','attendances/1774/1699313772 clock_out.png','Juan R',42026,NULL,'2023-11-06 11:53:38','2023-11-14 17:11:18'),(2863,'2023-11-06 06:53:43','2023-11-06 15:32:54','12.249.250.150','12.249.250.150','closed',8,519,'attendances/2170/1699282423 clock_in.png','attendances/2170/1699313574 clock_out.png','Juan R',42049,NULL,'2023-11-06 11:53:43','2023-11-14 17:13:59'),(2864,'2023-11-06 06:54:11','2023-11-06 15:58:44','12.249.250.150','12.249.250.150','closed',9,544,'attendances/2218/1699282451 clock_in.png','attendances/2218/1699315124 clock_out.png','Juan R',42044,NULL,'2023-11-06 11:54:11','2023-11-14 17:11:55'),(2865,'2023-11-06 06:54:50','2023-11-06 15:57:40','12.249.250.150','12.249.250.150','closed',9,542,'attendances/2179/1699282490 clock_in.png','attendances/2179/1699315060 clock_out.png','Juan R',42051,NULL,'2023-11-06 11:54:50','2023-11-14 17:17:26'),(2866,'2023-11-06 06:55:05','2023-11-06 15:57:23','12.249.250.150','12.249.250.150','closed',9,542,'attendances/2178/1699282505 clock_in.png','attendances/2178/1699315043 clock_out.png','Juan R',42039,NULL,'2023-11-06 11:55:05','2023-11-14 17:10:12'),(2867,'2023-11-06 06:55:08','2023-11-06 18:06:16','12.249.250.150','12.249.250.150','closed',11,671,'attendances/1479/1699282508 clock_in.png','attendances/1479/1699322776 clock_out.png','Juan R',42025,NULL,'2023-11-06 11:55:08','2023-11-14 17:10:47'),(2868,'2023-11-06 06:55:10','2023-11-06 15:36:10','12.249.250.150','12.249.250.150','closed',8,521,'attendances/1934/1699282510 clock_in.png','attendances/1934/1699313770 clock_out.png','Juan R',42029,NULL,'2023-11-06 11:55:10','2023-11-14 17:12:01'),(2869,'2023-11-06 06:55:21','2023-11-06 17:08:25','12.249.250.150','12.249.250.150','closed',10,613,'attendances/2190/1699282521 clock_in.png','attendances/2190/1699319305 clock_out.png','Juan R',42046,NULL,'2023-11-06 11:55:21','2023-11-14 17:12:05'),(2870,'2023-11-06 06:55:29','2023-11-06 15:32:32','12.249.250.150','12.249.250.150','closed',8,517,'attendances/2168/1699282529 clock_in.png','attendances/2168/1699313552 clock_out.png','Juan R',42042,NULL,'2023-11-06 11:55:29','2023-11-14 17:11:21'),(2871,'2023-11-06 06:55:34','2023-11-06 16:15:24','12.249.250.150','12.249.250.150','closed',9,559,'attendances/2200/1699282534 clock_in.png','attendances/2200/1699316124 clock_out.png','Juan R',42041,NULL,'2023-11-06 11:55:34','2023-11-14 17:11:12'),(2872,'2023-11-06 06:55:47','2023-11-06 16:41:33','12.249.250.150','12.249.250.150','closed',9,585,'attendances/2047/1699282547 clock_in.png','attendances/2047/1699317693 clock_out.png','Juan R',42043,NULL,'2023-11-06 11:55:48','2023-11-14 17:11:26'),(2873,'2023-11-06 06:55:55','2023-11-06 16:15:14','12.249.250.150','12.249.250.150','closed',9,559,'attendances/2150/1699282555 clock_in.png','attendances/2150/1699316114 clock_out.png','Juan R',42038,NULL,'2023-11-06 11:55:55','2023-11-14 17:10:09'),(2874,'2023-11-06 06:56:02','2023-11-06 16:09:49','12.249.250.150','12.249.250.150','closed',9,553,'attendances/2061/1699282562 clock_in.png','attendances/2061/1699315789 clock_out.png','Juan R',42045,NULL,'2023-11-06 11:56:02','2023-11-14 17:11:57'),(2875,'2023-11-06 06:56:18','2023-11-06 15:32:11','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1744/1699282578 clock_in.png','attendances/1744/1699313531 clock_out.png','Juan R',42048,NULL,'2023-11-06 11:56:18','2023-11-14 17:12:53'),(2876,'2023-11-06 06:56:29','2023-11-06 16:38:50','12.249.250.150','12.249.250.150','closed',9,582,'attendances/2169/1699282589 clock_in.png','attendances/2169/1699317530 clock_out.png','Juan R',42040,NULL,'2023-11-06 11:56:29','2023-11-14 17:11:09'),(2877,'2023-11-06 06:56:57','2023-11-06 15:30:11','12.249.250.150','12.249.250.150','closed',8,513,'attendances/2005/1699282617 clock_in.png','attendances/2005/1699313411 clock_out.png','Juan R',42032,NULL,'2023-11-06 11:56:57','2023-11-14 17:12:35'),(2878,'2023-11-06 06:57:12','2023-11-06 15:30:57','12.249.250.150','12.249.250.150','closed',8,513,'attendances/1395/1699282632 clock_in.png','attendances/1395/1699313457 clock_out.png','Juan R',42033,NULL,'2023-11-06 11:57:12','2023-11-14 17:13:45'),(2879,'2023-11-06 06:57:29','2023-11-06 15:34:02','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1958/1699282649 clock_in.png','attendances/1958/1699313642 clock_out.png','Juan R',42027,NULL,'2023-11-06 11:57:29','2023-11-14 17:11:23'),(2880,'2023-11-06 06:57:31','2023-11-06 15:32:06','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1728/1699282651 clock_in.png','attendances/1728/1699313526 clock_out.png','Juan R',42030,NULL,'2023-11-06 11:57:31','2023-11-14 17:12:11'),(2881,'2023-11-06 06:57:41','2023-11-06 15:34:18','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1858/1699282661 clock_in.png','attendances/1858/1699313658 clock_out.png','Juan R',42031,NULL,'2023-11-06 11:57:41','2023-11-14 17:12:22'),(2882,'2023-11-06 06:58:16','2023-11-06 16:41:08','12.249.250.150','12.249.250.150','closed',9,582,'attendances/974/1699282696 clock_in.png','attendances/974/1699317668 clock_out.png','Juan R',42065,NULL,'2023-11-06 11:58:16','2023-11-14 16:53:57'),(2883,'2023-11-06 07:02:32','2023-11-06 16:39:14','12.249.250.150','12.249.250.150','closed',9,576,'attendances/2192/1699282952 clock_in.png','attendances/2192/1699317554 clock_out.png','Juan R',42050,NULL,'2023-11-06 12:02:32','2023-11-14 17:14:47'),(2884,'2023-11-06 07:02:48','2023-11-06 15:33:04','12.249.250.150','12.249.250.150','closed',8,510,'attendances/1888/1699282968 clock_in.png','attendances/1888/1699313584 clock_out.png','Juan R',42036,NULL,'2023-11-06 12:02:48','2023-11-14 17:17:40'),(2885,'2023-11-06 07:05:19','2023-11-06 15:40:02','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1948/1699283119 clock_in.png','attendances/1948/1699314002 clock_out.png','Juan R',42034,NULL,'2023-11-06 12:05:19','2023-11-14 17:14:41'),(2886,'2023-11-06 07:49:46','2023-11-06 15:35:49','12.249.250.150','12.249.250.150','closed',7,466,'attendances/1462/1699285786 clock_in.png','attendances/1462/1699313749 clock_out.png','Juan R',42010,NULL,'2023-11-06 12:49:46','2023-11-14 17:11:40'),(2887,'2023-11-06 07:57:55','2023-11-06 16:30:00','12.249.250.150','38.51.234.67','closed',8,512,'attendances/1869/1699286275 clock_in.png',NULL,'Juan R',42009,NULL,'2023-11-06 12:57:55','2023-11-14 17:10:39'),(2888,'2023-11-06 07:59:10','2023-11-06 16:30:22','12.249.250.150','12.249.250.150','closed',8,511,'attendances/775/1699286350 clock_in.png','attendances/775/1699317022 clock_out.png','Juan R',42011,NULL,'2023-11-06 12:59:10','2023-11-14 17:13:48'),(2889,'2023-11-06 08:01:02','2023-11-06 16:33:44','12.249.250.150','12.249.250.150','closed',8,512,'attendances/1891/1699286462 clock_in.png','attendances/1891/1699317224 clock_out.png','Juan R',42012,NULL,'2023-11-06 13:01:02','2023-11-14 17:14:37'),(2890,'2023-11-07 05:53:41','2023-11-07 16:29:40','12.249.250.150','12.249.250.150','closed',10,635,'attendances/1116/1699365221 clock_in.png','attendances/1116/1699403380 clock_out.png','Juan R',42093,NULL,'2023-11-07 10:53:41','2023-11-14 17:12:38'),(2891,'2023-11-07 05:55:10','2023-11-07 15:38:00','12.249.250.150','190.103.31.245','closed',9,582,'attendances/622/1699365310 clock_in.png',NULL,'Juan R',42122,NULL,'2023-11-07 10:55:10','2023-11-14 17:17:19'),(2892,'2023-11-07 05:55:28','2023-11-07 20:04:34','12.249.250.150','12.249.250.150','closed',14,849,'attendances/1585/1699365328 clock_in.png','attendances/1585/1699416274 clock_out.png','Juan R',42090,NULL,'2023-11-07 10:55:28','2023-11-14 17:10:18'),(2893,'2023-11-07 05:55:29','2023-11-07 15:31:19','12.249.250.150','12.249.250.150','closed',9,575,'attendances/1934/1699365329 clock_in.png','attendances/1934/1699399879 clock_out.png','Juan R',42112,NULL,'2023-11-07 10:55:29','2023-11-14 17:12:01'),(2894,'2023-11-07 05:56:10','2023-11-07 14:30:50','12.249.250.150','12.249.250.150','closed',8,514,'attendances/726/1699365370 clock_in.png','attendances/726/1699396250 clock_out.png','Juan R',42088,NULL,'2023-11-07 10:56:10','2023-11-14 16:54:17'),(2895,'2023-11-07 05:56:16','2023-11-07 15:32:55','12.249.250.150','12.249.250.150','closed',9,576,'attendances/1774/1699365376 clock_in.png','attendances/1774/1699399975 clock_out.png','Juan R',42104,NULL,'2023-11-07 10:56:16','2023-11-14 17:11:18'),(2896,'2023-11-07 05:57:24','2023-11-07 14:32:30','12.249.250.150','12.249.250.150','closed',8,515,'attendances/2170/1699365444 clock_in.png','attendances/2170/1699396350 clock_out.png','Juan R',42094,NULL,'2023-11-07 10:57:24','2023-11-14 17:13:59'),(2897,'2023-11-07 05:57:38','2023-11-07 14:27:45','12.249.250.150','12.249.250.150','closed',8,510,'attendances/1551/1699365458 clock_in.png','attendances/1551/1699396065 clock_out.png','Juan R',42089,NULL,'2023-11-07 10:57:38','2023-11-14 16:54:44'),(2898,'2023-11-07 05:57:53','2023-11-07 14:32:09','12.249.250.150','12.249.250.150','closed',8,514,'attendances/2190/1699365473 clock_in.png','attendances/2190/1699396329 clock_out.png','Juan R',42092,NULL,'2023-11-07 10:57:53','2023-11-14 17:12:05'),(2899,'2023-11-07 05:59:02','2023-11-07 20:06:11','12.249.250.150','12.249.250.150','closed',14,847,'attendances/1450/1699365542 clock_in.png','attendances/1450/1699416371 clock_out.png','Juan R',42095,NULL,'2023-11-07 10:59:02','2023-11-14 17:14:43'),(2900,'2023-11-07 06:49:12','2023-11-07 15:33:06','12.249.250.150','12.249.250.150','closed',8,523,'attendances/1999/1699368552 clock_in.png','attendances/1999/1699399986 clock_out.png','Juan R',42108,NULL,'2023-11-07 11:49:12','2023-11-14 17:11:36'),(2901,'2023-11-07 06:51:18','2023-11-07 16:52:24','12.249.250.150','12.249.250.150','closed',10,601,'attendances/2179/1699368678 clock_in.png','attendances/2179/1699404744 clock_out.png','Juan R',42123,NULL,'2023-11-07 11:51:18','2023-11-14 17:17:26'),(2902,'2023-11-07 06:51:37','2023-11-07 16:52:36','12.249.250.150','12.249.250.150','closed',10,600,'attendances/2178/1699368697 clock_in.png','attendances/2178/1699404756 clock_out.png','Juan R',42098,NULL,'2023-11-07 11:51:37','2023-11-14 17:10:12'),(2903,'2023-11-07 06:51:57','2023-11-07 16:27:32','12.249.250.150','12.249.250.150','closed',9,575,'attendances/2005/1699368717 clock_in.png','attendances/2005/1699403252 clock_out.png','Juan R',42116,NULL,'2023-11-07 11:51:57','2023-11-14 17:12:35'),(2904,'2023-11-07 06:53:03','2023-11-07 15:31:52','12.249.250.150','12.249.250.150','closed',8,518,'attendances/2116/1699368783 clock_in.png','attendances/2116/1699399912 clock_out.png','Juan R',42091,NULL,'2023-11-07 11:53:03','2023-11-14 17:10:44'),(2905,'2023-11-07 06:53:32','2023-11-07 15:33:58','12.249.250.150','12.249.250.150','closed',8,520,'attendances/1728/1699368812 clock_in.png','attendances/1728/1699400038 clock_out.png','Juan R',42113,NULL,'2023-11-07 11:53:32','2023-11-14 17:12:11'),(2906,'2023-11-07 06:53:59','2023-11-07 17:08:05','12.249.250.150','12.249.250.150','closed',10,614,'attendances/2218/1699368839 clock_in.png','attendances/2218/1699405685 clock_out.png','Juan R',42110,NULL,'2023-11-07 11:53:59','2023-11-14 17:11:55'),(2907,'2023-11-07 06:55:00','2023-11-07 15:35:27','12.249.250.150','12.249.250.150','closed',8,520,'attendances/2047/1699368900 clock_in.png','attendances/2047/1699400127 clock_out.png','Juan R',42107,NULL,'2023-11-07 11:55:00','2023-11-14 17:11:26'),(2908,'2023-11-07 06:55:06','2023-11-07 15:50:42','12.249.250.150','12.249.250.150','closed',8,535,'attendances/2169/1699368906 clock_in.png','attendances/2169/1699401042 clock_out.png','Juan R',42101,NULL,'2023-11-07 11:55:07','2023-11-14 17:11:09'),(2909,'2023-11-07 06:55:15','2023-11-07 15:33:50','12.249.250.150','12.249.250.150','closed',8,518,'attendances/2061/1699368915 clock_in.png','attendances/2061/1699400030 clock_out.png','Juan R',42111,NULL,'2023-11-07 11:55:15','2023-11-14 17:11:57'),(2910,'2023-11-07 06:55:20','2023-11-07 15:34:12','12.249.250.150','12.249.250.150','closed',8,518,'attendances/2200/1699368920 clock_in.png','attendances/2200/1699400052 clock_out.png','Juan R',42103,NULL,'2023-11-07 11:55:20','2023-11-14 17:11:12'),(2911,'2023-11-07 06:55:36','2023-11-07 15:30:18','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1568/1699368936 clock_in.png','attendances/1568/1699399818 clock_out.png','Juan R',42099,NULL,'2023-11-07 11:55:36','2023-11-14 17:10:29'),(2912,'2023-11-07 06:55:41','2023-11-07 17:07:50','12.249.250.150','12.249.250.150','closed',10,612,'attendances/2222/1699368941 clock_in.png','attendances/2222/1699405670 clock_out.png','Juan R',42121,NULL,'2023-11-07 11:55:41','2023-11-14 17:15:02'),(2913,'2023-11-07 06:56:11','2023-11-07 15:32:56','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1479/1699368971 clock_in.png','attendances/1479/1699399976 clock_out.png','Juan R',42100,NULL,'2023-11-07 11:56:11','2023-11-14 17:10:47'),(2914,'2023-11-07 06:56:37','2023-11-07 15:32:42','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1395/1699368997 clock_in.png','attendances/1395/1699399962 clock_out.png','Juan R',42118,NULL,'2023-11-07 11:56:37','2023-11-14 17:13:45'),(2915,'2023-11-07 06:56:40','2023-11-07 15:30:47','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1858/1699369000 clock_in.png','attendances/1858/1699399847 clock_out.png','Juan R',42114,NULL,'2023-11-07 11:56:41','2023-11-14 17:12:22'),(2916,'2023-11-07 06:56:41','2023-11-07 15:33:21','12.249.250.150','12.249.250.150','closed',8,516,'attendances/2150/1699369001 clock_in.png','attendances/2150/1699400001 clock_out.png','Juan R',42097,NULL,'2023-11-07 11:56:41','2023-11-14 17:10:09'),(2917,'2023-11-07 06:57:14','2023-11-07 15:30:57','12.249.250.150','12.249.250.150','closed',8,513,'attendances/1958/1699369034 clock_in.png','attendances/1958/1699399857 clock_out.png','Juan R',42106,NULL,'2023-11-07 11:57:14','2023-11-14 17:11:23'),(2918,'2023-11-07 06:58:03','2023-11-07 15:33:31','12.249.250.150','12.249.250.150','closed',8,515,'attendances/2168/1699369083 clock_in.png','attendances/2168/1699400011 clock_out.png','Juan R',42105,NULL,'2023-11-07 11:58:03','2023-11-14 17:11:21'),(2919,'2023-11-07 06:58:34','2023-11-07 15:35:01','12.249.250.150','12.249.250.150','closed',8,516,'attendances/974/1699369114 clock_in.png','attendances/974/1699400101 clock_out.png','Juan R',42096,NULL,'2023-11-07 11:58:34','2023-11-14 16:53:57'),(2920,'2023-11-07 06:58:54','2023-11-07 16:28:03','12.249.250.150','12.249.250.150','closed',9,569,'attendances/1951/1699369134 clock_in.png','attendances/1951/1699403283 clock_out.png','Juan R',42102,NULL,'2023-11-07 11:58:54','2023-11-14 17:11:04'),(2921,'2023-11-07 06:59:10','2023-11-07 15:33:06','12.249.250.150','12.249.250.150','closed',8,513,'attendances/1744/1699369150 clock_in.png','attendances/1744/1699399986 clock_out.png','Juan R',42117,NULL,'2023-11-07 11:59:10','2023-11-14 17:12:53'),(2922,'2023-11-07 07:00:18','2023-11-07 17:08:44','12.249.250.150','12.249.250.150','closed',10,608,'attendances/2076/1699369218 clock_in.png','attendances/2076/1699405724 clock_out.png','Juan R',42120,NULL,'2023-11-07 12:00:18','2023-11-14 17:14:50'),(2923,'2023-11-07 07:03:07','2023-11-07 15:37:25','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1462/1699369387 clock_in.png','attendances/1462/1699400245 clock_out.png','Juan R',42109,NULL,'2023-11-07 12:03:07','2023-11-14 17:11:40'),(2924,'2023-11-07 07:03:23','2023-11-07 15:42:57','12.249.250.150','12.249.250.150','closed',8,519,'attendances/1948/1699369403 clock_in.png','attendances/1948/1699400577 clock_out.png','Juan R',42119,NULL,'2023-11-07 12:03:23','2023-11-14 17:14:41'),(2925,'2023-11-07 07:03:38','2023-11-07 15:42:39','12.249.250.150','12.249.250.150','closed',8,519,'attendances/1888/1699369418 clock_in.png','attendances/1888/1699400559 clock_out.png','Juan R',42124,NULL,'2023-11-07 12:03:38','2023-11-14 17:17:40'),(2926,'2023-11-07 07:06:31','2023-11-07 15:33:19','12.249.250.150','12.249.250.150','closed',8,506,'attendances/2133/1699369591 clock_in.png','attendances/2133/1699399999 clock_out.png','Juan R',42115,NULL,'2023-11-07 12:06:31','2023-11-14 17:12:26'),(2927,'2023-11-07 08:02:01','2023-11-07 16:30:17','12.249.250.150','12.249.250.150','closed',8,508,'attendances/775/1699372921 clock_in.png','attendances/775/1699403417 clock_out.png','Juan R',42126,NULL,'2023-11-07 13:02:01','2023-11-14 17:13:48'),(2928,'2023-11-07 08:02:11','2023-11-07 16:31:25','12.249.250.150','12.249.250.150','closed',8,509,'attendances/1869/1699372931 clock_in.png','attendances/1869/1699403485 clock_out.png','Juan R',42125,NULL,'2023-11-07 13:02:11','2023-11-14 17:10:39'),(2929,'2023-11-07 08:02:43','2023-11-07 16:32:05','12.249.250.150','12.249.250.150','closed',8,509,'attendances/1891/1699372963 clock_in.png','attendances/1891/1699403525 clock_out.png','Juan R',42127,NULL,'2023-11-07 13:02:43','2023-11-14 17:14:37'),(2931,'2023-11-08 04:31:05','2023-11-08 21:49:49','12.249.250.150','12.249.250.150','closed',17,1038,'attendances/1951/1699446665 clock_in.png','attendances/1951/1699508989 clock_out.png','Juan R',42145,NULL,'2023-11-08 09:31:05','2023-11-14 17:11:04'),(2932,'2023-11-08 04:31:24','2023-11-08 21:47:48','12.249.250.150','12.249.250.150','closed',17,1036,'attendances/2133/1699446684 clock_in.png','attendances/2133/1699508868 clock_out.png','Juan R',42146,NULL,'2023-11-08 09:31:24','2023-11-14 17:12:26'),(2933,'2023-11-08 04:31:42','2023-11-08 21:48:25','12.249.250.150','12.249.250.150','closed',17,1036,'attendances/2222/1699446702 clock_in.png','attendances/2222/1699508905 clock_out.png','Juan R',42148,NULL,'2023-11-08 09:31:42','2023-11-14 17:15:02'),(2934,'2023-11-08 04:31:53','2023-11-08 21:48:36','12.249.250.150','12.249.250.150','closed',17,1036,'attendances/1585/1699446713 clock_in.png','attendances/1585/1699508916 clock_out.png','Juan R',42144,NULL,'2023-11-08 09:31:54','2023-11-14 17:10:18'),(2935,'2023-11-08 04:33:41','2023-11-08 21:49:34','12.249.250.150','12.249.250.150','closed',17,1035,'attendances/1450/1699446821 clock_in.png','attendances/1450/1699508974 clock_out.png','Juan R',42147,NULL,'2023-11-08 09:33:41','2023-11-14 17:14:43'),(2936,'2023-11-08 05:53:47','2023-11-08 15:35:45','12.249.250.150','12.249.250.150','closed',9,581,'attendances/622/1699451627 clock_in.png','attendances/622/1699486545 clock_out.png','Juan R',42167,NULL,'2023-11-08 10:53:47','2023-11-14 17:17:19'),(2937,'2023-11-08 05:54:01','2023-11-08 15:30:57','12.249.250.150','12.249.250.150','closed',9,576,'attendances/1934/1699451641 clock_in.png','attendances/1934/1699486257 clock_out.png','Juan R',42160,NULL,'2023-11-08 10:54:01','2023-11-14 17:12:01'),(2938,'2023-11-08 05:57:35','2023-11-08 18:52:19','12.249.250.150','12.249.250.150','closed',12,774,'attendances/2170/1699451855 clock_in.png','attendances/2170/1699498339 clock_out.png','Juan R',42151,NULL,'2023-11-08 10:57:35','2023-11-14 17:13:59'),(2939,'2023-11-08 06:48:06','2023-11-08 15:30:47','12.249.250.150','12.249.250.150','closed',8,522,'attendances/2116/1699454886 clock_in.png','attendances/2116/1699486247 clock_out.png','Juan R',42149,NULL,'2023-11-08 11:48:06','2023-11-14 17:10:44'),(2940,'2023-11-08 06:50:22','2023-11-08 16:56:00','12.249.250.150','12.249.250.150','closed',10,605,'attendances/1999/1699455022 clock_in.png','attendances/1999/1699491360 clock_out.png','Juan R',42158,NULL,'2023-11-08 11:50:22','2023-11-14 17:11:36'),(2941,'2023-11-08 06:51:09','2023-11-08 15:31:47','12.249.250.150','12.249.250.150','closed',8,520,'attendances/2152/1699455069 clock_in.png','attendances/2152/1699486307 clock_out.png','Juan R',42177,NULL,'2023-11-08 11:51:09','2023-11-14 17:17:21'),(2942,'2023-11-08 06:52:35','2023-11-08 18:51:42','12.249.250.150','12.249.250.150','closed',11,719,'attendances/1551/1699455155 clock_in.png','attendances/1551/1699498302 clock_out.png','Juan R',42154,NULL,'2023-11-08 11:52:35','2023-11-14 16:54:44'),(2943,'2023-11-08 06:53:03','2023-11-08 18:51:30','12.249.250.150','12.249.250.150','closed',11,718,'attendances/2005/1699455183 clock_in.png','attendances/2005/1699498290 clock_out.png','Juan R',42163,NULL,'2023-11-08 11:53:04','2023-11-14 17:12:35'),(2944,'2023-11-08 06:53:06','2023-11-08 17:04:10','12.249.250.150','12.249.250.150','closed',10,611,'attendances/1116/1699455186 clock_in.png','attendances/1116/1699491850 clock_out.png','Juan R',42164,NULL,'2023-11-08 11:53:06','2023-11-14 17:12:38'),(2945,'2023-11-08 06:53:31','2023-11-08 18:44:41','12.249.250.150','12.249.250.150','closed',11,711,'attendances/726/1699455211 clock_in.png','attendances/726/1699497881 clock_out.png','Juan R',42153,NULL,'2023-11-08 11:53:31','2023-11-14 16:54:17'),(2946,'2023-11-08 06:54:35','2023-11-08 18:46:23','12.249.250.150','12.249.250.150','closed',11,711,'attendances/2178/1699455275 clock_in.png','attendances/2178/1699497983 clock_out.png','Juan R',42169,NULL,'2023-11-08 11:54:35','2023-11-14 17:10:12'),(2947,'2023-11-08 06:54:39','2023-11-08 16:09:25','12.249.250.150','12.249.250.150','closed',9,554,'attendances/1728/1699455279 clock_in.png','attendances/1728/1699488565 clock_out.png','Juan R',42161,NULL,'2023-11-08 11:54:39','2023-11-14 17:12:11'),(2948,'2023-11-08 06:54:52','2023-11-08 18:46:36','12.249.250.150','12.249.250.150','closed',11,711,'attendances/2179/1699455292 clock_in.png','attendances/2179/1699497996 clock_out.png','Juan R',42178,NULL,'2023-11-08 11:54:52','2023-11-14 17:17:26'),(2949,'2023-11-08 06:55:09','2023-11-08 15:31:10','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1774/1699455309 clock_in.png','attendances/1774/1699486270 clock_out.png','Juan R',42156,NULL,'2023-11-08 11:55:09','2023-11-14 17:11:18'),(2950,'2023-11-08 06:55:10','2023-11-08 16:56:49','12.249.250.150','12.249.250.150','closed',10,601,'attendances/974/1699455310 clock_in.png','attendances/974/1699491409 clock_out.png','Juan R',42152,NULL,'2023-11-08 11:55:10','2023-11-14 16:53:57'),(2951,'2023-11-08 06:55:37','2023-11-08 18:49:32','12.249.250.150','12.249.250.150','closed',11,713,'attendances/2076/1699455337 clock_in.png','attendances/2076/1699498172 clock_out.png','Juan R',42176,NULL,'2023-11-08 11:55:37','2023-11-14 17:14:50'),(2952,'2023-11-08 06:56:33','2023-11-08 15:31:31','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1568/1699455393 clock_in.png','attendances/1568/1699486291 clock_out.png','Juan R',42155,NULL,'2023-11-08 11:56:33','2023-11-14 17:10:29'),(2953,'2023-11-08 06:56:43','2023-11-08 15:32:52','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1958/1699455403 clock_in.png','attendances/1958/1699486372 clock_out.png','Juan R',42157,NULL,'2023-11-08 11:56:43','2023-11-14 17:11:23'),(2954,'2023-11-08 06:57:54','2023-11-08 17:03:05','12.249.250.150','190.103.31.245','closed',10,605,'attendances/1395/1699455474 clock_in.png','attendances/1395/1699470125 clock_out.png','Juan R',42165,NULL,'2023-11-08 11:57:54','2023-11-14 17:13:45'),(2955,'2023-11-08 06:58:13','2023-11-08 18:49:12','12.249.250.150','12.249.250.150','closed',11,710,'attendances/2218/1699455493 clock_in.png','attendances/2218/1699498152 clock_out.png','Juan R',42173,NULL,'2023-11-08 11:58:13','2023-11-14 17:11:55'),(2956,'2023-11-08 07:00:16','2023-11-08 15:32:34','12.249.250.150','12.249.250.150','closed',8,512,'attendances/1744/1699455616 clock_in.png','attendances/1744/1699486354 clock_out.png','Juan R',42174,NULL,'2023-11-08 12:00:16','2023-11-14 17:12:53'),(2957,'2023-11-08 07:01:11','2023-11-08 15:32:00','12.249.250.150','12.249.250.150','closed',8,510,'attendances/2192/1699455671 clock_in.png','attendances/2192/1699486320 clock_out.png','Juan R',42175,NULL,'2023-11-08 12:01:11','2023-11-14 17:14:47'),(2958,'2023-11-08 07:02:11','2023-11-08 17:05:02','12.249.250.150','12.249.250.150','closed',10,602,'attendances/2200/1699455731 clock_in.png','attendances/2200/1699491902 clock_out.png','Juan R',42171,NULL,'2023-11-08 12:02:11','2023-11-14 17:11:12'),(2959,'2023-11-08 07:04:24','2023-11-08 15:37:42','12.249.250.150','12.249.250.150','closed',8,513,'attendances/1462/1699455864 clock_in.png','attendances/1462/1699486662 clock_out.png','Juan R',42159,NULL,'2023-11-08 12:04:24','2023-11-14 17:11:40'),(2960,'2023-11-08 07:04:50','2023-11-08 15:42:06','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1948/1699455890 clock_in.png','attendances/1948/1699486926 clock_out.png','Juan R',42166,NULL,'2023-11-08 12:04:50','2023-11-14 17:14:41'),(2961,'2023-11-08 07:11:17','2023-11-08 15:32:24','12.249.250.150','12.249.250.150','closed',8,501,'attendances/2168/1699456277 clock_in.png','attendances/2168/1699486344 clock_out.png','Juan R',42172,NULL,'2023-11-08 12:11:17','2023-11-14 17:11:21'),(2962,'2023-11-08 07:11:25','2023-11-08 18:53:01','12.249.250.150','12.249.250.150','closed',11,701,'attendances/2169/1699456285 clock_in.png','attendances/2169/1699498381 clock_out.png','Juan R',42170,NULL,'2023-11-08 12:11:25','2023-11-14 17:11:09'),(2963,'2023-11-08 07:11:35','2023-11-08 15:39:31','12.249.250.150','12.249.250.150','closed',8,507,'attendances/1888/1699456295 clock_in.png','attendances/1888/1699486771 clock_out.png','Juan R',42168,NULL,'2023-11-08 12:11:35','2023-11-14 17:17:40'),(2964,'2023-11-08 07:15:37','2023-11-08 15:34:43','12.249.250.150','12.249.250.150','closed',8,499,'attendances/1858/1699456537 clock_in.png','attendances/1858/1699486483 clock_out.png','Juan R',42162,NULL,'2023-11-08 12:15:37','2023-11-14 17:12:22'),(2965,'2023-11-08 08:00:44','2023-11-08 17:00:42','12.249.250.150','12.249.250.150','closed',8,539,'attendances/2151/1699459244 clock_in.png','attendances/2151/1699491642 clock_out.png','Juan R',42139,NULL,'2023-11-08 13:00:44','2023-11-14 17:13:19'),(2966,'2023-11-08 08:02:54','2023-11-08 16:31:38','12.249.250.150','12.249.250.150','closed',8,508,'attendances/775/1699459374 clock_in.png','attendances/775/1699489898 clock_out.png','Juan R',42140,NULL,'2023-11-08 13:02:54','2023-11-14 17:13:48'),(2967,'2023-11-08 08:02:56','2023-11-08 16:34:32','12.249.250.150','12.249.250.150','closed',8,511,'attendances/1891/1699459376 clock_in.png','attendances/1891/1699490072 clock_out.png','Juan R',42141,NULL,'2023-11-08 13:02:56','2023-11-14 17:14:37'),(2968,'2023-11-08 08:03:30','2023-11-08 16:33:39','12.249.250.150','12.249.250.150','closed',8,510,'attendances/1869/1699459410 clock_in.png','attendances/1869/1699490019 clock_out.png','Juan R',42138,NULL,'2023-11-08 13:03:30','2023-11-14 17:10:39'),(2969,'2023-11-08 08:56:43','2023-11-08 18:52:26','12.249.250.150','12.249.250.150','closed',9,595,'attendances/2047/1699462603 clock_in.png','attendances/2047/1699498346 clock_out.png','Juan R',42142,NULL,'2023-11-08 13:56:43','2023-11-14 17:11:26'),(2970,'2023-11-08 08:57:00','2023-11-08 18:53:24','179.19.80.106','12.249.250.150','closed',9,596,NULL,'attendances/2061/1699498404 clock_out.png','Juan R',42143,NULL,'2023-11-08 17:06:11','2023-11-14 17:11:57'),(2971,'2023-11-09 04:30:21','2023-11-09 14:29:31','12.249.250.150','12.249.250.150','closed',9,599,'attendances/1116/1699533021 clock_in.png','attendances/1116/1699568971 clock_out.png','Juan R',42193,NULL,'2023-11-09 09:30:21','2023-11-14 17:12:38'),(2972,'2023-11-09 04:38:08','2023-11-09 14:30:21','12.249.250.150','12.249.250.150','closed',9,592,'attendances/2169/1699533488 clock_in.png','attendances/2169/1699569021 clock_out.png','Juan R',42192,NULL,'2023-11-09 09:38:08','2023-11-14 17:11:09'),(2973,'2023-11-09 04:38:48','2023-11-09 14:29:08','12.249.250.150','12.249.250.150','closed',9,590,'attendances/2222/1699533528 clock_in.png','attendances/2222/1699568948 clock_out.png','Juan R',42194,NULL,'2023-11-09 09:38:48','2023-11-14 17:15:02'),(2974,'2023-11-09 05:59:10','2023-11-09 14:30:00','12.249.250.150','179.19.109.15','closed',8,510,'attendances/775/1699538350 clock_in.png',NULL,'Juan R',42227,NULL,'2023-11-09 10:59:10','2023-11-14 17:13:48'),(2975,'2023-11-09 06:25:10','2023-11-09 15:42:59','12.249.250.150','12.249.250.150','closed',9,557,'attendances/974/1699539910 clock_in.png','attendances/974/1699573379 clock_out.png','Juan R',42196,NULL,'2023-11-09 11:25:10','2023-11-14 16:53:57'),(2976,'2023-11-09 06:34:30','2023-11-09 15:32:37','12.249.250.150','12.249.250.150','closed',8,538,'attendances/622/1699540470 clock_in.png','attendances/622/1699572757 clock_out.png','Juan R',42211,NULL,'2023-11-09 11:34:30','2023-11-14 17:17:19'),(2977,'2023-11-09 06:36:29','2023-11-09 14:27:16','12.249.250.150','12.249.250.150','closed',7,470,'attendances/1999/1699540589 clock_in.png','attendances/1999/1699568836 clock_out.png','Juan R',42204,NULL,'2023-11-09 11:36:29','2023-11-14 17:11:36'),(2978,'2023-11-09 06:46:43','2023-11-09 19:40:43','12.249.250.150','12.249.250.150','closed',12,774,'attendances/2151/1699541203 clock_in.png','attendances/2151/1699587643 clock_out.png','Juan R',42221,NULL,'2023-11-09 11:46:43','2023-11-14 17:13:19'),(2979,'2023-11-09 06:52:37','2023-11-09 19:04:29','12.249.250.150','12.249.250.150','closed',12,731,'attendances/2076/1699541557 clock_in.png','attendances/2076/1699585469 clock_out.png','Juan R',42224,NULL,'2023-11-09 11:52:37','2023-11-14 17:14:50'),(2980,'2023-11-09 06:52:56','2023-11-09 19:04:44','12.249.250.150','12.249.250.150','closed',12,731,'attendances/2178/1699541576 clock_in.png','attendances/2178/1699585484 clock_out.png','Juan R',42215,NULL,'2023-11-09 11:52:56','2023-11-14 17:10:12'),(2981,'2023-11-09 06:53:06','2023-11-09 15:31:33','12.249.250.150','12.249.250.150','closed',8,518,'attendances/1774/1699541586 clock_in.png','attendances/1774/1699572693 clock_out.png','Juan R',42202,NULL,'2023-11-09 11:53:06','2023-11-14 17:11:18'),(2982,'2023-11-09 06:53:21','2023-11-09 19:05:37','12.249.250.150','12.249.250.150','closed',12,732,'attendances/2005/1699541601 clock_in.png','attendances/2005/1699585537 clock_out.png','Juan R',42208,NULL,'2023-11-09 11:53:21','2023-11-14 17:12:35'),(2983,'2023-11-09 06:53:36','2023-11-09 17:46:23','12.249.250.150','12.249.250.150','closed',10,652,'attendances/2200/1699541616 clock_in.png','attendances/2200/1699580783 clock_out.png','Juan R',42201,NULL,'2023-11-09 11:53:36','2023-11-14 17:11:12'),(2984,'2023-11-09 06:55:20','2023-11-09 15:31:23','12.249.250.150','12.249.250.150','closed',8,516,'attendances/2168/1699541720 clock_in.png','attendances/2168/1699572683 clock_out.png','Juan R',42216,NULL,'2023-11-09 11:55:20','2023-11-14 17:11:21'),(2985,'2023-11-09 06:55:23','2023-11-09 15:30:27','12.249.250.150','12.249.250.150','closed',8,515,'attendances/2047/1699541723 clock_in.png','attendances/2047/1699572627 clock_out.png','Juan R',42217,NULL,'2023-11-09 11:55:23','2023-11-14 17:11:26'),(2986,'2023-11-09 06:55:26','2023-11-09 15:33:58','12.249.250.150','12.249.250.150','closed',8,518,'attendances/726/1699541726 clock_in.png','attendances/726/1699572838 clock_out.png','Juan R',42197,NULL,'2023-11-09 11:55:26','2023-11-14 16:54:17'),(2987,'2023-11-09 06:55:37','2023-11-09 16:46:59','12.249.250.150','12.249.250.150','closed',9,591,'attendances/2008/1699541737 clock_in.png','attendances/2008/1699577219 clock_out.png','Juan R',42240,NULL,'2023-11-09 11:55:37','2023-11-14 17:11:32'),(2988,'2023-11-09 06:55:51','2023-11-09 15:30:09','12.249.250.150','12.249.250.150','closed',8,514,'attendances/2061/1699541751 clock_in.png','attendances/2061/1699572609 clock_out.png','Juan R',42219,NULL,'2023-11-09 11:55:51','2023-11-14 17:11:57'),(2989,'2023-11-09 06:56:02','2023-11-09 15:31:02','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1934/1699541762 clock_in.png','attendances/1934/1699572662 clock_out.png','Juan R',42206,NULL,'2023-11-09 11:56:02','2023-11-14 17:12:01'),(2990,'2023-11-09 06:56:02','2023-11-09 15:44:11','12.249.250.150','12.249.250.150','closed',8,528,'attendances/1395/1699541762 clock_in.png','attendances/1395/1699573451 clock_out.png','Juan R',42209,NULL,'2023-11-09 11:56:02','2023-11-14 17:13:45'),(2991,'2023-11-09 06:56:13','2023-11-09 17:16:59','12.249.250.150','12.249.250.150','closed',10,620,'attendances/2150/1699541773 clock_in.png','attendances/2150/1699579019 clock_out.png','Juan R',42214,NULL,'2023-11-09 11:56:13','2023-11-14 17:10:09'),(2992,'2023-11-09 06:56:23','2023-11-09 19:04:59','12.249.250.150','12.249.250.150','closed',12,728,'attendances/2179/1699541783 clock_in.png','attendances/2179/1699585499 clock_out.png','Juan R',42226,NULL,'2023-11-09 11:56:23','2023-11-14 17:17:26'),(2993,'2023-11-09 06:56:29','2023-11-09 16:08:40','12.249.250.150','12.249.250.150','closed',9,552,'attendances/1888/1699541789 clock_in.png','attendances/1888/1699574920 clock_out.png','Juan R',42210,NULL,'2023-11-09 11:56:29','2023-11-14 17:17:40'),(2994,'2023-11-09 06:56:37','2023-11-09 15:36:07','12.249.250.150','12.249.250.150','closed',8,519,'attendances/1568/1699541797 clock_in.png','attendances/1568/1699572967 clock_out.png','Juan R',42199,NULL,'2023-11-09 11:56:37','2023-11-14 17:10:29'),(2995,'2023-11-09 06:56:48','2023-11-09 15:33:18','12.249.250.150','12.249.250.150','closed',8,516,'attendances/2152/1699541808 clock_in.png','attendances/2152/1699572798 clock_out.png','Juan R',42225,NULL,'2023-11-09 11:56:48','2023-11-14 17:17:21'),(2996,'2023-11-09 06:56:53','2023-11-09 15:45:32','12.249.250.150','12.249.250.150','closed',8,528,'attendances/2170/1699541814 clock_in.png','attendances/2170/1699573532 clock_out.png','Juan R',42222,NULL,'2023-11-09 11:56:54','2023-11-14 17:13:59'),(2997,'2023-11-09 06:56:57','2023-11-09 15:43:46','12.249.250.150','12.249.250.150','closed',8,526,'attendances/1479/1699541817 clock_in.png','attendances/1479/1699573426 clock_out.png','Juan R',42200,NULL,'2023-11-09 11:56:57','2023-11-14 17:10:47'),(2998,'2023-11-09 06:57:26','2023-11-09 19:00:46','12.249.250.150','12.249.250.150','closed',12,723,'attendances/2218/1699541846 clock_in.png','attendances/2218/1699585246 clock_out.png','Juan R',42218,NULL,'2023-11-09 11:57:26','2023-11-14 17:11:55'),(2999,'2023-11-09 06:57:45','2023-11-09 19:05:19','12.249.250.150','12.249.250.150','closed',12,727,'attendances/1551/1699541865 clock_in.png','attendances/1551/1699585519 clock_out.png','Juan R',42198,NULL,'2023-11-09 11:57:45','2023-11-14 16:54:44'),(3000,'2023-11-09 06:58:10','2023-11-09 15:35:14','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1958/1699541890 clock_in.png','attendances/1958/1699572914 clock_out.png','Juan R',42203,NULL,'2023-11-09 11:58:10','2023-11-14 17:11:23'),(3001,'2023-11-09 07:00:02','2023-11-09 15:35:46','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1858/1699542002 clock_in.png','attendances/1858/1699572946 clock_out.png','Juan R',42212,NULL,'2023-11-09 12:00:02','2023-11-14 17:12:22'),(3002,'2023-11-09 07:00:47','2023-11-09 15:32:07','12.249.250.150','12.249.250.150','closed',8,511,'attendances/1744/1699542047 clock_in.png','attendances/1744/1699572727 clock_out.png','Juan R',42220,NULL,'2023-11-09 12:00:47','2023-11-14 17:12:53'),(3003,'2023-11-09 07:01:45','2023-11-09 15:33:02','12.249.250.150','12.249.250.150','closed',8,511,'attendances/1462/1699542105 clock_in.png','attendances/1462/1699572782 clock_out.png','Juan R',42205,NULL,'2023-11-09 12:01:45','2023-11-14 17:11:40'),(3004,'2023-11-09 07:02:45','2023-11-09 16:46:37','12.249.250.150','12.249.250.150','closed',9,583,'attendances/2192/1699542165 clock_in.png','attendances/2192/1699577197 clock_out.png','Juan R',42223,NULL,'2023-11-09 12:02:45','2023-11-14 17:14:47'),(3005,'2023-11-09 07:04:09','2023-11-09 15:37:26','12.249.250.150','12.249.250.150','closed',8,513,'attendances/1948/1699542249 clock_in.png','attendances/1948/1699573046 clock_out.png','Juan R',42213,NULL,'2023-11-09 12:04:09','2023-11-14 17:14:41'),(3006,'2023-11-09 07:06:15','2023-11-09 16:18:16','12.249.250.150','12.249.250.150','closed',9,552,'attendances/1728/1699542375 clock_in.png','attendances/1728/1699575496 clock_out.png','Juan R',42207,NULL,'2023-11-09 12:06:15','2023-11-14 17:12:11'),(3007,'2023-11-09 06:30:00','2023-11-09 15:37:30','186.154.237.158','190.103.31.245','closed',9,547,NULL,'attendances/2133/1699558491 clock_out.png','Juan R',42195,NULL,'2023-11-09 12:18:33','2023-11-14 17:12:26'),(3008,'2023-11-09 08:00:20','2023-11-09 14:02:32','12.249.250.150','12.249.250.150','closed',6,362,'attendances/1869/1699545620 clock_in.png','attendances/1869/1699567352 clock_out.png','Juan R',42228,NULL,'2023-11-09 13:00:20','2023-11-14 17:10:39'),(3009,'2023-11-09 08:03:17','2023-11-09 16:30:37','12.249.250.150','12.249.250.150','closed',8,507,'attendances/1891/1699545797 clock_in.png','attendances/1891/1699576237 clock_out.png','Juan R',42229,NULL,'2023-11-09 13:03:17','2023-11-14 17:14:37'),(3010,'2023-11-06 05:55:00','2023-11-06 14:31:00','38.51.234.67','38.51.234.67','closed',8,516,NULL,NULL,'Juan R',42023,NULL,'2023-11-09 19:29:27','2023-11-14 17:15:02'),(3017,'2023-11-10 04:24:48','2023-11-10 14:09:12','12.249.250.150','12.249.250.150','closed',9,584,'attendances/726/1699619088 clock_in.png','attendances/726/1699654152 clock_out.png','Juan R',42252,NULL,'2023-11-10 09:24:48','2023-11-14 16:54:17'),(3018,'2023-11-10 04:24:55','2023-11-10 14:55:54','12.249.250.150','12.249.250.150','closed',10,630,'attendances/1585/1699619095 clock_in.png','attendances/1585/1699656954 clock_out.png','Juan R',42253,NULL,'2023-11-10 09:24:55','2023-11-14 17:10:18'),(3019,'2023-11-10 04:27:44','2023-11-10 16:14:39','12.249.250.150','12.249.250.150','closed',11,706,'attendances/1450/1699619264 clock_in.png','attendances/1450/1699661679 clock_out.png','Juan R',42255,NULL,'2023-11-10 09:27:44','2023-11-14 17:14:43'),(3020,'2023-11-10 04:32:15','2023-11-10 15:38:34','12.249.250.150','12.249.250.150','closed',11,666,'attendances/2133/1699619535 clock_in.png','attendances/2133/1699659514 clock_out.png','Juan R',42254,NULL,'2023-11-10 09:32:15','2023-11-14 17:12:26'),(3021,'2023-11-10 00:00:00','2023-11-10 02:13:00','38.51.234.67','38.51.234.67','closed',2,133,NULL,NULL,'Juan R',42290,NULL,'2023-11-10 09:56:22','2023-11-14 17:12:38'),(3022,'2023-11-10 00:00:00','2023-11-10 02:12:00','38.51.234.67','38.51.234.67','closed',2,132,NULL,NULL,'Juan R',42291,NULL,'2023-11-10 09:57:18','2023-11-14 17:15:02'),(3023,'2023-11-09 21:02:00','2023-11-09 23:59:00','38.51.234.67','38.51.234.67','closed',2,177,NULL,NULL,'Juan R',42292,NULL,'2023-11-10 10:05:13','2023-11-14 17:12:38'),(3024,'2023-11-09 21:02:00','2023-11-09 23:59:00','38.51.234.67','38.51.234.67','closed',2,177,NULL,NULL,'Juan R',42293,NULL,'2023-11-10 10:05:30','2023-11-14 17:15:02'),(3025,'2023-11-10 00:00:00','2023-11-10 00:43:00','38.51.234.67','38.51.234.67','closed',0,43,NULL,NULL,'Juan R',42295,NULL,'2023-11-10 10:44:22','2023-11-14 17:10:09'),(3026,'2023-11-09 22:26:00','2023-11-09 23:59:00','38.51.234.67','38.51.234.67','closed',1,93,NULL,NULL,'Juan R',42294,NULL,'2023-11-10 10:44:56','2023-11-14 17:10:09'),(3027,'2023-11-10 05:54:36','2023-11-10 15:32:12','12.249.250.150','12.249.250.150','closed',9,577,'attendances/1728/1699624476 clock_in.png','attendances/1728/1699659132 clock_out.png','Juan R',42274,NULL,'2023-11-10 10:54:36','2023-11-14 17:12:11'),(3028,'2023-11-10 05:58:49','2023-11-10 15:32:57','12.249.250.150','12.249.250.150','closed',9,574,'attendances/1479/1699624729 clock_in.png','attendances/1479/1699659177 clock_out.png','Juan R',42256,NULL,'2023-11-10 10:58:50','2023-11-14 17:10:47'),(3029,'2023-11-10 05:59:10','2023-11-10 15:22:14','12.249.250.150','12.249.250.150','closed',9,563,'attendances/1116/1699624750 clock_in.png','attendances/1116/1699658534 clock_out.png','Juan R',42257,NULL,'2023-11-10 10:59:17','2023-11-14 17:12:38'),(3030,'2023-11-10 06:35:01','2023-11-10 15:40:32','12.249.250.150','12.249.250.150','closed',9,545,'attendances/622/1699626901 clock_in.png','attendances/622/1699659632 clock_out.png','Juan R',42281,NULL,'2023-11-10 11:35:01','2023-11-14 17:17:19'),(3031,'2023-11-10 06:44:39','2023-11-10 15:29:34','12.249.250.150','12.249.250.150','closed',8,524,'attendances/1999/1699627479 clock_in.png','attendances/1999/1699658974 clock_out.png','Juan R',42269,NULL,'2023-11-10 11:44:39','2023-11-14 17:11:36'),(3032,'2023-11-10 06:52:27','2023-11-10 15:35:28','12.249.250.150','12.249.250.150','closed',8,523,'attendances/1774/1699627947 clock_in.png','attendances/1774/1699659328 clock_out.png','Juan R',42265,NULL,'2023-11-10 11:52:27','2023-11-14 17:11:18'),(3033,'2023-11-10 06:55:20','2023-11-10 18:51:10','12.249.250.150','12.249.250.150','closed',11,715,'attendances/1951/1699628120 clock_in.png','attendances/1951/1699671070 clock_out.png','Juan R',42263,NULL,'2023-11-10 11:55:20','2023-11-14 17:11:04'),(3034,'2023-11-10 06:55:31','2023-11-10 15:43:03','12.249.250.150','12.249.250.150','closed',8,527,'attendances/1934/1699628131 clock_in.png','attendances/1934/1699659783 clock_out.png','Juan R',42273,NULL,'2023-11-10 11:55:31','2023-11-14 17:12:01'),(3035,'2023-11-10 06:55:36','2023-11-10 18:51:00','12.249.250.150','12.249.250.150','closed',11,715,'attendances/2116/1699628136 clock_in.png','attendances/2116/1699671060 clock_out.png','Juan R',42262,NULL,'2023-11-10 11:55:36','2023-11-14 17:10:44'),(3036,'2023-11-10 06:55:44','2023-11-10 15:36:23','12.249.250.150','12.249.250.150','closed',8,520,'attendances/2168/1699628144 clock_in.png','attendances/2168/1699659383 clock_out.png','Juan R',42266,NULL,'2023-11-10 11:55:44','2023-11-14 17:11:21'),(3037,'2023-11-10 06:55:54','2023-11-10 15:30:13','12.249.250.150','12.249.250.150','closed',8,514,'attendances/2047/1699628154 clock_in.png','attendances/2047/1699659013 clock_out.png','Juan R',42268,NULL,'2023-11-10 11:55:54','2023-11-14 17:11:26'),(3038,'2023-11-10 06:55:56','2023-11-10 19:20:25','12.249.250.150','12.249.250.150','closed',12,744,'attendances/2178/1699628156 clock_in.png','attendances/2178/1699672825 clock_out.png','Juan R',42260,NULL,'2023-11-10 11:55:56','2023-11-14 17:10:12'),(3039,'2023-11-10 06:56:06','2023-11-10 19:20:26','12.249.250.150','12.249.250.150','closed',12,744,'attendances/2179/1699628166 clock_in.png','attendances/2179/1699672826 clock_out.png','Juan R',42282,NULL,'2023-11-10 11:56:06','2023-11-14 17:17:26'),(3040,'2023-11-10 06:56:08','2023-11-10 15:30:26','12.249.250.150','12.249.250.150','closed',8,514,'attendances/2061/1699628168 clock_in.png','attendances/2061/1699659026 clock_out.png','Juan R',42272,NULL,'2023-11-10 11:56:08','2023-11-14 17:11:57'),(3041,'2023-11-10 06:56:21','2023-11-10 19:20:50','12.249.250.150','12.249.250.150','closed',12,744,'attendances/2218/1699628181 clock_in.png','attendances/2218/1699672850 clock_out.png','Juan R',42271,NULL,'2023-11-10 11:56:21','2023-11-14 17:11:55'),(3042,'2023-11-10 06:56:28','2023-11-10 19:20:53','12.249.250.150','12.249.250.150','closed',12,744,'attendances/2076/1699628188 clock_in.png','attendances/2076/1699672853 clock_out.png','Juan R',42280,NULL,'2023-11-10 11:56:28','2023-11-14 17:14:50'),(3043,'2023-11-10 06:56:33','2023-11-10 19:21:13','12.249.250.150','12.249.250.150','closed',12,744,'attendances/1551/1699628193 clock_in.png','attendances/1551/1699672873 clock_out.png','Juan R',42258,NULL,'2023-11-10 11:56:33','2023-11-14 16:54:44'),(3044,'2023-11-10 06:56:44','2023-11-10 15:34:04','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1958/1699628204 clock_in.png','attendances/1958/1699659244 clock_out.png','Juan R',42267,NULL,'2023-11-10 11:56:44','2023-11-14 17:11:23'),(3045,'2023-11-10 06:56:49','2023-11-10 15:36:37','12.249.250.150','12.249.250.150','closed',8,519,'attendances/1744/1699628209 clock_in.png','attendances/1744/1699659397 clock_out.png','Juan R',42276,NULL,'2023-11-10 11:56:49','2023-11-14 17:12:53'),(3046,'2023-11-10 06:57:10','2023-11-10 15:29:12','12.249.250.150','12.249.250.150','closed',8,512,'attendances/1395/1699628230 clock_in.png','attendances/1395/1699658952 clock_out.png','Juan R',42278,NULL,'2023-11-10 11:57:10','2023-11-14 17:13:45'),(3047,'2023-11-10 06:57:27','2023-11-10 15:34:21','12.249.250.150','12.249.250.150','closed',8,516,'attendances/2150/1699628247 clock_in.png','attendances/2150/1699659261 clock_out.png','Juan R',42259,NULL,'2023-11-10 11:57:27','2023-11-14 17:10:09'),(3048,'2023-11-10 06:57:28','2023-11-10 16:52:05','12.249.250.150','12.249.250.150','closed',9,594,'attendances/2151/1699628248 clock_in.png','attendances/2151/1699663925 clock_out.png','Juan R',42277,NULL,'2023-11-10 11:57:28','2023-11-14 17:13:19'),(3049,'2023-11-10 07:00:50','2023-11-10 15:35:56','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1568/1699628450 clock_in.png','attendances/1568/1699659356 clock_out.png','Juan R',42261,NULL,'2023-11-10 12:00:50','2023-11-14 17:10:29'),(3050,'2023-11-10 07:02:44','2023-11-10 15:36:16','12.249.250.150','12.249.250.150','closed',8,513,'attendances/1462/1699628564 clock_in.png','attendances/1462/1699659376 clock_out.png','Juan R',42270,NULL,'2023-11-10 12:02:44','2023-11-14 17:11:40'),(3051,'2023-11-10 07:02:58','2023-11-10 15:43:57','12.249.250.150','12.249.250.150','closed',8,520,'attendances/1948/1699628578 clock_in.png','attendances/1948/1699659837 clock_out.png','Juan R',42279,NULL,'2023-11-10 12:02:58','2023-11-14 17:14:41'),(3052,'2023-11-10 07:10:01','2023-11-10 15:43:44','12.249.250.150','12.249.250.150','closed',8,513,'attendances/2200/1699629001 clock_in.png','attendances/2200/1699659824 clock_out.png','Juan R',42264,NULL,'2023-11-10 12:10:01','2023-11-14 17:11:12'),(3053,'2023-11-10 07:20:47','2023-11-10 15:37:11','12.249.250.150','12.249.250.150','closed',8,496,'attendances/1858/1699629647 clock_in.png','attendances/1858/1699659431 clock_out.png','Juan R',42275,NULL,'2023-11-10 12:20:47','2023-11-14 17:12:22'),(3054,'2023-11-10 07:55:46','2023-11-10 19:18:06','12.249.250.150','12.249.250.150','closed',11,682,'attendances/2008/1699631746 clock_in.png','attendances/2008/1699672686 clock_out.png','Juan R',42284,NULL,'2023-11-10 12:55:46','2023-11-14 17:11:32'),(3055,'2023-11-10 07:57:34','2023-11-10 19:18:01','12.249.250.150','12.249.250.150','closed',11,680,'attendances/2170/1699631854 clock_in.png','attendances/2170/1699672681 clock_out.png','Juan R',42286,NULL,'2023-11-10 12:57:34','2023-11-14 17:13:59'),(3056,'2023-11-10 07:58:26','2023-11-10 16:30:25','12.249.250.150','12.249.250.150','closed',8,511,'attendances/775/1699631907 clock_in.png','attendances/775/1699662625 clock_out.png','Juan R',42285,NULL,'2023-11-10 12:58:27','2023-11-14 17:13:48'),(3057,'2023-11-10 07:59:05','2023-11-10 16:34:52','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1891/1699631945 clock_in.png','attendances/1891/1699662892 clock_out.png','Juan R',42287,NULL,'2023-11-10 12:59:05','2023-11-14 17:14:37'),(3058,'2023-11-10 11:54:10','2023-11-10 20:43:00','12.249.250.150','12.249.250.150','closed',8,528,'attendances/2222/1699646050 clock_in.png','attendances/2222/1699677780 clock_out.png','Juan R',42289,NULL,'2023-11-10 16:54:10','2023-11-14 17:15:02'),(3059,'2023-11-10 11:55:07','2023-11-10 20:42:39','12.249.250.150','12.249.250.150','closed',8,527,'attendances/2169/1699646107 clock_in.png','attendances/2169/1699677759 clock_out.png','Juan R',42288,NULL,'2023-11-10 16:55:07','2023-11-14 17:11:09'),(3060,'2023-11-11 05:58:24','2023-11-11 14:35:31','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1479/1699711104 clock_in.png','attendances/1479/1699742131 clock_out.png','Juan R',42346,NULL,'2023-11-11 10:58:24','2023-11-14 17:10:47'),(3061,'2023-11-11 05:58:40','2023-11-11 14:36:56','12.249.250.150','12.249.250.150','closed',8,518,'attendances/1395/1699711120 clock_in.png','attendances/1395/1699742216 clock_out.png','Juan R',42402,NULL,'2023-11-11 10:58:40','2023-11-14 17:13:45'),(3062,'2023-11-11 06:00:41','2023-11-11 14:35:17','12.249.250.150','12.249.250.150','closed',8,514,'attendances/2008/1699711241 clock_in.png','attendances/2008/1699742117 clock_out.png','Juan R',42347,NULL,'2023-11-11 11:00:41','2023-11-14 17:11:32'),(3063,'2023-11-11 06:02:35','2023-11-11 16:23:12','12.249.250.150','12.249.250.150','closed',10,620,'attendances/2192/1699711355 clock_in.png','attendances/2192/1699748592 clock_out.png','Juan R',42349,NULL,'2023-11-11 11:02:35','2023-11-14 17:14:47'),(3064,'2023-11-11 06:02:45','2023-11-11 14:40:17','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1948/1699711365 clock_in.png','attendances/1948/1699742417 clock_out.png','Juan R',42348,NULL,'2023-11-11 11:02:45','2023-11-14 17:14:41'),(3065,'2023-11-11 07:00:32','2023-11-11 15:00:50','12.249.250.150','12.249.250.150','closed',8,480,'attendances/2151/1699714832 clock_in.png','attendances/2151/1699743650 clock_out.png','Juan R',42350,NULL,'2023-11-11 12:00:32','2023-11-14 17:13:19'),(3066,'2023-11-12 05:50:42','2023-11-12 15:12:45','12.249.250.150','12.249.250.150','closed',9,562,'attendances/2116/1699797042 clock_in.png','attendances/2116/1699830765 clock_out.png','Juan R',42352,NULL,'2023-11-12 10:50:42','2023-11-14 17:10:44'),(3067,'2023-11-12 05:55:07','2023-11-12 15:13:36','12.249.250.150','12.249.250.150','closed',9,558,'attendances/2008/1699797307 clock_in.png','attendances/2008/1699830816 clock_out.png','Juan R',42354,NULL,'2023-11-12 10:55:07','2023-11-14 17:11:32'),(3068,'2023-11-12 05:55:22','2023-11-12 15:12:29','12.249.250.150','12.249.250.150','closed',9,557,'attendances/2152/1699797322 clock_in.png','attendances/2152/1699830749 clock_out.png','Juan R',42356,NULL,'2023-11-12 10:55:22','2023-11-14 17:17:21'),(3069,'2023-11-12 05:57:01','2023-11-12 15:12:50','12.249.250.150','12.249.250.150','closed',9,555,'attendances/2150/1699797421 clock_in.png','attendances/2150/1699830770 clock_out.png','Juan R',42351,NULL,'2023-11-12 10:57:01','2023-11-14 17:10:09'),(3070,'2023-11-12 05:59:02','2023-11-12 15:12:57','12.249.250.150','12.249.250.150','closed',9,553,'attendances/1951/1699797542 clock_in.png','attendances/1951/1699830777 clock_out.png','Juan R',42353,NULL,'2023-11-12 10:59:02','2023-11-14 17:11:04'),(3071,'2023-11-12 06:09:49','2023-11-12 15:11:35','12.249.250.150','12.249.250.150','closed',9,541,'attendances/2192/1699798189 clock_in.png','attendances/2192/1699830695 clock_out.png','Juan R',42355,NULL,'2023-11-12 11:09:49','2023-11-14 17:14:47'),(3072,'2023-11-12 06:50:54','2023-11-12 16:05:07','12.249.250.150','12.249.250.150','closed',9,554,'attendances/974/1699800654 clock_in.png','attendances/974/1699833907 clock_out.png','Juan R',42357,NULL,'2023-11-12 11:50:54','2023-11-14 16:53:57'),(3073,'2023-11-12 07:01:40','2023-11-12 16:04:44','12.249.250.150','12.249.250.150','closed',9,543,'attendances/1888/1699801300 clock_in.png','attendances/1888/1699833884 clock_out.png','Juan R',42358,NULL,'2023-11-12 12:01:40','2023-11-14 17:17:40'),(3074,'2023-11-11 23:00:00','2023-11-11 23:59:00','38.51.234.67','38.51.234.67','closed',0,59,NULL,NULL,'Juan R',42404,NULL,'2023-11-12 17:32:53','2023-11-14 17:13:19'),(3075,'2023-11-12 00:00:00','2023-11-12 02:30:00','38.51.234.67','38.51.234.67','closed',2,150,NULL,NULL,'Juan R',42405,NULL,'2023-11-12 17:33:32','2023-11-14 17:13:19'),(3076,'2023-11-13 05:51:55','2023-11-13 17:06:38','12.249.250.150','12.249.250.150','closed',11,674,'attendances/1116/1699883515 clock_in.png','attendances/1116/1699923998 clock_out.png','Juan R',42364,NULL,'2023-11-13 10:51:55','2023-11-20 14:04:32'),(3077,'2023-11-13 05:55:08','2023-11-13 15:32:04','12.249.250.150','12.249.250.150','closed',9,576,'attendances/1568/1699883708 clock_in.png','attendances/1568/1699918324 clock_out.png','Juan R',42359,NULL,'2023-11-13 10:55:08','2023-11-20 14:01:25'),(3078,'2023-11-13 05:55:44','2023-11-13 14:30:59','12.249.250.150','12.249.250.150','closed',8,515,'attendances/2116/1699883744 clock_in.png','attendances/2116/1699914659 clock_out.png','Juan R',42360,NULL,'2023-11-13 10:55:44','2023-11-20 14:01:44'),(3079,'2023-11-13 05:55:57','2023-11-13 14:30:21','12.249.250.150','12.249.250.150','closed',8,514,'attendances/2169/1699883757 clock_in.png','attendances/2169/1699914621 clock_out.png','Juan R',42361,NULL,'2023-11-13 10:55:57','2023-11-20 14:02:24'),(3080,'2023-11-13 05:57:08','2023-11-13 14:35:27','12.249.250.150','12.249.250.150','closed',8,518,'attendances/2047/1699883828 clock_in.png','attendances/2047/1699914927 clock_out.png','Juan R',42362,NULL,'2023-11-13 10:57:08','2023-11-20 14:02:50'),(3081,'2023-11-13 05:57:20','2023-11-13 14:35:44','12.249.250.150','12.249.250.150','closed',8,518,'attendances/2061/1699883840 clock_in.png','attendances/2061/1699914944 clock_out.png','Juan R',42363,NULL,'2023-11-13 10:57:20','2023-11-20 14:03:18'),(3084,'2023-11-13 06:34:54','2023-11-13 15:32:33','12.249.250.150','12.249.250.150','closed',8,537,'attendances/622/1699886094 clock_in.png','attendances/622/1699918353 clock_out.png','Juan R',42388,NULL,'2023-11-13 11:34:54','2023-11-20 14:06:32'),(3085,'2023-11-13 06:50:44','2023-11-13 18:13:25','12.249.250.150','12.249.250.150','closed',11,682,'attendances/2076/1699887044 clock_in.png','attendances/2076/1699928005 clock_out.png','Juan R',42399,NULL,'2023-11-13 11:50:44','2023-11-20 14:05:40'),(3086,'2023-11-13 06:53:23','2023-11-13 15:32:01','12.249.250.150','12.249.250.150','closed',8,518,'attendances/1774/1699887203 clock_in.png','attendances/1774/1699918321 clock_out.png','Juan R',42377,NULL,'2023-11-13 11:53:23','2023-11-20 14:02:34'),(3087,'2023-11-13 06:53:58','2023-11-13 18:09:26','12.249.250.150','12.249.250.150','closed',11,675,'attendances/2179/1699887238 clock_in.png','attendances/2179/1699927766 clock_out.png','Juan R',42401,NULL,'2023-11-13 11:53:58','2023-11-20 14:06:42'),(3088,'2023-11-13 06:54:12','2023-11-13 18:14:41','12.249.250.150','12.249.250.150','closed',11,680,'attendances/1551/1699887252 clock_in.png','attendances/1551/1699928081 clock_out.png','Juan R',42374,NULL,'2023-11-13 11:54:12','2023-11-20 13:59:27'),(3089,'2023-11-13 06:54:27','2023-11-13 15:31:24','12.249.250.150','12.249.250.150','closed',8,516,'attendances/726/1699887267 clock_in.png','attendances/726/1699918284 clock_out.png','Juan R',42373,NULL,'2023-11-13 11:54:27','2023-11-20 13:59:20'),(3090,'2023-11-13 06:54:56','2023-11-13 15:30:26','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1934/1699887296 clock_in.png','attendances/1934/1699918226 clock_out.png','Juan R',42381,NULL,'2023-11-13 11:54:56','2023-11-20 14:03:25'),(3091,'2023-11-13 06:55:35','2023-11-13 15:32:33','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1744/1699887335 clock_in.png','attendances/1744/1699918353 clock_out.png','Juan R',42395,NULL,'2023-11-13 11:55:35','2023-11-20 14:04:37'),(3092,'2023-11-13 06:56:25','2023-11-13 15:54:41','12.249.250.150','12.249.250.150','closed',8,538,'attendances/2170/1699887385 clock_in.png','attendances/2170/1699919681 clock_out.png','Juan R',42397,NULL,'2023-11-13 11:56:25','2023-11-20 14:05:12'),(3093,'2023-11-13 06:56:37','2023-11-13 15:32:42','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1958/1699887397 clock_in.png','attendances/1958/1699918362 clock_out.png','Juan R',42378,NULL,'2023-11-13 11:56:37','2023-11-20 14:02:43'),(3094,'2023-11-13 06:56:40','2023-11-13 15:54:17','12.249.250.150','12.249.250.150','closed',8,537,'attendances/2133/1699887400 clock_in.png','attendances/2133/1699919657 clock_out.png','Juan R',42394,NULL,'2023-11-13 11:56:40','2023-11-20 14:04:13'),(3095,'2023-11-13 06:57:08','2023-11-13 15:50:40','12.249.250.150','12.249.250.150','closed',8,533,'attendances/1395/1699887428 clock_in.png','attendances/1395/1699919440 clock_out.png','Juan R',42385,NULL,'2023-11-13 11:57:08','2023-11-20 14:04:45'),(3096,'2023-11-13 06:57:20','2023-11-13 15:50:53','12.249.250.150','12.249.250.150','closed',8,533,'attendances/2200/1699887440 clock_in.png','attendances/2200/1699919453 clock_out.png','Juan R',42376,NULL,'2023-11-13 11:57:20','2023-11-20 14:02:29'),(3097,'2023-11-13 06:57:29','2023-11-13 15:32:24','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1450/1699887449 clock_in.png','attendances/1450/1699918344 clock_out.png','Juan R',42387,NULL,'2023-11-13 11:57:29','2023-11-20 14:05:34'),(3098,'2023-11-13 06:57:34','2023-11-13 16:58:56','12.249.250.150','12.249.250.150','closed',10,601,'attendances/1479/1699887454 clock_in.png','attendances/1479/1699923536 clock_out.png','Juan R',42375,NULL,'2023-11-13 11:57:34','2023-11-20 14:01:49'),(3099,'2023-11-13 06:57:41','2023-11-13 15:32:12','12.249.250.150','12.249.250.150','closed',8,514,'attendances/2168/1699887461 clock_in.png','attendances/2168/1699918332 clock_out.png','Juan R',42392,NULL,'2023-11-13 11:57:41','2023-11-20 14:02:37'),(3100,'2023-11-13 06:58:04','2023-11-13 18:14:23','12.249.250.150','12.249.250.150','closed',11,676,'attendances/2218/1699887484 clock_in.png','attendances/2218/1699928063 clock_out.png','Juan R',42403,NULL,'2023-11-13 11:58:04','2023-11-20 14:03:15'),(3101,'2023-11-13 06:58:28','2023-11-13 16:15:02','12.249.250.150','12.249.250.150','closed',9,556,'attendances/2151/1699887508 clock_in.png','attendances/2151/1699920902 clock_out.png','Juan R',42396,NULL,'2023-11-13 11:58:28','2023-11-20 14:04:39'),(3102,'2023-11-13 06:58:48','2023-11-13 15:50:29','12.249.250.150','12.249.250.150','closed',8,531,'attendances/1999/1699887528 clock_in.png','attendances/1999/1699919429 clock_out.png','Juan R',42379,NULL,'2023-11-13 11:58:48','2023-11-20 14:02:59'),(3103,'2023-11-13 06:59:02','2023-11-13 15:54:29','12.249.250.150','12.249.250.150','closed',8,535,'attendances/2150/1699887542 clock_in.png','attendances/2150/1699919669 clock_out.png','Juan R',42390,NULL,'2023-11-13 11:59:02','2023-11-20 13:59:32'),(3104,'2023-11-13 06:59:30','2023-11-13 15:50:16','12.249.250.150','12.249.250.150','closed',8,530,'attendances/974/1699887570 clock_in.png','attendances/974/1699919416 clock_out.png','Juan R',42372,NULL,'2023-11-13 11:59:30','2023-11-20 13:59:01'),(3105,'2023-11-13 06:59:32','2023-11-13 18:08:07','12.249.250.150','12.249.250.150','closed',11,668,'attendances/2178/1699887572 clock_in.png','attendances/2178/1699927687 clock_out.png','Juan R',42391,NULL,'2023-11-13 11:59:32','2023-11-20 13:59:36'),(3106,'2023-11-13 07:00:17','2023-11-13 15:30:05','12.249.250.150','12.249.250.150','closed',8,509,'attendances/2005/1699887617 clock_in.png','attendances/2005/1699918205 clock_out.png','Juan R',42384,NULL,'2023-11-13 12:00:17','2023-11-20 14:04:16'),(3107,'2023-11-13 07:00:18','2023-11-13 15:49:48','12.249.250.150','12.249.250.150','closed',8,529,'attendances/1728/1699887618 clock_in.png','attendances/1728/1699919388 clock_out.png','Juan R',42382,NULL,'2023-11-13 12:00:18','2023-11-20 14:04:08'),(3108,'2023-11-13 07:01:31','2023-11-13 15:32:56','12.249.250.150','12.249.250.150','closed',8,511,'attendances/1858/1699887691 clock_in.png','attendances/1858/1699918376 clock_out.png','Juan R',42383,NULL,'2023-11-13 12:01:31','2023-11-20 14:04:10'),(3109,'2023-11-13 07:03:07','2023-11-13 18:17:44','12.249.250.150','12.249.250.150','closed',11,674,'attendances/2222/1699887787 clock_in.png','attendances/2222/1699928264 clock_out.png','Juan R',42400,NULL,'2023-11-13 12:03:07','2023-11-20 14:05:43'),(3110,'2023-11-13 07:04:23','2023-11-13 17:29:05','12.249.250.150','12.249.250.150','closed',10,624,'attendances/2192/1699887863 clock_in.png','attendances/2192/1699925345 clock_out.png','Juan R',42398,NULL,'2023-11-13 12:04:24','2023-11-20 14:05:37'),(3111,'2023-11-13 07:04:57','2023-11-13 15:44:50','12.249.250.150','12.249.250.150','closed',8,519,'attendances/1888/1699887897 clock_in.png','attendances/1888/1699919090 clock_out.png','Juan R',42389,NULL,'2023-11-13 12:04:57','2023-11-20 14:06:46'),(3112,'2023-11-13 07:06:48','2023-11-13 15:43:43','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1948/1699888008 clock_in.png','attendances/1948/1699919023 clock_out.png','Juan R',42386,NULL,'2023-11-13 12:06:48','2023-11-20 14:05:27'),(3113,'2023-11-13 07:45:56','2023-11-13 15:46:47','12.249.250.150','12.249.250.150','closed',8,480,'attendances/1462/1699890356 clock_in.png','attendances/1462/1699919207 clock_out.png','Juan R',42380,NULL,'2023-11-13 12:45:56','2023-11-20 14:03:02'),(3114,'2023-11-13 07:57:17','2023-11-13 16:30:48','12.249.250.150','12.249.250.150','closed',8,513,'attendances/775/1699891037 clock_in.png','attendances/775/1699921848 clock_out.png','Juan R',42368,NULL,'2023-11-13 12:57:17','2023-11-20 14:04:49'),(3115,'2023-11-13 08:02:49','2023-11-13 16:32:02','38.51.234.69','12.249.250.150','closed',8,501,'attendances/1869/1699894369 clock_in.png','attendances/1869/1699921922 clock_out.png','Juan R',42367,NULL,'2023-11-13 13:52:49','2023-11-20 14:01:40'),(3116,'2023-11-13 09:02:23','2023-11-13 19:37:10','12.249.250.150','12.249.250.150','closed',10,634,'attendances/1585/1699894943 clock_in.png','attendances/1585/1699933030 clock_out.png','Juan R',42370,NULL,'2023-11-13 14:02:23','2023-11-20 14:01:01'),(3117,'2023-11-13 09:03:02','2023-11-13 19:34:24','12.249.250.150','12.249.250.150','closed',10,631,'attendances/1951/1699894982 clock_in.png','attendances/1951/1699932864 clock_out.png','Juan R',42371,NULL,'2023-11-13 14:03:02','2023-11-20 14:02:17'),(3118,'2023-11-13 06:25:00','2023-11-13 16:28:48','38.51.234.67','12.249.250.150','closed',10,603,NULL,'attendances/2008/1699921728 clock_out.png','Juan R',42365,NULL,'2023-11-13 14:09:15','2023-11-20 14:02:54'),(3119,'2023-11-13 06:26:00','2023-11-13 16:27:53','38.51.234.67','12.249.250.150','closed',10,601,NULL,'attendances/2152/1699921673 clock_out.png','Juan R',42366,NULL,'2023-11-13 14:13:31','2023-11-20 14:06:36'),(3120,'2023-11-13 08:01:19','2023-11-13 16:35:09','179.19.3.75','12.249.250.150','closed',8,504,'attendances/1891/1699897639 clock_in.png','attendances/1891/1699922109 clock_out.png','Juan R',42369,NULL,'2023-11-13 14:47:19','2023-11-20 14:05:21'),(3122,'2023-11-14 05:55:22','2023-11-14 14:32:37','12.249.250.150','12.249.250.150','closed',8,517,'attendances/2116/1699970122 clock_in.png','attendances/2116/1700001157 clock_out.png','Juan R',42422,NULL,'2023-11-14 10:55:22','2023-11-20 14:01:44'),(3123,'2023-11-14 05:55:34','2023-11-14 16:34:27','12.249.250.150','12.249.250.150','closed',10,638,'attendances/726/1699970134 clock_in.png','attendances/726/1700008467 clock_out.png','Juan R',42420,NULL,'2023-11-14 10:55:34','2023-11-20 13:59:20'),(3124,'2023-11-14 05:55:39','2023-11-14 14:31:52','12.249.250.150','12.249.250.150','closed',8,516,'attendances/2169/1699970139 clock_in.png','attendances/2169/1700001112 clock_out.png','Juan R',42423,NULL,'2023-11-14 10:55:39','2023-11-20 14:02:24'),(3125,'2023-11-14 05:56:38','2023-11-14 14:32:55','12.249.250.150','12.249.250.150','closed',8,516,'attendances/2061/1699970198 clock_in.png','attendances/2061/1700001175 clock_out.png','Juan R',42425,NULL,'2023-11-14 10:56:38','2023-11-20 14:03:18'),(3127,'2023-11-14 05:57:38','2023-11-14 21:45:54','12.249.250.150','12.249.250.150','closed',15,948,'attendances/2222/1699970258 clock_in.png','attendances/2222/1700027154 clock_out.png','Juan R',42428,NULL,'2023-11-14 10:57:38','2023-11-20 14:05:43'),(3128,'2023-11-14 05:59:58','2023-11-14 14:35:09','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1450/1699970398 clock_in.png','attendances/1450/1700001309 clock_out.png','Juan R',42426,NULL,'2023-11-14 10:59:58','2023-11-20 14:05:34'),(3129,'2023-11-14 06:03:39','2023-11-14 14:33:49','12.249.250.150','12.249.250.150','closed',8,510,'attendances/2192/1699970619 clock_in.png','attendances/2192/1700001229 clock_out.png','Juan R',42427,NULL,'2023-11-14 11:03:39','2023-11-20 14:05:37'),(3130,'2023-11-14 06:00:43','2023-11-14 14:33:12','186.154.237.158','12.249.250.150','closed',8,512,'attendances/2047/1699971763 clock_in.png','attendances/2047/1700001192 clock_out.png','Juan R',42424,NULL,'2023-11-14 11:22:43','2023-11-20 14:02:50'),(3131,'2023-11-14 06:34:53','2023-11-14 15:33:03','12.249.250.150','12.249.250.150','closed',8,538,'attendances/622/1699972493 clock_in.png','attendances/622/1700004783 clock_out.png','Juan R',42454,NULL,'2023-11-14 11:34:53','2023-11-20 14:06:32'),(3132,'2023-11-14 06:50:58','2023-11-14 16:22:30','12.249.250.150','12.249.250.150','closed',9,571,'attendances/2152/1699973458 clock_in.png','attendances/2152/1700007750 clock_out.png','Juan R',42455,NULL,'2023-11-14 11:50:58','2023-11-20 14:06:36'),(3133,'2023-11-14 06:51:16','2023-11-14 16:22:16','12.249.250.150','12.249.250.150','closed',9,571,'attendances/2151/1699973476 clock_in.png','attendances/2151/1700007736 clock_out.png','Juan R',42449,NULL,'2023-11-14 11:51:16','2023-11-20 14:04:39'),(3134,'2023-11-14 06:51:35','2023-11-14 16:22:20','12.249.250.150','12.249.250.150','closed',9,570,'attendances/2150/1699973495 clock_in.png','attendances/2150/1700007740 clock_out.png','Juan R',42430,NULL,'2023-11-14 11:51:35','2023-11-20 13:59:32'),(3135,'2023-11-14 06:54:04','2023-11-14 16:39:06','12.249.250.150','12.249.250.150','closed',9,585,'attendances/1999/1699973644 clock_in.png','attendances/1999/1700008746 clock_out.png','Juan R',42439,NULL,'2023-11-14 11:54:04','2023-11-20 14:02:59'),(3136,'2023-11-14 06:54:27','2023-11-14 16:59:33','12.249.250.150','12.249.250.150','closed',10,605,'attendances/2179/1699973667 clock_in.png','attendances/2179/1700009973 clock_out.png','Juan R',42456,NULL,'2023-11-14 11:54:27','2023-11-20 14:06:42'),(3137,'2023-11-14 06:54:33','2023-11-14 16:21:32','12.249.250.150','12.249.250.150','closed',9,566,'attendances/1728/1699973673 clock_in.png','attendances/1728/1700007692 clock_out.png','Juan R',42443,NULL,'2023-11-14 11:54:33','2023-11-20 14:04:08'),(3138,'2023-11-14 06:54:47','2023-11-14 15:31:35','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1774/1699973687 clock_in.png','attendances/1774/1700004695 clock_out.png','Juan R',42435,NULL,'2023-11-14 11:54:47','2023-11-20 14:02:34'),(3139,'2023-11-14 06:55:06','2023-11-14 15:33:15','12.249.250.150','12.249.250.150','closed',8,518,'attendances/1568/1699973706 clock_in.png','attendances/1568/1700004795 clock_out.png','Juan R',42432,NULL,'2023-11-14 11:55:06','2023-11-20 14:01:25'),(3140,'2023-11-14 06:55:29','2023-11-14 16:59:33','12.249.250.150','12.249.250.150','closed',10,604,'attendances/2076/1699973729 clock_in.png','attendances/2076/1700009973 clock_out.png','Juan R',42453,NULL,'2023-11-14 11:55:29','2023-11-20 14:05:40'),(3141,'2023-11-14 06:55:30','2023-11-14 15:31:21','12.249.250.150','12.249.250.150','closed',8,515,'attendances/2008/1699973730 clock_in.png','attendances/2008/1700004681 clock_out.png','Juan R',42438,NULL,'2023-11-14 11:55:30','2023-11-20 14:02:54'),(3142,'2023-11-14 06:55:43','2023-11-14 15:31:15','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1934/1699973743 clock_in.png','attendances/1934/1700004675 clock_out.png','Juan R',42442,NULL,'2023-11-14 11:55:43','2023-11-20 14:03:25'),(3143,'2023-11-14 06:55:45','2023-11-14 15:32:03','12.249.250.150','12.249.250.150','closed',8,516,'attendances/2168/1699973745 clock_in.png','attendances/2168/1700004723 clock_out.png','Juan R',42436,NULL,'2023-11-14 11:55:45','2023-11-20 14:02:37'),(3144,'2023-11-14 06:56:00','2023-11-14 16:58:40','12.249.250.150','12.249.250.150','closed',10,602,'attendances/2178/1699973760 clock_in.png','attendances/2178/1700009920 clock_out.png','Juan R',42431,NULL,'2023-11-14 11:56:00','2023-11-20 13:59:36'),(3145,'2023-11-14 06:56:10','2023-11-14 16:47:27','12.249.250.150','12.249.250.150','closed',9,591,'attendances/2200/1699973770 clock_in.png','attendances/2200/1700009247 clock_out.png','Juan R',42434,NULL,'2023-11-14 11:56:10','2023-11-20 14:02:29'),(3146,'2023-11-14 06:56:20','2023-11-14 15:31:52','12.249.250.150','12.249.250.150','closed',8,515,'attendances/2133/1699973780 clock_in.png','attendances/2133/1700004712 clock_out.png','Juan R',42445,NULL,'2023-11-14 11:56:20','2023-11-20 14:04:13'),(3147,'2023-11-14 06:56:26','2023-11-14 15:56:07','12.249.250.150','12.249.250.150','closed',8,539,'attendances/1479/1699973786 clock_in.png','attendances/1479/1700006167 clock_out.png','Juan R',42433,NULL,'2023-11-14 11:56:26','2023-11-20 14:01:49'),(3148,'2023-11-14 06:56:36','2023-11-14 15:36:48','12.249.250.150','12.249.250.150','closed',8,520,'attendances/2170/1699973796 clock_in.png','attendances/2170/1700005008 clock_out.png','Juan R',42451,NULL,'2023-11-14 11:56:36','2023-11-20 14:05:12'),(3149,'2023-11-14 06:56:39','2023-11-14 17:41:27','12.249.250.150','12.249.250.150','closed',10,644,'attendances/1395/1699973799 clock_in.png','attendances/1395/1700012487 clock_out.png','Juan R',42450,NULL,'2023-11-14 11:56:39','2023-11-20 14:04:45'),(3150,'2023-11-14 06:56:49','2023-11-14 16:38:27','12.249.250.150','12.249.250.150','closed',9,581,'attendances/1551/1699973809 clock_in.png','attendances/1551/1700008707 clock_out.png','Juan R',42421,NULL,'2023-11-14 11:56:49','2023-11-20 13:59:27'),(3151,'2023-11-14 06:57:05','2023-11-14 17:40:22','12.249.250.150','12.249.250.150','closed',10,643,'attendances/1116/1699973825 clock_in.png','attendances/1116/1700012422 clock_out.png','Juan R',42447,NULL,'2023-11-14 11:57:05','2023-11-20 14:04:32'),(3152,'2023-11-14 06:57:11','2023-11-14 15:32:14','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1744/1699973831 clock_in.png','attendances/1744/1700004734 clock_out.png','Juan R',42448,NULL,'2023-11-14 11:57:11','2023-11-20 14:04:37'),(3153,'2023-11-14 06:57:12','2023-11-14 15:35:29','12.249.250.150','12.249.250.150','closed',8,518,'attendances/1958/1699973832 clock_in.png','attendances/1958/1700004929 clock_out.png','Juan R',42437,NULL,'2023-11-14 11:57:12','2023-11-20 14:02:43'),(3154,'2023-11-14 06:58:14','2023-11-14 15:34:10','12.249.250.150','12.249.250.150','closed',8,515,'attendances/974/1699973894 clock_in.png','attendances/974/1700004850 clock_out.png','Juan R',42429,NULL,'2023-11-14 11:58:14','2023-11-20 13:59:01'),(3155,'2023-11-14 06:58:39','2023-11-14 15:35:31','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1462/1699973919 clock_in.png','attendances/1462/1700004931 clock_out.png','Juan R',42440,NULL,'2023-11-14 11:58:39','2023-11-20 14:03:02'),(3156,'2023-11-14 06:59:00','2023-11-14 15:39:14','12.249.250.150','12.249.250.150','closed',8,520,'attendances/1888/1699973940 clock_in.png','attendances/1888/1700005154 clock_out.png','Juan R',42457,NULL,'2023-11-14 11:59:00','2023-11-20 14:06:46'),(3157,'2023-11-14 07:00:12','2023-11-14 16:39:34','12.249.250.150','12.249.250.150','closed',9,579,'attendances/2218/1699974012 clock_in.png','attendances/2218/1700008774 clock_out.png','Juan R',42441,NULL,'2023-11-14 12:00:12','2023-11-20 14:03:15'),(3158,'2023-11-14 07:01:38','2023-11-14 16:58:03','12.249.250.150','12.249.250.150','closed',9,596,'attendances/2005/1699974098 clock_in.png','attendances/2005/1700009883 clock_out.png','Juan R',42446,NULL,'2023-11-14 12:01:38','2023-11-20 14:04:16'),(3159,'2023-11-14 07:01:47','2023-11-14 15:41:49','12.249.250.150','12.249.250.150','closed',8,520,'attendances/1948/1699974107 clock_in.png','attendances/1948/1700005309 clock_out.png','Juan R',42452,NULL,'2023-11-14 12:01:47','2023-11-20 14:05:27'),(3160,'2023-11-14 07:10:02','2023-11-14 15:35:20','12.249.250.150','12.249.250.150','closed',8,505,'attendances/1858/1699974602 clock_in.png','attendances/1858/1700004920 clock_out.png','Juan R',42444,NULL,'2023-11-14 12:10:02','2023-11-20 14:04:10'),(3161,'2023-11-14 08:00:25','2023-11-14 16:30:38','12.249.250.150','12.249.250.150','closed',8,510,'attendances/775/1699977625 clock_in.png','attendances/775/1700008238 clock_out.png','Juan R',42459,NULL,'2023-11-14 13:00:25','2023-11-20 14:04:49'),(3162,'2023-11-14 08:04:39','2023-11-14 16:31:51','38.51.234.69','12.249.250.150','closed',8,507,'attendances/1869/1699977879 clock_in.png','attendances/1869/1700008311 clock_out.png','Juan R',42458,NULL,'2023-11-14 13:04:39','2023-11-20 14:01:40'),(3163,'2023-11-14 08:07:04','2023-11-14 16:35:25','12.249.250.150','12.249.250.150','closed',8,508,'attendances/1891/1699978024 clock_in.png','attendances/1891/1700008525 clock_out.png','Juan R',42460,NULL,'2023-11-14 13:07:04','2023-11-20 14:05:21'),(3164,'2023-11-14 15:34:14','2023-11-14 23:59:00','12.249.250.150','38.51.234.67','closed',8,504,'attendances/1585/1700004854 clock_in.png',NULL,'Juan R',42461,NULL,'2023-11-14 20:34:14','2023-11-20 14:01:01'),(3165,'2023-11-14 15:49:43','2023-11-14 23:59:00','12.249.250.150','38.51.234.67','closed',8,489,'attendances/1951/1700005783 clock_in.png',NULL,'Juan R',42462,NULL,'2023-11-14 20:49:43','2023-11-20 14:02:17'),(3166,'2023-11-15 00:00:00','2023-11-15 06:40:05','38.51.234.67','12.249.250.150','closed',6,400,NULL,'attendances/1585/1700059205 clock_out.png','Juan R',42463,NULL,'2023-11-15 10:30:33','2023-11-20 14:01:01'),(3167,'2023-11-15 00:00:00','2023-11-15 06:40:18','38.51.234.67','12.249.250.150','closed',6,400,NULL,'attendances/1951/1700059218 clock_out.png','Juan R',42464,NULL,'2023-11-15 10:30:49','2023-11-20 14:02:17'),(3168,'2023-11-15 05:28:00','2023-11-15 15:31:54','38.51.234.67','12.249.250.150','closed',10,603,NULL,'attendances/1116/1700091114 clock_out.png','Juan R',42501,NULL,'2023-11-15 10:32:39','2023-11-20 14:04:32'),(3169,'2023-11-15 06:28:46','2023-11-15 15:58:12','12.249.250.150','12.249.250.150','closed',9,569,'attendances/1450/1700058526 clock_in.png','attendances/1450/1700092692 clock_out.png','Juan R',42505,NULL,'2023-11-15 11:28:46','2023-11-20 14:05:34'),(3170,'2023-11-15 06:29:21','2023-11-15 16:08:44','12.249.250.150','12.249.250.150','closed',9,579,'attendances/1551/1700058561 clock_in.png','attendances/1551/1700093324 clock_out.png','Juan R',42502,NULL,'2023-11-15 11:29:21','2023-11-20 13:59:27'),(3171,'2023-11-15 06:29:34','2023-11-15 16:00:55','12.249.250.150','12.249.250.150','closed',9,571,'attendances/2218/1700058574 clock_in.png','attendances/2218/1700092855 clock_out.png','Juan R',42503,NULL,'2023-11-15 11:29:34','2023-11-20 14:03:15'),(3172,'2023-11-15 06:29:50','2023-11-15 15:21:02','12.249.250.150','12.249.250.150','closed',8,531,'attendances/2076/1700058590 clock_in.png','attendances/2076/1700090462 clock_out.png','Juan R',42506,NULL,'2023-11-15 11:29:50','2023-11-20 14:05:40'),(3173,'2023-11-15 06:30:08','2023-11-15 15:54:21','12.249.250.150','12.249.250.150','closed',9,564,'attendances/2005/1700058608 clock_in.png','attendances/2005/1700092461 clock_out.png','Juan R',42504,NULL,'2023-11-15 11:30:08','2023-11-20 14:04:16'),(3174,'2023-11-15 06:40:40','2023-11-15 15:30:13','12.249.250.150','12.249.250.150','closed',8,529,'attendances/622/1700059240 clock_in.png','attendances/622/1700091013 clock_out.png','Juan R',42536,NULL,'2023-11-15 11:40:40','2023-11-20 14:06:32'),(3175,'2023-11-15 06:53:25','2023-11-15 18:12:34','12.249.250.150','12.249.250.150','closed',11,679,'attendances/1999/1700060005 clock_in.png','attendances/1999/1700100754 clock_out.png','Juan R',42523,NULL,'2023-11-15 11:53:25','2023-11-20 14:02:59'),(3176,'2023-11-15 06:54:08','2023-11-15 15:30:45','12.249.250.150','179.19.3.75','closed',8,516,'attendances/2179/1700060048 clock_in.png','attendances/2179/1700074977 clock_out.png','Juan R',42538,NULL,'2023-11-15 11:54:08','2023-11-20 14:06:42'),(3177,'2023-11-15 06:54:19','2023-11-15 15:30:26','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1774/1700060059 clock_in.png','attendances/1774/1700091026 clock_out.png','Juan R',42518,NULL,'2023-11-15 11:54:19','2023-11-20 14:02:34'),(3178,'2023-11-15 06:55:00','2023-11-15 15:37:13','12.249.250.150','179.19.3.75','closed',8,522,'attendances/2116/1700060100 clock_in.png','attendances/2116/1700074813 clock_out.png','Juan R',42514,NULL,'2023-11-15 11:55:00','2023-11-20 14:01:44'),(3179,'2023-11-15 06:55:38','2023-11-15 18:12:52','12.249.250.150','12.249.250.150','closed',11,677,'attendances/1395/1700060138 clock_in.png','attendances/1395/1700100772 clock_out.png','Juan R',42531,NULL,'2023-11-15 11:55:38','2023-11-20 14:04:45'),(3180,'2023-11-15 06:55:44','2023-11-15 15:30:26','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1568/1700060144 clock_in.png','attendances/1568/1700091026 clock_out.png','Juan R',42513,NULL,'2023-11-15 11:55:44','2023-11-20 14:01:25'),(3181,'2023-11-15 06:55:53','2023-11-15 18:12:02','12.249.250.150','12.249.250.150','closed',11,676,'attendances/2008/1700060153 clock_in.png','attendances/2008/1700100722 clock_out.png','Juan R',42522,NULL,'2023-11-15 11:55:53','2023-11-20 14:02:54'),(3182,'2023-11-15 06:56:02','2023-11-15 15:31:11','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1934/1700060162 clock_in.png','attendances/1934/1700091071 clock_out.png','Juan R',42526,NULL,'2023-11-15 11:56:02','2023-11-20 14:03:25'),(3183,'2023-11-15 06:56:04','2023-11-15 15:31:01','12.249.250.150','12.249.250.150','closed',8,514,'attendances/2168/1700060164 clock_in.png','attendances/2168/1700091061 clock_out.png','Juan R',42519,NULL,'2023-11-15 11:56:04','2023-11-20 14:02:37'),(3184,'2023-11-15 06:56:18','2023-11-15 15:31:17','12.249.250.150','12.249.250.150','closed',8,514,'attendances/2178/1700060178 clock_in.png','attendances/2178/1700091077 clock_out.png','Juan R',42512,NULL,'2023-11-15 11:56:18','2023-11-20 13:59:36'),(3185,'2023-11-15 06:56:27','2023-11-15 15:34:15','12.249.250.150','12.249.250.150','closed',8,517,'attendances/2047/1700060187 clock_in.png','attendances/2047/1700091255 clock_out.png','Juan R',42521,NULL,'2023-11-15 11:56:27','2023-11-20 14:02:50'),(3186,'2023-11-15 06:56:28','2023-11-15 15:37:28','12.249.250.150','12.249.250.150','closed',8,521,'attendances/2169/1700060188 clock_in.png','attendances/2169/1700091448 clock_out.png','Juan R',42516,NULL,'2023-11-15 11:56:28','2023-11-20 14:02:24'),(3187,'2023-11-15 06:56:32','2023-11-15 17:06:12','12.249.250.150','12.249.250.150','closed',10,609,'attendances/2152/1700060192 clock_in.png','attendances/2152/1700096772 clock_out.png','Juan R',42537,NULL,'2023-11-15 11:56:32','2023-11-20 14:06:36'),(3188,'2023-11-15 06:56:41','2023-11-15 15:32:43','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1479/1700060201 clock_in.png','attendances/1479/1700091163 clock_out.png','Juan R',42515,NULL,'2023-11-15 11:56:41','2023-11-20 14:01:49'),(3189,'2023-11-15 06:57:00','2023-11-15 16:56:48','12.249.250.150','12.249.250.150','closed',9,599,'attendances/2222/1700060220 clock_in.png','attendances/2222/1700096208 clock_out.png','Juan R',42535,NULL,'2023-11-15 11:57:00','2023-11-20 14:05:43'),(3190,'2023-11-15 06:57:01','2023-11-15 15:50:50','12.249.250.150','12.249.250.150','closed',8,533,'attendances/2150/1700060221 clock_in.png','attendances/2150/1700092250 clock_out.png','Juan R',42511,NULL,'2023-11-15 11:57:01','2023-11-20 13:59:32'),(3191,'2023-11-15 06:57:13','2023-11-15 15:35:05','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1958/1700060233 clock_in.png','attendances/1958/1700091305 clock_out.png','Juan R',42520,NULL,'2023-11-15 11:57:13','2023-11-20 14:02:43'),(3192,'2023-11-15 06:57:14','2023-11-15 15:50:30','12.249.250.150','12.249.250.150','closed',8,533,'attendances/2133/1700060234 clock_in.png','attendances/2133/1700092230 clock_out.png','Juan R',42528,NULL,'2023-11-15 11:57:14','2023-11-20 14:04:13'),(3193,'2023-11-15 06:57:16','2023-11-15 15:31:29','12.249.250.150','12.249.250.150','closed',8,514,'attendances/726/1700060236 clock_in.png','attendances/726/1700091089 clock_out.png','Juan R',42510,NULL,'2023-11-15 11:57:16','2023-11-20 13:59:20'),(3194,'2023-11-15 06:57:31','2023-11-15 18:13:30','12.249.250.150','12.249.250.150','closed',11,675,'attendances/2200/1700060251 clock_in.png','attendances/2200/1700100810 clock_out.png','Juan R',42517,NULL,'2023-11-15 11:57:31','2023-11-20 14:02:29'),(3195,'2023-11-15 06:57:42','2023-11-15 18:01:22','12.249.250.150','12.249.250.150','closed',11,663,'attendances/974/1700060262 clock_in.png','attendances/974/1700100082 clock_out.png','Juan R',42509,NULL,'2023-11-15 11:57:42','2023-11-20 13:59:01'),(3196,'2023-11-15 06:57:46','2023-11-15 15:30:45','12.249.250.150','12.249.250.150','closed',8,512,'attendances/1744/1700060266 clock_in.png','attendances/1744/1700091045 clock_out.png','Juan R',42529,NULL,'2023-11-15 11:57:46','2023-11-20 14:04:37'),(3197,'2023-11-15 06:57:51','2023-11-15 16:13:32','12.249.250.150','12.249.250.150','closed',9,555,'attendances/1728/1700060271 clock_in.png','attendances/1728/1700093612 clock_out.png','Juan R',42527,NULL,'2023-11-15 11:57:51','2023-11-20 14:04:08'),(3198,'2023-11-15 07:00:46','2023-11-15 16:26:37','12.249.250.150','12.249.250.150','closed',9,565,'attendances/1888/1700060446 clock_in.png','attendances/1888/1700094397 clock_out.png','Juan R',42539,NULL,'2023-11-15 12:00:46','2023-11-20 14:06:46'),(3199,'2023-11-15 07:03:30','2023-11-15 15:54:47','12.249.250.150','12.249.250.150','closed',8,531,'attendances/2192/1700060610 clock_in.png','attendances/2192/1700092487 clock_out.png','Juan R',42534,NULL,'2023-11-15 12:03:30','2023-11-20 14:05:37'),(3200,'2023-11-15 07:03:54','2023-11-15 15:43:38','12.249.250.150','12.249.250.150','closed',8,519,'attendances/1948/1700060634 clock_in.png','attendances/1948/1700091818 clock_out.png','Juan R',42533,NULL,'2023-11-15 12:03:54','2023-11-20 14:05:27'),(3201,'2023-11-15 07:07:09','2023-11-15 15:33:08','12.249.250.150','12.249.250.150','closed',8,505,'attendances/1462/1700060829 clock_in.png','attendances/1462/1700091188 clock_out.png','Juan R',42524,NULL,'2023-11-15 12:07:09','2023-11-20 14:03:02'),(3202,'2023-11-15 07:12:34','2023-11-15 15:35:30','12.249.250.150','12.249.250.150','closed',8,502,'attendances/1858/1700061154 clock_in.png','attendances/1858/1700091330 clock_out.png','Juan R',42540,NULL,'2023-11-15 12:12:34','2023-11-20 14:04:10'),(3205,'2023-11-15 07:58:50','2023-11-15 16:30:23','12.249.250.150','12.249.250.150','closed',8,511,'attendances/775/1700063930 clock_in.png','attendances/775/1700094623 clock_out.png','Juan R',42542,NULL,'2023-11-15 12:58:50','2023-11-20 14:04:49'),(3206,'2023-11-15 08:01:38','2023-11-15 16:32:35','12.249.250.150','12.249.250.150','closed',8,510,'attendances/1891/1700064098 clock_in.png','attendances/1891/1700094755 clock_out.png','Juan R',42543,NULL,'2023-11-15 13:01:38','2023-11-20 14:05:21'),(3207,'2023-11-15 08:01:55','2023-11-15 16:32:00','12.249.250.150','179.19.3.75','closed',8,510,'attendances/1869/1700064115 clock_in.png',NULL,'Juan R',42541,NULL,'2023-11-15 13:01:55','2023-11-20 14:01:40'),(3209,'2023-11-15 06:57:00','2023-11-15 18:12:20','38.51.234.67','12.249.250.150','closed',11,675,NULL,'attendances/2061/1700100740 clock_out.png','Juan R',42525,NULL,'2023-11-15 13:16:09','2023-11-20 14:03:18'),(3212,'2023-11-15 13:52:37','2023-11-15 23:59:00','12.249.250.150','186.154.237.158','closed',10,606,'attendances/1585/1700085157 clock_in.png',NULL,'Juan R',42546,NULL,'2023-11-15 18:52:37','2023-11-20 14:01:01'),(3213,'2023-11-15 13:52:48','2023-11-15 23:59:00','12.249.250.150','186.154.237.158','closed',10,606,'attendances/1951/1700085168 clock_in.png',NULL,'Juan R',42547,NULL,'2023-11-15 18:52:48','2023-11-20 14:02:17'),(3214,'2023-11-15 13:56:43','2023-11-15 23:59:00','12.249.250.150','186.154.237.158','closed',10,602,'attendances/2170/1700085403 clock_in.png',NULL,'Juan R',42532,NULL,'2023-11-15 18:56:43','2023-11-20 14:05:12'),(3215,'2023-11-16 05:49:09','2023-11-16 15:40:47','12.249.250.150','12.249.250.150','closed',9,591,'attendances/1568/1700142549 clock_in.png','attendances/1568/1700178047 clock_out.png','Juan R',42551,NULL,'2023-11-16 10:49:10','2023-11-20 14:01:25'),(3216,'2023-11-16 00:00:00','2023-11-16 01:04:00','186.154.237.158','186.154.237.158','closed',1,64,NULL,NULL,'Juan R',42574,NULL,'2023-11-16 10:51:44','2023-11-20 14:01:01'),(3217,'2023-11-16 00:00:00','2023-11-16 01:04:00','186.154.237.158','186.154.237.158','closed',1,64,NULL,NULL,'Juan R',42576,NULL,'2023-11-16 10:52:25','2023-11-20 14:05:12'),(3218,'2023-11-16 00:00:00','2023-11-16 01:04:00','186.154.237.158','186.154.237.158','closed',1,64,NULL,NULL,'Juan R',42575,NULL,'2023-11-16 10:52:52','2023-11-20 14:02:17'),(3219,'2023-11-16 05:55:26','2023-11-16 17:46:52','186.154.237.158','12.249.250.150','closed',11,711,'attendances/1116/1700144306 clock_in.png','attendances/1116/1700185612 clock_out.png','Juan R',42552,NULL,'2023-11-16 11:18:27','2023-11-20 14:04:32'),(3221,'2023-11-16 11:58:43','2023-11-16 18:39:23','12.249.250.150','12.249.250.150','closed',6,400,'attendances/1395/1700164723 clock_in.png','attendances/1395/1700188763 clock_out.png','Juan R',42556,NULL,'2023-11-16 16:58:43','2023-11-20 14:04:45'),(3222,'2023-11-16 11:59:44','2023-11-16 17:01:05','12.249.250.150','12.249.250.150','closed',5,301,'attendances/1450/1700164784 clock_in.png','attendances/1450/1700182865 clock_out.png','Juan R',42557,NULL,'2023-11-16 16:59:44','2023-11-20 14:05:34'),(3223,'2023-11-16 20:00:36','2023-11-16 23:59:00','179.19.3.75','38.51.234.67','closed',3,238,'attendances/1951/1700193936 clock_in.png',NULL,'Juan R',42555,NULL,'2023-11-17 01:05:36','2023-11-20 14:02:17'),(3224,'2023-11-16 20:00:50','2023-11-16 23:59:00','179.19.3.75','38.51.234.67','closed',3,238,'attendances/1585/1700193950 clock_in.png',NULL,'Juan R',42554,NULL,'2023-11-17 01:05:50','2023-11-20 14:01:01'),(3225,'2023-11-16 20:00:02','2023-11-16 23:59:00','179.19.3.75','38.51.234.67','closed',3,238,'attendances/1551/1700193962 clock_in.png',NULL,'Juan R',42553,NULL,'2023-11-17 01:06:02','2023-11-20 13:59:27'),(3226,'2023-11-17 00:00:00','2023-11-17 04:11:43','38.51.234.67','38.51.234.67','closed',4,251,'attendances/1551/1700223091 clock_in.png','attendances/1551/1700223103 clock_out.png','Juan R',42558,NULL,'2023-11-17 09:11:31','2023-11-20 13:59:27'),(3227,'2023-11-17 00:00:00','2023-11-17 04:11:00','38.51.234.67','38.51.234.67','closed',4,251,NULL,NULL,'Juan R',42560,NULL,'2023-11-17 09:30:57','2023-11-20 14:02:17'),(3228,'2023-11-17 00:00:00','2023-11-17 04:11:00','38.51.234.67','38.51.234.67','closed',4,251,NULL,NULL,'Juan R',42559,NULL,'2023-11-17 09:31:53','2023-11-20 14:01:01'),(3229,'2023-11-17 05:34:47','2023-11-17 14:09:14','12.249.250.150','12.249.250.150','closed',8,514,'attendances/2179/1700228087 clock_in.png','attendances/2179/1700258954 clock_out.png','Juan R',42578,NULL,'2023-11-17 10:34:47','2023-11-20 14:06:42'),(3230,'2023-11-17 05:43:15','2023-11-17 13:59:59','12.249.250.150','12.249.250.150','closed',8,496,'attendances/2178/1700228595 clock_in.png','attendances/2178/1700258399 clock_out.png','Juan R',42577,NULL,'2023-11-17 10:43:15','2023-11-20 13:59:36'),(3231,'2023-11-17 05:57:13','2023-11-17 16:20:15','12.249.250.150','12.249.250.150','closed',10,623,'attendances/2008/1700229433 clock_in.png','attendances/2008/1700266815 clock_out.png','Juan R',42582,NULL,'2023-11-17 10:57:13','2023-11-20 14:02:54'),(3232,'2023-11-17 05:57:24','2023-11-17 15:31:03','12.249.250.150','12.249.250.150','closed',9,573,'attendances/2116/1700229444 clock_in.png','attendances/2116/1700263863 clock_out.png','Juan R',42580,NULL,'2023-11-17 10:57:24','2023-11-20 14:01:44'),(3233,'2023-11-17 05:57:32','2023-11-17 16:15:53','12.249.250.150','12.249.250.150','closed',10,618,'attendances/2169/1700229452 clock_in.png','attendances/2169/1700266553 clock_out.png','Juan R',42581,NULL,'2023-11-17 10:57:32','2023-11-20 14:02:24'),(3234,'2023-11-17 05:57:38','2023-11-17 15:30:23','12.249.250.150','12.249.250.150','closed',9,572,'attendances/1568/1700229458 clock_in.png','attendances/1568/1700263823 clock_out.png','Juan R',42579,NULL,'2023-11-17 10:57:38','2023-11-20 14:01:25'),(3235,'2023-11-17 05:58:03','2023-11-17 16:22:19','12.249.250.150','12.249.250.150','closed',10,624,'attendances/2170/1700229483 clock_in.png','attendances/2170/1700266939 clock_out.png','Juan R',42583,NULL,'2023-11-17 10:58:03','2023-11-20 14:05:12'),(3236,'2023-11-17 06:00:14','2023-11-17 19:44:11','12.249.250.150','12.249.250.150','closed',13,823,'attendances/2222/1700229614 clock_in.png','attendances/2222/1700279051 clock_out.png','Juan R',42584,NULL,'2023-11-17 11:00:14','2023-11-20 14:05:43'),(3237,'2023-11-17 06:42:27','2023-11-17 16:43:58','12.249.250.150','12.249.250.150','closed',10,601,'attendances/622/1700232147 clock_in.png','attendances/622/1700268238 clock_out.png','Juan R',42600,NULL,'2023-11-17 11:42:27','2023-11-20 14:06:32'),(3238,'2023-11-17 06:51:14','2023-11-17 15:38:32','12.249.250.150','12.249.250.150','closed',8,527,'attendances/1999/1700232674 clock_in.png','attendances/1999/1700264312 clock_out.png','Juan R',42592,NULL,'2023-11-17 11:51:14','2023-11-20 14:02:59'),(3239,'2023-11-17 06:51:32','2023-11-17 16:50:34','12.249.250.150','12.249.250.150','closed',9,599,'attendances/1116/1700232692 clock_in.png','attendances/1116/1700268634 clock_out.png','Juan R',42597,NULL,'2023-11-17 11:51:33','2023-11-20 14:04:32'),(3240,'2023-11-17 06:52:02','2023-11-17 15:31:41','12.249.250.150','12.249.250.150','closed',8,519,'attendances/1774/1700232722 clock_in.png','attendances/1774/1700263901 clock_out.png','Juan R',42590,NULL,'2023-11-17 11:52:02','2023-11-20 14:02:34'),(3241,'2023-11-17 06:54:59','2023-11-17 12:26:33','12.249.250.150','12.249.250.150','closed',5,331,'attendances/1551/1700232899 clock_in.png','attendances/1551/1700252793 clock_out.png','Juan R',42587,NULL,'2023-11-17 11:54:59','2023-11-20 13:59:27'),(3242,'2023-11-17 06:55:10','2023-11-17 15:31:00','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1934/1700232910 clock_in.png','attendances/1934/1700263860 clock_out.png','Juan R',42594,NULL,'2023-11-17 11:55:10','2023-11-20 14:03:25'),(3243,'2023-11-17 06:55:21','2023-11-17 15:33:57','12.249.250.150','12.249.250.150','closed',8,518,'attendances/2151/1700232921 clock_in.png','attendances/2151/1700264037 clock_out.png','Juan R',42607,NULL,'2023-11-17 11:55:21','2023-11-20 14:04:39'),(3244,'2023-11-17 06:55:27','2023-11-17 15:40:28','12.249.250.150','190.103.31.245','closed',8,525,'attendances/1395/1700232927 clock_in.png','attendances/1395/1700249668 clock_out.png','Juan R',42598,NULL,'2023-11-17 11:55:27','2023-11-20 14:04:45'),(3245,'2023-11-17 06:55:29','2023-11-17 15:31:54','12.249.250.150','12.249.250.150','closed',8,516,'attendances/2133/1700232929 clock_in.png','attendances/2133/1700263914 clock_out.png','Juan R',42605,NULL,'2023-11-17 11:55:29','2023-11-20 14:04:13'),(3246,'2023-11-17 06:55:39','2023-11-17 15:33:43','12.249.250.150','12.249.250.150','closed',8,518,'attendances/2168/1700232939 clock_in.png','attendances/2168/1700264023 clock_out.png','Juan R',42602,NULL,'2023-11-17 11:55:39','2023-11-20 14:02:37'),(3247,'2023-11-17 06:55:57','2023-11-17 17:28:34','12.249.250.150','12.249.250.150','closed',10,632,'attendances/2047/1700232957 clock_in.png','attendances/2047/1700270914 clock_out.png','Juan R',42603,NULL,'2023-11-17 11:55:57','2023-11-20 14:02:50'),(3248,'2023-11-17 06:56:15','2023-11-17 17:28:49','12.249.250.150','12.249.250.150','closed',10,632,'attendances/2061/1700232975 clock_in.png','attendances/2061/1700270929 clock_out.png','Juan R',42604,NULL,'2023-11-17 11:56:15','2023-11-20 14:03:18'),(3249,'2023-11-17 06:56:29','2023-11-17 15:35:00','12.249.250.150','12.249.250.150','closed',8,518,'attendances/1858/1700232989 clock_in.png','attendances/1858/1700264100 clock_out.png','Juan R',42596,NULL,'2023-11-17 11:56:29','2023-11-20 14:04:10'),(3250,'2023-11-17 06:56:34','2023-11-17 15:34:45','12.249.250.150','12.249.250.150','closed',8,518,'attendances/1728/1700232994 clock_in.png','attendances/1728/1700264085 clock_out.png','Juan R',42595,NULL,'2023-11-17 11:56:34','2023-11-20 14:04:08'),(3251,'2023-11-17 06:56:40','2023-11-17 15:33:44','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1958/1700233000 clock_in.png','attendances/1958/1700264024 clock_out.png','Juan R',42591,NULL,'2023-11-17 11:56:40','2023-11-20 14:02:43'),(3252,'2023-11-17 06:56:46','2023-11-17 15:37:14','12.249.250.150','12.249.250.150','closed',8,520,'attendances/2200/1700233006 clock_in.png','attendances/2200/1700264234 clock_out.png','Juan R',42589,NULL,'2023-11-17 11:56:46','2023-11-20 14:02:29'),(3253,'2023-11-17 06:57:04','2023-11-17 16:30:19','12.249.250.150','12.249.250.150','closed',9,573,'attendances/726/1700233024 clock_in.png','attendances/726/1700267419 clock_out.png','Juan R',42586,NULL,'2023-11-17 11:57:04','2023-11-20 13:59:20'),(3254,'2023-11-17 06:57:44','2023-11-17 15:31:59','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1744/1700233064 clock_in.png','attendances/1744/1700263919 clock_out.png','Juan R',42606,NULL,'2023-11-17 11:57:44','2023-11-20 14:04:37'),(3255,'2023-11-17 06:58:08','2023-11-17 15:40:57','12.249.250.150','12.249.250.150','closed',8,522,'attendances/974/1700233088 clock_in.png','attendances/974/1700264457 clock_out.png','Juan R',42585,NULL,'2023-11-17 11:58:08','2023-11-20 13:59:01'),(3256,'2023-11-17 06:58:26','2023-11-17 15:32:22','12.249.250.150','12.249.250.150','closed',8,513,'attendances/1479/1700233106 clock_in.png','attendances/1479/1700263942 clock_out.png','Juan R',42588,NULL,'2023-11-17 11:58:26','2023-11-20 14:01:49'),(3257,'2023-11-17 07:01:41','2023-11-17 15:31:22','12.249.250.150','12.249.250.150','closed',8,509,'attendances/2192/1700233301 clock_in.png','attendances/2192/1700263882 clock_out.png','Juan R',42608,NULL,'2023-11-17 12:01:41','2023-11-20 14:05:37'),(3258,'2023-11-17 07:02:05','2023-11-17 15:34:18','12.249.250.150','12.249.250.150','closed',8,512,'attendances/2094/1700233325 clock_in.png','attendances/2094/1700264058 clock_out.png','Juan R',42615,NULL,'2023-11-17 12:02:05','2023-11-20 14:05:30'),(3259,'2023-11-17 07:03:23','2023-11-17 15:42:07','12.249.250.150','12.249.250.150','closed',8,518,'attendances/1888/1700233403 clock_in.png','attendances/1888/1700264527 clock_out.png','Juan R',42601,NULL,'2023-11-17 12:03:23','2023-11-20 14:06:46'),(3260,'2023-11-17 07:05:01','2023-11-17 15:44:26','12.249.250.150','12.249.250.150','closed',8,519,'attendances/1948/1700233501 clock_in.png','attendances/1948/1700264666 clock_out.png','Juan R',42599,NULL,'2023-11-17 12:05:01','2023-11-20 14:05:27'),(3261,'2023-11-17 07:10:14','2023-11-17 15:35:24','12.249.250.150','12.249.250.150','closed',8,505,'attendances/1462/1700233814 clock_in.png','attendances/1462/1700264124 clock_out.png','Juan R',42593,NULL,'2023-11-17 12:10:14','2023-11-20 14:03:02'),(3262,'2023-11-17 08:01:02','2023-11-17 16:32:36','12.249.250.150','12.249.250.150','closed',8,511,'attendances/1869/1700236862 clock_in.png','attendances/1869/1700267556 clock_out.png','Juan R',42609,NULL,'2023-11-17 13:01:02','2023-11-20 14:01:40'),(3263,'2023-11-17 08:01:29','2023-11-17 16:37:51','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1891/1700236889 clock_in.png','attendances/1891/1700267871 clock_out.png','Juan R',42610,NULL,'2023-11-17 13:01:29','2023-11-20 14:05:21'),(3264,'2023-11-17 08:54:39','2023-11-17 15:31:15','12.249.250.150','12.249.250.150','closed',6,396,'attendances/2076/1700240079 clock_in.png','attendances/2076/1700263875 clock_out.png','Juan R',42614,NULL,'2023-11-17 13:54:39','2023-11-20 14:05:40'),(3265,'2023-11-17 08:56:00','2023-11-17 16:19:17','12.249.250.150','12.249.250.150','closed',7,443,'attendances/2150/1700240160 clock_in.png','attendances/2150/1700266757 clock_out.png','Juan R',42611,NULL,'2023-11-17 13:56:00','2023-11-20 13:59:32'),(3266,'2023-11-17 08:58:11','2023-11-17 15:31:28','12.249.250.150','12.249.250.150','closed',6,393,'attendances/2218/1700240291 clock_in.png','attendances/2218/1700263888 clock_out.png','Juan R',42612,NULL,'2023-11-17 13:58:11','2023-11-20 14:03:15'),(3267,'2023-11-17 08:58:32','2023-11-17 16:21:06','12.249.250.150','12.249.250.150','closed',7,442,'attendances/1450/1700240312 clock_in.png','attendances/1450/1700266866 clock_out.png','Juan R',42613,NULL,'2023-11-17 13:58:32','2023-11-20 14:05:34'),(3268,'2023-11-17 15:51:49','2023-11-17 23:59:00','12.249.250.150','38.51.234.69','closed',8,487,'attendances/1585/1700265109 clock_in.png',NULL,'Juan R',42616,NULL,'2023-11-17 20:51:49','2023-11-20 14:01:01'),(3269,'2023-11-17 15:52:07','2023-11-17 23:59:00','12.249.250.150','38.51.234.69','closed',8,486,'attendances/1951/1700265127 clock_in.png',NULL,'Juan R',42617,NULL,'2023-11-17 20:52:07','2023-11-20 14:02:17'),(3270,'2023-11-18 00:00:00','2023-11-18 01:28:00','38.51.234.69','38.51.234.69','closed',1,88,NULL,NULL,'Juan R',42619,NULL,'2023-11-18 10:15:30','2023-11-20 14:02:17'),(3271,'2023-11-18 00:00:00','2023-11-18 01:28:00','38.51.234.69','38.51.234.69','closed',1,88,NULL,NULL,'Juan R',42618,NULL,'2023-11-18 10:15:46','2023-11-20 14:01:01'),(3272,'2023-11-18 05:57:19','2023-11-18 14:33:15','12.249.250.150','12.249.250.150','closed',8,515,'attendances/2200/1700315839 clock_in.png','attendances/2200/1700346795 clock_out.png','Juan R',42659,NULL,'2023-11-18 10:57:19','2023-11-20 14:02:29'),(3273,'2023-11-18 05:57:31','2023-11-18 14:33:05','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1999/1700315851 clock_in.png','attendances/1999/1700346785 clock_out.png','Juan R',42662,NULL,'2023-11-18 10:57:31','2023-11-20 14:02:59'),(3274,'2023-11-18 05:57:44','2023-11-18 14:32:49','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1728/1700315864 clock_in.png','attendances/1728/1700346769 clock_out.png','Juan R',42665,NULL,'2023-11-18 10:57:44','2023-11-20 14:04:08'),(3275,'2023-11-18 05:58:40','2023-11-18 16:17:07','12.249.250.150','12.249.250.150','closed',10,618,'attendances/2047/1700315920 clock_in.png','attendances/2047/1700353027 clock_out.png','Juan R',42661,NULL,'2023-11-18 10:58:40','2023-11-20 14:02:50'),(3276,'2023-11-18 05:59:22','2023-11-18 16:17:22','12.249.250.150','12.249.250.150','closed',10,618,'attendances/2061/1700315962 clock_in.png','attendances/2061/1700353042 clock_out.png','Juan R',42664,NULL,'2023-11-18 10:59:22','2023-11-20 14:03:18'),(3277,'2023-11-18 06:00:18','2023-11-18 13:31:28','12.249.250.150','12.249.250.150','closed',7,451,'attendances/2076/1700316018 clock_in.png','attendances/2076/1700343088 clock_out.png','Juan R',42666,NULL,'2023-11-18 11:00:18','2023-11-20 14:05:40'),(3278,'2023-11-18 06:00:41','2023-11-18 13:31:46','12.249.250.150','12.249.250.150','closed',7,451,'attendances/2218/1700316041 clock_in.png','attendances/2218/1700343106 clock_out.png','Juan R',42663,NULL,'2023-11-18 11:00:41','2023-11-20 14:03:15'),(3279,'2023-11-18 06:00:47','2023-11-18 13:45:44','12.249.250.150','12.249.250.150','closed',7,464,'attendances/2222/1700316047 clock_in.png','attendances/2222/1700343944 clock_out.png','Juan R',42667,NULL,'2023-11-18 11:00:47','2023-11-20 14:05:43'),(3280,'2023-11-18 06:38:28','2023-11-18 15:30:06','12.249.250.150','12.249.250.150','closed',8,531,'attendances/974/1700318308 clock_in.png','attendances/974/1700350206 clock_out.png','Juan R',42668,NULL,'2023-11-18 11:38:28','2023-11-20 13:59:01'),(3281,'2023-11-18 07:56:21','2023-11-18 14:31:05','12.249.250.150','12.249.250.150','closed',6,394,'attendances/726/1700322981 clock_in.png','attendances/726/1700346665 clock_out.png','Juan R',42669,NULL,'2023-11-18 12:56:21','2023-11-20 13:59:20'),(3282,'2023-11-18 18:54:25','2023-11-18 20:50:39','12.249.250.150','12.249.250.150','closed',1,116,'attendances/1395/1700362465 clock_in.png','attendances/1395/1700369439 clock_out.png','Juan R',42735,NULL,'2023-11-18 23:54:25','2023-11-20 14:04:45'),(3283,'2023-11-19 05:56:43','2023-11-19 14:24:36','12.249.250.150','12.249.250.150','closed',8,507,'attendances/2169/1700402203 clock_in.png','attendances/2169/1700432676 clock_out.png','Juan R',42671,NULL,'2023-11-19 10:56:43','2023-11-20 14:02:24'),(3284,'2023-11-19 05:56:56','2023-11-19 14:24:25','12.249.250.150','12.249.250.150','closed',8,507,'attendances/2116/1700402216 clock_in.png','attendances/2116/1700432665 clock_out.png','Juan R',42670,NULL,'2023-11-19 10:56:56','2023-11-20 14:01:44'),(3285,'2023-11-19 06:02:51','2023-11-19 14:18:29','12.249.250.150','12.249.250.150','closed',8,495,'attendances/2192/1700402571 clock_in.png','attendances/2192/1700432309 clock_out.png','Juan R',42672,NULL,'2023-11-19 11:02:51','2023-11-20 14:05:37'),(3286,'2023-11-19 17:56:14','2023-11-19 22:38:51','12.249.250.150','12.249.250.150','closed',4,282,'attendances/1479/1700445374 clock_in.png','attendances/1479/1700462331 clock_out.png','Juan R',42673,NULL,'2023-11-19 22:56:14','2023-11-20 14:01:49'),(3287,'2023-11-19 18:00:23','2023-11-19 22:40:39','12.249.250.150','12.249.250.150','closed',4,280,'attendances/2170/1700445623 clock_in.png','attendances/2170/1700462439 clock_out.png','Juan R',42683,NULL,'2023-11-19 23:00:23','2023-11-20 14:05:12'),(3288,'2023-11-20 05:52:59','2023-11-20 14:30:37','12.249.250.150','12.249.250.150','closed',8,517,'attendances/2222/1700488379 clock_in.png','attendances/2222/1700519437 clock_out.png','Juan R',42700,NULL,'2023-11-20 10:52:59','2023-11-27 15:57:20'),(3289,'2023-11-20 05:54:27','2023-11-20 15:45:52','12.249.250.150','12.249.250.150','closed',9,591,'attendances/2169/1700488467 clock_in.png','attendances/2169/1700523952 clock_out.png','Juan R',42696,NULL,'2023-11-20 10:54:27','2023-11-27 15:51:18'),(3290,'2023-11-20 05:56:07','2023-11-20 17:31:22','12.249.250.150','12.249.250.150','closed',11,695,'attendances/2116/1700488567 clock_in.png','attendances/2116/1700530282 clock_out.png','Juan R',42695,NULL,'2023-11-20 10:56:07','2023-11-27 15:51:05'),(3291,'2023-11-20 05:56:50','2023-11-20 15:32:00','12.249.250.150','190.103.31.245','closed',9,575,'attendances/1568/1700488610 clock_in.png',NULL,'Juan R',42694,NULL,'2023-11-20 10:56:50','2023-11-27 15:50:43'),(3292,'2023-11-20 06:00:15','2023-11-20 14:30:49','12.249.250.150','12.249.250.150','closed',8,510,'attendances/1951/1700488815 clock_in.png','attendances/1951/1700519449 clock_out.png','Juan R',42697,NULL,'2023-11-20 11:00:15','2023-11-27 15:51:14'),(3293,'2023-11-20 06:02:32','2023-11-20 17:31:09','12.249.250.150','12.249.250.150','closed',11,688,'attendances/1450/1700488952 clock_in.png','attendances/1450/1700530269 clock_out.png','Juan R',42699,NULL,'2023-11-20 11:02:32','2023-11-27 15:57:15'),(3294,'2023-11-20 06:20:31','2023-11-20 15:00:36','12.249.250.150','12.249.250.150','closed',8,520,'attendances/1551/1700490031 clock_in.png','attendances/1551/1700521236 clock_out.png','Juan R',42690,NULL,'2023-11-20 11:20:31','2023-11-27 15:23:10'),(3295,'2023-11-20 06:28:12','2023-11-20 15:00:19','12.249.250.150','12.249.250.150','closed',8,512,'attendances/2218/1700490492 clock_in.png','attendances/2218/1700521219 clock_out.png','Juan R',42691,NULL,'2023-11-20 11:28:12','2023-11-27 15:52:47'),(3296,'2023-11-20 06:30:58','2023-11-20 15:00:51','12.249.250.150','12.249.250.150','closed',8,509,'attendances/2047/1700490658 clock_in.png','attendances/2047/1700521251 clock_out.png','Juan R',42789,NULL,'2023-11-20 11:30:58','2023-11-27 15:51:57'),(3297,'2023-11-20 06:31:10','2023-11-20 15:01:06','12.249.250.150','12.249.250.150','closed',8,509,'attendances/2076/1700490670 clock_in.png','attendances/2076/1700521266 clock_out.png','Juan R',42693,NULL,'2023-11-20 11:31:10','2023-11-27 15:57:17'),(3298,'2023-11-20 06:00:46','2023-11-20 14:31:01','38.51.234.69','190.103.31.245','closed',8,510,'attendances/2133/1700491366 clock_in.png','attendances/2133/1700503261 clock_out.png','Juan R',42698,NULL,'2023-11-20 11:42:46','2023-11-27 15:53:14'),(3299,'2023-11-20 06:45:43','2023-11-20 16:06:34','12.249.250.150','12.249.250.150','closed',9,560,'attendances/1999/1700491543 clock_in.png','attendances/1999/1700525194 clock_out.png','Juan R',42708,NULL,'2023-11-20 11:45:43','2023-11-27 15:52:22'),(3300,'2023-11-20 06:46:01','2023-11-20 17:08:49','12.249.250.150','12.249.250.150','closed',10,622,'attendances/622/1700491561 clock_in.png','attendances/622/1700528929 clock_out.png','Juan R',42715,NULL,'2023-11-20 11:46:01','2023-11-27 15:57:32'),(3301,'2023-11-20 06:52:47','2023-11-20 15:32:29','12.249.250.150','12.249.250.150','closed',8,519,'attendances/1774/1700491967 clock_in.png','attendances/1774/1700523149 clock_out.png','Juan R',42706,NULL,'2023-11-20 11:52:47','2023-11-27 15:51:32'),(3302,'2023-11-20 06:52:47','2023-11-20 15:38:14','12.249.250.150','12.249.250.150','closed',8,525,'attendances/2179/1700491967 clock_in.png','attendances/2179/1700523494 clock_out.png','Juan R',42721,NULL,'2023-11-20 11:52:47','2023-11-27 15:59:35'),(3303,'2023-11-20 06:53:10','2023-11-20 15:37:59','12.249.250.150','12.249.250.150','closed',8,524,'attendances/2178/1700491990 clock_in.png','attendances/2178/1700523479 clock_out.png','Juan R',42717,NULL,'2023-11-20 11:53:10','2023-11-27 15:48:11'),(3304,'2023-11-20 06:53:16','2023-11-20 15:20:32','12.249.250.150','12.249.250.150','closed',8,507,'attendances/2005/1700491996 clock_in.png','attendances/2005/1700522432 clock_out.png','Juan R',42722,NULL,'2023-11-20 11:53:16','2023-11-27 15:54:01'),(3305,'2023-11-20 06:53:35','2023-11-20 15:32:57','12.249.250.150','12.249.250.150','closed',8,519,'attendances/1585/1700492015 clock_in.png','attendances/1585/1700523177 clock_out.png','Juan R',42703,NULL,'2023-11-20 11:53:35','2023-11-27 15:50:23'),(3306,'2023-11-20 06:54:23','2023-11-20 15:35:30','12.249.250.150','12.249.250.150','closed',8,521,'attendances/726/1700492063 clock_in.png','attendances/726/1700523330 clock_out.png','Juan R',42702,NULL,'2023-11-20 11:54:23','2023-11-27 15:22:30'),(3307,'2023-11-20 06:55:16','2023-11-20 16:00:17','12.249.250.150','12.249.250.150','closed',9,545,'attendances/1728/1700492116 clock_in.png','attendances/1728/1700524817 clock_out.png','Juan R',42710,NULL,'2023-11-20 11:55:16','2023-11-27 15:53:03'),(3308,'2023-11-20 06:55:21','2023-11-20 15:40:10','12.249.250.150','12.249.250.150','closed',8,524,'attendances/2170/1700492121 clock_in.png','attendances/2170/1700523610 clock_out.png','Juan R',42720,NULL,'2023-11-20 11:55:21','2023-11-27 15:55:51'),(3309,'2023-11-20 06:55:33','2023-11-20 16:09:10','12.249.250.150','12.249.250.150','closed',9,553,'attendances/2200/1700492133 clock_in.png','attendances/2200/1700525350 clock_out.png','Juan R',42705,NULL,'2023-11-20 11:55:33','2023-11-27 15:51:24'),(3310,'2023-11-20 06:55:38','2023-11-20 15:30:24','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1934/1700492138 clock_in.png','attendances/1934/1700523024 clock_out.png','Juan R',42709,NULL,'2023-11-20 11:55:38','2023-11-27 15:52:58'),(3311,'2023-11-20 06:55:48','2023-11-20 15:32:42','12.249.250.150','12.249.250.150','closed',8,516,'attendances/2168/1700492148 clock_in.png','attendances/2168/1700523162 clock_out.png','Juan R',42718,NULL,'2023-11-20 11:55:48','2023-11-27 15:51:48'),(3312,'2023-11-20 06:56:05','2023-11-20 16:07:46','12.249.250.150','12.249.250.150','closed',9,551,'attendances/1116/1700492165 clock_in.png','attendances/1116/1700525266 clock_out.png','Juan R',42712,NULL,'2023-11-20 11:56:05','2023-11-27 15:54:28'),(3313,'2023-11-20 06:56:22','2023-11-20 16:07:27','12.249.250.150','12.249.250.150','closed',9,551,'attendances/1479/1700492182 clock_in.png','attendances/1479/1700525247 clock_out.png','Juan R',42704,NULL,'2023-11-20 11:56:22','2023-11-27 15:51:08'),(3314,'2023-11-20 06:56:52','2023-11-20 16:10:52','12.249.250.150','12.249.250.150','closed',9,554,'attendances/1395/1700492212 clock_in.png','attendances/1395/1700525452 clock_out.png','Juan R',42713,NULL,'2023-11-20 11:56:52','2023-11-27 15:54:50'),(3315,'2023-11-20 06:57:03','2023-11-20 15:42:19','12.249.250.150','190.103.31.245','closed',8,525,'attendances/974/1700492223 clock_in.png','attendances/974/1700508859 clock_out.png','Juan R',42701,NULL,'2023-11-20 11:57:03','2023-11-27 15:22:18'),(3316,'2023-11-20 06:57:06','2023-11-20 15:34:24','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1744/1700492226 clock_in.png','attendances/1744/1700523264 clock_out.png','Juan R',42719,NULL,'2023-11-20 11:57:06','2023-11-27 15:54:34'),(3317,'2023-11-20 06:57:42','2023-11-20 15:38:33','12.249.250.150','12.249.250.150','closed',8,520,'attendances/2150/1700492262 clock_in.png','attendances/2150/1700523513 clock_out.png','Juan R',42685,NULL,'2023-11-20 11:57:42','2023-11-27 15:48:08'),(3318,'2023-11-20 06:57:48','2023-11-20 15:32:56','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1958/1700492268 clock_in.png','attendances/1958/1700523176 clock_out.png','Juan R',42707,NULL,'2023-11-20 11:57:48','2023-11-27 15:51:54'),(3319,'2023-11-20 07:02:51','2023-11-20 15:34:08','12.249.250.150','12.249.250.150','closed',8,511,'attendances/1948/1700492571 clock_in.png','attendances/1948/1700523248 clock_out.png','Juan R',42714,NULL,'2023-11-20 12:02:51','2023-11-27 15:57:07'),(3320,'2023-11-20 07:04:42','2023-11-20 15:44:45','12.249.250.150','12.249.250.150','closed',8,520,'attendances/1888/1700492682 clock_in.png','attendances/1888/1700523885 clock_out.png',NULL,42716,NULL,'2023-11-20 12:04:42','2023-11-20 20:44:45'),(3321,'2023-11-20 07:06:10','2023-11-20 15:33:17','12.249.250.150','12.249.250.150','closed',8,507,'attendances/1858/1700492770 clock_in.png','attendances/1858/1700523197 clock_out.png','Juan R',42711,NULL,'2023-11-20 12:06:10','2023-11-27 15:53:08'),(3322,'2023-11-20 08:05:37','2023-11-20 16:32:32','12.249.250.150','12.249.250.150','closed',8,506,'attendances/1869/1700496337 clock_in.png','attendances/1869/1700526752 clock_out.png','Juan R',42686,NULL,'2023-11-20 13:05:37','2023-11-27 15:51:00'),(3323,'2023-11-20 08:26:42','2023-11-20 17:00:16','12.249.250.150','12.249.250.150','closed',8,513,'attendances/775/1700497602 clock_in.png','attendances/775/1700528416 clock_out.png','Juan R',42688,NULL,'2023-11-20 13:26:42','2023-11-27 15:54:59'),(3324,'2023-11-20 08:00:40','2023-11-20 15:39:41','186.154.237.158','12.249.250.150','closed',7,459,'attendances/1462/1700498500 clock_in.png','attendances/1462/1700523581 clock_out.png','Juan R',42687,NULL,'2023-11-20 13:41:40','2023-11-27 15:52:25'),(3327,'2023-11-21 05:51:17','2023-11-21 14:26:27','12.249.250.150','12.249.250.150','closed',8,515,'attendances/622/1700574677 clock_in.png','attendances/622/1700605587 clock_out.png','Juan R',42844,NULL,'2023-11-21 10:51:17','2023-11-27 15:57:32'),(3328,'2023-11-21 05:54:06','2023-11-21 15:40:00','12.249.250.150','179.19.78.129','closed',9,585,'attendances/1999/1700574846 clock_in.png',NULL,'Juan R',42829,NULL,'2023-11-21 10:54:06','2023-11-27 15:52:22'),(3329,'2023-11-21 05:55:41','2023-11-21 15:42:00','12.249.250.150','190.103.31.245','closed',9,586,'attendances/974/1700574941 clock_in.png',NULL,'Juan R',42815,NULL,'2023-11-21 10:55:41','2023-11-27 15:22:18'),(3330,'2023-11-21 05:56:33','2023-11-21 14:32:22','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1585/1700574993 clock_in.png','attendances/1585/1700605942 clock_out.png','Juan R',42814,NULL,'2023-11-21 10:56:33','2023-11-27 15:50:23'),(3331,'2023-11-21 06:46:17','2023-11-21 17:56:59','12.249.250.150','12.249.250.150','closed',11,670,'attendances/2005/1700577977 clock_in.png','attendances/2005/1700618219 clock_out.png','Juan R',42835,NULL,'2023-11-21 11:46:17','2023-11-27 15:54:01'),(3332,'2023-11-21 06:46:48','2023-11-21 15:30:00','12.249.250.150','179.19.78.129','closed',8,523,'attendances/2094/1700578008 clock_in.png',NULL,'Juan R',42842,NULL,'2023-11-21 11:46:48','2023-11-27 15:57:11'),(3333,'2023-11-21 06:52:42','2023-11-21 18:01:38','12.249.250.150','12.249.250.150','closed',11,668,'attendances/726/1700578362 clock_in.png','attendances/726/1700618498 clock_out.png','Juan R',42816,NULL,'2023-11-21 11:52:42','2023-11-27 15:22:30'),(3334,'2023-11-21 06:52:59','2023-11-21 17:00:43','12.249.250.150','12.249.250.150','closed',10,607,'attendances/2169/1700578379 clock_in.png','attendances/2169/1700614843 clock_out.png','Juan R',42821,NULL,'2023-11-21 11:52:59','2023-11-27 15:51:18'),(3335,'2023-11-21 06:53:16','2023-11-21 15:36:30','12.249.250.150','12.249.250.150','closed',8,523,'attendances/1568/1700578396 clock_in.png','attendances/1568/1700609790 clock_out.png','Juan R',42818,NULL,'2023-11-21 11:53:16','2023-11-27 15:50:43'),(3336,'2023-11-21 06:53:19','2023-11-21 15:43:45','12.249.250.150','12.249.250.150','closed',8,530,'attendances/1395/1700578399 clock_in.png','attendances/1395/1700610225 clock_out.png','Juan R',42839,NULL,'2023-11-21 11:53:19','2023-11-27 15:54:50'),(3337,'2023-11-21 06:53:28','2023-11-21 15:32:03','12.249.250.150','12.249.250.150','closed',8,518,'attendances/1774/1700578408 clock_in.png','attendances/1774/1700609523 clock_out.png','Juan R',42824,NULL,'2023-11-21 11:53:28','2023-11-27 15:51:32'),(3338,'2023-11-21 06:53:53','2023-11-21 15:53:37','12.249.250.150','12.249.250.150','closed',8,539,'attendances/1479/1700578433 clock_in.png','attendances/1479/1700610817 clock_out.png','Juan R',42820,NULL,'2023-11-21 11:53:53','2023-11-27 15:51:08'),(3339,'2023-11-21 06:54:08','2023-11-21 16:35:06','12.249.250.150','12.249.250.150','closed',9,580,'attendances/1116/1700578448 clock_in.png','attendances/1116/1700613306 clock_out.png','Juan R',42836,NULL,'2023-11-21 11:54:08','2023-11-27 15:54:28'),(3340,'2023-11-21 06:54:35','2023-11-21 15:31:11','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1934/1700578475 clock_in.png','attendances/1934/1700609471 clock_out.png','Juan R',42831,NULL,'2023-11-21 11:54:35','2023-11-27 15:52:58'),(3341,'2023-11-21 06:55:25','2023-11-21 15:31:42','12.249.250.150','12.249.250.150','closed',8,516,'attendances/2008/1700578525 clock_in.png','attendances/2008/1700609502 clock_out.png','Juan R',42828,NULL,'2023-11-21 11:55:25','2023-11-27 15:52:01'),(3342,'2023-11-21 06:55:27','2023-11-21 15:32:21','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1744/1700578527 clock_in.png','attendances/1744/1700609541 clock_out.png','Juan R',42837,NULL,'2023-11-21 11:55:27','2023-11-27 15:54:34'),(3343,'2023-11-21 06:55:35','2023-11-21 15:32:34','12.249.250.150','12.249.250.150','closed',8,516,'attendances/2168/1700578535 clock_in.png','attendances/2168/1700609554 clock_out.png','Juan R',42825,NULL,'2023-11-21 11:55:35','2023-11-27 15:51:48'),(3344,'2023-11-21 06:55:48','2023-11-21 15:31:27','12.249.250.150','12.249.250.150','closed',8,515,'attendances/2047/1700578548 clock_in.png','attendances/2047/1700609487 clock_out.png','Juan R',42827,NULL,'2023-11-21 11:55:48','2023-11-27 15:51:57'),(3345,'2023-11-21 06:55:59','2023-11-21 15:31:27','12.249.250.150','12.249.250.150','closed',8,515,'attendances/2061/1700578559 clock_in.png','attendances/2061/1700609487 clock_out.png','Juan R',42830,NULL,'2023-11-21 11:55:59','2023-11-27 15:52:52'),(3346,'2023-11-21 06:56:32','2023-11-21 15:30:47','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1450/1700578592 clock_in.png','attendances/1450/1700609447 clock_out.png','Juan R',42843,NULL,'2023-11-21 11:56:32','2023-11-27 15:57:15'),(3347,'2023-11-21 06:56:40','2023-11-21 16:23:21','12.249.250.150','12.249.250.150','closed',9,566,'attendances/2200/1700578600 clock_in.png','attendances/2200/1700612601 clock_out.png','Juan R',42823,NULL,'2023-11-21 11:56:40','2023-11-27 15:51:24'),(3348,'2023-11-21 06:56:52','2023-11-21 15:30:16','12.249.250.150','12.249.250.150','closed',8,513,'attendances/2116/1700578612 clock_in.png','attendances/2116/1700609416 clock_out.png','Juan R',42819,NULL,'2023-11-21 11:56:52','2023-11-27 15:51:05'),(3349,'2023-11-21 06:57:12','2023-11-21 15:52:44','12.249.250.150','12.249.250.150','closed',8,535,'attendances/1728/1700578632 clock_in.png','attendances/1728/1700610764 clock_out.png','Juan R',42832,NULL,'2023-11-21 11:57:12','2023-11-27 15:53:03'),(3350,'2023-11-21 06:57:15','2023-11-21 15:33:54','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1958/1700578635 clock_in.png','attendances/1958/1700609634 clock_out.png','Juan R',42826,NULL,'2023-11-21 11:57:15','2023-11-27 15:51:54'),(3351,'2023-11-21 06:59:09','2023-11-21 15:30:36','12.249.250.150','179.19.78.129','closed',8,511,'attendances/2133/1700578749 clock_in.png','attendances/2133/1700593236 clock_out.png','Juan R',42834,NULL,'2023-11-21 11:59:09','2023-11-27 15:53:14'),(3352,'2023-11-21 06:59:16','2023-11-21 15:42:56','12.249.250.150','12.249.250.150','closed',8,523,'attendances/2151/1700578756 clock_in.png','attendances/2151/1700610176 clock_out.png','Juan R',42838,NULL,'2023-11-21 11:59:16','2023-11-27 15:54:38'),(3353,'2023-11-21 06:59:23','2023-11-21 15:53:02','12.249.250.150','12.249.250.150','closed',8,533,'attendances/2170/1700578763 clock_in.png','attendances/2170/1700610782 clock_out.png','Juan R',42840,NULL,'2023-11-21 11:59:23','2023-11-27 15:55:51'),(3354,'2023-11-21 06:59:45','2023-11-21 15:30:57','12.249.250.150','12.249.250.150','closed',8,511,'attendances/1951/1700578785 clock_in.png','attendances/1951/1700609457 clock_out.png','Juan R',42822,NULL,'2023-11-21 11:59:45','2023-11-27 15:51:14'),(3355,'2023-11-21 06:59:49','2023-11-21 15:42:30','12.249.250.150','12.249.250.150','closed',8,522,'attendances/2150/1700578789 clock_in.png','attendances/2150/1700610150 clock_out.png','Juan R',42817,NULL,'2023-11-21 11:59:49','2023-11-27 15:48:08'),(3356,'2023-11-21 07:02:43','2023-11-21 16:02:17','12.249.250.150','190.103.31.245','closed',8,539,'attendances/1948/1700578963 clock_in.png','attendances/1948/1700610137 clock_out.png','Juan R',42841,NULL,'2023-11-21 12:02:43','2023-11-27 15:57:07'),(3357,'2023-11-21 07:06:00','2023-11-21 15:34:13','12.249.250.150','12.249.250.150','closed',8,508,'attendances/1858/1700579160 clock_in.png','attendances/1858/1700609653 clock_out.png','Juan R',42833,NULL,'2023-11-21 12:06:00','2023-11-27 15:53:08'),(3358,'2023-11-21 07:08:45','2023-11-21 15:49:06','12.249.250.150','12.249.250.150','closed',8,520,'attendances/1888/1700579325 clock_in.png','attendances/1888/1700610546 clock_out.png',NULL,42845,NULL,'2023-11-21 12:08:45','2023-11-21 20:49:06'),(3359,'2023-11-21 08:26:19','2023-11-21 17:00:22','12.249.250.150','12.249.250.150','closed',8,514,'attendances/775/1700583979 clock_in.png','attendances/775/1700614822 clock_out.png','Juan R',42847,NULL,'2023-11-21 13:26:19','2023-11-27 15:54:59'),(3360,'2023-11-21 08:29:08','2023-11-21 17:08:00','12.249.250.150','179.19.78.129','closed',8,518,'attendances/1891/1700584148 clock_in.png',NULL,'Juan R',42848,NULL,'2023-11-21 13:29:08','2023-11-27 15:55:57'),(3361,'2023-11-21 08:29:41','2023-11-21 17:01:00','12.249.250.150','179.19.78.129','closed',8,511,'attendances/1869/1700584181 clock_in.png',NULL,'Juan R',42846,NULL,'2023-11-21 13:29:41','2023-11-27 15:51:00'),(3364,'2023-11-22 06:41:06','2023-11-22 15:31:18','12.249.250.150','12.249.250.150','closed',8,530,'attendances/622/1700664066 clock_in.png','attendances/622/1700695878 clock_out.png','Juan R',42916,NULL,'2023-11-22 11:41:06','2023-11-27 15:57:32'),(3365,'2023-11-22 06:51:08','2023-11-22 15:51:38','12.249.250.150','12.249.250.150','closed',9,540,'attendances/1999/1700664668 clock_in.png','attendances/1999/1700697098 clock_out.png','Juan R',42908,NULL,'2023-11-22 11:51:08','2023-11-27 15:52:22'),(3366,'2023-11-22 06:51:50','2023-11-22 15:39:14','12.249.250.150','12.249.250.150','closed',8,527,'attendances/2094/1700664710 clock_in.png','attendances/2094/1700696354 clock_out.png','Juan R',42923,NULL,'2023-11-22 11:51:50','2023-11-27 15:57:11'),(3367,'2023-11-22 06:52:57','2023-11-22 15:29:37','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1585/1700664777 clock_in.png','attendances/1585/1700695777 clock_out.png','Juan R',42901,NULL,'2023-11-22 11:52:57','2023-11-27 15:50:23'),(3368,'2023-11-22 06:53:12','2023-11-22 15:31:09','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1774/1700664792 clock_in.png','attendances/1774/1700695869 clock_out.png','Juan R',42906,NULL,'2023-11-22 11:53:12','2023-11-27 15:51:32'),(3370,'2023-11-22 06:54:19','2023-11-22 15:30:57','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1934/1700664859 clock_in.png','attendances/1934/1700695857 clock_out.png','Juan R',42910,NULL,'2023-11-22 11:54:19','2023-11-27 15:52:58'),(3371,'2023-11-22 06:55:12','2023-11-22 15:31:40','12.249.250.150','12.249.250.150','closed',8,516,'attendances/2168/1700664912 clock_in.png','attendances/2168/1700695900 clock_out.png','Juan R',42927,NULL,'2023-11-22 11:55:12','2023-11-27 15:51:48'),(3372,'2023-11-22 06:55:22','2023-11-22 15:41:22','12.249.250.150','12.249.250.150','closed',8,526,'attendances/1116/1700664922 clock_in.png','attendances/1116/1700696482 clock_out.png','Juan R',42913,NULL,'2023-11-22 11:55:22','2023-11-27 15:54:28'),(3373,'2023-11-22 06:55:39','2023-11-22 15:43:20','12.249.250.150','12.249.250.150','closed',8,527,'attendances/1479/1700664939 clock_in.png','attendances/1479/1700696600 clock_out.png','Juan R',42903,NULL,'2023-11-22 11:55:39','2023-11-27 15:51:08'),(3374,'2023-11-22 06:55:49','2023-11-22 15:31:51','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1744/1700664949 clock_in.png','attendances/1744/1700695911 clock_out.png','Juan R',42921,NULL,'2023-11-22 11:55:49','2023-11-27 15:54:34'),(3375,'2023-11-22 06:56:13','2023-11-22 15:29:27','12.249.250.150','12.249.250.150','closed',8,513,'attendances/2116/1700664973 clock_in.png','attendances/2116/1700695767 clock_out.png','Juan R',42919,NULL,'2023-11-22 11:56:13','2023-11-27 15:51:05'),(3376,'2023-11-22 06:56:29','2023-11-22 15:29:53','12.249.250.150','12.249.250.150','closed',8,513,'attendances/2133/1700664989 clock_in.png','attendances/2133/1700695793 clock_out.png','Juan R',42920,NULL,'2023-11-22 11:56:29','2023-11-27 15:53:14'),(3377,'2023-11-22 06:56:44','2023-11-22 15:36:32','12.249.250.150','12.249.250.150','closed',8,519,'attendances/2170/1700665004 clock_in.png','attendances/2170/1700696192 clock_out.png','Juan R',42922,NULL,'2023-11-22 11:56:44','2023-11-27 15:55:51'),(3378,'2023-11-22 06:56:55','2023-11-22 15:45:27','12.249.250.150','12.249.250.150','closed',8,528,'attendances/974/1700665015 clock_in.png','attendances/974/1700696727 clock_out.png','Juan R',42900,NULL,'2023-11-22 11:56:55','2023-11-27 15:22:18'),(3379,'2023-11-22 06:56:57','2023-11-22 15:30:08','12.249.250.150','12.249.250.150','closed',8,513,'attendances/1568/1700665017 clock_in.png','attendances/1568/1700695808 clock_out.png','Juan R',42902,NULL,'2023-11-22 11:56:57','2023-11-27 15:50:43'),(3380,'2023-11-22 06:57:09','2023-11-22 15:45:00','12.249.250.150','190.103.31.245','closed',8,527,'attendances/1728/1700665029 clock_in.png',NULL,'Juan R',42911,NULL,'2023-11-22 11:57:09','2023-11-27 15:53:03'),(3381,'2023-11-22 06:57:21','2023-11-22 15:40:56','12.249.250.150','12.249.250.150','closed',8,523,'attendances/2200/1700665041 clock_in.png','attendances/2200/1700696456 clock_out.png','Juan R',42905,NULL,'2023-11-22 11:57:21','2023-11-27 15:51:24'),(3382,'2023-11-22 06:57:57','2023-11-22 15:50:32','12.249.250.150','12.249.250.150','closed',8,532,'attendances/1395/1700665077 clock_in.png','attendances/1395/1700697032 clock_out.png','Juan R',42914,NULL,'2023-11-22 11:57:57','2023-11-27 15:54:50'),(3383,'2023-11-22 06:59:28','2023-11-22 15:35:48','12.249.250.150','12.249.250.150','closed',8,516,'attendances/2150/1700665168 clock_in.png','attendances/2150/1700696148 clock_out.png','Juan R',42918,NULL,'2023-11-22 11:59:28','2023-11-27 15:48:08'),(3384,'2023-11-22 07:00:06','2023-11-22 15:32:24','12.249.250.150','12.249.250.150','closed',8,512,'attendances/1958/1700665206 clock_in.png','attendances/1958/1700695944 clock_out.png','Juan R',42907,NULL,'2023-11-22 12:00:06','2023-11-27 15:51:54'),(3385,'2023-11-22 07:00:32','2023-11-22 15:36:04','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1462/1700665232 clock_in.png','attendances/1462/1700696164 clock_out.png','Juan R',42909,NULL,'2023-11-22 12:00:32','2023-11-27 15:52:25'),(3386,'2023-11-22 07:01:38','2023-11-22 15:30:32','12.249.250.150','12.249.250.150','closed',8,508,'attendances/1951/1700665298 clock_in.png','attendances/1951/1700695833 clock_out.png','Juan R',42904,NULL,'2023-11-22 12:01:38','2023-11-27 15:51:14'),(3387,'2023-11-22 07:05:16','2023-11-22 15:45:09','12.249.250.150','12.249.250.150','closed',8,519,'attendances/1888/1700665516 clock_in.png','attendances/1888/1700696709 clock_out.png',NULL,42917,NULL,'2023-11-22 12:05:16','2023-11-22 20:45:09'),(3388,'2023-11-22 07:05:29','2023-11-22 16:12:00','12.249.250.150','12.249.250.150','closed',9,546,'attendances/1948/1700665529 clock_in.png','attendances/1948/1700698320 clock_out.png','Juan R',42915,NULL,'2023-11-22 12:05:29','2023-11-27 15:57:07'),(3389,'2023-11-22 07:06:48','2023-11-22 15:32:37','12.249.250.150','12.249.250.150','closed',8,505,'attendances/1858/1700665608 clock_in.png','attendances/1858/1700695957 clock_out.png','Juan R',42912,NULL,'2023-11-22 12:06:48','2023-11-27 15:53:08'),(3390,'2023-11-22 06:53:00','2023-11-22 15:27:34','38.51.234.69','12.249.250.150','closed',8,514,NULL,'attendances/1551/1700695654 clock_out.png','Juan R',42928,NULL,'2023-11-22 12:46:19','2023-11-27 15:23:10'),(3391,'2023-11-22 08:26:49','2023-11-22 17:00:00','12.249.250.150','190.103.31.245','closed',8,513,'attendances/775/1700670409 clock_in.png',NULL,'Juan R',42925,NULL,'2023-11-22 13:26:49','2023-11-27 15:54:59'),(3392,'2023-11-22 08:32:38','2023-11-22 17:00:00','12.249.250.150','190.103.31.245','closed',8,507,'attendances/1869/1700670758 clock_in.png',NULL,'Juan R',42924,NULL,'2023-11-22 13:32:38','2023-11-27 15:51:00'),(3393,'2023-11-22 08:33:12','2023-11-22 17:00:00','12.249.250.150','190.103.31.245','closed',8,506,'attendances/1891/1700670792 clock_in.png',NULL,'Juan R',42926,NULL,'2023-11-22 13:33:12','2023-11-27 15:55:57'),(3394,'2023-11-25 04:57:56','2023-11-25 13:27:35','12.249.250.150','12.249.250.150','closed',8,509,'attendances/1585/1700917076 clock_in.png','attendances/1585/1700947655 clock_out.png','Juan R',42965,NULL,'2023-11-25 09:57:56','2023-11-27 15:50:23'),(3395,'2023-11-25 04:58:16','2023-11-25 13:27:06','12.249.250.150','12.249.250.150','closed',8,508,'attendances/1551/1700917096 clock_in.png','attendances/1551/1700947626 clock_out.png','Juan R',42964,NULL,'2023-11-25 09:58:16','2023-11-27 15:23:10'),(3396,'2023-11-25 07:47:40','2023-11-25 12:32:04','190.103.31.245','12.249.250.150','closed',4,284,'attendances/1116/1700928040 clock_in.png','attendances/1116/1700944324 clock_out.png','Juan R',43022,NULL,'2023-11-25 13:00:40','2023-11-27 15:54:28'),(3397,'2023-11-26 05:55:26','2023-11-26 12:34:50','12.249.250.150','12.249.250.150','closed',6,399,'attendances/1585/1701006926 clock_in.png','attendances/1585/1701030890 clock_out.png','Juan R',42967,NULL,'2023-11-26 10:55:26','2023-11-27 15:50:23'),(3398,'2023-11-26 05:57:17','2023-11-26 12:33:48','12.249.250.150','12.249.250.150','closed',6,396,'attendances/1551/1701007037 clock_in.png','attendances/1551/1701030828 clock_out.png','Juan R',42966,NULL,'2023-11-26 10:57:17','2023-11-27 15:23:10'),(3399,'2023-11-27 05:53:05','2023-11-27 17:35:20','12.249.250.150','12.249.250.150','closed',11,702,'attendances/2222/1701093185 clock_in.png','attendances/2222/1701135320 clock_out.png','Juan R',42941,NULL,'2023-11-27 10:53:05','2023-12-04 17:51:09'),(3400,'2023-11-27 05:53:20','2023-11-27 16:41:56','12.249.250.150','12.249.250.150','closed',10,648,'attendances/1585/1701093200 clock_in.png','attendances/1585/1701132116 clock_out.png','Juan R',42931,NULL,'2023-11-27 10:53:20','2023-12-04 17:39:24'),(3401,'2023-11-27 05:53:25','2023-11-27 16:45:51','12.249.250.150','12.249.250.150','closed',10,652,'attendances/2005/1701093205 clock_in.png','attendances/2005/1701132351 clock_out.png','Juan R',42938,NULL,'2023-11-27 10:53:25','2023-12-04 17:45:42'),(3402,'2023-11-27 05:53:35','2023-11-27 17:45:58','12.249.250.150','12.249.250.150','closed',11,712,'attendances/1551/1701093215 clock_in.png','attendances/1551/1701135958 clock_out.png','Juan R',42930,NULL,'2023-11-27 10:53:35','2023-12-04 17:39:09'),(3403,'2023-11-27 05:55:41','2023-11-27 16:36:23','12.249.250.150','12.249.250.150','closed',10,640,'attendances/726/1701093341 clock_in.png','attendances/726/1701131783 clock_out.png','Juan R',42929,NULL,'2023-11-27 10:55:41','2023-12-04 17:39:08'),(3404,'2023-11-27 05:56:15','2023-11-27 15:22:03','12.249.250.150','12.249.250.150','closed',9,565,'attendances/2116/1701093375 clock_in.png','attendances/2116/1701127323 clock_out.png','Juan R',42933,NULL,'2023-11-27 10:56:15','2023-12-04 17:41:15'),(3405,'2023-11-27 05:56:36','2023-11-27 15:31:16','12.249.250.150','12.249.250.150','closed',9,574,'attendances/1568/1701093396 clock_in.png','attendances/1568/1701127876 clock_out.png','Juan R',42932,NULL,'2023-11-27 10:56:36','2023-12-04 17:39:30'),(3406,'2023-11-27 05:57:40','2023-11-27 15:48:28','12.249.250.150','12.249.250.150','closed',9,590,'attendances/1479/1701093460 clock_in.png','attendances/1479/1701128908 clock_out.png','Juan R',42934,NULL,'2023-11-27 10:57:40','2023-12-04 17:41:23'),(3407,'2023-11-27 05:58:01','2023-11-27 15:46:16','12.249.250.150','12.249.250.150','closed',9,588,'attendances/1116/1701093481 clock_in.png','attendances/1116/1701128776 clock_out.png','Juan R',42939,NULL,'2023-11-27 10:58:01','2023-12-04 17:45:46'),(3408,'2023-11-27 05:59:52','2023-11-27 15:23:27','12.249.250.150','12.249.250.150','closed',9,563,'attendances/1450/1701093592 clock_in.png','attendances/1450/1701127407 clock_out.png','Juan R',42940,NULL,'2023-11-27 10:59:52','2023-12-04 17:51:03'),(3409,'2023-11-27 06:00:14','2023-11-27 16:41:31','12.249.250.150','12.249.250.150','closed',10,641,'attendances/1951/1701093614 clock_in.png','attendances/1951/1701132091 clock_out.png','Juan R',42935,NULL,'2023-11-27 11:00:14','2023-12-04 17:41:27'),(3410,'2023-11-27 06:00:48','2023-11-27 16:40:56','12.249.250.150','12.249.250.150','closed',10,640,'attendances/2218/1701093648 clock_in.png','attendances/2218/1701132056 clock_out.png','Juan R',42936,NULL,'2023-11-27 11:00:48','2023-12-04 17:45:02'),(3411,'2023-11-27 06:02:21','2023-11-27 14:30:00','12.249.250.150','190.103.31.245','closed',8,507,'attendances/2133/1701093741 clock_in.png',NULL,'Juan R',42937,NULL,'2023-11-27 11:02:21','2023-12-04 17:45:36'),(3412,'2023-11-27 06:46:07','2023-11-27 15:33:22','12.249.250.150','12.249.250.150','closed',8,527,'attendances/622/1701096367 clock_in.png','attendances/622/1701128002 clock_out.png','Juan R',42959,NULL,'2023-11-27 11:46:07','2023-12-04 17:51:13'),(3413,'2023-11-27 06:52:46','2023-11-27 15:30:03','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1774/1701096766 clock_in.png','attendances/1774/1701127803 clock_out.png','Juan R',42944,NULL,'2023-11-27 11:52:46','2023-12-04 17:42:11'),(3414,'2023-11-27 06:53:14','2023-11-27 15:25:53','12.249.250.150','12.249.250.150','closed',8,512,'attendances/2178/1701096794 clock_in.png','attendances/2178/1701127553 clock_out.png','Juan R',42958,NULL,'2023-11-27 11:53:14','2023-12-04 17:39:21'),(3415,'2023-11-27 06:54:26','2023-11-27 16:08:22','12.249.250.150','12.249.250.150','closed',9,553,'attendances/1728/1701096866 clock_in.png','attendances/1728/1701130102 clock_out.png','Juan R',42952,NULL,'2023-11-27 11:54:26','2023-12-04 17:45:28'),(3416,'2023-11-27 06:54:59','2023-11-27 18:14:20','12.249.250.150','12.249.250.150','closed',11,679,'attendances/2061/1701096899 clock_in.png','attendances/2061/1701137660 clock_out.png','Juan R',42950,NULL,'2023-11-27 11:54:59','2023-12-04 17:45:14'),(3417,'2023-11-27 06:55:07','2023-11-27 15:31:56','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1934/1701096907 clock_in.png','attendances/1934/1701127916 clock_out.png','Juan R',42951,NULL,'2023-11-27 11:55:07','2023-12-04 17:45:17'),(3418,'2023-11-27 06:55:31','2023-11-27 18:13:42','12.249.250.150','12.249.250.150','closed',11,678,'attendances/2047/1701096931 clock_in.png','attendances/2047/1701137622 clock_out.png','Juan R',42947,NULL,'2023-11-27 11:55:31','2023-12-04 17:44:26'),(3419,'2023-11-27 06:55:43','2023-11-27 15:30:34','12.249.250.150','12.249.250.150','closed',8,514,'attendances/2168/1701096943 clock_in.png','attendances/2168/1701127834 clock_out.png','Juan R',42945,NULL,'2023-11-27 11:55:43','2023-12-04 17:44:17'),(3420,'2023-11-27 06:55:46','2023-11-27 16:00:00','12.249.250.150','190.103.31.245','closed',9,544,'attendances/2094/1701096946 clock_in.png',NULL,'Juan R',42957,NULL,'2023-11-27 11:55:46','2023-12-04 17:50:39'),(3421,'2023-11-27 06:55:57','2023-11-27 15:46:29','12.249.250.150','12.249.250.150','closed',8,530,'attendances/1999/1701096957 clock_in.png','attendances/1999/1701128789 clock_out.png','Juan R',42948,NULL,'2023-11-27 11:55:57','2023-12-04 17:44:54'),(3422,'2023-11-27 06:56:36','2023-11-27 15:34:26','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1858/1701096996 clock_in.png','attendances/1858/1701128066 clock_out.png','Juan R',42953,NULL,'2023-11-27 11:56:36','2023-12-04 17:45:32'),(3423,'2023-11-27 06:56:48','2023-11-27 15:30:19','12.249.250.150','12.249.250.150','closed',8,513,'attendances/1958/1701097008 clock_in.png','attendances/1958/1701127819 clock_out.png','Juan R',42946,NULL,'2023-11-27 11:56:48','2023-12-04 17:44:21'),(3424,'2023-11-27 06:57:23','2023-11-27 17:52:43','12.249.250.150','12.249.250.150','closed',10,655,'attendances/2150/1701097043 clock_in.png','attendances/2150/1701136363 clock_out.png','Juan R',42943,NULL,'2023-11-27 11:57:23','2023-12-04 17:39:17'),(3425,'2023-11-27 06:57:27','2023-11-27 16:05:24','12.249.250.150','12.249.250.150','closed',9,547,'attendances/1395/1701097047 clock_in.png','attendances/1395/1701129924 clock_out.png','Juan R',42955,NULL,'2023-11-27 11:57:27','2023-12-04 17:45:56'),(3426,'2023-11-27 06:58:30','2023-11-27 15:30:55','12.249.250.150','12.249.250.150','closed',8,512,'attendances/1744/1701097110 clock_in.png','attendances/1744/1701127855 clock_out.png','Juan R',42954,NULL,'2023-11-27 11:58:30','2023-12-04 17:45:49'),(3427,'2023-11-27 06:59:39','2023-11-27 15:40:08','12.249.250.150','12.249.250.150','closed',8,520,'attendances/974/1701097179 clock_in.png','attendances/974/1701128408 clock_out.png','Juan R',42942,NULL,'2023-11-27 11:59:39','2023-12-04 17:27:10'),(3428,'2023-11-27 07:06:08','2023-11-27 15:40:39','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1888/1701097568 clock_in.png','attendances/1888/1701128439 clock_out.png','Juan R',42960,NULL,'2023-11-27 12:06:09','2023-12-04 17:51:21'),(3429,'2023-11-27 07:06:53','2023-11-27 15:40:25','12.249.250.150','12.249.250.150','closed',8,513,'attendances/1948/1701097613 clock_in.png','attendances/1948/1701128425 clock_out.png','Juan R',42956,NULL,'2023-11-27 12:06:53','2023-12-04 17:50:20'),(3430,'2023-11-27 07:56:09','2023-11-27 16:30:12','12.249.250.150','12.249.250.150','closed',8,514,'attendances/775/1701100569 clock_in.png','attendances/775/1701131412 clock_out.png','Juan R',42962,NULL,'2023-11-27 12:56:09','2023-12-04 17:46:00'),(3431,'2023-11-27 07:57:51','2023-11-27 16:33:08','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1869/1701100671 clock_in.png','attendances/1869/1701131588 clock_out.png','Juan R',42961,NULL,'2023-11-27 12:57:51','2023-12-04 17:40:22'),(3432,'2023-11-27 08:07:09','2023-11-27 15:39:12','12.249.250.150','12.249.250.150','closed',7,452,'attendances/1462/1701101229 clock_in.png','attendances/1462/1701128352 clock_out.png','Juan R',42949,NULL,'2023-11-27 13:07:10','2023-12-04 17:44:58'),(3433,'2023-11-27 08:00:33','2023-11-27 16:34:13','186.154.237.158','38.51.234.69','closed',8,513,'attendances/1891/1701117153 clock_in.png','attendances/1891/1701131653 clock_out.png','Juan R',42963,NULL,'2023-11-27 17:32:33','2023-12-04 17:50:10'),(3434,'2023-11-28 05:54:30','2023-11-28 15:02:48','12.249.250.150','12.249.250.150','closed',9,548,'attendances/726/1701179670 clock_in.png','attendances/726/1701212568 clock_out.png','Juan R',43023,NULL,'2023-11-28 10:54:30','2023-12-04 17:39:08'),(3435,'2023-11-28 05:55:12','2023-11-28 15:32:16','12.249.250.150','12.249.250.150','closed',9,577,'attendances/1728/1701179712 clock_in.png','attendances/1728/1701214336 clock_out.png','Juan R',43043,NULL,'2023-11-28 10:55:12','2023-12-04 17:45:28'),(3436,'2023-11-28 05:56:09','2023-11-28 14:57:59','12.249.250.150','12.249.250.150','closed',9,541,'attendances/2169/1701179769 clock_in.png','attendances/2169/1701212279 clock_out.png','Juan R',43026,NULL,'2023-11-28 10:56:09','2023-12-04 17:41:42'),(3437,'2023-11-28 05:56:44','2023-11-28 14:58:39','12.249.250.150','12.249.250.150','closed',9,541,'attendances/1551/1701179805 clock_in.png','attendances/1551/1701212319 clock_out.png','Juan R',43024,NULL,'2023-11-28 10:56:45','2023-12-04 17:39:09'),(3438,'2023-11-28 05:56:56','2023-11-28 15:30:32','12.249.250.150','12.249.250.150','closed',9,573,'attendances/1395/1701179816 clock_in.png','attendances/1395/1701214233 clock_out.png','Juan R',43048,NULL,'2023-11-28 10:56:56','2023-12-04 17:45:56'),(3439,'2023-11-28 05:56:58','2023-11-28 19:04:01','12.249.250.150','12.249.250.150','closed',13,787,'attendances/2005/1701179819 clock_in.png','attendances/2005/1701227041 clock_out.png','Juan R',43046,NULL,'2023-11-28 10:56:59','2023-12-04 17:45:42'),(3440,'2023-11-28 05:57:38','2023-11-28 15:01:17','12.249.250.150','12.249.250.150','closed',9,543,'attendances/2222/1701179858 clock_in.png','attendances/2222/1701212477 clock_out.png','Juan R',43029,NULL,'2023-11-28 10:57:38','2023-12-04 17:51:09'),(3441,'2023-11-28 05:58:26','2023-11-28 15:29:55','12.249.250.150','12.249.250.150','closed',9,571,'attendances/1116/1701179906 clock_in.png','attendances/1116/1701214195 clock_out.png','Juan R',43028,NULL,'2023-11-28 10:58:26','2023-12-04 17:45:46'),(3442,'2023-11-28 05:58:33','2023-11-28 14:58:24','12.249.250.150','12.249.250.150','closed',8,539,'attendances/2218/1701179913 clock_in.png','attendances/2218/1701212304 clock_out.png','Juan R',43027,NULL,'2023-11-28 10:58:33','2023-12-04 17:45:02'),(3443,'2023-11-28 06:17:14','2023-11-28 15:29:09','12.249.250.150','12.249.250.150','closed',9,551,'attendances/2094/1701181034 clock_in.png','attendances/2094/1701214149 clock_out.png','Juan R',43030,NULL,'2023-11-28 11:17:14','2023-12-04 17:50:39'),(3444,'2023-11-28 06:38:10','2023-11-28 15:32:09','12.249.250.150','12.249.250.150','closed',8,533,'attendances/622/1701182290 clock_in.png','attendances/622/1701214329 clock_out.png','Juan R',43052,NULL,'2023-11-28 11:38:10','2023-12-04 17:51:13'),(3445,'2023-11-28 06:52:18','2023-11-28 15:31:09','12.249.250.150','12.249.250.150','closed',8,518,'attendances/1774/1701183138 clock_in.png','attendances/1774/1701214269 clock_out.png','Juan R',43036,NULL,'2023-11-28 11:52:18','2023-12-04 17:42:11'),(3446,'2023-11-28 06:53:06','2023-11-28 13:25:50','12.249.250.150','12.249.250.150','closed',6,392,'attendances/1999/1701183186 clock_in.png','attendances/1999/1701206750 clock_out.png','Juan R',43040,NULL,'2023-11-28 11:53:06','2023-12-04 17:44:54'),(3447,'2023-11-28 06:55:08','2023-11-28 15:31:49','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1585/1701183308 clock_in.png','attendances/1585/1701214309 clock_out.png','Juan R',43032,NULL,'2023-11-28 11:55:08','2023-12-04 17:39:24'),(3448,'2023-11-28 06:55:15','2023-11-28 15:33:12','12.249.250.150','12.249.250.150','closed',8,517,'attendances/2008/1701183315 clock_in.png','attendances/2008/1701214392 clock_out.png','Juan R',43039,NULL,'2023-11-28 11:55:15','2023-12-04 17:44:49'),(3449,'2023-11-28 06:55:20','2023-11-28 15:30:20','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1934/1701183320 clock_in.png','attendances/1934/1701214220 clock_out.png','Juan R',43042,NULL,'2023-11-28 11:55:20','2023-12-04 17:45:17'),(3450,'2023-11-28 06:55:32','2023-11-28 15:32:00','12.249.250.150','12.249.250.150','closed',8,516,'attendances/2168/1701183332 clock_in.png','attendances/2168/1701214320 clock_out.png','Juan R',43037,NULL,'2023-11-28 11:55:32','2023-12-04 17:44:17'),(3451,'2023-11-28 06:55:50','2023-11-28 16:10:27','12.249.250.150','12.249.250.150','closed',9,554,'attendances/2116/1701183350 clock_in.png','attendances/2116/1701216627 clock_out.png','Juan R',43025,NULL,'2023-11-28 11:55:50','2023-12-04 17:41:15'),(3452,'2023-11-28 06:56:11','2023-11-28 15:31:37','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1568/1701183371 clock_in.png','attendances/1568/1701214297 clock_out.png','Juan R',43033,NULL,'2023-11-28 11:56:11','2023-12-04 17:39:30'),(3453,'2023-11-28 06:56:28','2023-11-28 15:32:33','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1744/1701183388 clock_in.png','attendances/1744/1701214353 clock_out.png','Juan R',43047,NULL,'2023-11-28 11:56:28','2023-12-04 17:45:49'),(3454,'2023-11-28 06:56:48','2023-11-28 16:10:56','12.249.250.150','12.249.250.150','closed',9,554,'attendances/1450/1701183408 clock_in.png','attendances/1450/1701216656 clock_out.png','Juan R',43050,NULL,'2023-11-28 11:56:48','2023-12-04 17:51:03'),(3455,'2023-11-28 06:56:52','2023-11-28 15:38:57','12.249.250.150','12.249.250.150','closed',8,522,'attendances/1951/1701183412 clock_in.png','attendances/1951/1701214737 clock_out.png','Juan R',43034,NULL,'2023-11-28 11:56:52','2023-12-04 17:41:27'),(3456,'2023-11-28 06:57:05','2023-11-28 15:36:15','12.249.250.150','12.249.250.150','closed',8,519,'attendances/2200/1701183425 clock_in.png','attendances/2200/1701214575 clock_out.png','Juan R',43035,NULL,'2023-11-28 11:57:05','2023-12-04 17:41:46'),(3457,'2023-11-28 06:57:31','2023-11-28 15:30:04','12.249.250.150','12.249.250.150','closed',8,512,'attendances/2076/1701183451 clock_in.png','attendances/2076/1701214204 clock_out.png','Juan R',43051,NULL,'2023-11-28 11:57:31','2023-12-04 17:51:06'),(3458,'2023-11-28 06:57:41','2023-11-28 18:19:03','12.249.250.150','12.249.250.150','closed',11,681,'attendances/2170/1701183461 clock_in.png','attendances/2170/1701224343 clock_out.png','Juan R',43049,NULL,'2023-11-28 11:57:41','2023-12-04 17:46:02'),(3459,'2023-11-28 07:00:16','2023-11-28 15:34:25','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1462/1701183616 clock_in.png','attendances/1462/1701214465 clock_out.png','Juan R',43041,NULL,'2023-11-28 12:00:16','2023-12-04 17:44:58'),(3460,'2023-11-28 07:00:28','2023-11-28 15:41:41','12.249.250.150','12.249.250.150','closed',8,521,'attendances/974/1701183628 clock_in.png','attendances/974/1701214901 clock_out.png','Juan R',43031,NULL,'2023-11-28 12:00:28','2023-12-04 17:27:10'),(3461,'2023-11-28 07:01:19','2023-11-28 15:35:19','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1958/1701183679 clock_in.png','attendances/1958/1701214519 clock_out.png','Juan R',43038,NULL,'2023-11-28 12:01:19','2023-12-04 17:44:21'),(3462,'2023-11-28 07:04:34','2023-11-28 19:04:34','12.249.250.150','38.51.234.69','closed',12,720,'attendances/2141/1701183874 clock_in.png','attendances/2141/1701227063 clock_out.png','Juan R',43045,NULL,'2023-11-28 12:04:34','2023-12-04 17:44:16'),(3463,'2023-11-28 07:06:23','2023-11-28 15:36:10','12.249.250.150','12.249.250.150','closed',8,509,'attendances/1858/1701183983 clock_in.png','attendances/1858/1701214570 clock_out.png','Juan R',43044,NULL,'2023-11-28 12:06:23','2023-12-04 17:45:32'),(3464,'2023-11-28 07:09:44','2023-11-28 16:04:05','12.249.250.150','12.249.250.150','closed',8,534,'attendances/1888/1701184184 clock_in.png','attendances/1888/1701216245 clock_out.png','Juan R',43053,NULL,'2023-11-28 12:09:44','2023-12-04 17:51:21'),(3465,'2023-11-28 07:57:01','2023-11-28 16:30:08','12.249.250.150','12.249.250.150','closed',8,513,'attendances/775/1701187021 clock_in.png','attendances/775/1701217808 clock_out.png','Juan R',43055,NULL,'2023-11-28 12:57:01','2023-12-04 17:46:00'),(3466,'2023-11-28 08:05:25','2023-11-28 16:32:56','12.249.250.150','12.249.250.150','closed',8,507,'attendances/1891/1701187525 clock_in.png','attendances/1891/1701217976 clock_out.png','Juan R',43056,NULL,'2023-11-28 13:05:25','2023-12-04 17:50:10'),(3468,'2023-11-29 06:35:22','2023-11-29 15:33:57','12.249.250.150','12.249.250.150','closed',8,538,'attendances/622/1701268522 clock_in.png','attendances/622/1701300837 clock_out.png','Juan R',43086,NULL,'2023-11-29 11:35:22','2023-12-04 17:51:13'),(3469,'2023-11-29 06:49:42','2023-11-29 15:31:07','12.249.250.150','12.249.250.150','closed',8,521,'attendances/2094/1701269382 clock_in.png','attendances/2094/1701300667 clock_out.png','Juan R',43084,NULL,'2023-11-29 11:49:42','2023-12-04 17:50:39'),(3470,'2023-11-29 06:51:39','2023-11-29 15:31:47','12.249.250.150','12.249.250.150','closed',8,520,'attendances/1551/1701269499 clock_in.png','attendances/1551/1701300707 clock_out.png','Juan R',43066,NULL,'2023-11-29 11:51:39','2023-12-04 17:39:09'),(3471,'2023-11-29 06:51:43','2023-11-29 16:00:05','12.249.250.150','12.249.250.150','closed',9,548,'attendances/1999/1701269503 clock_in.png','attendances/1999/1701302406 clock_out.png','Juan R',43075,NULL,'2023-11-29 11:51:43','2023-12-04 17:44:54'),(3472,'2023-11-29 06:52:30','2023-11-29 15:30:32','12.249.250.150','12.249.250.150','closed',8,518,'attendances/1585/1701269550 clock_in.png','attendances/1585/1701300632 clock_out.png','Juan R',43067,NULL,'2023-11-29 11:52:30','2023-12-04 17:39:24'),(3473,'2023-11-29 06:52:44','2023-11-29 15:32:06','12.249.250.150','12.249.250.150','closed',8,519,'attendances/1774/1701269564 clock_in.png','attendances/1774/1701300726 clock_out.png','Juan R',43072,NULL,'2023-11-29 11:52:44','2023-12-04 17:42:11'),(3474,'2023-11-29 06:55:06','2023-11-29 15:32:39','12.249.250.150','12.249.250.150','closed',8,517,'attendances/2168/1701269706 clock_in.png','attendances/2168/1701300759 clock_out.png','Juan R',43073,NULL,'2023-11-29 11:55:06','2023-12-04 17:44:17'),(3475,'2023-11-29 06:55:29','2023-11-29 15:32:22','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1744/1701269729 clock_in.png','attendances/1744/1701300742 clock_out.png','Juan R',43081,NULL,'2023-11-29 11:55:29','2023-12-04 17:45:49'),(3476,'2023-11-29 06:55:42','2023-11-29 15:31:07','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1934/1701269742 clock_in.png','attendances/1934/1701300667 clock_out.png','Juan R',43077,NULL,'2023-11-29 11:55:42','2023-12-04 17:45:17'),(3477,'2023-11-29 06:55:55','2023-11-29 15:30:48','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1450/1701269755 clock_in.png','attendances/1450/1701300648 clock_out.png','Juan R',43085,NULL,'2023-11-29 11:55:55','2023-12-04 17:51:03'),(3478,'2023-11-29 06:57:10','2023-11-29 16:19:51','12.249.250.150','12.249.250.150','closed',9,562,'attendances/1728/1701269830 clock_in.png','attendances/1728/1701303591 clock_out.png','Juan R',43078,NULL,'2023-11-29 11:57:10','2023-12-04 17:45:28'),(3479,'2023-11-29 06:57:18','2023-11-29 15:36:19','12.249.250.150','12.249.250.150','closed',8,519,'attendances/1958/1701269838 clock_in.png','attendances/1958/1701300979 clock_out.png','Juan R',43074,NULL,'2023-11-29 11:57:18','2023-12-04 17:44:21'),(3480,'2023-11-29 06:57:27','2023-11-29 16:22:00','12.249.250.150','12.249.250.150','closed',9,564,'attendances/1479/1701269847 clock_in.png','attendances/1479/1701303720 clock_out.png','Juan R',43069,NULL,'2023-11-29 11:57:27','2023-12-04 17:41:23'),(3481,'2023-11-29 06:57:53','2023-11-29 16:21:16','12.249.250.150','12.249.250.150','closed',9,563,'attendances/1395/1701269873 clock_in.png','attendances/1395/1701303676 clock_out.png','Juan R',43082,NULL,'2023-11-29 11:57:53','2023-12-04 17:45:56'),(3482,'2023-11-29 06:58:04','2023-11-29 16:22:51','12.249.250.150','12.249.250.150','closed',9,564,'attendances/2200/1701269884 clock_in.png','attendances/2200/1701303771 clock_out.png','Juan R',43071,NULL,'2023-11-29 11:58:04','2023-12-04 17:41:46'),(3483,'2023-11-29 06:58:18','2023-11-29 15:42:25','12.249.250.150','12.249.250.150','closed',8,524,'attendances/974/1701269898 clock_in.png','attendances/974/1701301345 clock_out.png','Juan R',43065,NULL,'2023-11-29 11:58:18','2023-12-04 17:27:10'),(3484,'2023-11-29 06:58:24','2023-11-29 15:30:47','12.249.250.150','12.249.250.150','closed',8,512,'attendances/1568/1701269904 clock_in.png','attendances/1568/1701300647 clock_out.png','Juan R',43068,NULL,'2023-11-29 11:58:24','2023-12-04 17:39:30'),(3485,'2023-11-29 06:58:40','2023-11-29 15:30:34','12.249.250.150','12.249.250.150','closed',8,511,'attendances/2116/1701269920 clock_in.png','attendances/2116/1701300634 clock_out.png','Juan R',43080,NULL,'2023-11-29 11:58:40','2023-12-04 17:41:15'),(3486,'2023-11-29 07:00:54','2023-11-29 15:31:33','12.249.250.150','12.249.250.150','closed',8,510,'attendances/1951/1701270055 clock_in.png','attendances/1951/1701300693 clock_out.png','Juan R',43070,NULL,'2023-11-29 12:00:55','2023-12-04 17:41:27'),(3487,'2023-11-29 07:04:50','2023-11-29 15:36:16','12.249.250.150','12.249.250.150','closed',8,511,'attendances/1462/1701270290 clock_in.png','attendances/1462/1701300976 clock_out.png','Juan R',43076,NULL,'2023-11-29 12:04:50','2023-12-04 17:44:58'),(3488,'2023-11-29 07:06:36','2023-11-29 15:34:48','12.249.250.150','12.249.250.150','closed',8,508,'attendances/1948/1701270396 clock_in.png','attendances/1948/1701300888 clock_out.png','Juan R',43083,NULL,'2023-11-29 12:06:36','2023-12-04 17:50:20'),(3489,'2023-11-29 07:08:57','2023-11-29 15:41:59','12.249.250.150','12.249.250.150','closed',8,513,'attendances/1888/1701270537 clock_in.png','attendances/1888/1701301319 clock_out.png','Juan R',43087,NULL,'2023-11-29 12:08:57','2023-12-04 17:51:21'),(3490,'2023-11-29 07:11:14','2023-11-29 15:36:09','12.249.250.150','12.249.250.150','closed',8,504,'attendances/1858/1701270674 clock_in.png','attendances/1858/1701300969 clock_out.png','Juan R',43079,NULL,'2023-11-29 12:11:14','2023-12-04 17:45:32'),(3491,'2023-11-29 07:57:11','2023-11-29 16:32:27','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1869/1701273431 clock_in.png','attendances/1869/1701304347 clock_out.png','Juan R',43088,NULL,'2023-11-29 12:57:11','2023-12-04 17:40:22'),(3492,'2023-11-29 08:01:50','2023-11-29 16:30:13','12.249.250.150','12.249.250.150','closed',8,508,'attendances/775/1701273710 clock_in.png','attendances/775/1701304213 clock_out.png','Juan R',43089,NULL,'2023-11-29 13:01:50','2023-12-04 17:46:00'),(3493,'2023-11-29 08:02:19','2023-11-29 16:32:13','12.249.250.150','12.249.250.150','closed',8,509,'attendances/1891/1701273739 clock_in.png','attendances/1891/1701304333 clock_out.png','Juan R',43090,NULL,'2023-11-29 13:02:19','2023-12-04 17:50:10'),(3494,'2023-11-29 10:59:44','2023-11-29 17:19:26','12.249.250.150','12.249.250.150','closed',6,379,'attendances/2141/1701284384 clock_in.png','attendances/2141/1701307166 clock_out.png','Juan R',43091,NULL,'2023-11-29 15:59:44','2023-12-04 17:44:16'),(3495,'2023-11-29 11:51:38','2023-11-29 18:57:12','12.249.250.150','12.249.250.150','closed',7,425,'attendances/2076/1701287498 clock_in.png','attendances/2076/1701313032 clock_out.png','Juan R',43093,NULL,'2023-11-29 16:51:38','2023-12-04 17:51:06'),(3496,'2023-11-29 11:56:24','2023-11-29 18:56:39','12.249.250.150','12.249.250.150','closed',7,420,'attendances/2169/1701287784 clock_in.png','attendances/2169/1701312999 clock_out.png','Juan R',43092,NULL,'2023-11-29 16:56:24','2023-12-04 17:41:42'),(3498,'2023-11-30 06:24:59','2023-11-30 16:37:05','12.249.250.150','12.249.250.150','closed',10,612,'attendances/2179/1701354299 clock_in.png','attendances/2179/1701391025 clock_out.png','Juan R',43106,NULL,'2023-11-30 11:24:59','2023-12-04 17:51:16'),(3499,'2023-11-30 06:25:15','2023-11-30 16:36:54','12.249.250.150','12.249.250.150','closed',10,611,'attendances/2178/1701354315 clock_in.png','attendances/2178/1701391014 clock_out.png','Juan R',43094,NULL,'2023-11-30 11:25:15','2023-12-04 17:39:21'),(3500,'2023-11-30 06:25:29','2023-11-30 16:37:21','12.249.250.150','12.249.250.150','closed',10,611,'attendances/1585/1701354329 clock_in.png','attendances/1585/1701391041 clock_out.png','Juan R',43095,NULL,'2023-11-30 11:25:29','2023-12-04 17:39:24'),(3501,'2023-11-30 06:27:05','2023-11-30 16:38:45','12.249.250.150','12.249.250.150','closed',10,611,'attendances/2200/1701354425 clock_in.png','attendances/2200/1701391125 clock_out.png','Juan R',43098,NULL,'2023-11-30 11:27:05','2023-12-04 17:41:46'),(3502,'2023-11-30 06:27:09','2023-11-30 16:40:53','12.249.250.150','12.249.250.150','closed',10,613,'attendances/2005/1701354429 clock_in.png','attendances/2005/1701391253 clock_out.png','Juan R',43101,NULL,'2023-11-30 11:27:09','2023-12-04 17:45:42'),(3503,'2023-11-30 06:27:38','2023-11-30 16:38:03','12.249.250.150','12.249.250.150','closed',10,610,'attendances/2008/1701354458 clock_in.png','attendances/2008/1701391083 clock_out.png','Juan R',43099,NULL,'2023-11-30 11:27:38','2023-12-04 17:44:49'),(3504,'2023-11-30 06:27:58','2023-11-30 17:29:09','12.249.250.150','12.249.250.150','closed',11,661,'attendances/2169/1701354478 clock_in.png','attendances/2169/1701394149 clock_out.png','Juan R',43097,NULL,'2023-11-30 11:27:58','2023-12-04 17:41:42'),(3505,'2023-11-30 06:28:04','2023-11-30 17:02:23','12.249.250.150','12.249.250.150','closed',10,634,'attendances/2222/1701354484 clock_in.png','attendances/2222/1701392543 clock_out.png','Juan R',43105,NULL,'2023-11-30 11:28:04','2023-12-04 17:51:09'),(3506,'2023-11-30 06:28:32','2023-11-30 17:02:17','12.249.250.150','12.249.250.150','closed',10,633,'attendances/2116/1701354512 clock_in.png','attendances/2116/1701392537 clock_out.png','Juan R',43096,NULL,'2023-11-30 11:28:32','2023-12-04 17:41:15'),(3507,'2023-11-30 06:28:48','2023-11-30 16:37:36','12.249.250.150','12.249.250.150','closed',10,608,'attendances/2170/1701354528 clock_in.png','attendances/2170/1701391056 clock_out.png','Juan R',43102,NULL,'2023-11-30 11:28:48','2023-12-04 17:46:02'),(3508,'2023-11-30 06:28:59','2023-11-30 16:38:16','12.249.250.150','12.249.250.150','closed',10,609,'attendances/2218/1701354539 clock_in.png','attendances/2218/1701391096 clock_out.png','Juan R',43100,NULL,'2023-11-30 11:28:59','2023-12-04 17:45:02'),(3509,'2023-11-30 06:31:51','2023-11-30 17:30:31','12.249.250.150','12.249.250.150','closed',10,658,'attendances/1450/1701354711 clock_in.png','attendances/1450/1701394231 clock_out.png','Juan R',43103,NULL,'2023-11-30 11:31:51','2023-12-04 17:51:03'),(3510,'2023-11-30 06:38:16','2023-11-30 15:30:55','12.249.250.150','12.249.250.150','closed',8,532,'attendances/622/1701355096 clock_in.png','attendances/622/1701387055 clock_out.png','Juan R',43128,NULL,'2023-11-30 11:38:16','2023-12-04 17:51:13'),(3511,'2023-11-30 06:24:00','2023-11-30 17:28:47','38.51.234.69','12.249.250.150','closed',11,664,NULL,'attendances/2076/1701394127 clock_out.png','Juan R',43104,NULL,'2023-11-30 11:50:23','2023-12-04 17:51:06'),(3512,'2023-11-30 06:52:06','2023-11-30 15:42:21','12.249.250.150','12.249.250.150','closed',8,530,'attendances/1948/1701355926 clock_in.png','attendances/1948/1701387741 clock_out.png','Juan R',43126,NULL,'2023-11-30 11:52:06','2023-12-04 17:50:20'),(3513,'2023-11-30 06:54:35','2023-11-30 15:42:18','12.249.250.150','12.249.250.150','closed',8,527,'attendances/726/1701356075 clock_in.png','attendances/726/1701387738 clock_out.png','Juan R',43108,NULL,'2023-11-30 11:54:35','2023-12-04 17:39:08'),(3514,'2023-11-30 06:55:05','2023-11-30 15:31:18','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1774/1701356105 clock_in.png','attendances/1774/1701387078 clock_out.png','Juan R',43114,NULL,'2023-11-30 11:55:05','2023-12-04 17:42:11'),(3515,'2023-11-30 06:55:18','2023-11-30 15:31:34','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1744/1701356118 clock_in.png','attendances/1744/1701387094 clock_out.png','Juan R',43124,NULL,'2023-11-30 11:55:18','2023-12-04 17:45:49'),(3516,'2023-11-30 06:55:29','2023-11-30 15:30:20','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1934/1701356129 clock_in.png','attendances/1934/1701387020 clock_out.png','Juan R',43119,NULL,'2023-11-30 11:55:29','2023-12-04 17:45:17'),(3517,'2023-11-30 06:55:39','2023-11-30 15:56:25','12.249.250.150','12.249.250.150','closed',9,540,'attendances/1999/1701356139 clock_in.png','attendances/1999/1701388585 clock_out.png','Juan R',43117,NULL,'2023-11-30 11:55:39','2023-12-04 17:44:54'),(3518,'2023-11-30 06:55:52','2023-11-30 15:31:07','12.249.250.150','12.249.250.150','closed',8,515,'attendances/2168/1701356152 clock_in.png','attendances/2168/1701387067 clock_out.png','Juan R',43115,NULL,'2023-11-30 11:55:52','2023-12-04 17:44:17'),(3519,'2023-11-30 06:56:05','2023-11-30 15:28:39','12.249.250.150','12.249.250.150','closed',8,512,'attendances/2094/1701356165 clock_in.png','attendances/2094/1701386919 clock_out.png','Juan R',43127,NULL,'2023-11-30 11:56:05','2023-12-04 17:50:39'),(3520,'2023-11-30 06:56:05','2023-11-30 16:17:02','12.249.250.150','12.249.250.150','closed',9,560,'attendances/1479/1701356165 clock_in.png','attendances/1479/1701389822 clock_out.png','Juan R',43112,NULL,'2023-11-30 11:56:05','2023-12-04 17:41:23'),(3521,'2023-11-30 06:56:18','2023-11-30 15:25:40','12.249.250.150','12.249.250.150','closed',8,509,'attendances/1551/1701356178 clock_in.png','attendances/1551/1701386740 clock_out.png','Juan R',43110,NULL,'2023-11-30 11:56:18','2023-12-04 17:39:09'),(3522,'2023-11-30 06:56:22','2023-11-30 16:20:17','12.249.250.150','12.249.250.150','closed',9,563,'attendances/1395/1701356182 clock_in.png','attendances/1395/1701390017 clock_out.png','Juan R',43125,NULL,'2023-11-30 11:56:22','2023-12-04 17:45:56'),(3523,'2023-11-30 06:56:43','2023-11-30 15:32:17','12.249.250.150','12.249.250.150','closed',8,515,'attendances/2150/1701356203 clock_in.png','attendances/2150/1701387137 clock_out.png','Juan R',43109,NULL,'2023-11-30 11:56:43','2023-12-04 17:39:17'),(3524,'2023-11-30 06:56:48','2023-11-30 16:01:44','12.249.250.150','12.249.250.150','closed',9,544,'attendances/1116/1701356208 clock_in.png','attendances/1116/1701388904 clock_out.png','Juan R',43123,NULL,'2023-11-30 11:56:48','2023-12-04 17:45:46'),(3525,'2023-11-30 06:57:30','2023-11-30 15:32:00','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1958/1701356250 clock_in.png','attendances/1958/1701387120 clock_out.png','Juan R',43116,NULL,'2023-11-30 11:57:30','2023-12-04 17:44:21'),(3526,'2023-11-30 06:57:39','2023-11-30 15:43:42','12.249.250.150','12.249.250.150','closed',8,526,'attendances/1888/1701356259 clock_in.png','attendances/1888/1701387822 clock_out.png','Juan R',43129,NULL,'2023-11-30 11:57:39','2023-12-04 17:51:21'),(3527,'2023-11-30 06:58:00','2023-11-30 15:58:00','12.249.250.150','38.51.234.69','closed',9,540,'attendances/974/1701356280 clock_in.png','attendances/974/1701388621 clock_out.png','Juan R',43107,NULL,'2023-11-30 11:58:00','2023-12-04 17:27:10'),(3528,'2023-11-30 06:58:40','2023-11-30 15:34:48','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1951/1701356320 clock_in.png','attendances/1951/1701387288 clock_out.png','Juan R',43113,NULL,'2023-11-30 11:58:40','2023-12-04 17:41:27'),(3529,'2023-11-30 06:59:50','2023-11-30 15:31:59','12.249.250.150','190.103.31.245','closed',8,512,'attendances/2133/1701356390 clock_in.png','attendances/2133/1701372652 clock_out.png','Juan R',43122,NULL,'2023-11-30 11:59:50','2023-12-04 17:45:36'),(3530,'2023-11-30 06:59:53','2023-11-30 16:18:53','12.249.250.150','12.249.250.150','closed',9,559,'attendances/2141/1701356393 clock_in.png','attendances/2141/1701389933 clock_out.png','Juan R',43120,NULL,'2023-11-30 11:59:53','2023-12-04 17:44:16'),(3531,'2023-11-30 07:05:11','2023-11-30 15:42:10','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1462/1701356711 clock_in.png','attendances/1462/1701387730 clock_out.png','Juan R',43118,NULL,'2023-11-30 12:05:11','2023-12-04 17:44:58'),(3532,'2023-11-30 07:10:33','2023-11-30 15:33:51','12.249.250.150','12.249.250.150','closed',8,503,'attendances/1858/1701357033 clock_in.png','attendances/1858/1701387231 clock_out.png','Juan R',43121,NULL,'2023-11-30 12:10:33','2023-12-04 17:45:32'),(3533,'2023-11-30 07:41:03','2023-11-30 15:31:02','12.249.250.150','12.249.250.150','closed',7,469,'attendances/1568/1701358863 clock_in.png','attendances/1568/1701387062 clock_out.png','Juan R',43111,NULL,'2023-11-30 12:41:03','2023-12-04 17:39:30'),(3534,'2023-11-30 07:58:24','2023-11-30 16:32:15','12.249.250.150','12.249.250.150','closed',8,513,'attendances/1869/1701359904 clock_in.png','attendances/1869/1701390735 clock_out.png','Juan R',43130,NULL,'2023-11-30 12:58:24','2023-12-04 17:40:22'),(3535,'2023-11-30 07:59:06','2023-11-30 16:30:21','12.249.250.150','12.249.250.150','closed',8,511,'attendances/775/1701359946 clock_in.png','attendances/775/1701390621 clock_out.png','Juan R',43131,NULL,'2023-11-30 12:59:06','2023-12-04 17:46:00'),(3536,'2023-11-30 08:10:17','2023-11-30 16:32:29','38.51.234.69','38.51.234.69','closed',8,502,'attendances/1891/1701376337 clock_in.png','attendances/1891/1701390749 clock_out.png','Juan R',43132,NULL,'2023-11-30 17:32:17','2023-12-04 17:50:10'),(3537,'2023-11-30 13:56:41','2023-11-30 22:52:40','12.249.250.150','12.249.250.150','closed',8,535,'attendances/2047/1701381401 clock_in.png','attendances/2047/1701413560 clock_out.png','Juan R',43133,NULL,'2023-11-30 18:56:41','2023-12-04 17:44:26'),(3538,'2023-11-30 13:56:45','2023-11-30 22:52:25','12.249.250.150','12.249.250.150','closed',8,535,'attendances/2061/1701381405 clock_in.png','attendances/2061/1701413545 clock_out.png','Juan R',43134,NULL,'2023-11-30 18:56:45','2023-12-04 17:45:14'),(3540,'2023-12-01 06:35:04','2023-12-01 15:31:30','12.249.250.150','12.249.250.150','closed',8,536,'attendances/622/1701441304 clock_in.png','attendances/622/1701473490 clock_out.png','Juan R',43164,NULL,'2023-12-01 11:35:04','2023-12-04 17:51:13'),(3541,'2023-12-01 06:48:11','2023-12-01 15:47:35','12.249.250.150','12.249.250.150','closed',8,539,'attendances/2179/1701442091 clock_in.png','attendances/2179/1701474455 clock_out.png','Juan R',43170,NULL,'2023-12-01 11:48:11','2023-12-04 17:51:16'),(3542,'2023-12-01 06:51:04','2023-12-01 15:30:46','12.249.250.150','12.249.250.150','closed',8,519,'attendances/1774/1701442264 clock_in.png','attendances/1774/1701473446 clock_out.png','Juan R',43145,NULL,'2023-12-01 11:51:04','2023-12-04 17:42:11'),(3543,'2023-12-01 06:55:18','2023-12-01 15:30:32','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1934/1701442518 clock_in.png','attendances/1934/1701473432 clock_out.png','Juan R',43153,NULL,'2023-12-01 11:55:18','2023-12-04 17:45:17'),(3544,'2023-12-01 06:56:01','2023-12-01 15:02:03','12.249.250.150','12.249.250.150','closed',8,486,'attendances/726/1701442561 clock_in.png','attendances/726/1701471723 clock_out.png','Juan R',43138,NULL,'2023-12-01 11:56:01','2023-12-04 17:39:08'),(3545,'2023-12-01 06:56:10','2023-12-01 15:38:09','12.249.250.150','12.249.250.150','closed',8,521,'attendances/1958/1701442570 clock_in.png','attendances/1958/1701473889 clock_out.png','Juan R',43147,NULL,'2023-12-01 11:56:10','2023-12-04 17:44:21'),(3546,'2023-12-01 06:56:52','2023-12-01 16:03:01','12.249.250.150','12.249.250.150','closed',9,546,'attendances/1728/1701442612 clock_in.png','attendances/1728/1701475381 clock_out.png','Juan R',43154,NULL,'2023-12-01 11:56:52','2023-12-04 17:45:28'),(3547,'2023-12-01 06:57:07','2023-12-01 16:01:26','12.249.250.150','12.249.250.150','closed',9,544,'attendances/2047/1701442627 clock_in.png','attendances/2047/1701475286 clock_out.png','Juan R',43148,NULL,'2023-12-01 11:57:07','2023-12-04 17:44:26'),(3548,'2023-12-01 06:57:18','2023-12-01 16:01:39','12.249.250.150','12.249.250.150','closed',9,544,'attendances/2061/1701442638 clock_in.png','attendances/2061/1701475299 clock_out.png','Juan R',43152,NULL,'2023-12-01 11:57:18','2023-12-04 17:45:14'),(3549,'2023-12-01 06:57:35','2023-12-01 17:10:38','12.249.250.150','12.249.250.150','closed',10,613,'attendances/2200/1701442655 clock_in.png','attendances/2200/1701479438 clock_out.png','Juan R',43143,NULL,'2023-12-01 11:57:35','2023-12-04 17:41:46'),(3550,'2023-12-01 06:58:08','2023-12-01 17:00:24','12.249.250.150','12.249.250.150','closed',10,602,'attendances/1999/1701442688 clock_in.png','attendances/1999/1701478824 clock_out.png','Juan R',43150,NULL,'2023-12-01 11:58:08','2023-12-04 17:44:54'),(3551,'2023-12-01 06:58:35','2023-12-01 17:16:03','12.249.250.150','12.249.250.150','closed',10,617,'attendances/2008/1701442715 clock_in.png','attendances/2008/1701479763 clock_out.png','Juan R',43149,NULL,'2023-12-01 11:58:35','2023-12-04 17:44:49'),(3552,'2023-12-01 06:59:29','2023-12-01 17:09:15','12.249.250.150','12.249.250.150','closed',10,609,'attendances/1116/1701442769 clock_in.png','attendances/1116/1701479355 clock_out.png','Juan R',43157,NULL,'2023-12-01 11:59:29','2023-12-04 17:45:46'),(3553,'2023-12-01 06:59:32','2023-12-01 15:31:07','12.249.250.150','12.249.250.150','closed',8,511,'attendances/2133/1701442772 clock_in.png','attendances/2133/1701473467 clock_out.png','Juan R',43156,NULL,'2023-12-01 11:59:32','2023-12-04 17:45:36'),(3554,'2023-12-01 06:59:53','2023-12-01 15:31:23','12.249.250.150','12.249.250.150','closed',8,511,'attendances/2141/1701442793 clock_in.png','attendances/2141/1701473483 clock_out.png','Juan R',43163,NULL,'2023-12-01 11:59:53','2023-12-04 17:44:16'),(3555,'2023-12-01 07:00:00','2023-12-01 16:02:39','12.249.250.150','12.249.250.150','closed',9,542,'attendances/1948/1701442800 clock_in.png','attendances/1948/1701475359 clock_out.png','Juan R',43161,NULL,'2023-12-01 12:00:00','2023-12-04 17:50:20'),(3556,'2023-12-01 07:00:17','2023-12-01 16:03:13','12.249.250.150','12.249.250.150','closed',9,542,'attendances/1479/1701442817 clock_in.png','attendances/1479/1701475393 clock_out.png','Juan R',43141,NULL,'2023-12-01 12:00:17','2023-12-04 17:41:23'),(3557,'2023-12-01 07:00:32','2023-12-01 17:00:32','12.249.250.150','38.51.234.69','closed',10,600,'attendances/974/1701442832 clock_in.png','attendances/974/1701478814 clock_out.png','Juan R',43137,NULL,'2023-12-01 12:00:32','2023-12-04 17:27:10'),(3558,'2023-12-01 07:00:57','2023-12-01 15:34:00','12.249.250.150','190.103.31.245','closed',8,513,'attendances/1568/1701442857 clock_in.png',NULL,'Juan R',43140,NULL,'2023-12-01 12:00:57','2023-12-04 17:39:30'),(3559,'2023-12-01 07:01:11','2023-12-01 15:50:21','12.249.250.150','12.249.250.150','closed',8,529,'attendances/1951/1701442871 clock_in.png','attendances/1951/1701474621 clock_out.png','Juan R',43142,NULL,'2023-12-01 12:01:11','2023-12-04 17:41:27'),(3560,'2023-12-01 07:01:23','2023-12-01 15:40:31','12.249.250.150','12.249.250.150','closed',8,519,'attendances/1462/1701442883 clock_in.png','attendances/1462/1701474031 clock_out.png','Juan R',43151,NULL,'2023-12-01 12:01:23','2023-12-04 17:44:58'),(3561,'2023-12-01 07:01:25','2023-12-01 15:30:44','12.249.250.150','12.249.250.150','closed',8,509,'attendances/2094/1701442885 clock_in.png','attendances/2094/1701473444 clock_out.png','Juan R',43162,NULL,'2023-12-01 12:01:25','2023-12-04 17:50:39'),(3562,'2023-12-01 07:01:29','2023-12-01 15:31:01','12.249.250.150','12.249.250.150','closed',8,509,'attendances/1744/1701442889 clock_in.png','attendances/1744/1701473461 clock_out.png','Juan R',43158,NULL,'2023-12-01 12:01:29','2023-12-04 17:45:49'),(3563,'2023-12-01 07:01:41','2023-12-01 15:46:42','12.249.250.150','12.249.250.150','closed',8,525,'attendances/2150/1701442901 clock_in.png','attendances/2150/1701474402 clock_out.png','Juan R',43139,NULL,'2023-12-01 12:01:41','2023-12-04 17:39:17'),(3564,'2023-12-01 07:03:08','2023-12-01 15:38:21','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1858/1701442988 clock_in.png','attendances/1858/1701473901 clock_out.png','Juan R',43155,NULL,'2023-12-01 12:03:08','2023-12-04 17:45:32'),(3565,'2023-12-01 07:03:57','2023-12-01 15:43:03','12.249.250.150','12.249.250.150','closed',8,519,'attendances/1888/1701443037 clock_in.png','attendances/1888/1701474183 clock_out.png','Juan R',43165,NULL,'2023-12-01 12:03:57','2023-12-04 17:51:21'),(3566,'2023-12-01 07:11:30','2023-12-01 15:32:22','12.249.250.150','12.249.250.150','closed',8,500,'attendances/2231/1701443490 clock_in.png','attendances/2231/1701473542 clock_out.png','Juan R',43171,NULL,'2023-12-01 12:11:30','2023-12-04 17:39:14'),(3567,'2023-12-01 07:57:34','2023-12-01 16:30:23','12.249.250.150','12.249.250.150','closed',8,512,'attendances/775/1701446254 clock_in.png','attendances/775/1701477024 clock_out.png','Juan R',43167,NULL,'2023-12-01 12:57:34','2023-12-04 17:46:00'),(3568,'2023-12-01 07:59:47','2023-12-01 16:34:07','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1891/1701446387 clock_in.png','attendances/1891/1701477247 clock_out.png','Juan R',43168,NULL,'2023-12-01 12:59:47','2023-12-04 17:50:10'),(3569,'2023-12-01 08:00:15','2023-12-01 16:33:55','12.249.250.150','12.249.250.150','closed',8,513,'attendances/1869/1701446415 clock_in.png','attendances/1869/1701477235 clock_out.png','Juan R',43166,NULL,'2023-12-01 13:00:15','2023-12-04 17:40:22'),(3570,'2023-12-01 08:18:05','2023-12-01 15:31:38','12.249.250.150','12.249.250.150','closed',7,433,'attendances/2195/1701447485 clock_in.png','attendances/2195/1701473498 clock_out.png','Juan R',43146,NULL,'2023-12-01 13:18:05','2023-12-04 17:41:49'),(3571,'2023-12-01 11:06:46','2023-12-01 20:32:30','12.249.250.150','12.249.250.150','closed',9,565,'attendances/2169/1701457606 clock_in.png','attendances/2169/1701491550 clock_out.png','Juan R',43169,NULL,'2023-12-01 16:06:46','2023-12-04 17:41:42'),(3572,'2023-12-02 05:52:57','2023-12-02 14:55:57','12.249.250.150','12.249.250.150','closed',9,543,'attendances/2222/1701525177 clock_in.png','attendances/2222/1701557757 clock_out.png','Juan R',43182,NULL,'2023-12-02 10:52:57','2023-12-04 17:51:09'),(3573,'2023-12-02 05:54:53','2023-12-02 14:56:13','12.249.250.150','12.249.250.150','closed',9,541,'attendances/1585/1701525293 clock_in.png','attendances/1585/1701557773 clock_out.png','Juan R',43174,NULL,'2023-12-02 10:54:53','2023-12-04 17:39:24'),(3574,'2023-12-02 05:55:57','2023-12-02 15:28:11','12.249.250.150','12.249.250.150','closed',9,572,'attendances/2008/1701525357 clock_in.png','attendances/2008/1701559691 clock_out.png','Juan R',43177,NULL,'2023-12-02 10:55:57','2023-12-04 17:44:49'),(3575,'2023-12-02 05:57:04','2023-12-02 15:31:24','12.249.250.150','12.249.250.150','closed',9,574,'attendances/726/1701525424 clock_in.png','attendances/726/1701559884 clock_out.png','Juan R',43172,NULL,'2023-12-02 10:57:04','2023-12-04 17:39:08'),(3576,'2023-12-02 05:57:12','2023-12-02 14:58:41','12.249.250.150','12.249.250.150','closed',9,541,'attendances/2179/1701525432 clock_in.png','attendances/2179/1701557921 clock_out.png','Juan R',43253,NULL,'2023-12-02 10:57:12','2023-12-04 17:51:16'),(3577,'2023-12-02 05:57:23','2023-12-02 14:57:23','12.249.250.150','38.51.234.69','closed',9,540,'attendances/2178/1701525443 clock_in.png','attendances/2178/1701557823 clock_out.png','Juan R',43252,NULL,'2023-12-02 10:57:23','2023-12-04 17:39:21'),(3578,'2023-12-02 05:57:29','2023-12-02 14:56:29','12.249.250.150','12.249.250.150','closed',8,539,'attendances/2218/1701525449 clock_in.png','attendances/2218/1701557789 clock_out.png','Juan R',43178,NULL,'2023-12-02 10:57:29','2023-12-04 17:45:02'),(3579,'2023-12-02 05:57:32','2023-12-02 15:02:46','12.249.250.150','12.249.250.150','closed',9,545,'attendances/1395/1701525452 clock_in.png','attendances/1395/1701558166 clock_out.png','Juan R',43180,NULL,'2023-12-02 10:57:32','2023-12-04 17:45:56'),(3580,'2023-12-02 06:00:13','2023-12-02 15:30:29','12.249.250.150','12.249.250.150','closed',9,570,'attendances/2141/1701525613 clock_in.png','attendances/2141/1701559829 clock_out.png','Juan R',43176,NULL,'2023-12-02 11:00:13','2023-12-04 17:44:16'),(3581,'2023-12-02 06:00:19','2023-12-02 16:10:51','12.249.250.150','12.249.250.150','closed',10,610,'attendances/2116/1701525619 clock_in.png','attendances/2116/1701562251 clock_out.png','Juan R',43175,NULL,'2023-12-02 11:00:19','2023-12-04 17:41:15'),(3582,'2023-12-02 06:01:50','2023-12-02 16:12:18','12.249.250.150','12.249.250.150','closed',10,610,'attendances/1450/1701525710 clock_in.png','attendances/1450/1701562338 clock_out.png','Juan R',43181,NULL,'2023-12-02 11:01:50','2023-12-04 17:51:03'),(3583,'2023-12-02 06:02:34','2023-12-02 14:55:37','12.249.250.150','12.249.250.150','closed',8,533,'attendances/1551/1701525754 clock_in.png','attendances/1551/1701557737 clock_out.png','Juan R',43173,NULL,'2023-12-02 11:02:34','2023-12-04 17:39:09'),(3584,'2023-12-02 06:17:57','2023-12-02 15:03:03','12.249.250.150','12.249.250.150','closed',8,525,'attendances/1728/1701526677 clock_in.png','attendances/1728/1701558183 clock_out.png','Juan R',43179,NULL,'2023-12-02 11:17:57','2023-12-04 17:45:28'),(3585,'2023-12-02 06:27:57','2023-12-02 15:04:24','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1116/1701527277 clock_in.png','attendances/1116/1701558264 clock_out.png','Juan R',43185,NULL,'2023-12-02 11:27:57','2023-12-04 17:45:46'),(3586,'2023-12-02 06:55:48','2023-12-02 17:20:35','12.249.250.150','12.249.250.150','closed',10,624,'attendances/2047/1701528948 clock_in.png','attendances/2047/1701566435 clock_out.png','Juan R',43184,NULL,'2023-12-02 11:55:48','2023-12-04 17:44:26'),(3587,'2023-12-02 06:56:38','2023-12-02 15:30:25','12.249.250.150','12.249.250.150','closed',8,513,'attendances/2200/1701528998 clock_in.png','attendances/2200/1701559825 clock_out.png','Juan R',43183,NULL,'2023-12-02 11:56:38','2023-12-04 17:41:46'),(3588,'2023-12-02 08:28:09','2023-12-02 15:02:13','12.249.250.150','12.249.250.150','closed',6,394,'attendances/2170/1701534489 clock_in.png','attendances/2170/1701558133 clock_out.png','Juan R',43186,NULL,'2023-12-02 13:28:09','2023-12-04 17:46:02'),(3590,'2023-12-03 06:02:11','2023-12-03 14:23:09','12.249.250.150','12.249.250.150','closed',8,500,'attendances/1479/1701612131 clock_in.png','attendances/1479/1701642189 clock_out.png','Juan R',43187,NULL,'2023-12-03 11:02:11','2023-12-04 17:41:23'),(3591,'2023-12-03 06:02:27','2023-12-03 14:25:47','12.249.250.150','12.249.250.150','closed',8,503,'attendances/2141/1701612147 clock_in.png','attendances/2141/1701642347 clock_out.png','Juan R',43188,NULL,'2023-12-03 11:02:27','2023-12-04 17:44:16'),(3592,'2023-12-04 03:59:12','2023-12-04 18:04:58','12.249.250.150','12.249.250.150','closed',14,845,'attendances/2218/1701691152 clock_in.png','attendances/2218/1701741898 clock_out.png',NULL,43256,NULL,'2023-12-04 08:59:12','2023-12-04 23:04:58'),(3593,'2023-12-04 03:59:31','2023-12-04 16:33:03','12.249.250.150','12.249.250.150','closed',12,753,'attendances/2141/1701691171 clock_in.png','attendances/2141/1701736383 clock_out.png',NULL,43255,NULL,'2023-12-04 08:59:31','2023-12-04 21:33:03'),(3594,'2023-12-04 03:59:47','2023-12-04 18:06:00','12.249.250.150','12.249.250.150','closed',14,846,'attendances/2005/1701691187 clock_in.png','attendances/2005/1701741960 clock_out.png',NULL,43257,NULL,'2023-12-04 08:59:47','2023-12-04 23:06:00'),(3595,'2023-12-04 05:29:32','2023-12-04 18:43:22','12.249.250.150','12.249.250.150','closed',13,793,'attendances/2195/1701696572 clock_in.png','attendances/2195/1701744202 clock_out.png',NULL,43259,NULL,'2023-12-04 10:29:32','2023-12-04 23:43:22'),(3596,'2023-12-04 05:32:11','2023-12-04 18:43:55','12.249.250.150','12.249.250.150','closed',13,791,'attendances/2231/1701696731 clock_in.png','attendances/2231/1701744235 clock_out.png',NULL,43258,NULL,'2023-12-04 10:32:11','2023-12-04 23:43:55'),(3597,'2023-12-04 05:56:22','2023-12-04 20:11:09','12.249.250.150','12.249.250.150','closed',14,854,'attendances/2076/1701698182 clock_in.png','attendances/2076/1701749469 clock_out.png',NULL,43266,NULL,'2023-12-04 10:56:22','2023-12-05 01:11:09'),(3598,'2023-12-04 05:56:44','2023-12-04 16:39:08','12.249.250.150','12.249.250.150','closed',10,642,'attendances/2159/1701698204 clock_in.png','attendances/2159/1701736749 clock_out.png',NULL,43299,NULL,'2023-12-04 10:56:44','2023-12-04 21:39:09'),(3599,'2023-12-04 05:57:07','2023-12-04 20:22:12','12.249.250.150','12.249.250.150','closed',14,865,'attendances/1551/1701698227 clock_in.png','attendances/1551/1701750132 clock_out.png',NULL,43260,NULL,'2023-12-04 10:57:07','2023-12-05 01:22:12'),(3600,'2023-12-04 05:57:41','2023-12-04 20:11:25','12.249.250.150','12.249.250.150','closed',14,853,'attendances/2094/1701698261 clock_in.png','attendances/2094/1701749485 clock_out.png',NULL,43265,NULL,'2023-12-04 10:57:41','2023-12-05 01:11:25'),(3601,'2023-12-04 05:57:44','2023-12-04 16:33:56','12.249.250.150','12.249.250.150','closed',10,636,'attendances/1116/1701698264 clock_in.png','attendances/1116/1701736436 clock_out.png',NULL,43264,NULL,'2023-12-04 10:57:44','2023-12-04 21:33:56'),(3602,'2023-12-04 05:58:01','2023-12-04 17:28:34','12.249.250.150','12.249.250.150','closed',11,690,'attendances/2008/1701698281 clock_in.png','attendances/2008/1701739714 clock_out.png',NULL,43262,NULL,'2023-12-04 10:58:01','2023-12-04 22:28:34'),(3603,'2023-12-04 05:59:12','2023-12-04 15:40:17','12.249.250.150','12.249.250.150','closed',9,581,'attendances/1999/1701698352 clock_in.png','attendances/1999/1701733217 clock_out.png',NULL,43282,NULL,'2023-12-04 10:59:12','2023-12-04 20:40:17'),(3604,'2023-12-04 05:59:26','2023-12-04 17:29:01','12.249.250.150','12.249.250.150','closed',11,689,'attendances/2224/1701698366 clock_in.png','attendances/2224/1701739741 clock_out.png',NULL,43298,NULL,'2023-12-04 10:59:26','2023-12-04 22:29:01'),(3605,'2023-12-04 05:59:34','2023-12-04 20:17:38','12.249.250.150','12.249.250.150','closed',14,858,'attendances/2222/1701698374 clock_in.png','attendances/2222/1701749858 clock_out.png',NULL,43267,NULL,'2023-12-04 10:59:34','2023-12-05 01:17:38'),(3606,'2023-12-04 05:59:47','2023-12-04 15:21:06','12.249.250.150','12.249.250.150','closed',9,561,'attendances/2133/1701698387 clock_in.png','attendances/2133/1701732066 clock_out.png',NULL,43263,NULL,'2023-12-04 10:59:47','2023-12-04 20:21:06'),(3607,'2023-12-04 06:01:02','2023-12-04 15:21:02','12.249.250.150','12.249.250.150','closed',9,560,'attendances/1951/1701698462 clock_in.png','attendances/1951/1701732062 clock_out.png',NULL,43261,NULL,'2023-12-04 11:01:02','2023-12-04 20:21:02'),(3608,'2023-12-04 06:01:15','2023-12-04 15:30:00','12.249.250.150','190.103.31.245','closed',9,568,'attendances/1728/1701698475 clock_in.png',NULL,NULL,43285,NULL,'2023-12-04 11:01:15','2023-12-04 22:54:23'),(3609,'2023-12-04 06:09:50','2023-12-04 15:18:07','12.249.250.150','12.249.250.150','closed',9,548,'attendances/1395/1701698990 clock_in.png','attendances/1395/1701731887 clock_out.png',NULL,43288,NULL,'2023-12-04 11:09:50','2023-12-04 20:18:07'),(3610,'2023-12-04 06:22:01','2023-12-04 18:26:59','12.249.250.150','12.249.250.150','closed',12,724,'attendances/2169/1701699721 clock_in.png','attendances/2169/1701743219 clock_out.png',NULL,43269,NULL,'2023-12-04 11:22:01','2023-12-04 23:26:59'),(3611,'2023-12-04 06:24:20','2023-12-04 18:26:38','12.249.250.150','12.249.250.150','closed',12,722,'attendances/1585/1701699860 clock_in.png','attendances/1585/1701743198 clock_out.png',NULL,43268,NULL,'2023-12-04 11:24:20','2023-12-04 23:26:38'),(3612,'2023-12-04 06:31:27','2023-12-04 15:30:26','12.249.250.150','12.249.250.150','closed',8,538,'attendances/622/1701700287 clock_in.png','attendances/622/1701732626 clock_out.png',NULL,43291,NULL,'2023-12-04 11:31:27','2023-12-04 20:30:26'),(3613,'2023-12-04 06:31:59','2023-12-04 18:28:51','12.249.250.150','12.249.250.150','closed',11,716,'attendances/1450/1701700319 clock_in.png','attendances/1450/1701743331 clock_out.png',NULL,43270,NULL,'2023-12-04 11:31:59','2023-12-04 23:28:51'),(3614,'2023-12-04 06:49:24','2023-12-04 18:05:33','12.249.250.150','12.249.250.150','closed',11,676,'attendances/2179/1701701364 clock_in.png','attendances/2179/1701741933 clock_out.png',NULL,43292,NULL,'2023-12-04 11:49:24','2023-12-04 23:05:33'),(3615,'2023-12-04 06:49:36','2023-12-04 18:05:17','12.249.250.150','12.249.250.150','closed',11,675,'attendances/2178/1701701376 clock_in.png','attendances/2178/1701741917 clock_out.png',NULL,43274,NULL,'2023-12-04 11:49:36','2023-12-04 23:05:17'),(3616,'2023-12-04 06:52:33','2023-12-04 15:30:15','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1774/1701701553 clock_in.png','attendances/1774/1701732615 clock_out.png',NULL,43278,NULL,'2023-12-04 11:52:33','2023-12-04 20:30:15'),(3617,'2023-12-04 06:53:56','2023-12-04 15:54:56','12.249.250.150','12.249.250.150','closed',9,541,'attendances/974/1701701636 clock_in.png','attendances/974/1701734096 clock_out.png',NULL,43271,NULL,'2023-12-04 11:53:56','2023-12-04 20:54:56'),(3618,'2023-12-04 06:54:05','2023-12-04 18:04:40','12.249.250.150','12.249.250.150','closed',11,670,'attendances/2116/1701701645 clock_in.png','attendances/2116/1701741880 clock_out.png',NULL,43275,NULL,'2023-12-04 11:54:05','2023-12-04 23:04:40'),(3619,'2023-12-04 06:55:14','2023-12-04 15:30:36','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1934/1701701714 clock_in.png','attendances/1934/1701732636 clock_out.png',NULL,43284,NULL,'2023-12-04 11:55:14','2023-12-04 20:30:36'),(3620,'2023-12-04 06:55:14','2023-12-04 16:04:56','12.249.250.150','12.249.250.150','closed',9,549,'attendances/1479/1701701714 clock_in.png','attendances/1479/1701734696 clock_out.png',NULL,43276,NULL,'2023-12-04 11:55:14','2023-12-04 21:04:56'),(3621,'2023-12-04 06:55:15','2023-12-04 15:31:52','12.249.250.150','12.249.250.150','closed',8,516,'attendances/2168/1701701715 clock_in.png','attendances/2168/1701732712 clock_out.png',NULL,43279,NULL,'2023-12-04 11:55:15','2023-12-04 20:31:52'),(3622,'2023-12-04 06:55:32','2023-12-04 15:31:43','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1744/1701701732 clock_in.png','attendances/1744/1701732703 clock_out.png',NULL,43287,NULL,'2023-12-04 11:55:32','2023-12-04 20:31:43'),(3623,'2023-12-04 06:55:38','2023-12-04 15:47:03','12.249.250.150','12.249.250.150','closed',8,531,'attendances/2047/1701701738 clock_in.png','attendances/2047/1701733623 clock_out.png',NULL,43281,NULL,'2023-12-04 11:55:38','2023-12-04 20:47:03'),(3624,'2023-12-04 06:55:50','2023-12-04 15:46:50','12.249.250.150','12.249.250.150','closed',8,531,'attendances/2061/1701701750 clock_in.png','attendances/2061/1701733610 clock_out.png',NULL,43283,NULL,'2023-12-04 11:55:50','2023-12-04 20:46:50'),(3625,'2023-12-04 06:55:55','2023-12-04 18:45:21','12.249.250.150','12.249.250.150','closed',11,709,'attendances/726/1701701755 clock_in.png','attendances/726/1701744321 clock_out.png',NULL,43272,NULL,'2023-12-04 11:55:55','2023-12-04 23:45:21'),(3626,'2023-12-04 06:56:43','2023-12-04 23:41:23','12.249.250.150','12.249.250.150','closed',16,1004,'attendances/2200/1701701803 clock_in.png','attendances/2200/1701762083 clock_out.png',NULL,43277,NULL,'2023-12-04 11:56:43','2023-12-05 04:41:23'),(3627,'2023-12-04 06:56:53','2023-12-04 23:41:11','12.249.250.150','12.249.250.150','closed',16,1004,'attendances/2170/1701701813 clock_in.png','attendances/2170/1701762071 clock_out.png',NULL,43289,NULL,'2023-12-04 11:56:53','2023-12-05 04:41:11'),(3628,'2023-12-04 06:57:05','2023-12-04 15:31:02','12.249.250.150','12.249.250.150','closed',8,513,'attendances/1958/1701701825 clock_in.png','attendances/1958/1701732662 clock_out.png',NULL,43280,NULL,'2023-12-04 11:57:05','2023-12-04 20:31:03'),(3629,'2023-12-04 06:57:17','2023-12-04 15:31:22','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1858/1701701837 clock_in.png','attendances/1858/1701732682 clock_out.png',NULL,43286,NULL,'2023-12-04 11:57:17','2023-12-04 20:31:22'),(3630,'2023-12-04 06:57:55','2023-12-04 15:46:34','12.249.250.150','12.249.250.150','closed',8,528,'attendances/2150/1701701875 clock_in.png','attendances/2150/1701733594 clock_out.png',NULL,43273,NULL,'2023-12-04 11:57:55','2023-12-04 20:46:34'),(3631,'2023-12-04 06:58:39','2023-12-04 15:56:26','12.249.250.150','12.249.250.150','closed',8,537,'attendances/2058/1701701919 clock_in.png','attendances/2058/1701734186 clock_out.png',NULL,43300,NULL,'2023-12-04 11:58:39','2023-12-04 20:56:26'),(3632,'2023-12-04 06:59:11','2023-12-04 18:34:46','12.249.250.150','12.249.250.150','closed',11,695,'attendances/2227/1701701951 clock_in.png','attendances/2227/1701743686 clock_out.png',NULL,43301,NULL,'2023-12-04 11:59:11','2023-12-04 23:34:46'),(3633,'2023-12-04 07:00:34','2023-12-04 15:39:33','12.249.250.150','12.249.250.150','closed',8,518,'attendances/1948/1701702034 clock_in.png','attendances/1948/1701733173 clock_out.png',NULL,43290,NULL,'2023-12-04 12:00:34','2023-12-04 20:39:33'),(3634,'2023-12-04 07:01:05','2023-12-04 16:06:10','12.249.250.150','12.249.250.150','closed',9,545,'attendances/2230/1701702065 clock_in.png','attendances/2230/1701734771 clock_out.png',NULL,43302,NULL,'2023-12-04 12:01:05','2023-12-04 21:06:11'),(3635,'2023-12-04 07:03:54','2023-12-04 15:53:55','12.249.250.150','12.249.250.150','closed',8,530,'attendances/1888/1701702234 clock_in.png','attendances/1888/1701734035 clock_out.png',NULL,43293,NULL,'2023-12-04 12:03:54','2023-12-04 20:53:55'),(3636,'2023-12-04 07:57:47','2023-12-04 16:35:26','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1869/1701705467 clock_in.png','attendances/1869/1701736526 clock_out.png',NULL,43294,NULL,'2023-12-04 12:57:47','2023-12-04 21:35:26'),(3637,'2023-12-04 07:58:06','2023-12-04 16:29:54','12.249.250.150','12.249.250.150','closed',8,511,'attendances/775/1701705486 clock_in.png','attendances/775/1701736194 clock_out.png',NULL,43296,NULL,'2023-12-04 12:58:06','2023-12-04 21:29:54'),(3638,'2023-12-04 08:00:58','2023-12-04 15:38:40','12.249.250.150','12.249.250.150','closed',7,457,'attendances/1462/1701705658 clock_in.png','attendances/1462/1701733120 clock_out.png',NULL,43295,NULL,'2023-12-04 13:00:58','2023-12-04 20:38:40'),(3639,'2023-12-04 08:01:43','2023-12-04 16:35:39','12.249.250.150','12.249.250.150','closed',8,513,'attendances/1891/1701705703 clock_in.png','attendances/1891/1701736539 clock_out.png',NULL,43297,NULL,'2023-12-04 13:01:43','2023-12-04 21:35:39'),(3640,'2023-12-02 23:04:00','2023-12-02 23:59:00','38.51.234.69','38.51.234.69','closed',0,55,NULL,NULL,NULL,43348,NULL,'2023-12-04 18:09:18','2023-12-04 18:09:18'),(3641,'2023-12-03 00:00:00','2023-12-03 01:14:00','38.51.234.69','38.51.234.69','closed',1,74,NULL,NULL,NULL,43349,NULL,'2023-12-04 18:10:04','2023-12-04 18:10:04'),(3643,'2023-12-04 20:50:54','2023-12-04 23:59:00','179.19.109.38','38.51.234.69','closed',3,188,'attendances/726/1701749694 clock_in.png',NULL,NULL,43393,NULL,'2023-12-05 01:14:54','2023-12-05 09:33:59'),(3646,'2023-12-04 20:15:00','2023-12-04 23:45:15','179.19.109.38','12.249.250.150','closed',3,210,NULL,'attendances/2231/1701762315 clock_out.png',NULL,43395,NULL,'2023-12-05 01:38:07','2023-12-05 04:45:15'),(3647,'2023-12-04 20:15:54','2023-12-04 23:47:22','179.19.109.38','12.249.250.150','closed',3,211,'attendances/2195/1701751554 clock_in.png','attendances/2195/1701762442 clock_out.png',NULL,43396,NULL,'2023-12-05 01:45:54','2023-12-05 04:47:22'),(3648,'2023-12-04 20:50:38','2023-12-04 23:59:00','12.249.250.150','38.51.234.69','closed',3,188,'attendances/1116/1701751838 clock_in.png',NULL,NULL,43394,NULL,'2023-12-05 01:50:38','2023-12-05 09:35:57'),(3649,'2023-12-04 20:51:11','2023-12-04 23:59:00','12.249.250.150','38.51.234.69','closed',3,187,'attendances/1479/1701751871 clock_in.png',NULL,NULL,43392,NULL,'2023-12-05 01:51:11','2023-12-05 09:34:39'),(3654,'2023-12-05 00:00:00','2023-12-05 00:13:00','38.51.234.69','38.51.234.69','closed',0,13,NULL,NULL,NULL,43400,NULL,'2023-12-05 09:28:11','2023-12-05 09:28:11'),(3656,'2023-12-05 00:00:00','2023-12-05 00:10:00','38.51.234.69','38.51.234.69','closed',0,10,NULL,NULL,NULL,43398,NULL,'2023-12-05 09:30:32','2023-12-05 09:30:32'),(3657,'2023-12-05 00:00:00','2023-12-05 00:12:00','38.51.234.69','38.51.234.69','closed',0,12,NULL,NULL,NULL,43397,NULL,'2023-12-05 09:31:10','2023-12-05 09:31:10'),(3658,'2023-12-05 05:55:20','2023-12-05 15:05:12','12.249.250.150','12.249.250.150','closed',9,549,'attendances/2061/1701784520 clock_in.png','attendances/2061/1701817512 clock_out.png',NULL,43354,NULL,'2023-12-05 10:55:20','2023-12-05 20:05:12'),(3659,'2023-12-05 05:55:35','2023-12-05 15:04:57','12.249.250.150','12.249.250.150','closed',9,549,'attendances/2047/1701784535 clock_in.png','attendances/2047/1701817497 clock_out.png',NULL,43353,NULL,'2023-12-05 10:55:35','2023-12-05 20:04:57'),(3660,'2023-12-05 05:56:06','2023-12-05 15:04:09','12.249.250.150','12.249.250.150','closed',9,548,'attendances/2231/1701784566 clock_in.png','attendances/2231/1701817449 clock_out.png',NULL,43351,NULL,'2023-12-05 10:56:06','2023-12-05 20:04:09'),(3661,'2023-12-05 05:58:30','2023-12-05 19:00:19','12.249.250.150','12.249.250.150','closed',13,781,'attendances/2222/1701784710 clock_in.png','attendances/2222/1701831619 clock_out.png',NULL,43357,NULL,'2023-12-05 10:58:30','2023-12-06 00:00:19'),(3662,'2023-12-05 05:59:15','2023-12-05 19:00:31','12.249.250.150','12.249.250.150','closed',13,781,'attendances/2076/1701784755 clock_in.png','attendances/2076/1701831631 clock_out.png',NULL,43356,NULL,'2023-12-05 10:59:15','2023-12-06 00:00:31'),(3663,'2023-12-05 06:02:39','2023-12-05 18:59:08','12.249.250.150','12.249.250.150','closed',12,776,'attendances/1551/1701784959 clock_in.png','attendances/1551/1701831548 clock_out.png',NULL,43350,NULL,'2023-12-05 11:02:39','2023-12-05 23:59:08'),(3664,'2023-12-05 06:04:44','2023-12-05 18:57:58','12.249.250.150','12.249.250.150','closed',12,773,'attendances/2094/1701785084 clock_in.png','attendances/2094/1701831478 clock_out.png',NULL,43355,NULL,'2023-12-05 11:04:44','2023-12-05 23:57:58'),(3665,'2023-12-05 06:06:34','2023-12-05 15:04:28','12.249.250.150','12.249.250.150','closed',8,537,'attendances/2195/1701785194 clock_in.png','attendances/2195/1701817468 clock_out.png',NULL,43352,NULL,'2023-12-05 11:06:34','2023-12-05 20:04:28'),(3666,'2023-12-05 06:22:42','2023-12-05 18:32:10','12.249.250.150','12.249.250.150','closed',12,729,'attendances/1585/1701786162 clock_in.png','attendances/1585/1701829930 clock_out.png',NULL,43358,NULL,'2023-12-05 11:22:42','2023-12-05 23:32:10'),(3667,'2023-12-05 06:23:45','2023-12-05 18:23:30','12.249.250.150','12.249.250.150','closed',11,719,'attendances/2169/1701786225 clock_in.png','attendances/2169/1701829410 clock_out.png',NULL,43359,NULL,'2023-12-05 11:23:45','2023-12-05 23:23:30'),(3668,'2023-12-05 06:29:44','2023-12-05 18:32:34','12.249.250.150','12.249.250.150','closed',12,722,'attendances/1450/1701786584 clock_in.png','attendances/1450/1701829954 clock_out.png',NULL,43360,NULL,'2023-12-05 11:29:44','2023-12-05 23:32:34'),(3669,'2023-12-05 06:43:34','2023-12-05 15:37:23','12.249.250.150','12.249.250.150','closed',8,533,'attendances/622/1701787414 clock_in.png','attendances/622/1701819443 clock_out.png',NULL,43384,NULL,'2023-12-05 11:43:34','2023-12-05 20:37:23'),(3670,'2023-12-05 06:51:25','2023-12-05 15:30:55','12.249.250.150','12.249.250.150','closed',8,519,'attendances/2179/1701787885 clock_in.png','attendances/2179/1701819055 clock_out.png',NULL,43385,NULL,'2023-12-05 11:51:25','2023-12-05 20:30:55'),(3671,'2023-12-05 06:51:39','2023-12-05 15:31:14','12.249.250.150','12.249.250.150','closed',8,519,'attendances/2178/1701787899 clock_in.png','attendances/2178/1701819074 clock_out.png',NULL,43364,NULL,'2023-12-05 11:51:39','2023-12-05 20:31:14'),(3672,'2023-12-05 06:53:01','2023-12-05 15:31:46','12.249.250.150','12.249.250.150','closed',8,518,'attendances/1774/1701787981 clock_in.png','attendances/1774/1701819106 clock_out.png',NULL,43368,NULL,'2023-12-05 11:53:01','2023-12-05 20:31:46'),(3673,'2023-12-05 06:54:35','2023-12-05 15:45:20','12.249.250.150','12.249.250.150','closed',8,530,'attendances/1948/1701788075 clock_in.png','attendances/1948/1701819921 clock_out.png',NULL,43383,NULL,'2023-12-05 11:54:35','2023-12-05 20:45:21'),(3674,'2023-12-05 06:55:18','2023-12-05 15:31:15','12.249.250.150','12.249.250.150','closed',8,515,'attendances/2168/1701788118 clock_in.png','attendances/2168/1701819075 clock_out.png',NULL,43369,NULL,'2023-12-05 11:55:18','2023-12-05 20:31:15'),(3675,'2023-12-05 06:55:43','2023-12-05 15:30:43','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1934/1701788143 clock_in.png','attendances/1934/1701819043 clock_out.png',NULL,43375,NULL,'2023-12-05 11:55:43','2023-12-05 20:30:43'),(3676,'2023-12-05 06:55:59','2023-12-05 15:36:59','12.249.250.150','12.249.250.150','closed',8,521,'attendances/1958/1701788159 clock_in.png','attendances/1958/1701819419 clock_out.png',NULL,43370,NULL,'2023-12-05 11:55:59','2023-12-05 20:36:59'),(3677,'2023-12-05 06:56:00','2023-12-05 17:05:06','12.249.250.150','12.249.250.150','closed',10,609,'attendances/726/1701788160 clock_in.png','attendances/726/1701824706 clock_out.png',NULL,43362,NULL,'2023-12-05 11:56:00','2023-12-05 22:05:06'),(3678,'2023-12-05 06:56:11','2023-12-05 15:37:18','12.249.250.150','12.249.250.150','closed',8,521,'attendances/1858/1701788171 clock_in.png','attendances/1858/1701819439 clock_out.png',NULL,43377,NULL,'2023-12-05 11:56:12','2023-12-05 20:37:19'),(3679,'2023-12-05 06:56:27','2023-12-05 17:08:42','12.249.250.150','12.249.250.150','closed',10,612,'attendances/1395/1701788187 clock_in.png','attendances/1395/1701824922 clock_out.png',NULL,43381,NULL,'2023-12-05 11:56:27','2023-12-05 22:08:42'),(3680,'2023-12-05 06:56:32','2023-12-05 17:44:11','12.249.250.150','12.249.250.150','closed',10,647,'attendances/2116/1701788192 clock_in.png','attendances/2116/1701827051 clock_out.png',NULL,43365,NULL,'2023-12-05 11:56:32','2023-12-05 22:44:11'),(3681,'2023-12-05 06:59:29','2023-12-05 15:30:26','12.249.250.150','12.249.250.150','closed',8,510,'attendances/2141/1701788369 clock_in.png','attendances/2141/1701819026 clock_out.png',NULL,43378,NULL,'2023-12-05 11:59:29','2023-12-05 20:30:26'),(3682,'2023-12-05 06:59:59','2023-12-05 17:44:46','12.249.250.150','12.249.250.150','closed',10,644,'attendances/2218/1701788399 clock_in.png','attendances/2218/1701827086 clock_out.png',NULL,43374,NULL,'2023-12-05 11:59:59','2023-12-05 22:44:46'),(3683,'2023-12-05 07:00:05','2023-12-05 17:09:26','12.249.250.150','12.249.250.150','closed',10,609,'attendances/1999/1701788405 clock_in.png','attendances/1999/1701824966 clock_out.png',NULL,43372,NULL,'2023-12-05 12:00:05','2023-12-05 22:09:26'),(3684,'2023-12-05 07:00:34','2023-12-05 15:31:00','12.249.250.150','12.249.250.150','closed',8,510,'attendances/1951/1701788434 clock_in.png','attendances/1951/1701819060 clock_out.png',NULL,43366,NULL,'2023-12-05 12:00:34','2023-12-05 20:31:00'),(3685,'2023-12-05 07:01:02','2023-12-05 15:50:36','12.249.250.150','12.249.250.150','closed',8,529,'attendances/974/1701788462 clock_in.png','attendances/974/1701820236 clock_out.png',NULL,43361,NULL,'2023-12-05 12:01:02','2023-12-05 20:50:36'),(3686,'2023-12-05 07:01:39','2023-12-05 15:32:13','12.249.250.150','12.249.250.150','closed',8,510,'attendances/1744/1701788499 clock_in.png','attendances/1744/1701819133 clock_out.png',NULL,43380,NULL,'2023-12-05 12:01:39','2023-12-05 20:32:13'),(3687,'2023-12-05 07:02:40','2023-12-05 15:48:39','12.249.250.150','12.249.250.150','closed',8,525,'attendances/1462/1701788560 clock_in.png','attendances/1462/1701820119 clock_out.png',NULL,43373,NULL,'2023-12-05 12:02:40','2023-12-05 20:48:39'),(3688,'2023-12-05 07:03:47','2023-12-05 16:09:10','12.249.250.150','12.249.250.150','closed',9,545,'attendances/1728/1701788628 clock_in.png','attendances/1728/1701821350 clock_out.png',NULL,43376,NULL,'2023-12-05 12:03:48','2023-12-05 21:09:10'),(3689,'2023-12-05 07:08:46','2023-12-05 15:38:23','12.249.250.150','12.249.250.150','closed',8,509,'attendances/1888/1701788926 clock_in.png','attendances/1888/1701819503 clock_out.png',NULL,43386,NULL,'2023-12-05 12:08:46','2023-12-05 20:38:23'),(3690,'2023-12-05 07:29:08','2023-12-05 17:04:41','12.249.250.150','12.249.250.150','closed',9,575,'attendances/2170/1701790148 clock_in.png','attendances/2170/1701824681 clock_out.png',NULL,43382,NULL,'2023-12-05 12:29:08','2023-12-05 22:04:41'),(3691,'2023-12-05 07:57:49','2023-12-05 16:30:47','12.249.250.150','12.249.250.150','closed',8,512,'attendances/775/1701791869 clock_in.png','attendances/775/1701822647 clock_out.png',NULL,43388,NULL,'2023-12-05 12:57:49','2023-12-05 21:30:47'),(3692,'2023-12-05 07:59:51','2023-12-05 16:32:32','12.249.250.150','12.249.250.150','closed',8,512,'attendances/1869/1701791991 clock_in.png','attendances/1869/1701822752 clock_out.png',NULL,43387,NULL,'2023-12-05 12:59:51','2023-12-05 21:32:32'),(3693,'2023-12-05 08:00:03','2023-12-05 16:32:42','12.249.250.150','12.249.250.150','closed',8,512,'attendances/1891/1701792003 clock_in.png','attendances/1891/1701822762 clock_out.png',NULL,43389,NULL,'2023-12-05 13:00:03','2023-12-05 21:32:42'),(3694,'2023-12-05 08:29:50','2023-12-05 18:04:35','12.249.250.150','12.249.250.150','closed',9,574,'attendances/1479/1701793790 clock_in.png','attendances/1479/1701828275 clock_out.png',NULL,43390,NULL,'2023-12-05 13:29:50','2023-12-05 23:04:35'),(3695,'2023-12-05 08:30:00','2023-12-05 18:04:46','12.249.250.150','12.249.250.150','closed',9,574,'attendances/2200/1701793800 clock_in.png','attendances/2200/1701828286 clock_out.png',NULL,43391,NULL,'2023-12-05 13:30:00','2023-12-05 23:04:46'),(3697,'2023-12-06 05:27:37','2023-12-06 20:14:00','12.249.250.150','12.249.250.150','closed',14,886,'attendances/1116/1701869257 clock_in.png','attendances/1116/1701922462 clock_out.png',NULL,43413,NULL,'2023-12-06 10:27:37','2023-12-07 01:14:22'),(3698,'2023-12-06 05:32:30','2023-12-06 20:05:00','12.249.250.150','12.249.250.150','closed',14,872,'attendances/2170/1701869550 clock_in.png','attendances/2170/1701921917 clock_out.png',NULL,43414,NULL,'2023-12-06 10:32:30','2023-12-07 01:05:17'),(3699,'2023-12-06 05:53:36','2023-12-06 17:10:00','12.249.250.150','12.249.250.150','closed',11,676,'attendances/2076/1701870816 clock_in.png','attendances/2076/1701911423 clock_out.png',NULL,43416,NULL,'2023-12-06 10:53:36','2023-12-06 22:10:23'),(3700,'2023-12-06 05:56:19','2023-12-06 17:53:00','12.249.250.150','12.249.250.150','closed',11,716,'attendances/2169/1701870979 clock_in.png','attendances/2169/1701913980 clock_out.png',NULL,43415,NULL,'2023-12-06 10:56:19','2023-12-06 22:53:00'),(3702,'2023-12-06 06:04:00','2023-12-06 17:10:00','12.249.250.150','12.249.250.150','closed',11,666,'attendances/2222/1701871442 clock_in.png','attendances/2222/1701911425 clock_out.png',NULL,43417,NULL,'2023-12-06 11:04:02','2023-12-06 22:10:25'),(3703,'2023-12-06 06:10:00','2023-12-06 20:02:00','12.249.250.150','12.249.250.150','closed',13,832,'attendances/1999/1701871845 clock_in.png','attendances/1999/1701921778 clock_out.png',NULL,43431,NULL,'2023-12-06 11:10:45','2023-12-07 01:02:58'),(3704,'2023-12-06 06:37:00','2023-12-06 20:03:00','12.249.250.150','12.249.250.150','closed',13,806,'attendances/974/1701873430 clock_in.png','attendances/974/1701921788 clock_out.png',NULL,43418,NULL,'2023-12-06 11:37:10','2023-12-07 01:03:08'),(3705,'2023-12-06 06:40:00','2023-12-06 15:44:00','12.249.250.150','12.249.250.150','closed',9,544,'attendances/622/1701873623 clock_in.png','attendances/622/1701906289 clock_out.png',NULL,43441,NULL,'2023-12-06 11:40:23','2023-12-06 20:44:49'),(3706,'2023-12-06 06:50:00','2023-12-06 17:54:00','12.249.250.150','12.249.250.150','closed',11,664,'attendances/2094/1701874224 clock_in.png','attendances/2094/1701914067 clock_out.png',NULL,43440,NULL,'2023-12-06 11:50:24','2023-12-06 22:54:27'),(3707,'2023-12-06 06:52:00','2023-12-06 15:44:00','12.249.250.150','12.249.250.150','closed',8,532,'attendances/1774/1701874349 clock_in.png','attendances/1774/1701906264 clock_out.png',NULL,43427,NULL,'2023-12-06 11:52:29','2023-12-06 20:44:24'),(3708,'2023-12-06 06:53:00','2023-12-06 15:33:00','12.249.250.150','12.249.250.150','closed',8,520,'attendances/2179/1701874381 clock_in.png','attendances/2179/1701905633 clock_out.png',NULL,43442,NULL,'2023-12-06 11:53:01','2023-12-06 20:33:53'),(3709,'2023-12-06 06:53:00','2023-12-06 15:33:00','12.249.250.150','12.249.250.150','closed',8,520,'attendances/2178/1701874394 clock_in.png','attendances/2178/1701905619 clock_out.png',NULL,43421,NULL,'2023-12-06 11:53:14','2023-12-06 20:33:39'),(3710,'2023-12-06 06:54:00','2023-12-06 15:39:00','12.249.250.150','12.249.250.150','closed',8,525,'attendances/1934/1701874469 clock_in.png','attendances/1934/1701905953 clock_out.png',NULL,43434,NULL,'2023-12-06 11:54:29','2023-12-06 20:39:13'),(3711,'2023-12-06 06:55:00','2023-12-06 19:20:00','12.249.250.150','12.249.250.150','closed',12,745,'attendances/2008/1701874510 clock_in.png','attendances/2008/1701919243 clock_out.png',NULL,43430,NULL,'2023-12-06 11:55:10','2023-12-07 00:20:43'),(3712,'2023-12-06 06:55:00','2023-12-06 15:44:00','12.249.250.150','12.249.250.150','closed',8,529,'attendances/2168/1701874521 clock_in.png','attendances/2168/1701906279 clock_out.png',NULL,43428,NULL,'2023-12-06 11:55:21','2023-12-06 20:44:39'),(3713,'2023-12-06 06:55:00','2023-12-06 20:19:00','12.249.250.150','12.249.250.150','closed',13,804,'attendances/2200/1701874557 clock_in.png','attendances/2200/1701922762 clock_out.png',NULL,43425,NULL,'2023-12-06 11:55:57','2023-12-07 01:19:23'),(3714,'2023-12-06 06:56:00','2023-12-06 15:45:00','12.249.250.150','12.249.250.150','closed',8,529,'attendances/1744/1701874569 clock_in.png','attendances/1744/1701906305 clock_out.png',NULL,43438,NULL,'2023-12-06 11:56:09','2023-12-06 20:45:05'),(3715,'2023-12-06 06:57:00','2023-12-06 16:33:00','12.249.250.150','12.249.250.150','closed',9,576,'attendances/1568/1701874644 clock_in.png','attendances/1568/1701909193 clock_out.png',NULL,43422,NULL,'2023-12-06 11:57:24','2023-12-06 21:33:13'),(3716,'2023-12-06 06:57:00','2023-12-06 16:32:00','12.249.250.150','12.249.250.150','closed',9,575,'attendances/2133/1701874660 clock_in.png','attendances/2133/1701909170 clock_out.png',NULL,43437,NULL,'2023-12-06 11:57:40','2023-12-06 21:32:50'),(3717,'2023-12-06 06:57:00','2023-12-06 15:37:00','12.249.250.150','12.249.250.150','closed',8,520,'attendances/1958/1701874679 clock_in.png','attendances/1958/1701905857 clock_out.png',NULL,43429,NULL,'2023-12-06 11:57:59','2023-12-06 20:37:37'),(3718,'2023-12-06 06:58:00','2023-12-06 20:00:00','12.249.250.150','12.249.250.150','closed',13,782,'attendances/2218/1701874697 clock_in.png','attendances/2218/1701921619 clock_out.png',NULL,43433,NULL,'2023-12-06 11:58:17','2023-12-07 01:00:19'),(3719,'2023-12-06 06:58:00','2023-12-06 19:30:00','12.249.250.150','12.249.250.150','closed',12,752,'attendances/2116/1701874704 clock_in.png','attendances/2116/1701919821 clock_out.png',NULL,43423,NULL,'2023-12-06 11:58:24','2023-12-07 00:30:21'),(3720,'2023-12-06 06:58:00','2023-12-06 20:01:00','12.249.250.150','12.249.250.150','closed',13,783,'attendances/1951/1701874712 clock_in.png','attendances/1951/1701921684 clock_out.png',NULL,43424,NULL,'2023-12-06 11:58:32','2023-12-07 01:01:24'),(3721,'2023-12-06 06:58:00','2023-12-06 19:20:00','12.249.250.150','12.249.250.150','closed',12,742,'attendances/2150/1701874736 clock_in.png','attendances/2150/1701919257 clock_out.png',NULL,43419,NULL,'2023-12-06 11:58:56','2023-12-07 00:20:57'),(3722,'2023-12-06 06:59:00','2023-12-06 18:10:00','12.249.250.150','12.249.250.150','closed',11,671,'attendances/2231/1701874764 clock_in.png','attendances/2231/1701915011 clock_out.png',NULL,43420,NULL,'2023-12-06 11:59:24','2023-12-06 23:10:11'),(3723,'2023-12-06 07:00:00','2023-12-06 16:37:00','12.249.250.150','12.249.250.150','closed',9,577,'attendances/1948/1701874855 clock_in.png','attendances/1948/1701909447 clock_out.png',NULL,43439,NULL,'2023-12-06 12:00:55','2023-12-06 21:37:27'),(3724,'2023-12-06 07:03:00','2023-12-06 16:07:00','12.249.250.150','12.249.250.150','closed',9,544,'attendances/1728/1701874984 clock_in.png','attendances/1728/1701907637 clock_out.png',NULL,43435,NULL,'2023-12-06 12:03:04','2023-12-06 21:07:17'),(3725,'2023-12-06 07:06:00','2023-12-06 15:42:00','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1462/1701875195 clock_in.png','attendances/1462/1701906167 clock_out.png',NULL,43432,NULL,'2023-12-06 12:06:35','2023-12-06 20:42:47'),(3726,'2023-12-06 07:06:00','2023-12-06 19:38:00','12.249.250.150','12.249.250.150','closed',12,752,'attendances/2195/1701875207 clock_in.png','attendances/2195/1701920309 clock_out.png',NULL,43426,NULL,'2023-12-06 12:06:47','2023-12-07 00:38:29'),(3727,'2023-12-06 07:11:00','2023-12-06 15:50:00','12.249.250.150','12.249.250.150','closed',8,519,'attendances/1888/1701875500 clock_in.png','attendances/1888/1701906654 clock_out.png',NULL,43443,NULL,'2023-12-06 12:11:40','2023-12-06 20:50:54'),(3728,'2023-12-06 07:11:00','2023-12-06 15:37:00','12.249.250.150','12.249.250.150','closed',8,506,'attendances/1858/1701875512 clock_in.png','attendances/1858/1701905873 clock_out.png',NULL,43436,NULL,'2023-12-06 12:11:52','2023-12-06 20:37:53'),(3729,'2023-12-06 07:58:00','2023-12-06 16:31:00','12.249.250.150','12.249.250.150','closed',8,513,'attendances/1869/1701878332 clock_in.png','attendances/1869/1701909090 clock_out.png',NULL,43444,NULL,'2023-12-06 12:58:52','2023-12-06 21:31:30'),(3730,'2023-12-06 07:59:00','2023-12-06 16:30:00','12.249.250.150','12.249.250.150','closed',8,511,'attendances/775/1701878363 clock_in.png','attendances/775/1701909032 clock_out.png',NULL,43445,NULL,'2023-12-06 12:59:23','2023-12-06 21:30:32'),(3731,'2023-12-06 08:02:00','2023-12-06 16:31:00','12.249.250.150','12.249.250.150','closed',8,509,'attendances/1891/1701878549 clock_in.png','attendances/1891/1701909099 clock_out.png',NULL,43446,NULL,'2023-12-06 13:02:29','2023-12-06 21:31:39'),(3733,'2023-12-06 08:55:00','2023-12-06 17:42:00','12.249.250.150','12.249.250.150','closed',8,527,'attendances/2061/1701881713 clock_in.png','attendances/2061/1701913357 clock_out.png',NULL,43449,NULL,'2023-12-06 13:55:13','2023-12-06 22:42:37'),(3734,'2023-12-06 08:59:00','2023-12-06 17:43:00','12.249.250.150','12.249.250.150','closed',8,524,'attendances/2141/1701881993 clock_in.png','attendances/2141/1701913390 clock_out.png',NULL,43447,NULL,'2023-12-06 13:59:53','2023-12-06 22:43:10'),(3735,'2023-12-06 08:55:00','2023-12-06 17:42:00','190.103.31.245','12.249.250.150','closed',8,527,NULL,'attendances/2047/1701913373 clock_out.png',NULL,43448,NULL,'2023-12-06 22:37:34','2023-12-06 22:42:53'),(3736,'2023-12-07 05:53:00','2023-12-07 15:53:00','12.249.250.150','12.249.250.150','closed',10,600,'attendances/2178/1701957184 clock_in.png','attendances/2178/1701993218 clock_out.png',NULL,43458,NULL,'2023-12-07 10:53:04','2023-12-07 20:53:38'),(3737,'2023-12-07 05:53:00','2023-12-07 15:53:00','12.249.250.150','12.249.250.150','closed',10,600,'attendances/2179/1701957195 clock_in.png','attendances/2179/1701993234 clock_out.png',NULL,43469,NULL,'2023-12-07 10:53:15','2023-12-07 20:53:54'),(3738,'2023-12-07 05:53:00','2023-12-07 16:55:00','12.249.250.150','12.249.250.150','closed',11,662,'attendances/1585/1701957214 clock_in.png','attendances/1585/1701996934 clock_out.png',NULL,43459,NULL,'2023-12-07 10:53:34','2023-12-07 21:55:34'),(3739,'2023-12-07 05:54:00','2023-12-07 15:58:00','12.249.250.150','12.249.250.150','closed',10,604,'attendances/1551/1701957249 clock_in.png','attendances/1551/1701993522 clock_out.png',NULL,43457,NULL,'2023-12-07 10:54:09','2023-12-07 20:58:42'),(3740,'2023-12-07 05:54:00','2023-12-07 15:25:00','12.249.250.150','12.249.250.150','closed',9,571,'attendances/2141/1701957279 clock_in.png','attendances/2141/1701991559 clock_out.png',NULL,43461,NULL,'2023-12-07 10:54:39','2023-12-07 20:25:59'),(3741,'2023-12-07 05:57:00','2023-12-07 21:00:00','12.249.250.150','12.249.250.150','closed',15,903,'attendances/2047/1701957447 clock_in.png','attendances/2047/1702011649 clock_out.png',NULL,43462,NULL,'2023-12-07 10:57:27','2023-12-08 02:00:49'),(3742,'2023-12-07 05:57:00','2023-12-07 21:00:00','12.249.250.150','12.249.250.150','closed',15,903,'attendances/2061/1701957457 clock_in.png','attendances/2061/1702011633 clock_out.png',NULL,43463,NULL,'2023-12-07 10:57:37','2023-12-08 02:00:33'),(3743,'2023-12-07 05:58:00','2023-12-07 15:00:00','12.249.250.150','38.51.234.69','closed',9,542,'attendances/2218/1701957491 clock_in.png',NULL,NULL,43485,NULL,'2023-12-07 10:58:11','2023-12-08 11:35:32'),(3744,'2023-12-07 05:58:00','2023-12-07 15:07:00','12.249.250.150','12.249.250.150','closed',9,549,'attendances/2116/1701957497 clock_in.png','attendances/2116/1701990479 clock_out.png',NULL,43474,NULL,'2023-12-07 10:58:17','2023-12-07 20:07:59'),(3745,'2023-12-07 05:58:00','2023-12-07 15:07:00','12.249.250.150','12.249.250.150','closed',9,549,'attendances/2169/1701957517 clock_in.png','attendances/2169/1701990470 clock_out.png',NULL,43460,NULL,'2023-12-07 10:58:37','2023-12-07 20:07:50'),(3746,'2023-12-07 05:59:00','2023-12-07 15:28:00','12.249.250.150','12.249.250.150','closed',9,569,'attendances/2076/1701957585 clock_in.png','attendances/2076/1701991735 clock_out.png',NULL,43467,NULL,'2023-12-07 10:59:45','2023-12-07 20:28:55'),(3747,'2023-12-07 05:59:00','2023-12-07 17:32:00','12.249.250.150','12.249.250.150','closed',11,693,'attendances/726/1701957596 clock_in.png','attendances/726/1701999161 clock_out.png',NULL,43456,NULL,'2023-12-07 10:59:56','2023-12-07 22:32:41'),(3748,'2023-12-07 06:00:00','2023-12-07 15:29:00','12.249.250.150','12.249.250.150','closed',9,569,'attendances/2094/1701957608 clock_in.png','attendances/2094/1701991754 clock_out.png',NULL,43465,NULL,'2023-12-07 11:00:08','2023-12-07 20:29:14'),(3749,'2023-12-07 06:01:00','2023-12-07 17:00:00','12.249.250.150','12.249.250.150','closed',10,659,'attendances/1450/1701957661 clock_in.png','attendances/1450/1701997257 clock_out.png',NULL,43466,NULL,'2023-12-07 11:01:01','2023-12-07 22:00:57'),(3750,'2023-12-07 06:01:00','2023-12-07 18:28:00','12.249.250.150','12.249.250.150','closed',12,747,'attendances/2170/1701957678 clock_in.png','attendances/2170/1702002485 clock_out.png',NULL,43464,NULL,'2023-12-07 11:01:18','2023-12-07 23:28:05'),(3751,'2023-12-07 06:01:00','2023-12-07 15:26:00','12.249.250.150','12.249.250.150','closed',9,565,'attendances/2222/1701957719 clock_in.png','attendances/2222/1701991603 clock_out.png',NULL,43468,NULL,'2023-12-07 11:01:59','2023-12-07 20:26:43'),(3752,'2023-12-07 06:18:00','2023-12-07 15:38:00','12.249.250.150','12.249.250.150','closed',9,560,'attendances/1948/1701958693 clock_in.png','attendances/1948/1701992319 clock_out.png',NULL,43494,NULL,'2023-12-07 11:18:13','2023-12-07 20:38:39'),(3753,'2023-12-07 06:31:00','2023-12-07 17:51:00','12.249.250.150','12.249.250.150','closed',11,680,'attendances/622/1701959509 clock_in.png','attendances/622/1702000307 clock_out.png',NULL,43496,NULL,'2023-12-07 11:31:49','2023-12-07 22:51:47'),(3754,'2023-12-07 06:48:00','2023-12-07 22:03:00','12.249.250.150','12.249.250.150','closed',15,915,'attendances/1999/1701960539 clock_in.png','attendances/1999/1702015427 clock_out.png',NULL,43483,NULL,'2023-12-07 11:48:59','2023-12-08 03:03:47'),(3755,'2023-12-07 06:53:00','2023-12-07 17:51:00','12.249.250.150','12.249.250.150','closed',10,658,'attendances/1774/1701960787 clock_in.png','attendances/1774/1702000319 clock_out.png',NULL,43479,NULL,'2023-12-07 11:53:07','2023-12-07 22:51:59'),(3756,'2023-12-07 06:53:00','2023-12-07 16:26:00','12.249.250.150','12.249.250.150','closed',9,573,'attendances/2058/1701960803 clock_in.png','attendances/2058/1701995206 clock_out.png',NULL,43495,NULL,'2023-12-07 11:53:23','2023-12-07 21:26:46'),(3757,'2023-12-07 06:53:00','2023-12-07 17:00:00','12.249.250.150','12.249.250.150','closed',10,607,'attendances/1568/1701960836 clock_in.png','attendances/1568/1701997246 clock_out.png',NULL,43473,NULL,'2023-12-07 11:53:56','2023-12-07 22:00:46'),(3758,'2023-12-07 06:54:00','2023-12-07 20:56:00','12.249.250.150','12.249.250.150','closed',14,842,'attendances/1116/1701960843 clock_in.png','attendances/1116/1702011393 clock_out.png',NULL,43491,NULL,'2023-12-07 11:54:03','2023-12-08 01:56:33'),(3759,'2023-12-07 06:54:00','2023-12-07 15:30:00','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1744/1701960864 clock_in.png','attendances/1744/1701991818 clock_out.png',NULL,43492,NULL,'2023-12-07 11:54:24','2023-12-07 20:30:18'),(3760,'2023-12-07 06:54:00','2023-12-07 21:46:00','12.249.250.150','12.249.250.150','closed',14,892,'attendances/1395/1701960890 clock_in.png','attendances/1395/1702014370 clock_out.png',NULL,43493,NULL,'2023-12-07 11:54:50','2023-12-08 02:46:10'),(3761,'2023-12-07 06:55:00','2023-12-07 17:52:00','12.249.250.150','12.249.250.150','closed',10,657,'attendances/1934/1701960910 clock_in.png','attendances/1934/1702000361 clock_out.png',NULL,43486,NULL,'2023-12-07 11:55:10','2023-12-07 22:52:41'),(3762,'2023-12-07 06:55:00','2023-12-07 16:06:00','12.249.250.150','12.249.250.150','closed',9,551,'attendances/1728/1701960912 clock_in.png','attendances/1728/1701993998 clock_out.png',NULL,43487,NULL,'2023-12-07 11:55:12','2023-12-07 21:06:38'),(3763,'2023-12-07 06:55:00','2023-12-07 17:53:00','12.249.250.150','12.249.250.150','closed',10,658,'attendances/2008/1701960927 clock_in.png','attendances/2008/1702000397 clock_out.png',NULL,43482,NULL,'2023-12-07 11:55:27','2023-12-07 22:53:17'),(3764,'2023-12-07 06:55:00','2023-12-07 20:38:00','12.249.250.150','12.249.250.150','closed',13,823,'attendances/1479/1701960952 clock_in.png','attendances/1479/1702010308 clock_out.png',NULL,43475,NULL,'2023-12-07 11:55:52','2023-12-08 01:38:28'),(3765,'2023-12-07 06:55:00','2023-12-07 15:30:00','12.249.250.150','12.249.250.150','closed',8,515,'attendances/2168/1701960954 clock_in.png','attendances/2168/1701991815 clock_out.png',NULL,43480,NULL,'2023-12-07 11:55:54','2023-12-07 20:30:15'),(3766,'2023-12-07 06:56:00','2023-12-07 16:27:00','12.249.250.150','12.249.250.150','closed',9,571,'attendances/2224/1701960974 clock_in.png','attendances/2224/1701995239 clock_out.png',NULL,43488,NULL,'2023-12-07 11:56:14','2023-12-07 21:27:19'),(3767,'2023-12-07 06:56:00','2023-12-07 15:32:00','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1858/1701960986 clock_in.png','attendances/1858/1701991959 clock_out.png',NULL,43489,NULL,'2023-12-07 11:56:26','2023-12-07 20:32:39'),(3768,'2023-12-07 06:56:00','2023-12-07 22:03:00','12.249.250.150','12.249.250.150','closed',15,907,'attendances/974/1701960996 clock_in.png','attendances/974/1702015416 clock_out.png',NULL,43470,NULL,'2023-12-07 11:56:36','2023-12-08 03:03:36'),(3769,'2023-12-07 06:56:00','2023-12-07 22:03:00','12.249.250.150','12.249.250.150','closed',15,907,'attendances/2200/1701961005 clock_in.png','attendances/2200/1702015437 clock_out.png',NULL,43477,NULL,'2023-12-07 11:56:45','2023-12-08 03:03:57'),(3770,'2023-12-07 06:58:00','2023-12-07 15:32:00','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1958/1701961105 clock_in.png','attendances/1958/1701991946 clock_out.png',NULL,43481,NULL,'2023-12-07 11:58:25','2023-12-07 20:32:26'),(3771,'2023-12-07 06:59:00','2023-12-07 16:44:00','12.249.250.150','12.249.250.150','closed',9,585,'attendances/1951/1701961164 clock_in.png','attendances/1951/1701996264 clock_out.png',NULL,43476,NULL,'2023-12-07 11:59:24','2023-12-07 21:44:24'),(3772,'2023-12-07 06:59:00','2023-12-07 16:55:00','12.249.250.150','12.249.250.150','closed',9,596,'attendances/2150/1701961179 clock_in.png','attendances/2150/1701996919 clock_out.png',NULL,43471,NULL,'2023-12-07 11:59:39','2023-12-07 21:55:19'),(3773,'2023-12-07 06:59:00','2023-12-07 16:55:00','12.249.250.150','12.249.250.150','closed',9,596,'attendances/2133/1701961181 clock_in.png','attendances/2133/1701996946 clock_out.png',NULL,43490,NULL,'2023-12-07 11:59:41','2023-12-07 21:55:46'),(3774,'2023-12-07 07:00:00','2023-12-07 20:12:00','12.249.250.150','12.249.250.150','closed',13,792,'attendances/2195/1701961241 clock_in.png','attendances/2195/1702008730 clock_out.png',NULL,43478,NULL,'2023-12-07 12:00:41','2023-12-08 01:12:10'),(3775,'2023-12-07 07:00:00','2023-12-07 20:11:00','12.249.250.150','12.249.250.150','closed',13,791,'attendances/2230/1701961255 clock_in.png','attendances/2230/1702008711 clock_out.png',NULL,43472,NULL,'2023-12-07 12:00:55','2023-12-08 01:11:51'),(3776,'2023-12-07 07:01:00','2023-12-07 16:23:00','12.249.250.150','12.249.250.150','closed',9,562,'attendances/1888/1701961305 clock_in.png','attendances/1888/1701995022 clock_out.png',NULL,43497,NULL,'2023-12-07 12:01:45','2023-12-07 21:23:42'),(3777,'2023-12-07 07:06:00','2023-12-07 15:38:00','12.249.250.150','12.249.250.150','closed',8,512,'attendances/1462/1701961571 clock_in.png','attendances/1462/1701992306 clock_out.png',NULL,43484,NULL,'2023-12-07 12:06:11','2023-12-07 20:38:26'),(3778,'2023-12-07 07:58:00','2023-12-07 16:30:00','12.249.250.150','12.249.250.150','closed',8,512,'attendances/775/1701964702 clock_in.png','attendances/775/1701995438 clock_out.png',NULL,43499,NULL,'2023-12-07 12:58:22','2023-12-07 21:30:38'),(3779,'2023-12-07 08:00:00','2023-12-07 16:32:00','12.249.250.150','12.249.250.150','closed',8,512,'attendances/1891/1701964837 clock_in.png','attendances/1891/1701995531 clock_out.png',NULL,43500,NULL,'2023-12-07 13:00:37','2023-12-07 21:32:11'),(3780,'2023-12-07 08:01:00','2023-12-07 16:32:00','12.249.250.150','12.249.250.150','closed',8,511,'attendances/1869/1701964878 clock_in.png','attendances/1869/1701995520 clock_out.png',NULL,43498,NULL,'2023-12-07 13:01:18','2023-12-07 21:32:00'),(3781,'2023-12-08 05:52:00','2023-12-08 20:49:00','12.249.250.150','12.249.250.150','closed',14,897,'attendances/1116/1702043549 clock_in.png','attendances/1116/1702097393 clock_out.png',NULL,43526,NULL,'2023-12-08 10:52:29','2023-12-09 01:49:53'),(3782,'2023-12-08 05:54:00','2023-12-08 20:18:00','12.249.250.150','12.249.250.150','closed',14,864,'attendances/1551/1702043699 clock_in.png','attendances/1551/1702095525 clock_out.png',NULL,43522,NULL,'2023-12-08 10:54:59','2023-12-09 01:18:45'),(3783,'2023-12-08 05:55:00','2023-12-08 20:15:00','12.249.250.150','12.249.250.150','closed',14,860,'attendances/2076/1702043736 clock_in.png','attendances/2076/1702095326 clock_out.png',NULL,43529,NULL,'2023-12-08 10:55:36','2023-12-09 01:15:26'),(3784,'2023-12-08 05:56:00','2023-12-08 16:00:00','12.249.250.150','12.249.250.150','closed',10,604,'attendances/726/1702043779 clock_in.png','attendances/726/1702080042 clock_out.png',NULL,43521,NULL,'2023-12-08 10:56:19','2023-12-08 21:00:42'),(3785,'2023-12-08 05:56:00','2023-12-08 17:24:00','12.249.250.150','12.249.250.150','closed',11,688,'attendances/1568/1702043813 clock_in.png','attendances/1568/1702085063 clock_out.png',NULL,43524,NULL,'2023-12-08 10:56:53','2023-12-08 22:24:23'),(3786,'2023-12-08 05:57:00','2023-12-08 20:18:00','12.249.250.150','12.249.250.150','closed',14,861,'attendances/1585/1702043835 clock_in.png','attendances/1585/1702095509 clock_out.png',NULL,43523,NULL,'2023-12-08 10:57:15','2023-12-09 01:18:29'),(3787,'2023-12-08 05:58:00','2023-12-08 15:35:00','12.249.250.150','12.249.250.150','closed',9,577,'attendances/1958/1702043884 clock_in.png','attendances/1958/1702078509 clock_out.png',NULL,43545,NULL,'2023-12-08 10:58:04','2023-12-08 20:35:09'),(3788,'2023-12-08 05:58:00','2023-12-08 20:17:00','12.249.250.150','12.249.250.150','closed',14,859,'attendances/1450/1702043906 clock_in.png','attendances/1450/1702095435 clock_out.png',NULL,43528,NULL,'2023-12-08 10:58:26','2023-12-09 01:17:15'),(3789,'2023-12-08 05:58:00','2023-12-08 17:24:00','12.249.250.150','12.249.250.150','closed',11,686,'attendances/2133/1702043926 clock_in.png','attendances/2133/1702085062 clock_out.png',NULL,43525,NULL,'2023-12-08 10:58:46','2023-12-08 22:24:22'),(3790,'2023-12-08 05:59:00','2023-12-08 20:13:00','12.249.250.150','12.249.250.150','closed',14,854,'attendances/2222/1702043994 clock_in.png','attendances/2222/1702095181 clock_out.png',NULL,43530,NULL,'2023-12-08 10:59:54','2023-12-09 01:13:01'),(3791,'2023-12-08 06:02:00','2023-12-08 21:03:00','12.249.250.150','38.51.234.69','closed',15,901,'attendances/2058/1702044146 clock_in.png','attendances/2058/1702098049 clock_out.png',NULL,43527,NULL,'2023-12-08 11:02:26','2023-12-10 13:59:32'),(3792,'2023-12-08 06:11:00','2023-12-08 15:34:00','12.249.250.150','12.249.250.150','closed',9,563,'attendances/1858/1702044699 clock_in.png','attendances/1858/1702078499 clock_out.png',NULL,43554,NULL,'2023-12-08 11:11:39','2023-12-08 20:34:59'),(3793,'2023-12-08 06:33:00','2023-12-08 22:11:00','12.249.250.150','12.249.250.150','closed',15,938,'attendances/1395/1702045994 clock_in.png','attendances/1395/1702102297 clock_out.png',NULL,43555,NULL,'2023-12-08 11:33:14','2023-12-09 03:11:37'),(3794,'2023-12-08 06:33:00','2023-12-08 18:42:00','12.249.250.150','12.249.250.150','closed',12,729,'attendances/2170/1702046028 clock_in.png','attendances/2170/1702089750 clock_out.png',NULL,43533,NULL,'2023-12-08 11:33:48','2023-12-08 23:42:30'),(3795,'2023-12-08 06:34:00','2023-12-08 21:06:00','12.249.250.150','12.249.250.150','closed',14,872,'attendances/2195/1702046043 clock_in.png','attendances/2195/1702098383 clock_out.png',NULL,43532,NULL,'2023-12-08 11:34:03','2023-12-09 02:06:23'),(3796,'2023-12-08 06:34:00','2023-12-08 20:54:00','12.249.250.150','12.249.250.150','closed',14,860,'attendances/1749/1702046049 clock_in.png','attendances/1749/1702097694 clock_out.png',NULL,43531,NULL,'2023-12-08 11:34:09','2023-12-09 01:54:54'),(3797,'2023-12-08 06:41:00','2023-12-08 15:31:00','12.249.250.150','12.249.250.150','closed',8,530,'attendances/622/1702046462 clock_in.png','attendances/622/1702078285 clock_out.png',NULL,43558,NULL,'2023-12-08 11:41:02','2023-12-08 20:31:25'),(3798,'2023-12-08 06:50:00','2023-12-08 22:27:00','12.249.250.150','12.249.250.150','closed',15,937,'attendances/1999/1702047034 clock_in.png','attendances/1999/1702103220 clock_out.png',NULL,43548,NULL,'2023-12-08 11:50:34','2023-12-09 03:27:00'),(3799,'2023-12-08 06:51:00','2023-12-08 15:31:00','12.249.250.150','12.249.250.150','closed',8,520,'attendances/1774/1702047072 clock_in.png','attendances/1774/1702078306 clock_out.png',NULL,43543,NULL,'2023-12-08 11:51:12','2023-12-08 20:31:46'),(3800,'2023-12-08 06:52:00','2023-12-08 16:50:00','12.249.250.150','12.249.250.150','closed',9,598,'attendances/2008/1702047160 clock_in.png','attendances/2008/1702083000 clock_out.png',NULL,43547,NULL,'2023-12-08 11:52:40','2023-12-08 21:50:00'),(3801,'2023-12-08 06:53:00','2023-12-08 22:12:00','12.249.250.150','12.249.250.150','closed',15,919,'attendances/2061/1702047227 clock_in.png','attendances/2061/1702102358 clock_out.png',NULL,43551,NULL,'2023-12-08 11:53:47','2023-12-09 03:12:38'),(3802,'2023-12-08 06:54:00','2023-12-08 22:27:00','12.249.250.150','12.249.250.150','closed',15,933,'attendances/974/1702047244 clock_in.png','attendances/974/1702103235 clock_out.png',NULL,43535,NULL,'2023-12-08 11:54:04','2023-12-09 03:27:15'),(3803,'2023-12-08 06:54:00','2023-12-08 22:13:00','12.249.250.150','12.249.250.150','closed',15,919,'attendances/2047/1702047262 clock_in.png','attendances/2047/1702102406 clock_out.png',NULL,43546,NULL,'2023-12-08 11:54:22','2023-12-09 03:13:26'),(3804,'2023-12-08 06:54:00','2023-12-08 19:23:00','12.249.250.150','12.249.250.150','closed',12,749,'attendances/2179/1702047290 clock_in.png','attendances/2179/1702092203 clock_out.png',NULL,43561,NULL,'2023-12-08 11:54:50','2023-12-09 00:23:23'),(3805,'2023-12-08 06:55:00','2023-12-08 18:27:00','12.249.250.150','12.249.250.150','closed',11,692,'attendances/2169/1702047317 clock_in.png','attendances/2169/1702088871 clock_out.png',NULL,43539,NULL,'2023-12-08 11:55:17','2023-12-08 23:27:51'),(3806,'2023-12-08 06:55:00','2023-12-08 19:23:00','12.249.250.150','12.249.250.150','closed',12,748,'attendances/2178/1702047322 clock_in.png','attendances/2178/1702092216 clock_out.png',NULL,43537,NULL,'2023-12-08 11:55:22','2023-12-09 00:23:36'),(3807,'2023-12-08 06:55:00','2023-12-08 16:11:00','12.249.250.150','12.249.250.150','closed',9,556,'attendances/1728/1702047328 clock_in.png','attendances/1728/1702080700 clock_out.png',NULL,43553,NULL,'2023-12-08 11:55:28','2023-12-08 21:11:40'),(3808,'2023-12-08 06:55:00','2023-12-08 15:31:00','12.249.250.150','12.249.250.150','closed',8,516,'attendances/2168/1702047337 clock_in.png','attendances/2168/1702078295 clock_out.png',NULL,43544,NULL,'2023-12-08 11:55:37','2023-12-08 20:31:35'),(3809,'2023-12-08 06:55:00','2023-12-08 15:32:00','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1934/1702047347 clock_in.png','attendances/1934/1702078360 clock_out.png',NULL,43552,NULL,'2023-12-08 11:55:47','2023-12-08 20:32:40'),(3810,'2023-12-08 06:56:00','2023-12-08 18:13:00','12.249.250.150','12.249.250.150','closed',11,677,'attendances/2200/1702047390 clock_in.png','attendances/2200/1702088030 clock_out.png',NULL,43541,NULL,'2023-12-08 11:56:30','2023-12-08 23:13:50'),(3811,'2023-12-08 06:56:00','2023-12-08 21:00:00','12.249.250.150','12.249.250.150','closed',14,844,'attendances/2224/1702047408 clock_in.png','attendances/2224/1702098058 clock_out.png',NULL,43559,NULL,'2023-12-08 11:56:48','2023-12-09 02:00:58'),(3812,'2023-12-08 06:57:00','2023-12-08 15:30:00','12.249.250.150','38.51.234.69','closed',8,513,'attendances/2150/1702047434 clock_in.png',NULL,NULL,43536,NULL,'2023-12-08 11:57:14','2023-12-10 14:03:27'),(3813,'2023-12-08 06:57:00','2023-12-08 18:15:00','12.249.250.150','12.249.250.150','closed',11,678,'attendances/2230/1702047465 clock_in.png','attendances/2230/1702088105 clock_out.png',NULL,43560,NULL,'2023-12-08 11:57:45','2023-12-08 23:15:05'),(3814,'2023-12-08 06:58:00','2023-12-08 15:53:00','12.249.250.150','12.249.250.150','closed',8,535,'attendances/1948/1702047524 clock_in.png','attendances/1948/1702079625 clock_out.png',NULL,43556,NULL,'2023-12-08 11:58:44','2023-12-08 20:53:45'),(3815,'2023-12-08 06:59:00','2023-12-08 20:45:00','12.249.250.150','12.249.250.150','closed',13,826,'attendances/2141/1702047553 clock_in.png','attendances/2141/1702097143 clock_out.png',NULL,43542,NULL,'2023-12-08 11:59:13','2023-12-09 01:45:43'),(3816,'2023-12-08 06:59:00','2023-12-08 18:27:00','12.249.250.150','12.249.250.150','closed',11,688,'attendances/2116/1702047556 clock_in.png','attendances/2116/1702088870 clock_out.png',NULL,43538,NULL,'2023-12-08 11:59:16','2023-12-08 23:27:50'),(3817,'2023-12-08 07:01:00','2023-12-08 18:43:00','12.249.250.150','12.249.250.150','closed',11,702,'attendances/2094/1702047693 clock_in.png','attendances/2094/1702089785 clock_out.png',NULL,43557,NULL,'2023-12-08 12:01:33','2023-12-08 23:43:06'),(3818,'2023-12-08 07:02:00','2023-12-08 15:45:00','12.249.250.150','12.249.250.150','closed',8,523,'attendances/1951/1702047728 clock_in.png','attendances/1951/1702079143 clock_out.png',NULL,43540,NULL,'2023-12-08 12:02:08','2023-12-08 20:45:43'),(3819,'2023-12-08 07:04:00','2023-12-08 16:30:00','12.249.250.150','190.103.31.245','closed',9,566,'attendances/1888/1702047897 clock_in.png',NULL,NULL,43562,NULL,'2023-12-08 12:04:57','2023-12-08 22:26:19'),(3820,'2023-12-08 07:06:00','2023-12-08 15:49:00','12.249.250.150','12.249.250.150','closed',8,523,'attendances/1462/1702047963 clock_in.png','attendances/1462/1702079350 clock_out.png',NULL,43549,NULL,'2023-12-08 12:06:03','2023-12-08 20:49:10'),(3821,'2023-12-08 07:29:00','2023-12-08 20:30:00','12.249.250.150','12.249.250.150','closed',13,781,'attendances/1479/1702049385 clock_in.png','attendances/1479/1702096257 clock_out.png',NULL,43566,NULL,'2023-12-08 12:29:45','2023-12-09 01:30:57'),(3822,'2023-12-08 07:59:00','2023-12-08 16:30:00','12.249.250.150','12.249.250.150','closed',8,511,'attendances/775/1702051177 clock_in.png','attendances/775/1702081804 clock_out.png',NULL,43564,NULL,'2023-12-08 12:59:37','2023-12-08 21:30:04'),(3823,'2023-12-08 08:00:00','2023-12-08 16:33:00','12.249.250.150','12.249.250.150','closed',8,513,'attendances/1869/1702051248 clock_in.png','attendances/1869/1702081995 clock_out.png',NULL,43563,NULL,'2023-12-08 13:00:48','2023-12-08 21:33:15'),(3824,'2023-12-08 08:01:00','2023-12-08 16:33:00','12.249.250.150','12.249.250.150','closed',8,512,'attendances/1891/1702051316 clock_in.png','attendances/1891/1702082009 clock_out.png',NULL,43565,NULL,'2023-12-08 13:01:56','2023-12-08 21:33:29'),(3826,'2023-12-08 20:59:00','2023-12-08 22:50:00','12.249.250.150','12.249.250.150','closed',1,111,'attendances/2178/1702097945 clock_in.png','attendances/2178/1702104622 clock_out.png',NULL,43649,NULL,'2023-12-09 01:59:05','2023-12-09 03:50:22'),(3827,'2023-12-08 20:58:00','2023-12-08 22:50:00','179.19.132.128','12.249.250.150','closed',1,112,'attendances/2179/1702099690 clock_in.png','attendances/2179/1702104612 clock_out.png',NULL,43650,NULL,'2023-12-09 02:28:10','2023-12-09 03:50:12'),(3828,'2023-12-08 22:49:00','2023-12-08 23:59:00','12.249.250.150','38.51.234.69','closed',1,70,'attendances/2200/1702104550 clock_in.png',NULL,NULL,43647,NULL,'2023-12-09 03:49:10','2023-12-09 09:09:09'),(3829,'2023-12-08 23:00:00','2023-12-08 23:59:00','12.249.250.150','38.51.234.69','closed',0,59,'attendances/2230/1702105235 clock_in.png',NULL,NULL,43648,NULL,'2023-12-09 04:00:35','2023-12-09 09:09:59'),(3832,'2023-12-09 00:00:00','2023-12-09 02:33:00','38.51.234.69','38.51.234.69','closed',2,153,NULL,NULL,NULL,43652,NULL,'2023-12-09 09:07:16','2023-12-09 09:07:16'),(3833,'2023-12-09 00:00:00','2023-12-09 02:31:00','38.51.234.69','38.51.234.69','closed',2,151,NULL,NULL,NULL,43651,NULL,'2023-12-09 09:07:39','2023-12-09 09:07:39'),(3834,'2023-12-09 05:50:00','2023-12-09 17:50:00','12.249.250.150','12.249.250.150','closed',12,720,'attendances/1116/1702129836 clock_in.png','attendances/1116/1702173029 clock_out.png',NULL,43624,NULL,'2023-12-09 10:50:36','2023-12-09 22:50:29'),(3835,'2023-12-09 05:54:00','2023-12-09 15:25:00','12.249.250.150','12.249.250.150','closed',9,571,'attendances/622/1702130050 clock_in.png','attendances/622/1702164325 clock_out.png',NULL,43627,NULL,'2023-12-09 10:54:10','2023-12-09 20:25:25'),(3836,'2023-12-09 05:55:00','2023-12-09 14:34:00','12.249.250.150','12.249.250.150','closed',8,519,'attendances/1934/1702130152 clock_in.png','attendances/1934/1702161290 clock_out.png',NULL,43621,NULL,'2023-12-09 10:55:52','2023-12-09 19:34:50'),(3837,'2023-12-09 05:55:00','2023-12-09 17:52:00','12.249.250.150','12.249.250.150','closed',11,717,'attendances/2178/1702130159 clock_in.png','attendances/2178/1702173138 clock_out.png',NULL,43616,NULL,'2023-12-09 10:55:59','2023-12-09 22:52:18'),(3838,'2023-12-09 05:56:00','2023-12-09 17:52:00','12.249.250.150','12.249.250.150','closed',11,716,'attendances/2179/1702130174 clock_in.png','attendances/2179/1702173128 clock_out.png',NULL,43628,NULL,'2023-12-09 10:56:14','2023-12-09 22:52:08'),(3839,'2023-12-09 05:56:00','2023-12-09 15:26:00','12.249.250.150','12.249.250.150','closed',9,570,'attendances/2150/1702130195 clock_in.png','attendances/2150/1702164416 clock_out.png',NULL,43615,NULL,'2023-12-09 10:56:35','2023-12-09 20:26:56'),(3840,'2023-12-09 05:56:00','2023-12-09 17:12:00','12.249.250.150','12.249.250.150','closed',11,676,'attendances/1728/1702130211 clock_in.png','attendances/1728/1702170771 clock_out.png',NULL,43622,NULL,'2023-12-09 10:56:51','2023-12-09 22:12:51'),(3841,'2023-12-09 05:56:00','2023-12-09 15:26:00','12.249.250.150','12.249.250.150','closed',9,570,'attendances/1774/1702130213 clock_in.png','attendances/1774/1702164411 clock_out.png',NULL,43619,NULL,'2023-12-09 10:56:53','2023-12-09 20:26:51'),(3842,'2023-12-09 05:58:00','2023-12-09 16:38:00','12.249.250.150','12.249.250.150','closed',10,640,'attendances/2133/1702130331 clock_in.png','attendances/2133/1702168703 clock_out.png',NULL,43623,NULL,'2023-12-09 10:58:51','2023-12-09 21:38:23'),(3843,'2023-12-09 05:59:00','2023-12-09 16:45:00','12.249.250.150','12.249.250.150','closed',10,646,'attendances/2195/1702130367 clock_in.png','attendances/2195/1702169133 clock_out.png',NULL,43618,NULL,'2023-12-09 10:59:27','2023-12-09 21:45:33'),(3844,'2023-12-09 06:01:00','2023-12-09 15:27:00','12.249.250.150','12.249.250.150','closed',9,566,'attendances/1951/1702130482 clock_in.png','attendances/1951/1702164435 clock_out.png',NULL,43617,NULL,'2023-12-09 11:01:22','2023-12-09 20:27:15'),(3845,'2023-12-09 06:03:00','2023-12-09 15:26:00','12.249.250.150','12.249.250.150','closed',9,563,'attendances/1744/1702130595 clock_in.png','attendances/1744/1702164390 clock_out.png',NULL,43625,NULL,'2023-12-09 11:03:15','2023-12-09 20:26:30'),(3846,'2023-12-09 06:08:00','2023-12-09 14:33:00','12.249.250.150','12.249.250.150','closed',8,505,'attendances/1395/1702130889 clock_in.png','attendances/1395/1702161188 clock_out.png',NULL,43626,NULL,'2023-12-09 11:08:09','2023-12-09 19:33:08'),(3847,'2023-12-09 06:31:00','2023-12-09 16:35:00','12.249.250.150','12.249.250.150','closed',10,604,'attendances/974/1702132311 clock_in.png','attendances/974/1702168509 clock_out.png',NULL,43614,NULL,'2023-12-09 11:31:51','2023-12-09 21:35:09'),(3848,'2023-12-09 06:31:00','2023-12-09 14:34:00','12.249.250.150','12.249.250.150','closed',8,483,'attendances/1999/1702132315 clock_in.png','attendances/1999/1702161248 clock_out.png',NULL,43620,NULL,'2023-12-09 11:31:55','2023-12-09 19:34:08'),(3849,'2023-12-09 06:38:00','2023-12-09 15:26:00','12.249.250.150','12.249.250.150','closed',8,528,'attendances/2168/1702132688 clock_in.png','attendances/2168/1702164399 clock_out.png',NULL,43635,NULL,'2023-12-09 11:38:08','2023-12-09 20:26:39'),(3850,'2023-12-09 06:52:00','2023-12-09 19:18:00','12.249.250.150','12.249.250.150','closed',12,746,'attendances/2047/1702133571 clock_in.png','attendances/2047/1702178287 clock_out.png',NULL,43643,NULL,'2023-12-09 11:52:51','2023-12-10 00:18:07'),(3851,'2023-12-09 06:53:00','2023-12-09 19:17:00','12.249.250.150','12.249.250.150','closed',12,744,'attendances/2061/1702133581 clock_in.png','attendances/2061/1702178268 clock_out.png',NULL,43644,NULL,'2023-12-09 11:53:01','2023-12-10 00:17:48'),(3852,'2023-12-09 06:53:00','2023-12-09 19:20:00','12.249.250.150','12.249.250.150','closed',12,747,'attendances/1585/1702133621 clock_in.png','attendances/1585/1702178407 clock_out.png',NULL,43631,NULL,'2023-12-09 11:53:41','2023-12-10 00:20:07'),(3853,'2023-12-09 06:57:00','2023-12-09 19:30:00','12.249.250.150','12.249.250.150','closed',12,753,'attendances/726/1702133826 clock_in.png','attendances/726/1702179055 clock_out.png',NULL,43629,NULL,'2023-12-09 11:57:06','2023-12-10 00:30:55'),(3854,'2023-12-09 06:57:00','2023-12-09 14:41:00','12.249.250.150','12.249.250.150','closed',7,464,'attendances/2200/1702133853 clock_in.png','attendances/2200/1702161686 clock_out.png',NULL,43633,NULL,'2023-12-09 11:57:33','2023-12-09 19:41:26'),(3855,'2023-12-09 06:57:00','2023-12-09 19:22:00','12.249.250.150','12.249.250.150','closed',12,745,'attendances/1450/1702133863 clock_in.png','attendances/1450/1702178538 clock_out.png',NULL,43637,NULL,'2023-12-09 11:57:43','2023-12-10 00:22:18'),(3856,'2023-12-09 06:58:00','2023-12-09 16:34:00','12.249.250.150','12.249.250.150','closed',9,576,'attendances/1479/1702133896 clock_in.png','attendances/1479/1702168484 clock_out.png',NULL,43632,NULL,'2023-12-09 11:58:16','2023-12-09 21:34:44'),(3857,'2023-12-09 06:58:00','2023-12-09 19:29:00','12.249.250.150','12.249.250.150','closed',12,751,'attendances/2141/1702133932 clock_in.png','attendances/2141/1702178942 clock_out.png',NULL,43634,NULL,'2023-12-09 11:58:52','2023-12-10 00:29:02'),(3858,'2023-12-09 06:59:00','2023-12-09 19:20:00','12.249.250.150','12.249.250.150','closed',12,741,'attendances/2218/1702133976 clock_in.png','attendances/2218/1702178421 clock_out.png',NULL,43636,NULL,'2023-12-09 11:59:36','2023-12-10 00:20:21'),(3859,'2023-12-09 07:00:00','2023-12-09 19:21:00','186.154.237.158','12.249.250.150','closed',12,741,NULL,'attendances/1551/1702178460 clock_out.png',NULL,43630,NULL,'2023-12-09 12:58:01','2023-12-10 00:21:00'),(3860,'2023-12-09 08:25:00','2023-12-09 17:06:00','12.249.250.150','12.249.250.150','closed',8,521,'attendances/1568/1702139136 clock_in.png','attendances/1568/1702170383 clock_out.png',NULL,43638,NULL,'2023-12-09 13:25:36','2023-12-09 22:06:23'),(3861,'2023-12-09 08:55:00','2023-12-09 17:25:00','12.249.250.150','12.249.250.150','closed',8,510,'attendances/2008/1702140929 clock_in.png','attendances/2008/1702171517 clock_out.png',NULL,43639,NULL,'2023-12-09 13:55:29','2023-12-09 22:25:17'),(3862,'2023-12-09 08:56:00','2023-12-09 17:25:00','12.249.250.150','12.249.250.150','closed',8,509,'attendances/2170/1702141006 clock_in.png','attendances/2170/1702171559 clock_out.png',NULL,43640,NULL,'2023-12-09 13:56:46','2023-12-09 22:25:59'),(3863,'2023-12-09 10:56:00','2023-12-09 19:28:00','12.249.250.150','12.249.250.150','closed',8,512,'attendances/2116/1702148189 clock_in.png','attendances/2116/1702178889 clock_out.png',NULL,43641,NULL,'2023-12-09 15:56:29','2023-12-10 00:28:09'),(3864,'2023-12-09 10:57:00','2023-12-09 19:20:00','12.249.250.150','12.249.250.150','closed',8,503,'attendances/2094/1702148253 clock_in.png','attendances/2094/1702178442 clock_out.png',NULL,43645,NULL,'2023-12-09 15:57:33','2023-12-10 00:20:42'),(3865,'2023-12-09 11:00:00','2023-12-09 19:23:00','12.249.250.150','12.249.250.150','closed',8,503,'attendances/2169/1702148444 clock_in.png','attendances/2169/1702178601 clock_out.png',NULL,43642,NULL,'2023-12-09 16:00:44','2023-12-10 00:23:21'),(3866,'2023-12-09 11:09:00','2023-12-09 19:28:00','12.249.250.150','12.249.250.150','closed',8,499,'attendances/2058/1702148968 clock_in.png','attendances/2058/1702178923 clock_out.png',NULL,43646,NULL,'2023-12-09 16:09:28','2023-12-10 00:28:43'),(3867,'2023-12-09 21:49:00','2023-12-09 23:59:00','12.249.250.150','38.51.234.69','closed',2,130,'attendances/1116/1702187362 clock_in.png',NULL,NULL,43760,NULL,'2023-12-10 02:49:22','2023-12-10 11:11:45'),(3868,'2023-12-09 21:51:00','2023-12-09 23:59:00','12.249.250.150','38.51.234.69','closed',2,128,'attendances/1479/1702187487 clock_in.png',NULL,NULL,43761,NULL,'2023-12-10 02:51:27','2023-12-10 11:07:15'),(3869,'2023-12-09 21:55:00','2023-12-09 23:59:00','12.249.250.150','38.51.234.69','closed',2,124,'attendances/2179/1702187718 clock_in.png',NULL,NULL,43757,NULL,'2023-12-10 02:55:18','2023-12-10 11:12:26'),(3870,'2023-12-09 21:55:00','2023-12-09 23:59:00','12.249.250.150','38.51.234.69','closed',2,124,'attendances/2178/1702187728 clock_in.png',NULL,NULL,43756,NULL,'2023-12-10 02:55:28','2023-12-10 11:06:57'),(3871,'2023-12-09 22:30:00','2023-12-09 23:59:00','12.249.250.150','38.51.234.69','closed',1,89,'attendances/2008/1702189808 clock_in.png',NULL,NULL,43758,NULL,'2023-12-10 03:30:08','2023-12-10 11:07:40'),(3872,'2023-12-09 22:31:00','2023-12-09 23:59:00','12.249.250.150','38.51.234.69','closed',1,88,'attendances/2170/1702189871 clock_in.png',NULL,NULL,43759,NULL,'2023-12-10 03:31:11','2023-12-10 11:12:04'),(3881,'2023-12-10 00:00:00','2023-12-10 03:36:00','38.51.234.69','38.51.234.69','closed',3,216,NULL,NULL,NULL,43764,NULL,'2023-12-10 09:52:07','2023-12-10 09:52:07'),(3882,'2023-12-10 06:00:00','2023-12-10 14:54:00','12.249.250.150','12.249.250.150','closed',8,534,'attendances/2150/1702216824 clock_in.png','attendances/2150/1702248869 clock_out.png',NULL,43690,NULL,'2023-12-10 11:00:24','2023-12-10 19:54:29'),(3883,'2023-12-09 22:37:00','2023-12-09 23:59:00','38.51.234.69','38.51.234.69','closed',1,82,NULL,NULL,NULL,43763,NULL,'2023-12-10 11:10:24','2023-12-10 11:10:24'),(3884,'2023-12-10 06:22:00','2023-12-10 14:54:00','12.249.250.150','12.249.250.150','closed',8,512,'attendances/2200/1702218154 clock_in.png','attendances/2200/1702248880 clock_out.png',NULL,43691,NULL,'2023-12-10 11:22:34','2023-12-10 19:54:40'),(3885,'2023-12-10 06:48:00','2023-12-10 14:30:00','12.249.250.150','12.249.250.150','closed',7,462,'attendances/2218/1702219699 clock_in.png','attendances/2218/1702247410 clock_out.png',NULL,43692,NULL,'2023-12-10 11:48:19','2023-12-10 19:30:10'),(3886,'2023-12-10 00:00:00','2023-12-10 02:02:00','38.51.234.69','38.51.234.69','closed',2,122,NULL,NULL,NULL,43770,NULL,'2023-12-10 11:49:40','2023-12-10 11:49:40'),(3887,'2023-12-10 00:00:00','2023-12-10 02:03:00','38.51.234.69','38.51.234.69','closed',2,123,NULL,NULL,NULL,43771,NULL,'2023-12-10 11:50:14','2023-12-10 11:50:14'),(3888,'2023-12-10 00:00:00','2023-12-10 02:02:00','38.51.234.69','38.51.234.69','closed',2,122,NULL,NULL,NULL,43772,NULL,'2023-12-10 11:50:38','2023-12-10 11:50:38'),(3889,'2023-12-10 00:00:00','2023-12-10 02:02:00','38.51.234.69','38.51.234.69','closed',2,122,NULL,NULL,NULL,43773,NULL,'2023-12-10 11:50:56','2023-12-10 11:50:56'),(3890,'2023-12-10 06:51:00','2023-12-10 15:00:00','12.249.250.150','12.249.250.150','closed',8,489,'attendances/1585/1702219868 clock_in.png','attendances/1585/1702249244 clock_out.png',NULL,43687,NULL,'2023-12-10 11:51:08','2023-12-10 20:00:44'),(3891,'2023-12-10 06:51:00','2023-12-10 14:29:00','12.249.250.150','12.249.250.150','closed',7,458,'attendances/1551/1702219892 clock_in.png','attendances/1551/1702247394 clock_out.png',NULL,43686,NULL,'2023-12-10 11:51:32','2023-12-10 19:29:54'),(3892,'2023-12-10 00:00:00','2023-12-10 03:37:00','38.51.234.69','38.51.234.69','closed',3,217,NULL,NULL,NULL,43774,NULL,'2023-12-10 11:52:25','2023-12-10 12:46:58'),(3893,'2023-12-10 00:00:00','2023-12-10 03:38:00','38.51.234.69','38.51.234.69','closed',3,218,NULL,NULL,NULL,43775,NULL,'2023-12-10 11:52:38','2023-12-10 14:04:33'),(3894,'2023-12-10 06:54:00','2023-12-10 16:30:00','12.249.250.150','12.249.250.150','closed',9,576,'attendances/1568/1702220078 clock_in.png','attendances/1568/1702254621 clock_out.png',NULL,43688,NULL,'2023-12-10 11:54:38','2023-12-10 21:30:21'),(3895,'2023-12-10 06:55:00','2023-12-10 14:33:00','12.249.250.150','12.249.250.150','closed',7,458,'attendances/1744/1702220130 clock_in.png','attendances/1744/1702247585 clock_out.png',NULL,43693,NULL,'2023-12-10 11:55:30','2023-12-10 19:33:05'),(3896,'2023-12-10 06:59:00','2023-12-10 15:39:00','12.249.250.150','12.249.250.150','closed',8,520,'attendances/1749/1702220343 clock_in.png','attendances/1749/1702251552 clock_out.png',NULL,43695,NULL,'2023-12-10 11:59:03','2023-12-10 20:39:12'),(3897,'2023-12-10 06:59:00','2023-12-10 16:30:00','12.249.250.150','12.249.250.150','closed',9,571,'attendances/1450/1702220355 clock_in.png','attendances/1450/1702254633 clock_out.png',NULL,43689,NULL,'2023-12-10 11:59:15','2023-12-10 21:30:33'),(3898,'2023-12-10 07:00:00','2023-12-10 16:14:00','12.249.250.150','12.249.250.150','closed',9,554,'attendances/2058/1702220416 clock_in.png','attendances/2058/1702253640 clock_out.png',NULL,43694,NULL,'2023-12-10 12:00:16','2023-12-10 21:14:00'),(3899,'2023-12-10 07:00:00','2023-12-10 15:38:00','12.249.250.150','12.249.250.150','closed',8,518,'attendances/2222/1702220445 clock_in.png','attendances/2222/1702251496 clock_out.png',NULL,43696,NULL,'2023-12-10 12:00:45','2023-12-10 20:38:16'),(3900,'2023-12-10 06:00:00','2023-12-10 15:39:00','38.51.234.69','12.249.250.150','closed',9,579,NULL,'attendances/2224/1702251598 clock_out.png',NULL,43697,NULL,'2023-12-10 12:31:00','2023-12-10 20:39:58'),(3901,'2023-12-10 05:58:00','2023-12-10 13:49:00','38.51.234.69','38.51.234.69','closed',7,471,NULL,NULL,NULL,43698,NULL,'2023-12-10 12:51:29','2023-12-10 20:19:36'),(3902,'2023-12-10 10:00:00','2023-12-10 15:00:00','38.51.234.69','38.51.234.69','closed',5,300,'attendances/1999/1702231137 clock_in.png','attendances/1999/1702249334 clock_out.png',NULL,43701,NULL,'2023-12-10 14:58:57','2023-12-13 15:54:07'),(3903,'2023-12-10 10:00:00','2023-12-10 15:00:00','38.51.234.69','38.51.234.69','closed',5,300,'attendances/1395/1702231155 clock_in.png','attendances/1395/1702249260 clock_out.png',NULL,43703,NULL,'2023-12-10 14:59:15','2023-12-11 19:04:42'),(3904,'2023-12-10 10:00:00','2023-12-10 15:00:00','38.51.234.69','38.51.234.69','closed',5,300,'attendances/974/1702231167 clock_in.png','attendances/974/1702249229 clock_out.png',NULL,43700,NULL,'2023-12-10 14:59:27','2023-12-11 16:36:32'),(3905,'2023-12-10 10:45:00','2023-12-10 15:02:00','12.249.250.150','12.249.250.150','closed',4,257,'attendances/2195/1702233918 clock_in.png','attendances/2195/1702249321 clock_out.png',NULL,43702,NULL,'2023-12-10 15:45:18','2023-12-10 20:02:01'),(3908,'2023-12-11 04:00:00','2023-12-11 14:38:00','38.51.234.69','12.249.250.150','closed',10,638,'attendances/726/1702305826 clock_in.png','attendances/726/1702334312 clock_out.png','Juan R',43704,NULL,'2023-12-11 11:43:46','2023-12-18 17:28:47'),(3909,'2023-12-11 04:00:00','2023-12-11 16:02:00','38.51.234.69','179.19.21.49','closed',12,722,'attendances/2116/1702305843 clock_in.png','attendances/2116/1702333872 clock_out.png','Juan R',43705,NULL,'2023-12-11 11:44:03','2023-12-18 17:32:03'),(3910,'2023-12-11 04:59:00','2023-12-11 17:26:00','38.51.234.69','179.19.21.49','closed',12,747,'attendances/1568/1702305867 clock_in.png',NULL,'Juan R',43706,NULL,'2023-12-11 11:44:27','2023-12-18 17:31:51'),(3911,'2023-12-11 05:00:00','2023-12-11 16:00:00','38.51.234.69','179.19.21.49','closed',11,660,'attendances/1951/1702305883 clock_in.png',NULL,'Juan R',43707,NULL,'2023-12-11 11:44:43','2023-12-18 17:33:02'),(3912,'2023-12-11 05:12:00','2023-12-11 17:30:00','38.51.234.69','179.19.21.49','closed',12,738,'attendances/2133/1702305897 clock_in.png',NULL,'Juan R',43708,NULL,'2023-12-11 11:44:57','2023-12-18 17:39:38'),(3913,'2023-12-11 05:57:00','2023-12-11 18:40:00','38.51.234.69','12.249.250.150','closed',12,763,'attendances/2233/1702305923 clock_in.png','attendances/2233/1702348816 clock_out.png','Juan R',43721,NULL,'2023-12-11 11:45:23','2023-12-18 17:44:02'),(3914,'2023-12-11 05:57:00','2023-12-11 17:16:00','38.51.234.69','179.19.21.49','closed',11,679,'attendances/2179/1702305935 clock_in.png',NULL,'Juan R',43724,NULL,'2023-12-11 11:45:35','2023-12-18 17:44:58'),(3915,'2023-12-11 05:58:00','2023-12-11 19:26:00','38.51.234.69','12.249.250.150','closed',13,808,'attendances/2224/1702306045 clock_in.png','attendances/2224/1702351610 clock_out.png','Juan R',43723,NULL,'2023-12-11 11:47:25','2023-12-18 17:44:32'),(3916,'2023-12-11 05:53:00','2023-12-11 18:37:00','38.51.234.69','12.249.250.150','closed',12,764,'attendances/2222/1702306058 clock_in.png','attendances/2222/1702348664 clock_out.png','Juan R',43722,NULL,'2023-12-11 11:47:38','2023-12-18 17:43:33'),(3917,'2023-12-11 06:01:00','2023-12-11 19:27:00','38.51.234.69','12.249.250.150','closed',13,806,'attendances/1450/1702306081 clock_in.png','attendances/1450/1702351634 clock_out.png','Juan R',43720,NULL,'2023-12-11 11:48:01','2023-12-18 17:43:18'),(3918,'2023-12-11 06:00:00','2023-12-11 17:31:00','38.51.234.69','179.19.21.49','closed',11,691,'attendances/2058/1702306192 clock_in.png',NULL,'Juan R',43719,NULL,'2023-12-11 11:49:52','2023-12-18 17:43:11'),(3919,'2023-12-11 06:50:00','2023-12-11 17:32:00','12.249.250.150','179.19.21.49','closed',10,642,'attendances/1934/1702306210 clock_in.png',NULL,'Juan R',43734,NULL,'2023-12-11 11:50:10','2023-12-18 17:39:05'),(3920,'2023-12-11 05:58:00','2023-12-11 18:37:00','38.51.234.69','12.249.250.150','closed',12,759,'attendances/2094/1702306233 clock_in.png','attendances/2094/1702348668 clock_out.png','Juan R',43718,NULL,'2023-12-11 11:50:33','2023-12-18 17:43:06'),(3921,'2023-12-11 06:02:00','2023-12-11 19:27:00','38.51.234.69','12.249.250.150','closed',13,805,'attendances/2170/1702306250 clock_in.png','attendances/2170/1702351671 clock_out.png','Juan R',43717,NULL,'2023-12-11 11:50:50','2023-12-18 17:41:57'),(3922,'2023-12-11 05:52:00','2023-12-11 17:30:00','38.51.234.69','179.19.21.49','closed',11,698,'attendances/1774/1702306277 clock_in.png',NULL,'Juan R',43715,NULL,'2023-12-11 11:51:17','2023-12-18 17:34:04'),(3923,'2023-12-11 06:05:00','2023-12-11 17:20:00','38.51.234.69','179.19.21.49','closed',11,675,'attendances/2195/1702306287 clock_in.png',NULL,'Juan R',43714,NULL,'2023-12-11 11:51:27','2023-12-18 17:33:53'),(3924,'2023-12-11 05:58:00','2023-12-11 19:26:00','38.51.234.69','12.249.250.150','closed',13,808,'attendances/2141/1702306300 clock_in.png','attendances/2141/1702351589 clock_out.png','Juan R',43713,NULL,'2023-12-11 11:51:40','2023-12-18 17:34:07'),(3925,'2023-12-11 05:58:00','2023-12-11 18:36:00','38.51.234.69','12.249.250.150','closed',12,758,'attendances/2218/1702306310 clock_in.png','attendances/2218/1702348607 clock_out.png','Juan R',43716,NULL,'2023-12-11 11:51:50','2023-12-18 17:37:06'),(3926,'2023-12-11 06:01:00','2023-12-11 18:05:00','38.51.234.69','179.19.21.49','closed',12,724,'attendances/1116/1702306423 clock_in.png','attendances/1116/1702340075 clock_out.png','Juan R',43736,NULL,'2023-12-11 11:53:43','2023-12-18 17:40:33'),(3927,'2023-12-11 05:58:00','2023-12-11 17:17:00','38.51.234.69','179.19.21.49','closed',11,679,'attendances/2169/1702306498 clock_in.png',NULL,'Juan R',43712,NULL,'2023-12-11 11:54:58','2023-12-18 17:33:44'),(3928,'2023-12-11 05:55:00','2023-12-11 18:37:00','38.51.234.69','12.249.250.150','closed',12,762,'attendances/1585/1702306521 clock_in.png','attendances/1585/1702348628 clock_out.png','Juan R',43711,NULL,'2023-12-11 11:55:21','2023-12-18 17:31:30'),(3929,'2023-12-11 06:55:00','2023-12-11 17:31:00','12.249.250.150','179.19.21.49','closed',10,636,'attendances/1744/1702306528 clock_in.png',NULL,'Juan R',43737,NULL,'2023-12-11 11:55:28','2023-12-18 17:40:43'),(3930,'2023-12-11 05:57:00','2023-12-11 17:16:00','38.51.234.69','179.19.21.49','closed',11,679,'attendances/2178/1702306534 clock_in.png',NULL,'Juan R',43710,NULL,'2023-12-11 11:55:34','2023-12-18 17:29:14'),(3931,'2023-12-11 05:56:00','2023-12-11 18:38:00','38.51.234.69','12.249.250.150','closed',12,762,'attendances/1551/1702306544 clock_in.png','attendances/1551/1702348738 clock_out.png','Juan R',43709,NULL,'2023-12-11 11:55:45','2023-12-18 17:28:56'),(3932,'2023-12-11 06:55:00','2023-12-11 17:27:00','12.249.250.150','179.19.21.49','closed',10,632,'attendances/2230/1702306557 clock_in.png',NULL,'Juan R',43742,NULL,'2023-12-11 11:55:57','2023-12-18 17:44:46'),(3933,'2023-12-11 06:56:00','2023-12-11 15:34:00','12.249.250.150','12.249.250.150','closed',8,518,'attendances/1858/1702306564 clock_in.png','attendances/1858/1702337694 clock_out.png','Juan R',43747,NULL,'2023-12-11 11:56:04','2023-12-18 17:39:33'),(3934,'2023-12-11 06:56:00','2023-12-11 17:27:00','12.249.250.150','179.19.21.49','closed',10,631,'attendances/1479/1702306572 clock_in.png',NULL,'Juan R',43727,NULL,'2023-12-11 11:56:12','2023-12-18 17:32:54'),(3935,'2023-12-11 06:56:00','2023-12-11 15:35:00','12.249.250.150','12.249.250.150','closed',8,519,'attendances/1958/1702306579 clock_in.png','attendances/1958/1702337704 clock_out.png','Juan R',43745,NULL,'2023-12-11 11:56:19','2023-12-18 17:34:26'),(3936,'2023-12-11 06:56:00','2023-12-11 17:25:00','12.249.250.150','179.19.21.49','closed',10,629,'attendances/1749/1702306579 clock_in.png',NULL,'Juan R',43753,NULL,'2023-12-11 11:56:19','2023-12-18 17:41:01'),(3937,'2023-12-11 06:56:00','2023-12-11 17:27:00','12.249.250.150','179.19.21.49','closed',10,631,'attendances/2047/1702306585 clock_in.png',NULL,'Juan R',43730,NULL,'2023-12-11 11:56:25','2023-12-18 17:34:32'),(3938,'2023-12-11 06:56:00','2023-12-11 15:46:00','12.249.250.150','12.249.250.150','closed',8,530,'attendances/2008/1702306595 clock_in.png','attendances/2008/1702338396 clock_out.png','Juan R',43731,NULL,'2023-12-11 11:56:35','2023-12-18 17:36:01'),(3939,'2023-12-11 06:56:00','2023-12-11 17:32:00','12.249.250.150','179.19.21.49','closed',10,636,'attendances/2168/1702306612 clock_in.png',NULL,'Juan R',43729,NULL,'2023-12-11 11:56:52','2023-12-18 17:34:22'),(3940,'2023-12-11 06:57:00','2023-12-11 17:25:00','12.249.250.150','179.19.21.49','closed',10,628,'attendances/2061/1702306621 clock_in.png','attendances/2061/1702306630 clock_out.png','Juan R',43733,NULL,'2023-12-11 11:57:01','2023-12-18 17:38:54'),(3941,'2023-12-11 06:08:00','2023-12-11 17:31:00','38.51.234.69','179.19.21.49','closed',11,683,'attendances/622/1702306627 clock_in.png',NULL,'Juan R',43741,NULL,'2023-12-11 11:57:07','2023-12-18 17:44:20'),(3942,'2023-12-11 06:57:00','2023-12-11 15:50:00','12.249.250.150','12.249.250.150','closed',8,533,'attendances/1395/1702306643 clock_in.png','attendances/1395/1702338607 clock_out.png','Juan R',43738,NULL,'2023-12-11 11:57:23','2023-12-18 17:40:45'),(3943,'2023-12-11 06:57:00','2023-12-11 15:51:00','12.249.250.150','190.103.31.245','closed',8,534,'attendances/1999/1702306660 clock_in.png',NULL,'Juan R',43732,NULL,'2023-12-11 11:57:40','2023-12-18 17:36:58'),(3945,'2023-12-11 06:57:00','2023-12-11 18:07:00','12.249.250.150','179.19.21.49','closed',11,670,'attendances/1666/1702306676 clock_in.png',NULL,'Juan R',43751,NULL,'2023-12-11 11:57:56','2023-12-18 17:36:54'),(3946,'2023-12-11 06:58:00','2023-12-11 15:49:00','12.249.250.150','12.249.250.150','closed',8,531,'attendances/2200/1702306682 clock_in.png','attendances/2200/1702338576 clock_out.png','Juan R',43728,NULL,'2023-12-11 11:58:02','2023-12-18 17:33:50'),(3947,'2023-12-11 06:59:00','2023-12-11 18:12:00','12.249.250.150','12.249.250.150','closed',11,673,'attendances/2150/1702306783 clock_in.png','attendances/2150/1702347130 clock_out.png','Juan R',43726,NULL,'2023-12-11 11:59:43','2023-12-18 17:29:01'),(3948,'2023-12-11 07:00:00','2023-12-11 15:46:00','12.249.250.150','12.249.250.150','closed',8,526,'attendances/1728/1702306833 clock_in.png','attendances/1728/1702338387 clock_out.png','Juan R',43735,NULL,'2023-12-11 12:00:33','2023-12-18 17:39:13'),(3949,'2023-12-11 07:01:00','2023-12-11 15:40:00','12.249.250.150','12.249.250.150','closed',8,519,'attendances/2227/1702306868 clock_in.png','attendances/2227/1702338040 clock_out.png','Juan R',43750,NULL,'2023-12-11 12:01:08','2023-12-18 17:39:29'),(3950,'2023-12-11 07:01:00','2023-12-11 16:02:00','12.249.250.150','12.249.250.150','closed',9,541,'attendances/2228/1702306885 clock_in.png','attendances/2228/1702339323 clock_out.png','Juan R',43754,NULL,'2023-12-11 12:01:25','2023-12-18 17:45:12'),(3951,'2023-12-11 07:04:00','2023-12-11 17:07:00','12.249.250.150','179.19.21.49','closed',10,603,'attendances/1181/1702307093 clock_in.png',NULL,'Juan R',43740,NULL,'2023-12-11 12:04:53','2023-12-18 17:43:25'),(3952,'2023-12-11 07:06:00','2023-12-11 16:00:00','12.249.250.150','12.249.250.150','closed',8,534,'attendances/1530/1702307175 clock_in.png','attendances/1530/1702339220 clock_out.png','Juan R',43752,NULL,'2023-12-11 12:06:15','2023-12-18 17:44:15'),(3953,'2023-12-11 07:08:00','2023-12-11 15:38:00','12.249.250.150','12.249.250.150','closed',8,510,'attendances/1888/1702307334 clock_in.png','attendances/1888/1702337931 clock_out.png','Juan R',43743,NULL,'2023-12-11 12:08:54','2023-12-18 17:45:07'),(3954,'2023-12-11 07:09:00','2023-12-11 18:14:00','186.154.240.36','179.19.21.49','closed',11,665,'attendances/1950/1702307384 clock_in.png','attendances/1950/1702347555 clock_out.png','Juan R',43755,NULL,'2023-12-11 12:09:44','2023-12-18 17:42:16'),(3955,'2023-12-11 07:20:00','2023-12-11 15:54:00','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1948/1702308043 clock_in.png','attendances/1948/1702338892 clock_out.png','Juan R',43739,NULL,'2023-12-11 12:20:43','2023-12-18 17:43:00'),(3956,'2023-12-11 07:56:00','2023-12-11 16:30:00','12.249.250.150','12.249.250.150','closed',8,514,'attendances/775/1702310162 clock_in.png','attendances/775/1702341006 clock_out.png','Juan R',43748,NULL,'2023-12-11 12:56:02','2023-12-18 17:41:16'),(3957,'2023-12-11 07:58:00','2023-12-11 15:32:00','12.249.250.150','12.249.250.150','closed',7,454,'attendances/1462/1702310300 clock_in.png','attendances/1462/1702337567 clock_out.png','Juan R',43746,NULL,'2023-12-11 12:58:20','2023-12-18 17:37:01'),(3958,'2023-12-11 08:01:00','2023-12-11 16:37:00','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1869/1702310473 clock_in.png','attendances/1869/1702341439 clock_out.png','Juan R',43744,NULL,'2023-12-11 13:01:13','2023-12-18 17:32:00'),(3959,'2023-12-11 06:57:00','2023-12-11 15:45:00','186.154.237.158','12.249.250.150','closed',8,528,'attendances/974/1702321831 clock_in.png','attendances/974/1702338311 clock_out.png','Juan R',43725,NULL,'2023-12-11 16:10:31','2023-12-18 17:27:56'),(3961,'2023-12-12 05:01:00','2023-12-12 16:06:00','12.249.250.150','12.249.250.150','closed',11,665,'attendances/1568/1702386119 clock_in.png','attendances/1568/1702425969 clock_out.png','Juan R',43782,NULL,'2023-12-12 10:01:59','2023-12-18 17:31:51'),(3962,'2023-12-12 05:02:00','2023-12-12 16:15:00','12.249.250.150','12.249.250.150','closed',11,673,'attendances/1951/1702386157 clock_in.png','attendances/1951/1702426556 clock_out.png','Juan R',43783,NULL,'2023-12-12 10:02:37','2023-12-18 17:33:02'),(3963,'2023-12-12 05:05:00','2023-12-12 15:48:00','12.249.250.150','12.249.250.150','closed',10,643,'attendances/2133/1702386337 clock_in.png','attendances/2133/1702424933 clock_out.png','Juan R',43784,NULL,'2023-12-12 10:05:37','2023-12-18 17:39:38'),(3964,'2023-12-12 05:49:00','2023-12-12 16:29:00','12.249.250.150','12.249.250.150','closed',10,640,'attendances/1774/1702388982 clock_in.png','attendances/1774/1702427378 clock_out.png','Juan R',43789,NULL,'2023-12-12 10:49:43','2023-12-18 17:34:04'),(3965,'2023-12-12 05:51:00','2023-12-12 16:31:00','12.249.250.150','12.249.250.150','closed',10,640,'attendances/1934/1702389080 clock_in.png','attendances/1934/1702427473 clock_out.png','Juan R',43793,NULL,'2023-12-12 10:51:20','2023-12-18 17:39:05'),(3966,'2023-12-12 05:52:00','2023-12-12 16:30:00','12.249.250.150','12.249.250.150','closed',10,638,'attendances/622/1702389123 clock_in.png','attendances/622/1702427451 clock_out.png','Juan R',43800,NULL,'2023-12-12 10:52:03','2023-12-18 17:44:20'),(3967,'2023-12-12 05:54:00','2023-12-12 16:30:00','12.249.250.150','12.249.250.150','closed',10,636,'attendances/2150/1702389299 clock_in.png','attendances/2150/1702427457 clock_out.png','Juan R',43785,NULL,'2023-12-12 10:55:00','2023-12-18 17:29:01'),(3968,'2023-12-12 05:55:00','2023-12-12 16:30:00','12.249.250.150','12.249.250.150','closed',10,635,'attendances/2168/1702389308 clock_in.png','attendances/2168/1702427433 clock_out.png','Juan R',43790,NULL,'2023-12-12 10:55:08','2023-12-18 17:34:22'),(3969,'2023-12-12 05:55:00','2023-12-12 18:38:00','12.249.250.150','12.249.250.150','closed',12,763,'attendances/1585/1702389327 clock_in.png','attendances/1585/1702435136 clock_out.png','Juan R',43787,NULL,'2023-12-12 10:55:27','2023-12-18 17:31:30'),(3970,'2023-12-12 05:57:00','2023-12-12 16:30:00','12.249.250.150','12.249.250.150','closed',10,633,'attendances/1744/1702389450 clock_in.png','attendances/1744/1702427422 clock_out.png','Juan R',43795,NULL,'2023-12-12 10:57:30','2023-12-18 17:40:43'),(3971,'2023-12-12 05:57:00','2023-12-12 18:24:00','12.249.250.150','12.249.250.150','closed',12,747,'attendances/2094/1702389461 clock_in.png','attendances/2094/1702434294 clock_out.png','Juan R',43798,NULL,'2023-12-12 10:57:41','2023-12-18 17:43:06'),(3972,'2023-12-12 05:57:00','2023-12-12 18:30:00','12.249.250.150','12.249.250.150','closed',12,753,'attendances/1749/1702389473 clock_in.png','attendances/1749/1702434607 clock_out.png','Juan R',43796,NULL,'2023-12-12 10:57:53','2023-12-18 17:41:01'),(3973,'2023-12-12 05:58:00','2023-12-12 15:49:00','12.249.250.150','12.249.250.150','closed',9,591,'attendances/2170/1702389485 clock_in.png','attendances/2170/1702424950 clock_out.png','Juan R',43822,NULL,'2023-12-12 10:58:05','2023-12-18 17:41:57'),(3974,'2023-12-12 05:58:00','2023-12-12 18:26:00','12.249.250.150','12.249.250.150','closed',12,748,'attendances/1551/1702389491 clock_in.png','attendances/1551/1702434375 clock_out.png','Juan R',43786,NULL,'2023-12-12 10:58:11','2023-12-18 17:28:56'),(3975,'2023-12-12 05:59:00','2023-12-12 18:25:00','12.249.250.150','12.249.250.150','closed',12,746,'attendances/2233/1702389553 clock_in.png','attendances/2233/1702434316 clock_out.png','Juan R',43799,NULL,'2023-12-12 10:59:13','2023-12-18 17:44:02'),(3976,'2023-12-12 05:59:00','2023-12-12 18:39:00','12.249.250.150','12.249.250.150','closed',12,760,'attendances/2141/1702389589 clock_in.png','attendances/2141/1702435147 clock_out.png','Juan R',43788,NULL,'2023-12-12 10:59:49','2023-12-18 17:34:07'),(3977,'2023-12-12 06:01:00','2023-12-12 18:33:00','12.249.250.150','12.249.250.150','closed',12,752,'attendances/1666/1702389712 clock_in.png','attendances/1666/1702434837 clock_out.png','Juan R',43791,NULL,'2023-12-12 11:01:52','2023-12-18 17:36:54'),(3978,'2023-12-12 06:02:00','2023-12-12 18:26:00','12.249.250.150','190.89.30.156','closed',12,744,'attendances/2218/1702389760 clock_in.png','attendances/2218/1702389769 clock_out.png','Juan R',43792,NULL,'2023-12-12 11:02:40','2023-12-18 17:37:06'),(3979,'2023-12-12 06:05:00','2023-12-12 18:26:00','12.249.250.150','12.249.250.150','closed',12,741,'attendances/2235/1702389914 clock_in.png','attendances/2235/1702434393 clock_out.png','Juan R',43834,NULL,'2023-12-12 11:05:16','2023-12-18 17:40:50'),(3980,'2023-12-12 06:06:00','2023-12-12 18:39:00','12.249.250.150','12.249.250.150','closed',12,753,'attendances/1950/1702389982 clock_in.png','attendances/1950/1702435153 clock_out.png','Juan R',43797,NULL,'2023-12-12 11:06:22','2023-12-18 17:42:16'),(3981,'2023-12-12 06:25:00','2023-12-12 18:15:00','12.249.250.150','190.89.30.156','closed',11,710,'attendances/2047/1702391109 clock_in.png','attendances/2047/1702391230 clock_out.png','Juan R',43802,NULL,'2023-12-12 11:25:09','2023-12-18 17:34:32'),(3982,'2023-12-12 06:26:00','2023-12-12 18:15:00','12.249.250.150','12.249.250.150','closed',11,709,'attendances/2230/1702391180 clock_in.png','attendances/2230/1702433745 clock_out.png','Juan R',43805,NULL,'2023-12-12 11:26:20','2023-12-18 17:44:46'),(3983,'2023-12-12 06:27:00','2023-12-12 18:11:00','12.249.250.150','12.249.250.150','closed',11,704,'attendances/1479/1702391247 clock_in.png','attendances/1479/1702433517 clock_out.png','Juan R',43801,NULL,'2023-12-12 11:27:27','2023-12-18 17:32:54'),(3984,'2023-12-12 06:30:00','2023-12-12 18:19:00','12.249.250.150','12.249.250.150','closed',11,709,'attendances/2224/1702391447 clock_in.png','attendances/2224/1702433947 clock_out.png','Juan R',43804,NULL,'2023-12-12 11:30:47','2023-12-18 17:44:32'),(3985,'2023-12-12 06:32:00','2023-12-12 18:39:00','12.249.250.150','12.249.250.150','closed',12,727,'attendances/1450/1702391525 clock_in.png','attendances/1450/1702435159 clock_out.png','Juan R',43803,NULL,'2023-12-12 11:32:05','2023-12-18 17:43:18'),(3986,'2023-12-12 06:50:00','2023-12-12 15:59:00','12.249.250.150','12.249.250.150','closed',9,549,'attendances/1116/1702392634 clock_in.png','attendances/1116/1702425543 clock_out.png','Juan R',43820,NULL,'2023-12-12 11:50:34','2023-12-18 17:40:33'),(3987,'2023-12-12 06:50:00','2023-12-12 13:36:00','12.249.250.150','12.249.250.150','closed',6,406,'attendances/1999/1702392652 clock_in.png','attendances/1999/1702416963 clock_out.png','Juan R',43815,NULL,'2023-12-12 11:50:52','2023-12-18 17:36:58'),(3988,'2023-12-12 06:51:00','2023-12-12 18:43:00','12.249.250.150','12.249.250.150','closed',11,712,'attendances/2179/1702392713 clock_in.png','attendances/2179/1702435392 clock_out.png','Juan R',43827,NULL,'2023-12-12 11:51:53','2023-12-18 17:44:58'),(3989,'2023-12-12 06:52:00','2023-12-12 18:42:00','12.249.250.150','12.249.250.150','closed',11,710,'attendances/2178/1702392723 clock_in.png','attendances/2178/1702435375 clock_out.png','Juan R',43808,NULL,'2023-12-12 11:52:03','2023-12-18 17:29:14'),(3990,'2023-12-12 06:52:00','2023-12-12 18:34:00','12.249.250.150','12.249.250.150','closed',11,702,'attendances/2061/1702392741 clock_in.png','attendances/2061/1702434848 clock_out.png','Juan R',43817,NULL,'2023-12-12 11:52:21','2023-12-18 17:38:54'),(3991,'2023-12-12 06:54:00','2023-12-12 15:42:00','12.249.250.150','12.249.250.150','closed',8,528,'attendances/1948/1702392879 clock_in.png','attendances/1948/1702424556 clock_out.png','Juan R',43823,NULL,'2023-12-12 11:54:39','2023-12-18 17:43:00'),(3992,'2023-12-12 06:54:00','2023-12-12 16:00:00','12.249.250.150','12.249.250.150','closed',9,546,'attendances/2116/1702392886 clock_in.png','attendances/2116/1702425607 clock_out.png','Juan R',43809,NULL,'2023-12-12 11:54:46','2023-12-18 17:32:03'),(3993,'2023-12-12 06:54:00','2023-12-12 16:00:00','12.249.250.150','12.249.250.150','closed',9,546,'attendances/2234/1702392887 clock_in.png','attendances/2234/1702425638 clock_out.png','Juan R',43833,NULL,'2023-12-12 11:54:47','2023-12-18 17:43:23'),(3994,'2023-12-12 06:55:00','2023-12-12 19:13:00','12.249.250.150','12.249.250.150','closed',12,738,'attendances/2008/1702392917 clock_in.png','attendances/2008/1702437188 clock_out.png','Juan R',43814,NULL,'2023-12-12 11:55:17','2023-12-18 17:36:01'),(3995,'2023-12-12 06:55:00','2023-12-12 18:47:00','12.249.250.150','12.249.250.150','closed',11,712,'attendances/2169/1702392930 clock_in.png','attendances/2169/1702435631 clock_out.png','Juan R',43810,NULL,'2023-12-12 11:55:30','2023-12-18 17:33:44'),(3996,'2023-12-12 06:55:00','2023-12-12 16:58:00','12.249.250.150','12.249.250.150','closed',10,603,'attendances/2058/1702392937 clock_in.png','attendances/2058/1702429094 clock_out.png','Juan R',43824,NULL,'2023-12-12 11:55:37','2023-12-18 17:43:11'),(3997,'2023-12-12 06:56:00','2023-12-12 16:30:00','12.249.250.150','12.249.250.150','closed',9,574,'attendances/726/1702392975 clock_in.png','attendances/726/1702427446 clock_out.png','Juan R',43807,NULL,'2023-12-12 11:56:15','2023-12-18 17:28:47'),(3998,'2023-12-12 06:56:00','2023-12-12 18:12:00','12.249.250.150','12.249.250.150','closed',11,676,'attendances/2200/1702392996 clock_in.png','attendances/2200/1702433564 clock_out.png','Juan R',43811,NULL,'2023-12-12 11:56:36','2023-12-18 17:33:50'),(3999,'2023-12-12 06:56:00','2023-12-12 16:58:00','12.249.250.150','12.249.250.150','closed',10,602,'attendances/2236/1702393006 clock_in.png','attendances/2236/1702429120 clock_out.png','Juan R',43812,NULL,'2023-12-12 11:56:46','2023-12-18 17:44:24'),(4000,'2023-12-12 06:57:00','2023-12-12 18:34:00','12.249.250.150','12.249.250.150','closed',11,697,'attendances/1395/1702393038 clock_in.png','attendances/1395/1702434890 clock_out.png','Juan R',43821,NULL,'2023-12-12 11:57:18','2023-12-18 17:40:45'),(4001,'2023-12-12 06:57:00','2023-12-12 15:35:00','12.249.250.150','190.89.30.156','closed',8,518,'attendances/1958/1702393050 clock_in.png',NULL,'Juan R',43813,NULL,'2023-12-12 11:57:30','2023-12-18 17:34:26'),(4002,'2023-12-12 06:58:00','2023-12-12 15:55:00','12.249.250.150','12.249.250.150','closed',8,537,'attendances/974/1702393127 clock_in.png','attendances/974/1702425335 clock_out.png','Juan R',43806,NULL,'2023-12-12 11:58:47','2023-12-18 17:27:56'),(4003,'2023-12-12 07:03:00','2023-12-12 15:51:00','12.249.250.150','190.89.30.156','closed',8,528,'attendances/1181/1702393388 clock_in.png',NULL,'Juan R',43825,NULL,'2023-12-12 12:03:08','2023-12-18 17:43:25'),(4004,'2023-12-12 07:08:00','2023-12-12 15:42:00','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1462/1702393703 clock_in.png','attendances/1462/1702424544 clock_out.png','Juan R',43816,NULL,'2023-12-12 12:08:23','2023-12-18 17:37:01'),(4005,'2023-12-12 07:09:00','2023-12-12 16:14:00','12.249.250.150','12.249.250.150','closed',9,545,'attendances/1728/1702393783 clock_in.png','attendances/1728/1702426457 clock_out.png','Juan R',43818,NULL,'2023-12-12 12:09:43','2023-12-18 17:39:13'),(4006,'2023-12-12 07:10:00','2023-12-12 16:53:00','12.249.250.150','12.249.250.150','closed',9,583,'attendances/2069/1702393803 clock_in.png','attendances/2069/1702428812 clock_out.png','Juan R',43829,NULL,'2023-12-12 12:10:03','2023-12-18 17:29:09'),(4007,'2023-12-12 07:15:00','2023-12-12 18:11:00','12.249.250.150','12.249.250.150','closed',10,656,'attendances/1530/1702394121 clock_in.png','attendances/1530/1702433495 clock_out.png','Juan R',43826,NULL,'2023-12-12 12:15:21','2023-12-18 17:44:15'),(4008,'2023-12-12 07:17:00','2023-12-12 15:45:00','12.249.250.150','12.249.250.150','closed',8,508,'attendances/1858/1702394247 clock_in.png','attendances/1858/1702424709 clock_out.png','Juan R',43819,NULL,'2023-12-12 12:17:27','2023-12-18 17:39:33'),(4009,'2023-12-12 07:22:00','2023-12-12 15:53:00','12.249.250.150','12.249.250.150','closed',8,511,'attendances/1888/1702394551 clock_in.png','attendances/1888/1702425196 clock_out.png','Juan R',43828,NULL,'2023-12-12 12:22:31','2023-12-18 17:45:07'),(4010,'2023-12-12 07:58:00','2023-12-12 16:31:00','12.249.250.150','12.249.250.150','closed',8,513,'attendances/1891/1702396713 clock_in.png','attendances/1891/1702427505 clock_out.png','Juan R',43832,NULL,'2023-12-12 12:58:33','2023-12-18 17:42:47'),(4011,'2023-12-12 07:58:00','2023-12-12 16:30:00','12.249.250.150','12.249.250.150','closed',8,512,'attendances/775/1702396731 clock_in.png','attendances/775/1702427443 clock_out.png','Juan R',43831,NULL,'2023-12-12 12:58:51','2023-12-18 17:41:16'),(4012,'2023-12-12 08:00:00','2023-12-12 16:32:00','12.249.250.150','12.249.250.150','closed',8,512,'attendances/1869/1702396819 clock_in.png','attendances/1869/1702427568 clock_out.png','Juan R',43830,NULL,'2023-12-12 13:00:19','2023-12-18 17:32:00'),(4013,'2023-12-12 08:50:00','2023-12-12 15:51:00','12.249.250.150','12.249.250.150','closed',7,421,'attendances/2238/1702399838 clock_in.png','attendances/2238/1702425060 clock_out.png','Juan R',43794,NULL,'2023-12-12 13:50:38','2023-12-18 17:40:01'),(4019,'2023-12-12 15:31:00','2023-12-12 19:04:00','190.89.30.156','190.89.30.156','closed',3,213,NULL,NULL,'Juan R',43932,NULL,'2023-12-13 00:31:26','2023-12-18 17:36:58'),(4020,'2023-12-13 05:52:00','2023-12-13 16:30:00','12.249.250.150','12.249.250.150','closed',10,638,'attendances/622/1702475558 clock_in.png','attendances/622/1702513820 clock_out.png','Juan R',43899,NULL,'2023-12-13 10:52:38','2023-12-18 17:44:20'),(4021,'2023-12-13 05:53:00','2023-12-13 18:49:00','12.249.250.150','12.249.250.150','closed',12,776,'attendances/1585/1702475594 clock_in.png','attendances/1585/1702522172 clock_out.png','Juan R',43878,NULL,'2023-12-13 10:53:14','2023-12-18 17:31:30'),(4022,'2023-12-13 05:54:00','2023-12-13 16:30:00','12.249.250.150','12.249.250.150','closed',10,636,'attendances/1774/1702475668 clock_in.png','attendances/1774/1702513808 clock_out.png','Juan R',43884,NULL,'2023-12-13 10:54:28','2023-12-18 17:34:04'),(4023,'2023-12-13 05:55:00','2023-12-13 16:31:00','12.249.250.150','12.249.250.150','closed',10,636,'attendances/1934/1702475732 clock_in.png','attendances/1934/1702513896 clock_out.png','Juan R',43888,NULL,'2023-12-13 10:55:32','2023-12-18 17:39:05'),(4024,'2023-12-13 05:58:00','2023-12-13 18:49:00','12.249.250.150','12.249.250.150','closed',12,771,'attendances/1551/1702475894 clock_in.png','attendances/1551/1702522189 clock_out.png','Juan R',43877,NULL,'2023-12-13 10:58:14','2023-12-18 17:28:56'),(4025,'2023-12-13 05:59:00','2023-12-13 16:31:00','12.249.250.150','12.249.250.150','closed',10,632,'attendances/1744/1702475948 clock_in.png','attendances/1744/1702513885 clock_out.png','Juan R',43890,NULL,'2023-12-13 10:59:08','2023-12-18 17:40:43'),(4026,'2023-12-13 05:59:00','2023-12-13 17:27:00','12.249.250.150','12.249.250.150','closed',11,688,'attendances/2218/1702475960 clock_in.png','attendances/2218/1702517232 clock_out.png','Juan R',43887,NULL,'2023-12-13 10:59:20','2023-12-18 17:37:06'),(4027,'2023-12-13 05:59:00','2023-12-13 16:31:00','12.249.250.150','12.249.250.150','closed',10,632,'attendances/1568/1702475980 clock_in.png','attendances/1568/1702513917 clock_out.png','Juan R',43879,NULL,'2023-12-13 10:59:40','2023-12-18 17:31:51'),(4028,'2023-12-13 05:59:00','2023-12-13 18:47:00','12.249.250.150','12.249.250.150','closed',12,768,'attendances/2233/1702475981 clock_in.png','attendances/2233/1702522078 clock_out.png','Juan R',43897,NULL,'2023-12-13 10:59:41','2023-12-18 17:44:02'),(4029,'2023-12-13 05:59:00','2023-12-13 16:08:00','12.249.250.150','12.249.250.150','closed',10,609,'attendances/1951/1702475996 clock_in.png','attendances/1951/1702512532 clock_out.png','Juan R',43881,NULL,'2023-12-13 10:59:56','2023-12-18 17:33:02'),(4030,'2023-12-13 06:00:00','2023-12-13 18:50:00','12.249.250.150','12.249.250.150','closed',12,770,'attendances/2141/1702476001 clock_in.png','attendances/2141/1702522218 clock_out.png','Juan R',43882,NULL,'2023-12-13 11:00:01','2023-12-18 17:34:07'),(4031,'2023-12-13 06:00:00','2023-12-13 16:30:00','12.249.250.150','12.249.250.150','closed',10,630,'attendances/2168/1702476013 clock_in.png','attendances/2168/1702513829 clock_out.png','Juan R',43885,NULL,'2023-12-13 11:00:13','2023-12-18 17:34:22'),(4032,'2023-12-13 06:00:00','2023-12-13 16:37:00','12.249.250.150','12.249.250.150','closed',10,637,'attendances/2169/1702476024 clock_in.png','attendances/2169/1702514255 clock_out.png','Juan R',43880,NULL,'2023-12-13 11:00:24','2023-12-18 17:33:44'),(4033,'2023-12-13 06:00:00','2023-12-13 15:31:00','12.249.250.150','12.249.250.150','closed',9,571,'attendances/1666/1702476034 clock_in.png','attendances/1666/1702510295 clock_out.png','Juan R',43886,NULL,'2023-12-13 11:00:34','2023-12-18 17:36:54'),(4034,'2023-12-13 06:00:00','2023-12-13 15:59:00','12.249.250.150','12.249.250.150','closed',9,599,'attendances/2234/1702476050 clock_in.png','attendances/2234/1702511988 clock_out.png','Juan R',43898,NULL,'2023-12-13 11:00:50','2023-12-18 17:43:23'),(4035,'2023-12-13 06:01:00','2023-12-13 16:49:00','12.249.250.150','12.249.250.150','closed',10,648,'attendances/1450/1702476065 clock_in.png','attendances/1450/1702514969 clock_out.png','Juan R',43895,NULL,'2023-12-13 11:01:05','2023-12-18 17:43:18'),(4036,'2023-12-13 06:01:00','2023-12-13 18:04:00','12.249.250.150','12.249.250.150','closed',12,723,'attendances/2224/1702476067 clock_in.png','attendances/2224/1702519499 clock_out.png','Juan R',43900,NULL,'2023-12-13 11:01:07','2023-12-18 17:44:32'),(4037,'2023-12-13 06:01:00','2023-12-13 18:05:00','12.249.250.150','12.249.250.150','closed',12,724,'attendances/2195/1702476076 clock_in.png','attendances/2195/1702519532 clock_out.png','Juan R',43883,NULL,'2023-12-13 11:01:16','2023-12-18 17:33:53'),(4038,'2023-12-13 06:01:00','2023-12-13 15:58:00','12.249.250.150','12.249.250.150','closed',9,597,'attendances/1749/1702476091 clock_in.png','attendances/1749/1702511884 clock_out.png','Juan R',43892,NULL,'2023-12-13 11:01:31','2023-12-18 17:41:01'),(4039,'2023-12-13 06:01:00','2023-12-13 18:48:00','12.249.250.150','12.249.250.150','closed',12,767,'attendances/2235/1702476112 clock_in.png','attendances/2235/1702522128 clock_out.png','Juan R',43891,NULL,'2023-12-13 11:01:52','2023-12-18 17:40:50'),(4040,'2023-12-13 06:02:00','2023-12-13 18:49:00','12.249.250.150','12.249.250.150','closed',12,767,'attendances/2094/1702476164 clock_in.png','attendances/2094/1702522159 clock_out.png','Juan R',43894,NULL,'2023-12-13 11:02:44','2023-12-18 17:43:06'),(4041,'2023-12-13 06:05:00','2023-12-13 16:04:00','12.249.250.150','12.249.250.150','closed',9,599,'attendances/2170/1702476326 clock_in.png','attendances/2170/1702512286 clock_out.png','Juan R',43915,NULL,'2023-12-13 11:05:26','2023-12-18 17:41:57'),(4042,'2023-12-13 06:05:00','2023-12-13 16:31:00','12.249.250.150','12.249.250.150','closed',10,626,'attendances/2150/1702476332 clock_in.png','attendances/2150/1702513864 clock_out.png','Juan R',43876,NULL,'2023-12-13 11:05:32','2023-12-18 17:29:01'),(4043,'2023-12-13 06:07:00','2023-12-13 16:49:00','12.249.250.150','12.249.250.150','closed',10,642,'attendances/1950/1702476454 clock_in.png','attendances/1950/1702514990 clock_out.png','Juan R',43893,NULL,'2023-12-13 11:07:34','2023-12-18 17:42:16'),(4044,'2023-12-13 06:09:00','2023-12-13 18:50:00','12.249.250.150','12.249.250.150','closed',12,761,'attendances/2222/1702476557 clock_in.png','attendances/2222/1702522202 clock_out.png','Juan R',43896,NULL,'2023-12-13 11:09:17','2023-12-18 17:43:33'),(4045,'2023-12-13 06:47:00','2023-12-13 19:17:00','12.249.250.150','12.249.250.150','closed',12,750,'attendances/1999/1702478822 clock_in.png','attendances/1999/1702523865 clock_out.png','Juan R',43908,NULL,'2023-12-13 11:47:02','2023-12-18 17:36:58'),(4046,'2023-12-13 06:49:00','2023-12-13 19:40:00','12.249.250.150','12.249.250.150','closed',12,771,'attendances/1395/1702478954 clock_in.png','attendances/1395/1702525233 clock_out.png','Juan R',43914,NULL,'2023-12-13 11:49:14','2023-12-18 17:40:45'),(4047,'2023-12-13 06:50:00','2023-12-13 16:05:00','12.249.250.150','12.249.250.150','closed',9,555,'attendances/1116/1702479029 clock_in.png','attendances/1116/1702512356 clock_out.png','Juan R',43913,NULL,'2023-12-13 11:50:29','2023-12-18 17:40:33'),(4048,'2023-12-13 06:51:00','2023-12-13 19:02:00','12.249.250.150','12.249.250.150','closed',12,731,'attendances/2178/1702479086 clock_in.png','attendances/2178/1702522924 clock_out.png','Juan R',43903,NULL,'2023-12-13 11:51:26','2023-12-18 17:29:14'),(4049,'2023-12-13 06:51:00','2023-12-13 19:02:00','12.249.250.150','12.249.250.150','closed',12,731,'attendances/2179/1702479110 clock_in.png','attendances/2179/1702522946 clock_out.png','Juan R',43918,NULL,'2023-12-13 11:51:50','2023-12-18 17:44:58'),(4050,'2023-12-13 06:52:00','2023-12-13 16:40:00','12.249.250.150','12.249.250.150','closed',9,588,'attendances/2008/1702479158 clock_in.png','attendances/2008/1702514448 clock_out.png','Juan R',43907,NULL,'2023-12-13 11:52:38','2023-12-18 17:36:01'),(4051,'2023-12-13 06:54:00','2023-12-13 19:40:00','12.249.250.150','12.249.250.150','closed',12,766,'attendances/2047/1702479296 clock_in.png','attendances/2047/1702525205 clock_out.png','Juan R',43906,NULL,'2023-12-13 11:54:56','2023-12-18 17:34:32'),(4052,'2023-12-13 06:55:00','2023-12-13 19:39:00','12.249.250.150','12.249.250.150','closed',12,764,'attendances/2061/1702479307 clock_in.png','attendances/2061/1702525185 clock_out.png','Juan R',43910,NULL,'2023-12-13 11:55:07','2023-12-18 17:38:54'),(4053,'2023-12-13 06:55:00','2023-12-13 16:12:00','12.249.250.150','12.249.250.150','closed',9,557,'attendances/1728/1702479320 clock_in.png','attendances/1728/1702512770 clock_out.png','Juan R',43911,NULL,'2023-12-13 11:55:20','2023-12-18 17:39:13'),(4054,'2023-12-13 06:55:00','2023-12-13 16:43:00','12.249.250.150','12.249.250.150','closed',9,588,'attendances/1181/1702479342 clock_in.png','attendances/1181/1702514636 clock_out.png','Juan R',43917,NULL,'2023-12-13 11:55:42','2023-12-18 17:43:25'),(4055,'2023-12-13 06:55:00','2023-12-13 15:36:00','12.249.250.150','12.249.250.150','closed',8,521,'attendances/1858/1702479347 clock_in.png','attendances/1858/1702510579 clock_out.png','Juan R',43912,NULL,'2023-12-13 11:55:47','2023-12-18 17:39:33'),(4056,'2023-12-13 06:56:00','2023-12-13 15:36:00','12.249.250.150','12.249.250.150','closed',8,520,'attendances/1958/1702479365 clock_in.png','attendances/1958/1702510563 clock_out.png','Juan R',43905,NULL,'2023-12-13 11:56:05','2023-12-18 17:34:26'),(4057,'2023-12-13 06:57:00','2023-12-13 16:03:00','12.249.250.150','12.249.250.150','closed',9,546,'attendances/2116/1702479435 clock_in.png','attendances/2116/1702512227 clock_out.png','Juan R',43904,NULL,'2023-12-13 11:57:15','2023-12-18 17:32:03'),(4058,'2023-12-13 06:58:00','2023-12-13 16:30:00','12.249.250.150','12.249.250.150','closed',9,572,'attendances/726/1702479492 clock_in.png','attendances/726/1702513842 clock_out.png','Juan R',43902,NULL,'2023-12-13 11:58:12','2023-12-18 17:28:47'),(4059,'2023-12-13 06:59:00','2023-12-13 19:18:00','12.249.250.150','12.249.250.150','closed',12,739,'attendances/974/1702479564 clock_in.png','attendances/974/1702523892 clock_out.png','Juan R',43901,NULL,'2023-12-13 11:59:24','2023-12-18 17:27:56'),(4060,'2023-12-13 06:59:00','2023-12-13 16:04:00','12.249.250.150','12.249.250.150','closed',9,545,'attendances/2057/1702479572 clock_in.png','attendances/2057/1702512247 clock_out.png','Juan R',43889,NULL,'2023-12-13 11:59:32','2023-12-18 17:34:19'),(4061,'2023-12-13 07:01:00','2023-12-13 16:16:00','12.249.250.150','12.249.250.150','closed',9,555,'attendances/1948/1702479694 clock_in.png','attendances/1948/1702512995 clock_out.png','Juan R',43916,NULL,'2023-12-13 12:01:34','2023-12-18 17:43:00'),(4062,'2023-12-13 07:05:00','2023-12-13 15:42:00','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1888/1702479927 clock_in.png','attendances/1888/1702510948 clock_out.png','Juan R',43919,NULL,'2023-12-13 12:05:27','2023-12-18 17:45:07'),(4063,'2023-12-13 07:07:00','2023-12-13 15:42:00','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1462/1702480034 clock_in.png','attendances/1462/1702510934 clock_out.png','Juan R',43909,NULL,'2023-12-13 12:07:14','2023-12-18 17:37:01'),(4064,'2023-12-13 08:00:00','2023-12-13 16:31:00','12.249.250.150','12.249.250.150','closed',8,511,'attendances/775/1702483218 clock_in.png','attendances/775/1702513875 clock_out.png','Juan R',43921,NULL,'2023-12-13 13:00:18','2023-12-18 17:41:16'),(4065,'2023-12-13 08:00:00','2023-12-13 16:33:00','12.249.250.150','12.249.250.150','closed',8,513,'attendances/1869/1702483253 clock_in.png','attendances/1869/1702513987 clock_out.png','Juan R',43920,NULL,'2023-12-13 13:00:53','2023-12-18 17:32:00'),(4066,'2023-12-13 08:02:00','2023-12-13 16:35:00','12.249.250.150','12.249.250.150','closed',8,513,'attendances/1891/1702483368 clock_in.png','attendances/1891/1702514137 clock_out.png','Juan R',43922,NULL,'2023-12-13 13:02:48','2023-12-18 17:42:47'),(4067,'2023-12-13 08:58:00','2023-12-13 18:34:00','12.249.250.150','12.249.250.150','closed',9,576,'attendances/2230/1702486697 clock_in.png','attendances/2230/1702521293 clock_out.png','Juan R',43924,NULL,'2023-12-13 13:58:17','2023-12-18 17:44:46'),(4068,'2023-12-13 08:58:00','2023-12-13 18:31:00','12.249.250.150','12.249.250.150','closed',9,573,'attendances/1479/1702486718 clock_in.png','attendances/1479/1702521115 clock_out.png','Juan R',43923,NULL,'2023-12-13 13:58:38','2023-12-18 17:32:54'),(4069,'2023-12-13 09:52:00','2023-12-13 18:30:00','12.249.250.150','12.249.250.150','closed',8,518,'attendances/2200/1702489967 clock_in.png','attendances/2200/1702521004 clock_out.png','Juan R',43925,NULL,'2023-12-13 14:52:47','2023-12-18 17:33:50'),(4070,'2023-12-13 13:58:00','2023-12-13 20:34:00','12.249.250.150','38.51.234.69','closed',6,396,'attendances/2058/1702504703 clock_in.png',NULL,'Juan R',43926,NULL,'2023-12-13 18:58:23','2023-12-18 17:43:11'),(4071,'2023-12-13 13:59:00','2023-12-13 20:35:00','12.249.250.150','38.51.234.69','closed',6,396,'attendances/2236/1702504741 clock_in.png',NULL,'Juan R',43927,NULL,'2023-12-13 18:59:01','2023-12-18 17:44:24'),(4074,'2023-12-14 04:50:00','2023-12-14 18:23:00','12.249.250.150','12.249.250.150','closed',13,813,'attendances/1116/1702558247 clock_in.png','attendances/1116/1702607007 clock_out.png','Juan R',43975,NULL,'2023-12-14 09:50:47','2023-12-18 17:40:33'),(4075,'2023-12-14 04:54:00','2023-12-14 19:46:00','12.249.250.150','12.249.250.150','closed',14,892,'attendances/726/1702558440 clock_in.png','attendances/726/1702612004 clock_out.png','Juan R',43971,NULL,'2023-12-14 09:54:00','2023-12-18 17:28:47'),(4076,'2023-12-14 04:56:00','2023-12-14 18:17:00','12.249.250.150','12.249.250.150','closed',13,801,'attendances/2116/1702558603 clock_in.png','attendances/2116/1702606646 clock_out.png','Juan R',43972,NULL,'2023-12-14 09:56:43','2023-12-18 17:32:03'),(4077,'2023-12-14 04:57:00','2023-12-14 18:18:00','12.249.250.150','12.249.250.150','closed',13,801,'attendances/1666/1702558678 clock_in.png','attendances/1666/1702606707 clock_out.png','Juan R',43974,NULL,'2023-12-14 09:57:58','2023-12-18 17:36:54'),(4078,'2023-12-14 04:59:00','2023-12-14 18:23:00','12.249.250.150','12.249.250.150','closed',13,804,'attendances/2141/1702558791 clock_in.png','attendances/2141/1702607006 clock_out.png','Juan R',43973,NULL,'2023-12-14 09:59:51','2023-12-18 17:34:07'),(4079,'2023-12-14 05:00:00','2023-12-14 19:49:00','12.249.250.150','12.249.250.150','closed',14,889,'attendances/1450/1702558803 clock_in.png','attendances/1450/1702612189 clock_out.png','Juan R',43976,NULL,'2023-12-14 10:00:03','2023-12-18 17:43:18'),(4080,'2023-12-14 05:03:00','2023-12-14 18:15:00','12.249.250.150','12.249.250.150','closed',13,792,'attendances/2234/1702559028 clock_in.png','attendances/2234/1702606552 clock_out.png','Juan R',44021,NULL,'2023-12-14 10:03:48','2023-12-18 17:43:23'),(4081,'2023-12-14 05:19:00','2023-12-14 21:06:00','12.249.250.150','12.249.250.150','closed',15,947,'attendances/2200/1702559990 clock_in.png','attendances/2200/1702616811 clock_out.png','Juan R',43979,NULL,'2023-12-14 10:19:50','2023-12-18 17:33:50'),(4082,'2023-12-14 05:21:00','2023-12-14 18:37:00','12.249.250.150','12.249.250.150','closed',13,796,'attendances/1585/1702560112 clock_in.png','attendances/1585/1702607864 clock_out.png','Juan R',43977,NULL,'2023-12-14 10:21:52','2023-12-18 17:31:30'),(4083,'2023-12-14 05:31:00','2023-12-14 18:22:00','12.249.250.150','12.249.250.150','closed',12,771,'attendances/2169/1702560695 clock_in.png','attendances/2169/1702606967 clock_out.png','Juan R',43978,NULL,'2023-12-14 10:31:35','2023-12-18 17:33:44'),(4084,'2023-12-14 05:54:00','2023-12-14 18:44:00','12.249.250.150','12.249.250.150','closed',12,770,'attendances/2008/1702562077 clock_in.png','attendances/2008/1702608297 clock_out.png','Juan R',43987,NULL,'2023-12-14 10:54:37','2023-12-18 17:36:01'),(4085,'2023-12-14 05:56:00','2023-12-14 16:31:00','12.249.250.150','12.249.250.150','closed',10,635,'attendances/1934/1702562187 clock_in.png','attendances/1934/1702600316 clock_out.png','Juan R',43989,NULL,'2023-12-14 10:56:27','2023-12-18 17:39:05'),(4086,'2023-12-14 05:56:00','2023-12-14 19:10:00','12.249.250.150','12.249.250.150','closed',13,794,'attendances/1551/1702562200 clock_in.png','attendances/1551/1702609805 clock_out.png','Juan R',43982,NULL,'2023-12-14 10:56:40','2023-12-18 17:28:56'),(4087,'2023-12-14 05:56:00','2023-12-14 16:30:00','12.249.250.150','12.249.250.150','closed',10,634,'attendances/1774/1702562214 clock_in.png','attendances/1774/1702600246 clock_out.png','Juan R',43985,NULL,'2023-12-14 10:56:54','2023-12-18 17:34:04'),(4088,'2023-12-14 05:57:00','2023-12-14 16:31:00','12.249.250.150','12.249.250.150','closed',10,634,'attendances/1744/1702562224 clock_in.png','attendances/1744/1702600296 clock_out.png','Juan R',43991,NULL,'2023-12-14 10:57:04','2023-12-18 17:40:43'),(4089,'2023-12-14 05:57:00','2023-12-14 16:40:00','12.249.250.150','12.249.250.150','closed',10,643,'attendances/1568/1702562228 clock_in.png','attendances/1568/1702600850 clock_out.png','Juan R',43983,NULL,'2023-12-14 10:57:08','2023-12-18 17:31:51'),(4090,'2023-12-14 05:57:00','2023-12-14 19:04:00','12.249.250.150','12.249.250.150','closed',13,787,'attendances/2233/1702562252 clock_in.png','attendances/2233/1702609489 clock_out.png','Juan R',43996,NULL,'2023-12-14 10:57:32','2023-12-18 17:44:02'),(4091,'2023-12-14 05:58:00','2023-12-14 21:11:00','12.249.250.150','12.249.250.150','closed',15,913,'attendances/1999/1702562315 clock_in.png','attendances/1999/1702617066 clock_out.png','Juan R',44002,NULL,'2023-12-14 10:58:35','2023-12-18 17:36:58'),(4092,'2023-12-14 05:58:00','2023-12-14 19:04:00','12.249.250.150','12.249.250.150','closed',13,786,'attendances/2235/1702562319 clock_in.png','attendances/2235/1702609473 clock_out.png','Juan R',43992,NULL,'2023-12-14 10:58:39','2023-12-18 17:40:50'),(4093,'2023-12-14 05:59:00','2023-12-14 18:23:00','12.249.250.150','12.249.250.150','closed',12,744,'attendances/2058/1702562348 clock_in.png','attendances/2058/1702606987 clock_out.png','Juan R',43994,NULL,'2023-12-14 10:59:08','2023-12-18 17:43:11'),(4094,'2023-12-14 05:59:00','2023-12-14 18:13:00','12.249.250.150','12.249.250.150','closed',12,734,'attendances/622/1702562358 clock_in.png','attendances/622/1702606438 clock_out.png','Juan R',43997,NULL,'2023-12-14 10:59:18','2023-12-18 17:44:20'),(4095,'2023-12-14 05:59:00','2023-12-14 19:10:00','12.249.250.150','12.249.250.150','closed',13,791,'attendances/2222/1702562382 clock_in.png','attendances/2222/1702609838 clock_out.png','Juan R',43995,NULL,'2023-12-14 10:59:42','2023-12-18 17:43:33'),(4096,'2023-12-14 06:00:00','2023-12-14 17:29:00','12.249.250.150','12.249.250.150','closed',11,689,'attendances/2218/1702562407 clock_in.png','attendances/2218/1702603763 clock_out.png','Juan R',43988,NULL,'2023-12-14 11:00:07','2023-12-18 17:37:06'),(4097,'2023-12-14 06:01:00','2023-12-14 19:05:00','12.249.250.150','12.249.250.150','closed',13,784,'attendances/2094/1702562467 clock_in.png','attendances/2094/1702609554 clock_out.png','Juan R',43993,NULL,'2023-12-14 11:01:07','2023-12-18 17:43:06'),(4098,'2023-12-14 06:03:00','2023-12-14 18:30:00','12.249.250.150','12.249.250.150','closed',12,747,'attendances/2133/1702562592 clock_in.png','attendances/2133/1702607410 clock_out.png','Juan R',43990,NULL,'2023-12-14 11:03:12','2023-12-18 17:39:38'),(4099,'2023-12-14 06:03:00','2023-12-14 15:56:00','12.249.250.150','12.249.250.150','closed',9,593,'attendances/1951/1702562608 clock_in.png','attendances/1951/1702598204 clock_out.png','Juan R',43984,NULL,'2023-12-14 11:03:28','2023-12-18 17:33:02'),(4100,'2023-12-14 06:04:00','2023-12-14 18:44:00','12.249.250.150','12.249.250.150','closed',12,760,'attendances/2168/1702562643 clock_in.png','attendances/2168/1702608286 clock_out.png','Juan R',43986,NULL,'2023-12-14 11:04:03','2023-12-18 17:34:22'),(4101,'2023-12-14 06:04:00','2023-12-14 18:30:00','12.249.250.150','12.249.250.150','closed',12,746,'attendances/2150/1702562699 clock_in.png','attendances/2150/1702607424 clock_out.png','Juan R',43981,NULL,'2023-12-14 11:04:59','2023-12-18 17:29:01'),(4102,'2023-12-14 06:31:00','2023-12-14 18:47:00','12.249.250.150','12.249.250.150','closed',12,736,'attendances/1181/1702564289 clock_in.png','attendances/1181/1702608426 clock_out.png','Juan R',43999,NULL,'2023-12-14 11:31:29','2023-12-18 17:43:25'),(4103,'2023-12-14 06:32:00','2023-12-14 18:47:00','12.249.250.150','12.249.250.150','closed',12,735,'attendances/1749/1702564320 clock_in.png','attendances/1749/1702608434 clock_out.png','Juan R',43998,NULL,'2023-12-14 11:32:00','2023-12-18 17:41:01'),(4104,'2023-12-14 06:56:00','2023-12-14 19:55:00','12.249.250.150','12.249.250.150','closed',12,779,'attendances/1395/1702565782 clock_in.png','attendances/1395/1702612552 clock_out.png','Juan R',44006,NULL,'2023-12-14 11:56:22','2023-12-18 17:40:45'),(4105,'2023-12-14 06:56:00','2023-12-14 15:34:00','12.249.250.150','12.249.250.150','closed',8,518,'attendances/1858/1702565786 clock_in.png','attendances/1858/1702596844 clock_out.png','Juan R',44005,NULL,'2023-12-14 11:56:26','2023-12-18 17:39:33'),(4106,'2023-12-14 06:58:00','2023-12-14 17:21:00','12.249.250.150','12.249.250.150','closed',10,623,'attendances/2236/1702565894 clock_in.png','attendances/2236/1702603264 clock_out.png','Juan R',44010,NULL,'2023-12-14 11:58:14','2023-12-18 17:44:24'),(4107,'2023-12-14 06:58:00','2023-12-14 15:34:00','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1958/1702565903 clock_in.png','attendances/1958/1702596857 clock_out.png','Juan R',44001,NULL,'2023-12-14 11:58:23','2023-12-18 17:34:26'),(4108,'2023-12-14 06:58:00','2023-12-14 16:01:00','12.249.250.150','12.249.250.150','closed',9,543,'attendances/1728/1702565908 clock_in.png','attendances/1728/1702598470 clock_out.png','Juan R',44004,NULL,'2023-12-14 11:58:28','2023-12-18 17:39:13'),(4109,'2023-12-14 06:59:00','2023-12-14 18:31:00','12.249.250.150','12.249.250.150','closed',11,692,'attendances/2170/1702565976 clock_in.png','attendances/2170/1702607494 clock_out.png','Juan R',44008,NULL,'2023-12-14 11:59:36','2023-12-18 17:41:57'),(4110,'2023-12-14 07:00:00','2023-12-14 19:55:00','12.249.250.150','12.249.250.150','closed',12,775,'attendances/974/1702566007 clock_in.png','attendances/974/1702612538 clock_out.png','Juan R',44000,NULL,'2023-12-14 12:00:07','2023-12-18 17:27:56'),(4111,'2023-12-14 07:03:00','2023-12-14 17:56:00','12.249.250.150','12.249.250.150','closed',10,653,'attendances/1948/1702566205 clock_in.png','attendances/1948/1702605386 clock_out.png','Juan R',44009,NULL,'2023-12-14 12:03:25','2023-12-18 17:43:00'),(4112,'2023-12-14 07:05:00','2023-12-14 16:08:00','12.249.250.150','12.249.250.150','closed',9,543,'attendances/1888/1702566323 clock_in.png','attendances/1888/1702598916 clock_out.png','Juan R',44011,NULL,'2023-12-14 12:05:23','2023-12-18 17:45:07'),(4113,'2023-12-14 07:06:00','2023-12-14 15:38:00','12.249.250.150','12.249.250.150','closed',8,512,'attendances/1462/1702566371 clock_in.png','attendances/1462/1702597102 clock_out.png','Juan R',44003,NULL,'2023-12-14 12:06:11','2023-12-18 17:37:01'),(4114,'2023-12-14 07:52:00','2023-12-14 16:57:00','12.249.250.150','12.249.250.150','closed',9,545,'attendances/2179/1702569155 clock_in.png','attendances/2179/1702601866 clock_out.png','Juan R',44020,NULL,'2023-12-14 12:52:35','2023-12-18 17:44:58'),(4115,'2023-12-14 07:52:00','2023-12-14 16:57:00','12.249.250.150','12.249.250.150','closed',9,545,'attendances/2178/1702569167 clock_in.png','attendances/2178/1702601875 clock_out.png','Juan R',44012,NULL,'2023-12-14 12:52:47','2023-12-18 17:29:14'),(4116,'2023-12-14 07:54:00','2023-12-14 18:55:00','12.249.250.150','12.249.250.150','closed',11,661,'attendances/2047/1702569249 clock_in.png','attendances/2047/1702608907 clock_out.png','Juan R',44015,NULL,'2023-12-14 12:54:09','2023-12-18 17:34:32'),(4117,'2023-12-14 07:54:00','2023-12-14 18:55:00','12.249.250.150','12.249.250.150','closed',11,661,'attendances/2061/1702569261 clock_in.png','attendances/2061/1702608919 clock_out.png','Juan R',44016,NULL,'2023-12-14 12:54:21','2023-12-18 17:38:54'),(4118,'2023-12-14 07:55:00','2023-12-14 18:26:00','12.249.250.150','12.249.250.150','closed',10,631,'attendances/1479/1702569352 clock_in.png','attendances/1479/1702607179 clock_out.png','Juan R',44014,NULL,'2023-12-14 12:55:52','2023-12-18 17:32:54'),(4119,'2023-12-14 07:57:00','2023-12-14 18:32:00','12.249.250.150','12.249.250.150','closed',10,635,'attendances/2230/1702569454 clock_in.png','attendances/2230/1702607540 clock_out.png','Juan R',44019,NULL,'2023-12-14 12:57:34','2023-12-18 17:44:46'),(4120,'2023-12-14 08:00:00','2023-12-14 16:34:00','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1869/1702569608 clock_in.png','attendances/1869/1702600479 clock_out.png','Juan R',44013,NULL,'2023-12-14 13:00:08','2023-12-18 17:32:00'),(4121,'2023-12-14 08:01:00','2023-12-14 17:21:00','12.249.250.150','12.249.250.150','closed',9,560,'attendances/2239/1702569692 clock_in.png','attendances/2239/1702603278 clock_out.png','Juan R',44018,NULL,'2023-12-14 13:01:32','2023-12-18 17:40:53'),(4122,'2023-12-14 08:03:00','2023-12-14 16:34:00','12.249.250.150','12.249.250.150','closed',8,511,'attendances/1891/1702569802 clock_in.png','attendances/1891/1702600468 clock_out.png','Juan R',44017,NULL,'2023-12-14 13:03:22','2023-12-18 17:42:47'),(4123,'2023-12-14 08:03:00','2023-12-14 16:30:00','12.249.250.150','12.249.250.150','closed',8,507,'attendances/775/1702569815 clock_in.png','attendances/775/1702600256 clock_out.png','Juan R',44007,NULL,'2023-12-14 13:03:35','2023-12-18 17:41:16'),(4125,'2023-12-14 21:01:00','2023-12-14 23:29:00','12.249.250.150','38.51.234.69','closed',2,148,'attendances/2230/1702616502 clock_in.png',NULL,'Juan R',44079,NULL,'2023-12-15 02:01:42','2023-12-18 17:44:46'),(4126,'2023-12-14 21:00:00','2023-12-14 23:31:00','38.51.234.69','38.51.234.69','closed',2,151,NULL,NULL,'Juan R',44080,NULL,'2023-12-15 09:18:41','2023-12-18 17:27:56'),(4127,'2023-12-15 04:47:00','2023-12-15 16:30:00','12.249.250.150','12.249.250.150','closed',11,703,'attendances/2200/1702644478 clock_in.png','attendances/2200/1702686639 clock_out.png','Juan R',44047,NULL,'2023-12-15 09:47:58','2023-12-18 17:33:50'),(4128,'2023-12-15 05:00:00','2023-12-15 15:32:00','12.249.250.150','12.249.250.150','closed',10,632,'attendances/1395/1702645229 clock_in.png','attendances/1395/1702683144 clock_out.png','Juan R',44054,NULL,'2023-12-15 10:00:29','2023-12-18 17:40:45'),(4129,'2023-12-15 05:27:00','2023-12-15 16:09:00','12.249.250.150','12.249.250.150','closed',10,642,'attendances/2047/1702646838 clock_in.png','attendances/2047/1702685385 clock_out.png','Juan R',44043,NULL,'2023-12-15 10:27:18','2023-12-18 17:34:32'),(4130,'2023-12-15 05:27:00','2023-12-15 16:09:00','12.249.250.150','12.249.250.150','closed',10,642,'attendances/2061/1702646879 clock_in.png','attendances/2061/1702685373 clock_out.png','Juan R',44044,NULL,'2023-12-15 10:27:59','2023-12-18 17:38:54'),(4131,'2023-12-15 05:53:00','2023-12-15 15:31:00','12.249.250.150','12.249.250.150','closed',9,578,'attendances/1774/1702648438 clock_in.png','attendances/1774/1702683087 clock_out.png','Juan R',44034,NULL,'2023-12-15 10:53:58','2023-12-18 17:34:04'),(4132,'2023-12-15 05:54:00','2023-12-15 16:32:00','12.249.250.150','12.249.250.150','closed',10,638,'attendances/1585/1702648456 clock_in.png','attendances/1585/1702686731 clock_out.png','Juan R',44030,NULL,'2023-12-15 10:54:17','2023-12-18 17:31:30'),(4133,'2023-12-15 05:54:00','2023-12-15 17:12:00','12.249.250.150','12.249.250.150','closed',11,678,'attendances/2094/1702648489 clock_in.png','attendances/2094/1702689148 clock_out.png','Juan R',44040,NULL,'2023-12-15 10:54:49','2023-12-18 17:43:06'),(4134,'2023-12-15 05:55:00','2023-12-15 15:31:00','12.249.250.150','12.249.250.150','closed',9,576,'attendances/1934/1702648516 clock_in.png','attendances/1934/1702683072 clock_out.png','Juan R',44037,NULL,'2023-12-15 10:55:16','2023-12-18 17:39:05'),(4135,'2023-12-15 05:56:00','2023-12-15 16:51:00','12.249.250.150','12.249.250.150','closed',10,655,'attendances/2222/1702648575 clock_in.png','attendances/2222/1702687919 clock_out.png','Juan R',44041,NULL,'2023-12-15 10:56:15','2023-12-18 17:43:33'),(4136,'2023-12-15 05:56:00','2023-12-15 17:12:00','12.249.250.150','12.249.250.150','closed',11,676,'attendances/2169/1702648598 clock_in.png','attendances/2169/1702689160 clock_out.png','Juan R',44032,NULL,'2023-12-15 10:56:38','2023-12-18 17:33:44'),(4137,'2023-12-15 05:57:00','2023-12-15 15:31:00','12.249.250.150','12.249.250.150','closed',9,574,'attendances/2168/1702648620 clock_in.png','attendances/2168/1702683097 clock_out.png','Juan R',44035,NULL,'2023-12-15 10:57:00','2023-12-18 17:34:22'),(4138,'2023-12-15 05:57:00','2023-12-15 18:03:00','12.249.250.150','12.249.250.150','closed',12,726,'attendances/1568/1702648662 clock_in.png','attendances/1568/1702692239 clock_out.png','Juan R',44031,NULL,'2023-12-15 10:57:42','2023-12-18 17:31:51'),(4139,'2023-12-15 05:58:00','2023-12-15 15:32:00','12.249.250.150','12.249.250.150','closed',9,574,'attendances/2150/1702648702 clock_in.png','attendances/2150/1702683137 clock_out.png','Juan R',44028,NULL,'2023-12-15 10:58:22','2023-12-18 17:29:01'),(4140,'2023-12-15 05:58:00','2023-12-15 17:00:00','12.249.250.150','179.19.89.219','closed',11,662,'attendances/2133/1702648715 clock_in.png',NULL,'Juan R',44038,NULL,'2023-12-15 10:58:35','2023-12-18 17:39:38'),(4141,'2023-12-15 05:58:00','2023-12-15 13:02:00','12.249.250.150','12.249.250.150','closed',7,424,'attendances/1951/1702648731 clock_in.png','attendances/1951/1702674176 clock_out.png','Juan R',44033,NULL,'2023-12-15 10:58:51','2023-12-18 17:33:02'),(4142,'2023-12-15 05:59:00','2023-12-15 16:54:00','12.249.250.150','12.249.250.150','closed',10,655,'attendances/1666/1702648745 clock_in.png','attendances/1666/1702688080 clock_out.png','Juan R',44036,NULL,'2023-12-15 10:59:05','2023-12-18 17:36:54'),(4143,'2023-12-15 05:59:00','2023-12-15 16:54:00','12.249.250.150','12.249.250.150','closed',10,655,'attendances/2141/1702648759 clock_in.png','attendances/2141/1702688063 clock_out.png','Juan R',44069,NULL,'2023-12-15 10:59:19','2023-12-18 17:34:07'),(4144,'2023-12-15 05:59:00','2023-12-15 15:31:00','12.249.250.150','12.249.250.150','closed',9,572,'attendances/622/1702648790 clock_in.png','attendances/622/1702683118 clock_out.png','Juan R',44042,NULL,'2023-12-15 10:59:50','2023-12-18 17:44:20'),(4145,'2023-12-15 06:03:00','2023-12-15 15:31:00','12.249.250.150','12.249.250.150','closed',9,568,'attendances/1744/1702648989 clock_in.png','attendances/1744/1702683107 clock_out.png','Juan R',44039,NULL,'2023-12-15 11:03:09','2023-12-18 17:40:43'),(4146,'2023-12-15 06:51:00','2023-12-15 16:14:00','12.249.250.150','12.249.250.150','closed',9,563,'attendances/1999/1702651875 clock_in.png','attendances/1999/1702685681 clock_out.png','Juan R',44050,NULL,'2023-12-15 11:51:15','2023-12-18 17:36:58'),(4147,'2023-12-15 06:54:00','2023-12-15 19:06:00','12.249.250.150','12.249.250.150','closed',12,732,'attendances/2179/1702652043 clock_in.png','attendances/2179/1702695983 clock_out.png','Juan R',44065,NULL,'2023-12-15 11:54:03','2023-12-18 17:44:58'),(4148,'2023-12-15 06:54:00','2023-12-15 19:06:00','12.249.250.150','12.249.250.150','closed',12,732,'attendances/2178/1702652068 clock_in.png','attendances/2178/1702695969 clock_out.png','Juan R',44046,NULL,'2023-12-15 11:54:28','2023-12-18 17:29:14'),(4149,'2023-12-15 06:55:00','2023-12-15 16:35:00','12.249.250.150','12.249.250.150','closed',9,580,'attendances/2239/1702652118 clock_in.png','attendances/2239/1702686933 clock_out.png','Juan R',44056,NULL,'2023-12-15 11:55:18','2023-12-18 17:40:53'),(4150,'2023-12-15 06:55:00','2023-12-15 17:32:00','12.249.250.150','190.89.30.156','closed',10,637,'attendances/726/1702652148 clock_in.png','attendances/726/1702652180 clock_out.png','Juan R',44045,NULL,'2023-12-15 11:55:48','2023-12-18 17:28:47'),(4151,'2023-12-15 06:56:00','2023-12-15 16:55:00','12.249.250.150','12.249.250.150','closed',9,599,'attendances/2230/1702652167 clock_in.png','attendances/2230/1702688154 clock_out.png','Juan R',44064,NULL,'2023-12-15 11:56:07','2023-12-18 17:44:46'),(4152,'2023-12-15 06:56:00','2023-12-15 16:09:00','12.249.250.150','12.249.250.150','closed',9,553,'attendances/2008/1702652206 clock_in.png','attendances/2008/1702685360 clock_out.png','Juan R',44049,NULL,'2023-12-15 11:56:46','2023-12-18 17:36:01'),(4153,'2023-12-15 06:57:00','2023-12-15 18:17:00','12.249.250.150','12.249.250.150','closed',11,680,'attendances/2170/1702652226 clock_in.png','attendances/2170/1702693044 clock_out.png','Juan R',44058,NULL,'2023-12-15 11:57:06','2023-12-18 17:41:57'),(4154,'2023-12-15 06:58:00','2023-12-15 16:58:00','12.249.250.150','12.249.250.150','closed',10,600,'attendances/1749/1702652294 clock_in.png','attendances/1749/1702688320 clock_out.png','Juan R',44057,NULL,'2023-12-15 11:58:14','2023-12-18 17:41:01'),(4155,'2023-12-15 06:58:00','2023-12-15 16:37:00','12.249.250.150','12.249.250.150','closed',9,579,'attendances/2218/1702652320 clock_in.png','attendances/2218/1702687026 clock_out.png','Juan R',44052,NULL,'2023-12-15 11:58:40','2023-12-18 17:37:06'),(4156,'2023-12-15 06:58:00','2023-12-15 16:04:00','12.249.250.150','12.249.250.150','closed',9,546,'attendances/974/1702652321 clock_in.png','attendances/974/1702685068 clock_out.png','Juan R',44081,NULL,'2023-12-15 11:58:41','2023-12-18 17:27:56'),(4157,'2023-12-15 06:58:00','2023-12-15 18:03:00','12.249.250.150','12.249.250.150','closed',11,665,'attendances/2233/1702652332 clock_in.png','attendances/2233/1702692202 clock_out.png','Juan R',44063,NULL,'2023-12-15 11:58:52','2023-12-18 17:44:02'),(4158,'2023-12-15 06:59:00','2023-12-15 16:43:00','12.249.250.150','12.249.250.150','closed',9,584,'attendances/1450/1702652378 clock_in.png','attendances/1450/1702687428 clock_out.png','Juan R',44061,NULL,'2023-12-15 11:59:38','2023-12-18 17:43:18'),(4159,'2023-12-15 07:00:00','2023-12-15 16:36:00','12.249.250.150','12.249.250.150','closed',9,576,'attendances/2235/1702652414 clock_in.png','attendances/2235/1702686993 clock_out.png','Juan R',44055,NULL,'2023-12-15 12:00:14','2023-12-18 17:40:50'),(4160,'2023-12-15 07:01:00','2023-12-15 15:48:00','12.249.250.150','12.249.250.150','closed',8,527,'attendances/1948/1702652486 clock_in.png','attendances/1948/1702684103 clock_out.png','Juan R',44059,NULL,'2023-12-15 12:01:26','2023-12-18 17:43:00'),(4161,'2023-12-15 07:04:00','2023-12-15 18:03:00','12.249.250.150','12.249.250.150','closed',10,659,'attendances/2058/1702652667 clock_in.png','attendances/2058/1702692217 clock_out.png','Juan R',44060,NULL,'2023-12-15 12:04:27','2023-12-18 17:43:11'),(4162,'2023-12-15 07:06:00','2023-12-15 15:37:00','12.249.250.150','12.249.250.150','closed',8,511,'attendances/1858/1702652803 clock_in.png','attendances/1858/1702683459 clock_out.png','Juan R',44053,NULL,'2023-12-15 12:06:43','2023-12-18 17:39:33'),(4163,'2023-12-15 07:07:00','2023-12-15 15:41:00','12.249.250.150','12.249.250.150','closed',8,514,'attendances/1462/1702652829 clock_in.png','attendances/1462/1702683667 clock_out.png','Juan R',44051,NULL,'2023-12-15 12:07:09','2023-12-18 17:37:01'),(4164,'2023-12-15 07:47:00','2023-12-15 18:39:00','12.249.250.150','12.249.250.150','closed',10,652,'attendances/1181/1702655256 clock_in.png','attendances/1181/1702694370 clock_out.png','Juan R',44074,NULL,'2023-12-15 12:47:36','2023-12-18 17:43:25'),(4165,'2023-12-15 07:51:00','2023-12-15 18:39:00','12.249.250.150','12.249.250.150','closed',10,648,'attendances/1116/1702655496 clock_in.png','attendances/1116/1702694395 clock_out.png','Juan R',44071,NULL,'2023-12-15 12:51:36','2023-12-18 17:40:33'),(4166,'2023-12-15 07:53:00','2023-12-15 18:40:00','12.249.250.150','12.249.250.150','closed',10,647,'attendances/2236/1702655583 clock_in.png','attendances/2236/1702694448 clock_out.png','Juan R',44075,NULL,'2023-12-15 12:53:03','2023-12-18 17:44:24'),(4167,'2023-12-15 07:57:00','2023-12-15 18:38:00','12.249.250.150','12.249.250.150','closed',10,641,'attendances/2116/1702655837 clock_in.png','attendances/2116/1702694337 clock_out.png','Juan R',44068,NULL,'2023-12-15 12:57:17','2023-12-18 17:32:03'),(4168,'2023-12-15 05:55:00','2023-12-15 16:49:00','186.154.237.158','12.249.250.150','closed',10,654,NULL,'attendances/1551/1702687785 clock_out.png','Juan R',44029,NULL,'2023-12-15 12:57:41','2023-12-18 17:28:56'),(4169,'2023-12-15 07:58:00','2023-12-15 16:30:00','12.249.250.150','12.249.250.150','closed',8,512,'attendances/775/1702655884 clock_in.png','attendances/775/1702686631 clock_out.png','Juan R',44072,NULL,'2023-12-15 12:58:04','2023-12-18 17:41:16'),(4170,'2023-12-15 08:00:00','2023-12-15 16:35:00','12.249.250.150','179.19.89.219','closed',8,515,'attendances/1869/1702656035 clock_in.png',NULL,'Juan R',44067,NULL,'2023-12-15 13:00:35','2023-12-18 17:32:00'),(4171,'2023-12-15 08:00:00','2023-12-15 16:39:00','12.249.250.150','12.249.250.150','closed',8,519,'attendances/1891/1702656039 clock_in.png','attendances/1891/1702687161 clock_out.png','Juan R',44073,NULL,'2023-12-15 13:00:39','2023-12-18 17:42:47'),(4172,'2023-12-15 08:04:00','2023-12-15 17:19:00','12.249.250.150','190.89.30.156','closed',9,555,'attendances/2195/1702656284 clock_in.png','attendances/2195/1702672340 clock_out.png','Juan R',44070,NULL,'2023-12-15 13:04:44','2023-12-18 17:33:53'),(4173,'2023-12-15 06:55:00','2023-12-15 15:32:00','186.154.237.158','12.249.250.150','closed',8,517,NULL,'attendances/2234/1702683133 clock_out.png','Juan R',44062,NULL,'2023-12-15 13:08:01','2023-12-18 17:43:23'),(4174,'2023-12-15 11:03:00','2023-12-15 16:01:00','12.249.250.150','12.249.250.150','closed',4,298,'attendances/1888/1702667014 clock_in.png','attendances/1888/1702684864 clock_out.png','Juan R',44066,NULL,'2023-12-15 16:03:34','2023-12-18 17:45:07'),(4179,'2023-12-16 03:19:00','2023-12-16 12:36:00','12.249.250.150','12.249.250.150','closed',9,557,'attendances/1585/1702725578 clock_in.png','attendances/1585/1702758978 clock_out.png','Juan R',44122,NULL,'2023-12-16 08:19:38','2023-12-18 17:31:30'),(4180,'2023-12-16 03:26:00','2023-12-16 12:31:00','12.249.250.150','12.249.250.150','closed',9,545,'attendances/2233/1702726019 clock_in.png','attendances/2233/1702758713 clock_out.png','Juan R',44126,NULL,'2023-12-16 08:26:59','2023-12-18 17:44:02'),(4181,'2023-12-16 03:27:00','2023-12-16 12:42:00','12.249.250.150','12.249.250.150','closed',9,555,'attendances/2234/1702726065 clock_in.png','attendances/2234/1702759325 clock_out.png','Juan R',44125,NULL,'2023-12-16 08:27:45','2023-12-18 17:43:23'),(4182,'2023-12-16 03:29:00','2023-12-16 12:34:00','12.249.250.150','12.249.250.150','closed',9,545,'attendances/2235/1702726143 clock_in.png','attendances/2235/1702758896 clock_out.png','Juan R',44124,NULL,'2023-12-16 08:29:03','2023-12-18 17:40:50'),(4183,'2023-12-16 03:29:00','2023-12-16 12:33:00','12.249.250.150','12.249.250.150','closed',9,544,'attendances/1551/1702726173 clock_in.png','attendances/1551/1702758781 clock_out.png','Juan R',44121,NULL,'2023-12-16 08:29:33','2023-12-18 17:28:56'),(4184,'2023-12-16 03:32:00','2023-12-16 12:37:00','12.249.250.150','12.249.250.150','closed',9,545,'attendances/2169/1702726335 clock_in.png','attendances/2169/1702759049 clock_out.png','Juan R',44123,NULL,'2023-12-16 08:32:15','2023-12-18 17:33:44'),(4185,'2023-12-16 03:32:00','2023-12-16 12:38:00','12.249.250.150','12.249.250.150','closed',9,546,'attendances/2133/1702726349 clock_in.png','attendances/2133/1702759113 clock_out.png','Juan R',44127,NULL,'2023-12-16 08:32:29','2023-12-18 17:39:38'),(4186,'2023-12-15 23:02:00','2023-12-15 23:59:00','38.51.234.69','38.51.234.69','closed',0,57,NULL,NULL,'Juan R',44151,NULL,'2023-12-16 08:54:56','2023-12-18 17:40:33'),(4187,'2023-12-16 00:00:00','2023-12-16 00:24:00','38.51.234.69','38.51.234.69','closed',0,24,NULL,NULL,'Juan R',44152,NULL,'2023-12-16 08:55:46','2023-12-18 17:40:33'),(4188,'2023-12-16 05:57:00','2023-12-16 14:47:00','12.249.250.150','12.249.250.150','closed',8,530,'attendances/2222/1702735040 clock_in.png','attendances/2222/1702766831 clock_out.png','Juan R',44133,NULL,'2023-12-16 10:57:20','2023-12-18 17:43:33'),(4189,'2023-12-16 05:57:00','2023-12-16 17:00:00','12.249.250.150','12.249.250.150','closed',11,663,'attendances/1749/1702735064 clock_in.png','attendances/1749/1702774828 clock_out.png','Juan R',44132,NULL,'2023-12-16 10:57:44','2023-12-18 17:41:01'),(4190,'2023-12-16 05:58:00','2023-12-16 14:31:00','12.249.250.150','12.249.250.150','closed',8,513,'attendances/1568/1702735099 clock_in.png','attendances/1568/1702765878 clock_out.png','Juan R',44128,NULL,'2023-12-16 10:58:19','2023-12-18 17:31:51'),(4191,'2023-12-16 06:00:00','2023-12-16 14:20:00','12.249.250.150','12.249.250.150','closed',8,500,'attendances/1951/1702735259 clock_in.png','attendances/1951/1702765205 clock_out.png','Juan R',44129,NULL,'2023-12-16 11:00:59','2023-12-18 17:33:02'),(4192,'2023-12-16 06:04:00','2023-12-16 14:33:00','12.249.250.150','12.249.250.150','closed',8,509,'attendances/1395/1702735489 clock_in.png','attendances/1395/1702766023 clock_out.png','Juan R',44131,NULL,'2023-12-16 11:04:49','2023-12-18 17:40:45'),(4193,'2023-12-16 06:10:00','2023-12-16 14:31:00','12.249.250.150','12.249.250.150','closed',8,501,'attendances/1999/1702735831 clock_in.png','attendances/1999/1702765887 clock_out.png','Juan R',44130,NULL,'2023-12-16 11:10:31','2023-12-18 17:36:58'),(4194,'2023-12-16 06:19:00','2023-12-16 17:00:00','38.51.234.69','12.249.250.150','closed',10,641,NULL,'attendances/2230/1702774806 clock_out.png','Juan R',44134,NULL,'2023-12-16 11:22:18','2023-12-18 17:44:46'),(4195,'2023-12-16 06:49:00','2023-12-16 15:30:00','12.249.250.150','12.249.250.150','closed',8,521,'attendances/726/1702738177 clock_in.png','attendances/726/1702769415 clock_out.png','Juan R',44135,NULL,'2023-12-16 11:49:37','2023-12-18 17:28:47'),(4196,'2023-12-16 06:54:00','2023-12-16 14:31:00','12.249.250.150','12.249.250.150','closed',7,457,'attendances/2008/1702738472 clock_in.png','attendances/2008/1702765877 clock_out.png','Juan R',44138,NULL,'2023-12-16 11:54:32','2023-12-18 17:36:01'),(4197,'2023-12-16 06:54:00','2023-12-16 15:30:00','12.249.250.150','12.249.250.150','closed',8,516,'attendances/2200/1702738480 clock_in.png','attendances/2200/1702769442 clock_out.png','Juan R',44137,NULL,'2023-12-16 11:54:40','2023-12-18 17:33:50'),(4198,'2023-12-16 06:54:00','2023-12-16 15:27:00','12.249.250.150','12.249.250.150','closed',8,513,'attendances/1450/1702738491 clock_in.png','attendances/1450/1702769233 clock_out.png','Juan R',44139,NULL,'2023-12-16 11:54:51','2023-12-18 17:43:18'),(4199,'2023-12-16 06:55:00','2023-12-16 14:15:00','12.249.250.150','12.249.250.150','closed',7,440,'attendances/2116/1702738528 clock_in.png','attendances/2116/1702764927 clock_out.png','Juan R',44136,NULL,'2023-12-16 11:55:28','2023-12-18 17:32:03'),(4201,'2023-12-16 07:17:00','2023-12-16 10:01:00','38.51.234.69','38.51.234.69','closed',2,164,NULL,NULL,'Juan R',44159,NULL,'2023-12-16 15:55:18','2023-12-18 17:43:00'),(4202,'2023-12-16 11:55:00','2023-12-16 20:44:00','12.249.250.150','12.249.250.150','closed',8,529,'attendances/2094/1702756549 clock_in.png','attendances/2094/1702788253 clock_out.png','Juan R',44147,NULL,'2023-12-16 16:55:49','2023-12-18 17:43:06'),(4203,'2023-12-16 12:21:00','2023-12-16 20:41:00','12.249.250.150','12.249.250.150','closed',8,500,'attendances/2179/1702758113 clock_in.png','attendances/2179/1702788105 clock_out.png','Juan R',44146,NULL,'2023-12-16 17:21:53','2023-12-18 17:44:58'),(4204,'2023-12-16 12:22:00','2023-12-16 20:41:00','12.249.250.150','12.249.250.150','closed',8,499,'attendances/2178/1702758123 clock_in.png','attendances/2178/1702788084 clock_out.png','Juan R',44140,NULL,'2023-12-16 17:22:03','2023-12-18 17:29:14'),(4205,'2023-12-16 12:25:00','2023-12-16 20:44:00','12.249.250.150','12.249.250.150','closed',8,499,'attendances/1666/1702758356 clock_in.png','attendances/1666/1702788274 clock_out.png','Juan R',44142,NULL,'2023-12-16 17:25:56','2023-12-18 17:36:54'),(4206,'2023-12-16 12:29:00','2023-12-16 20:43:00','12.249.250.150','12.249.250.150','closed',8,494,'attendances/2170/1702758584 clock_in.png','attendances/2170/1702788229 clock_out.png','Juan R',44144,NULL,'2023-12-16 17:29:44','2023-12-18 17:41:57'),(4207,'2023-12-16 12:33:00','2023-12-16 20:44:00','12.249.250.150','12.249.250.150','closed',8,491,'attendances/2218/1702758783 clock_in.png','attendances/2218/1702788274 clock_out.png','Juan R',44143,NULL,'2023-12-16 17:33:03','2023-12-18 17:37:06'),(4208,'2023-12-16 12:43:00','2023-12-16 20:43:00','12.249.250.150','12.249.250.150','closed',8,480,'attendances/2239/1702759407 clock_in.png','attendances/2239/1702788233 clock_out.png','Juan R',44141,NULL,'2023-12-16 17:43:27','2023-12-18 17:40:53'),(4209,'2023-12-16 12:43:00','2023-12-16 20:43:00','12.249.250.150','12.249.250.150','closed',8,480,'attendances/2058/1702759416 clock_in.png','attendances/2058/1702788201 clock_out.png','Juan R',44145,NULL,'2023-12-16 17:43:36','2023-12-18 17:43:11'),(4211,'2023-12-17 06:47:00','2023-12-17 12:25:00','12.249.250.150','12.249.250.150','closed',5,338,'attendances/1116/1702824440 clock_in.png','attendances/1116/1702844710 clock_out.png','Juan R',44156,NULL,'2023-12-17 11:47:20','2023-12-18 17:40:33'),(4212,'2023-12-17 06:50:00','2023-12-17 12:26:00','12.249.250.150','12.249.250.150','closed',5,336,'attendances/2150/1702824632 clock_in.png','attendances/2150/1702844782 clock_out.png','Juan R',44153,NULL,'2023-12-17 11:50:32','2023-12-18 17:29:01'),(4213,'2023-12-17 06:55:00','2023-12-17 15:23:00','12.249.250.150','190.89.30.156','closed',8,508,'attendances/1181/1702824916 clock_in.png','attendances/1181/1702825079 clock_out.png','Juan R',44157,NULL,'2023-12-17 11:55:16','2023-12-18 17:43:25'),(4214,'2023-12-17 06:56:00','2023-12-17 12:26:00','12.249.250.150','12.249.250.150','closed',5,330,'attendances/2236/1702824982 clock_in.png','attendances/2236/1702844763 clock_out.png','Juan R',44158,NULL,'2023-12-17 11:56:22','2023-12-18 17:44:24'),(4215,'2023-12-17 06:56:00','2023-12-17 12:24:00','12.249.250.150','12.249.250.150','closed',5,328,'attendances/2047/1702825014 clock_in.png','attendances/2047/1702844693 clock_out.png','Juan R',44154,NULL,'2023-12-17 11:56:54','2023-12-18 17:34:32'),(4216,'2023-12-17 06:57:00','2023-12-17 12:25:00','12.249.250.150','12.249.250.150','closed',5,328,'attendances/2061/1702825033 clock_in.png','attendances/2061/1702844749 clock_out.png','Juan R',44155,NULL,'2023-12-17 11:57:13','2023-12-18 17:38:54'),(4218,'2023-12-17 16:56:00','2023-12-17 20:21:00','190.89.30.156','12.249.250.150','closed',3,205,NULL,'attendances/1116/1702873284 clock_out.png','Juan R',44213,NULL,'2023-12-17 22:24:59','2023-12-18 17:40:33'),(4219,'2023-12-18 04:59:00','2023-12-18 17:15:00','12.249.250.150','12.249.250.150','closed',12,736,'attendances/2218/1702904356 clock_in.png','attendances/2218/1702948541 clock_out.png','Juan R',44193,NULL,'2023-12-18 09:59:16','2023-12-26 12:25:58'),(4220,'2023-12-18 04:59:00','2023-12-18 18:56:00','12.249.250.150','12.249.250.150','closed',13,837,'attendances/2222/1702904373 clock_in.png','attendances/2222/1702954566 clock_out.png','Juan R',44200,NULL,'2023-12-18 09:59:33','2023-12-26 12:32:25'),(4221,'2023-12-18 05:00:00','2023-12-18 16:32:00','12.249.250.150','12.249.250.150','closed',11,692,'attendances/1568/1702904405 clock_in.png','attendances/1568/1702945946 clock_out.png','Juan R',44203,NULL,'2023-12-18 10:00:05','2023-12-26 12:07:40'),(4222,'2023-12-18 05:01:00','2023-12-18 18:49:00','12.249.250.150','177.93.48.50','closed',13,828,'attendances/2235/1702904475 clock_in.png',NULL,'Juan R',44196,NULL,'2023-12-18 10:01:15','2023-12-26 12:31:29'),(4223,'2023-12-18 05:01:00','2023-12-18 16:03:00','12.249.250.150','12.249.250.150','closed',11,662,'attendances/2133/1702904495 clock_in.png','attendances/2133/1702944215 clock_out.png','Juan R',44205,NULL,'2023-12-18 10:01:35','2023-12-26 12:26:28'),(4224,'2023-12-18 05:08:00','2023-12-18 16:08:00','12.249.250.150','12.249.250.150','closed',11,660,'attendances/2236/1702904923 clock_in.png','attendances/2236/1702944500 clock_out.png','Juan R',44204,NULL,'2023-12-18 10:08:43','2023-12-26 12:32:36'),(4226,'2023-12-18 05:55:00','2023-12-18 15:38:00','12.249.250.150','12.249.250.150','closed',9,583,'attendances/1585/1702907717 clock_in.png','attendances/1585/1702942699 clock_out.png','Juan R',44186,NULL,'2023-12-18 10:55:17','2023-12-26 12:07:34'),(4227,'2023-12-18 05:55:00','2023-12-18 16:29:00','12.249.250.150','12.249.250.150','closed',10,634,'attendances/1774/1702907730 clock_in.png','attendances/1774/1702945792 clock_out.png','Juan R',44190,NULL,'2023-12-18 10:55:30','2023-12-26 12:23:49'),(4228,'2023-12-18 05:56:00','2023-12-18 16:29:00','12.249.250.150','12.249.250.150','closed',10,633,'attendances/622/1702907769 clock_in.png','attendances/622/1702945776 clock_out.png','Juan R',44202,NULL,'2023-12-18 10:56:09','2023-12-26 12:32:33'),(4229,'2023-12-18 05:56:00','2023-12-18 16:30:00','12.249.250.150','12.249.250.150','closed',10,634,'attendances/1934/1702907786 clock_in.png','attendances/1934/1702945807 clock_out.png','Juan R',44194,NULL,'2023-12-18 10:56:26','2023-12-26 12:26:07'),(4230,'2023-12-18 05:56:00','2023-12-18 18:50:00','12.249.250.150','12.249.250.150','closed',12,774,'attendances/2094/1702907803 clock_in.png','attendances/2094/1702954216 clock_out.png','Juan R',44197,NULL,'2023-12-18 10:56:43','2023-12-26 12:32:07'),(4231,'2023-12-18 05:58:00','2023-12-18 18:57:00','12.249.250.150','12.249.250.150','closed',12,779,'attendances/1551/1702907898 clock_in.png','attendances/1551/1702954679 clock_out.png','Juan R',44185,NULL,'2023-12-18 10:58:18','2023-12-26 11:51:35'),(4232,'2023-12-18 05:58:00','2023-12-18 18:50:00','12.249.250.150','177.93.48.50','closed',12,772,'attendances/2233/1702907915 clock_in.png',NULL,'Juan R',44201,NULL,'2023-12-18 10:58:35','2023-12-26 12:32:28'),(4233,'2023-12-18 05:59:00','2023-12-18 15:31:00','12.249.250.150','12.249.250.150','closed',9,572,'attendances/2168/1702907956 clock_in.png','attendances/2168/1702942268 clock_out.png','Juan R',44191,NULL,'2023-12-18 10:59:16','2023-12-26 12:25:21'),(4235,'2023-12-18 05:59:00','2023-12-18 15:32:00','12.249.250.150','12.249.250.150','closed',9,573,'attendances/1744/1702907991 clock_in.png','attendances/1744/1702942324 clock_out.png','Juan R',44195,NULL,'2023-12-18 10:59:51','2023-12-26 12:31:24'),(4236,'2023-12-18 06:00:00','2023-12-18 18:52:00','12.249.250.150','12.249.250.150','closed',12,772,'attendances/1450/1702908006 clock_in.png','attendances/1450/1702954361 clock_out.png','Juan R',44199,NULL,'2023-12-18 11:00:06','2023-12-26 12:32:17'),(4237,'2023-12-18 06:00:00','2023-12-18 16:04:00','12.249.250.150','12.249.250.150','closed',10,604,'attendances/2141/1702908018 clock_in.png','attendances/2141/1702944243 clock_out.png','Juan R',44188,NULL,'2023-12-18 11:00:18','2023-12-26 12:25:15'),(4238,'2023-12-18 06:02:00','2023-12-18 16:03:00','12.249.250.150','12.249.250.150','closed',10,601,'attendances/2058/1702908174 clock_in.png','attendances/2058/1702944231 clock_out.png','Juan R',44198,NULL,'2023-12-18 11:02:54','2023-12-26 12:32:10'),(4239,'2023-12-18 06:03:00','2023-12-18 15:42:00','12.249.250.150','12.249.250.150','closed',9,579,'attendances/2195/1702908206 clock_in.png','attendances/2195/1702942920 clock_out.png','Juan R',44189,NULL,'2023-12-18 11:03:26','2023-12-26 12:23:44'),(4240,'2023-12-18 06:05:00','2023-12-18 15:38:00','12.249.250.150','12.249.250.150','closed',9,573,'attendances/2169/1702908304 clock_in.png','attendances/2169/1702942680 clock_out.png','Juan R',44187,NULL,'2023-12-18 11:05:04','2023-12-26 12:08:00'),(4241,'2023-12-18 06:06:00','2023-12-18 18:51:00','12.249.250.150','12.249.250.150','closed',12,765,'attendances/1666/1702908411 clock_in.png','attendances/1666/1702954276 clock_out.png','Juan R',44192,NULL,'2023-12-18 11:06:51','2023-12-26 12:25:44'),(4242,'2023-12-18 06:50:00','2023-12-18 17:28:00','12.249.250.150','12.249.250.150','closed',10,638,'attendances/2178/1702911021 clock_in.png','attendances/2178/1702949329 clock_out.png','Juan R',44165,NULL,'2023-12-18 11:50:21','2023-12-26 12:07:31'),(4243,'2023-12-18 06:50:00','2023-12-18 17:29:00','12.249.250.150','12.249.250.150','closed',10,639,'attendances/2179/1702911035 clock_in.png','attendances/2179/1702949342 clock_out.png','Juan R',44182,NULL,'2023-12-18 11:50:35','2023-12-26 12:32:53'),(4244,'2023-12-18 06:51:00','2023-12-18 15:35:00','12.249.250.150','12.249.250.150','closed',8,524,'attendances/1116/1702911062 clock_in.png','attendances/1116/1702942525 clock_out.png','Juan R',44175,NULL,'2023-12-18 11:51:02','2023-12-26 12:30:04'),(4245,'2023-12-18 06:52:00','2023-12-18 15:47:00','12.249.250.150','12.249.250.150','closed',8,535,'attendances/2234/1702911166 clock_in.png','attendances/2234/1702943268 clock_out.png','Juan R',44180,NULL,'2023-12-18 11:52:46','2023-12-26 12:32:20'),(4246,'2023-12-18 06:53:00','2023-12-18 15:46:00','12.249.250.150','12.249.250.150','closed',8,533,'attendances/2116/1702911192 clock_in.png','attendances/2116/1702943199 clock_out.png','Juan R',44166,NULL,'2023-12-18 11:53:12','2023-12-26 12:07:52'),(4247,'2023-12-18 06:54:00','2023-12-18 15:53:00','12.249.250.150','12.249.250.150','closed',8,539,'attendances/2008/1702911265 clock_in.png','attendances/2008/1702943588 clock_out.png','Juan R',44171,NULL,'2023-12-18 11:54:25','2023-12-26 12:25:40'),(4248,'2023-12-18 06:54:00','2023-12-18 15:47:00','12.249.250.150','12.249.250.150','closed',8,533,'attendances/2061/1702911274 clock_in.png','attendances/2061/1702943270 clock_out.png','Juan R',44173,NULL,'2023-12-18 11:54:34','2023-12-26 12:26:02'),(4249,'2023-12-18 06:54:00','2023-12-18 15:47:00','12.249.250.150','12.249.250.150','closed',8,533,'attendances/2047/1702911285 clock_in.png','attendances/2047/1702943261 clock_out.png','Juan R',44170,NULL,'2023-12-18 11:54:45','2023-12-26 12:25:28'),(4250,'2023-12-18 06:54:00','2023-12-18 16:14:00','12.249.250.150','12.249.250.150','closed',9,560,'attendances/2200/1702911296 clock_in.png','attendances/2200/1702944845 clock_out.png','Juan R',44168,NULL,'2023-12-18 11:54:56','2023-12-26 12:23:36'),(4251,'2023-12-18 06:55:00','2023-12-18 15:50:00','12.249.250.150','12.249.250.150','closed',8,535,'attendances/1479/1702911308 clock_in.png','attendances/1479/1702943457 clock_out.png','Juan R',44167,NULL,'2023-12-18 11:55:08','2023-12-26 12:07:56'),(4252,'2023-12-18 06:55:00','2023-12-18 15:51:00','12.249.250.150','12.249.250.150','closed',8,536,'attendances/1749/1702911328 clock_in.png','attendances/1749/1702943475 clock_out.png','Juan R',44177,NULL,'2023-12-18 11:55:28','2023-12-26 12:31:35'),(4253,'2023-12-18 06:55:00','2023-12-18 15:58:00','12.249.250.150','12.249.250.150','closed',9,543,'attendances/2230/1702911333 clock_in.png','attendances/2230/1702943898 clock_out.png','Juan R',44215,NULL,'2023-12-18 11:55:33','2023-12-26 12:32:40'),(4254,'2023-12-18 06:55:00','2023-12-18 15:56:00','12.249.250.150','12.249.250.150','closed',9,541,'attendances/1395/1702911352 clock_in.png','attendances/1395/1702943778 clock_out.png','Juan R',44176,NULL,'2023-12-18 11:55:52','2023-12-26 12:31:27'),(4255,'2023-12-18 06:55:00','2023-12-18 15:36:00','12.249.250.150','12.249.250.150','closed',8,521,'attendances/1858/1702911354 clock_in.png','attendances/1858/1702942572 clock_out.png','Juan R',44174,NULL,'2023-12-18 11:55:54','2023-12-26 12:26:12'),(4256,'2023-12-18 06:56:00','2023-12-18 15:59:00','12.249.250.150','12.249.250.150','closed',9,543,'attendances/1999/1702911394 clock_in.png','attendances/1999/1702943949 clock_out.png','Juan R',44172,NULL,'2023-12-18 11:56:34','2023-12-26 12:25:51'),(4257,'2023-12-18 06:58:00','2023-12-18 15:34:00','12.249.250.150','177.93.48.50','closed',8,516,'attendances/1958/1702911484 clock_in.png','attendances/1958/1702929912 clock_out.png','Juan R',44169,NULL,'2023-12-18 11:58:04','2023-12-26 12:25:25'),(4258,'2023-12-18 06:59:00','2023-12-18 15:49:00','12.249.250.150','12.249.250.150','closed',8,530,'attendances/1181/1702911572 clock_in.png','attendances/1181/1702943379 clock_out.png','Juan R',44181,NULL,'2023-12-18 11:59:32','2023-12-26 12:32:23'),(4259,'2023-12-18 07:00:00','2023-12-18 15:40:00','12.249.250.150','12.249.250.150','closed',8,520,'attendances/1948/1702911611 clock_in.png','attendances/1948/1702942816 clock_out.png','Juan R',44179,NULL,'2023-12-18 12:00:11','2023-12-26 12:31:54'),(4260,'2023-12-18 07:00:00','2023-12-18 16:05:00','12.249.250.150','12.249.250.150','closed',9,545,'attendances/2170/1702911643 clock_in.png','attendances/2170/1702944303 clock_out.png','Juan R',44178,NULL,'2023-12-18 12:00:43','2023-12-26 12:31:42'),(4261,'2023-12-18 07:10:00','2023-12-18 15:36:00','12.249.250.150','12.249.250.150','closed',8,506,'attendances/1888/1702912250 clock_in.png','attendances/1888/1702942609 clock_out.png','Juan R',44183,NULL,'2023-12-18 12:10:50','2023-12-26 12:33:02'),(4262,'2023-12-18 07:00:00','2023-12-18 15:32:00','186.154.237.158','12.249.250.150','closed',8,512,NULL,'attendances/726/1702942327 clock_out.png','Juan R',44164,NULL,'2023-12-18 12:16:55','2023-12-26 11:50:51'),(4263,'2023-12-18 07:36:00','2023-12-18 16:31:00','12.249.250.150','12.249.250.150','closed',8,535,'attendances/775/1702913800 clock_in.png','attendances/775/1702945902 clock_out.png','Juan R',44208,NULL,'2023-12-18 12:36:40','2023-12-26 12:31:40'),(4264,'2023-12-18 07:50:00','2023-12-18 15:38:00','12.249.250.150','12.249.250.150','closed',7,468,'attendances/1462/1702914643 clock_in.png','attendances/1462/1702942733 clock_out.png','Juan R',44207,NULL,'2023-12-18 12:50:43','2023-12-26 12:25:54'),(4265,'2023-12-18 07:59:00','2023-12-18 16:34:00','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1869/1702915198 clock_in.png','attendances/1869/1702946071 clock_out.png','Juan R',44206,NULL,'2023-12-18 12:59:58','2023-12-26 12:07:46'),(4266,'2023-12-18 08:01:00','2023-12-18 16:34:00','12.249.250.150','12.249.250.150','closed',8,513,'attendances/1891/1702915293 clock_in.png','attendances/1891/1702946063 clock_out.png','Juan R',44209,NULL,'2023-12-18 13:01:33','2023-12-26 12:31:51'),(4270,'2023-12-19 05:54:00','2023-12-19 15:40:00','12.249.250.150','12.249.250.150','closed',9,586,'attendances/2179/1702994054 clock_in.png','attendances/2179/1703029214 clock_out.png','Juan R',44283,NULL,'2023-12-19 10:54:18','2023-12-26 12:32:53'),(4271,'2023-12-19 05:54:00','2023-12-19 16:28:00','12.249.250.150','12.249.250.150','closed',10,634,'attendances/622/1702994093 clock_in.png','attendances/622/1703032117 clock_out.png','Juan R',44282,NULL,'2023-12-19 10:54:53','2023-12-26 12:32:33'),(4272,'2023-12-19 05:55:00','2023-12-19 16:29:00','12.249.250.150','12.249.250.150','closed',10,634,'attendances/1774/1702994108 clock_in.png','attendances/1774/1703032143 clock_out.png','Juan R',44270,NULL,'2023-12-19 10:55:08','2023-12-26 12:23:49'),(4273,'2023-12-19 05:56:00','2023-12-19 16:30:00','12.249.250.150','12.249.250.150','closed',10,634,'attendances/1934/1702994165 clock_in.png','attendances/1934/1703032219 clock_out.png','Juan R',44274,NULL,'2023-12-19 10:56:05','2023-12-26 12:26:07'),(4274,'2023-12-19 05:57:00','2023-12-19 15:32:00','12.249.250.150','12.249.250.150','closed',9,575,'attendances/1568/1702994228 clock_in.png','attendances/1568/1703028773 clock_out.png','Juan R',44266,NULL,'2023-12-19 10:57:08','2023-12-26 12:07:40'),(4275,'2023-12-19 05:57:00','2023-12-19 17:04:00','12.249.250.150','12.249.250.150','closed',11,667,'attendances/726/1702994232 clock_in.png','attendances/726/1703034297 clock_out.png','Juan R',44262,NULL,'2023-12-19 10:57:12','2023-12-26 11:50:51'),(4276,'2023-12-19 05:57:00','2023-12-19 17:59:00','12.249.250.150','12.249.250.150','closed',12,722,'attendances/1551/1702994263 clock_in.png','attendances/1551/1703037593 clock_out.png','Juan R',44264,NULL,'2023-12-19 10:57:43','2023-12-26 11:51:35'),(4277,'2023-12-19 05:57:00','2023-12-19 15:32:00','12.249.250.150','12.249.250.150','closed',9,575,'attendances/2236/1702994269 clock_in.png','attendances/2236/1703028724 clock_out.png','Juan R',44267,NULL,'2023-12-19 10:57:49','2023-12-26 12:32:36'),(4278,'2023-12-19 05:57:00','2023-12-19 17:06:00','12.249.250.150','12.249.250.150','closed',11,669,'attendances/2141/1702994278 clock_in.png','attendances/2141/1703034407 clock_out.png','Juan R',44268,NULL,'2023-12-19 10:57:58','2023-12-26 12:25:15'),(4280,'2023-12-19 05:58:00','2023-12-19 19:01:00','12.249.250.150','177.93.48.50','closed',13,783,'attendances/2230/1702994327 clock_in.png',NULL,'Juan R',44269,NULL,'2023-12-19 10:58:47','2023-12-26 12:32:40'),(4281,'2023-12-19 05:58:00','2023-12-19 16:30:00','12.249.250.150','12.249.250.150','closed',10,632,'attendances/1744/1702994337 clock_in.png','attendances/1744/1703032206 clock_out.png','Juan R',44276,NULL,'2023-12-19 10:58:57','2023-12-26 12:31:24'),(4282,'2023-12-19 05:59:00','2023-12-19 15:39:00','12.249.250.150','12.249.250.150','closed',9,580,'attendances/2178/1702994343 clock_in.png','attendances/2178/1703029199 clock_out.png','Juan R',44265,NULL,'2023-12-19 10:59:03','2023-12-26 12:07:31'),(4283,'2023-12-19 05:59:00','2023-12-19 17:03:00','12.249.250.150','12.249.250.150','closed',11,664,'attendances/2233/1702994395 clock_in.png','attendances/2233/1703034234 clock_out.png','Juan R',44281,NULL,'2023-12-19 10:59:55','2023-12-26 12:32:28'),(4284,'2023-12-19 06:01:00','2023-12-19 17:58:00','12.249.250.150','12.249.250.150','closed',11,717,'attendances/2222/1702994469 clock_in.png','attendances/2222/1703037530 clock_out.png','Juan R',44280,NULL,'2023-12-19 11:01:09','2023-12-26 12:32:25'),(4285,'2023-12-19 06:01:00','2023-12-19 17:06:00','12.249.250.150','12.249.250.150','closed',11,665,'attendances/2218/1702994476 clock_in.png','attendances/2218/1703034369 clock_out.png','Juan R',44273,NULL,'2023-12-19 11:01:16','2023-12-26 12:25:58'),(4286,'2023-12-19 06:01:00','2023-12-19 17:58:00','12.249.250.150','12.249.250.150','closed',11,717,'attendances/2235/1702994518 clock_in.png','attendances/2235/1703037503 clock_out.png','Juan R',44277,NULL,'2023-12-19 11:01:58','2023-12-26 12:31:29'),(4287,'2023-12-19 06:04:00','2023-12-19 18:00:00','12.249.250.150','12.249.250.150','closed',11,716,'attendances/2094/1702994643 clock_in.png','attendances/2094/1703037623 clock_out.png','Juan R',44278,NULL,'2023-12-19 11:04:03','2023-12-26 12:32:07'),(4288,'2023-12-19 06:04:00','2023-12-19 17:06:00','12.249.250.150','12.249.250.150','closed',11,662,'attendances/2058/1702994685 clock_in.png','attendances/2058/1703034394 clock_out.png','Juan R',44279,NULL,'2023-12-19 11:04:45','2023-12-26 12:32:10'),(4289,'2023-12-19 06:05:00','2023-12-19 16:29:00','12.249.250.150','12.249.250.150','closed',10,624,'attendances/2168/1702994750 clock_in.png','attendances/2168/1703032173 clock_out.png','Juan R',44271,NULL,'2023-12-19 11:05:50','2023-12-26 12:25:21'),(4290,'2023-12-19 06:06:00','2023-12-19 15:31:00','12.249.250.150','12.249.250.150','closed',9,565,'attendances/2133/1702994793 clock_in.png','attendances/2133/1703028705 clock_out.png','Juan R',44275,NULL,'2023-12-19 11:06:33','2023-12-26 12:26:28'),(4291,'2023-12-19 06:07:00','2023-12-19 16:29:00','12.249.250.150','12.249.250.150','closed',10,622,'attendances/2150/1702994823 clock_in.png','attendances/2150/1703032160 clock_out.png','Juan R',44263,NULL,'2023-12-19 11:07:03','2023-12-26 12:07:26'),(4292,'2023-12-19 06:08:00','2023-12-19 17:04:00','12.249.250.150','12.249.250.150','closed',10,656,'attendances/1666/1702994935 clock_in.png','attendances/1666/1703034257 clock_out.png','Juan R',44272,NULL,'2023-12-19 11:08:55','2023-12-26 12:25:44'),(4293,'2023-12-19 06:23:00','2023-12-19 17:17:00','12.249.250.150','12.249.250.150','closed',10,654,'attendances/2169/1702995801 clock_in.png','attendances/2169/1703035023 clock_out.png','Juan R',44285,NULL,'2023-12-19 11:23:21','2023-12-26 12:08:00'),(4294,'2023-12-19 06:26:00','2023-12-19 17:13:00','12.249.250.150','12.249.250.150','closed',10,647,'attendances/1585/1702995991 clock_in.png','attendances/1585/1703034809 clock_out.png','Juan R',44284,NULL,'2023-12-19 11:26:31','2023-12-26 12:07:34'),(4295,'2023-12-19 06:31:00','2023-12-19 17:13:00','12.249.250.150','12.249.250.150','closed',10,642,'attendances/2170/1702996282 clock_in.png','attendances/2170/1703034822 clock_out.png','Juan R',44286,NULL,'2023-12-19 11:31:22','2023-12-26 12:31:42'),(4296,'2023-12-19 06:44:00','2023-12-19 15:50:00','12.249.250.150','12.249.250.150','closed',9,546,'attendances/2239/1702997071 clock_in.png','attendances/2239/1703029805 clock_out.png','Juan R',44299,NULL,'2023-12-19 11:44:31','2023-12-26 12:31:32'),(4297,'2023-12-19 06:51:00','2023-12-19 15:45:00','12.249.250.150','12.249.250.150','closed',8,534,'attendances/1116/1702997489 clock_in.png','attendances/1116/1703029517 clock_out.png','Juan R',44297,NULL,'2023-12-19 11:51:29','2023-12-26 12:30:04'),(4298,'2023-12-19 06:53:00','2023-12-19 16:25:00','12.249.250.150','12.249.250.150','closed',9,572,'attendances/2234/1702997581 clock_in.png','attendances/2234/1703031947 clock_out.png','Juan R',44303,NULL,'2023-12-19 11:53:01','2023-12-26 12:32:20'),(4299,'2023-12-19 06:53:00','2023-12-19 13:35:00','12.249.250.150','12.249.250.150','closed',6,402,'attendances/1999/1702997628 clock_in.png','attendances/1999/1703021727 clock_out.png','Juan R',44293,NULL,'2023-12-19 11:53:48','2023-12-26 12:25:51'),(4300,'2023-12-19 06:54:00','2023-12-19 16:49:00','12.249.250.150','12.249.250.150','closed',9,595,'attendances/2061/1702997658 clock_in.png','attendances/2061/1703033363 clock_out.png','Juan R',44295,NULL,'2023-12-19 11:54:18','2023-12-26 12:26:02'),(4301,'2023-12-19 06:54:00','2023-12-19 16:49:00','12.249.250.150','12.249.250.150','closed',9,595,'attendances/2047/1702997673 clock_in.png','attendances/2047/1703033379 clock_out.png','Juan R',44291,NULL,'2023-12-19 11:54:33','2023-12-26 12:25:28'),(4302,'2023-12-19 06:54:00','2023-12-19 16:13:00','12.249.250.150','12.249.250.150','closed',9,559,'attendances/1749/1702997695 clock_in.png','attendances/1749/1703031238 clock_out.png','Juan R',44300,NULL,'2023-12-19 11:54:55','2023-12-26 12:31:35'),(4303,'2023-12-19 06:55:00','2023-12-19 16:02:00','12.249.250.150','12.249.250.150','closed',9,547,'attendances/1479/1702997700 clock_in.png','attendances/1479/1703030552 clock_out.png','Juan R',44288,NULL,'2023-12-19 11:55:00','2023-12-26 12:07:56'),(4304,'2023-12-19 06:55:00','2023-12-19 16:02:00','12.249.250.150','12.249.250.150','closed',9,547,'attendances/2008/1702997758 clock_in.png','attendances/2008/1703030561 clock_out.png','Juan R',44292,NULL,'2023-12-19 11:55:58','2023-12-26 12:25:40'),(4305,'2023-12-19 06:56:00','2023-12-19 16:52:00','12.249.250.150','12.249.250.150','closed',9,596,'attendances/2116/1702997775 clock_in.png','attendances/2116/1703033578 clock_out.png','Juan R',44287,NULL,'2023-12-19 11:56:15','2023-12-26 12:07:52'),(4306,'2023-12-19 06:57:00','2023-12-19 16:03:00','12.249.250.150','12.249.250.150','closed',9,546,'attendances/2200/1702997823 clock_in.png','attendances/2200/1703030605 clock_out.png','Juan R',44289,NULL,'2023-12-19 11:57:03','2023-12-26 12:23:36'),(4307,'2023-12-19 06:57:00','2023-12-19 16:22:00','12.249.250.150','12.249.250.150','closed',9,565,'attendances/1395/1702997840 clock_in.png','attendances/1395/1703031740 clock_out.png','Juan R',44298,NULL,'2023-12-19 11:57:20','2023-12-26 12:31:27'),(4308,'2023-12-19 06:57:00','2023-12-19 15:34:00','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1958/1702997852 clock_in.png','attendances/1958/1703028863 clock_out.png','Juan R',44290,NULL,'2023-12-19 11:57:32','2023-12-26 12:25:25'),(4309,'2023-12-19 06:57:00','2023-12-19 15:34:00','12.249.250.150','12.249.250.150','closed',8,517,'attendances/1858/1702997865 clock_in.png','attendances/1858/1703028852 clock_out.png','Juan R',44296,NULL,'2023-12-19 11:57:45','2023-12-26 12:26:12'),(4310,'2023-12-19 07:00:00','2023-12-19 15:41:00','12.249.250.150','12.249.250.150','closed',8,521,'attendances/1948/1702998010 clock_in.png','attendances/1948/1703029287 clock_out.png','Juan R',44301,NULL,'2023-12-19 12:00:10','2023-12-26 12:31:54'),(4311,'2023-12-19 07:00:00','2023-12-19 16:54:00','12.249.250.150','12.249.250.150','closed',9,594,'attendances/1450/1702998019 clock_in.png','attendances/1450/1703033661 clock_out.png','Juan R',44302,NULL,'2023-12-19 12:00:19','2023-12-26 12:32:17'),(4312,'2023-12-19 07:02:00','2023-12-19 15:38:00','12.249.250.150','12.249.250.150','closed',8,516,'attendances/1462/1702998135 clock_in.png','attendances/1462/1703029084 clock_out.png','Juan R',44294,NULL,'2023-12-19 12:02:15','2023-12-26 12:25:54'),(4313,'2023-12-19 07:09:00','2023-12-19 15:42:00','12.249.250.150','12.249.250.150','closed',8,513,'attendances/1888/1702998576 clock_in.png','attendances/1888/1703029356 clock_out.png','Juan R',44304,NULL,'2023-12-19 12:09:36','2023-12-26 12:33:02'),(4314,'2023-12-19 07:57:00','2023-12-19 16:30:00','12.249.250.150','12.249.250.150','closed',8,513,'attendances/775/1703001453 clock_in.png','attendances/775/1703032247 clock_out.png','Juan R',44306,NULL,'2023-12-19 12:57:33','2023-12-26 12:31:40'),(4315,'2023-12-19 08:00:00','2023-12-19 16:32:00','12.249.250.150','12.249.250.150','closed',8,512,'attendances/1869/1703001652 clock_in.png','attendances/1869/1703032372 clock_out.png','Juan R',44305,NULL,'2023-12-19 13:00:52','2023-12-26 12:07:46'),(4316,'2023-12-19 08:03:00','2023-12-19 16:38:00','12.249.250.150','12.249.250.150','closed',8,515,'attendances/1891/1703001782 clock_in.png','attendances/1891/1703032721 clock_out.png','Juan R',44307,NULL,'2023-12-19 13:03:02','2023-12-26 12:31:51'),(4319,'2023-12-18 06:00:00','2023-12-18 15:32:00','190.89.30.156','190.89.30.156','closed',9,572,NULL,NULL,'Juan R',44184,NULL,'2023-12-19 22:54:49','2023-12-26 12:07:26'),(4320,'2023-12-20 05:54:00','2023-12-20 13:08:00','12.249.250.150','12.249.250.150','closed',7,434,'attendances/726/1703080454 clock_in.png','attendances/726/1703106509 clock_out.png','Juan R',44351,NULL,'2023-12-20 10:54:14','2023-12-26 11:50:51'),(4321,'2023-12-20 05:55:00','2023-12-20 14:39:00','12.249.250.150','12.249.250.150','closed',8,524,'attendances/2094/1703080539 clock_in.png','attendances/2094/1703111997 clock_out.png','Juan R',44365,NULL,'2023-12-20 10:55:39','2023-12-26 12:32:07'),(4322,'2023-12-20 05:55:00','2023-12-20 15:26:00','12.249.250.150','12.249.250.150','closed',9,571,'attendances/2047/1703080555 clock_in.png','attendances/2047/1703114764 clock_out.png','Juan R',44356,NULL,'2023-12-20 10:55:55','2023-12-26 12:25:28'),(4323,'2023-12-20 05:56:00','2023-12-20 15:22:00','12.249.250.150','12.249.250.150','closed',9,566,'attendances/1551/1703080568 clock_in.png','attendances/1551/1703114577 clock_out.png','Juan R',44353,NULL,'2023-12-20 10:56:08','2023-12-26 11:51:35'),(4324,'2023-12-20 05:56:00','2023-12-20 15:22:00','12.249.250.150','190.89.30.156','closed',9,566,'attendances/1181/1703080583 clock_in.png',NULL,'Juan R',44368,NULL,'2023-12-20 10:56:23','2023-12-26 12:32:23'),(4325,'2023-12-20 05:56:00','2023-12-20 16:29:00','12.249.250.150','12.249.250.150','closed',10,633,'attendances/622/1703080611 clock_in.png','attendances/622/1703118547 clock_out.png','Juan R',44370,NULL,'2023-12-20 10:56:51','2023-12-26 12:32:33'),(4326,'2023-12-20 05:57:00','2023-12-20 16:01:00','12.249.250.150','12.249.250.150','closed',10,604,'attendances/1479/1703080621 clock_in.png','attendances/1479/1703116878 clock_out.png','Juan R',44355,NULL,'2023-12-20 10:57:01','2023-12-26 12:07:56'),(4327,'2023-12-20 05:57:00','2023-12-20 16:30:00','12.249.250.150','12.249.250.150','closed',10,633,'attendances/1934/1703080623 clock_in.png','attendances/1934/1703118610 clock_out.png','Juan R',44361,NULL,'2023-12-20 10:57:03','2023-12-26 12:26:07'),(432